/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "show_info.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "populate_server_settings.h"
#include "commented.h"
#include "functions.h"
#include "get_option_pos.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];

extern int use_tls;


void populate_server_settings(struct w *widgets)
{
    /* Lists the values for the selected server in the server tab */
    FILE *fp;
    int x=0, val=0, once=0, vhost_found = 0;
    long file_size = 0, old_pos = 0, opt_pos = 0;
    char *line, *tmp, *new_buffer;
    gchar *info, *utf8 = NULL;
    gchar *address_line, *name_line;


    /* Clear all entries.
       We dont want the standard server to propagate to
       some vhost when the user havnt requested it. */
    for(x=0; x<13; x++)
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[x]), "");

    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        /* We just show this popup here too many windows looks bad */
        info = g_strdup_printf("%s %s", _("Error: Cant open the apache httpd configuration here:\n"), HTTPD_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    new_buffer = allocate(file_size);               


/* ------------ If server type is vhost, scroll to the correct one ----------- */
    if( strstr("Virtualhost", (char *)global_server_type) )
    {
        /* Setup the address:port and ServerName lines to identify the server with */
        address_line = g_strdup_printf("<VirtualHost %s:%s>\n", global_server_address, global_server_port);
        name_line    = g_strdup_printf("ServerName %s\n", global_server_name);

        /* Scan for the vhost address and server name */
        if( file_size > 1 )
        while(fgets(line, file_size, fp)!=NULL)
        {
            if( commented(line) )
                continue;
        
            opt_pos = get_option_pos(line, 0);
            snprintf(new_buffer, 1000, "%s", &line[opt_pos]);

            if( ! strcmp(new_buffer, address_line) )
            {
                /* Matching vhost line, save its position */
                old_pos = ftell(fp);
                old_pos = old_pos-strlen(line); /* Scroll back one line */

                while(fgets(line, file_size, fp)!=NULL)
                {
                    if( commented(line) )
                      continue;

                    opt_pos = get_option_pos(line, 0);
                    snprintf(new_buffer, 1000, "%s", &line[opt_pos]);

                    /* If the vhost has no ServerName then its found */
                    if( strlen((char *)global_server_name) < 5
                    &&  cmplowercase((char *)global_server_name, "none") )
                    {
                        vhost_found = 1;
                        break;
                    }

                    /* Its also got a matching ServerName ... */
                    if( ! strcmp(new_buffer, name_line) )
                    {
                        /* IE: ServerName www.example.org found */
                        vhost_found = 1;
                        break;		        
                    }
                    if( cmplowercase(line, "</virtualhost") )
                        break;
                }
                if( vhost_found )
                    break;
            }
        }
        g_free(address_line);
        g_free(name_line);
    }


    /* Vhost selected but not found. */
    if( ! vhost_found && strstr("Virtualhost", (char *)global_server_type) )
    {
        fclose(fp);
        free(line);
        free(new_buffer);
        return;
    }


    /* Standard server selected, scroll to the beginning */
    if( ! vhost_found )
        rewind(fp);
    else /* Scroll back to the vhost we found */
        fseek(fp, old_pos, SEEK_SET);

    /* Populate the selected servers settings */
    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( commented(line) )
            continue;

	    /* We arent looking for vhost data, skip this vhost */
	    if( ! vhost_found && cmplowercase(line, "<virtualhost") )
	      while(fgets(line, file_size, fp)!=NULL)
	        if( cmplowercase(line, "</virtualhost") && ! commented(line) )
	          break;

        if( commented(line) )
          continue;

        if( commented(line) )
          continue;


        /* Server name */	
        if( cmplowercase(line, "servername ") )
        {
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

            for(x=0; new_buffer[x]!='\0'; x++)
            if( new_buffer[x]==':' || new_buffer[x]=='\n' )
            {
                new_buffer[x]='\0';
                break;
            }
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
        }

        /* Vhost address and port */
        if( cmplowercase(line, "<virtualhost ") )
        {
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

            tmp = allocate(1024);
            for(x=0; new_buffer[x]!='\0'; x++)
            {
                if( new_buffer[x]==':' || new_buffer[x]=='\n' )
                {
            	    snprintf(tmp, 1000, "%s", &new_buffer[x+1]);
                    new_buffer[x]='\0';
                    break;
                }
            }
            if( tmp[strlen(tmp)-1]=='\n' )
                tmp[strlen(tmp)-1]='\0';
            /* Cut the last '>' char */
            if( tmp[strlen(tmp)-1]=='>' )
                tmp[strlen(tmp)-1]='\0';

            /* Server address */
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);

            /* Server port */
            if( chars_are_digits(tmp) )
            {
                val = atoi(tmp);
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), val);
            }
            else
              printf("Port isnt digits %s\n", tmp);

            free(tmp);
        }

        /* Standard server address and port */
        if( cmplowercase(line, "listen ") && ! once )
        {
            once = 1;

            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

            /* The syntax here should be address:port */
            if( cmplowercase(line, ":") && cmplowercase(line, ".") )
            {
                /* Cut away the port ":2468" */
                for(x=0; new_buffer[x]!='\0'; x++)
                      if( new_buffer[x]==':' )
                	    break;
                new_buffer[x]='\0';
            }
            else
            {   /* The syntax here is Listen PORT.
                   Address is always 0.0.0.0 then */
                snprintf(new_buffer, 1024, "%s", "0.0.0.0");
            }

            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

            /* Insert the address */
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);


            /* Insert the server port... */
            if( cmplowercase(line, ":") && cmplowercase(line, ".") )
            {
                /* Scroll to the server port */
                for(x=0; line[x]!='\0'; x++)
                      if( line[x]==':' )
	                    break;
	                x++;
            }

            for(x=x; line[x]!='\0'; x++)
              if( line[x]!=' ' )
                break;

            snprintf(new_buffer, 1024, "%s", &line[x]);

            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

            /* Insert the port */
            if( chars_are_digits(new_buffer) )
            {
                val = atoi(new_buffer);
                /* If its 0 it means the Listen Directive has no port: "Listen 0.0.0.0" */
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), val);
            }
            else
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), 80);
        }

        /* ServerSignature (show server identity) */	
        if( cmplowercase(line, "serversignature") )
        {
            if( cmplowercase(line, "on") )
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
            else
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 1);
        }

        /* Admin email */
        if( cmplowercase(line, "serveradmin") )
        {   
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), utf8);
        }

        if( cmplowercase(line, "hostnamelookups") )
        {
            if( cmplowercase(line, "on") )
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
            else
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 1);
        }

        if( cmplowercase(line, "usecanonicalname") )
        {
            /* There must be a space because it contains "on" */
            if( cmplowercase(line, " on") )
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 0);
            else
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 1);
        }

        /* Timeout (Connection timeout) */
        if( cmplowercase(line, "timeout") && ! cmplowercase(line, "keepalivetimeout") )
        {
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            new_buffer[strlen(new_buffer)-1]='\0';

            if( chars_are_digits(new_buffer) )
            {
            	val = atoi(new_buffer);
            	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[1]), val);
            }
        }

        /* Allow keepalive requests */
        if( cmplowercase(line, "keepalive ") && ! cmplowercase(line, "nokeepalive") )
        {
            if( cmplowercase(line, "on") )
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 0);
            else
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 1);
        }

        /* MaxKeepAliveRequests */
        if( cmplowercase(line, "maxkeepaliverequests ") )
        {
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            new_buffer[strlen(new_buffer)-1]='\0';

            if( chars_are_digits(new_buffer) )
            {
            	val = atoi(new_buffer);
            	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[2]), val);
            }
        }

        /* KeepAliveTimeout */
        if( cmplowercase(line, "keepalivetimeout ") )
        {
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            new_buffer[strlen(new_buffer)-1]='\0';

            if( chars_are_digits(new_buffer) )
            {
                val = atoi(new_buffer);
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[3]), val);
            }
        }

        /* Server user */
        if( cmplowercase(line, "user ") )
        {   
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[3]), utf8);
        }

        /* Server group */
        if( cmplowercase(line, "group ") )
        {   
            opt_pos = get_option_pos(line, 1);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[4]), utf8);
        }

        /* ServerTokens */
        if( cmplowercase(line, "servertokens ") )
        {
            if( cmplowercase(line, "os") ) // Fixme, more tokens...
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 0);
            else
              gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 1);
        }

        /* Document root */
        if( cmplowercase(line, "documentroot ") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
              
            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[5]), utf8);
        }

        /* Server root */
        if( cmplowercase(line, "serverroot ") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
              
            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[6]), utf8);
        }

        /* Directory index */
        if( cmplowercase(line, "directoryindex ") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
              
            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[7]), utf8);
        }

        /* Default type */
        if( cmplowercase(line, "defaulttype ") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
              
            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[8]), utf8);
        }

        /* Access filename */
        if( cmplowercase(line, "accessfilename ") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
              
            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[9]), utf8);
        }

        /* Default language */
        if( cmplowercase(line, "defaultlanguage ") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[10]), utf8);
        }

        /* Language priority */
        if( cmplowercase(line, "languagepriority ")
        && ! cmplowercase(line, "forcelanguagepriority") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
              
            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[11]), utf8);
        }

        /* Add default charset */
        if( cmplowercase(line, "adddefaultcharset ") )
        {   
            opt_pos = get_option_pos(line, 1);

            /* Dont show '"' chars */
            if( line[opt_pos]=='"' )
              snprintf(new_buffer, 1024, "%s", &line[opt_pos+1]);
            else
              snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
              
            if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
              new_buffer[strlen(new_buffer)-1]='\0';

            /* Cut out the last '"' char if any */
            if( new_buffer[strlen(new_buffer)-1]=='"' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[12]), utf8);
        }
        else  /* Break at end of vhost */
        if( cmplowercase(line, "</virtualhost") )
            break;
    }
    fclose(fp);
    free(line);
    free(new_buffer);

    if( utf8!=NULL )
        g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
