/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_module_tab.h"
#include "show_info.h"
#include "commented.h"
#include "functions.h"
#include "get_option_pos.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];



/* Lists modules for the selected server */
void populate_module_tab(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    char *line, *new_buffer;
    long file_size=0, old_pos=0, opt_pos=0;
    int i=0, vhost_found=0;
    gchar *address_line, *name_line;
    gchar *utf8=NULL, *info=NULL;

    /* Clear all stores */
    gtk_list_store_clear(widgets->module_store);
    gtk_list_store_clear(widgets->addtype_store);
    gtk_list_store_clear(widgets->addhandler_store);
    gtk_list_store_clear(widgets->addencoding_store);
    gtk_list_store_clear(widgets->addlanguage_store);
    gtk_list_store_clear(widgets->adddescription_store);
    gtk_list_store_clear(widgets->addicon_store);
    gtk_list_store_clear(widgets->addiconbytype_store);
    gtk_list_store_clear(widgets->addiconbyencoding_store);
    gtk_list_store_clear(widgets->alias_store);
    gtk_list_store_clear(widgets->scriptalias_store);

    /* Populate the module tab */
    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        /* We just show this popup here too many windows looks bad */
        info = g_strdup_printf("%s %s", _("Error: Cant open httpd.conf here:\n"), HTTPD_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    new_buffer = allocate(file_size);


/* ------------ If server type is vhost, scroll to the correct one ----------- */
    if( strstr("Virtualhost", (char *)global_server_type) )
    {
        /* Setup the address:port and ServerName lines to identify the server with */
        address_line = g_strdup_printf("<VirtualHost %s:%s>\n", global_server_address, global_server_port);
        name_line    = g_strdup_printf("ServerName %s\n", global_server_name);

        /* Scan for the vhost address and server name */
	    if( file_size > 1 )
        while(fgets(line, file_size, fp)!=NULL)
        {
    	    if( commented(line) )
    	      continue;

            opt_pos = get_option_pos(line, 0);
            snprintf(new_buffer, 1000, "%s", &line[opt_pos]);
        
            if( strcmp(new_buffer, address_line) == 0 )
            {
                /* Matching vhost line, save its position */
                old_pos = ftell(fp);
                old_pos = old_pos - strlen(line) -1; /* Scroll back one line */

                while(fgets(line, file_size, fp)!=NULL)
                {
                    if( commented(line) )
                      continue;

                    opt_pos = get_option_pos(line, 0);
                    snprintf(new_buffer, 1000, "%s", &line[opt_pos]);

                            /* If the vhost has no ServerName then its found */
                    if( strlen((char *)global_server_name) < 5
                    &&  cmplowercase((char *)global_server_name, "none") )
                    {
                        vhost_found = 1;
                        break;
                    }

                    /* Its also got a matching ServerName ... */
                    if( strcmp(new_buffer, name_line) == 0 )
                    {
                        /* IE: ServerName www.example.org found */
                        vhost_found = 1;
                        break;
                    }
                    if( cmplowercase(line, "</virtualhost") )
                      break;
                }
                if( vhost_found )
                  break;
            }
        }
        g_free(address_line);
        g_free(name_line);
    }

    if( ! vhost_found && strstr("Virtualhost", (char *)global_server_type) )
    {
        /* Dont show a popup, already shown in populate_server_settings.c */
        fclose(fp);
        free(line);
        free(new_buffer);
        return;
    }

    /* Standard server selected, scroll to the beginning */
    if( ! vhost_found )
        rewind(fp);
    else /* Scroll back to the vhost we found */
        fseek(fp, old_pos+1, SEEK_SET);

    /* Populate the selected servers modules */
    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( commented(line) || strlen(line) < 3 )
            continue;

        /* We arent looking for vhost data.
           Scroll past the vhost section */
        if( ! vhost_found && cmplowercase(line, "<virtualhost") )
        {
            if( file_size > 1 )
            while(fgets(line, file_size, fp)!=NULL)
            {
                if( commented(line) )
                    continue;
                /* Vhost end found, break */
                if( cmplowercase(line, "</virtualhost") )
                    break;
            }
        }

        /* Selected vhost's end found, break */
        if( vhost_found && cmplowercase(line, "</virtualhost") )
            break;

        if( cmplowercase(line, "loadmodule ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->module_store), &iter);

            /* Insert module name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->module_store), &iter, 0, utf8, -1);

            /* Insert module path */
            sscanf(line, "%*s %*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->module_store), &iter, 1, utf8, -1);
        }
        if( cmplowercase(line, "addtype ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->addtype_store), &iter);

            /* Insert addtype name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addtype_store), &iter, 0, utf8, -1);

            /* Insert addtype mimetypes... */
            /* AddType application/x-httpd-php (insert from here).php .php4 .php3 .phtml .wml */
            opt_pos = get_option_pos(line, 2);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addtype_store), &iter, 1, utf8, -1);
        }
        if( cmplowercase(line, "addhandler ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->addhandler_store), &iter);

            /* Insert addhandler name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addhandler_store), &iter, 0, utf8, -1);

            /* Insert addhandler mimetypes */
            sscanf(line, "%*s %*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addhandler_store), &iter, 1, utf8, -1);
        }
        if( cmplowercase(line, "addencoding ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->addencoding_store), &iter);

            /* Insert addencoding name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addencoding_store), &iter, 0, utf8, -1);

            /* Insert addencoding mimetypes */
            sscanf(line, "%*s %*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addencoding_store), &iter, 1, utf8, -1);
        }
        if( cmplowercase(line, "addlanguage ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->addlanguage_store), &iter);

            /* Insert addlanguage name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addlanguage_store), &iter, 0, utf8, -1);

            /* Insert addlanguage mimetypes */
            sscanf(line, "%*s %*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addlanguage_store), &iter, 1, utf8, -1);
        }
        if( cmplowercase(line, "adddescription ") )
        {
	            gtk_list_store_append(GTK_LIST_STORE(widgets->adddescription_store), &iter);

            /* Get the option value between the first '" "' chars. */
            if( strstr(line, "\"") )
            {
                for(i=0; line[i]!='\0'; i++)
                {
                    if( line[i-1]=='"' )
                		break;
                }
                snprintf(new_buffer, 4000, "%s", &line[i]);

                /* Cut the last '"' char if any */
                for(i=strlen(new_buffer)-1; new_buffer[i]!='\0'; i--)
                {
                    if( new_buffer[i]=='"' )
                    {
                    	new_buffer[i]='\0';
                		break;
                    }
                }
                if( new_buffer[strlen(new_buffer)-1]=='\n' )
                      new_buffer[strlen(new_buffer)-1]='\0';
            }
            else
                sscanf(line, "%*s %s", new_buffer);
            
            /* Insert adddescription name */
	            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	            gtk_list_store_set(GTK_LIST_STORE(widgets->adddescription_store), &iter, 0, utf8, -1);

            /* Get all option values after the second '"' char. */
            if( strstr(line, "\"") )
            {
                for(i=strlen(line)-1; line[i]!='\0'; i--)
                {
                    if( line[i-2]=='"' )
                        break;
                }
                snprintf(new_buffer, 4000, "%s", &line[i]);

                if( new_buffer[strlen(new_buffer)-1]=='\n' )
                    new_buffer[strlen(new_buffer)-1]='\0';
            }
            else
              sscanf(line, "%*s %*s %s", new_buffer);

            /* Insert adddescription mimetypes */
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->adddescription_store), &iter, 1, utf8, -1);
        }

        if( cmplowercase(line, "addicon ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->addicon_store), &iter);

            /* Insert addicon name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addicon_store), &iter, 0, utf8, -1);

            /* Insert addicon mimetypes */
            opt_pos = get_option_pos(line, 2);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addicon_store), &iter, 1, utf8, -1);
        }

        if( cmplowercase(line, "addiconbytype ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->addiconbytype_store), &iter);

            /* Insert addiconbytype name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addiconbytype_store), &iter, 0, utf8, -1);

            /* Insert addiconbytype mimetypes */
            opt_pos = get_option_pos(line, 2);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addiconbytype_store), &iter, 1, utf8, -1);
        }

        if( cmplowercase(line, "addiconbyencoding ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->addiconbyencoding_store), &iter);

            /* Insert addiconbyencoding name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addiconbyencoding_store), &iter, 0, utf8, -1);

            /* Insert addiconbyencoding mimetypes */
            opt_pos = get_option_pos(line, 2);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->addiconbyencoding_store), &iter, 1, utf8, -1);
        }

        if( cmplowercase(line, "alias ") && ! cmplowercase(line, "scriptalias") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->alias_store), &iter);

            /* Insert alias name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->alias_store), &iter, 0, utf8, -1);

            /* Insert alias mimetypes */
            opt_pos = get_option_pos(line, 2);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->alias_store), &iter, 1, utf8, -1);
        }

        if( cmplowercase(line, "scriptalias ") )
        {
            gtk_list_store_append(GTK_LIST_STORE(widgets->scriptalias_store), &iter);

            /* Insert scriptalias name */
            sscanf(line, "%*s %s", new_buffer);
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->scriptalias_store), &iter, 0, utf8, -1);

            /* Insert scriptalias mimetypes */
            opt_pos = get_option_pos(line, 2);
            snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
            if( new_buffer[strlen(new_buffer)-1]=='\n' )
              new_buffer[strlen(new_buffer)-1]='\0';

            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->scriptalias_store), &iter, 1, utf8, -1);
        }
    }		    
    fclose(fp);
    free(line);
    free(new_buffer);

    if( utf8 !=NULL )
        g_free(utf8);
}
