/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "allocate.h"
#include "widgets.h"
#include "functions.h"
#include "populate_htaccess_tab.h"
#include "select_first_user.h"
#include "chars_are_digits.h"
#include "show_info.h"
#include "commands.h"



void populate_htaccess_tab(struct w *widgets)
{
    populate_virtual_users(widgets);
    populate_htaccess_users(widgets);

    gtk_widget_show_all(widgets->main_window);
}


void populate_virtual_users(struct w *widgets)
{
    /* Lists users in the virtual user list */
    FILE *fp;
    char *line;
    long file_size;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit=0;
    gchar *username, *main_password_file;
    gchar *utf8=NULL;
    int x = 0, found_user = 0;

    gtk_list_store_clear(widgets->virtual_user_store);

    main_password_file = g_strdup_printf("%s/passwords/passwords", HTTPD_ROOT_PATH);
    if((fp=fopen(main_password_file, "r"))==NULL)
    {
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);
    line = allocate(file_size);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        for(x=0; line[x]!='\0'; x++)
        {
            if( line[x]==':' )
            {
                found_user = 1;
		
                username = g_strdup_printf("%s", line);
                username[x]='\0';

                /* Insert username */
                gtk_list_store_append(GTK_LIST_STORE(widgets->virtual_user_store), &iter);

	            utf8 = g_locale_to_utf8(username, strlen(username), NULL, NULL, NULL);
	            gtk_list_store_set(GTK_LIST_STORE(widgets->virtual_user_store), &iter, 0, utf8, -1);
                if( utf8!=NULL )
	                g_free(utf8);

                g_free(username);
                break;
    	    }
        }
    }
    free(line);
    g_free(main_password_file);
    fclose(fp);

    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->virtual_user_treeview), path, NULL, edit);
    gtk_tree_path_free(path);

    select_first_virtual_user(widgets);
}


void populate_htaccess_users(struct w *widgets)
{
    /* Lists htaccess users */
    FILE *fp;
    char *line;
    long file_size;
    int i = 0, found_user = 0;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit=0;
    gchar *username, *file_path, *utf8=NULL;
    G_CONST_RETURN gchar *dir_path;

    gtk_list_store_clear(widgets->htacc_user_store);

    dir_path = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[2]));

    file_path = g_strdup_printf("%s/.htaccess", dir_path);
    if((fp=fopen(file_path, "r"))==NULL)
    {
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size+1);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        /* We have found the beginning of a limit statement */
        if( cmplowercase(line, "<limit ") )
        while(fgets(line, file_size, fp)!=NULL)
        {
            if( cmplowercase(line, "</limit ") )
              break;

            /* "Require User" found. Add the user */
            if( cmplowercase(line, "require ")
            &&  cmplowercase(line, "user ")  )
            {
                for(i=1; line[i]!='\0'; i++)
                if( line[i]==' ' && line[i-1]=='r' ) /* "require use'r'"*/
                    break;
                  
                username = g_strdup_printf("%s", &line[i+1]);
                if( username[strlen(username)-1]=='\n' )
                    username[strlen(username)-1]='\0';

                found_user = 1;

                /* Insert username */
                gtk_list_store_append(GTK_LIST_STORE(widgets->htacc_user_store), &iter);

                utf8 = g_locale_to_utf8(username, strlen(username), NULL, NULL, NULL);
                gtk_list_store_set(GTK_LIST_STORE(widgets->htacc_user_store), &iter, 0, utf8, -1);
                if( utf8!=NULL )
	                  g_free(utf8);
	
	            if( username!=NULL )
	                g_free(username);
            }
        }
    }
    fclose(fp);
    free(line);
    g_free(file_path);

    if( ! found_user )
        return;

    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->htacc_user_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
    select_first_htacc_user(widgets);
}
