/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_gadmin_httpd.h"
#include "populate_servers.h"
#include "select_first_server.h"
#include "populate_server_settings.h"
#include "populate_module_tab.h"
#include "select_first_user.h"
#include "populate_htaccess_tab.h"
#include "populate_disc_tab.h"
#include "populate_access_tab.h"
#include "populate_error_tab.h"
#include "populate_conf_tab.h"



void populate_gadmin_httpd(struct w *widgets)
{
	/* Populate the servers treeview */
	populate_servers(widgets);
	/* Set the first server as selected */
	select_first_server(widgets);

	/* Populate the server settings */
	populate_server_settings(widgets);

	/* Populate the module tab */
	populate_module_tab(widgets);

	/* Populate the htaccess tab */
	populate_htaccess_tab(widgets);   
	/* Set the first virtual user as selected */
	select_first_virtual_user(widgets);
	/* Set the first htaccess user as selected */
	select_first_htacc_user(widgets);

	/* Populate the disc tab */
	populate_discs(widgets);

	/* Populate the file access tab */
	populate_access_tab(widgets);

	/* Populate the error tab */
	populate_error_tab(widgets);
	
	/* Populate the conf tab */
	populate_conf_tab(widgets);
}
