/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
/* For tolower.. */
#include <ctype.h>
#include "widgets.h"
#include "chars_are_digits.h"
#include "allocate.h"
#include "functions.h"
#include "show_info.h"
#include "commands.h"

#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif

#if ! defined USE_DARWIN
    #ifndef _CRYPT_H
      #include <crypt.h>
    #endif
#endif


/* Compare strings in lower case */
int cmplowercase(char *buf, char *cmpstring)
{
    char *p, *newbuf;
    int retval = 0;

    if( buf==NULL )
        return retval;

    /* Ignore single newline chars */
    if( strlen(buf) < 2 )
        return retval;

    newbuf = allocate(strlen(buf)+1);
    /* Exists if it cant allocate */
    sprintf(newbuf, "%s", buf);

    for(p = newbuf; *p!='\0'; ++p)
        *p = tolower(*p);

    if( strstr(newbuf, cmpstring) )
        retval = 1;

    free(newbuf);

    return retval;
}


char *encrypt_password(G_CONST_RETURN gchar *password)
{
    /* Make an encrypted password using the MD5 algoritm */
    int i=0, where=0, randlen=8; /* The max MD5 random stringsize is 8 */
    char *rnd_string;
    char salt[13]=""; /* The total salt length is 12 */

    /* 64 chars */
    char *arr[]={"A","B","C","D","E","F","G","H","I","J","K",
	     "L","M","N","O","P","Q","R","S","T","U","V",
	     "W","X","Y","Z","a","b","c","d","e","f","g",
	     "h","i","j","k","l","m","n","o","p","q","r",
	     "s","t","u","v","w","x","y","z","0","1","2",
	     "3","4","5","6","7","8","9",".","/"};

    srand((unsigned)time(NULL));

    rnd_string = allocate(9);

    while( i < randlen )
    {
        where=rand()%64;
        strcat(rnd_string, arr[where]);
        i++;
    }

#if defined HAVE_CRYPT
    /* For this to work it must have linked with -lcrypt */
    sprintf(salt, "$1$%s$", rnd_string);
#else
    /* We cant use MD5 salting and the salt can only be 2 chars */
    sprintf(salt, "%s", &rnd_string[6]);
#endif

    free(rnd_string);

    return crypt(password, salt);
}


void make_dir_chmod(gchar *directory, char perm[128])
{
    gchar *command;

    command = g_strdup_printf("mkdir -p %s && chmod %s %s", directory, perm, directory);
    if( ! run_command(command) )
        printf("Error running command: %s\n", command);    

    g_free(command);
}


int fix_conf()
{
    /* Strip all newlines between directives */
    /* * then add newlines before <Anonymous and <VirtualHost */
    FILE *fp;
    char *old_buffer, *new_buffer;
    long conf_size, allocate_extra=0;

    /* First remove any newlines first on all lines in the config */
    /* And see how many new chars we will be adding */
    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        printf("Error reading %s for adding newlines\n", HTTPD_CONF);
        return 0;
    }
    fseek(fp, 0, SEEK_END);
    conf_size=ftell(fp);
    rewind(fp);

    old_buffer = allocate(conf_size+1024);
    if( old_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
        return 0;
    }

    new_buffer = allocate(conf_size+1024);
    if( new_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
        free(old_buffer);
        return 0;
    }

    if( conf_size > 1 )
    while(fgets(old_buffer, conf_size, fp)!=NULL)
    {
        if( old_buffer[0]=='\n' || old_buffer[0]=='\r' )
        {
          /* Dont collect these lines */
        }
        else
          strcat(new_buffer, old_buffer);	  	  

        if( strstr(old_buffer, "<Anonymous") || strstr(old_buffer, "<VirtualHost") )
            allocate_extra++;
    }
    fclose(fp);
    free(old_buffer);
    strcat(new_buffer, "\n");

    /* Write the newline stripped conf */
    if((fp=fopen(HTTPD_CONF, "w+"))==NULL)
    {
       printf("Error reading %s for adding newlines\n", HTTPD_CONF);
       free(new_buffer);
       return 0;
    }
    fputs(new_buffer, fp);
    fclose(fp);
    free(new_buffer);

    /* Add the newlines */
    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        printf("Error reading %s for adding newlines\n", HTTPD_CONF);
        return 0;
    }
    fseek(fp, 0, SEEK_END);
    conf_size=ftell(fp);
    rewind(fp);

    old_buffer = allocate(conf_size+1024);
    if( old_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
        return 0;
    }

    new_buffer = allocate(conf_size+1024+allocate_extra);
    if( new_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
        free(old_buffer);
        return 0;
    }

    if( conf_size > 1 )
    while(fgets(old_buffer, conf_size, fp)!=NULL)
    {
        if( strstr(old_buffer, "<Anonymous") || strstr(old_buffer, "<VirtualHost") )
        {
            strcat(new_buffer, "\n");
            strcat(new_buffer, old_buffer);
        }
        else
          strcat(new_buffer, old_buffer);
    }
    fclose(fp);
    free(old_buffer);

    /* Write the newline added conf */
    if((fp=fopen(HTTPD_CONF, "w+"))==NULL)
    {
        printf("Error reading %s for adding newlines\n", HTTPD_CONF);
        free(new_buffer);
        return 0;
    }
    fputs(new_buffer, fp);
    fclose(fp);
    free(new_buffer);

    return 1;
}


void
fix_path(char *path)
{
    char *temp;
    temp = allocate(4096);

    /* Take away an unwanted star at the end */
    if( path[strlen(path)-1]=='*' )
        path[strlen(path)-1]='\0';
    /* Take away an extra slash at the end */    
    if( path[strlen(path)-1]=='/' )
        path[strlen(path)-1]='\0';

    /* Make sure we have a slash at the beginning of the path */    
    if( path[0]!='/' )
    {
        snprintf(temp, 1024, "/%s", path);
        snprintf(path, 1024, "%s", temp);
    }        
    if( temp!=NULL )
        free(temp);    
}


void randomize_username(struct w *widgets)
{
    char *rnd_string;
    gchar *utf8=NULL;
    int len = 6; /* Default username length */

    rnd_string = random_string(len);

    /* Insert the randomized username in the username entry */    
    utf8 = g_locale_to_utf8(rnd_string, strlen(rnd_string), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[0]), utf8);

    if( utf8!=NULL )
      g_free(utf8);

    free(rnd_string);
}


void randomize_password(struct w *widgets)
{
    char *rnd_string;
    int len = 6; /* Default password length */
    gchar *utf8=NULL;

    rnd_string = random_string(len);

    /* Insert the randomized password in the password entry */    
    utf8 = g_locale_to_utf8(rnd_string, strlen(rnd_string), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[1]), utf8);

    if( utf8!=NULL )
        g_free(utf8);
    
    free(rnd_string);
}


char *random_string(int len)
{
    /* Returns a randomized string in upper or lower case 
     * depending on what is selected */
    char *rnd_string;
    gchar *info;
    int upper_case = 0;
    int where = 0;
    int i = 0;

    if( len > 256 )
    {
        info = g_strdup_printf(_("Randomize length too long, changed it to 256.\n"));
        show_info(info);
        g_free(info);
        len = 256;
    }

    /* 256 is the max allowed */
    rnd_string = allocate(300);

    /* Uppercase array 106 chars */
    char *u_arr[]={"A","B","C","D","E","F","G","H","I",
	    	   "J","K","L","M","N","O","P","Q","R",
	           "S","T","U","V","W","X","Y","Z",
    	           "a","b","c","d","e","f","g","h","i",
	           "j","k","l","m","n","o","p","q","r",
	           "s","t","u","v","w","x","y","z",
    	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9"};

    /* Lowercase array 53 chars */
    char *l_arr[]={"a","b","c","d","e","f","g","h","i",
                   "j","k","l","m","n","o","p","q","r",
	           "s","t","u","v","w","x","y","z",
                   "1","2","3","4","5","6","7","8","9",
                   "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9"};


    /* Give "deep thought" some time to come up with the number "42" :) */
    usleep(300000);

    /* Make the first random nondigit */
    srand((unsigned)time(NULL));
    while(1)
    {
	    if( upper_case )
	    {
	        where = rand() % 106;
        	  
	        if( ! chars_are_digits(u_arr[where]) )
	        {
                strcpy(rnd_string, u_arr[where]);
                break;
	        }
	    }
	
	    if( ! upper_case )
	    {
	        where = rand() % 53;

	        if( ! chars_are_digits(l_arr[where]) )
	        {
                strcpy(rnd_string, l_arr[where]);
                break;
	        }
	    }
    }

    where = 0;
    i = 1;

    usleep(300000);
    srand((unsigned)time(NULL));

    while( i < len )
    {
	    if( upper_case )
	    {
	        where = rand() % 106;
           	strcat(rnd_string, u_arr[where]);
	    }
	    if( ! upper_case )
	    {
	        where = rand() % 53;
            strcat(rnd_string, l_arr[where]);
	    }
	    i++;
    }

    return rnd_string;
}


void
exec_ssl(char *command, char descr[128])
{
    FILE *fp;
    if((fp=popen(command, "r"))==NULL)    
    {
        perror("popen");
        printf("Error description: %s\n", descr);
        printf("Error command: %s\n", command);
        return;
    }
    pclose(fp);
}
