/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "allocate.h"
#include "delete_server.h"
#include "populate_servers.h"
#include "populate_module_tab.h"
#include "populate_conf_tab.h"
#include "reread_conf.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];

extern int activated;



void delete_server(struct w *widgets)
{
    FILE *fp;
    char *line, *config, *temp_vhost;
    gchar *match_line;
    int found_server = 0;
    long conf_size;

    if( ! strstr((char *)global_server_type, "Virtualhost") )
    {
        printf("Refusing to delete the standard server!\n");
        return;      
    }
    if( strlen(global_server_address)==0 ) 
    {
        printf("Cant delete the server, its got no address!\n");
        return;
    }

    /* Delete the selected vhost */
    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        printf("Cant delete the server, file: %s not found\n", HTTPD_CONF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    config = allocate(conf_size+1); 
    line = allocate(conf_size+1);
    temp_vhost = allocate(conf_size+1);

    match_line = g_strdup_printf("<VirtualHost %s:%s>\n", global_server_address, global_server_port);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
        /* Is this the server to delete */
        if( ! strcmp(line, match_line) && ! found_server )
        {
            strcpy(temp_vhost, line);

            while(fgets(line, conf_size, fp)!=NULL)
            {
                if( strlen(line) > 8000 )
                    continue;

                strcat(temp_vhost, line);

                // Fixme: Compare names better
	            if( strstr(line, (char *)global_server_name) )
	            {
                    found_server = 1;

                    /* Scroll past this vhost */
                    while(fgets(line, conf_size, fp)!=NULL)
                    {
                        if( strlen(line) > 8000 )
                            continue;

                            strcat(temp_vhost, line);

                        if( strstr(line, "</VirtualHost>") )
                            break;
                    }
                }
                if( strstr(line, "</VirtualHost>") )
                    break;
            }

            if( ! found_server )
                strcat(config, temp_vhost);

            temp_vhost[0]='\0';
        }
        else /* Get everything thats not a vhost */
            strcat(config, line);
    }
    fclose(fp);

    free(line);
    g_free(match_line);
    free(temp_vhost);

    if( ! found_server )
    {
        free(config);
        return;
    }

    /* Write the new config without the deleted vhost */
    if((fp=fopen(HTTPD_CONF, "w+"))==NULL)
    {
        printf("Error Writing configuration here: %s\n", HTTPD_CONF);
        free(config);
        return;
    }
    fputs(config, fp);
    fclose(fp);
    free(config);

    populate_servers(widgets);
    populate_conf_tab(widgets);
    populate_module_tab(widgets);

    reread_conf(widgets);
}
