/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "create_transfer_tab.h"
#include "populate_transfer_tab.h"
#include "commands.h"
#include "show_info.h"

#define EXPAND_TRANSFER_SECTION 1


void kick_pid(struct w *widgets)
{
    gchar *cmd, *info;
    G_CONST_RETURN gchar *pid;
    
    pid = gtk_entry_get_text(GTK_ENTRY(widgets->kick_entry));

    if( pid == NULL || strlen(pid) < 2 )
        return;

    cmd = g_strdup_printf("kill -9 %s", pid);
    if( ! run_command(cmd) )    
    {
        info = g_strdup_printf(_("Can not terminate process: %s\n"), pid);    
        show_info(info);
        g_free(info);
    }
    g_free(cmd);
}


void transfer_treeview_row_clicked(GtkTreeView *treeview, GdkEventButton *event, struct w *widgets)
{
    gchar *pid;
    GtkTreeIter iter;
    GtkTreePath *path;
    GtkTreeModel *list_store;
    GtkTreeSelection *selection;

    /* The left button is pressed */
    if( ! event->type == GDK_BUTTON_PRESS || ! event->button == 1 )
        return;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));

    if( gtk_tree_selection_count_selected_rows(selection) <= 1 )
    {
        /* Get the treepath for the row that was clicked */
        if( gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(treeview), event->x, event->y,
				                                &path, NULL, NULL, NULL))
        {
            gtk_tree_selection_unselect_all(selection);
    	    gtk_tree_selection_select_path(selection, path);

            list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
            gtk_tree_model_get_iter(list_store, &iter, path);

            gtk_tree_model_get(list_store, &iter, 1, &pid, -1);

            gtk_entry_set_text(GTK_ENTRY(widgets->kick_entry), pid);

            g_free(pid);
            gtk_tree_path_free(path);
        }
    }
}


void create_transfer_tab(struct w *widgets)
{
    GtkCellRenderer *transfer_cell_renderer;
    GtkWidget *transfer_treeview_hbox;
    GtkWidget *transfer_scrolled_window;
    gchar *utf8 = NULL;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    /* Create the transfer treeview in a scrolled window */
    transfer_treeview_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox4), transfer_treeview_hbox, EXPAND_TRANSFER_SECTION, TRUE, 0);

    transfer_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(transfer_treeview_hbox), transfer_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(transfer_scrolled_window),
						    GTK_POLICY_AUTOMATIC,
						    GTK_POLICY_ALWAYS);

    widgets->transfer_store = gtk_list_store_new(13, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, 
    G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
    G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->transfer_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_MODEL(widgets->transfer_store));

    gtk_container_add(GTK_CONTAINER(transfer_scrolled_window), widgets->transfer_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->transfer_treeview), TRUE);

    /* Set the column labels in the treeview */
    transfer_cell_renderer = gtk_cell_renderer_text_new();

    /* srv pid acc m cpu ss req conn child slot client vhost request */

    GtkTreeViewColumn *srv_col = gtk_tree_view_column_new_with_attributes(_("Server nr"), transfer_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(srv_col));

    GtkTreeViewColumn *pid_col = gtk_tree_view_column_new_with_attributes(_("PID"), transfer_cell_renderer, "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(pid_col));

    GtkTreeViewColumn *acc_col = gtk_tree_view_column_new_with_attributes(_("Accesses"), transfer_cell_renderer, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(acc_col));

    GtkTreeViewColumn *mode_col = gtk_tree_view_column_new_with_attributes(_("Mode"), transfer_cell_renderer, "text", 3, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(mode_col));

    GtkTreeViewColumn *cpu_col = gtk_tree_view_column_new_with_attributes(_("CPU usage"), transfer_cell_renderer, "text", 4, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(cpu_col));

    GtkTreeViewColumn *ss_col = gtk_tree_view_column_new_with_attributes(_("Seconds"), transfer_cell_renderer, "text", 5, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(ss_col));

    GtkTreeViewColumn *req_col = gtk_tree_view_column_new_with_attributes(_("Req"), transfer_cell_renderer, "text", 6, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(req_col));

    GtkTreeViewColumn *conn_col = gtk_tree_view_column_new_with_attributes(_("Kilobytes"), transfer_cell_renderer, "text", 7, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(conn_col));

    GtkTreeViewColumn *child_col = gtk_tree_view_column_new_with_attributes(_("Megabytes"), transfer_cell_renderer, "text", 8, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(child_col));

    GtkTreeViewColumn *slot_col = gtk_tree_view_column_new_with_attributes(_("Total MB"), transfer_cell_renderer, "text", 9, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(slot_col));

    GtkTreeViewColumn *client_col = gtk_tree_view_column_new_with_attributes(_("Client"), transfer_cell_renderer, "text", 10, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(client_col));

    GtkTreeViewColumn *vhost_col = gtk_tree_view_column_new_with_attributes(_("Vhost"), transfer_cell_renderer, "text", 11, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(vhost_col));

    GtkTreeViewColumn *request_col = gtk_tree_view_column_new_with_attributes(_("Client request"), transfer_cell_renderer, "text", 12, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->transfer_treeview), GTK_TREE_VIEW_COLUMN(request_col));

    /* Treeview clicked callback */
    g_signal_connect((gpointer)widgets->transfer_treeview, "button_press_event",
	        		G_CALLBACK(transfer_treeview_row_clicked), widgets);

    /* Add a kick hbox */
    GtkWidget *kick_hbox1 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox4), kick_hbox1, FALSE, FALSE, 0);

    GtkWidget *kick_entry_label = gtk_label_new(_("\t\t\t\t\t\t\tPID to kick:"));
    widgets->kick_entry = gtk_entry_new();

    gtk_box_pack_start(GTK_BOX(kick_hbox1), kick_entry_label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(kick_hbox1), widgets->kick_entry, FALSE, FALSE, 0);

    /* Add a kick/kickban button box */
    GtkWidget *transfer_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox4), transfer_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(transfer_button_box), GTK_BUTTONBOX_SPREAD);

    /* Kick button */
    GtkWidget *kick_button = gtk_button_new();
    GtkWidget *kick_alignment = gtk_alignment_new(0.5, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(kick_button), kick_alignment);

    GtkWidget *kick_hbox = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(kick_alignment), kick_hbox);

    GtkWidget *kick_image = gtk_image_new_from_stock("gtk-apply", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start(GTK_BOX(kick_hbox), kick_image, FALSE, FALSE, 0);

    GtkWidget *kick_label = gtk_label_new_with_mnemonic(_("Kick"));
    gtk_box_pack_start(GTK_BOX(kick_hbox), kick_label, FALSE, FALSE, 0);

    gtk_label_set_justify(GTK_LABEL(kick_label), GTK_JUSTIFY_LEFT);

    gtk_box_pack_start(GTK_BOX(transfer_button_box), kick_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(GTK_OBJECT(kick_button), "clicked",
			     G_CALLBACK(kick_pid), widgets);

    /* Update button */
    GtkWidget *update_button = gtk_button_new();
    GtkWidget *update_alignment = gtk_alignment_new(0.5, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(update_button), update_alignment);

    GtkWidget *update_hbox = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(update_alignment), update_hbox);

    GtkWidget *update_image = gtk_image_new_from_stock("gtk-refresh", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start(GTK_BOX(update_hbox), update_image, FALSE, FALSE, 0);

    GtkWidget *update_label = gtk_label_new_with_mnemonic(_("Update"));
    gtk_box_pack_start(GTK_BOX(update_hbox), update_label, FALSE, FALSE, 0);

    gtk_label_set_justify(GTK_LABEL(update_label), GTK_JUSTIFY_LEFT);

    gtk_box_pack_start(GTK_BOX(transfer_button_box), update_button, FALSE, FALSE, 0);

    g_signal_connect_swapped(GTK_OBJECT(update_button), "clicked",
			     G_CALLBACK(populate_transfers), widgets);

    if( utf8 != NULL )
        g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
