/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_progressbars.h"
#include "make_settings_labels.h"
#include "make_settings_hseparators.h"
#include "generate_cert.h"
#include "create_server_settings.h"

extern int use_tls;



void create_server_settings(struct w *widgets)
{
    GtkTooltips *tooltips;
//    GtkWidget *gen_cert_button;
    gchar *utf8 = NULL;
//    gdouble progress_val = 1.0;
    gchar *combo_text;

    /* Counters for the widgets and positions in the table */
    int a = 0;
    int b = 1;
    int ent  = 0;
    int spin = 0;
    int comb = 0;

    /* Max lengths and input */
    int entry_size = 100;

    tooltips = gtk_tooltips_new();

    /* Server name */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" The servers name: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("www.example.org, 192.168.0.100. If the server is a vhost it directs requests based on this name"), NULL);
    a++; b++; ent++;

    /* Server address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" The servers IP-address or hostname: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("www.example.org, 192.168.0.100 or 0.0.0.0 which means listen to all network interfaces"), NULL);
    a++; b++; ent++;

    /* Server port */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Server port: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin],
    _("The server port. 0 means deactivated"), NULL);
    a++; b++; spin++;

    /* Show server identity */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Show server identity: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Email address */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" The administrators email address: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("The administrators email address"), NULL);
    a++; b++; ent++;

    /* Hostname lookups */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Hostname lookups: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Use canonical name */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Use canonical name: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Timeout (Connection timeout) */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Connection timeout: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin],
    _("Connection timeout. 0 means deactivated"), NULL);
    a++; b++; spin++;

    /* KeepAlive */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Allow keepalive requests: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* MaxKeepAliveRequests */    
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Max keepalive requests: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin],
    _("Maximum number of keepalive requests"), NULL);
    a++; b++; spin++;

    /* KeepAliveTimeout */    
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Keepalive timeout: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin],
    _("Keepalive timeout. 0 means deactivated"), NULL);
    a++; b++; spin++;

    /* Server user */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this user: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("The server drops root privileges and runs as this user"), NULL);
    a++; b++; ent++;

    /* Server group */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this group: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("The server drops root privileges and runs as this group"), NULL);
    a++; b++; ent++;

    /* ServerTokens */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Show server token: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("OS"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* ExtendedStatus must always be set to on to
       get the client list for the transfer tab */
/*
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Extended status: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("On"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("Off"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
*/
    a++; b++; comb++;

    /* DocumentRoot */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Webpage documents directory: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("Serves webpages from this directory"), NULL);
    a++; b++; ent++;

    /* ServerRoot */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Server configuration directory: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("Server configuration files are located in this directory"), NULL);
    a++; b++; ent++;

    /* DirectoryIndex */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Directory indexing: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("Serves these files automatically when browsing to directories"), NULL);
    a++; b++; ent++;

    /* DefaultType */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Default document type: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("This is the default document type"), NULL);
    a++; b++; ent++;

    /* AccessFileName */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Access privilege filename: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("Access restrictions can be set in this file if present in a directory"), NULL);
    a++; b++; ent++;

    /* TypesConfig */
//    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Mimetype file: "), 0,1,a,b,200);
//    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
//    _("Mimetypes classifies website contents"), NULL);
//    a++; b++; ent++;

    /* DefaultLanguage (or "none") */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Default language: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("Optionally set a default language.\nThis should not be used when serving multilanguage pages."), NULL);
    a++; b++; ent++;

    /* Language priority */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Language priority: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("Interpret webpages in this language first."), NULL);
    a++; b++; ent++;

    /* Default charset */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Default charset: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent],
    _("IE: On, Off or CharSet. Overrides charset meta tags in webpages. Default setting is Off."), NULL);
    a++; b++; ent++;

    gtk_widget_show_all(widgets->main_window);
}
