/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "server_treeview_row_clicked.h"
#include "add_server.h"
#include "delete_server.h"
#include "apply_server_settings.h"

/* Wether to let the module sections expand */
#define EXPAND_MODULE_SECTION FALSE

/* Define treeview and cell numbers */
#define NUM_MODULE_TREEVIEWS 11
#define NUM_MODULE_CELLS NUM_MODULE_TREEVIEWS * 2

/* The module tab requires 2 hboxes per added section */
#define NUM_HBOXES NUM_MODULE_TREEVIEWS * 2


char mod_type[1024]="";

void set_module_type(char *type, struct w *widgets)
{
    snprintf(mod_type, 1000, "%s", type);
}

void scroll_to_last_row(GtkTreeView *treeview, GtkTreeIter iter)
{
    /* Scroll to the last row */
    GtkTreeModel *model;
    GtkTreePath *path;
    GtkTreeSelection *selection;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
    path = gtk_tree_model_get_path(GTK_TREE_MODEL(model), &iter);
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
    gtk_tree_selection_select_path(GTK_TREE_SELECTION(selection), path);
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(treeview), path, 0, TRUE);
    gtk_tree_path_free(path);
}

void add_module(struct w *widgets)
{
    GtkTreeIter iter;
    gchar *info;

    if( ! strcmp(mod_type, "module") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->module_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->module_treeview), iter);
    }
    if( ! strcmp(mod_type, "addtype") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->addtype_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->addtype_treeview), iter);
    }
    if( ! strcmp(mod_type, "addhandler") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->addhandler_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->addhandler_treeview), iter);
    }
    if( ! strcmp(mod_type, "addencoding") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->addencoding_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->addencoding_treeview), iter);
    }
    if( ! strcmp(mod_type, "addlanguage") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->addlanguage_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->addlanguage_treeview), iter);
    }
    if( ! strcmp(mod_type, "adddescription") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->adddescription_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->adddescription_treeview), iter);
    }
    if( ! strcmp(mod_type, "addicon") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->addicon_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->addicon_treeview), iter);
    }
    if( ! strcmp(mod_type, "addiconbytype") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->addiconbytype_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->addiconbytype_treeview), iter);
    }
    if( ! strcmp(mod_type, "addiconbyencoding") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->addiconbyencoding_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->addiconbyencoding_treeview), iter);
    }
    if( ! strcmp(mod_type, "alias") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->alias_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->alias_treeview), iter);
    }
    if( ! strcmp(mod_type, "scriptalias") )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->scriptalias_store), &iter);
        scroll_to_last_row(GTK_TREE_VIEW(widgets->scriptalias_treeview), iter);
    }

    info = g_strdup_printf("%s",
    _("A new row has been added for this option type.\nClick the cells in this row to write a new option specification.\n"));
    show_info(info);
    g_free(info);
}

void del_module(struct w *widgets)
{
    GtkTreeIter iter;
    gboolean val;

    if( ! strcmp(mod_type, "module") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->module_store), &iter);
    }
    if( ! strcmp(mod_type, "addtype") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->addtype_store), &iter);
    }
    if( ! strcmp(mod_type, "addhandler") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->addhandler_store), &iter);
    }
    if( ! strcmp(mod_type, "addencoding") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->addencoding_store), &iter);
    }
    if( ! strcmp(mod_type, "addlanguage") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->addlanguage_store), &iter);
    }
    if( ! strcmp(mod_type, "adddescription") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->adddescription_store), &iter);
    }
    if( ! strcmp(mod_type, "addicon") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->addicon_store), &iter);
    }
    if( ! strcmp(mod_type, "addiconbytype") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->addiconbytype_store), &iter);
    }
    if( ! strcmp(mod_type, "addiconbyencoding") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->addiconbyencoding_store), &iter);
    }
    if( ! strcmp(mod_type, "alias") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->alias_store), &iter);
    }
    if( ! strcmp(mod_type, "scriptalias") )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(widgets->scriptalias_store), &iter);
    }
}

/* It would be nice to get the columns number here somehow... */
void left_cell_edited(GtkCellRendererText *cell, gchar *path_string,
			gchar *new_text, GtkListStore *store)
{
    /* Changes the edited module cell text */
    GtkTreeIter iter;
    GtkTreePath *path = NULL;

    path = gtk_tree_path_new_from_string(path_string);
    gtk_tree_model_get_iter(GTK_TREE_MODEL(store), &iter, path);

    if( path!=NULL )
        gtk_tree_path_free(path);

    gtk_list_store_set(GTK_LIST_STORE(store), &iter, 0, new_text, -1);
}

void right_cell_edited(GtkCellRendererText *cell, gchar *path_string,
			gchar *new_text, GtkListStore *store)
{
    /* Changes the edited module cell text */
    GtkTreeIter iter;
    GtkTreePath *path = NULL;

    path = gtk_tree_path_new_from_string(path_string);
    gtk_tree_model_get_iter(GTK_TREE_MODEL(store), &iter, path);

    if( path!=NULL )
        gtk_tree_path_free(path);

    gtk_list_store_set(GTK_LIST_STORE(store), &iter, 1, new_text, -1);
}

void delete_row_clicked(gpointer data, GtkTreeView *treeview)
{
    /* Deletes the selected treeview row */
    GtkTreeModel *model;
    GtkTreeStore *model_store;
    GtkTreeSelection *select;
    GtkTreeIter iter;
    gboolean val;
		
    model_store = (GtkTreeStore *) gtk_tree_view_get_model(treeview);
    select = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
				
    if( gtk_tree_selection_get_selected(select, &model, &iter) )
    {
        val = gtk_list_store_remove(GTK_LIST_STORE(model_store), &iter);
    }
}

void create_module_tab(struct w *widgets)
{
    GtkWidget *main_scrolled_window;
    GtkWidget *main_vbox;
    GtkWidget *hbox[NUM_HBOXES];
    GtkTooltips *tooltips;
    gchar *utf8=NULL;
    int i = 0;

    /* All treeviews has 2 columns */
    GtkCellRenderer *cell[NUM_MODULE_CELLS];

    GtkWidget *module_scrolled_window;
    GtkWidget *addtype_scrolled_window;
    GtkWidget *addhandler_scrolled_window;
    GtkWidget *addencoding_scrolled_window;
    GtkWidget *addlanguage_scrolled_window;
    GtkWidget *adddescription_scrolled_window;
    GtkWidget *addicon_scrolled_window;
    GtkWidget *addiconbytype_scrolled_window;
    GtkWidget *addiconbyencoding_scrolled_window;
    GtkWidget *alias_scrolled_window;
    GtkWidget *scriptalias_scrolled_window;

    tooltips = gtk_tooltips_new();

    /* Create the main scrolled window in the notebook */
    main_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox2), main_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(main_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(main_scrolled_window, -1, 100);

    /* Create a main vbox inside the main scrolled window */
    main_vbox = gtk_vbox_new(FALSE, 0);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(main_scrolled_window), main_vbox);

    /* Pack hboxes into the main vbox */
    for(i=0; i<NUM_HBOXES; i++)
    {
        hbox[i] = gtk_hbox_new(TRUE, 0);
        gtk_container_add(GTK_CONTAINER(main_vbox), hbox[i]);
    }  

    /* Create all cell renderers and make them editable */
    for(i=0; i<NUM_MODULE_CELLS; i++)
    {
        cell[i] = gtk_cell_renderer_text_new();
        g_object_set(cell[i], "editable", TRUE, NULL);
    }

    i = 0;

    /* MODULES TREEVIEW BEGIN */
    module_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[0]), module_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(module_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(module_scrolled_window, -1, 100);

    widgets->module_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->module_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->module_treeview), GTK_TREE_MODEL(widgets->module_store));
    gtk_container_add(GTK_CONTAINER(module_scrolled_window), widgets->module_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->module_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *modulename_col = gtk_tree_view_column_new_with_attributes(_("Module name"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->module_treeview), GTK_TREE_VIEW_COLUMN(modulename_col));
    i++;

    GtkTreeViewColumn *modulepath_col = gtk_tree_view_column_new_with_attributes(_("Module path"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->module_treeview), GTK_TREE_VIEW_COLUMN(modulepath_col));
    i++;

    /* Module button box */
    GtkWidget *module_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[1]), module_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(module_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_module_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(module_button_box), delete_module_button, FALSE, FALSE, 0);
    g_signal_connect(delete_module_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->module_treeview);
    /* Add button */
    GtkWidget *add_module_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(module_button_box), add_module_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_module_button), "clicked", 
                             G_CALLBACK(set_module_type), "module");
    g_signal_connect_swapped(G_OBJECT(add_module_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_module_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(module_button_box), apply_module_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_module_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* MODULES TREEVIEW END */


    /* AddType TREEVIEW BEGIN */
    addtype_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[2]), addtype_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(addtype_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(addtype_scrolled_window, -1, 100);

    widgets->addtype_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->addtype_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->addtype_treeview), GTK_TREE_MODEL(widgets->addtype_store));
    gtk_container_add(GTK_CONTAINER(addtype_scrolled_window), widgets->addtype_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->addtype_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *addtype_col = gtk_tree_view_column_new_with_attributes(_("Application type (AddType)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addtype_treeview), GTK_TREE_VIEW_COLUMN(addtype_col));
    i++;
    GtkTreeViewColumn *addtypemimetype_col = gtk_tree_view_column_new_with_attributes(_("Application mimetypes"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addtype_treeview), GTK_TREE_VIEW_COLUMN(addtypemimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *addtype_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[3]), addtype_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(addtype_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_addtype_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(addtype_button_box), delete_addtype_button, FALSE, FALSE, 0);
    g_signal_connect(delete_addtype_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->addtype_treeview);
    /* Add button */
    GtkWidget *add_addtype_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(addtype_button_box), add_addtype_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_addtype_button), "clicked", 
                             G_CALLBACK(set_module_type), "addtype");
    g_signal_connect_swapped(G_OBJECT(add_addtype_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_addtype_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(addtype_button_box), apply_addtype_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_addtype_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddType TREEVIEW END */


    /* AddHandler TREEVIEW BEGIN */
    addhandler_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[4]), addhandler_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(addhandler_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(addhandler_scrolled_window, -1, 100);

    widgets->addhandler_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->addhandler_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->addhandler_treeview), GTK_TREE_MODEL(widgets->addhandler_store));

    gtk_container_add(GTK_CONTAINER(addhandler_scrolled_window), widgets->addhandler_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->addhandler_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *handlertype_col = gtk_tree_view_column_new_with_attributes(_("Handler type (AddHandler)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addhandler_treeview), GTK_TREE_VIEW_COLUMN(handlertype_col));
    i++;
    GtkTreeViewColumn *handlermimetype_col = gtk_tree_view_column_new_with_attributes(_("Handler function or mimetype"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addhandler_treeview), GTK_TREE_VIEW_COLUMN(handlermimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *addhandler_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[5]), addhandler_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(addhandler_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_addhandler_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(addhandler_button_box), delete_addhandler_button, FALSE, FALSE, 0);
    g_signal_connect(delete_addhandler_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->addhandler_treeview);
    /* Add button */
    GtkWidget *add_addhandler_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(addhandler_button_box), add_addhandler_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_addhandler_button), "clicked", 
                             G_CALLBACK(set_module_type), "addhandler");
    g_signal_connect_swapped(G_OBJECT(add_addhandler_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_addhandler_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(addhandler_button_box), apply_addhandler_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_addhandler_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddHandler TREEVIEW END */


    /* AddEncoding TREEVIEW BEGIN */
    addencoding_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[6]), addencoding_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(addencoding_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(addencoding_scrolled_window, -1, 100);

    widgets->addencoding_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->addencoding_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->addencoding_treeview), GTK_TREE_MODEL(widgets->addencoding_store));

    gtk_container_add(GTK_CONTAINER(addencoding_scrolled_window), widgets->addencoding_treeview);

    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->addencoding_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *encodingtype_col = gtk_tree_view_column_new_with_attributes(_("Encoder type (AddEncoding)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addencoding_treeview), GTK_TREE_VIEW_COLUMN(encodingtype_col));
    i++;
    GtkTreeViewColumn *encodingmimetype_col = gtk_tree_view_column_new_with_attributes(_("Encoder function or mimetype"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addencoding_treeview), GTK_TREE_VIEW_COLUMN(encodingmimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *addencoding_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[7]), addencoding_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(addencoding_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_addencoding_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(addencoding_button_box), delete_addencoding_button, FALSE, FALSE, 0);
    g_signal_connect(delete_addencoding_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->addencoding_treeview);
    /* Add button */
    GtkWidget *add_addencoding_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(addencoding_button_box), add_addencoding_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_addencoding_button), "clicked", 
                             G_CALLBACK(set_module_type), "addencoding");
    g_signal_connect_swapped(G_OBJECT(add_addencoding_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_addencoding_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(addencoding_button_box), apply_addencoding_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_addencoding_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddEncoding TREEVIEW END */

    /* AddLanguage TREEVIEW BEGIN */
    addlanguage_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[8]), addlanguage_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(addlanguage_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(addlanguage_scrolled_window, -1, 100);

    widgets->addlanguage_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->addlanguage_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->addlanguage_treeview), GTK_TREE_MODEL(widgets->addlanguage_store));

    gtk_container_add(GTK_CONTAINER(addlanguage_scrolled_window), widgets->addlanguage_treeview);

    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->addlanguage_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *languagetype_col = gtk_tree_view_column_new_with_attributes(_("Language short name (AddLanguage)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addlanguage_treeview), GTK_TREE_VIEW_COLUMN(languagetype_col));
    i++;
    GtkTreeViewColumn *languagemimetype_col = gtk_tree_view_column_new_with_attributes(_("Language system mimetype"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addlanguage_treeview), GTK_TREE_VIEW_COLUMN(languagemimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *addlanguage_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[9]), addlanguage_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(addlanguage_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_addlanguage_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(addlanguage_button_box), delete_addlanguage_button, FALSE, FALSE, 0);
    g_signal_connect(delete_addlanguage_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->addlanguage_treeview);
    /* Add button */
    GtkWidget *add_addlanguage_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(addlanguage_button_box), add_addlanguage_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_addlanguage_button), "clicked", 
                             G_CALLBACK(set_module_type), "addlanguage");
    g_signal_connect_swapped(G_OBJECT(add_addlanguage_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_addlanguage_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(addlanguage_button_box), apply_addlanguage_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_addlanguage_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddLanguage TREEVIEW END */


    /* AddDescription TREEVIEW BEGIN */
    adddescription_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[10]), adddescription_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(adddescription_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(adddescription_scrolled_window, -1, 100);

    widgets->adddescription_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->adddescription_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->adddescription_treeview), GTK_TREE_MODEL(widgets->adddescription_store));

    gtk_container_add(GTK_CONTAINER(adddescription_scrolled_window), widgets->adddescription_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->adddescription_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *description_col = gtk_tree_view_column_new_with_attributes(_("File description (AddDescription)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->adddescription_treeview), GTK_TREE_VIEW_COLUMN(description_col));
    i++;
    GtkTreeViewColumn *descriptionmimetype_col = gtk_tree_view_column_new_with_attributes(_("Description system mimetype"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->adddescription_treeview), GTK_TREE_VIEW_COLUMN(descriptionmimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *adddescription_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[11]), adddescription_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(adddescription_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_adddescription_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(adddescription_button_box), delete_adddescription_button, FALSE, FALSE, 0);
    g_signal_connect(delete_adddescription_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->adddescription_treeview);
    /* Add button */
    GtkWidget *add_adddescription_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(adddescription_button_box), add_adddescription_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_adddescription_button), "clicked", 
                             G_CALLBACK(set_module_type), "adddescription");
    g_signal_connect_swapped(G_OBJECT(add_adddescription_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_adddescription_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(adddescription_button_box), apply_adddescription_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_adddescription_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddDescription TREEVIEW END */


    /* AddIcon TREEVIEW BEGIN */
    addicon_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[12]), addicon_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(addicon_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(addicon_scrolled_window, -1, 100);

    widgets->addicon_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->addicon_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->addicon_treeview), GTK_TREE_MODEL(widgets->addicon_store));

    gtk_container_add(GTK_CONTAINER(addicon_scrolled_window), widgets->addicon_treeview);

    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->addicon_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *icon_col = gtk_tree_view_column_new_with_attributes(_("Icon file (AddIcon)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addicon_treeview), GTK_TREE_VIEW_COLUMN(icon_col));
    i++;
    GtkTreeViewColumn *iconmimetype_col = gtk_tree_view_column_new_with_attributes(_("Icon system mimetype"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addicon_treeview), GTK_TREE_VIEW_COLUMN(iconmimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *addicon_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[13]), addicon_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(addicon_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_addicon_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(addicon_button_box), delete_addicon_button, FALSE, FALSE, 0);
    g_signal_connect(delete_addicon_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->addicon_treeview);
    /* Add button */
    GtkWidget *add_addicon_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(addicon_button_box), add_addicon_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_addicon_button), "clicked", 
                             G_CALLBACK(set_module_type), "addicon");
    g_signal_connect_swapped(G_OBJECT(add_addicon_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_addicon_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(addicon_button_box), apply_addicon_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_addicon_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddIcon TREEVIEW END */


    /* AddIconByType TREEVIEW BEGIN */
    addiconbytype_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[14]), addiconbytype_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(addiconbytype_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(addiconbytype_scrolled_window, -1, 100);

    widgets->addiconbytype_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->addiconbytype_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->addiconbytype_treeview), GTK_TREE_MODEL(widgets->addiconbytype_store));

    gtk_container_add(GTK_CONTAINER(addiconbytype_scrolled_window), widgets->addiconbytype_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->addiconbytype_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *iconbytype_col = gtk_tree_view_column_new_with_attributes(_("Icon type,file (AddIconByType)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addiconbytype_treeview), GTK_TREE_VIEW_COLUMN(iconbytype_col));
    i++;
    GtkTreeViewColumn *iconbytypemimetype_col = gtk_tree_view_column_new_with_attributes(_("Icon path"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addiconbytype_treeview), GTK_TREE_VIEW_COLUMN(iconbytypemimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *addiconbytype_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[15]), addiconbytype_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(addiconbytype_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_addiconbytype_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(addiconbytype_button_box), delete_addiconbytype_button, FALSE, FALSE, 0);
    g_signal_connect(delete_addiconbytype_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->addiconbytype_treeview);
    /* Add button */
    GtkWidget *add_addiconbytype_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(addiconbytype_button_box), add_addiconbytype_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_addiconbytype_button), "clicked", 
                             G_CALLBACK(set_module_type), "addiconbytype");
    g_signal_connect_swapped(G_OBJECT(add_addiconbytype_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_addiconbytype_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(addiconbytype_button_box), apply_addiconbytype_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_addiconbytype_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddIconByType TREEVIEW END */


    /* AddIconByEncoding TREEVIEW BEGIN */
    addiconbyencoding_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[16]), addiconbyencoding_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(addiconbyencoding_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(addiconbyencoding_scrolled_window, -1, 100);

    widgets->addiconbyencoding_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->addiconbyencoding_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->addiconbyencoding_treeview), GTK_TREE_MODEL(widgets->addiconbyencoding_store));

    gtk_container_add(GTK_CONTAINER(addiconbyencoding_scrolled_window), widgets->addiconbyencoding_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->addiconbyencoding_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *iconbyencoding_col = gtk_tree_view_column_new_with_attributes(_("Icon type,file (AddIconByEncoding)"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addiconbyencoding_treeview), GTK_TREE_VIEW_COLUMN(iconbyencoding_col));
    i++;
    GtkTreeViewColumn *iconbyencodingmimetype_col = gtk_tree_view_column_new_with_attributes(_("Icon path"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->addiconbyencoding_treeview), GTK_TREE_VIEW_COLUMN(iconbyencodingmimetype_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *addiconbyencoding_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[17]), addiconbyencoding_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(addiconbyencoding_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_addiconbyencoding_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(addiconbyencoding_button_box), delete_addiconbyencoding_button, FALSE, FALSE, 0);
    g_signal_connect(delete_addiconbyencoding_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->addiconbyencoding_treeview);
    /* Add button */
    GtkWidget *add_addiconbyencoding_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(addiconbyencoding_button_box), add_addiconbyencoding_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_addiconbyencoding_button), "clicked", 
                             G_CALLBACK(set_module_type), "addiconbyencoding");
    g_signal_connect_swapped(G_OBJECT(add_addiconbyencoding_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_addiconbyencoding_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(addiconbyencoding_button_box), apply_addiconbyencoding_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_addiconbyencoding_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* AddIconByEncoding TREEVIEW END */


    /* Alias TREEVIEW BEGIN */
    alias_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[18]), alias_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(alias_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(alias_scrolled_window, -1, 100);

    widgets->alias_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->alias_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->alias_treeview), GTK_TREE_MODEL(widgets->alias_store));
    gtk_container_add(GTK_CONTAINER(alias_scrolled_window), widgets->alias_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->alias_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *alias_col = gtk_tree_view_column_new_with_attributes(_("Alias"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->alias_treeview), GTK_TREE_VIEW_COLUMN(alias_col));
    i++;
    GtkTreeViewColumn *aliaspath_col = gtk_tree_view_column_new_with_attributes(_("Alias path"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->alias_treeview), GTK_TREE_VIEW_COLUMN(aliaspath_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *alias_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[19]), alias_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(alias_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_alias_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(alias_button_box), delete_alias_button, FALSE, FALSE, 0);
    g_signal_connect(delete_alias_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->alias_treeview);
    /* Add button */
    GtkWidget *add_alias_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(alias_button_box), add_alias_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_alias_button), "clicked", 
                             G_CALLBACK(set_module_type), "alias");
    g_signal_connect_swapped(G_OBJECT(add_alias_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_alias_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(alias_button_box), apply_alias_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_alias_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* Alias TREEVIEW END */


    /* ScriptAlias TREEVIEW BEGIN */
    scriptalias_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[20]), scriptalias_scrolled_window, FALSE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scriptalias_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(scriptalias_scrolled_window, -1, 100);

    widgets->scriptalias_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    widgets->scriptalias_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->scriptalias_treeview), GTK_TREE_MODEL(widgets->scriptalias_store));
    gtk_container_add(GTK_CONTAINER(scriptalias_scrolled_window), widgets->scriptalias_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->scriptalias_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *scriptalias_col = gtk_tree_view_column_new_with_attributes(_("Script alias"), cell[i], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scriptalias_treeview), GTK_TREE_VIEW_COLUMN(scriptalias_col));
    i++;
    GtkTreeViewColumn *scriptaliaspath_col = gtk_tree_view_column_new_with_attributes(_("Script alias path"), cell[i], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scriptalias_treeview), GTK_TREE_VIEW_COLUMN(scriptaliaspath_col));
    i++;

    /* AddType/Application type button box */
    GtkWidget *scriptalias_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[21]), scriptalias_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(scriptalias_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete module button */
    GtkWidget *delete_scriptalias_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(scriptalias_button_box), delete_scriptalias_button, FALSE, FALSE, 0);
    g_signal_connect(delete_scriptalias_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->scriptalias_treeview);
    /* Add module button */
    GtkWidget *add_scriptalias_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(scriptalias_button_box), add_scriptalias_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(add_scriptalias_button), "clicked", 
                             G_CALLBACK(set_module_type), "scriptalias");
    g_signal_connect_swapped(G_OBJECT(add_scriptalias_button), "clicked", 
                             G_CALLBACK(add_module), widgets);
    /* Apply button, saves all module settings */
    GtkWidget *apply_scriptalias_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(scriptalias_button_box), apply_scriptalias_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(apply_scriptalias_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);
    /* ScriptAlias TREEVIEW END */


    /* Connect all cell renderers to the edited signal and callback */
    /* There are 2 cell renderers for each treeview */
    for(i=0; i<NUM_MODULE_CELLS; i++)
    {
        if( i==0 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->module_store);
        }
        if( i==1 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->module_store);
            }
        if( i==2 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->addtype_store);
        }
        if( i==3 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->addtype_store);
        }
        if( i==4 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->addhandler_store);
        }
        if( i==5 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->addhandler_store);
        }
        if( i==6 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->addencoding_store);
        }
        if( i==7 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->addencoding_store);
        }
        if( i==8 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->addlanguage_store);
        }
        if( i==9 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->addlanguage_store);
        }
        if( i==10 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->adddescription_store);
        }
        if( i==11 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->adddescription_store);
        }
        if( i==12 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->addicon_store);
        }
        if( i==13 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->addicon_store);
        }
        if( i==14 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->addiconbytype_store);
        }
        if( i==15 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->addiconbytype_store);
        }
        if( i==16 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->addiconbyencoding_store);
        }
        if( i==17 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->addiconbyencoding_store);
        }
        if( i==18 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->alias_store);
        }
        if( i==19 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->alias_store);
        }
        if( i==20 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(left_cell_edited), widgets->scriptalias_store);
        }
        if( i==21 )
        {
            g_signal_connect(cell[i], "edited",  
                G_CALLBACK(right_cell_edited), widgets->scriptalias_store);
        }
    }

    gtk_widget_show_all(widgets->main_window);

    if( utf8 != NULL )
        g_free(utf8);
}
