/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "functions.h"
#include "create_htaccess_tab.h"
#include "user_treeview_row_clicked.h"
#include "make_settings_buttons.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_checkbuttons.h"
#include "user_handling.h"
#include "functions.h"


#define EXPAND_USER_SECTION FALSE
#define EXPAND_USER_SETTINGS_SECTION FALSE



void create_htaccess_tab(struct w *widgets)
{
    GtkWidget *main_vbox;
    GtkWidget *main_scrolled_window;
    GtkWidget *hbox[4];

    /* For the first treeview */
    GtkWidget *virtual_scrolled_window;
    GtkCellRenderer *virtual_user_cell_renderer;
    GtkWidget *virtual_del_user_button;
    GtkWidget *virtual_add_user_button;
    GtkWidget *virtual_hbuttonbox;
    GtkTreeSelection *virtual_selection;

    /* For the second treeview */
    GtkWidget *htacc_scrolled_window;
    GtkCellRenderer *htacc_user_cell_renderer;
    GtkWidget *htacc_del_user_button;
    GtkWidget *htacc_add_user_button;
    GtkWidget *htacc_hbuttonbox;


    GtkTooltips *tooltips;
    GtkWidget *frame1, *frame2;
    gchar *utf8=NULL;
    int a = 0;
    int b = 1;
    int ent  = 0;

    virtual_hbuttonbox = gtk_hbutton_box_new();
    htacc_hbuttonbox  = gtk_hbutton_box_new();
    tooltips = gtk_tooltips_new();

    /* Create the main scrolled window in the notebook */
    main_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox3), main_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(main_scrolled_window),
                                                        GTK_POLICY_AUTOMATIC,
                                                            GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(main_scrolled_window, -1, 100);

    /* Create a main vbox inside the main scrolled window */
    main_vbox = gtk_vbox_new(FALSE, 0);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(main_scrolled_window), main_vbox);

    /* Pack hboxes into the main vbox */
    hbox[0] = gtk_hbox_new(TRUE, 0);
    gtk_container_add(GTK_CONTAINER(main_vbox), hbox[0]);

    hbox[1] = gtk_hbox_new(TRUE, 0);
    gtk_container_add(GTK_CONTAINER(main_vbox), hbox[1]);

    hbox[2] = gtk_hbox_new(TRUE, 0);
    gtk_container_add(GTK_CONTAINER(main_vbox), hbox[2]);

    hbox[3] = gtk_hbox_new(TRUE, 0);
    gtk_container_add(GTK_CONTAINER(main_vbox), hbox[3]);



// ----------------- HBOX 0 ----------------

    /* Create the global userlist treeview in a scrolled window */
    virtual_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[0]), virtual_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(virtual_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(virtual_scrolled_window, -1, 100);

    widgets->virtual_user_store = gtk_list_store_new(1, G_TYPE_STRING);

    widgets->virtual_user_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->virtual_user_treeview), GTK_TREE_MODEL(widgets->virtual_user_store));

    gtk_container_add(GTK_CONTAINER(virtual_scrolled_window), widgets->virtual_user_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->virtual_user_treeview), TRUE);

    /* Set the column labels in the treeview */
    virtual_user_cell_renderer = gtk_cell_renderer_text_new();

    GtkTreeViewColumn *virtual_user_col = gtk_tree_view_column_new_with_attributes(_("Virtual users"), virtual_user_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->virtual_user_treeview), GTK_TREE_VIEW_COLUMN(virtual_user_col));


    /* FIXME: Selection is multiple */
    virtual_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(widgets->virtual_user_treeview));
    gtk_tree_selection_set_mode(GTK_TREE_SELECTION(virtual_selection), GTK_SELECTION_MULTIPLE);


    g_signal_connect((gpointer)widgets->virtual_user_treeview, "button_press_event",  
		      G_CALLBACK(virtual_user_treeview_row_clicked), widgets);

    frame1 = gtk_frame_new(_("Add and delete virtual users:"));

    widgets->virtual_usr_table = gtk_table_new(NUM_USERTAB_ENTRIES+NUM_USERTAB_SPINBUTTONS+NUM_USERTAB_CHECKBUTTONS+NUM_USERTAB_COMBOS, 2, FALSE);
    gtk_box_pack_start(GTK_BOX(hbox[0]), frame1, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame1), widgets->virtual_usr_table);

    /* Username */	     /* Max length and input 350 chars */
    GtkWidget *username_button;
    widgets->user_set_entry[ent] = gtk_entry_new();
    username_button = make_button_with_entry(GTK_TABLE(widgets->virtual_usr_table),
                        		     widgets->user_set_entry[ent],
                    			     "gtk-refresh",
					     "Username:",
					     "Create a randomized username",
					     0,1,a,b,350);
    a++; b++; ent++;

    g_signal_connect_swapped(G_OBJECT(username_button), "clicked",
			     G_CALLBACK(randomize_username), widgets);

    /* Password  */
    GtkWidget *password_button;
    widgets->user_set_entry[ent] = gtk_entry_new();
    password_button = make_button_with_entry(GTK_TABLE(widgets->virtual_usr_table),
                        		     widgets->user_set_entry[ent],
                    			     "gtk-refresh",
					     "Password:",
					     "Create a randomized password",
					     0,1,a,b,350);
    a++; b++; ent++;

    g_signal_connect_swapped(G_OBJECT(password_button), "clicked",
			     G_CALLBACK(randomize_password), widgets);


    /* The add and delete user buttons */
    virtual_del_user_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    virtual_add_user_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(virtual_hbuttonbox), virtual_del_user_button, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(virtual_hbuttonbox), virtual_add_user_button, TRUE, TRUE, 0);

    g_signal_connect_swapped(G_OBJECT(virtual_del_user_button), "clicked",
			     G_CALLBACK(del_virtual_user), widgets);

    g_signal_connect_swapped(G_OBJECT(virtual_add_user_button), "clicked",
			     G_CALLBACK(add_virtual_user), widgets);
			     
    gtk_table_attach(GTK_TABLE(widgets->virtual_usr_table), virtual_hbuttonbox, 0, 3, a, b, 0, 0, 5, 5);
    a++; b++;
// -----------------------------------------


    a=0; b=1;


// ----------------- HBOX 1 ----------------
    /* Create the htaccess userlist treeview in a scrolled window */
    htacc_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[1]), htacc_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(htacc_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(htacc_scrolled_window, -1, 100);

    widgets->htacc_user_store = gtk_list_store_new(1, G_TYPE_STRING);

    widgets->htacc_user_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->htacc_user_treeview), GTK_TREE_MODEL(widgets->htacc_user_store));

    gtk_container_add(GTK_CONTAINER(htacc_scrolled_window), widgets->htacc_user_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->htacc_user_treeview), TRUE);

    /* Set the column labels in the treeview */
    htacc_user_cell_renderer = gtk_cell_renderer_text_new();

    GtkTreeViewColumn *htacc_user_col = gtk_tree_view_column_new_with_attributes(_("Directory access is limited to these users"), htacc_user_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->htacc_user_treeview), GTK_TREE_VIEW_COLUMN(htacc_user_col));

    g_signal_connect((gpointer)widgets->htacc_user_treeview, "button_press_event",  
		      G_CALLBACK(htacc_user_treeview_row_clicked), widgets);

    gtk_tooltips_set_tip(tooltips, widgets->htacc_user_treeview,
    _("There is no access limitation if no users show for the selected directory."), NULL);


    frame2 = gtk_frame_new(_("User access limitations:"));

    widgets->htacc_usr_table = gtk_table_new(NUM_USERTAB_ENTRIES+NUM_USERTAB_SPINBUTTONS+NUM_USERTAB_CHECKBUTTONS+NUM_USERTAB_COMBOS, 2, FALSE);
    gtk_box_pack_start(GTK_BOX(hbox[1]), frame2, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame2), widgets->htacc_usr_table);

    /* Directory */
    GtkWidget *htacc_dir_button;
    widgets->user_set_entry[ent] = gtk_entry_new();
    htacc_dir_button = make_button_with_entry(GTK_TABLE(widgets->htacc_usr_table),
                        		     widgets->user_set_entry[ent],
                    			     "gtk-refresh",
					     "Directory:",
					     "Select directory to limit access to",
					     0,1,a,b,350);

    /* Set default htaccess directory */
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[2]), HTTPD_DOCUMENT_PATH);

    a++; b++; ent++;

    g_signal_connect_swapped(G_OBJECT(htacc_dir_button), "clicked",
			     G_CALLBACK(show_htacc_dir_sel), widgets);


    /* The add and delete user buttons */
    htacc_del_user_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    htacc_add_user_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(htacc_hbuttonbox), htacc_del_user_button, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(htacc_hbuttonbox), htacc_add_user_button, TRUE, TRUE, 0);

    gtk_tooltips_set_tip(tooltips, htacc_del_user_button,
		_("Delete selected limited user from directory."), NULL);
    gtk_tooltips_set_tip(tooltips, htacc_add_user_button,
		_("Add selected virtual user to directory."), NULL);

    g_signal_connect_swapped(G_OBJECT(htacc_del_user_button), "clicked",
			     G_CALLBACK(del_htacc_user), widgets);

    g_signal_connect_swapped(G_OBJECT(htacc_add_user_button), "clicked",
			     G_CALLBACK(add_htacc_user), widgets);
			     
    gtk_table_attach(GTK_TABLE(widgets->htacc_usr_table), htacc_hbuttonbox, 0, 3, a, b, 0, 0, 5, 5);
    a++; b++;



    gtk_widget_show_all(widgets->main_window);

    if( utf8 != NULL )
        g_free(utf8);
}
