/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "add_server.h"
#include "show_info.h"
#include "populate_servers.h"
#include "populate_module_tab.h"
#include "populate_conf_tab.h"



void add_server(struct w *widgets)
{
    FILE *fp;
    char *server_config;

    if((fp=fopen(HTTPD_CONF, "a"))==NULL)
    {
        printf("Cant write to: %s\n", HTTPD_CONF);
        return;
    }
    
    /* The server configuration to be added */
    server_config = allocate(16384);

    strcpy(server_config, "\n\n<VirtualHost *:80>\n");
    strcat(server_config, "ServerName www.example.org\n");
    strcat(server_config, "DocumentRoot /var/www/www.example.org\n");
    strcat(server_config, "ServerAdmin webmaster@www.example.org\n");
    strcat(server_config, "</VirtualHost>\n");

    fputs(server_config, fp);
    fclose(fp);
    free(server_config);

    /* Repopulate the affected parts of the gui */
    populate_servers(widgets);

    populate_module_tab(widgets);    

    populate_conf_tab(widgets);    
}
