/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "allocate.h"
#include "get_option_pos.h"
#include "add_missing_opts.h"
#include "functions.h"
#include "commented.h"


/* Options to add if missing: [Option - Option value] */
char *opt_list[]={
    "Servername",      "www.example.org",
    "ExtendedStatus",  "On",
    "DefaultLanguage", "en",
    "ServerAdmin", "admin@example.org",
    "AddDefaultCharset", "Off",
    "ServerSignature", "On",
    "ServerTokens", "OS",
    "UseCanonicalName", "On",
NULL};



void add_missing_opts(struct w *widgets)
{
    int i = 0, z = 1;

    for(i=0; opt_list[i]!=NULL; i++)
    {
        if( ! have_option((char *)opt_list[i]) )
        {
            add_option((char *)opt_list[i], (char *)opt_list[z]);
        }
        i++;
        z=z+2;

        /* Failsafe, dont add more then 20 options */
        if( i > 40 )
        {
            printf("Maximum option additions reached.\n");
            break;
        }
    }
}


int have_option(char *option)
{
    FILE *fp;
    long file_size = 0;
    long opt_pos   = 0;
    int i = 0, ret = 0;
    char *line, *opt, *opt1, *p;

    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        return ret;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size+1);
    opt  = allocate(1024);
    opt1 = allocate(1024);

    snprintf(opt1, 1000, "%s", option);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( commented(line) )
            continue;

        opt_pos = get_option_pos(line, 0);
        snprintf(opt, 1000, "%s", &line[opt_pos]);

        for(i=0; opt[i]!='\0'; i++)
        if( opt[i]==' ' || opt[i]=='\n' || opt[i]=='\t')
        {
            opt[i]='\0';
            break;
        }

        for(p = opt; *p!='\0'; ++p)
            *p = tolower(*p);

        for(p = opt1; *p!='\0'; ++p)
            *p = tolower(*p);

        if( strcmp(opt, opt1) == 0 )
        {
            ret = 1;
            break;
        }
    }
    fclose(fp);
    free(line);
    free(opt);
    free(opt1);

    return ret;
}


/* Add options first in the conf */
void add_option(char *option, char *value)
{
    FILE *fp;
    long file_size = 0;
    char *line, *new_conf;

    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        /* Dont show popups */
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line     = allocate(file_size+1);
    new_conf = allocate(file_size+1024);

    snprintf(new_conf, 1000, "%s %s\n", option, value);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
        strcat(new_conf, line);

    fclose(fp);
    free(line);

    if((fp=fopen(HTTPD_CONF, "w+"))==NULL)
    {
        printf("Can not write: %s\n", HTTPD_CONF);
        return;
    }
    fputs(new_conf, fp);
    fclose(fp);
    free(new_conf);
}


/* Add module data last in the conf */
void add_module_data(char *data)
{
    FILE *fp;

    if((fp=fopen(HTTPD_CONF, "a+"))==NULL)
    {
        printf("Can not append to: %s\n", HTTPD_CONF);
        return;
    }
    fputs("\n", fp);
    fputs(data, fp);
    fclose(fp);
}


/* Matches "LoadModule ModuleName" */
int have_module(char *module_name)
{
    FILE *fp;
    long file_size = 0;
    long opt_pos   = 0;
    int i = 0, ret = 0;
    char *line, *opt, *opt1, *p;

    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        return ret;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size+1);
    opt  = allocate(1024);
    opt1 = allocate(1024);

    snprintf(opt1, 1000, "%s", module_name);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( commented(line) )
            continue;

        if( ! cmplowercase(line, "loadmodule ") )
            continue;

        opt_pos = get_option_pos(line, 1);
        snprintf(opt, 1000, "%s", &line[opt_pos]);

        for(i=0; opt[i]!='\0'; i++)
        if( opt[i]==' ' || opt[i]=='\n' || opt[i]=='\t' )
        {
            opt[i]='\0';
            break;
        }

        for(p = opt; *p!='\0'; ++p)
            *p = tolower(*p);

        for(p = opt1; *p!='\0'; ++p)
            *p = tolower(*p);

        if( strcmp(opt, opt1) == 0 )
        {
            ret = 1;
            break;
        }
    }
    fclose(fp);
    free(line);
    free(opt);
    free(opt1);

    return ret;
}


/* Lowercase matches an entire
   line wo leading whitespace */
int have_line(char *input)
{
    FILE *fp;
    long file_size = 0;
    long opt_pos   = 0;
    int i = 0, ret = 0;
    char *line, *opt, *opt1, *p;

    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        return ret;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size+1);
    opt  = allocate(1024);
    opt1 = allocate(1024);

    snprintf(opt1, 1000, "%s", input);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( commented(line) )
            continue;

        opt_pos = get_option_pos(line, 0);
        snprintf(opt, 1000, "%s", &line[opt_pos]);

        for(i=0; opt[i]!='\0'; i++)
        if( opt[i]=='\n' || opt[i]=='\t' )
        {
            opt[i]='\0';
            break;
        }

        for(p = opt; *p!='\0'; ++p)
            *p = tolower(*p);

        for(p = opt1; *p!='\0'; ++p)
            *p = tolower(*p);

        if( strcmp(opt, opt1) == 0 )
        {
            ret = 1;
            break;
        }
    }
    fclose(fp);
    free(line);
    free(opt);
    free(opt1);

    return ret;
}
