/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"

extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];


void select_first_scope(struct w *widgets)
{
    GtkTreePath *path;
    GtkTreeIter iter;
    GtkTreeModel *list_store;
    gchar *nic=NULL, *subnet=NULL, *netmask=NULL;

    path = gtk_tree_path_new_first();

    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(widgets->scope_treeview));

    if( ! gtk_tree_model_get_iter(list_store, &iter, path) )
    {
       gtk_tree_path_free(path);
       return;
    }
    
    gtk_tree_model_get(list_store, &iter, 0, &nic, -1);
    gtk_tree_model_get(list_store, &iter, 1, &subnet, -1);
    gtk_tree_model_get(list_store, &iter, 2, &netmask, -1);

    if( nic==NULL || subnet==NULL || netmask==NULL )
    {
        gtk_tree_path_free(path);
        return;
    }

    snprintf(global_subnet, 1000, "%s", (gchar *)subnet);
    snprintf(global_netmask, 1000, "%s", (gchar *)netmask);
    snprintf(global_nic, 1000, "%s", (gchar *)nic);

    g_free(nic);
    g_free(subnet);
    g_free(netmask);
}
