/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "functions.h"
#include "commented.h"

extern char global_hwaddr[1024];
extern char global_ipaddr[1024];
extern char global_hostname[1024];
extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;


void populate_host_settings(struct w *widgets)
{
    FILE *fp;
    gchar *utf8=NULL;
    char *line, *tmp, *comments;
    long conf_size = 0;
    int i=0, y=0, found_host = 0;
    GtkTextBuffer *textbuffer;
    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();


    /* Populate hostname,ipaddr and hwaddr entries from the global values */
    utf8 = g_locale_to_utf8((char *)global_hostname, strlen(global_hostname), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[0]), utf8);

    utf8 = g_locale_to_utf8((char *)global_ipaddr, strlen(global_ipaddr), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[1]), utf8);

    utf8 = g_locale_to_utf8((char *)global_hwaddr, strlen(global_hwaddr), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[2]), utf8);


    /* Locate and insert the values from the host */
    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
	if( utf8!=NULL )
          g_free(utf8);

        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    tmp  = allocate(MAX_CONF_LINE);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) || strlen(line) < 3 || strlen(line) > MAX_CONF_LINE )
	  continue;

	if( is_selected_host(global_hostname, line) )
	{
	    found_host = 1;
	    break;
	}
    }

    /* Insert the other host values if found */
    if( found_host && conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) || strlen(line) > MAX_CONF_LINE )
	  continue;

	/* Break at host end */
	if( strstr(line, "}") )
	  break;

	remove_semicolon(line);

	if( strstr(line, "default-lease-time") )
	{
    	    sscanf(line, "%*s %s", tmp);
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[3]), utf8);
	}

	if( strstr(line, "max-lease-time") )
	{
	    sscanf(line, "%*s %s", tmp);
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[4]), utf8);
	}

	if(  strstr(line, "option domain-name")
	&& ! strstr(line, "option domain-name-servers") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(tmp, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", tmp);
		 sprintf(line, "%s", tmp);
	      }
	      
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[5]), utf8);
	}

	if( strstr(line, "option subnet-mask") )
	{
	    sscanf(line, "%*s %*s %s", tmp);
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[6]), utf8);
	}

	if( strstr(line, "option broadcast-address") )
	{
	    sscanf(line, "%*s %*s %s", tmp);
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[7]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option routers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(tmp, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[8]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option domain-name-servers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(tmp, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[9]), utf8);
	}

	if( strstr(line, "option nis-domain") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(tmp, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", tmp);
		 sprintf(line, "%s", tmp);
	      }

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[10]), utf8);
	}

	if( strstr(line, "option time-offset") )
	{
	    sscanf(line, "%*s %*s %s", tmp);
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[11]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option ntp-servers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(tmp, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[12]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option netbios-name-servers") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(tmp, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[13]), utf8);
	}

	if( strstr(line, "option T150") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(tmp, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", tmp);
		 sprintf(line, "%s", tmp);
	      }

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[14]), utf8);
	}

	if( strstr(line, "filename") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(tmp, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", tmp);
		 sprintf(line, "%s", tmp);
	      }

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[15]), utf8);
	}

	if( strstr(line, "root-path") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(tmp, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", tmp);
		 sprintf(line, "%s", tmp);
	      }

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[16]), utf8);
	}

	if( strstr(line, "next-server") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(tmp, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", tmp);
		 sprintf(line, "%s", tmp);
	      }

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[17]), utf8);
	}

	if( strstr(line, "x-display-manager") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(tmp, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", tmp);
		 sprintf(line, "%s", tmp);
	      }

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[18]), utf8);
	}
    }

    if( ! found_host )
    {
	/* Clear the host settings entries */
	for(i=0; i < NUM_HOST_SETTINGS; i++)
	   gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[i]), "");

	/* Clear the comment textview */
	textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->host_comment_textview));
	gtk_text_buffer_set_text(textbuffer, "", 0);
    }
    fclose(fp);
    free(line);
    free(tmp);

    /* Populate the host comment textview */
    if( found_host )
    {
	comments = get_comments_for_host(global_hostname);
	utf8 = g_locale_to_utf8(comments, strlen(comments), NULL, NULL, NULL);
	textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->host_comment_textview));
	gtk_text_buffer_set_text(textbuffer, utf8, strlen(utf8));
	if( comments!=NULL )
	  free(comments);
    }

    if( utf8!=NULL )
      g_free(utf8);
}
