/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include "make_settings_textviews.h"


/* Textview in a scrolled window */
GtkWidget *make_textview_with_label(GtkTable *table,
                                 const gchar *label_text,
                                 gint left_attach,
                                 gint right_attach,
                                 gint top_attach,
                                 gint bottom_attach)
{
    GtkWidget *textview;
    GtkWidget *scrolled_window;
    GtkWidget *textview_hbox;
    GtkWidget *label;

    label = gtk_label_new(label_text);

    textview_hbox = gtk_hbox_new(TRUE, 0);

    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(textview_hbox), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), 
                    			        GTK_POLICY_AUTOMATIC, 
		    			        GTK_POLICY_ALWAYS);
    textview = gtk_text_view_new();
    gtk_container_add(GTK_CONTAINER(scrolled_window), textview);

    gtk_table_attach(table, label, left_attach, right_attach, top_attach, bottom_attach, GTK_FILL, GTK_EXPAND, 2, 2);
    gtk_table_attach(table, textview_hbox, left_attach + 1, right_attach + 1, top_attach, bottom_attach, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 20, 2);

    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_misc_set_padding(GTK_MISC(label), 2, 2);

    gtk_widget_show(textview);
    gtk_widget_show(label);
 
    return textview;
}
