/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "gettext.h"
#include "widgets.h"
#include "locate_icons.h"
#include "allocate.h"
#include "functions.h"

/* Use as externs */
char global_netmask[1024]="";
char global_subnet[1024]="";
char global_nic[1024]="";

char global_ipaddr[1024]="";
char global_hwaddr[1024]="";
char global_hostname[1024]="";

int del_row_num=0;
int num_ranges=0;
int activated=0;
int info_window_exit_main=0;

int MAX_CONF_LINE=1024;
int MAX_READ_POPEN=8192;

char LEASE_FILE_BUF[1024]="";
char DHCPD_CONF_BUF[1024]="";

#include "create_main_window.h"
#include "create_scope_tab.h"
#include "create_host_tab.h"
#include "create_lease_tab.h"
#include "create_verify_tab.h"
#include "populate_scope_treeview.h"
#include "populate_scope_settings.h"
#include "select_first_scope.h"
#include "populate_host_treeview.h"
#include "populate_host_settings.h"
#include "select_first_host.h"
#include "populate_leases.h"
#include "add_conf_dialog.h"
#include "populate_ranges.h"
#include "set_num_ranges.h"
#include "status_update.h"
#include "load_settings.h"
#include "gadmin_dhcpd.h"



int main(int argc, char *argv[])
{
    FILE *fp;
    int i = 0;
    gchar *info;

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    gtk_set_locale();
    gtk_init(&argc, &argv);

    wid *widgets = g_malloc (sizeof (wid));

    /* Non root usage */
    if( ! getuid() == 0 )
    {
	/* For setting a different exit method in the info window */
	info_window_exit_main = 1;

        info = g_strdup_printf("You must be root to run: %s\nThis window will close in 10 seconds.\n", PACKAGE);
        show_info(info);
        g_free(info);

	/* Users can close the info window earlier then the timeout */
	for(i=0; i<10; i++)
	{
    	    while(gtk_events_pending())
                  gtk_main_iteration();

	    /* Set when close info window is clicked */
	    if( info_window_exit_main == 2 )
	      break;

    	    usleep(100000*10);
    	}

	g_free(widgets); /* The g_ptr_array has not yet been allocated */
	return 0;
    }

    /* Load saved paths */
    load_settings(widgets);

    /* Use the defined settings if there are no valid settings */
    if( strlen(DHCPD_CONF_BUF) < 5 )
      snprintf(DHCPD_CONF_BUF, 1000, "%s", DHCPD_CONF);

    if( strlen(LEASE_FILE_BUF) < 5 )
      snprintf(LEASE_FILE_BUF, 1000, "%s", LEASE_FILE);

    /* Use command line arguments if we have any */
    if( argc >= 2 )
    {
        if( ! strstr(argv[1], "dhcpd.conf") )
        {
	    printf("Argument 1 should be: /path/to/dhcpd.conf\n");
	    g_free(widgets);
            return 0;
        }
	if( strlen(argv[1]) > 1000 )
	{
	    printf("Argument 1 too long: max 1000 chars\n");
	    g_free(widgets);
	    return 0;
	}
	snprintf(DHCPD_CONF_BUF, 1000, "%s", argv[1]);
    }

    if( argc >= 3 )
    {
        if( ! strstr(argv[2], "dhcpd.leases") )
        {
    	    printf("Argument 2 should be: /path/to/dhcpd.leases\n");
	    g_free(widgets);
	    return 0;
	}
	if( strlen(argv[2]) > 1000 )
	{
	    printf("Argument too long: max 1000 chars\n");
	    g_free(widgets);
	    return 0;
	}
	snprintf(LEASE_FILE_BUF, 1000, "%s", argv[2]);
    }


    create_main_window(widgets);

    create_scope_tab(widgets);

    create_host_tab(widgets);

    create_lease_tab(widgets);

    create_verify_tab(widgets);

    /* Pointer arrays for the dynamic range widgets */
    widgets->ranges_hbox_array = g_ptr_array_new();
    widgets->ranges_from_entry_array = g_ptr_array_new();
    widgets->ranges_to_entry_array = g_ptr_array_new();
    widgets->ranges_del_button_array = g_ptr_array_new();

    gtk_widget_show_all(widgets->main_window);

    /* Populate the scope treeview */
    populate_scope_treeview(widgets);
    select_first_scope(widgets);

    /* Populate scope ranges */
    set_num_ranges();
    populate_ranges(widgets, global_nic, global_subnet, global_netmask);

    /* Populate the scope settings */
    populate_scope_settings(widgets);

    /* Populate the host treeview */
    populate_host_treeview(widgets);
    select_first_host(widgets);

    populate_host_settings(widgets);

    /* Populate leases */
    populate_leases(widgets);

    /* Start the online/offline timer */
    gtk_timeout_add(1000, (GtkFunction) status_update, widgets);

    /* Show add new conf dialog if dhcpd.conf is missing */
    if( ! file_exists(DHCPD_CONF_BUF) )
        add_conf_dialog(widgets);           

    /* If the file exists but doesnt have some required options, add them */
    if( file_exists(DHCPD_CONF_BUF) )
        add_missing_values(DHCPD_CONF_BUF);  

    /* DHCPD requires dhcpd.leases to start. Add if valid path and missing. */
    if( ! file_exists(LEASE_FILE_BUF)
    && LEASE_FILE_BUF != NULL
    && strlen(LEASE_FILE_BUF) > 5 )
    {
	if((fp=fopen(LEASE_FILE_BUF, "w+"))==NULL)
	{
    	    printf("Error: couldnt write a new dhcpd.leases file here: %s\n", LEASE_FILE_BUF);
	}
	else
	  {
	     fclose(fp);
	     printf("An empty dhcpd.leases file was created here: %s\n", LEASE_FILE_BUF);
	  }
    }

    /* Window (x) close button */
    g_signal_connect(GTK_OBJECT(widgets->main_window), "destroy",
                    	     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    /* Start the main loop */
    gtk_main();

    g_ptr_array_free(widgets->ranges_hbox_array, TRUE);
    g_ptr_array_free(widgets->ranges_from_entry_array, TRUE);
    g_ptr_array_free(widgets->ranges_to_entry_array, TRUE);
    g_ptr_array_free(widgets->ranges_del_button_array, TRUE);
    g_free(widgets);

    return 0;
}
