/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "populate_leases.h"
#include "clear_leases.h"


#define NUM_LEASE_COLS 12


void create_lease_tab(struct w *widgets)
{
    /* Create the leases treeview in a scrolled window */
    GtkCellRenderer *cell_renderer;
    GtkWidget *hbox, *scrolled_window;
    GtkWidget *hbuttonbox, *clear_button, *update_button;
    GtkWidget *extended_leases_button;
    GtkTreeViewColumn *col[NUM_LEASE_COLS];
    int i = 0;

    GtkTooltips *tooltips = gtk_tooltips_new();
    
    hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox3), hbox, TRUE, TRUE, 0);

    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						        GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(scrolled_window, -1, 140);

    widgets->lease_store = gtk_list_store_new(NUM_LEASE_COLS,
				 G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
                                 G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
                                 G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
				 G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->lease_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->lease_treeview),
				GTK_TREE_MODEL(widgets->lease_store));

    gtk_container_add(GTK_CONTAINER(scrolled_window), widgets->lease_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->lease_treeview), TRUE);

    /* Set the column labels in the treeview */
    cell_renderer = gtk_cell_renderer_text_new();

    col[0] = gtk_tree_view_column_new_with_attributes(_("Status"), 
				    cell_renderer, "text", 0, NULL);
    col[1] = gtk_tree_view_column_new_with_attributes(_("IP-Address"), 
					cell_renderer, "text", 1, NULL);
    col[2] = gtk_tree_view_column_new_with_attributes(_("Hardware-Type"), 
						cell_renderer, "text", 2, NULL);
    col[3] = gtk_tree_view_column_new_with_attributes(_("Hardware-Address"), 
						cell_renderer, "text", 3, NULL);
    col[4] = gtk_tree_view_column_new_with_attributes(_("Hostname"), 
						cell_renderer, "text", 4, NULL);
    col[5] = gtk_tree_view_column_new_with_attributes(_("Starts"), 
						cell_renderer, "text", 5, NULL);
    col[6] = gtk_tree_view_column_new_with_attributes(_("Ends"), 
						cell_renderer, "text", 6, NULL);
    col[7] = gtk_tree_view_column_new_with_attributes(_("Next binding state"), 
						cell_renderer, "text", 7, NULL);
    col[8] = gtk_tree_view_column_new_with_attributes(_("CLTT"), 
						cell_renderer, "text", 8, NULL);
    col[9] = gtk_tree_view_column_new_with_attributes(_("TSTP"), 
						cell_renderer, "text", 9, NULL);
    col[10] = gtk_tree_view_column_new_with_attributes(_("TSFP"), 
						cell_renderer, "text", 10, NULL);
    col[11] = gtk_tree_view_column_new_with_attributes(_("UUID"), 
						cell_renderer, "text", 11, NULL);
    for(i=0; i < NUM_LEASE_COLS; i++)
    {
        gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->lease_treeview),
    						GTK_TREE_VIEW_COLUMN(col[i]));
	/* Make the treeview sortable */
	gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(col[i]), i);
    }

    /* The leases clear show extended and update buttons */
    hbuttonbox = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox3), hbuttonbox, FALSE, TRUE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_SPREAD);

    /* Clear button */
    clear_button = gtk_button_new();
    gtk_tooltips_set_tip(tooltips, clear_button,
                _("Delete all leases from the lease file."), NULL);
    GtkWidget *alignment2 = gtk_alignment_new(0.5, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(clear_button), alignment2);
    GtkWidget *hbox2 = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(alignment2), hbox2);
    GtkWidget *image2 = gtk_image_new_from_stock("gtk-delete", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start(GTK_BOX(hbox2), image2, FALSE, FALSE, 0);
    GtkWidget *label2 = gtk_label_new_with_mnemonic(_("Delete all"));
    gtk_box_pack_start(GTK_BOX(hbox2), label2, FALSE, FALSE, 0);
    gtk_label_set_justify(GTK_LABEL(label2), GTK_JUSTIFY_LEFT);
    gtk_container_add(GTK_CONTAINER(hbuttonbox), clear_button);
    g_signal_connect_swapped(G_OBJECT(clear_button), "clicked", 
                             G_CALLBACK(clear_leases), widgets);

    /* Show extended leases button */
    extended_leases_button = gtk_button_new();
    gtk_tooltips_set_tip(tooltips, extended_leases_button,
                _("Show extended lease information."), NULL);
    GtkWidget *alignment1 = gtk_alignment_new(0.5, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(extended_leases_button), alignment1);
    GtkWidget *hbox1 = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(alignment1), hbox1);
    GtkWidget *image1 = gtk_image_new_from_stock("gtk-find", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start(GTK_BOX(hbox1), image1, FALSE, FALSE, 0);
    GtkWidget *label1 = gtk_label_new_with_mnemonic(_("Extended information"));
    gtk_box_pack_start(GTK_BOX(hbox1), label1, FALSE, FALSE, 0);
    gtk_label_set_justify(GTK_LABEL(label1), GTK_JUSTIFY_LEFT);
    gtk_container_add(GTK_CONTAINER(hbuttonbox), extended_leases_button);
    g_signal_connect_swapped(G_OBJECT(extended_leases_button), "clicked", 
                             G_CALLBACK(show_extended_leases), widgets);

    /* Update button */
    update_button = gtk_button_new_from_stock(GTK_STOCK_REFRESH);
    gtk_container_add(GTK_CONTAINER(hbuttonbox), update_button);
    g_signal_connect_swapped(G_OBJECT(update_button), "clicked", 
                             G_CALLBACK(populate_leases), widgets);
}

