/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "delete_host_from_btn.h"
#include "add_host.h"
#include "apply_host_settings.h"
#include "host_treeview_row_clicked.h"
#include "create_host_set_entries.h"



void create_host_tab(struct w *widgets)
{
    GtkCellRenderer *cell_host_renderer;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    /* Create the hosts treeview in a scrolled window */
    GtkWidget *treeview_vbox = gtk_vbox_new(FALSE, 0);

    /* Add the host treeview to the first stretchable vpaned widget */
    GtkWidget *vpaned = gtk_vpaned_new();
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox2), vpaned, TRUE, TRUE, 0);
    gtk_paned_pack1(GTK_PANED(vpaned), treeview_vbox, 1, 1);

    GtkWidget *host_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(treeview_vbox), host_scrolled_window, TRUE, TRUE, 0);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(host_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Set the size */
    gtk_widget_set_size_request(host_scrolled_window, -1, 30);

    widgets->host_store = gtk_list_store_new(3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->host_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->host_treeview), GTK_TREE_MODEL(widgets->host_store));

    gtk_container_add(GTK_CONTAINER(host_scrolled_window), widgets->host_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->host_treeview), TRUE);

    /* Set the column labels in the treeview */
    cell_host_renderer = gtk_cell_renderer_text_new();

    GtkTreeViewColumn *host_hostname_col = gtk_tree_view_column_new_with_attributes(_("Hostname to assign"), 
									    cell_host_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->host_treeview), GTK_TREE_VIEW_COLUMN(host_hostname_col));

    GtkTreeViewColumn *host_ipaddr_col = gtk_tree_view_column_new_with_attributes(_("IP-address to assign"), 
									    cell_host_renderer, "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->host_treeview), GTK_TREE_VIEW_COLUMN(host_ipaddr_col));


    GtkTreeViewColumn *host_hwaddr_col = gtk_tree_view_column_new_with_attributes(_("Client hardware address"), 
									    cell_host_renderer, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->host_treeview), GTK_TREE_VIEW_COLUMN(host_hwaddr_col));

    /* Make the treeview sortable */
    gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(host_hostname_col), 0);
    gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(host_ipaddr_col), 1);
    gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(host_hwaddr_col), 2);

    g_signal_connect((gpointer)widgets->host_treeview, "button-press-event", 
		    		G_CALLBACK(host_treeview_row_clicked), widgets);

    GtkWidget *add_del_hbox = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(treeview_vbox), add_del_hbox, FALSE, FALSE, 0);

    /* Entries for adding a new host */
    widgets->host_add_hostname_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), widgets->host_add_hostname_entry, TRUE, TRUE, 0);
    gtk_widget_set_size_request(widgets->host_add_hostname_entry, 120, -1);
    gtk_tooltips_set_tip(tooltips, widgets->host_add_hostname_entry, _("Computer name"), NULL);

    widgets->host_add_ipaddr_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), widgets->host_add_ipaddr_entry, TRUE, TRUE, 0);
    gtk_widget_set_size_request(widgets->host_add_ipaddr_entry, 110, -1);
    gtk_tooltips_set_tip(tooltips, widgets->host_add_ipaddr_entry, "192.168.0.254", NULL);

    widgets->host_add_hwaddr_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), widgets->host_add_hwaddr_entry, TRUE, TRUE, 0);
    gtk_widget_set_size_request(widgets->host_add_hwaddr_entry, 120, -1);
    gtk_tooltips_set_tip(tooltips, widgets->host_add_hwaddr_entry, "00:20:ED:58:78:96", NULL);


    /* A hbutton box for the add, apply and delete host buttons */
    GtkWidget *host_add_hbuttonbox = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), host_add_hbuttonbox, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(host_add_hbuttonbox), GTK_BUTTONBOX_SPREAD);

    /* The add host button */
    GtkWidget *host_add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_container_add(GTK_CONTAINER(host_add_hbuttonbox), host_add_button);
    g_signal_connect_swapped(G_OBJECT(host_add_button), "clicked", 
                            	     G_CALLBACK(add_host), widgets);

    GtkWidget *host_spacer_label_add2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(add_del_hbox), host_spacer_label_add2, FALSE, FALSE, 2);

    /* The delete host button */
    GtkWidget *host_del_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_tooltips_set_tip(tooltips, host_del_button, _("Delete the selected host."), NULL);
    gtk_container_add(GTK_CONTAINER(host_add_hbuttonbox), host_del_button);
    g_signal_connect_swapped(G_OBJECT(host_del_button), "clicked", 
                         G_CALLBACK(delete_host_from_btn), widgets);

    GtkWidget *host_spacer_label_del2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(add_del_hbox), host_spacer_label_del2, FALSE, FALSE, 7);

    /* The apply host button */
    GtkWidget *host_apply_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_container_add(GTK_CONTAINER(host_add_hbuttonbox), host_apply_button);
    g_signal_connect_swapped(G_OBJECT(host_apply_button), "clicked", 
                                     G_CALLBACK(apply_host_settings), widgets);


    /* Host settings vbox */
    widgets->host_set_vbox = gtk_vbox_new(TRUE, 0);

    /* Add the host settings to the second stretchable vpaned widget */
    gtk_paned_pack2(GTK_PANED(vpaned), widgets->host_set_vbox, 1, 1);

    GtkWidget *host_set_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(widgets->host_set_vbox), host_set_scrolled_window, TRUE, TRUE, 0);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(host_set_scrolled_window), 
								GTK_POLICY_AUTOMATIC, 
								GTK_POLICY_ALWAYS);
    widgets->host_set_viewport = gtk_viewport_new(NULL, NULL);
    gtk_container_add(GTK_CONTAINER(host_set_scrolled_window), widgets->host_set_viewport);

    widgets->host_set_scrolled_vbox = gtk_vbox_new(TRUE, 0);
    gtk_container_add(GTK_CONTAINER(widgets->host_set_viewport), widgets->host_set_scrolled_vbox);

    create_host_set_entries(widgets);

    gtk_widget_show_all(widgets->main_window);
}
