/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "reread_conf.h"
#include "allocate.h"
#include "show_info.h"
#include "clear_ptr_array.h"
#include "set_num_ranges.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"
#include "failover_functions.h"


extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];

extern char DHCPD_CONF_BUF[1024];



void add_range(struct w *widgets)
{
    FILE *fp;
    long conf_size = 0;
    int range_added = 0;
    int range_found = 0;
    int nic_found = 0;
    int have_failover = 0;
    char *line;
    char *new_conf;
    gchar *range_line, *info;
    G_CONST_RETURN gchar *range_from;
    G_CONST_RETURN gchar *range_to;

    /* Check if this is subnet has a failover declaration */
    gchar *nic = g_strdup_printf("%s", global_nic);
    gchar *subnet = g_strdup_printf("%s", global_subnet);
    gchar *netmask = g_strdup_printf("%s", global_netmask);

    have_failover = failover_exists(nic, subnet, netmask);

    g_free(nic);
    g_free(subnet);
    g_free(netmask);

    /* get the ranges from the entries */
    range_from = gtk_entry_get_text(GTK_ENTRY(widgets->ranges_add_from_entry));
    range_to = gtk_entry_get_text(GTK_ENTRY(widgets->ranges_add_to_entry));

    if( strlen(range_from) < 7 )
    {
       info = g_strdup_printf(_("The range from IP-address is too short, the range was not added.\n"));
       show_info(info);
       g_free(info);
       return;
    }

    if( strlen(range_to) < 7 )
    {
       info = g_strdup_printf(_("The range to IP-address is too short, the range was not added.\n"));
       show_info(info);
       g_free(info);
       return;
    }

    /* 3 different styles \n{ or .20{ or .20 { */
    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", global_subnet, global_netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", global_subnet, global_netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", global_subnet, global_netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", global_nic);

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt open dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    /* If this range already exists, dont add it */
    range_line = g_strdup_printf("range %s %s;\n", range_from, range_to);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    nic_found = 1;
		    break;
		}
	    }
	    
	    if( nic_found )
	    {
		nic_found = 0;
		while(fgets(line, conf_size, fp)!=NULL)
		{
		    if( strstr(line, range_line) && ! strstr(line, "#") )
		    {
		        range_found = 1;
			break;
		    }
		}
	    }
	}
    }
    g_free(range_line);
    
    if( range_found )
    {
	fclose(fp);
	free(line);
	g_free(scope_line1);
	g_free(scope_line2);
	g_free(scope_line3);
	g_free(nic_line);

	info = g_strdup_printf(_("The range already exists, the range was not added.\n"));
	show_info(info);
	g_free(info);
	return;
    }


    /* Widget range limited anti-overflow */
    new_conf = allocate(conf_size+1024);


    /* Add the range */
    rewind(fp);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    strcat(new_conf, line);    
	
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		strcat(new_conf, line);
		
		/* Adds a new range after the interface line if its not a failover configuration */
		if( strstr(line, nic_line) && ! have_failover && ! strstr(line, "#") )
		{
		    range_added = 1;
		    /* Cosmetics and readability. */
		    strcat(new_conf, "    range ");
		    strcat(new_conf, range_from);
		    strcat(new_conf, " ");
		    strcat(new_conf, range_to);
		    strcat(new_conf, ";\n");
		    break;
		}

		/* Adds a new range after the dynamic bootp line if its a failover configuration. */
		if( strstr(line, "deny dynamic bootp clients") && have_failover && ! strstr(line, "#") )  
		{
		    range_added = 1;
		    /* Cosmetics and readability. */
		    strcat(new_conf, "        range ");
		    strcat(new_conf, range_from);
		    strcat(new_conf, " ");
		    strcat(new_conf, range_to);
		    strcat(new_conf, ";\n");
		    break;
		}
	    }
	}
	else
	  strcat(new_conf, line);
    }
    fclose(fp);
    free(line);
    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
    g_free(nic_line);


    if( range_added )
    {
	if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
	{
    	    printf("Could not write dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
	    free(new_conf);
    	    return;
	}
        fputs(new_conf, fp);
	fclose(fp);
    }
    free(new_conf);


    if( range_added )
    {
	clear_ptr_array(widgets);
	set_num_ranges();
	populate_ranges(widgets, global_nic, global_subnet, global_netmask);
	populate_scope_settings(widgets);

	reread_conf();
    }
    else
      {
         info = g_strdup_printf(_("The scope was not found, could not add the new range.\n"));
         show_info(info);
         g_free(info);
      }
}
