%define desktop_vendor magnus-swe@telia.com
%{!?_dist: %{expand: %%define dist rhfc14}}

Summary:	GADMIN-DHCPD -- A GTK+ administation tool for the ISC DHCPD server.
Name:		gadmin-dhcpd
Version:	0.5.2
Release:	0.1.%{dist}.nr
License:	GPL
Group:		Applications/System
URL:		http://mange.dynalias.org/linux.html
Source0:	http://mange.dynalias.org/linux/%{name}/%{name}-%{version}.tar.gz
BuildRoot:	%{_builddir}/%{name}-%{version}-root
Provides:	gadmin-dhcpd

%description
GADMIN-DHCPD is a fast and easy to use GTK+ administration tool for the ISC DHCPD server.

%prep
%setup -q
%configure \
DHCPD_CONF="/etc/dhcp/dhcpd.conf" \
LEASE_FILE="/var/lib/dhcpd/dhcpd.leases" \
SYSINIT_START_CMD="chkconfig dhcpd on" \
SYSINIT_STOP_CMD="chkconfig dhcpd off"

%build
%{__make}

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall INSTALL_USER=`id -un` INSTALL_GROUP=`id -gn`

# pam auth
install -d %{buildroot}%{_sysconfdir}/pam.d/
install -d %{buildroot}%{_sysconfdir}/security/console.apps
install -m 644 etc/pam.d/%{name} %{buildroot}%{_sysconfdir}/pam.d/%{name}
install -m 644 etc/security/console.apps/%{name} %{buildroot}%{_sysconfdir}/security/console.apps/%{name}

# desktop entry
install -d %{buildroot}%{_datadir}/applications
install -m 644 desktop/gadmin-dhcpd.desktop %{buildroot}%{_datadir}/applications/%{desktop_vendor}-%{name}.desktop

# docs wo version information
install -d %{buildroot}%{_datadir}/doc/%{name}
install -m 644 README COPYING AUTHORS ChangeLog %{buildroot}%{_datadir}/doc/%{name}/

%find_lang %name

%post 
if test ! -h %{_bindir}/gadmin-dhcpd; then \
ln -s %{_bindir}/consolehelper %{_bindir}/gadmin-dhcpd ; \
fi;

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(0755, root, root)
%{_sbindir}/%{name}

%defattr(0644, root, root)

%{_datadir}/doc/%{name}/README
%{_datadir}/doc/%{name}/COPYING
%{_datadir}/doc/%{name}/AUTHORS
%{_datadir}/doc/%{name}/ChangeLog
%{_sysconfdir}/pam.d/%{name}
%{_sysconfdir}/security/console.apps/%{name}
%{_datadir}/applications/%{desktop_vendor}-%{name}.desktop
%{_datadir}/pixmaps/*.png
%dir %{_datadir}/pixmaps/%{name}
%{_datadir}/pixmaps/%{name}/*.png

%changelog
* Mon Jan 17 2011 Magnus-swe <magnus-swe@telia.com>
- Fixed populating extended leases with pools.
- Adds stricter settings checks.
- Deprecates ddns-update-style: Ad-hoc.
* Wed Jan 12 2011 Magnus-swe <magnus-swe@telia.com>
- Adds better lease treeview populating code.
- Adds extended lease view.
- Updates Swedish translation.
* Sat Jan 8 2011 Magnus-swe <magnus-swe@telia.com>
- Shows leases in a sortable treeview with one line per host.
- Verify command fixes. Converts sv.po to utf-8 and updates it.
* Sat Mar 27 2010 Magnus-swe <magnus-swe@telia.com>
- Selects scopes and sets ranges properly at startup.
* Tue Mar 15 2010 Magnus-swe <magnus-swe@telia.com>
- Adds draggable vpaned widgets for hosts, scopes and ranges.
- The settings window opens regardless if the conf file exists.
* Tue Nov 17 2009 Magnus-swe <magnus-swe@telia.com>
- Using comments in loadbalancer pools within scopes now works.
- After applying a primary loadbalancer a secondary-adapted dhcpd.conf
- can be uploaded via SCP to a remote secondary loadbalancing server.
- A command entry is available so that remote dhcp servers
- can be restarted after recieving a dhcpd.conf update.
- The default command works on Ubuntu 9.10 and Fedora:
- "/etc/init.d/dhcp* restart".
* Fri Sep 18 2009 Magnus-swe <magnus-swe@telia.com>
- Fixed adding missing global options.
* Sat Aug 8 2009 Magnus-swe <magnus-swe@telia.com>
- Added per scope and host commentability.
- Treeview sorting can now be done.
- Stricter parsing of single hosts.
- Sets status color and missing server color.
- Added options next-server and x-display-manager. 
- Added global options:
- allow booting;
- deny unknown-clients;
- not / authoritative;
- default-lease-time 604800;
- option ip-forwarding false;
- option mask-supplier false;
- (Thanks to Navy.mil)
* Fri Jun 6 2008 Magnus-swe <magnus-swe@telia.com>
- Added option root-path.
* Fri Mar 7 2008 Magnus-swe <magnus-swe@telia.com>
- Fixed applying pools.
- Groundwork for loadbalance updates via ssh.
- Desktop filename changed.
