/****************************************************************************************/
/*  					Sim51 Source Code : funcs3.c					    */
/****************************************************************************************/
/* You are free to modify,change and redistribute this source code of Sim51 only if you */
/* agree to share those changes and modifications with me and of course, you must also  */
/* mention my name as the original author of this program 'Sim51'. That's a very small  */
/* favour I am asking in return for more than 4000 free lines of hard written code.     */
/****************************************************************************************/
#include"headers.c"
#include"vars.c"
#include<time.h>
#define printf printw
#define scanf scanw
#define strcmpi strcasecmp
//extern struct instruct;
//extern char tclk;
//extern struct instruct instructions[256];
int i=-16;
int ii=-16;
void cls();
void show_regs(char);
void rw_pc();
void rw_sp();
void rw_dp();
void rw_a();
void rw_b();
void rw_psw();
void rw_p0();
void rw_p1();
void rw_p2();
void rw_p3();
void rw_ip();
void rw_ie();
void rw_tm();
void rw_tc();
void rw_th0();
void rw_th1();
void rw_tl0();
void rw_tl1();
void rw_sc();
void rw_sb();
void rw_pcn();
void rw_em();
void rw_ex();
extern void load_hex_file(char *);

void take_snapshot(char *);
void load_snapfile(char *);

			/* prototype declaration of */
void data_dump();       /* all required functions */
void code_dump(char*,char);
void extern_data_dump(char*,char);
void display_help();
void input_hex();
void execute_code(char*,char);
void trace_code(char*,char);
void unassemble(char*,char);
void decode_and_simulate(int);
void proceed_execution();
//void vector_to_interrupt();

void display_shell()
{
 char ch,command[10],temp[10],temp2[10];
 int c,d,s,pos,hex_bkp;
 //time_t *t;
 //initscr();
 printf("\rgSim51>");
 //printf("\r-");  //old style prompt...
 refresh();
 fflush(stdin);
	getstr(command);
	printf("\n");
	if(strlen(command)==0)
	  display_shell();
	else
	   {              //this stage removes all intervening spaces..
	      pos=0;
	      d=0;
	      do
		{
		 if(isspace(command[pos]))
		   pos++;
		 else
		    {
		      temp2[d]=command[pos];
		      if(command[pos]=='\0')
			   break;
		      pos++;
		      d++;
		    }
		}while(1);

 strcpy(command,temp2);

 if((command[0]=='c' && command[1]=='d')||(command[0]=='C' && command[1]=='D'))
    {
      if(strlen(command)==2)
	 code_dump("0",0);
      else
      {
	s=2;
	d=0;
      do
	{
	  temp[d]=command[s];
	  if(command[s]=='\0')
	    break;
	  d++;
	  s++;
	}while(1);
    code_dump(temp,1);

     }

}

else
   if((command[0]=='x' && command[1]=='d')||(command[0]=='X' && command[1]=='D'))
     {
       if(strlen(command)==2)
           extern_data_dump("0",0);
      else
      {
	s=2;
	d=0;
      do
	{
	  temp[d]=command[s];
	  if(command[s]=='\0')
	    break;
	  d++;
	  s++;
	}while(1);
    extern_data_dump(temp,1);

     }

}



else
       if((command[0]=='t')||(command[0]=='T'))
    {
      if(strlen(command)==1)
	 trace_code("0",0);   //no arg
      else
      {
	s=1;         // make this equal to no. of chars in the command
	d=0;
      do
	{
	  temp[d]=command[s];
	  if(command[s]=='\0')
	    break;
	  d++;
	  s++;
	}while(1);
    trace_code(temp,1);  //arg supplied

      }

  }


else
    if((command[0]=='u')||(command[0]=='U'))
    {
      if(strlen(command)==1)
	 unassemble("0",0);   //no arg
      else
      {
	s=1;         // make this equal to no. of chars in the command
	d=0;
      do
	{
	  temp[d]=command[s];
	  if(command[s]=='\0')
	    break;
	  d++;
	  s++;
	}while(1);
      unassemble(temp,1);  //arg supplied

      }

  }



else
    if((command[0]=='g')||(command[0]=='G'))
    {
      if(strlen(command)==1)
	 execute_code("0",0);   //no arg
      else
      {
	s=1;         // make this equal to no. of chars in the command
	d=0;
      do
	{
	  temp[d]=command[s];
	  if(command[s]=='\0')
	    break;
	  d++;
	  s++;
	}while(1);
      execute_code(temp,1);  //arg supplied

      }

  }






else
    if((command[0]=='b')||(command[0]=='B'))
    {
      if(strlen(command)==1)
       set_break_point(PC);  //no arg
       //	 set_break_point("0",0);   //no arg
      else
      {
	s=1;         // make this equal to no. of chars in the command
	d=0;
      do
	{
	  temp[d]=command[s];
	  if(command[s]=='\0')
	    break;
	  d++;
	  s++;
	}while(1);

   sscanf(temp,"%X",&hex_bkp);
   set_break_point(hex_bkp);  //arg supplied
   //   set_break_point(temp,1);  //arg supplied

      }

  }

else
if(!strcmp("lf",command))  {
printf("Enter hex file to load:");
scanf("%s",temp);
load_hex_file(temp);
}

else
if(!strcmp("s",command))  {

	//time(time_);
	
	printf("Enter name of snapshot file:");
	scanf("%s",temp);
	take_snapshot(temp);

}

else
if(!strcmp("ls",command))  {
printf("Enter snapshot file to load:");
scanf("%s",temp);
load_snapfile(temp);
}

else
   if(!strcmpi("lb",command))     /* show all breakpoints*/
   {
      int c=0;
      //for(c=0;c<bkp_no;c++)
      //while(break_points[c]!=-1 && c<=bkp_no)
      while(c<bkp_no)
       {
	 if(break_points[c] != -1)
	 {
		 printf("Breakpoint %d : PC=%X\n\r",c,break_points[c]);
	         refresh();
	 }
	 else
	    if(break_points[c] == -1)
	   {
		printf("Breakpoint %d : Removed\n\r",c);
		refresh();
	   }
	 c++;

       }
      display_shell();
      //show_regs('0');
   }

else
   if(!strcmpi("rbp",command))     /* remove a particular breakpoint*/
   {
     char sbkp[6];
     int rbkp;
     printf("Remove Breakpoint no. [0-%d]?:",bkp_no-1);
     refresh();
     getstr(sbkp);
     sscanf(sbkp,"%X",&rbkp);
     break_points[rbkp] = -1;
     printf("Breakpoint no. %d removed.\n\r",rbkp);
     refresh();
     display_shell();
   }

else
   if(!strcmpi("p",command))     /* proceed or step over a subroutine */
   {
      proceed_execution();
      //show_regs('0');
   }

else
   if(!strcmpi("v",command))     /* vector to a particular interrupt*/
   {
      vector_to_interrupt();

   }

else
   if(!strcmpi("r",command))     /* show all registers*/
   {
      show_regs('0');
   }
else
   if (!strcmpi("rpc",command))  /* read and write the program counter*/
     {
	rw_pc();
     }
else
   if (!strcmpi("rdp",command)) /*read and write the data pointer*/
     {
       rw_dp();
     }
else
   if(!strcmpi("rsp",command)) /*read and write the stack pointer*/
     {
       rw_sp();
     }


else
   if(!strcmpi("ra",command)) /*read and write the Accumulator...*/
     {
       rw_a();
     }


else
   if(!strcmpi("rb",command)) /*read and write the B register...*/
     {
       rw_b();
     }

else
   if(!strcmpi("rpsw",command)) /*read and write the PSW*/
     {
       rw_psw();
     }

else
   if(!strcmpi("rp0",command)) /*read and write port0*/
     {
       rw_p0();
     }

else
   if(!strcmpi("rp1",command)) /*read and write the port1*/
     {
       rw_p1();
     }

else
   if(!strcmpi("rp2",command)) /*read and write the port2*/
     {
       rw_p2();
     }


else
   if(!strcmpi("rp3",command)) /*read and write the port3*/
     {
       rw_p3();
     }

else
   if(!strcmpi("rip",command)) /*read and write the IP register...*/
     {
       rw_ip();
     }

else
   if(!strcmpi("rie",command)) /*read and write the interrupt enable reg...*/
     {
       rw_ie();
     }


else
   if(!strcmpi("rtm",command)) /*read and write the TMOD reg...*/
     {
       rw_tm();
     }


else
   if(!strcmpi("rtc",command)) /*read and write the TCON reg...*/
     {
       rw_tc();
     }


else
   if(!strcmpi("rth0",command)) /*read and write the TH0 reg...*/
     {
       rw_th0();
     }


else
   if(!strcmpi("rth1",command)) /*read and write the TH1 reg...*/
     {
       rw_th1();
     }


else
   if(!strcmpi("rtl0",command)) /*read and write the TL0 reg...*/
     {
       rw_tl0();
     }


else
   if(!strcmpi("rtl1",command)) /*read and write the TL1 reg...*/
     {
       rw_tl1();
     }


else
   if(!strcmpi("rsc",command)) /*read and write the SCON reg...*/
     {
       rw_sc();
     }


else
   if(!strcmpi("rsb",command)) /*read and write the SBUF reg...*/
     {
       rw_sb();
     }


else
   if(!strcmpi("rpcn",command)) /*read and write the PCON reg...*/
     {
       rw_pcn();
     }


else
   if(!strcmpi("em",command)) /*edit a location in RAM...*/
     {
       rw_em();
     }
else
   if(!strcmpi("ex",command)) /*edit a location in RAM...*/
     {
       rw_ex();
     }




else
   if(!strcmpi("cls",command)) /*edit a location in RAM...*/
     {
       cls();
     }


 // if (!strcmpi("u",command)) /*unassemble 128 bytes,starting from */
			    /*the current value of program counter*/
 //   {
  //    unassemble();  /*this function is defined in the decoder.c src file*/
  //  }
else
   if(!strcmpi("dd",command)) /* data dump of RAM area*/
    {
       data_dump();
    }

//  if (!strcmpi("cd",command)) /* code dump of ROM area*/
 /*   {
      code_dump(0);
    }  */
else
   if(!strcmpi("?",command))  /* a help menu of all possible commands*/
    {
      display_help();
    }
else
   if (!strcmpi("i",command)) /* prompt to take hex input from user*/
    {
       input_hex();
       display_shell();
    }
//else
 //  if (!strcmpi("g",command)) /* execute the code starting from current */
 //   {                       /* value of the program counter */
/*      execute_code();
      display_shell();
    }  */
//  if(!strcmpi("t",command)) /* trace the execution of code starting from */
  // {                        /* current value of the program counter */
  //   trace_code();
 //  }


else
   if(!strcmpi("q",command)) /*quitting cleanly....*/
    {
       //wclear(stdscr);
	werase(stdscr);
       endwin();
	system("clear");
       exit(0);
    }

else
   if (!strcmpi("!",command)) /* Opening a sub-shell */
    {
       
	if(fork()==0)
	    execl("/bin/bash","bash",NULL);
	else
		
	    wait((int*)NULL);	
	//input_hex();
       	display_shell();
	
    }



else
  {
   printf("Unrecognized Command!!\n\r");
   refresh();
   display_shell();
  }

}

//endwin();

}

void show_regs(char flag)
 {
   //printf("in show regs!!");
   //PSW=0xdd;
 /*  printf("%d",(PSW & 0x80)>>7);   */
   //flushall();


if(flag=='7')      //called via r...so no clk is reqd...
     {
   printf("A=%.2x  B=%.2x  PC=%.4x  PSW=%.2x  SP=%.2x  DPTR=%.4x\
   P0=%.2x  P1=%.2x  P2=%.2x  P3=%.2x      IP=%.2x  IE=%.2x TMOD=%.2x\
   TCON=%.2x  TH0=%.2x  TL0=%.2x  TH1=%.2x  TL1=%.2x  SCON=%.2x\n\r\
  SBUF=%.2x  PCON=%.2x                CY=%d  AC=%d  RS1=%d\
  RS0=%d  OV=%d  P=%d  CLK=%d",A&0x00ff,B&0x00ff,PC&0xffff,PSW&0x00ff,SP&0x00ff,DPH * 0x100 + DPL/*DPTR&0xffff*/,P0&0x00ff,P1&0x00ff,P2&0x00ff,P3&0x00ff,IP&0x00ff,\
   IE&0x00ff,TMOD&0x00ff,TCON&0x00ff,TH0&0x00ff,TL0&0x00ff,TH1&0x00ff,TL1&0x00ff,SCON&0x00ff,SBUF&0x00ff,PCON&0x00ff,((PSW & 0x80)>>7),\
   ((PSW & 0x40)>>6),((PSW & 0x10)>>4),((PSW & 0x08)>>3),((PSW & 0x04)>>2),\
   (PSW & 0x01),tclk );
   //((PSW & 0x10)>>4),((PSW & 0x08)>>3),((PSW & 0x04)>>2),(PSW & 0x01));
   printf("\n\r");
   refresh();
   disassemble_code(PC,1);

   if (go_flag==0)        // in case it is due to a 'go' command...
      display_shell();

      }

   if(flag=='1')       //called from trace...so clk is reqd..
   {
    printf("A=%.2x  B=%.2x  PC=%.4x  PSW=%.2x  SP=%.2x  DPTR=%.4x\
   P0=%.2x  P1=%.2x  P2=%.2x  P3=%.2x      IP=%.2x  IE=%.2x TMOD=%.2x\
   TCON=%.2x  TH0=%.2x  TL0=%.2x  TH1=%.2x  TL1=%.2x  SCON=%.2x\n\r\
SBUF=%.2x  PCON=%.2x                 CY=%d  AC=%d  RS1=%d\
  RS0=%d  OV=%d  P=%d  CLK=%d",A&0x00ff,B&0x00ff,PC&0xffff,PSW&0x00ff,SP&0x00ff,DPH * 0x100 + DPL/*DPTR&0xffff*/,P0&0x00ff,P1&0x00ff,P2&0x00ff,P3&0x00ff,IP&0x00ff,\
   IE&0x00ff,TMOD&0x00ff,TCON&0x00ff,TH0&0x00ff,TL0&0x00ff,TH1&0x00ff,TL1&0x00ff,SCON&0x00ff,SBUF&0x00ff,PCON&0x00ff,((PSW & 0x80)>>7),\
   ((PSW & 0x40)>>6),((PSW & 0x10)>>4),((PSW & 0x08)>>3),((PSW & 0x04)>>2),\
   (PSW & 0x01),tclk );
   //((PSW & 0x10)>>4),((PSW & 0x08)>>3),((PSW & 0x04)>>2),(PSW & 0x01));
   printf("\n\r");
   refresh();
   disassemble_code(PC,1);

   if (go_flag==0)        // in case it is due to a 'go' command...
      display_shell();
   }

   else if(flag=='0')      //called via r...so no clk is reqd...
      {

 /* printf("A=%.2x  B=%.2x  PC=%.4x  PSW=%.2x  SP=%.2x  DPTR=%.4x\
   P0=%.2x  P1=%.2x  P2=%.2x  P3=%.2x      IP=%.2x  IE=%.2x TMOD=%.2x\
   TCON=%.2x  TH0=%.2x  TL0=%.2x  TH1=%.2x  TL1=%.2x  SCON=%.2x\n\r\
SBUF=%.2x  PCON=%.2x                    CY=%d  AC=%d  RS1=%d\
  RS0=%d  OV=%d  P=%d ",A,B,PC,PSW,SP,DPH * 0x100 + DPL,P0,P1,P2,P3,IP,\
   IE,TMOD,TCON,TH0,TL0,TH1,TL1,SCON,SBUF,PCON,((PSW & 0x80)>>7),\
   ((PSW & 0x40)>>6),((PSW & 0x10)>>4),((PSW & 0x08)>>3),((PSW & 0x04)>>2),\
   (PSW & 0x01));  */

   printf("A=%.2x  B=%.2x  PC=%.4x  PSW=%.2x  SP=%.2x  DPTR=%.4x\
   P0=%.2x  P1=%.2x  P2=%.2x  P3=%.2x      IP=%.2x  IE=%.2x TMOD=%.2x\
   TCON=%.2x  TH0=%.2x  TL0=%.2x  TH1=%.2x  TL1=%.2x  SCON=%.2x\n\r\
SBUF=%.2x  PCON=%.2x                 CY=%d  AC=%d  RS1=%d\
  RS0=%d  OV=%d  P=%d ",A&0x00ff,B&0x00ff,PC&0xffff,PSW&0x00ff,SP&0x00ff,DPH * 0x100 + DPL,P0&0x00ff,P1&0x00ff,P2&0x00ff,P3&0x00ff,IP&0x00ff,\
   IE&0x00ff,TMOD&0x00ff,TCON&0x00ff,TH0&0x00ff,TL0&0x00ff,TH1&0x00ff,TL1&0x00ff,SCON&0x00ff,SBUF&0x00ff,PCON&0x00ff,((PSW & 0x80)>>7),\
   ((PSW & 0x40)>>6),((PSW & 0x10)>>4),((PSW & 0x08)>>3),((PSW & 0x04)>>2),\
   (PSW & 0x01) );

//   ((PSW & 0x10)>>4),((PSW & 0x08)>>3),((PSW & 0x04)>>2),(PSW & 0x01));
   printf("\n\r");
   refresh();
   disassemble_code(PC,1);

   display_shell();

      }






 }

void rw_pc()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("PC=%x\n\r:",PC);
  refresh();
  scanf("%x",&PC);
  display_shell();

 }

void rw_sp()
 {
  unsigned int temp1;	 
  //unsigned char temp1,temp2;
  //temp1=DPL;	//to save DPH and DPL which disappear mysteriously
  //temp2=DPH;    //whenever this function is called...
  printf("SP=%x\n\r:",SP);
  refresh();
  scanf("%x",&temp1);
  SP=(unsigned char)temp1;
  //DPL=temp1;
  //DPH=temp2; 
  display_shell();


 }

void rw_dp()
 {
  unsigned int temp1;	 
  unsigned int tempDPTR;
  //printf("inside rw_dp!!");
  printf("DPTR=%x\n\r:",DPH * 0x100 + DPL);
  refresh();
  scanf("%x",&tempDPTR);
  RAM[0X82] = (unsigned char)(tempDPTR & 0x00ff);
  RAM[0X83] = (unsigned char)( (tempDPTR>>8) & 0x00ff );
  display_shell();

 }


void rw_a()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("A=%x\n\r:",A);
  refresh();
  scanf("%x",&temp1);
  A=(unsigned char)temp1;
  display_shell();

 }


void rw_b()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("B=%x\n\r:",B);
  refresh();
  scanf("%x",&temp1);
  B=(unsigned char)temp1;
  display_shell();

 }

void rw_psw()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("PSW=%x\n\r:",PSW);
  refresh();
  scanf("%x",&temp1);
  
  PSW=(unsigned char)temp1;
  display_shell();

 }


void rw_p0()
 {
  
  unsigned int temp1;
  printf("P0=%x\n\r:",P0);
  refresh();
  scanf("%x",&temp1);      //scanf takes in an integer in hex format...
  P0=(unsigned char)temp1; //which needs to be type casted *BEFORE* assignment...so that value does not get written over 
  display_shell(); 	   //adjacent location... this works and does not destroy adjacent SFR when neighbouring SFR is updated...
  			   // cmanta ;)	 
 } 


void rw_p1()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("P1=%x\n\r:",P1);
  refresh();
  scanf("%x",&temp1);
  P1=(unsigned char)temp1;
  display_shell();

 }


void rw_p2()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("P2=%x\n\r:",P2);
  scanf("%x",&temp1);
  P2=(unsigned char)temp1;
  display_shell();

 }

void rw_p3()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("P3=%x\n\r:",P3);
  refresh();
  scanf("%x",&temp1);
  P3=(unsigned char)temp1;
  display_shell();

 }


void rw_ie()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("IE=%x\n\r:",IE);
  refresh();
  scanf("%x",&temp1);
  IE=(unsigned char)temp1;
  display_shell();

 }


void rw_ip()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("IP=%x\n\r:",IP);
  refresh();
  scanf("%x",&temp1);
  IP=(unsigned char)temp1;
  display_shell();

 }

void rw_tm()
 {
  unsigned int temp1;	 
  //printf("inside rw_pc!!");
  printf("TMOD=%x\n\r:",TMOD);
  refresh();
  scanf("%x",&temp1);
  TMOD=(unsigned char)temp1;
  display_shell();

 }

void rw_tc()
 {
  unsigned int temp1;	 
 //printf("inside rw_pc!!");
  printf("TCON=%x\n\r:",TCON);
  refresh();
  scanf("%x",&temp1);
  TCON=(unsigned char) temp1;
  display_shell();

 }


void rw_th0()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("TH0=%x\n\r:",TH0);
  refresh();
  scanf("%x",&temp1);
  TH0=(unsigned char)temp1;
  display_shell();

 }


void rw_th1()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("TH1=%x\n\r:",TH1);
  refresh();
  scanf("%x",&temp1);
  TH1=(unsigned char)temp1;
  display_shell();

 }

void rw_tl0()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("TL0=%x\n\r:",TL0);
  refresh();
  scanf("%x",&temp1);
  TL0=(unsigned char)temp1;
  display_shell();

 }

void rw_tl1()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("TL1=%x\n\r:",TL1);
  refresh();
  scanf("%x",&temp1);
  TL1=(unsigned char)temp1;
  display_shell();

 }


void rw_sc()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("SCON=%x\n\r:",SCON);
  refresh();
  scanf("%.2x",&temp1);
  SCON=(unsigned char)temp1;
  display_shell();

 }


void rw_sb()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("SBUF=%x\n\r:",SBUF);
  refresh();
  scanf("%.2x",&temp1);
  SBUF=(unsigned char)temp1;
  display_shell();

 }


void rw_pcn()
 {
  unsigned int temp1;	 
   //printf("inside rw_pc!!");
  printf("PCON=%x\n\r:",PCON);
  refresh();
  scanf("%x",&temp1);
  PCON=(unsigned char)temp1;
  display_shell();

 }


void rw_em()
 {
   //printf("inside rw_pc!!");
  unsigned int addr;
  unsigned int data;
  printf("Enter address of location to edit:");
  refresh();
  scanf("%X",&addr);
  printf("RAM[%.4X]=%.2X\n\r:",addr,RAM[addr]);
  scanf("%X",&data);
  RAM[addr]=(unsigned char)data;
  display_shell();

 }

void rw_ex()
 {
   //printf("inside rw_pc!!");
  unsigned int addr;
  unsigned int data;
  printf("Enter address of external data to edit:");
  refresh();
  scanf("%X",&addr);
  printf("XDATA[%.4X]=%.2X\n\r:",addr,XDATA[addr]);
  scanf("%X",&data);
  //sscanf(XDATA+addr,"%2x",&data);
  //*(XDATA+addr)=(unsigned char)data;
  //XDATA[0]=23;
  display_shell();

 }


void cls()
 {
   clear();
   //clrscr();
   display_shell();
 }


void data_dump()
 {
   static int k=0;
   static int kount=0;
   int i=0;
   //printf("inside data_dump()!!");
  /* for(i=0;i<128;i++)
	RAM[i]=i;     // just testing RAM...
    RAM[124]=0xee;
    RAM[0]=0xff;   */
   for(i=0;i<128;i+=16)
     {
       //kount++;
       printf("%.4x:  ",i);
       refresh();
  for(;k<16+kount*16;k++)
	 {

	    if((k%8)==0 && ((k%16)))
	      {
		printf(" -  ");
	      }
	    printf("%.2x ",RAM[k]);
	 }
       printf("\n\r");
     refresh();
  if(k==128)
	{
	  kount=0;
	  k=0;
	  //i=0;
	}
     else
	  kount++;

     }

 display_shell();

 }

void code_dump(char *n,char flag)
 {

   unsigned int temp,start;
   unsigned static int count=0,t=0;
   unsigned int j;
sscanf(n,"%x",&start);
if(start==0 && flag==0)     /*flag=0 -> no arg.*/
    ;
    //i=-16;                  /*flag=1 -> arg. supplied*/
if(start==0 && flag==1)
    i=-16;

temp=start;
  start=(start/16)*16;
if(start==0 && (temp<=15) && (flag==1))
	 i=-16;
if(!(start==0))
      i=start-16;
   
if(i==0xfff0)
	   i=-16;


  i+=16;
  
  for(;i<=0xffff;i++)
     {
      if((i%16)==0)
	 {
	   printf("%.4x:  ",i);
	   refresh();
  	   t++;
	   //count++;
	   //for(j=i;j<=(0xf+0x10*(count));j++)
	    for(j=i;j<=(0xf+i);j++)
	     {
	       if((j%8)==0 && ((j%16)))
		    printf(" -  ");
	       if(j>=temp)
		  printf("%.2x ",ROM[j]);
	       else
		  printf("   ");
		  refresh();

	     }

	   printf("\n\r");
	   refresh();
  	   if((t%8)==0)
	     {
	       display_shell();
	     }

	  count++;
	  }

	 
     if(i==0xffff)
	     i=-16;
     
     }
display_shell();

 }


void  extern_data_dump(char *n,char flag)
 {

   unsigned int temp,start;
   unsigned static int count=0,t=0;
   unsigned int j;
sscanf(n,"%x",&start);
if(start==0 && flag==0)     /*flag=0 -> no arg.*/
    ;
    //i=-16;                  /*flag=1 -> arg. supplied*/
if(start==0 && flag==1)
    ii=-16;

temp=start;
  start=(start/16)*16;
if(start==0 && (temp<=15) && (flag==1))
	 ii=-16;
if(!(start==0))
      ii=start-16;
   
if(ii==0xfff0)
	   ii=-16;


  ii+=16;
      for(;ii<=0xffff;ii++)
     {
      if((ii%16)==0)
	 {
	   printf("%.4x:  ",ii);
	   refresh();
  	   t++;
	   //count++;
	   //for(j=i;j<=(0xf+0x10*(count));j++)
	    for(j=ii;j<=(0xf+ii);j++)
	     {
	       if((j%8)==0 && ((j%16)))
		    printf(" -  ");
	       if(j>=temp)
		  printf("%.2x ",ROM[j]);
	       else
		  printf("   ");
		  refresh();

	     }

	   printf("\n\r");
	   refresh();
  	   if((t%8)==0)
	     {
	       display_shell();
	     }

	  count++;
	  }

	 
     if(ii==0xffff)
	     ii=-16;
     
     }
display_shell();

 }









void display_help()
 {
   int chr,nl=0;
   char line[100]={0};
   FILE *fp;
   clear();
   //clrscr();
   if ( (fp=fopen("sim51.hlp","r"))==NULL)
     {
       printf("Help file not found!!\n\r\n\r");
       refresh();
     }
   else
      {
	//system("less sim51.hlp");
	while( (chr=fgetc(fp))!=EOF )
	//while( (fgets(line,100,fp)) )
	  {
	    if(chr=='\n')
	      nl++;

	    if( (nl%24)==0 && nl!=0  )
	      {
		printf("\n\rPress any key...");
		refresh();
  		getch();
		printf("\r                 "); //to remove the extra line
		refresh();
  		//clrscr();
		nl++;
		//nl=1;
		fflush(stdin);
	      }
		addch((chtype)chr);
		//printf("%c",chr);
	       //addch(chr);
	       //refresh();
	    //fputc(chr,stdout);


	  }
refresh();
      }




  display_shell();

   //printf("inside display_help()!!");
 }

void input_hex()
 {
   //printf("inside input_hex()!!");
   static int loc,d;
   static unsigned char v;
   char s[4];
   printf(":");
   refresh();
   scanf("%x",&loc);
   
   fflush(stdin);
   for(;;) //loc++)
    {
      printf("%.4x: ",loc);
      refresh();
      getstr(s);
      if(strlen(s)==0)
	break;
      else    {
	 d = loc;
	 sscanf(s,"%x",&v);
	 loc = d ;
	 ROM[loc] = v;
      	 loc++;
      
      }

    }

 display_shell();
 fflush(stdin);
 }

void execute_code(char *n,char flag)
 {
   int count=0,ins=-1,start;  //ins is set to -1 to distinguish between
   char str[6];               // no arg. and intentional 0 arg...
   go_flag=1;
   sscanf(n,"%x",&start);

   if(flag==0)   //means no arg, has been given...
       {
	 printf("Execute how many instructions[default=5]?:\n\r");
	 refresh();
  	 getstr(str);
	 sscanf(str,"%x",&ins);
	 if(ins==-1)
	   ins = 5;       //setting default value...

       }

   else
       if(flag==1)    //means arg has been supplied...
	 ins = start;
   //do



    while (count<ins)
      {
	     count++;
    //	if(  (check_for_bkpoint(PC))==1  && (ins==1)  )  //means no bkpoint...
   //	  {
	     sprintf(str,"%X",PC);  //to convet a string into a hex value..
	     trace_code(str,1);  // arg supplied....
	     printf("\n\r");
       //	  }	//printf("hello\n\r");
	//count++;
    //  else
     //	 if(  (check_for_bkpoint(PC))==1  && ( ins>1 )     )  //  means bkpoint...
      //	  {
      //	     printf("Stopped execution at break point PC=%X\n\r",PC);
	 	     refresh();

                     //display_shell();

       //	  }


      } //while (count<ins);
    go_flag=0;
    //strcpy(command,"");
    display_shell();
   //printf("inside execute_code()!!");
 }


/*void proceed_execution()
 {
    unsigned int initPC,finalPC;
    char str[6];
    //if(instructions[ROM[PC]].nobytes==1)
       finalPC = PC + instructions[ROM[PC]].nobytes;
       go_flag=1;
       while(PC != finalPC)
	 {
	   //go_flag=1;
	   sprintf(str,"%X",PC);
	   trace_code(str,1);  // arg supplied....
	   printf("\n\r");
	   refresh();

	 }
      go_flag=0;
      display_shell();
 }*/

void trace_code(char *n,char flag)
 {
   int temp,start;
   char foo_flag;
   sscanf(n,"%x",&start);
   if(flag==0)     //flag=0 -> no arg.,start tracing from
     {                             //current value of PC
	if( (check_for_bkpoint(PC))==1 && go_flag==1)   //means bkpoint...
	   {
	    printf("Stopped execution at break point PC=%X\n\r",PC);
	    refresh();

	    display_shell();
	   }

	else
	   //if( (check_for_bkpoint(PC))==0)   //means no bkpoint...*/
	       decode_and_simulate(PC);
     }
   else
     {
			//else flag=1 -> arg. is starting point of trace*/

      foo_flag = check_for_bkpoint(start);

      //if( (check_for_bkpoint(start))==1 && go_flag==1)   //means bkpoint...
	  if( (foo_flag == 1)  &&  (go_flag==1)  )
	   {
	     printf("Stopped execution at break point PC=%X\n\r",PC);
	     refresh();
  	     go_flag = 0;   //resetting go_flag again for next cycle...
	     display_shell();
	   }


	else
	   //if( (check_for_bkpoint(start))==0  && flag==1)   //means no bkpoint... */
	      decode_and_simulate(start);

     }





  /*int temp,start;
   static int count=0,t=0;
   int j;
sscanf(n,"%x",&start);
if(start==0 && flag==1)     //flag=1 -> no arg.
    i=-16;                  //flag=0 -> arg. supplied
temp=start;
  start=(start/16)*16;
if(start==0 && (temp<=15))
	 i=-16;
if(!(start==0))
      i=start-16;
   i+=16;
   for(;i<0xfff;i++)
     {
      if((i%16)==0)
	 {
	   printf("%.4x:  ",i);
	   refresh();
  	   t++;
	   //count++;
	   //for(j=i;j<=(0xf+0x10*(count));j++)
	    for(j=i;j<=(0xf+i);j++)
	     {
	       if((j%8)==0 && ((j%16)))
		    printf(" -  ");
	       if(j>=temp)
		  {
 			printf("%.2x ",ROM[j]);
			refresh();
  		  }
	       else
		  {
                    printf("   ");
			refresh();
  		  }

	     }

	   printf("\n\r");
	   refresh();

           if((t%8)==0)
	     {
	       display_shell();
	     }

	  count++;
	  }

	 }   */
if(go_flag==0)
  display_shell();



   //printf("inside trace_code()!!");
 }

void take_snapshot(char *snap_file)
{
	FILE *fp;
	unsigned int i;
	char *timestr;
	time_t t;
	t=time(&t);
	timestr=ctime(&t);
	timestr[strlen(timestr)-1]='\0';
	printf("\nSnapshot saved in file %s on %s...\n",snap_file,timestr);
	
	fp=fopen(snap_file,"w");
	fprintf(fp,"# \'%s\' : Snapshot file generated automagically by gSim51 on %s...\n\n",snap_file,timestr);
	//time(t);
	//perror("time");
	//timestring=ctime(t);
	//perror("puts");	
	fprintf(fp,"\n\n# Section for RAM area of 8051...\n\n[RAM]\n");
	
	fprintf(fp,"PC=%.4X\n",PC);
	for(i=0;i<=0xff;i++) {
		if(RAM[i]) {
			fprintf(fp,"%.2X=%.2X\n",i,RAM[i]);
		}
	}
		
	
	
	
	
	fprintf(fp,"\n# Section for ROM area of 8051...\n\n[ROM]\n");
	for(i=0;i<=0xffff;i++) {
		if(ROM[i]) {
			fprintf(fp,"%.2X=%.2X\n",i,ROM[i]);
		}
	}

	
	/*  fprintf(fp,"SERIAL=YES\n");   //enable only when serial port is supported...
	fprintf(fp,"SERIAL_FILE=%s\n",serial_file);  */
	
	fprintf(fp,"\n\n# End of Snapshot file \'%s\'...\n\n",snap_file);
	
	fclose(fp);
	
	display_shell();


}

void load_snapfile(char *snapfile)
{
	FILE *fp;
	unsigned int i,val,loc;
	char buff[80],tempbuff[6],j,RAM_flag=0,ROM_flag=0;
	fp=fopen(snapfile,"r");
	while(fgets(buff,80,fp))	
	{
		if( buff[0]!='#'&& buff[0]=='[' &&  buff[0]!= '\n' )  {
		strcpy(tempbuff,buff);
		tempbuff[5]='\0';
		if(!strcmp(tempbuff,"[RAM]"))   {
				RAM_flag=1;	
				ROM_flag=0;
				//printf("it is RAM!\n");  //fill ur RAM here...
				//refresh();  
		//		continue;
				
		
		}
			
		if(!strcmp(tempbuff,"[ROM]"))   {
				ROM_flag=1;
				RAM_flag=0;
				//printf("it is ROM!\n");  //fill ur ROM here...
				//refresh();
		//		continue;
			
		}


	}
			
		if( (buff[0]>=0x30 && buff[0]<=0x39 ) || (buff[0]>=0x41 && buff[0]<=0x46) || (buff[0]=='P'&& buff[1]=='C') )
		{
		
		if(buff[0]=='P' && buff[1]=='C')
			{
				sscanf(buff,"PC=%4X",&val);
				PC=val;
			}
		else
			{
						
			  sscanf(buff,"%X=%2X",&loc,&val);	

			if(RAM_flag)
				RAM[loc]=val;
			if(ROM_flag)
				ROM[loc]=val;
			}	

		

		}		
		
		
		
		
			
		//printf("%s",buff);
		refresh();
	}
		
		/*{
		
		
		//strcpy(tempbuff,buff);
		j=buff[0];
		if(j=='#')  
		  ;
		else
		{
			
			if(j=='[')  {
			strcpy(tempbuff,buff);
			tempbuff[6]='\0';		
			if(!strcmp(tempbuff,"[RAM]"))
				printf("Bingo!!\n");
			}
				
			//printf("%s",buff);
		
		
		}
		
	}*/

display_shell();
}
