/****************************************************************************************/
/*  					Sim51 Source Code : Decoder.c					    */
/****************************************************************************************/
/* You are free to modify,change and redistribute this source code of Sim51 only if you */
/* agree to share those changes and modifications with me and of course, you must also  */
/* mention my name as the original author of this program 'Sim51'. That's a very small  */
/* favour I am asking in return for more than 4000 free lines of hard written code.     */
/****************************************************************************************/

#include"headers.c"
#include"vars.c"
//#define A RAM[0xE0]
#define truncA (A=A & 0x00ff)
//extern unsigned char *RAM;
extern unsigned char RAM[256];
//char tlck;
char flag=0;
char test_for_carry(unsigned char op1,unsigned char op2,unsigned char pos);
void set_flags(unsigned int,unsigned char,unsigned char,unsigned char);
unsigned char count_no_of_ones(unsigned char val);

void nop_isr(int);
void ajmp_isr(int);
void ljmp_isr(int);
void jmpdptr_isr(int opcode);
void rr_isr(int);
void inc_dec_isr(int);
void jbc_isr(int opcode);
void acall_isr(int opcode);
void lcall_isr(int opcode);
void rrc_isr(int opcode);
void rlc_isr(int opcode);
void jb_isr(int opcode);
void ret_isr(int opcode);
void reti_isr(int opcode);
void rl_isr(int opcode);
void add_isr(int opcode);
void addc_isr(int opcode);
void daa_isr(int opcode);
void mov_isr(int opcode);
void orl_isr(int opcode);
void orlc_isr(int opcode);
void anl_isr(int opcode);
void anlc_isr(int opcode);
void xrl_isr(int opcode);
void push_isr(int opcode);
void pop_isr(int opcode);
void djnz_isr(int opcode);
void cjne_isr(int opcode);
void xch_isr(int opcode);
void xchd_isr(int opcode);
void subb_isr(int opcode);
void clra_isr(int opcode);
void cpla_isr(int opcode);
void swapa_isr(int opcode);
void setb_isr(int opcode);
void clr_isr(int opcode);
void cpl_isr(int opcode);
void incdptr_isr(int opcode);
void jz_isr(int opcode);
void jnz_isr(int opdcode);
void sjmp_isr(int opcode);
void jnb_isr(int opcode);
void jc_isr(int opcode);
void jnc_isr(int opcode);
void mulab_isr(int opcode);
void divab_isr(int opcode);

void dummy_isr(int opcode);
int get_current_reg_bank();
void unassemble(char*,char);
void disassemble_code(int,char);
void set_break_point(unsigned int);
char check_for_bkpoint(unsigned int pcval);
void vector_to_interrupt();
void reset_memory();


struct instruct
 {
   int hex_code;
   const char *mnemonic;
   int nobytes;
   int clock;
   //int noperands;
   void (*ins_ptr)(int);
};

   //struct instruct instructions;
  struct instruct instructions[]={
					   {0X0,"NOP",1,12,nop_isr},   //
					   {0X1,"AJMP ",2,24,ajmp_isr},
					   {0X2,"LJMP",3,24,ljmp_isr}, //
					   {0X3,"RR A",1,12,rr_isr}, //
					   {0X4,"INC A",1,12,inc_dec_isr},//
/*'X' denotes dummy args. for simulator*/  {0X5,"INC ",2,12,inc_dec_isr},//
 /*A means address,*/			   {0X6,"INC @R0",1,12,inc_dec_isr},//
 /*D means data*/			   {0X7,"INC @R1",1,12,inc_dec_isr},//
 /*C means code*/			   {0X8,"INC R0",1,12,inc_dec_isr}, //
					   {0X9,"INC R1",1,12,inc_dec_isr}, //
					   {0XA,"INC R2",1,12,inc_dec_isr},//
					   {0XB,"INC R3",1,12,inc_dec_isr}, //
					   {0XC,"INC R4",1,12,inc_dec_isr}, //
					   {0XD,"INC R5",1,12,inc_dec_isr},  //
					   {0XE,"INC R6",1,12,inc_dec_isr},//
					   {0XF,"INC R7",1,12,inc_dec_isr}, //
					   {0X10,"JBC ",3,24,jbc_isr},
					   {0X11,"ACALL ",2,24,acall_isr},
					   {0X12,"LCALL",3,24,lcall_isr},
					   {0X13,"RRC A",1,12,rrc_isr},  //
					   {0X14,"DEC A",1,12,inc_dec_isr}, //
					   {0X15,"DEC ",2,12,inc_dec_isr},    //
					   {0X16,"DEC @R0",1,12,inc_dec_isr},   //
					   {0X17,"DEC @R1",1,12,inc_dec_isr},  //
					   {0X18,"DEC R0",1,12,inc_dec_isr}, //
					   {0X19,"DEC R1",1,12,inc_dec_isr}, //
					   {0X1A,"DEC R2",1,12,inc_dec_isr}, //
					   {0X1B,"DEC R3",1,12,inc_dec_isr}, //
					   {0X1C,"DEC R4",1,12,inc_dec_isr}, //
					   {0X1D,"DEC R5",1,12,inc_dec_isr}, //
					   {0X1E,"DEC R6",1,12,inc_dec_isr}, //
					   {0X1F,"DEC R7",1,12,inc_dec_isr}, //
					   {0X20,"JB ",3,24,jb_isr},
					   {0X21,"AJMP ",2,24,ajmp_isr},
					   {0X22,"RET",1,24,ret_isr},
					   {0X23,"RL A",1,12,rl_isr}, //
					   {0X24,"ADD A,#",2,12,add_isr}, //
					   {0X25,"ADD A,",2,12,add_isr}, //
					   {0X26,"ADD A,@R0 ",1,12,add_isr}, //
					   {0X27,"ADD A,@R1 ",1,12,add_isr}, //
					   {0X28,"ADD A,R0",1,12,add_isr}, //
					   {0X29,"ADD A,R1",1,12,add_isr},//
					   {0X2A,"ADD A,R2",1,12,add_isr}, //
					   {0X2B,"ADD A,R3",1,12,add_isr},//
					   {0X2C,"ADD A,R4",1,12,add_isr}, //
					   {0X2D,"ADD A,R5",1,12,add_isr}, //
					   {0X2E,"ADD A,R6",1,12,add_isr}, //
					   {0X2F,"ADD A,R7",1,12,add_isr}, //
					   {0X30,"JNB ",3,24,jnb_isr},
					   {0X31,"ACALL ",2,24,acall_isr},
					   {0X32,"RETI",1,24,reti_isr},
					   {0X33,"RLC A",1,12,rlc_isr},
					   {0X34,"ADDC A,#",2,12,add_isr},
					   {0X35,"ADDC A,",1,12,add_isr},
					   {0X36,"ADDC A,@R0 ",1,12,add_isr},
					   {0X37,"ADDC A,@R1 ",1,12,add_isr},
					   {0X38,"ADDC A,R0",1,12,add_isr},
					   {0X39,"ADDC A,R1",1,12,add_isr},
					   {0X3A,"ADDC A,R2",1,12,add_isr},
					   {0X3B,"ADDC A,R3",1,12,add_isr},
					   {0X3C,"ADDC A,R4",1,12,add_isr},
					   {0X3D,"ADDC A,R5",1,12,add_isr},
					   {0X3E,"ADDC A,R6",1,12,add_isr},
					   {0X3F,"ADDC A,R7",1,12,add_isr},
					   {0X40,"JC ",2,24,jc_isr},
					   {0X41,"AJMP ",2,24,ajmp_isr},
					   {0X42,"ORL ",2,12,orl_isr},
					   {0X43,"ORL ",3,12,orl_isr},
					   {0X44,"ORL A,#",2,12,orl_isr},
					   {0X45,"ORL A,",2,12,orl_isr},
					   {0X46,"ORL A,@R0 ",1,12,orl_isr},
					   {0X47,"ORL A,@R1 ",1,12,orl_isr},
					   {0X48,"ORL A,R0",1,12,orl_isr},
					   {0X49,"ORL A,R1",1,12,orl_isr},
					   {0X4A,"ORL A,R2",1,12,orl_isr},
					   {0X4B,"ORL A,R3",1,12,orl_isr},
					   {0X4C,"ORL A,R4",1,12,orl_isr},
					   {0X4D,"ORL A,R5",1,12,orl_isr},
					   {0X4E,"ORL A,R6",1,12,orl_isr},
					   {0X4F,"ORL A,R7",1,12,orl_isr},
					   {0X50,"JNC ",2,24,jnc_isr},
					   {0X51,"ACALL ",2,24,acall_isr},
					   {0X52,"ANL ",2,12,anl_isr},
					   {0X53,"ANL ",3,24,anl_isr},
					   {0X54,"ANL A,#",2,12,anl_isr},
					   {0X55,"ANL A,",2,12,anl_isr},
					   {0X56,"ANL A,@R0  ",1,12,anl_isr},
					   {0X57,"ANL A,@R1  ",1,12,anl_isr},
					   {0X58,"ANL A,R0",1,12,anl_isr},
					   {0X59,"ANL A,R1",1,12,anl_isr},
					   {0X5A,"ANL A,R2",1,12,anl_isr},
					   {0X5B,"ANL A,R3",1,12,anl_isr},
					   {0X5C,"ANL A,R4",1,12,anl_isr},
					   {0X5D,"ANL A,R5",1,12,anl_isr},
					   {0X5E,"ANL A,R6",1,12,anl_isr},
					   {0X5F,"ANL A,R7",1,12,anl_isr},
					   {0X60,"JZ ",2,24,jz_isr},
					   {0X61,"AJMP ",2,24,ajmp_isr},
					   {0X62,"XRL ",2,12,xrl_isr},
					   {0X63,"XRL ",3,24,xrl_isr},
					   {0X64,"XRL A,#",2,12,xrl_isr},
					   {0X65,"XRL A,",2,12,xrl_isr},
					   {0X66,"XRL A,@R0",1,12,xrl_isr},
					   {0X67,"XRL A,@R1",1,12,xrl_isr},
					   {0X68,"XRL A,R0",1,12,xrl_isr},
					   {0X69,"XRL A,R1",1,12,xrl_isr},
					   {0X6A,"XRL A,R2",1,12,xrl_isr},
					   {0X6B,"XRL A,R3",1,12,xrl_isr},
					   {0X6C,"XRL A,R4",1,12,xrl_isr},
					   {0X6D,"XRL A,R5",1,12,xrl_isr},
					   {0X6E,"XRL A,R6",1,12,xrl_isr},
					   {0X6F,"XRL A,R7",1,12,xrl_isr},
					   {0X70,"JNZ ",2,24,jnz_isr},
					   {0X71,"ACALL ",2,24,acall_isr},
					   {0X72,"ORL C,",2,24,orlc_isr},
					   {0X73,"JMP @A+DPTR",1,24,jmpdptr_isr},
					   {0X74,"MOV A,#",2,12,mov_isr},
  /*MOV DATAADDR,#DATA*/		   {0X75,"MOV ",3,24,mov_isr},
					   {0X76,"MOV @R0,#",2,12,mov_isr},
					   {0X77,"MOV @R1,#",2,12,mov_isr},
					   {0X78,"MOV R0,#",2,12,mov_isr},
					   {0X79,"MOV R1,#",2,12,mov_isr},
					   {0X7A,"MOV R2,#",2,12,mov_isr},
					   {0X7B,"MOV R3,#",2,12,mov_isr},
					   {0X7C,"MOV R4,#",2,12,mov_isr},
					   {0X7D,"MOV R5,#",2,12,mov_isr},
					   {0X7E,"MOV R6,#",2,12,mov_isr},
					   {0X7F,"MOV R7,#",2,12,mov_isr},
					   {0X80,"SJMP ",2,24,sjmp_isr},
					   {0X81,"AJMP ",2,24,ajmp_isr},
					   {0X82,"ANL C,",2,24,anlc_isr},
					   {0X83,"MOVC A,@A+PC ",1,24,mov_isr},
					   {0X84,"DIV AB",1,48,divab_isr},
					   {0X85,"MOV",3,24,mov_isr},
					   {0X86,"MOV ",2,24,mov_isr},
					   {0X87,"MOV ",2,24,mov_isr},
					   {0X88,"MOV ",2,24,mov_isr},
					   {0X89,"MOV ",2,24,mov_isr},
					   {0X8A,"MOV ",2,24,mov_isr},
					   {0X8B,"MOV ",2,24,mov_isr},
					   {0X8C,"MOV ",2,24,mov_isr},
					   {0X8D,"MOV ",2,24,mov_isr},
					   {0X8E,"MOV ",2,24,mov_isr},
					   {0X8F,"MOV ",2,24,mov_isr},
					   {0X90,"MOV DPTR,#",3,24,mov_isr},
					   {0X91,"ACALL ",2,24,acall_isr},
					   {0X92,"MOV ",2,24,mov_isr},
					   {0X93,"MOVC A,@A+DPTR",1,24,mov_isr},
					   {0X94,"SUBB A,#",2,12,subb_isr},
					   {0X95,"SUBB A,",2,12,subb_isr},
					   {0X96,"SUBB A,@R0 ",1,12,subb_isr},
					   {0X97,"SUBB A,@R1 ",1,12,subb_isr},
					   {0X98,"SUBB A,R0",1,12,subb_isr},
					   {0X99,"SUBB A,R1",1,12,subb_isr},
					   {0X9A,"SUBB A,R2",1,12,subb_isr},
					   {0X9B,"SUBB A,R3",1,12,subb_isr},
					   {0X9C,"SUBB A,R4",1,12,subb_isr},
					   {0X9D,"SUBB A,R5",1,12,subb_isr},
					   {0X9E,"SUBB A,R6",1,12,subb_isr},
					   {0X9F,"SUBB A,R7",1,12,subb_isr},
					   {0XA0,"ORL C,/",2,24,orlc_isr},
					   {0XA1,"AJMP ",2,24,ajmp_isr},
					   {0XA2,"MOV C,",2,12,mov_isr},
					   {0XA3,"INC DPTR",1,24,incdptr_isr},
					   {0XA4,"MUL AB",1,48,mulab_isr},
					   {0XA5," ",1,12,dummy_isr},
					   {0XA6,"MOV @R0,",2,24,mov_isr},
					   {0XA7,"MOV @R1,",2,24,mov_isr},
					   {0XA8,"MOV R0,",2,24,mov_isr},
					   {0XA9,"MOV R1,",2,24,mov_isr},
					   {0XAA,"MOV R2,",2,24,mov_isr},
					   {0XAB,"MOV R3,",2,24,mov_isr},
					   {0XAC,"MOV R4,",2,24,mov_isr},
					   {0XAD,"MOV R5,",2,24,mov_isr},
					   {0XAE,"MOV R6,",2,24,mov_isr},
					   {0XAF,"MOV R7,",2,24,mov_isr},
					   {0XB0,"ANL C,/",2,24,anlc_isr},
					   {0XB1,"ACALL ",2,24,acall_isr},
					   {0XB2,"CPL ",2,12,cpl_isr},
					   {0XB3,"CPL C",1,12,cpl_isr},
					   {0XB4,"CJNE A,#",3,24,cjne_isr},
					   {0XB5,"CJNE A,",3,24,cjne_isr},
					   {0XB6,"CJNE @R0,#",3,24,cjne_isr},
					   {0XB7,"CJNE @R1,#",3,24,cjne_isr},
					   {0XB8,"CJNE R0,#",3,24,cjne_isr},
					   {0XB9,"CJNE R1,#",3,24,cjne_isr},
					   {0XBA,"CJNE R2,#",3,24,cjne_isr},
					   {0XBB,"CJNE R3,#",3,24,cjne_isr},
					   {0XBC,"CJNE R4,#",3,24,cjne_isr},
					   {0XBD,"CJNE R5,#",3,24,cjne_isr},
					   {0XBE,"CJNE R6,#",3,24,cjne_isr},
					   {0XBF,"CJNE R7,#",3,24,cjne_isr},
					   {0XC0,"PUSH ",2,24,push_isr},
					   {0XC1,"AJMP ",2,24,ajmp_isr},
					   {0XC2,"CLR ",2,12,clr_isr},
					   {0XC3,"CLR C",1,12,clr_isr},
					   {0XC4,"SWAP A",1,12,swapa_isr},
					   {0XC5,"XCH A,",2,12,xch_isr},
					   {0XC6,"XCH A,@R0",1,12,xch_isr},
					   {0XC7,"XCH A,@R1",1,12,xch_isr},
					   {0XC8,"XCH A,R0",1,12,xch_isr},
					   {0XC9,"XCH A,R1",1,12,xch_isr},
					   {0XCA,"XCH A,R2",1,12,xch_isr},
					   {0XCB,"XCH A,R3",1,12,xch_isr},
					   {0XCC,"XCH A,R4",1,12,xch_isr},
					   {0XCD,"XCH A,R5",1,12,xch_isr},
					   {0XCE,"XCH A,R6",1,12,xch_isr},
					   {0XCF,"XCH A,R7",1,12,xch_isr},
					   {0XD0,"POP ",2,24,pop_isr},
					   {0XD1,"ACALL ",2,24,acall_isr},
					   {0XD2,"SETB ",2,12,setb_isr},
					   {0XD3,"SETB C",1,12,setb_isr},
					   {0XD4,"DA A",1,12,daa_isr},
					   {0XD5,"DJNZ ",3,24,djnz_isr},
					   {0XD6,"XCHD A,@R0",1,12,xchd_isr},
					   {0XD7,"XCHD A,@R1",1,12,xchd_isr},
					   {0XD8,"DJNZ R0,",2,24,djnz_isr},
					   {0XD9,"DJNZ R1,",2,24,djnz_isr},
					   {0XDA,"DJNZ R2,",2,24,djnz_isr},
					   {0XDB,"DJNZ R3,",2,24,djnz_isr},
					   {0XDC,"DJNZ R4,",2,24,djnz_isr},
					   {0XDD,"DJNZ R5,",2,24,djnz_isr},
					   {0XDE,"DJNZ R6,",2,24,djnz_isr},
					   {0XDF,"DJNZ R7,",2,24,djnz_isr},
					   {0XE0,"MOVX A,@DPTR",1,24,mov_isr},
					   {0XE1,"AJMP ",2,24,ajmp_isr},
					   {0XE2,"MOVX A,@R0",1,24,mov_isr},
					   {0XE3,"MOVX A,@R1",1,24,mov_isr},
					   {0XE4,"CLR A",1,12,clra_isr},
					   {0XE5,"MOV A,",2,12,mov_isr},
					   {0XE6,"MOV A,@R0",1,12,mov_isr},
					   {0XE7,"MOV A,@R1",1,12,mov_isr},
					   {0XE8,"MOV A,R0",1,12,mov_isr},
					   {0XE9,"MOV A,R1",1,12,mov_isr},
					   {0XEA,"MOV A,R2",1,12,mov_isr},
					   {0XEB,"MOV A,R3",1,12,mov_isr},
					   {0XEC,"MOV A,R4",1,12,mov_isr},
					   {0XED,"MOV A,R5",1,12,mov_isr},
					   {0XEE,"MOV A,R6",1,12,mov_isr},
					   {0XEF,"MOV A,R7",1,12,mov_isr},
					   {0XF0,"MOVX @DPTR,A",1,24,dummy_isr},
					   {0XF1,"ACALL ",2,24,acall_isr},
					   {0XF2,"MOVX @R0,A",1,24,mov_isr},
					   {0XF3,"MOVX @R1,A",1,24,mov_isr},
					   {0XF4,"CPL A",1,12,cpla_isr},
					   {0XF5,"MOV ",2,12,mov_isr},
					   {0XF6,"MOV @R0,A",1,12,mov_isr},
					   {0XF7,"MOV @R1,A",1,12,mov_isr},
					   {0XF8,"MOV R0,A",1,12,mov_isr},
					   {0XF9,"MOV R1,A",1,12,mov_isr},
					   {0XFA,"MOV R2,A",1,12,mov_isr},
					   {0XFB,"MOV R3,A",1,12,mov_isr},
					   {0XFC,"MOV R4,A",1,12,mov_isr},
					   {0XFD,"MOV R5,A",1,12,mov_isr},
					   {0XFE,"MOV R6,A",1,12,mov_isr},
					   {0XFF,"MOV R7,A",1,12,mov_isr},
  /* dummy for hex 100*/         	   {0X100," ",1,12,dummy_isr}

			      };


//void unassemble(char *n,char flag)
void unassemble(char *n,char flag)
 {
   int temp,start;
   sscanf(n,"%x",&start);
   if(flag==0)     //flag=0 -> no arg.,start unassembling from
     {                             //current value of UC
	disassemble_code(UC,0);
     }
   else
     {
			//else flag=1 -> arg. is starting point of trace

	disassemble_code(start,0);

     }

   //printf("inside unassemble!!");
 }

void decode_and_simulate(int start)
 {

   //char tlck;
   //extern struct instruct instructions;
   /*static struct instruct instructions[]={
					   {0,"NOP",4,0,nop_isr},
					   {1,"ADD A",4,1,nop_isr}
				       };*/

   //instructions

   //test++;
   //char flag=0;
   //A=128;
   PC=start;
   //printf("%s\n\r",instructions[ROM[PC]].mnemonic);
     if(instructions[ROM[PC]].hex_code>=0x04 && instructions[ROM[PC]].hex_code<=0x0f)
	 flag=1;  //flag=+1 means INC operation...
     if(instructions[ROM[PC]].hex_code>=0x14 && instructions[ROM[PC]].hex_code<=0x1f)
	 flag=-1;  //flag=-1 means DEC operation...

   tclk = instructions[ROM[PC]].clock;
   //printf("CLK=%d\n\r",instructions[ROM[PC]].clock);
   instructions[ROM[PC]].ins_ptr(instructions[ROM[PC]].hex_code);
   //printf("inside decode_and_simulate!!");
   //printf("%d",test);
   //printf("%.4x:%.2x\n\r",PC,ROM[PC]);
   /*do ur stuff here..decode and simulate!!*/

   PC++;
   //printf("%x \n\r",A);
   //if( (count_no_of_ones(A)%2)==0 )              // even no of ones in acc...
 if( (count_no_of_ones(A)%2)==0 )
    //PSW= 0xcc;
    PSW = PSW & 0xfe;    //checking for P flag and clearing it...!!

  else
      //if( (count_no_of_ones(A)%2)!=0 )    // odd number of ones in acc...
     if( (count_no_of_ones(A)%2)!=0 )
       PSW = PSW | 0x01;    //checking for P flag and setting it...!!
    //PSW=0xff;
   //printf("%x \n\r",PSW);

   show_regs('1');
   //printf("CLK=%d\n\r",tclk);
   if(go_flag==0)
   display_shell();   /*********uncommented in guwahati on 29/12/02******////
 }                     //////////////////

void set_break_point(unsigned int bkval)
 {
   //int break_points[6],c;
   //static int bkp_no=0;
   //printf("inside set_break_point()!!  %X \n\r",pcval);
   break_points[bkp_no]=bkval;
   bkp_no++;
   printf(" Breakpoint set at PC=%X\n\r",bkval);
   refresh();
   /*if (bkval==0x99)
      {for(c=0;c<bkp_no;c++)
      printf("Breakpoint %d : PC=%X\n\r",c,break_points[c]);
      }    */
   display_shell();

 }

char check_for_bkpoint(unsigned int pcval)
 {
   int c=0,flag=0;
   while(c<bkp_no)

    {
     if( break_points[c]==pcval)    //current PC has a bkpoint...
       {
	 flag=1;
	 break;
       }
     c++;

    }

   return flag; // flag=1means bkpoint found while flag=0 bkpoint not found..
 //if (flag==1)
   //return 1;    //means current PC has bkpoint...
 //if(flag==0)
   //return 0;   //means current PC has no bkpoint...

 }



 void nop_isr(int opcode)
  {
    //printf("inside nop_isr!!\n\r");
    opcode++; //just to remove warning for the time being....
    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
    refresh();
    // NOP: just do nothing.....
  }

void ajmp_isr(int opcode)
  {

    unsigned int tempPC,abs_addr,final_addr,curr_page_addr;
    printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
    printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
    refresh();
    // gotta find the current page and add the 11-bit address from
    //ajmp to get the absolute address within the current of the following
    // adress...

    switch(opcode)
     {

       case 0x01:
	    abs_addr = 0x000 + ROM[++PC];  // these are the 11 bit abs addresses..
	    break;

       case 0x21:
	    abs_addr = 0x100 + ROM[++PC];
	    break;

       case 0x41:
	    abs_addr = 0x200 + ROM[++PC];
	    break;

       case 0x61:
	    abs_addr = 0x300 + ROM[++PC];
	    break;

       case 0x81:
	    abs_addr = 0x400 + ROM[++PC];
	    break;

       case 0xa1:
	    abs_addr = 0x500 + ROM[++PC];
	    break;

       case 0xc1:
	    abs_addr = 0x600 + ROM[++PC];
	    break;

       case 0xe1:
	    abs_addr = 0x700 + ROM[++PC];
	    break;
     }


 tempPC = PC + 1;   //pointing to the next instruction...
 curr_page_addr =  tempPC & 0xf800;
 final_addr =   curr_page_addr + abs_addr;
 PC = final_addr - 1;  // to compensate for the extra 'PC++'...


    //opcode++; //just to remove warning for the time being....
    //printf("inside ajmp_isr!!\n\r");
  }

void sjmp_isr(int opcode)
 {
   printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
     if(ROM[PC+1] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+1] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+1];
		  //PC++;
		}

	     PC++; //so that offset is counted from next instruction..
	     //PC--;
	  //}

       //else
	// PC++;

  opcode++;    //just to remove warnings...



 }




void ljmp_isr(int opcode)
  {
     int temp;
     printf("%s %.2X%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
     printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
     refresh();
     temp=ROM[PC+1]*256+ROM[PC+2];
				      //optimize this...
     PC=temp-1;
     //PC+=2;
     //PC=ROM[++PC]*256+ROM[++PC]-1;
     //printf("inside ljmp_isr!!\n\r");
  opcode++; //just to remove warning for the time being....
  }


void jmpdptr_isr(int opcode)
 {
   //unsigned int tempDPTR;
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
    refresh();
   PC = A + (DPH * 0x100 + DPL);
   PC--;     	   // to compensate for the 'PC++' at
		   //the end of this function call..

  opcode++; //just to remove warning for the time being....
 }




void rr_isr(int opcode)
  {
    unsigned char lsb;
    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
        refresh();
	//truncA;
    lsb=A&1;
    A=A>>1;
    if(lsb==1)
      A=A|128;
    //printf("inside rr_isr!!\n\r");
  opcode++; //just to remove warning for the time being....
  }



void inc_dec_isr(int opcode)
  {
    //printf("%s\n\r",instructions[ROM[PC]].mnemonic);
    int current_bank=0;
    //RAM[0]=36; //just testting!!
    //RAM[1]=17;
    //switch (opcode)
     //{
       if(opcode==0x04 || opcode==0x14)             // INC or DEC A
	  {
	   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
           refresh();
	   A+=flag;
	   //break;
	  }
       //case(0x05 || 0x15):
      if(opcode==0x05 || opcode==0x15)
       {
	 printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	 printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
    refresh();
	 RAM[ROM[++PC]]+=flag;
	 //break;
       }
      if(opcode==0x06 || opcode==0x16)
      {
       //case(0x06):
	 printf("%s \n\r",instructions[ROM[PC]].mnemonic);
	 printf("%.4X:%.2X \n\r",PC,ROM[PC]);
    refresh();
	 current_bank=get_current_reg_bank();   //confirm this from as51..
	 RAM[RAM[current_bank*8]]+=flag;
	 //break;
       }
      if(opcode==0x07 || opcode==0x17)
      {
       //case(0x07):
	 printf("%s \n\r",instructions[ROM[PC]].mnemonic);
	 printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC]);
    refresh();
	 current_bank=get_current_reg_bank();
	 RAM[RAM[current_bank*8+1]]+=flag;
	 //break;
      }
       //default:
	 //  break;

     //printf("inside inc_isr!!");
  if((opcode>=0x8 && opcode<=0x0f) || (opcode>=0x18 && opcode<=0x1f))
      {
	 printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	 printf("%.4X:%.2X \n\r",PC,ROM[PC]);
    refresh();
	 current_bank=get_current_reg_bank();
	 //printf("current reg bank is:%d",current_bank);
	 if(flag==1)
	     RAM[current_bank*8+(opcode-0x08)]++;
	 else
	  if(flag==-1)
	     RAM[current_bank*8+(opcode-0x18)]--;

      }

}

int get_current_reg_bank()
 {
   unsigned char temp;
   //PSW=0x18;   //to change register banks manually
   temp=PSW;
   temp=temp<<3;
   temp=temp>>6;
   return temp;

 }

void jbc_isr(opcode)
 {
   printf("%s %.2X,%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
   printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
       refresh();

      if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
	   {
	     if( RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) ));
		{          //clearing bit before making the jump....
		   RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] & ~(unsigned char) pow(2,(ROM[PC+1] % 8) );
		   if(ROM[PC+2] & 0x80)
		  {
		     PC = PC - (0xff - ROM[PC+2] + 1);
		     //PC++;
		     //PC--;
		     //PC-=2;
		  }
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     //PC++; //so that offset is counted from next instruction..
	     //PC++;
	  }
	     PC+=2;	//printf("bit is set!!\n\r");
	     //RAM[0x20 + (ROM[PC + 1] /8)] =  RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) );

	   }

	     else   // for SFR bits.....
		if( ROM[PC+1] >0x7f )
		{
		  //offset = ROM[PC+1] % 8;
		  //loc = 8 * ( ROM[PC +1] /8 );
		  //RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
		  //RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] | (unsigned char)(pow (2,ROM[PC+1] % 8));
		  if(  RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8)))
		    {           //clearing bit before making the jump....
		       RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] & ~(unsigned char)(pow (2,ROM[PC+1] % 8));
			if(ROM[PC+2] & 0x80)
			  {
			    PC = PC - (0xff - ROM[PC+2] + 1);
			    //PC++;
			    //PC--;
			    //PC-=2;
			  }
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     //PC++; //so that offset is counted from next instruction..
	     //PC++;
      }

	      PC+=2;	      //printf("bit is set!!");

		}

    //PC+=2;
    opcode++; //just to remove warning for the time being....
    //printf("inside jbc_isr!!\n\r");
 }

void acall_isr(int opcode)
  {

    unsigned char PCL,PCH;
    unsigned int tempPC,abs_addr,final_addr,curr_page_addr;
    printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
    printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
    refresh();
    // gotta find the current page and add the 11-bit address from
    //ajmp to get the absolute address within the current of the following
    // adress...

    switch(opcode)
     {

       case 0x11:
	    abs_addr = 0x000 + ROM[++PC];  // these are the 11 bit abs addresses..
	    break;

       case 0x31:
	    abs_addr = 0x100 + ROM[++PC];
	    break;

       case 0x51:
	    abs_addr = 0x200 + ROM[++PC];
	    break;

       case 0x71:
	    abs_addr = 0x300 + ROM[++PC];
	    break;

       case 0x91:
	    abs_addr = 0x400 + ROM[++PC];
	    break;

       case 0xb1:
	    abs_addr = 0x500 + ROM[++PC];
	    break;

       case 0xd1:
	    abs_addr = 0x600 + ROM[++PC];
	    break;

       case 0xf1:
	    abs_addr = 0x700 + ROM[++PC];
	    break;
     }


   tempPC = PC + 1;   //pointing to the next instruction...
   PCL = (unsigned char) (tempPC &0xff);
   PCH = (unsigned char) ((tempPC>>8)&0xff);
   RAM[++SP] = PCL;
   RAM[++SP] = PCH;

   curr_page_addr =  tempPC & 0xf800;
   final_addr =   curr_page_addr + abs_addr;
   PC = final_addr - 1;  // to compensate for the extra 'PC++'...
    //opcode++; //just to remove warning for the time being....
    //printf("inside acall_isr!!\n\r");
  }

void lcall_isr(int opcode)
  {
    unsigned int tempPC;
    unsigned char PCL,PCH;
    printf("%s %.2X%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
    printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
    refresh();
    tempPC = PC+3;
    PCL = (unsigned char) (tempPC &0xff);
    PCH = (unsigned char) ((tempPC>>8)&0xff);
    RAM[++SP] = PCL;
    RAM[++SP] = PCH;
    //printf("%x  %x\n\r",PCH,PCL);
    PC = ROM[PC+2] +  ROM[PC+1] * 256 ;  //just hoping that msb first...
    PC--;  	//to compensate for the 'PC++' at the end of this isr..
    //PC+=2;
    opcode++; //just to remove warning for the time being....
    //printf("inside lcall_isr!!\n\r");
  }


void rrc_isr(int opcode)
  {
    unsigned char lsb;
    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
    refresh();
    //truncA;
    lsb=A&1;
    A=A>>1;
    if( PSW & 0x80)
       A = A | 0x80;


    if(lsb==1)
       PSW = PSW | 128;
    if(lsb==0)
       PSW = PSW & 0x7f;

    //printf("inside rr_isr!!\n\r");
  opcode++; //just to remove warning for the time being....

    //opcode++; //just to remove warning for the time being....
    //printf("inside rrc_isr!!\n\r");
  }


void rlc_isr(int opcode)
  {
    unsigned char msb;
    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
    refresh();
    //truncA;
    msb=A & 0x80;
    A=A<<1;
    if( PSW & 0x80)
       A = A | 0x01;


    if(msb==0x80)
       PSW = PSW | 128;
    if(msb==0)
       PSW = PSW & 0x7f;

    //printf("inside rr_isr!!\n\r");
  opcode++; //just to remove warning for the time being....

    //opcode++; //just to remove warning for the time being....
    //printf("inside rrc_isr!!\n\r");
  }




void jb_isr(int opcode)
  {
   printf("%s %.2X,%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
   printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
    refresh();
      if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
	   {
	     if( RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) ));
		{          //clearing bit before making the jump....
		   //RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] & ~(unsigned char) pow(2,(ROM[PC+1] % 8) );
		   if(ROM[PC+2] & 0x80)
		  {
		     PC = PC - (0xff - ROM[PC+2] + 1);
		     //PC++;
		     //PC--;
		     //PC-=2;
		  }
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     //PC++; //so that offset is counted from next instruction..
	     //PC++;
	  }
	   PC+=2;	//printf("bit is set!!\n\r");
	     //RAM[0x20 + (ROM[PC + 1] /8)] =  RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) );

	   }

	     else   // for SFR bits.....
		if( ROM[PC+1] >0x7f )
		{
		  //offset = ROM[PC+1] % 8;
		  //loc = 8 * ( ROM[PC +1] /8 );
		  //RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
		  //RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] | (unsigned char)(pow (2,ROM[PC+1] % 8));
		  if(  RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8)))
		    {           //clearing bit before making the jump....
		       //RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] & ~(unsigned char)(pow (2,ROM[PC+1] % 8));
			if(ROM[PC+2] & 0x80)
			  {
			    PC = PC - (0xff - ROM[PC+2] + 1);
			    //PC++;
			    //PC--;
			    //PC-=2;
			  }
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     //PC++; //so that offset is counted from next instruction..
	     //PC++;
      }

	PC+=2;	      //printf("bit is set!!");

		}
    opcode++; //just to remove warning for the time being....
    //printf("inside jbc_isr!!\n\r");

     //PC+=2;

    //opcode++; //just to remove warning for the time being....
    //printf("inside jb_isr!!\n\r");
  }

void jnb_isr(int opcode)
 {
   printf("%s %.2X,%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
   printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
    refresh();
      if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
	   {
	     if(! (RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) ))   );
		{          //clearing bit before making the jump....
		   //RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] & ~(unsigned char) pow(2,(ROM[PC+1] % 8) );
		   if(ROM[PC+2] & 0x80)
		    {
		     PC = PC - (0xff - ROM[PC+2] + 1);
		     //PC++;
		     //PC--;
		     //PC-=2;
		    }
		   else
		    {
		      PC = PC + ROM[PC+2];
		     //PC++;
		    }

	     //PC++; //so that offset is counted from next instruction..
	     //PC++;
	  }
	      PC+=2;	//printf("bit is set!!\n\r");
	     //RAM[0x20 + (ROM[PC + 1] /8)] =  RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) );

	   //PC+=2;
	   }

	     else   // for SFR bits.....
		if( ROM[PC+1] >0x7f )
		{
		  //offset = ROM[PC+1] % 8;
		  //loc = 8 * ( ROM[PC +1] /8 );
		  //RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
		  //RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] | (unsigned char)(pow (2,ROM[PC+1] % 8));
		  if(! (RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8)))  )
		    {           //clearing bit before making the jump....
		       //RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] & ~(unsigned char)(pow (2,ROM[PC+1] % 8));
			if(ROM[PC+2] & 0x80)
			  {
			    PC = PC - (0xff - ROM[PC+2] + 1);
			    //PC++;
			    //PC--;
			    //PC-=2;
			  }
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     //PC++; //so that offset is counted from next instruction..
	     //PC++;
      }

		      //printf("bit is set!!");
		PC+=2;
		}
    opcode++; //just to remove warning for the time being....
    //printf("inside jbc_isr!!\n\r");

 }


void jc_isr(int opcode)
 {
   printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
    refresh();
   if( PSW & 0x80 )
	  {
	    if(ROM[PC+1] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+1] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+1];
		  //PC++;
		}

	     PC++; //so that offset is counted from next instruction..
	     //PC--;
	  }

       else
	 PC++;

  opcode++;    //just to remove warnings...

 }


void jnc_isr(int opcode)
 {
   printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   if( !(PSW & 0x80) )
	  {
	    if(ROM[PC+1] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+1] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+1];
		  //PC++;
		}

	     PC++; //so that offset is counted from next instruction..
	     //PC--;
	  }

       else
	 PC++;

  opcode++;    //just to remove warnings...





 }



void ret_isr(int opcode)
 {
   unsigned char PCL,PCH;
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
      refresh();
   PCH = RAM[SP--];
   PCL = RAM[SP--];
   PC = PCH * 256 + PCL;
   PC--;    //to compensate for the 'PC++' after this function...
   opcode++; //just to remove warning for the time being....
   //printf("inside ret_isr!!\n\r");
 }


void reti_isr(int opcode)
 {                           // same as ret_isr....enable interrupts later..
   unsigned char PCL,PCH;
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
      refresh();
   PCH = RAM[SP--];
   PCL = RAM[SP--];
   PC = PCH * 256 + PCL;
   PC--;    //to compensate for the 'PC++' after this function...
   opcode++; //just to remove warning for the time being....
   //printf("inside ret_isr!!\n\r");
 }


void rl_isr(int opcode)
 {
    unsigned char msb;
    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
       refresh();
   msb=A&128;
    A=A<<1;
    if(msb==128)
      A=A|1;
   //printf("inside rl_isr!!\n\r");
 opcode++; //just to remove warning for the time being....
 }


void incdptr_isr(int opcode)
 {
  unsigned int tempDPTR;
  printf("%s\n\r",instructions[ROM[PC]].mnemonic);
  printf("%.4X:%.2X\n\r",PC,ROM[PC]);
     refresh();
   tempDPTR = DPH *0x100 + DPL;
  tempDPTR++;

  DPL = (unsigned char)(tempDPTR & 0x00ff);
  DPH = (unsigned char)( (tempDPTR >> 8) & 0x00ff);
  opcode++; //just to remove warning for the time being....
 }

void mulab_isr(int opcode)
 {
   unsigned int result;
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
      refresh();
   result = A * B;
   A = (unsigned char) (result & 0x00ff );
   B = (unsigned char) ( (result>>8) & 0x00ff );
   if(result > 0xff)
     PSW = PSW | 0x04; // setting OV flag if result > 0xff...

   else
     PSW = PSW & 0xfb;  //else resetting OV flag...


   PSW = PSW & 0x7f;    //resetting CY flag...unconditionally

   opcode++;    //just to remove warnings...

 }

void divab_isr(int opcode)
 {

   unsigned char num_r, denom_r;
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
      refresh();
   num_r = A;
   denom_r = B;

   if(B!=0)
     {
       A = num_r / denom_r;
       B = num_r % denom_r;
       PSW = PSW & 0xfb ; // resetting OV flag if denom_r!=0 and division
			  // proceeds....
     }
   else
      PSW = PSW | 0x04; // setting OV flag if B=0...


   PSW = PSW % 0x7f;  //resetting CY flag...unconditionally

   opcode++;    //just to remove warnings...
 }


void add_isr(int opcode)
 {
   int current_bank,mycarry,tempA;
   //printf("%s%x\n\r",instructions[ROM[PC]].mnemonic);
    //printf("%.4x:%.2x\n\r",PC,ROM[PC]);
   if(opcode>=0x34 && opcode <=0x3f )
       mycarry=((PSW & 0x80)>>7);
   else
      if(opcode >=0x24 && opcode <=0x2f)
       mycarry=0;

   if(opcode==0x24 || opcode==0x34)
     {

      tempA=A;
      printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
      printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
         refresh();
   tempA=A+ROM[PC+1]+mycarry;
      set_flags(tempA,A,ROM[PC+1],0xc5);
      A=tempA&0x00ff;
/*      if(A & 0xff00)
	  A=A & 0x00ff;   // to check for 9 bit or more values and
			 //truncate the extra bits..     */
     PC++;

     }
    else
    if(opcode==0x25 || opcode==0x35)
     {
      printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
      printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
         refresh();
   tempA=A+RAM[ROM[PC+1]]+mycarry;

      set_flags(tempA,A,RAM[ROM[PC+1]],0xc5);
      A=tempA&0x00ff;
      PC++;

     }
    else
       if(opcode==0x26 || opcode==0x36)
	{
	 printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	 printf("%.4X:%.2X\n\r",PC,ROM[PC]);
	    refresh();
   current_bank=get_current_reg_bank();
	 tempA=A+RAM[RAM[current_bank*8]]+mycarry;

	 set_flags(tempA,A,RAM[RAM[current_bank*8]],0xc5);
	 A=tempA&0x00ff;

	}
	else
	   if(opcode==0x27 || opcode==0x37)
	      {
		printf("%s\n\r",instructions[ROM[PC]].mnemonic);
		printf("%.4X:%.2X\n\r",PC,ROM[PC]);
		   refresh();
   current_bank=get_current_reg_bank();
		tempA=A+RAM[RAM[current_bank*8+1]]+mycarry;

		set_flags(tempA,A,RAM[RAM[current_bank*8+1]],0xc5);
		A=tempA&0x00ff;


	      }
	   else
	      if(   ((opcode>=0x28) && (opcode<=0x2f)) || ((opcode>=0x38) && (opcode<=0x3f))   )
		 {
		  printf("%s\n\r",instructions[ROM[PC]].mnemonic);
		  printf("%.4X:%.2X\n\r",PC,ROM[PC]);
		     refresh();
   		  current_bank=get_current_reg_bank();

		  //if(opcode>=0x28) && (opcode<=2

		  tempA=A+RAM[current_bank*8+(   (opcode>=0x28)&&(opcode<=0x2f)? \
		  (opcode-0x28 ):( opcode-0x38 )  )  ]+mycarry;

		    set_flags(tempA,A,RAM[current_bank*8+(   (opcode>=0x28)&&(opcode<=0x2f)? (opcode-0x28 ):( opcode-0x38 )  )  ],0xc5);
		    A=tempA&0x00ff;


		 }
  // extracting the correct reg from the opcode information.....
    //printf("inside add_isr!!\n\r");

		  //set_flags(tempA,A,RAM[current_bank*8+(   (opcode>=0x28)&&(opcode<=0x2f)? (opcode-0x28 ):( opcode-0x38 )  )  ],0xc5);
		  //A=tempA&0x00ff;


 }


void daa_isr(int opcode)

 {
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();

   if(   (A & 0x0f)>9 || ( PSW & 0x04)   )
      A = A + 0x06;


   if (	 ((A>>4) & 0x0f)>9 || ( PSW & 0x80)  )
      A = A + 0x60;

   opcode++; //just to remove warning for the time being....

 }


void subb_isr(int opcode)
 {
   int current_bank,mycarry,tempA=0;
   unsigned char tempB;
   //printf("%s%x\n\r",instructions[ROM[PC]].mnemonic);
    //printf("%.4x:%.2x\n\r",PC,ROM[PC]);
 /*  if(opcode>=0x34 && opcode <=0x3f )
       mycarry=((PSW & 0x80)>>7);
   else
      if(opcode >=0x24 && opcode <=0x2f)
       mycarry=0;    */

   if(opcode==0x94)// || opcode==0x34)
     {
      printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
      printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
      //printf("%d %x\n\r",ROM[PC+1],ROM[PC+1]);
      tempB =  (~ROM[++PC] + 1)   ;
      //tempA = (unsigned char) (  A + (~ROM[++PC] + 1)    );
      //tempA=A;
      //tempB=ROM[++PC];
      //tempB=~tempB;
      //printf("%d  %d\n\r",tempA,tempB);
      tempA = A + tempB;
      //tempA = A + (~ROM[++PC] + 1);
      tempA = tempA ^ 256;
      //tempAA = tempA;
      //tempAA = tempAA ^ 256;
      //tempA=A+ROM[++PC]+mycarry;
      set_flags(tempA,A,tempB,0xc5);
      A=tempA&0x00ff;
/*      if(A & 0xff00)
	  A=A & 0x00ff;   // to check for 9 bit or more values and
		 //truncate the extra bits..     */
      //PC++;
     }
    else
    if(opcode==0x95)// || opcode==0x35)
     {
      printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
      printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
      tempB = ~( RAM[ROM[++PC]] ) + 1;
      tempA =  A + tempB;
      tempA = tempA ^ 256;
      //tempA=A+RAM[ROM[++PC]]+mycarry;
      set_flags(tempA,A,tempB,0xc5);
      A=tempA&0x00ff;
     }
    else
       if(opcode==0x96)// || opcode==0x36)
	{
	 printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	 printf("%.4X:%.2X\n\r",PC,ROM[PC]);
	    refresh();
   	 current_bank = get_current_reg_bank();
	 tempB = ~( RAM[RAM[current_bank*8]]) + 1;
	 tempA = A + tempB;
	 //tempA =(unsigned char) ( A + ~( RAM[RAM[current_bank*8]] ) + 1 );
	 tempA = tempA ^ 256;
	 set_flags(tempA,A,tempB,0xc5);
	 A=tempA&0x00ff;
	}
	else
	   if(opcode==0x97)// || opcode==0x37)
	      {
		printf("%s\n\r",instructions[ROM[PC]].mnemonic);
		printf("%.4X:%.2X\n\r",PC,ROM[PC]);
		   refresh();
   	current_bank=get_current_reg_bank();
		tempB = ~( RAM[RAM[current_bank * 8 + 1]] ) + 1;
		tempA = A + tempB;
		//tempA =(unsigned char) ( A + ~( RAM[RAM[current_bank * 8 + 1]] ) + 1 );
		tempA = tempA ^ 256;
		set_flags(tempA,A,tempB,0xc5);
		A=tempA&0x00ff;
	      }
	   else
	      if(   ((opcode>=0x98) && (opcode<=0x9f))  )// || ((opcode>=0x38) && (opcode<=0x3f))   )
		 {
		  printf("%s\n\r",instructions[ROM[PC]].mnemonic);
		  printf("%.4X:%.2X\n\r",PC,ROM[PC]);
		     refresh();
   current_bank=get_current_reg_bank();
		  //if(opcode>=0x28) && (opcode<=2
		  tempB = ( ~(RAM[ current_bank * 8 + (opcode-0x98)]) + 1);
		  //printf("%X \n\r",A);
		  tempA = A + tempB;
		  //tempA = (unsigned char) (A + ( ~(RAM[ current_bank * 8 + (opcode-0x98)]) + 1));
		  tempA = tempA ^ 256;
		  set_flags(tempA,A,tempB,0xc5);
		  A=tempA&0x00ff;
		 }
  // extracting the correct reg from the opcode information.....
    //printf("inside add_isr!!\n\r");
		  //set_flags(tempA,0xc5);
		  //A=tempA&0x00ff;
 }

void clra_isr(int opcode)
 {
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
      refresh();
   A = A ^ A; 	       // clearing all the bits of the accumulator...
   opcode++;  		//just to remove warning...
 }


void cpla_isr(int opcode)
 {
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
      refresh();
   A = ~A;          // toggling all the bits of the accumulator...
   opcode++;  		//just to remove warning...
 }

void swapa_isr(opcode)
 {
    int count=0;
    unsigned char lsb;
    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
       refresh();


    for(;count<4;count++)    // iterate 4 times to swap nibbles...
       {
	  lsb=A&1;
	  A=A>>1;        // rotating right 4 times to swap ls-nibble and
	  if(lsb==1)     // rs-nibble..................
	     A=A|128;
       }
  opcode++; //just to remove warning for the time being....
 }


void setb_isr(int opcode)
 {
   //int loc,bit,offset;
   //unsigned char mask;
   if(opcode==0xd3)
	{
	   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
	      refresh();
   PSW=PSW | 128;  //setting carry flag for 'SETB C' instruction..
	}
   else
	if(opcode==0xd2)
	   {
	     printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	     printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	        refresh();
   //offset = ROM[PC+1] / 8;
	     //loc = 0x20 + offset;
	     //bit = ROM[PC+1] % 8;
	     //mask = (unsigned char) pow(2,bit);
	     //RAM[loc] = RAM[loc] | mask;

	     //RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] | (unsigned char) pow(2,(ROM[PC+1] % 8) );

	     if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
	       RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] | (unsigned char) pow(2,(ROM[PC+1] % 8) );
	     else   // for SFR bits.....
		if( ROM[PC+1] >0x7f )
		{
		  //offset = ROM[PC+1] % 8;
		  //loc = 8 * ( ROM[PC +1] /8 );
		  //RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
		  RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] | (unsigned char)(pow (2,ROM[PC+1] % 8));

		}

	     PC++;
	   }
     opcode++; //just to remove warning for the time being....

  }



void clr_isr(int opcode)
 {
   //int loc,bit,offset;
   //unsigned char mask;
   if(opcode==0xc3)
	{
	   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
	      refresh();
   PSW=PSW & 127;  //setting carry flag for 'SETB C' instruction..
	}
   else
	if(opcode==0xc2)
	   {
	     printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	     printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	        refresh();
   //offset = ROM[PC+1] / 8;
	     //loc = 0x20 + offset;
	     //bit = ROM[PC+1] % 8;
	     //mask = (unsigned char) pow(2,bit);
	     //RAM[loc] = RAM[loc] | mask;
	     if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
	       RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] & ~(unsigned char) pow(2,(ROM[PC+1] % 8) );
	     else   // for SFR bits.....
		if( ROM[PC+1] >0x7f )
		{
		  //offset = ROM[PC+1] % 8;
		  //loc = 8 * ( ROM[PC +1] /8 );
		  //RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
		  RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] & ~(unsigned char)(pow (2,ROM[PC+1] % 8));

		}


	     PC++;
	   }
     opcode++; //just to remove warning for the time being....

  }



void cpl_isr(int opcode)
 {
   //int loc,bit,offset;
   //unsigned char mask;
   if(opcode==0xb3)
	{
	   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
	      refresh();
   PSW=PSW ^ 128;  //setting carry flag for 'SETB C' instruction..
	}
   else
	if(opcode==0xb2)
	   {
	     printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	     printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	        refresh();
   //offset = ROM[PC+1] / 8;
	     //loc = 0x20 + offset;
	     //bit = ROM[PC+1] % 8;
	     //mask = (unsigned char) pow(2,bit);
	     //RAM[loc] = RAM[loc] | mask;

	     //RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] ^ (unsigned char) pow(2,(ROM[PC+1] % 8) );

	     if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
	       RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)]  ^ (unsigned char) pow(2,(ROM[PC+1] % 8) );
	     else   // for SFR bits.....
		if( ROM[PC+1] >0x7f )
		{
		  //offset = ROM[PC+1] % 8;
		  //loc = 8 * ( ROM[PC +1] /8 );
		  //RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
		  RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )]  ^ (unsigned char)(pow (2,ROM[PC+1] % 8));

		}

	     PC++;
	   }
     opcode++; //just to remove warning for the time being....

  }






void dummy_isr(opcode)
{
  opcode++; //just to remove warning for the time being....
  //printf("inside dummy_isr");
}



void orl_isr(opcode)
{
   // for debugging purposes...
   //printf("inside orl isr!!\n\r");
   int current_bank;

/*   if(opcode==0xa0 || opcode==0x72)

     {
       printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
       printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);

       RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] ^ (unsigned char) pow(2,(ROM[PC+1] % 8) );
       PC++;



     }    */


   if(opcode==0x42)
     {
       printf("%s %.2X,A\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
       printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
          refresh();
   RAM[ROM[PC+1]] = RAM[ROM[PC+1]] | A ;
    //   RAM[ROM[PC]]  = A | ROM[PC+1];
       PC++;
       //RAM[ROM[PC+1]]=RAM[ROM[PC+2]];

     }

   if(opcode==0x43)
      {
	printf("%s %.2X,#%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
	printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
	   refresh();
   RAM[ROM[PC+1]] = RAM[ROM[PC+1]] | ROM[PC+2];
	PC+=2;

      }
   if(opcode==0x44)
      {
	printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	   refresh();
   A = ROM[++PC] | A;    //can use ++PC here....used only
      }  			//in one side of equal sign..

   if(opcode==0x45)
      {
	printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	   refresh();
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	A = A | RAM[ROM[++PC]];

      }
   if(opcode==0x46)
      {
	//printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	//printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();

	current_bank=get_current_reg_bank();
	A = A | RAM[RAM[current_bank*8]];
      }

   if(opcode==0x47)
      {
	//printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	//printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
           refresh();

	current_bank=get_current_reg_bank();
	A = A | RAM[RAM[current_bank*8+1]];
      }

   if(opcode>=0x48 && opcode<=0x4f)
      {
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
	   refresh();
   current_bank=get_current_reg_bank();
	A = A | RAM[current_bank*8+(opcode-0x48)];
      }

}

void orlc_isr(opcode)
 {
   printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
   if(opcode==0x72)
   {


    if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
      {
	 if( RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) ))
	     PSW = PSW | 0x80;
      }
    else
      if( ROM[PC+1] >0x7f )
	 if(  RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8)))
	     PSW = PSW | 0x80;
    }

  else
     if(opcode==0xa0)
     {

       if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
      {
	 if(! (RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) ))  )
	     PSW = PSW | 0x80;
      }
    else
      if( ROM[PC+1] >0x7f )
	 if(! (RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8)))  )
	     PSW = PSW | 0x80;


     }



     PC++;
     opcode++; //just to remove warning for the time being....

 }


 void anlc_isr(opcode)
 {
   printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();

   if(opcode==0x82)
   {

    if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
      {
	 if(! (RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8)))  )
	     PSW = PSW & 0x7f;
      }
  else
     if( ROM[PC+1] >0x7f )
	 if(! (RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8)))  )
	     PSW = PSW & 0x7f;
   }

 else
    if(opcode==0xb0)
    {
      if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
       {
	 if( RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8))  )
	     PSW = PSW & 0x7f;
       }
      else
	if( ROM[PC+1] >0x7f )
	 if( RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8))  )
	     PSW = PSW & 0x7f;

    }





     PC++;
     opcode++; //just to remove warning for the time being....

 }



void anl_isr(opcode)
{
   // for debugging purposes...
   //printf("inside orl isr!!\n\r");
   int current_bank;
   if(opcode==0x52)
     {
       printf("%s %.2X,A\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
       printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
          refresh();
   RAM[ROM[PC+1]] = RAM[ROM[PC+1]] & A ;
    //   RAM[ROM[PC]]  = A | ROM[PC+1];
       PC++;
       //RAM[ROM[PC+1]]=RAM[ROM[PC+2]];

     }

   if(opcode==0x53)
      {
	printf("%s %.2X,#%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
	printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
	   refresh();
   RAM[ROM[PC+1]] = RAM[ROM[PC+1]] & ROM[PC+2];
	PC+=2;

      }
   if(opcode==0x54)
      {
	printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	   refresh();
   A = ROM[++PC] & A;    //can use ++PC here....used only
      }  			//in one side of equal sign..

   if(opcode==0x55)
      {
	printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	   refresh();
   A = A & RAM[ROM[++PC]];

      }
   if(opcode==0x56)
      {
	//printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	//printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
           refresh();

	current_bank=get_current_reg_bank();
	A = A & RAM[RAM[current_bank*8]];
      }

   if(opcode==0x57)
      {
	//printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	//printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
           refresh();

	current_bank=get_current_reg_bank();
	A = A & RAM[RAM[current_bank*8+1]];
      }

   if(opcode>=0x58 && opcode<=0x5f)
      {
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
	   refresh();
   current_bank=get_current_reg_bank();
	A = A & RAM[current_bank*8+(opcode-0x58)];
      }




}


void xrl_isr(opcode)
{
   // for debugging purposes...
   //printf("inside orl isr!!\n\r");
   int current_bank;
   if(opcode==0x62)
     {
       printf("%s %.2X,A\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
       printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
          refresh();
   RAM[ROM[PC+1]] = RAM[ROM[PC+1]] ^ A ;
    //   RAM[ROM[PC]]  = A | ROM[PC+1];
       PC++;
       //RAM[ROM[PC+1]]=RAM[ROM[PC+2]];

     }

   if(opcode==0x63)
      {
	printf("%s %.2X,#%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
	printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
	   refresh();
   RAM[ROM[PC+1]] = RAM[ROM[PC+1]] ^ ROM[PC+2];
	PC+=2;

      }
   if(opcode==0x64)
      {
	printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	   refresh();
   A = ROM[++PC] ^ A;    //can use ++PC here....used only
      }  			//in one side of equal sign..

   if(opcode==0x65)
      {
	printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	   refresh();
   A = A ^ RAM[ROM[++PC]];

      }
   if(opcode==0x66)
      {
	//printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	//printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();

	current_bank=get_current_reg_bank();
	A = A ^ RAM[RAM[current_bank*8]];
      }

   if(opcode==0x67)
      {
	//printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	//printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();

	current_bank=get_current_reg_bank();
	A = A ^ RAM[RAM[current_bank*8+1]];
      }

   if(opcode>=0x68 && opcode<=0x6f)
      {
	printf("%s\n\r",instructions[ROM[PC]].mnemonic);
	printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   	current_bank=get_current_reg_bank();
	A = A ^ RAM[current_bank*8+(opcode-0x68)];
      }

}

void push_isr(opcode)
{
   opcode++;    //just to remove warnings...
   printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
   RAM[++SP] = RAM[ROM[++PC]];
}


void pop_isr(opcode)
{
   opcode++;    //just to remove warnings...
   printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
   RAM[ROM[++PC]] =  RAM[SP--];
}

void djnz_isr(opcode)
{
  int current_bank;

  if(opcode>=0xd8 && opcode<=0xdf)
    {
       printf("%s%X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
       printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
       current_bank=get_current_reg_bank();
       if( (--RAM[current_bank*8+(opcode-0xd8)])!=0 )
	  {
	    if(ROM[PC+1] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+1] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+1];
		  //PC++;
		}

	     PC++;
	  }

       else
	    PC++;
     }

 else
       {
	 printf("%s %.2X,#%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
	 printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
   refresh();

	 if( (--RAM[ROM[PC+1]])!=0 )
	  {
	    if(ROM[PC+2] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+2] + 1);
		  //PC+=2;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC+=2;
		}

	    PC+=2;
	  }


       else
	   PC+=2;
       }
}


void jz_isr(int opcode)
 {
   printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
     refresh();
    if( A==0 )
	  {
	    if(ROM[PC+1] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+1] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+1];
		  //PC++;
		}

	     PC++; //so that offset is counted from next instruction..
	     //PC--;
	  }

       else
	 PC++;

  opcode++;    //just to remove warnings...
 }


void jnz_isr(int opcode)
 {
   printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
   if( A!=0 )
	  {
	    if(ROM[PC+1] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+1] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+1];
		  //PC++;
		}

	     PC++; //so that offset is counted from next instruction..
	     //PC--;
	  }

       else
	 PC++;

  opcode++;    //just to remove warnings...
 }



void cjne_isr(opcode)
 {

    int current_bank;
    printf("%s%.2X,%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
    printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
      refresh();
    //printf("inside cjne_isr!!\n\r"); for debugging...

    if(opcode==0xb4)
      {
	 if(A<ROM[PC+1])
	    PSW = PSW | 128;
	else
	   if(A>ROM[PC+1])
	    PSW = PSW & 127;

	if(A!=ROM[PC+1])
	    {
	       if(ROM[PC+2] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+2] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     }



      }
if(opcode==0xb5)
      {

	 if(A<RAM[ROM[PC+1]])
	    PSW = PSW | 128;
	else
	   if(A>RAM[ROM[PC+1]])
	    PSW = PSW & 127;

	 if(A!=RAM[ROM[PC+1]])
	    {
	       if(ROM[PC+2] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+2] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     }


      }



if(opcode==0xb6)
      {

	 current_bank = get_current_reg_bank();
	 //printf("%x  %x %x\n\r",ROM[PC],ROM[PC+1],ROM[PC+2]);
	 //printf("%x  %x  %x\n\r",RAM[current_bank*8],RAM[RAM[current_bank*8]],RAM[ROM[PC+1]]);
			 //for debugging....
	 if(RAM[RAM[current_bank*8]] < ROM[PC+1])
	    PSW = PSW | 128;      //setting caryy flag...
	else
	   if(RAM[RAM[current_bank*8]] > ROM[PC+1])
	    PSW = PSW & 127;      //resetting carry flag...

	 if(RAM[RAM[current_bank*8]] !=  ROM[PC+1])
	    {
	       if(ROM[PC+2] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+2] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     }


      }


if(opcode==0xb7)
      {

	 current_bank = get_current_reg_bank();
	 if(RAM[RAM[current_bank*8+1]] < ROM[PC+1])
	    PSW = PSW | 128;      //setting caryy flag...
	else
	   if(RAM[RAM[current_bank*8+1]] > ROM[PC+1])
	    PSW = PSW & 127;      //resetting carry flag...

	 if(RAM[RAM[current_bank*8+1]] != ROM[PC+1])
	    {
	       if(ROM[PC+2] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+2] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     }


      }

if(opcode>=0xb8 && opcode<=0xbf)
      {

	 current_bank = get_current_reg_bank();
	 //printf("%x  %x\n\r",RAM[current_bank*8 + (opcode-0xb8)],ROM[PC+1]);
	 if(RAM[current_bank*8 + (opcode-0xb8)] < ROM[PC+1])
	    PSW = PSW | 128;      //setting caryy flag...
	else
	   if(RAM[current_bank*8 + (opcode-0xb8)] > ROM[PC+1])
	    PSW = PSW & 127;      //resetting carry flag...

	 if(RAM[current_bank*8 + (opcode-0xb8) ] != ROM[PC+1])
	    {
	       if(ROM[PC+2] & 0x80)
		{
		  PC = PC - (0xff - ROM[PC+2] + 1);
		  //PC++;
		  //PC--;
		  //PC-=2;
		}
	    else
		{
		  PC = PC + ROM[PC+2];
		  //PC++;
		}

	     }

      }

    PC+=2;

 }


void xch_isr(opcode)
 {
   int tempVar,current_bank;
   if(opcode==0xc5)
     {
       printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
       printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
          refresh();
   tempVar = A;
       A = RAM[ROM[PC+1]];
       RAM[ROM[PC+1]] = tempVar;
       PC++;

     }


  if(opcode==0xc6)
     {
       printf("%s\n\r",instructions[ROM[PC]].mnemonic);
       printf("%.4X:%.2X\n\r",PC,ROM[PC]);
          refresh();
   current_bank = get_current_reg_bank();
       tempVar = A;
       A = RAM[RAM[current_bank*8]];
       RAM[RAM[current_bank*8]] = tempVar;
     }

if(opcode==0xc7)
     {
       printf("%s\n\r",instructions[ROM[PC]].mnemonic);
       printf("%.4X:%.2X\n\r",PC,ROM[PC]);
          refresh();
   current_bank = get_current_reg_bank();
       tempVar = A;
       A = RAM[RAM[current_bank*8 + 1]];
       RAM[RAM[current_bank*8 + 1]] = tempVar;
     }


if(opcode>=0xc8 && opcode<=0xcf)
     {
       printf("%s\n\r",instructions[ROM[PC]].mnemonic);
       printf("%.4X:%.2X\n\r",PC,ROM[PC]);
          refresh();
   current_bank = get_current_reg_bank();
       tempVar = A;
       A = RAM[current_bank*8 + (opcode-0xc8) ];
       RAM[current_bank*8 + (opcode-0xc8) ] = tempVar;
     }

 }


void xchd_isr(int opcode)
 {
       // to swap lower nibbles between Acc and indirect memory....
   unsigned char lower_nibble,current_bank,tempA;
   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
      refresh();
   current_bank = get_current_reg_bank();
   if(opcode==0xd6)
     {
	lower_nibble = ( RAM[RAM[current_bank*8]] & 0x0f ) ;

	tempA = A;
	A = (A & 0xf0) | lower_nibble;

	lower_nibble = tempA & 0x0f;
	RAM[RAM[current_bank*8]] = (RAM[RAM[current_bank*8]] & 0xf0) | lower_nibble;

     }

   else
      if(opcode==0xd7)
       {
	lower_nibble = ( RAM[RAM[current_bank*8+1]] & 0x0f );

	tempA = A;
	A = (A & 0xf0) | lower_nibble;

	lower_nibble = tempA & 0x0f;
	RAM[RAM[current_bank*8+1]] = (RAM[RAM[current_bank*8+1]] & 0xf0) | lower_nibble;

       }
	//tempA = A;
	//A = (A & 0xf0) | lower_nibble;

   //opcode++; //just to remove warning for the time being....
 }





void mov_isr(opcode)
{

 unsigned int current_bank,tempDPTR;
 if(opcode==0x74)
  {
    printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
    printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
      refresh();
    A=ROM[++PC];
  }
  else
    if(opcode==0x75)
    {
      printf("%s %.2X,#%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
      printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
      refresh();
      RAM[ROM[PC+1]]=ROM[PC+2];
      PC+=2;
    }
     else
       if(opcode==0x76)
	{
	  printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	  printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   	  current_bank=get_current_reg_bank();
	  RAM[RAM[current_bank*8]]=ROM[++PC];
	}
       else
	if(opcode==0x77)
	{
	  printf("%s @R1,#%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	  printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   	  current_bank=get_current_reg_bank();
	  RAM[RAM[current_bank*8+1]]=ROM[++PC];
	}
       else
	 if(opcode>=0X78 && opcode<=0x7f)
	   {
	    printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
	    printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   	    current_bank=get_current_reg_bank();
	    RAM[current_bank*8+(opcode-0x78)]=ROM[++PC];

	   }
       else
	  if(opcode==0x85)
	    {
	      printf("%s %.2X,%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+2],ROM[PC+1]);
	      printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
   refresh();
   	      RAM[ROM[PC+2]]=RAM[ROM[PC+1]];
	      //RAM[ROM[PC+1]]=RAM[ROM[PC+2]];
	      PC+=2;
	    }
	   else
	      if(opcode==0x86)
		{
		  printf("%s%.2X,@R0\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
		  printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   		  current_bank=get_current_reg_bank();
		  RAM[ROM[++PC]]=RAM[RAM[current_bank*8]];

		}
	     else
	       if(opcode==0x87)
		 {
		   printf("%s%.2X,@R0\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
		   printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   		   current_bank=get_current_reg_bank();
		   RAM[ROM[++PC]]=RAM[RAM[current_bank*8+1]];

		}
	     else
		 if(opcode>=0x88 && opcode<=0x8f)
		   {
		    printf("%s%.2X,R%d\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],opcode-0x88);
		    printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   		    current_bank=get_current_reg_bank();
		    RAM[ROM[++PC]]=RAM[current_bank*8+(opcode-0x88)];


		  }
		else
		   if(opcode==0x90)
		     {

		       printf("%s%.2X%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
		       printf("%.4X:%.2X %.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1],ROM[PC+2]);
   refresh();
   		       DPH = ROM[PC+1];
		       DPL = ROM[PC+2];
		       //DPTR=ROM[PC+1]*256+ROM[PC+2];
		       PC+=2;
		     }

		 else
		    if(opcode==0x92)    // MOV dest bit,src bit instruction
		      {
		       printf("%s%.2X,C\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
		       printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   		       //RAM[ROM[++PC]]=A;

			  if(PSW & 0x80)  // means carry set if true..
			     {
			       //set addressed bit...
				 if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
					RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] | (unsigned char) pow(2,(ROM[PC+1] % 8) );
				 else   // for SFR bits.....
					if( ROM[PC+1] >0x7f )
						{
							//offset = ROM[PC+1] % 8;
							//loc = 8 * ( ROM[PC +1] /8 );
							//RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
							RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] | (unsigned char)(pow (2,ROM[PC+1] % 8));

						}
			     }

			  else
			     if( !(PSW &0x80)  )  //means carry is clear...
				   {
				     //clear addressed bit...
					 if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
						RAM[0x20 + (ROM[PC + 1] /8)] = RAM[0x20 + (ROM[PC + 1] /8)] & ~(unsigned char) pow(2,(ROM[PC+1] % 8) );
   /*look out for opcode=0x83 and 0x93*/   else   // for SFR bits.....
   /*down below..abt 137 lines below..*/ if( ROM[PC+1] >0x7f )
						{
						  //offset = ROM[PC+1] % 8;
						  //loc = 8 * ( ROM[PC +1] /8 );
						  //RAM[loc] = RAM[loc] & ~(unsigned char)(pow (2,offset));
						  RAM[8 * ( ROM[PC +1] /8 )] = RAM[8 * ( ROM[PC +1] /8 )] & ~(unsigned char)(pow (2,ROM[PC+1] % 8));

						}

				   }


			PC++;
		      }


		  else
		     if( opcode==0xa2)

		       {
			  printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
			  printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   			  if(ROM[PC+1] <= 0x7f)  // for bit addresses between 20h and 30h
				{
				   if( RAM[0x20 + (ROM[PC + 1] /8)] & (unsigned char) pow(2,(ROM[PC+1] % 8) ))
					PSW = PSW | 0x80;
				   else
					PSW = PSW & 0x7f;
				}
			  else
			     if( ROM[PC+1] >0x7f )
				{
				  if(  RAM[8 * ( ROM[PC +1] /8 )] & (unsigned char)(pow (2,ROM[PC+1] % 8)))
					PSW = PSW | 0x80;
				  else
				      PSW = PSW & 0x7f;
				}

			 PC++;
		       }



		  else
		     if(opcode==0xa6)
		       {
			 printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
			 printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   			 current_bank=get_current_reg_bank();
			 RAM[RAM[current_bank*8]]=RAM[ROM[++PC]];

		       }

		     else
		       if(opcode==0xa7)
		       {
			 printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
			 printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   			 current_bank=get_current_reg_bank();
			 RAM[RAM[current_bank*8+1]]=RAM[ROM[++PC]];

		       }
		    else
		       if(opcode>=0xa8 && opcode<=0xaf)
			{
			 printf("%s%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
			 printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   			 current_bank=get_current_reg_bank();
			 RAM[current_bank*8+(opcode-0xa8)]=RAM[ROM[++PC]];
			}
		    else
		       if(opcode==0xe5)
			{
			  printf("%s %X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
			  printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   			  A = RAM[ROM[++PC]];
			}



		    else
		       if(opcode==0xe6)
			 {
			   printf("%s\n\r",instructions[ROM[PC]].mnemonic);
			   printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   			   current_bank=get_current_reg_bank();
			   A=RAM[RAM[current_bank*8]];
			 }
		       else
			 if(opcode==0xe7)
			   {
			     printf("%s\n\r",instructions[ROM[PC]].mnemonic);
			     printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   			     current_bank=get_current_reg_bank();
			     A=RAM[RAM[current_bank*8+1]];
			   }
			 else
			  if(opcode>=0xe8 && opcode<=0xef)
			    {
			      printf("%s\n\r",instructions[ROM[PC]].mnemonic);
			      printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   			      current_bank=get_current_reg_bank();
			      A=RAM[current_bank*8+(opcode-0xe8)];
			    }

			  else
			     if(opcode==0xf5)
			       {
				 printf("%s%.2X,A\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1]);
				 printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);
   refresh();
   				 RAM[ROM[++PC]]=A;
			      }

			     else
				if(opcode==0xf6)
				  {
				    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
				    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   				    current_bank=get_current_reg_bank();
				    RAM[RAM[current_bank*8]]=A;
				  }
				if(opcode==0xf7)
				  {
				    printf("%s\n\r",instructions[ROM[PC]].mnemonic);
				    printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   				    current_bank=get_current_reg_bank();
				    RAM[RAM[current_bank*8+1]]=A;
				  }
				 else
				    if(opcode>=0xf8 && opcode<=0xff)
				      {
					printf("%s\n\r",instructions[ROM[PC]].mnemonic);
					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   					current_bank=get_current_reg_bank();
					RAM[current_bank*8+(opcode-0xf8)]=A;
				      }
				 else
				    if(opcode==0x83)
				      {
					printf("%s\n\r",instructions[ROM[PC]].mnemonic);
					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   					A = ROM[A + PC + 1];
				      }

				 else
				    if(opcode==0x93)
				      {
					printf("%s\n\r",instructions[ROM[PC]].mnemonic);
					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
   refresh();
   					tempDPTR = DPH * 0x100 + DPL;
					A = ROM[A + tempDPTR];

				      }
				else
				   if(opcode==0xe0)
				   {

					printf("%s\n\r",instructions[ROM[PC]].mnemonic);

					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
			
					tempDPTR = DPH * 0x100 + DPL;
					A = XDATA[tempDPTR];
				   }

			else
				   if(opcode==0xf0)
				   {

					printf("%s\n\r",instructions[ROM[PC]].mnemonic);

					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
			
					tempDPTR = DPH * 0x100 + DPL;
					XDATA[tempDPTR] = A; 
		
					
				   }

			else
				   if(opcode==0xe2)
				   {

					printf("%s\n\r",instructions[ROM[PC]].mnemonic);

					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
					
					current_bank=get_current_reg_bank();
			   		
					A = XDATA[RAM[current_bank*8]];
	
				   }


			else
				   if(opcode==0xe3)
				   {

					printf("%s\n\r",instructions[ROM[PC]].mnemonic);

					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
					
					current_bank=get_current_reg_bank();
			   		
					A = XDATA[RAM[current_bank*8+1]];
	
				   }
			else
				   if(opcode==0xf2)
				   {

					printf("%s\n\r",instructions[ROM[PC]].mnemonic);

					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
					
					current_bank=get_current_reg_bank();
			   		
					XDATA[RAM[current_bank*8]] = A ;
	
				   }



			else
				   if(opcode==0xf3)
				   {

					printf("%s\n\r",instructions[ROM[PC]].mnemonic);

					printf("%.4X:%.2X\n\r",PC,ROM[PC]);
					
					current_bank=get_current_reg_bank();
			   		
					XDATA[RAM[current_bank*8+1]] = A ;
	
				   }



				 
 //printf("inside dummy_isr");


}


void proceed_execution()
 {
    unsigned int initPC,finalPC;
    char str[6];
    //if(instructions[ROM[PC]].nobytes==1)
       finalPC = PC + instructions[ROM[PC]].nobytes;
       go_flag=1;
       //while(PC != finalPC)
	while(1)
	 {
	   //go_flag=1;
	   if( PC==finalPC )
	     break;
	   sprintf(str,"%X",PC);
	   trace_code(str,1);  // arg supplied....
	   printf("\n\r");

	 }
      go_flag=0;
      display_shell();
 }

void vector_to_interrupt()
 {
      char sint[5];
      unsigned char PCL,PCH;
      int nint;
      unsigned int tempPC;
      printf("         ****List of available 8051 interrupts****\n\r\n\r");
      printf("Reset(Jumps to PC=0000): 0\n\r\n\r");
      printf("Ext INT0 (Vectors to PC=0003: 1\n\r\n\r");
      printf("Ext INT1 (Vectors to PC=0013: 2\n\r\n\r");
      printf("Timer0 TF0 (Vectors to PC=000B: 3\n\r\n\r");
      printf("Timer1 TF1 (Vectors to PC=001B: 4\n\r\n\r");
      printf("SerialCOM RI or TI (Vectors to PC=0023: 5\n\r\n\r");
      printf("Enter the Interrupt Vector no.[0-5]:");
   refresh();

      getstr(sint);
      sscanf(sint,"%X",&nint);
      //tempPC = PC + instructions[ROM[PC]].nobytes;
      tempPC = PC;
   /*   PCL = (unsigned char) (tempPC &0xff);
      PCH = (unsigned char) ((tempPC>>8)&0xff);
      RAM[++SP] = PCL;       //preparing the stack...
      RAM[++SP] = PCH;       //before the ISR is called...  */

      switch(nint)
       {

	   case 0:
		  PC = 0x0000;
		  printf("\n\rTransferring control to RESET Vector...\n\r\n\r");
   refresh();
   		  PCL = (unsigned char) (tempPC &0xff);
		  PCH = (unsigned char) ((tempPC>>8)&0xff);
		  RAM[++SP] = PCL;       //preparing the stack...
		  RAM[++SP] = PCH;       //before the ISR is called...
		  reset_memory();
		  break;


	   case 1:
		  PC = 0x0003;
		  printf("\n\rTransferring control to Ext INT0 Vector...\n\r\n\r");
   refresh();
   		  PCL = (unsigned char) (tempPC &0xff);
		  PCH = (unsigned char) ((tempPC>>8)&0xff);
		  RAM[++SP] = PCL;       //preparing the stack...
		  RAM[++SP] = PCH;       //before the ISR is called...
		  break;

	   case 2:
		  PC = 0x0013;
		  printf("\n\rTransferring control to Ext INT1 Vector...\n\r\n\r");
   refresh();
   		  PCL = (unsigned char) (tempPC &0xff);
		  PCH = (unsigned char) ((tempPC>>8)&0xff);
		  RAM[++SP] = PCL;       //preparing the stack...
		  RAM[++SP] = PCH;       //before the ISR is called...
		  break;


	   case 3:
		  PC = 0x000B;
		  printf("\n\rTransferring control to Timer0 TF0 Vector...\n\r\n\r");
   refresh();
   		  PCL = (unsigned char) (tempPC &0xff);
		  PCH = (unsigned char) ((tempPC>>8)&0xff);
		  RAM[++SP] = PCL;       //preparing the stack...
		  RAM[++SP] = PCH;       //before the ISR is called...
		  break;


	   case 4:
		  PC = 0x001B;
		  printf("\n\rTransferring control to Timer0 TF1 Vector...\n\r\n\r");
   refresh();
   		  PCL = (unsigned char) (tempPC &0xff);
		  PCH = (unsigned char) ((tempPC>>8)&0xff);
		  RAM[++SP] = PCL;       //preparing the stack...
		  RAM[++SP] = PCH;       //before the ISR is called...
		  break;


	   case 5:
		  PC = 0x0023;
		  printf("\n\rTransferring control to SerialCOM RI or TI Vector...\n\r\n\r");
   refresh();
   		  PCL = (unsigned char) (tempPC &0xff);
		  PCH = (unsigned char) ((tempPC>>8)&0xff);
		  RAM[++SP] = PCL;       //preparing the stack...
		  RAM[++SP] = PCH;       //before the ISR is called...
		  break;


	   default:
		   printf("\n\rThe response \"%s\" is incorrect!\n\r",sint);
                   refresh();
    		   break;
	  }

      show_regs('0');
      display_shell();


 }







void disassemble_code(int start,char flag)
 {

    char lines=0,konst,col_flag=0;
    //int i;
    UC=start;

   if(flag==0)   // means normal 16 line disassemble...
      konst=16;
   else if(flag==1)   // means single line disassemble...
      konst=1;
  //for(;UC<=start+0xf,;UC++)



   for(;lines<konst;lines++,UC++)
     {

       col_flag = check_for_bkpoint(UC);
			//1 means bkpoint...0 means no bkpoint
	if(instructions[ROM[UC]].nobytes==1)
     {
	if(col_flag==0)     //no bkpoint...
	  {
	    printf("%.4X: %.2X        %s\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic);
            refresh();

          }
	else
	   if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	       printf("%.4X: %.2X        %s      %c\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic,42);
	         refresh();
   //printf("hello\n\r");				      //  extra '\r' needed...
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }
	//UC++;
     }

 else if(instructions[ROM[UC]].nobytes==2)
     {
	col_flag = check_for_bkpoint(UC);

	if(instructions[ROM[UC]].hex_code==0x86)
	 {
	  if(col_flag==0)     //no bkpoint...
	     {

		 printf("%.4X: %.2X %.2X     %s%.2X,@R0\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
                 refresh();

	     }
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      printf("%.4X: %.2X %.2X     %s%.2X,@R0      %c\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],42);
   refresh();
   					      //  extra '\r' needed...
	      //printf("hello\n\r");				      //  extra '\r' needed...
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }


	  UC++;
	 }
	else
	   if(instructions[ROM[UC]].hex_code==0x87)
	    {
	     //printf("%.4X: %.2X %.2X     %s%.2X,@R1\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);

	     if(col_flag==0)     //no bkpoint...
	       {
	           printf("%.4X: %.2X %.2X     %s%.2X,@R1\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
    		   refresh();

	       }
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	       printf("%.4X: %.2X %.2X     %s%.2X,@R1      %c\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],42);
		   refresh();
   			      //  extra '\r' needed...
	       //printf("hello\n\r");
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }

	     UC++;
	    }
	   else
	      if(instructions[ROM[UC]].hex_code>=0x88 && instructions[ROM[UC]].hex_code<=0x8f)
	       {
		 //printf("%.4X: %.2X %.2X     %s%.2X,R%d\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],instructions[ROM[UC]].hex_code-0x88);

	    if(col_flag==0)     //no bkpoint...
               {
	         printf("%.4X: %.2X %.2X     %s%.2X,R%d\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],instructions[ROM[UC]].hex_code-0x88);
   		 refresh();

	       }
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);

	       printf("%.4X: %.2X %.2X     %s%.2X,R%d      %c\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],instructions[ROM[UC]].hex_code-0x88,42);				      //  extra '\r' needed...
	         refresh();
   //textcolor(7);
	      //printf("hello\n\r");
	      col_flag = 0;   //bkpoint...
	     }

	 UC++;
	       }
	     else
		if((instructions[ROM[UC]].hex_code==0xf5) || (instructions[ROM[UC]].hex_code==0x42) || (instructions[ROM[UC]].hex_code==0x52) || (instructions[ROM[UC]].hex_code==0x62))
		 {
		   //printf("%.4X: %.2X %.2X     %s%.2X,A\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
		   //printf("%.4X:%.2X %.2X\n\r",PC,ROM[PC],ROM[PC+1]);

	  if(col_flag==0)     //no bkpoint...
	       {
	         printf("%.4X: %.2X %.2X     %s%.2X,A\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
   		 refresh();

	       }//printf("%.4X: %.2X %.2X     %s%.2X,R%d\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],instructions[ROM[UC]].hex_code-0x88);
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	       printf("%.4X: %.2X %.2X     %s%.2X,A      %c\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],42);
	   refresh();
          //printf("%.4X: %.2X %.2X     %s%.2X,R%d\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],instructions[ROM[UC]].hex_code-0x88);				      //  extra '\r' needed...
	      //textcolor(7);
	       //printf("hello\n\r");
	      col_flag = 0;   //bkpoint...
	     }

     UC++;
		}

	     else
		if( (instructions[ROM[UC]].hex_code==0x92)  )
		 {
		    //printf("%.4X: %.2X %.2X     %s%.2X,C\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);

	  if(col_flag==0)     //no bkpoint...
	     {
	       printf("%.4X: %.2X %.2X     %s%.2X,C\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	       refresh();
    	     }
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	       //printf("%.4X: %.2X %.2X     %s%.2X,A\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	       printf("%.4X: %.2X %.2X     %s%.2X,C      %c\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],42);
	         refresh();
   //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }

      UC++;


		 }


	     else
		{
		 //printf("%.4X: %.2X %.2X     %s%.2X\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	  if(col_flag==0)     //no bkpoint...
	     {
	      printf("%.4X: %.2X %.2X     %s%.2X\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
              refresh();
 	     }

	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      printf("%.4X: %.2X %.2X     %s%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1],42);
	         refresh();
   //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }

     UC++;     //required due to strange behaviour of 'printf'!!

		}


     }

else   if(instructions[ROM[UC]].nobytes==3)
     {
       col_flag = check_for_bkpoint(UC);

       if((instructions[ROM[UC]].hex_code==0x75) || (instructions[ROM[UC]].hex_code==0x43)  || (instructions[ROM[UC]].hex_code==0x53)  || (instructions[ROM[UC]].hex_code==0x63))
	 {
	   //printf("%.4X: %.2X %.2X %.2X  %s%.2X,#%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);

	   if(col_flag==0)     //no bkpoint...
	     {
	      printf("%.4X: %.2X %.2X %.2X  %s%.2X,#%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	        refresh();
   //printf("%.4X: %.2X %.2X     %s%.2X\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	     }
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      printf("%.4X: %.2X %.2X %.2X  %s%.2X,#%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2],42);
   refresh();

	      //printf("%.4X: %.2X %.2X     %s%.2X       B\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }

	   UC+=2;
	 }

       else
	  if(instructions[ROM[UC]].hex_code==0x02)
	  {
	    //printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);

	    if(col_flag==0)     //no bkpoint...
	       {
	          printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	        refresh();
	       }
   //printf("%.4X: %.2X %.2X     %s%.2X\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2],42);
	         refresh();
   //printf("%.4X: %.2X %.2X     %s%.2X       B\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }

	    UC+=2;
	  }
	  else
	     if(instructions[ROM[UC]].hex_code==0x90)
	       {
		//printf("%s%.2X%.2X\n\r",instructions[ROM[PC]].mnemonic,ROM[PC+1],ROM[PC+2]);
	       //printf("%.4X: %.2X %.2X %.2X  %s%.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);

	 if(col_flag==0)     //no bkpoint...
	    {
	       printf("%.4X: %.2X %.2X %.2X  %s%.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
   	       refresh();

	     //printf("%.4X: %.2X %.2X     %s%.2X\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	    }
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      printf("%.4X: %.2X %.2X %.2X  %s%.2X%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2],42);
   refresh();

	      //printf("%.4X: %.2X %.2X     %s%.2X       B\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }

	UC+=2;

	       }
	 else
	 if(instructions[ROM[UC]].hex_code>=0xb4 && instructions[ROM[UC]].hex_code<=0xbf)
	   {
	     //printf("%.4X: %.2X %.2X %.2X  %s%.2X,%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	 if(col_flag==0)     //no bkpoint...
	     {
	       printf("%.4X: %.2X %.2X %.2X  %s%.2X,%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	        refresh();
   		//printf("%.4X: %.2X %.2X %.2X  %s%.2X,#%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	     //printf("%.4X: %.2X %.2X     %s%.2X\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	     }
	  else
	     if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      //printf("%.4X: %.2X %.2X %.2X  %s%.2X,#%.2X      B\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	      printf("%.4X: %.2X %.2X %.2X  %s%.2X,%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2],42);
	         refresh();
   //printf("%.4X: %.2X %.2X     %s%.2X       B\n\r",UC,ROM[UC],ROM[UC+1],instructions[ROM[UC]].mnemonic,ROM[UC+1]);
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }

	     UC+=2;
	   }

	 else
	 if(instructions[ROM[UC]].hex_code==0x12)// && instructions[ROM[UC]].hex_code<=0xbf)
	   {
	     //printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	if(col_flag==0)     //no bkpoint...
	   {
	     printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
             refresh();
	   }
	  //printf("%.4X: %.2X        %s\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic);
	else
	   if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2],42);
   	      refresh();

	       //printf("%.4X: %.2X        %s      B\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic);
	      //printf("hello\n\r");				      //  extra '\r' needed...
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }
	//UC++;


	     UC+=2;
	   }



else
	 if(instructions[ROM[UC]].hex_code==0x85)// && instructions[ROM[UC]].hex_code<=0xbf)
	   {

	     //printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	if(col_flag==0)     //no bkpoint...
           {
	    printf("%.4X: %.2X %.2X %.2X  %s %.2X,%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+2],ROM[UC+1]);
	      refresh();
   //printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	  //printf("%.4X: %.2X        %s\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic);
	   }
	else
	   if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	       printf("%.4X: %.2X %.2X %.2X  %s %.2X,%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+2],ROM[UC+1],42);
	         refresh();
   //printf("%.4X: %.2X %.2X %.2X  %s %.2X%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2],15);

	       //printf("%.4X: %.2X        %s      B\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic);
	      //printf("hello\n\r");				      //  extra '\r' needed...
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }
	//UC++;


	     UC+=2;
	   }




       else
	  {
	    //printf("%.4X: %.2X %.2X %.2X  %s %.2X,%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);

	if(col_flag==0)     //no bkpoint...
	   {
	    printf("%.4X: %.2X %.2X %.2X  %s %.2X,%.2X\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2]);
	       refresh();

	  //printf("%.4X: %.2X        %s\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic);
	   }
	else
	   if(col_flag==1)
	     {
	      //textcolor(RED);//+BLINK);
	      printf("%.4X: %.2X %.2X %.2X  %s %.2X,%.2X      %c\n\r",UC,ROM[UC],ROM[UC+1],ROM[UC+2],instructions[ROM[UC]].mnemonic,ROM[UC+1],ROM[UC+2],42);
   refresh();

	       //printf("%.4X: %.2X        %s      B\n\r",UC,ROM[UC],instructions[ROM[UC]].mnemonic);
	      //printf("hello\n\r");				      //  extra '\r' needed...
	      //textcolor(7);
	      col_flag = 0;   //bkpoint...
	     }
	//UC++;

    UC+=2;
	  }

     }
	
  }
 if(go_flag==0)
   display_shell();

 }

void set_flags(unsigned int value,unsigned char op1, unsigned char op2,unsigned char mask)
{
//this function when called examines the 'value' parameter and sets
// the PSW flags based on the mask supplied to it.....

int temp=0;           //temp must be an int to detect carry from 8th bit...
unsigned char temp_flag_bits=0,oldPSW,flag1,flag2;
oldPSW=PSW;            //saving the current PSW...
temp=value & 256;

if(temp)
   temp_flag_bits=temp_flag_bits | 128;    //evaluating the flags....
			    //and building up the temp flag bits...
else                        //this involves several steps,
   temp_flag_bits=temp_flag_bits | 0;      //for all the flags are involved...


  // flag1 = test_for_carry(op1,op2,6);
  // flag2 = test_for_carry(op1,op2,7);
   //if(  flag1  && (!flag2)   )
  if(  (test_for_carry(op1,op2,6))  && !(test_for_carry(op1,op2,7))   )
    temp_flag_bits=temp_flag_bits | 4;    //checking for OV flag...

   //if(  flag2  && (!flag1) )
  if(  (test_for_carry(op1,op2,7))  && !(test_for_carry(op1,op2,6)  )     )
    temp_flag_bits=temp_flag_bits | 4;    //checking for OV flag...


  if( (test_for_carry(op1,op2,3))  )
    temp_flag_bits=temp_flag_bits | 64;    //checking for AC flag...

  if( (count_no_of_ones(A)%2)!=0 )
    temp_flag_bits=temp_flag_bits | 1;    //checking for P flag...

  else
     if( (count_no_of_ones(A)%2)==0 )
       temp_flag_bits=temp_flag_bits & 0xfe;    //checking for P flag...



temp_flag_bits=temp_flag_bits & mask;  //finally masking to get only
				      //the needed flags...
				      //this step should be performed
				      //after all the flags are evaluated...
PSW=temp_flag_bits;   //transferring temp_flag to the PSW...
PSW=PSW | oldPSW;    //restoring the unchanged flag values....

}


/*void addc_isr(int opcode)
{
//printf("inside addc_isr!");   // isr for adding with carry....

} */

char test_for_carry(unsigned char op1,unsigned char op2,unsigned char pos)
 {
  char iscarry;
  if ( (op1 & op2) & (unsigned char)(pow(2,pos))    )
	 return 1;     // returning a carry if both are 1s

  else
   //  {
     if( (op1 | op2) & (unsigned char)(pow(2,pos))  )
	     { iscarry=test_for_carry(op1,op2,pos-1);  //recursing if both are different..
	       if(iscarry==1)
		  return 1;
	       else
		  return 0;
	     }
	    //iscarry++;
	 //   return 67;
     else
	 return 0;  // returning a no carry if both are 0s
  //   }
//iscarry++;
/* if(iscarry==1)
  return -1;
else
  return -1;  */
//printf("hello");

 }


unsigned char count_no_of_ones(unsigned char val)
 {
   unsigned char count,no_ones=0,no_zeroes=0;
   //val=0x88;

   for (count=0;count<=7;count++)
    {
	if(  ((val>>count) & 0x01)    )
	  no_ones++;
	else
	   no_zeroes++;
    }

   //clrscr();
   //printf(" 1s = %d  0s = %d ",no_ones,no_zeroes);
   return no_ones;
   //getch();
 }

void reset_memory()      // this function brings the 8051 CPU in a reset
 {			//state
   int pos;
   for(pos=0;pos<=255;pos++)  //clearing data(RAM) Area
     RAM[pos]=0;

     RAM[0x81]=0x07;
   for(pos=0;pos<=4095;pos++)   //clearing Code Area
     ROM[pos]=0;

 }
