const Ci = Components.interfaces;

const CLASS_ID = Components.ID("5D744206-AF1C-11DC-AD9A-481A56D89593");
const CLASS_NAME = "simplemail protocol handler";
const CONTRACT_ID = "@mozilla.org/network/protocol;1?name=simplemail";

function SimpleMailProtocolHandler() {
}

SimpleMailProtocolHandler.prototype = {
  defaultPort: -1,
  protocolFlags: 0,
  scheme: "simplemail",

  allowPort: function(port, scheme) { return false; },

  newChannel: function(url) {
    var file = this.getDataDirectory();
    var fileUrl = this.getFileURL(file) + url.host + url.path;

    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
    var bstream = Components.classes["@mozilla.org/binaryinputstream;1"]
                  .createInstance(Components.interfaces.nsIBinaryInputStream);
    return ioService.newChannel(fileUrl, null, null);
  },

  getDataDirectory: function() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                .getService(Components.interfaces.nsIPrefService)
                .getBranch("extensions.simplemail.");
    var file;
    try {
      file = prefs.getComplexValue("dataDirectory",
                                   Components.interfaces.nsIRelativeFilePref).file;
    }
    catch(e) {
      file = prefs.getComplexValue("dataDirectory",
                                   Components.interfaces.nsILocalFile);
    }
    if (!file.exists()) file.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0777);
    return file;
  },

  getFileURL: function(file) {
    var ios = Components.classes["@mozilla.org/network/io-service;1"]
              .getService(Components.interfaces.nsIIOService);
    var fileHandler = ios.getProtocolHandler("file")
                     .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
    return fileHandler.getURLSpecFromFile(file);
  },

  newURI: function(spec, originCharset, baseURI) {
    var url = Components.classes["@mozilla.org/network/standard-url;1"]
              .createInstance(Ci.nsIURL);
    url.spec = spec;
    return url;
  },

  QueryInterface: function(aIID) {
    if (!aIID.equals(Ci.nsIProtocolHandler) && !aIID.equals(Ci.nsISupports))
        throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  },
};

// Factory
var SimpleMailProtocolHandlerFactory = {
  singleton: null,
  createInstance: function (aOuter, aIID) {
    if (aOuter != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;
    if (this.singleton == null)
      this.singleton = new SimpleMailProtocolHandler();
    return this.singleton.QueryInterface(aIID);
  }
};

// Module
var SimpleMailProtocolHandlerModule = {
  registerSelf: function(aCompMgr, aFileSpec, aLocation, aType) {
    aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
    aCompMgr.registerFactoryLocation(CLASS_ID, CLASS_NAME, CONTRACT_ID, aFileSpec, aLocation, aType);
  },

  unregisterSelf: function(aCompMgr, aLocation, aType) {
    aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
    aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);        
  },
  
  getClassObject: function(aCompMgr, aCID, aIID) {
    if (!aIID.equals(Ci.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

    if (aCID.equals(CLASS_ID))
      return SimpleMailProtocolHandlerFactory;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function(aCompMgr) { return true; }
};

// Module initialization
function NSGetModule(aCompMgr, aFileSpec) { return SimpleMailProtocolHandlerModule; }
