const Ci = Components.interfaces;

const CLASS_ID = Components.ID("F0349348-724A-11DC-BDCB-39D355D89593");
const CLASS_NAME = "mailto protocol handler";
const CONTRACT_ID = "@mozilla.org/network/protocol;1?name=mailto";

function MailtoProtocolHandler() {
}

MailtoProtocolHandler.prototype = {
  defaultPort: -1,
  protocolFlags: 0,
  scheme: "mailto",

  allowPort: function(port, scheme) { return false; },

  newChannel: function(uri) {
    this.getBrowserWindow().SimpleMail.openNewMessage(null, uri.spec);

    // return a fake empty channel so current window doesn't change
    return Components.classes["@mozilla.org/network/input-stream-channel;1"]
           .getService(Ci.nsIChannel);
  },

  newURI: function(spec, originCharset, baseURI) {
    var uri = Components.classes["@mozilla.org/network/simple-uri;1"]
              .getService(Ci.nsIURI);
    uri.spec = spec;
    return uri;
  },

  QueryInterface: function(aIID) {
    if (!aIID.equals(Ci.nsIProtocolHandler) && !aIID.equals(Ci.nsISupports))
        throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  },

  getBrowserWindow: function() {
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
             .getService(Ci.nsIWindowMediator);
    return wm.getMostRecentWindow("navigator:browser");
  }
};

// Factory
var MailtoProtocolHandlerFactory = {
  singleton: null,
  createInstance: function (aOuter, aIID) {
    if (aOuter != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;
    if (this.singleton == null)
      this.singleton = new MailtoProtocolHandler();
    return this.singleton.QueryInterface(aIID);
  }
};

// Module
var MailtoProtocolHandlerModule = {
  registerSelf: function(aCompMgr, aFileSpec, aLocation, aType) {
    aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
    aCompMgr.registerFactoryLocation(CLASS_ID, CLASS_NAME, CONTRACT_ID, aFileSpec, aLocation, aType);
  },

  unregisterSelf: function(aCompMgr, aLocation, aType) {
    aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
    aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);        
  },
  
  getClassObject: function(aCompMgr, aCID, aIID) {
    if (!aIID.equals(Ci.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

    if (aCID.equals(CLASS_ID))
      return MailtoProtocolHandlerFactory;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function(aCompMgr) { return true; }
};

// Module initialization
function NSGetModule(aCompMgr, aFileSpec) { return MailtoProtocolHandlerModule; }
