// Code taken from: http://developer.mozilla.org/en/docs/Chrome:_Command_Line

const contractID = "@mozilla.org/commandlinehandler/general-startup;1?type=simplemail";
const CID = Components.ID("{97F3D658-4931-11DD-A820-938C56D89593}");
const category = "m-simplemail";

const SimpleMailHandler = {
  QueryInterface: function(iid) {
    if (iid.equals(Components.interfaces.nsICommandLineHandler) ||
        iid.equals(Components.interfaces.nsIFactory) ||
        iid.equals(Components.interfaces.nsISupports))
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  handle : function(cmdLine) {
    var simplemail = cmdLine.handleFlag("simplemail", false);
    var simplemailtab = cmdLine.handleFlag("simplemailtab", false);
    if (!simplemail && !simplemailtab) return;

    cmdLine.preventDefault = true;

    function openSimpleMail() {
      if (simplemail) {
        var navbox = wnd.document.getElementById("navigator-toolbox");
        navbox.collapsed = true;
        var tabContainer = wnd.getBrowser().mTabContainer;
        tabContainer.collapsed = true;
        var bottombox = wnd.document.getElementById("browser-bottombox");
        bottombox.collapsed = true;
      }
      wnd.setTimeout(wnd.SimpleMail.open, simplemailtab ? 100 : 0);
    }
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
             .getService(Components.interfaces.nsIWindowMediator);
    var wnd = wm.getMostRecentWindow("navigator:browser");
    if (simplemailtab && wnd) return openSimpleMail();

    var ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
             .getService(Components.interfaces.nsIWindowWatcher);
    var wnd = ww.openWindow(null, "chrome://browser/content/browser.xul", null, "resizable", null);
    wnd.addEventListener("load", openSimpleMail, false);
  },

  createInstance: function(outer, iid) {
    if (outer != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;

    return this.QueryInterface(iid);
  },

  lockFactory : function(lock) {}
};

const SimpleMailHandlerModule = {
  QueryInterface : function(iid) {
    if (iid.equals(Components.interfaces.nsIModule) ||
        iid.equals(Components.interfaces.nsISupports))
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  getClassObject: function(compMgr, cid, iid) {
    if (cid.equals(CID))
      return SimpleMailHandler.QueryInterface(iid);

    throw Components.results.NS_ERROR_NOT_REGISTERED;
  },

  registerSelf : function mod_regself(compMgr, fileSpec, location, type) {
    compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
    compMgr.registerFactoryLocation(CID,
                                    "SimpleMailHandler",
                                    contractID,
                                    fileSpec,
                                    location,
                                    type);

    var catMan = Components.classes["@mozilla.org/categorymanager;1"].
      getService(Components.interfaces.nsICategoryManager);
    catMan.addCategoryEntry("command-line-handler",
                            category,
                            contractID, true, true);
  },

  unregisterSelf : function mod_unreg(compMgr, location, type) {
    compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
    compMgr.unregisterFactoryLocation(CID, location);

    var catMan = Components.classes["@mozilla.org/categorymanager;1"].
      getService(Components.interfaces.nsICategoryManager);
    catMan.deleteCategoryEntry("command-line-handler", category);
  },

  canUnload : function (compMgr) {
    return true;
  }
};

function NSGetModule(comMgr, fileSpec) {
  return SimpleMailHandlerModule;
}
