var SmDom = {
  get: function(id) {
    return document.getElementById(id);
  },
  remove: function(id) {
    var element = SmDom.get(id);
    if (element) {
      element.parentNode.removeChild(element);
    }
  }
}

var SmDate = {
  toMIME: function(date) {
    var date = new Date(date);
    return date.toString().replace(/(^\w+) (\w+) (\w+) (.*) GMT(.*)/,
                                   "$1, $3 $2 $4 $5");
  },

  toString: function(date) {
    var date = new Date(date);
    if (!date.getTime()) return "";

    var timeZone = - date.getTimezoneOffset() / 60;
    return SmUtils.pad(date.getDate()) + "/" +
           SmUtils.pad(date.getMonth() + 1) + "/" +
           date.getFullYear().toString().substr(2) + " " +
           SmUtils.pad(date.getHours()) + ":" +
           SmUtils.pad(date.getMinutes()) + ":" +
           SmUtils.pad(date.getSeconds());
  },

  toGMT: function(date) {
    var date = new Date(date);
    if (!date.getTime()) return "";

    var gmt = new Date(date.getTime() + date.getTimezoneOffset() * 60 * 1000);
    return gmt.getFullYear() + "-" +
           SmUtils.pad(gmt.getMonth() + 1) + "-" +
           SmUtils.pad(gmt.getDate()) + " " +
           SmUtils.pad(gmt.getHours()) + ":" +
           SmUtils.pad(gmt.getMinutes()) + ":" +
           SmUtils.pad(gmt.getSeconds()) + " GMT";
  },

  timePassed: function(date) {
    if (date) {
      var seconds = Math.floor((new Date() - date) / 1000);
      var hours = Math.floor(seconds / 3600);
      seconds = seconds - hours * 3600;
      var minutes = Math.floor(seconds / 60);
      seconds = seconds - minutes * 60;
      return SmUtils.pad(hours) + ":" +
             SmUtils.pad(minutes) + ":" +
             SmUtils.pad(seconds);
    }
  },

  parse: function(date) {
    // Convert short year to full
    date = date.replace(/(\w+, \d+ \w+) (\d{2}) /, "$1 20$2 ");
    return Date.parse(date);
  }
}

var SmUtils = {
  getVersion: function() {
    var em = Components.classes["@mozilla.org/extensions/manager;1"]
             .getService(Components.interfaces.nsIExtensionManager);
    var addon = em.getItemForID("simplemail@telega.phpnet.us");
    return addon.version;
  },

  pad: function(number) {
    return (number < 10) ? "0" + number : number;
  },

  // Make a reversed copy of an array, preserving keys
  reverse: function(array) {
    var reverseKeys = new Array();
    for(var i in array) {
      reverseKeys.unshift(i);
    }
    var result = new Object();
    for(var i in reverseKeys) {
      var key = reverseKeys[i];
      result[key] = array[key];
    }
    return result;
  },

  merge: function(array1, array2) {
    var result = new Array();
    for(var i in array1) {
      result[i] = array1[i];
    }

    for(var i in array2) {
      if (array2[i] != null) result[i] = array2[i];
    }
    return result;
  },

  clearElement: function(element) {
    for(var i = element.childNodes.length - 1; i >= 0; i--) {
      element.removeChild(element.childNodes[i]);
    }
  },

  alert: function(message, title) {
    var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                  .getService(Components.interfaces.nsIPromptService);
    return prompts.alert(window, title || "Simple Mail", message);
  },

  confirm: function(message, wnd) {
    var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                  .getService(Components.interfaces.nsIPromptService);
    return prompts.confirm(wnd || window, "Simple Mail", message);
  },

  confirmCheck: function(message, checkMessage, check, wnd) {
    var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                  .getService(Components.interfaces.nsIPromptService);
    return prompts.confirmCheck(wnd || window, "Simple Mail", message, checkMessage, check);
  },

  prompt: function(message, value) {
    var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                  .getService(Components.interfaces.nsIPromptService);
    var message = (SmBundle.getString(message) || message) + ":";
    return prompts.prompt(window, "Simple Mail", message, value, null, { value: false });
  },

  promptPassword: function(email, savePassword) {
    var password = { value: "" };
    var check = { value: false };
    var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                  .getService(Components.interfaces.nsIPromptService);
    var message = SmBundle.getString("enterPasswordFor", [ email ]) + ":";
    prompts.promptPassword(window, "Simple Mail", message,
                           password, SmBundle.getString("savePassword"), check);

    if (check.value && savePassword) savePassword(password.value);
    return password.value;
  },

  error: function(message, params) {
    message = SmBundle.getString(message, params);

    var browserWindow = SmUtils.getBrowserWindow();
    SmPopup.open("chrome://simplemail/skin/status/errors_large.png",
                 "Simple Mail", message, browserWindow.toJavaScriptConsole);

    message = "Simple Mail: " + message;
    Components.utils.reportError(message);
    return message;
  },

  getBrowserWindow: function() {
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
             .getService(Components.interfaces.nsIWindowMediator);
    return wm.getMostRecentWindow("navigator:browser");
  },

  getBrowser: function() {
    return SmUtils.getBrowserWindow().getBrowser();
  },

  getDocumentTab: function(doc) {
    var gBrowser = SmUtils.getBrowser();
    var tabs = gBrowser.tabContainer.childNodes;
    for(var i = 0; i < tabs.length; i++) {
      if (tabs[i].linkedBrowser.contentDocument == doc) {
        return tabs[i];
      }
    }
  },

  toJSON: function(object, indent, level) {
    if (!level) level = 0;
    if (!indent) indent = " ";
    var json = "";

    for(var i in object) {
      var value = object[i];
      if (i[0] != "_" &&     // Field names beginning with "_" are ignored
          value != null &&
          typeof value != "function")
      {
        if (json) json += "," + indent;
        json += "'" + i + "': ";

        switch(typeof value) {
          case "number":
          case "boolean":
              json += value;
              break;
          case "string":
              json += "'" + value.replace(/([\\\'\n])/g, "\\$1") + "'";
              break;
          default:
              json += this.toJSON(value, indent, level + 1);
              break;
        }
      }
    }
    json = "{" + indent + json + indent + "}";
    return level ? json : "(" + json + ")";
  },

  whereToOpenLink: function(event) {
    if (!event) return "";

    if (!event.button) {
      return event.shiftKey ? (event.ctrlKey ? "tabshifted" : "window")
                            : (event.ctrlKey ? "tab" : "");
    } else if (event.button == 1) {
      return event.shiftKey ? "tab" : "tabshifted";
    }
  },

  // Works in both FF & SeaMonkey

  openUILink: function(url, where) {
    if (where instanceof Event) {
      where = SmUtils.whereToOpenLink(where);
    }
    switch(where) {
      case "tabshifted": return gBrowser.addTab(url);
      case "tab":        return gBrowser.selectedTab = gBrowser.addTab(url);
      case "window":     return open(url);
      default:           return loadURI(url);
    }
  },

  md5: function(string) {
    // Build array of character codes to MD5
    var array = new Array();
    for(var i = 0; i < string.length; i++) {
      array.push(string.charCodeAt(i));
    } 

    var hash = Components.classes["@mozilla.org/security/hash;1"]
               .createInstance(Components.interfaces.nsICryptoHash);
    hash.init(hash.MD5);
    hash.update(array, array.length);
    var binary = hash.finish(false);

    // Unpack the binary data bin2hex style
    var result = "";
    for (var i = 0; i < binary.length; ++i) {
      var c = binary.charCodeAt(i);
      var ones = c % 16;
      var tens = c >> 4;
      result += String.fromCharCode(tens + (tens > 9 ? 87 : 48)) +
                String.fromCharCode(ones + (ones > 9 ? 87 : 48));
    }
    return result;
  },

  size2string: function(value) {
    return value >= 1000000 ? (value / 1000000).toFixed(1) + " " + SmBundle.getString("mb") :
           value >= 1000 ? (value / 1000).toFixed(1) + " " + SmBundle.getString("kb")
                         : value + " " + SmBundle.getString("bytes");
  },

  lastUniqueId: 0,

  getUniqueId: function() {
    return SmUtils.lastUniqueId = Math.max(SmUtils.lastUniqueId + 1, new Date().getTime());
  },

  getFontList: function() {
    var enumerator = Components.classes["@mozilla.org/gfx/fontenumerator;1"]
                     .getService(Components.interfaces.nsIFontEnumerator);
    var count = {};
    return enumerator.EnumerateAllFonts(count);
  },

  // Select item in menulist

  selectItem: function(menulistId, value, add) {
    var vl = String.toLowerCase(value);
    var popup = SmDom.get(menulistId).menupopup;

    for(var i = 0; i < popup.childNodes.length; i++) {
      var l = String.toLowerCase(popup.childNodes[i].label);
      var v = String.toLowerCase(popup.childNodes[i].value);
      if (vl == l || vl == v) {
        popup.parentNode.selectedIndex = i;
        return;
      }
    }
    if (add && value) {
      var menuitem = popup.ownerDocument.createElement("menuitem");
      menuitem.setAttribute("label", value);
      menuitem.setAttribute("value", value);
      popup.parentNode.selectedItem = popup.appendChild(menuitem);
    }
    else popup.parentNode.selectedIndex = 0;
  },

  getDefaultCharsets: function() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                .getService(Components.interfaces.nsIPrefService)
                .getBranch("");
    var charsets = prefs.getComplexValue("intl.charsetmenu.browser.static",
                                         Components.interfaces.nsIPrefLocalizedString);
    return charsets.toString().split(", ");
  },

  isFirefox2: function() {
    return Components.classes["@mozilla.org/passwordmanager;1"];
  }
}

var SmText = {
  REGEXP_URL: /(https?:\/\/|ftp:\/\/|mailto:)[^\s<>\[\]\(\){}]*/gi,
  REGEXP_LINK: /<img[\s\S]*?src=['"](.*?)['"][\s\S]*?>|<a[\s\S]*?href=['"](.*?)['"][\s\S]*?<\/a>/gi,

  getURL: function(text) {
    var match = ("" + text).match(SmText.REGEXP_URL);
    return match && match[0];
  },

  toHtml: function(text) {
    return text.replace(/</g, "&lt;")
               .replace(/\r?\n/g, "<br>")
               .replace(SmText.REGEXP_URL, function(url) {
                 return "<a href='" + url + "'>" + url + "</a>";
               });
  },

  replaceURLs: function(text, onUrl) {
    return text.replace(SmText.REGEXP_LINK, function(text, image, anchor) {
                                              return onUrl(text, image || anchor, image);
                                            });
  },

  trim: function(string) {
    return string.replace(/^\s+|\s+$/g, "");
  },

  toUTF8: function(text, charset) {
    try {
      if (!charset) return text;
      var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"]
                      .getService(Components.interfaces.nsIScriptableUnicodeConverter);
      converter.charset = charset;
      var result = converter.ConvertToUnicode(text);
      return result + converter.Finish();
    }
    catch(e) {
      SmUtils.error("encodingError");
      throw e;
    }
  },

  fromUTF8: function(text, charset) {
    try {
      if (!charset) return text;
      var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"]
                      .getService(Components.interfaces.nsIScriptableUnicodeConverter);
      converter.charset = charset;
      var result = converter.ConvertFromUnicode(text);
      return result + converter.Finish();
    }
    catch(e) {
      SmUtils.error("encodingError");
      throw e;
    }
  },

  getSelectedHtml: function(doc) {
    var selection = doc.defaultView.getSelection();
    if (selection.rangeCount) {
      var fragment = selection.getRangeAt(0).cloneContents();
      var div = doc.createElement("div");
      div.appendChild(fragment);
      return div.innerHTML;
    }
  },

  // Highlight given phrase, skipping html tags & entities

  highlight: function(phrase, html) {
    var regexp = new RegExp("(<[\\s\\S]*?>|&.*?;)|(" + phrase + ")", "gi");
    return html.replace(regexp, function($0, $1, $2) {
      return $1 || "<span class='highlight'>" + $2 + "</span>";
    });
  },

  imageToLink: function(html) {
    return SmText.replaceURLs(html, function(text, url, isImage) {
      return isImage ? "<a href='" + url + "'>" + text + "</a>" : text;
    });
  },
}

var SmPopup = {
  TIMEOUT: 3 * 1000,
  queue: [],
  inProgress: false,

  open: function(image, title, text, onClick) {
    SmPopup.queue.push({
      image: image,
      title: title,
      text: text,
      onClick: onClick
    });
    SmPopup.showNext();
  },

  showNext: function() {
    if (SmPopup.inProgress) return;

    var item = SmPopup.queue.shift();
    if (!item) return;

    SmPopup.inProgress = true;

    if (SmPrefs.getBool("customPopup")) SmPopup.showCustomPopup(item);
    else SmPopup.showStandardPopup(item);

    setTimeout(function() {
      SmPopup.inProgress = false;
      SmPopup.showNext();
    },
    SmPopup.TIMEOUT);
  },

  showCustomPopup: function(item) {
    var wnd = SmUtils.getBrowserWindow();
    wnd.openDialog(
      "chrome://simplemail/content/notify.xul", "simplemail-notify",
      "chrome,popup,titlebar=no", item.image, item.title, item.text, SmPopup.TIMEOUT,
      function() {
        SmPopup.queue = [];
        if (item.onClick) item.onClick();
      }
    );
  },

  showStandardPopup: function(item) {
    var listener = {
      observe: function(subject, topic) {
        if (topic == "alertclickcallback") {
          SmPopup.queue = [];
          if (item.onClick) item.onClick();
        }
      }
    }
    var alertsService = Components.classes["@mozilla.org/alerts-service;1"]
                        .getService(Components.interfaces.nsIAlertsService);
    alertsService.showAlertNotification(item.image, item.title, item.text, true, null, listener);
  }
}

var SmBundle = {
  bundle: Components.classes["@mozilla.org/intl/stringbundle;1"]
          .getService(Components.interfaces.nsIStringBundleService)
          .createBundle("chrome://simplemail/locale/simplemail.properties"),

  getString: function(name, params) {
    try {
      return params ? SmBundle.bundle.formatStringFromName(name, params, params.length)
                    : SmBundle.bundle.GetStringFromName(name);
    }
    catch(e) {
      return null;
    }
  }
}
