var DefaultTreeView = {
  DROP_ON: Components.interfaces.nsITreeView.DROP_ON,
  DROP_BEFORE: Components.interfaces.nsITreeView.DROP_BEFORE,
  DROP_AFTER: Components.interfaces.nsITreeView.DROP_AFTER,

  setTree: function(treebox) {
    this.treebox = treebox;
    if (treebox) this.tree = treebox.treeBody.parentNode;
  },
  isContainer: function(row) { return false; },
  isSeparator: function(row) { return false; },
  isSorted: function() { return false; },
  cycleHeader: function(column) {},
  cycleCell: function(row, column) { this.tree.view.selection.select(row); },
  getLevel: function(row) { return 0; },
  getImageSrc: function(row, column) { return null; },
  getRowProperties: function(row, props) {},
  getCellProperties: function(row, column, props) {},
  getColumnProperties: function(column, props) {},
  canDrop: function(row, orientation) { return false; },

  extend: function(treeView) {
    for(var i in this) {
      if (treeView[i] == null) treeView[i] = this[i];
    }
  },

  atomService: Components.classes["@mozilla.org/atom-service;1"]
               .getService(Components.interfaces.nsIAtomService),

  nextDirection: {
    ""           : "ascending",
    "ascending"  : "descending",
    "descending" : ""
  },

  getSortedColumn: function() {
    var column = this.tree.columns.getSortedColumn();
    if (column) return SmDom.get(column.id);
  },

  getCheckboxColumn: function() {
    for(var i = 0; i < this.tree.columns.count; i++) {
      var column = this.tree.columns.getColumnAt(i);
      if (column.type == column.TYPE_CHECKBOX) {
        return column;
      }
    }
  },

  forEachChecked: function(onItem) {
    var column = this.getCheckboxColumn();
    if (!column) return;

    var found;
    this.treebox.beginUpdateBatch();
    for (var i = this.rowCount - 1; i >= 0; i--) {
      if (this.getCellValue(i, column) == "true") {
        found = true;
        onItem(i);
      }
    }
    this.treebox.endUpdateBatch();
    return found;
  },

  forEachSelected: function(onItem) {
    var start = new Object();
    var end = new Object();
    var rangeCount = this.tree.view.selection.getRangeCount();

    var found;
    this.treebox.beginUpdateBatch();
    for (var i = rangeCount - 1; i >= 0; i--){
      this.tree.view.selection.getRangeAt(i, start, end);
      for (var j = end.value; j >= start.value; j--) {
        found = true;
        onItem(j);
      }
    }
    this.treebox.endUpdateBatch();
    return found;
  },

  // Event handling

  onDblClick: function(event) {
    var row = {}, column = {}, child = {};
    this.treebox.getCellAt(event.clientX, event.clientY, row, column, child);

    if (row.value != -1) {
      event.preventDefault();
      this.action();
    }
  },

  onKeyPress: function(event) {
    var char = String.fromCharCode(event.charCode);
    if (!(event.ctrlKey || event.metaKey || event.altKey)) {
      switch (event.keyCode) {
        case event.DOM_VK_DELETE:
        case event.DOM_VK_BACK_SPACE: event.preventDefault(); return this.delete(event.shiftKey);
        case event.DOM_VK_RETURN:     event.preventDefault(); return this.action();
        case event.DOM_VK_INSERT:     event.preventDefault(); return this.select();
      }
      switch (char) {
        case "*": event.preventDefault();
                  return this.selectAll(event);
      }
    }
    if ((event.ctrlKey || event.metaKey) && !(event.altKey || event.shiftKey)) {
      switch (char) {
        case "a": event.preventDefault();
                  return this.selectAll(event);
      }
    }
  },

  action: function() {},
  delete: function() {},
  select: function() {
    this.tree.view.selection.rangedSelect(this.tree.currentIndex,
                                          this.tree.currentIndex, true);
    if (this.tree.currentIndex < this.rowCount - 1) {
      this.tree.currentIndex++;
    }
  },
  selectAll: function(event) {
    this.tree.view.selection.selectAll();
  }
}
