function SmPasswordManagerImpl() { // Firefox 2.0
  var passwordManager = Components.classes["@mozilla.org/passwordmanager;1"]
                        .getService(Components.interfaces.nsIPasswordManager);
  var passwordManagerInternal = Components.classes["@mozilla.org/passwordmanager;1"]
                                .getService(Components.interfaces.nsIPasswordManagerInternal);

  var url = "chrome://simplemail/";
  var userName = "simplemail";

  this.getPassword = function(id) {
    var host = { value: url + id };
    var user = { value: userName };
    var password = { value: "" }; 
    try {
      passwordManagerInternal.findPasswordEntry(host.value, user.value,
                                                password.value, host, user, password);
    }
    catch(e) {}
    return password.value;
  }

  this.removePassword = function(id) {
    try {
      passwordManager.removeUser(url + id, userName);
    }
    catch(e) {}
  }

  this.setPassword = function(id, password) {
    this.removePassword(id);
    try {
      passwordManager.addUser(url + id, userName, password);
    }
    catch(e) {}
  }
}

function SmLoginManagerImpl() { // Firefox 3.0
  var loginManager = Components.classes["@mozilla.org/login-manager;1"]
                     .getService(Components.interfaces.nsILoginManager);

  var nsLoginInfo = new Components.Constructor("@mozilla.org/login-manager/loginInfo;1",
                                               Components.interfaces.nsILoginInfo,
                                               "init");
  var url = "chrome://simplemail/";
  var realm = "Simple Mail Account Password";
  var userName = "simplemail";

  this.getPassword = function(id) {
    var logins = loginManager.findLogins({}, url + id, null, realm);
      
    for (var i = 0; i < logins.length; i++) {
      if (logins[i].username == userName) {
         return logins[i].password;
      }
    }
    return "";
  }

  this.removePassword = function(id) {
    var logins = loginManager.findLogins({}, url + id, null, realm);
      
    for (var i = 0; i < logins.length; i++) {
      if (logins[i].username == userName) {
         loginManager.removeLogin(logins[i]);
         return;
      }
    }
  }

  this.setPassword = function(id, password) {
    this.removePassword(id);
    if (!password) return;

    try {
      var loginInfo = new nsLoginInfo(url + id, null, realm,
                                      userName, password, "", "");
      loginManager.addLogin(loginInfo);
    }
    catch(e) {}
  }
}

var SmPasswordManager = SmUtils.isFirefox2() ? new SmPasswordManagerImpl()
                                             : new SmLoginManagerImpl();

function SmStorage() {
  var file = SmFile.getDataDirectory();
  file.append("simplemail.sqlite");
  this.firstRun = !file.exists();

  var storageService = Components.classes["@mozilla.org/storage/service;1"]
                       .getService(Components.interfaces.mozIStorageService);
  var connection = storageService.openDatabase(file);

  if (this.firstRun) {
    connection.executeSimpleSQL("CREATE TABLE addressBook (" +
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "name             STRING," +
                                  "email            STRING," +
                                  "groupp           STRING," +
                                  "favorite         BOOLEAN)");

    connection.executeSimpleSQL("CREATE TABLE accounts (" + 
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "indexx           INTEGER," +
                                  "name             STRING," +
                                  "email            STRING," +
                                  "replyTo          STRING," +
                                  "refresh          DOUBLE," +
                                  "deleteMode       STRING," +
                                  "color            STRING," +
                                  "subject          STRING," +
                                  "signature        STRING," +
                                  "isImap           BOOLEAN," +
                                  "pop3auth         INTEGER," +
                                  "pop3host         STRING," +
                                  "pop3port         INTEGER," +
                                  "pop3ssl          BOOLEAN," +
                                  "pop3login        STRING," +
                                  "smtpHost         STRING," +
                                  "smtpPort         INTEGER," +
                                  "smtpSsl          BOOLEAN," +
                                  "smtpLogin        STRING)");

    connection.executeSimpleSQL("CREATE TABLE messages (" + 
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "accountId        INTEGER," +
                                  "uid              STRING," +
                                  "fromm            STRING," + // "from" is reserved word
                                  "too              STRING," + // "to" is reserved word
                                  "cc               STRING," + 
                                  "bcc              STRING," + 
                                  "subject          STRING," + 
                                  "date             DATETIME," + 
                                  "size             DOUBLE," + 
                                  "charset          STRING," +
                                  "read             BOOLEAN," +
                                  "deleted          BOOLEAN," +
                                  "attachmentsDir   STRING," +
                                  "attachmentsCount INTEGER," +
                                  "html             STRING," +
                                  "folderId         INTEGER," +
                                  "partial          BOOLEAN," +
                                  "template         BOOLEAN," +
                                  "color            INTEGER DEFAULT 0," +
                                  "returnReceiptTo  STRING," +
                                  "replyTo          STRING)");

    connection.executeSimpleSQL("CREATE INDEX messages_accountId_uid ON messages (accountId, uid)");
    connection.executeSimpleSQL("CREATE INDEX messages_deleted_folderId_id ON messages (deleted, folderId, id DESC)");

    connection.executeSimpleSQL("CREATE TABLE folders (" + 
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "parentId         INTEGER DEFAULT 0," +
                                  "name             STRING," +
                                  "open             BOOLEAN)");

    connection.executeSimpleSQL("CREATE TABLE rules (" +
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "filterId         INTEGER," +
                                  "property         STRING," +
                                  "negative         BOOLEAN," +
                                  "condition        STRING," +
                                  "param            STRING)");

    connection.executeSimpleSQL("CREATE TABLE actions (" +
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "filterId         INTEGER," +
                                  "name             STRING," +
                                  "param            STRING)");

    connection.executeSimpleSQL("CREATE TABLE filters (" +
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "indexx           INTEGER," +
                                  "name             STRING," +
                                  "type             INTEGER)");

    // Create default folders
    var statement = connection.createStatement("INSERT INTO folders (name) VALUES (?1)");
    for(var i in SmFolder.DEFAULT_NAMES) {
      statement.bindStringParameter(0, SmFolder.DEFAULT_NAMES[i]);
      statement.execute();
    }

    // Create default filter
    var statement = connection.createStatement("INSERT INTO filters (name, type) VALUES (?1, ?2)");
    statement.bindStringParameter(0, "default");
    statement.bindInt32Parameter(1, SmFilter.INBOX);
    statement.execute();

    var statement = connection.createStatement("INSERT INTO actions (filterId, name) VALUES (?1, ?2)");
    statement.bindInt32Parameter(0, 1);
    statement.bindStringParameter(1, "sound");
    statement.execute();
  }

  try { // Since version 2.39
    connection.executeSimpleSQL("ALTER TABLE accounts ADD pop3auth INTEGER");
  }
  catch(e) {}

  try { // Since version 2.43
    connection.executeSimpleSQL("ALTER TABLE messages ADD returnReceiptTo STRING");
  }
  catch(e) {}

  try { // Since version 2.49
    connection.executeSimpleSQL("CREATE TABLE rules (" +
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "filterId         INTEGER," +
                                  "property         STRING," +
                                  "negative         BOOLEAN," +
                                  "condition        STRING," +
                                  "param            STRING)");

    connection.executeSimpleSQL("CREATE TABLE actions (" +
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "filterId         INTEGER," +
                                  "name             STRING," +
                                  "param            STRING)");

    connection.executeSimpleSQL("CREATE TABLE filters (" +
                                  "id               INTEGER PRIMARY KEY AUTOINCREMENT," +
                                  "indexx           INTEGER," +
                                  "name             STRING," +
                                  "type             INTEGER)");
    // Create default filter
    var statement = connection.createStatement("INSERT INTO filters (name, type) VALUES (?1, ?2)");
    statement.bindStringParameter(0, "default");
    statement.bindInt32Parameter(0, SmFilter.INBOX);
    statement.execute();

    var statement = connection.createStatement("INSERT INTO actions (filterId, name) VALUES (?1, ?2)");
    statement.bindInt32Parameter(0, 1);
    statement.bindStringParameter(1, "sound");
    statement.execute();
  }
  catch(e) {}

  try { // Since version 2.54
    connection.executeSimpleSQL("ALTER TABLE folders ADD open BOOLEAN");
  }
  catch(e) {}

  try { // Since version 2.55
    connection.executeSimpleSQL("ALTER TABLE accounts ADD subject STRING");
  }
  catch(e) {}

  try { // Since version 2.58
    connection.executeSimpleSQL("ALTER TABLE addressBook ADD groupp STRING");
  }
  catch(e) {}

  try { // Since version 2.59
    connection.executeSimpleSQL("ALTER TABLE addressBook ADD favorite BOOLEAN");
  }
  catch(e) {}

  try { // Since version 2.61
    connection.executeSimpleSQL("ALTER TABLE messages ADD replyTo STRING");
  }
  catch(e) {}

  try { // Since version 2.62
    connection.executeSimpleSQL("ALTER TABLE accounts ADD indexx INTEGER");
    connection.executeSimpleSQL("ALTER TABLE filters ADD indexx INTEGER");
  }
  catch(e) {}

  try { // Since version 2.71
    connection.executeSimpleSQL("ALTER TABLE filters ADD type INTEGER");
    connection.executeSimpleSQL("ALTER TABLE accounts ADD replyTo STRING");
  }
  catch(e) {}

  var text = "text: ";

  // SQLite converts number-like strings to numbers, prevent this.

  function bindString(statement, id, value) {
    if (value && !isNaN(Number(value))) value = text + value;
    statement.bindStringParameter(id, value);
  }

  function getString(statement, id) {
    var value = statement.getString(id);
    return value && value.substr(0, text.length) == text ? value.substr(text.length) : value;
  }

  function getAddress(condition) {
    var sql = "SELECT id, name, email, groupp, favorite FROM addressBook " +
              "WHERE " + condition;
    var statement = connection.createStatement(sql);
    try {
      if (statement.executeStep()) {
        return new SmAddress(
          statement.getInt32(0),
          getString(statement, 1),
          getString(statement, 2),
          getString(statement, 3),
          statement.getInt32(4)
        );
      }
    }
    finally {
      statement.reset();
    }
  }

  this.getAddressByName = function(name) {
    return getAddress("name='" + name + "'");
  }

  this.getAddressByEmail = function(email) {
    return getAddress("email='" + email + "'");
  }

  this.addAddressList = function(list) {
    var addresses = SmAddress.parseList(list);
    for(var i in addresses) {
      var address = addresses[i];
      if (!this.getAddressByEmail(address.email)) this.saveAddress(address);
    }
  }

  this.saveAddress = function(address) {
    var sql = address.id ? "UPDATE addressBook SET name=?1, email=?2," +
                           "groupp=?3, favorite=?4 WHERE id=?5"
                         : "INSERT INTO addressBook (name, email, groupp, favorite) " +
                           "VALUES (?1, ?2, ?3, ?4)";

    var statement = connection.createStatement(sql);

    bindString(statement, 0, address.name);
    bindString(statement, 1, address.email);
    bindString(statement, 2, address.group);
    statement.bindInt32Parameter(3, address.favorite);
    if (address.id) statement.bindInt32Parameter(4, address.id);
    statement.execute();

    if (!address.id) {
      var statement = connection.createStatement("SELECT last_insert_rowid() FROM addressBook");
      try {
        if (statement.executeStep()) address.id = statement.getInt32(0);
      }
      finally {
        statement.reset();
      }
    }
  }

  function getAddresses(condition) {
    var sql = "SELECT id, name, email, groupp, favorite FROM addressBook" +
              (condition ? " WHERE " + condition : "") +
              " ORDER BY name, email";

    var statement = connection.createStatement(sql);
    try {
      var addresses = new Array();
      while(statement.executeStep()) {
        addresses.push(new SmAddress(
          statement.getInt32(0),
          getString(statement, 1),
          getString(statement, 2),
          getString(statement, 3),
          statement.getInt32(4)
        ));
      }
      return addresses;
    }
    finally {
      statement.reset();
    }
  }

  this.getAddresses = function(ids) {
    return getAddresses(ids ? "id in (" + ids + ")" : "");
  }                               

  this.getFavoriteAddresses = function() {
    return getAddresses("favorite=1");
  }

  this.deleteAddress = function(address) {
    var statement = connection.createStatement("DELETE FROM addressBook WHERE id=?1");
    statement.bindInt32Parameter(0, address.id);
    statement.execute();
  }

  var accounts; // Accounts list cache

  this.getAccounts = function() {
    if (!accounts) {
      accounts = doGetAccounts();
    }
    return accounts;
  }

  this.getAccount = function(id) {
    var accounts = this.getAccounts();
    for(var i in accounts) {
      if (accounts[i].id == id) return accounts[i];
    }
  }

  function doGetAccounts() {
    var accounts = new Array();
    var sql = "SELECT id, indexx, name, email, replyTo, refresh, deleteMode," +
              "color, subject, signature, isImap, pop3auth," +
              "pop3host, pop3port, pop3ssl, pop3login, " +
              "smtpHost, smtpPort, smtpSsl, smtpLogin FROM accounts ORDER BY indexx";
    var statement = connection.createStatement(sql);
    try {
      while(statement.executeStep()) {
        var id = statement.getInt32(0);
        accounts.push(new SmAccount(
          id,
          statement.getInt32(1),
          getString(statement, 2),
          getString(statement, 3),
          getString(statement, 4),
          statement.getDouble(5),
          getString(statement, 6),
          getString(statement, 7),
          getString(statement, 8),
          getString(statement, 9),
          statement.getInt32(10),
          statement.getInt32(11),
          getString(statement, 12),
          statement.getInt32(13),
          statement.getInt32(14),
          getString(statement, 15),
          getString(statement, 16),
          statement.getInt32(17),
          statement.getInt32(18),
          getString(statement, 19)
        ));
      }
    }
    finally {
      statement.reset();
    }
    return accounts;
  }

  this.saveAccount = function(account) {
    var sql = account.id ? "UPDATE accounts SET indexx=?1, name=?2, email=?3," +
                           "replyTo=?4, refresh=?5, deleteMode=?6, color=?7," +
                           "subject=?8, signature=?9, isImap=?10, pop3auth=?11," +
                           "pop3host=?12, pop3port=?13, pop3ssl=?14, pop3login=?15," +
                           "smtpHost=?16, smtpPort=?17, smtpSsl=?18, smtpLogin=?19 WHERE id=?20"

                         : "INSERT INTO accounts (indexx, name, email, replyTo, refresh," +
                           "deleteMode, color, subject, signature, isImap, pop3auth," + 
                           "pop3host, pop3port, pop3ssl, pop3login, " + 
                           "smtpHost, smtpPort, smtpSsl, smtpLogin) " +
                           "VALUES (?1, ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9, ?10," +
                           "?11, ?12, ?13, ?14, ?15, ?16, ?17, ?18, ?19)";

    var statement = connection.createStatement(sql);

    statement.bindInt32Parameter(0, account.index);
    bindString(statement, 1, account.name);
    bindString(statement, 2, account.email);
    bindString(statement, 3, account.replyTo);
    statement.bindDoubleParameter(4, account.refresh);
    bindString(statement, 5, account.deleteMode);
    bindString(statement, 6, account.color);
    bindString(statement, 7, account.subject);
    bindString(statement, 8, account.signature);
    statement.bindInt32Parameter(9, account.pop3.isImap);
    statement.bindInt32Parameter(10, account.pop3.auth);
    bindString(statement, 11, account.pop3.host);
    statement.bindInt32Parameter(12, account.pop3.port);
    statement.bindInt32Parameter(13, account.pop3.ssl);
    bindString(statement, 14, account.pop3.login);
    bindString(statement, 15, account.smtp.host);
    statement.bindInt32Parameter(16, account.smtp.port);
    statement.bindInt32Parameter(17, account.smtp.ssl);
    bindString(statement, 18, account.smtp.login);
    if (account.id) statement.bindInt32Parameter(19, account.id);
    statement.execute();

    if (!account.id) {
      var statement = connection.createStatement("SELECT last_insert_rowid() FROM accounts");
      try {
        if (statement.executeStep()) account.id = statement.getInt32(0);
      }
      finally {
        statement.reset();
      }
    }
    if (account.pop3.password != null) {
      account.pop3.setPassword(account.pop3.password);
    }
    if (account.smtp.password != null) {
      account.smtp.setPassword(account.smtp.password);
    }
    // Invalidate accounts list cache
    accounts = null;
  }

  this.saveAccounts = function(accounts) {
    for(var i = 0; i < accounts.length; i++) {
      accounts[i].index = i;
      this.saveAccount(accounts[i]);
    }
  }

  // Doesn't delete account messages
  this.deleteAccount = function(account) {
    // Purge deleted messages
    var sql = "DELETE FROM messages WHERE deleted=1 AND accountId=?1";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, account.id);
    statement.execute();

    var statement = connection.createStatement("DELETE FROM accounts WHERE id=?1");
    statement.bindInt32Parameter(0, account.id);
    statement.execute();

    SmPasswordManager.removePassword(account.id + "/pop3/");
    SmPasswordManager.removePassword(account.id + "/smtp/");

    // Invalidate accounts list cache
    accounts = null;
  }

  this.messageExists = function(accountId, uid) {
    var statement = connection.createStatement("SELECT uid FROM messages WHERE accountId=?1 AND uid=?2");
    try {
      statement.bindInt32Parameter(0, accountId);
      bindString(statement, 1, uid);
      return statement.executeStep();
    }
    finally {
      statement.reset();
    }
  }

  // "Search" is performed in all folders.
  // Order by colors uses additional column noColor, so that no-color items appear at bottom

  function getMessages(condition, order) {
    var sql = "SELECT id, accountId, uid, fromm, too, cc, bcc, subject, date, size," +
              " charset, read, deleted, attachmentsDir, attachmentsCount, folderId," +
              " partial, template, color = 0 AS noColor, color, returnReceiptTo, replyTo" +
              " FROM messages WHERE deleted = 0 AND " + condition +
              " ORDER BY " + (order || "id DESC");

    var statement = connection.createStatement(sql);
    try {
      var messages = new Array();
      while(statement.executeStep()) {
        var id = statement.getInt32(0);
        messages.push(new SmMessage(
          id,
          statement.getInt32(1),
          getString(statement, 2),
          getString(statement, 3),
          getString(statement, 4),
          getString(statement, 5),
          getString(statement, 6),
          getString(statement, 7),
          new Date(statement.getInt64(8)),
          statement.getDouble(9),
          getString(statement, 10),
          statement.getInt32(11),
          statement.getInt32(12),
          getString(statement, 13),
          statement.getInt32(14),
          null,
          statement.getInt32(15),
          statement.getInt32(16),
          statement.getInt32(17),
          statement.getInt32(19),
          getString(statement, 20),
          getString(statement, 21)
        ));
      }
      return messages;
    }
    finally {
      statement.reset();
    }
  }

  this.getAccountMessages = function(accountId) {
    return getMessages("accountId=" + accountId);
  }

  this.getFolderMessages = function(folderId, order) {
    return getMessages("folderId=" + folderId, order);
  }

  this.getSearchMessages = function(search, order) {
    var condition = "(subject LIKE '%" + search + "%' OR html LIKE '%" + search + "%')";
    return getMessages(condition, order);
  }

  this.saveMessage = function(message, noSourceUpdate) {
    if (message.deleted) {
      // Do not really delete message, keep its uid in DB
      // so that it's not downloaded from server again

      SmFile.deleteAttachments(message.attachmentsDir);

      message.from = null;
      message.to = null;
      message.cc = null;
      message.bcc = null;
      message.subject = null;
      message.date = null;
      message.size = null;
      message.charset = null;
      message.read = null;
      message.attachmentsDir = null;
      message.attachmentsCount = null;
      message.html = null;
      message.folderId = null;
      message.partial = null;
      message.template = null;
      message.color = null;
      message.returnReceiptTo = null;
      message.replyTo = null;
    }
    else if (!noSourceUpdate) {
      SmFile.saveAttachment(message.attachmentsDir, SmFile.MESSAGE_SOURCE,
                            message.source || message.toString());
    }

    var sql = message.id ? "UPDATE messages SET accountId=?1, uid=?2, fromm=?3, too=?4," +
                           "cc=?5, bcc=?6, subject=?7, date=?8, size=?9, charset=?10," +
                           "read=?11, deleted=?12, attachmentsDir=?13, attachmentsCount=?14," +
                           "html=?15, folderId=?16, partial=?17, template=?18, color=?19," +
                           "returnReceiptTo=?20, replyTo=?21 WHERE id=?22"
                         : "INSERT INTO messages (accountId, uid, fromm, too, cc, bcc," +
                           "subject, date, size, charset, read, deleted, attachmentsDir," +
                           "attachmentsCount, html, folderId, partial, template, color," +
                           "returnReceiptTo, replyTo) VALUES (?1, ?2, ?3, ?4, ?5, ?6, ?7," +
                           "?8, ?9, ?10, ?11, ?12, ?13, ?14, ?15, ?16, ?17, ?18, ?19, ?20, ?21)";

    var statement = connection.createStatement(sql);

    statement.bindInt32Parameter(0, message.accountId);
    bindString(statement, 1, message.uid);
    bindString(statement, 2, message.from);
    bindString(statement, 3, message.to);
    bindString(statement, 4, message.cc);
    bindString(statement, 5, message.bcc);
    bindString(statement, 6, message.subject);
    statement.bindInt64Parameter(7, message.date);
    statement.bindDoubleParameter(8, !message.deleted && message.getSize());
    bindString(statement, 9, message.charset);
    statement.bindInt32Parameter(10, message.read);
    statement.bindInt32Parameter(11, message.deleted);
    bindString(statement, 12, message.attachmentsDir);
    statement.bindInt32Parameter(13, message.attachmentsCount);
    bindString(statement, 14, message.html);
    statement.bindInt32Parameter(15, message.folderId);
    statement.bindInt32Parameter(16, message.partial);
    statement.bindInt32Parameter(17, message.template);
    statement.bindInt32Parameter(18, message.color);
    bindString(statement, 19, message.returnReceiptTo);
    bindString(statement, 20, message.replyTo);
    if (message.id) statement.bindInt32Parameter(21, message.id);
    statement.execute();

    if (!message.id) {
      var statement = connection.createStatement("SELECT last_insert_rowid() FROM messages");
      try {
        if (statement.executeStep()) message.id = statement.getInt32(0);
      }
      finally {
        statement.reset();
      }
    }
    unreadCount = null;
  }

  this.getMessage = function(id) {
    var sql = "SELECT id, accountId, uid, fromm, too, cc, bcc, subject, date, size, " +
              "charset, read, deleted, attachmentsDir, attachmentsCount, html, folderId," +
              "partial, template, color, returnReceiptTo, replyTo FROM messages WHERE id=?1";      
    var statement = connection.createStatement(sql);
    try {
      statement.bindInt32Parameter(0, id);
      if (statement.executeStep()) return new SmMessage(
        id,
        statement.getInt32(1),
        getString(statement, 2),
        getString(statement, 3),
        getString(statement, 4),
        getString(statement, 5),
        getString(statement, 6),
        getString(statement, 7),
        new Date(statement.getInt64(8)),
        statement.getDouble(9),
        getString(statement, 10),
        statement.getInt32(11),
        statement.getInt32(12),
        getString(statement, 13),
        statement.getInt32(14),
        getString(statement, 15),
        statement.getInt32(16),
        statement.getInt32(17),
        statement.getInt32(18),
        statement.getInt32(19),
        getString(statement, 20),
        getString(statement, 21)
      );
    }
    finally {
      statement.reset();
    }
  }

  this.saveMessageState = function(message) {
    var sql = "UPDATE messages SET read=?1, folderId=?2, color=?3, returnReceiptTo=?4 WHERE id=?5";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, message.read);
    statement.bindInt32Parameter(1, message.folderId);
    statement.bindInt32Parameter(2, message.color);
    bindString(statement, 3, message.returnReceiptTo);
    statement.bindInt32Parameter(4, message.id);
    statement.execute();

    unreadCount = null;
  }

  this.deleteMessage = function(message) {
    if (message.uid && this.getAccount(message.accountId)) {
      message.deleted = true;
      this.saveMessage(message);
    } else {
      SmFile.deleteAttachments(message.attachmentsDir);
      var statement = connection.createStatement("DELETE FROM messages WHERE id=?1");
      statement.bindInt32Parameter(0, message.id);
      statement.execute();
    }
    unreadCount = null;
  }

  var unreadCount;

  this.getUnreadCount = function() {
    if (unreadCount == null) {
      unreadCount = doGetUnreadCount();
    }
    return unreadCount;
  }

  function doGetUnreadCount() {
    var sql = "SELECT COUNT(id) FROM messages WHERE deleted=0 AND read=0 AND folderId!=?1";
    var statement = connection.createStatement(sql);
    try {
      statement.bindInt32Parameter(0, SmFolder.TRASH);
      if (statement.executeStep()) return statement.getInt32(0);
    }
    finally {
      statement.reset();
    }
  }

  var folders = null;

  this.getFolders = function() {
    if (!folders) folders = doGetFolders();
    return folders;
  }

  // Folders grouped by parentId

  function doGetFolders() {
    var statement = connection.createStatement("SELECT id, parentId, name, open FROM folders");
    try {
      var folders = new Array();
      while(statement.executeStep()) {
        var id = statement.getInt32(0);
        var parentId = statement.getInt32(1);
        if (!folders[parentId]) {
          folders[parentId] = new Array();
        }
        folders[parentId].push(new SmFolder(id, parentId, getString(statement, 2),
                                            statement.getInt32(3)));
      }
      return folders;
    }
    finally {
      statement.reset();
    }
  }

  this.getFolder = function(id) {
    var folders = this.getFolders();
    for(var i in folders) {
      var children = folders[i];
      for (var j in children) {
        if (children[j].id == id) return children[j];
      }
    }
  }

  // Unread counts keyed by folderId

  this.getFolderCounts = function() {
    var counts = new Array();
    var sql = "SELECT folderId, count(id), sum(size), sum(1-read) FROM messages " +
              "WHERE deleted = 0 GROUP BY folderId";
    var statement = connection.createStatement(sql);
    try {
      while(statement.executeStep()) {
        var folderId = statement.getInt32(0);
        counts[folderId] = {
          total:  statement.getInt32(1),
          size:   statement.getInt32(2),
          unread: statement.getInt32(3)
        };
      }
    }
    finally {
      statement.reset();
    }

    function calculateChildUnread(folderId) {
      var count = counts[folderId];
      if (!count) count = counts[folderId] = {};

      count.unread |= 0;
      count.childUnread |= 0;

      var children = folders[folderId];
      for(var i in children) {
        var child = children[i];
        count.childUnread += calculateChildUnread(child.id);
      }
      return count.unread + count.childUnread;
    }

    var folders = this.getFolders();
    calculateChildUnread(0);

    return counts;
  }

  this.saveFolder = function(folder) {
    var sql = folder.id ? "UPDATE folders SET parentId=?1, name=?2, open=?3 WHERE id=?4"
                        : "INSERT INTO folders (parentId, name, open) VALUES (?1, ?2, ?3)";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, folder.parentId);
    bindString(statement, 1, folder.name);
    statement.bindInt32Parameter(2, folder.open);
    if (folder.id) statement.bindInt32Parameter(3, folder.id);
    statement.execute();

    if (!folder.id) {
      var statement = connection.createStatement("SELECT last_insert_rowid() FROM folders");
      try {
        if (statement.executeStep()) folder.id = statement.getInt32(0);
      }
      finally {
        statement.reset();
      }
    }
    folders = null;
  }

  this.deleteFolder = function(folder, childrenOnly) {
    // Recursively delete child folders
    var children = this.getFolders()[folder.id];
    for(var i in children) {
      this.deleteFolder(children[i]);
    }
    if (!childrenOnly) {
      var statement = connection.createStatement("DELETE FROM folders WHERE id=?1");
      statement.bindInt32Parameter(0, folder.id);
      statement.execute();
    }
    folders = null;
  }

  function getRules(filterId) {
    var sql = "SELECT id, filterId, property, negative, condition, param " +
              "FROM rules WHERE filterId=?1";
    var statement = connection.createStatement(sql);
    try {
      statement.bindInt32Parameter(0, filterId);
      var rules = new Array();
      while(statement.executeStep()) {
        rules.push(new SmRule(
          statement.getInt32(0),
          statement.getInt32(1),
          getString(statement, 2),
          statement.getInt32(3),
          getString(statement, 4),
          getString(statement, 5)
        ));
      }
      return rules;
    }
    finally {
      statement.reset();
    }
  }

  function saveRule(rule) {
    var sql = rule.id ? "UPDATE rules SET filterId=?1, property=?2, negative=?3," +
                        "condition=?4, param=?5 WHERE id=?6"
                      : "INSERT INTO rules (filterId, property, negative, condition," +
                        "param) VALUES (?1, ?2, ?3, ?4, ?5)";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, rule.filterId);
    bindString(statement, 1, rule.property);
    statement.bindInt32Parameter(2, rule.not);
    bindString(statement, 3, rule.condition);
    bindString(statement, 4, rule.param);
    if (rule.id) statement.bindInt32Parameter(5, rule.id);
    statement.execute();

    if (!rule.id) {
      var statement = connection.createStatement("SELECT last_insert_rowid() FROM rules");
      try {
        if (statement.executeStep()) rule.id = statement.getInt32(0);
      }
      finally {
        statement.reset();
      }
    }
  }

  function saveRules(filter) {
    var ids = new Array();
    for(var i in filter.rules) {
      var rule = filter.rules[i];
      rule.filterId = filter.id;
      saveRule(rule);
      ids.push(rule.id);
    }
    var sql = "DELETE FROM rules WHERE filterId=?1 AND id NOT IN (" + ids.join(",") + ")";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, filter.id);
    statement.execute();
  }

  function getActions(filterId) {
    var sql = "SELECT id, filterId, name, param FROM actions WHERE filterId=?1";
    var statement = connection.createStatement(sql);
    try {
      statement.bindInt32Parameter(0, filterId);
      var actions = new Array();
      while(statement.executeStep()) {
        actions.push(new SmAction(
          statement.getInt32(0),
          statement.getInt32(1),
          getString(statement, 2),
          getString(statement, 3)
        ));
      }
      return actions;
    }
    finally {
      statement.reset();
    }
  }

  function saveAction(action) {
    var sql = action.id ? "UPDATE actions SET filterId=?1, name=?2, param=?3 WHERE id=?4"
                        : "INSERT INTO actions (filterId, name, param) VALUES (?1, ?2, ?3)";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, action.filterId);
    bindString(statement, 1, action.name);
    bindString(statement, 2, action.param);
    if (action.id) statement.bindInt32Parameter(3, action.id);
    statement.execute();

    if (!action.id) {
      var statement = connection.createStatement("SELECT last_insert_rowid() FROM actions");
      try {
        if (statement.executeStep()) action.id = statement.getInt32(0);
      }
      finally {
        statement.reset();
      }
    }
  }

  function saveActions(filter) {
    var ids = new Array();
    for(var i in filter.actions) {
      var action = filter.actions[i];
      action.filterId = filter.id;
      saveAction(action);
      ids.push(action.id);
    }
    var sql = "DELETE FROM actions WHERE filterId=?1 AND id NOT IN (" + ids.join(",") + ")";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, filter.id);
    statement.execute();
  }

  var filters;

  this.getFilters = function() {
    if (!filters) filters = doGetFilters();
    return filters;
  }

  function getFilter(id) {
    var filters = this.getFilters();
    for(var i in filters) {
      if (filters[i].id == id) return filters[i];
    }
  } 

  function doGetFilters() {
    var sql = "SELECT id, indexx, name, type FROM filters ORDER BY indexx";
    var statement = connection.createStatement(sql);
    try {
      var filters = new Array();
      while(statement.executeStep()) {
        var id = statement.getInt32(0);
        filters.push(new SmFilter(
          id,
          statement.getInt32(1),
          getString(statement, 2),
          statement.getInt32(3),
          getRules(id),
          getActions(id)
        ));
      }
      return filters;
    }
    finally {
      statement.reset();
    }
  }

  this.saveFilter = function(filter) {
    var sql = filter.id ? "UPDATE filters SET indexx=?1, name=?2, type=?3 WHERE id=?4"
                        : "INSERT INTO filters (indexx, name, type) VALUES (?1, ?2, ?3)";
    var statement = connection.createStatement(sql);
    statement.bindInt32Parameter(0, filter.index);
    bindString(statement, 1, filter.name);
    statement.bindInt32Parameter(2, filter.type);
    if (filter.id) statement.bindInt32Parameter(3, filter.id);
    statement.execute();

    if (!filter.id) {
      var statement = connection.createStatement("SELECT last_insert_rowid() FROM filters");
      try {
        if (statement.executeStep()) filter.id = statement.getInt32(0);
      }
      finally {
        statement.reset();
      }
    }
    saveRules(filter);
    saveActions(filter);

    filters = null;
  }

  this.saveFilters = function(filters) {
    for(var i = 0; i < filters.length; i++) {
      filters[i].index = i;
      this.saveFilter(filters[i]);
    }
  }

  this.deleteFilter = function(filter) {
    var statement = connection.createStatement("DELETE FROM rules WHERE filterId=?1");
    statement.bindInt32Parameter(0, filter.id);
    statement.execute();

    var statement = connection.createStatement("DELETE FROM actions WHERE filterId=?1");
    statement.bindInt32Parameter(0, filter.id);
    statement.execute();

    var statement = connection.createStatement("DELETE FROM filters WHERE id=?1");
    statement.bindInt32Parameter(0, filter.id);
    statement.execute();

    filters = null;
  }
}
