var ruleTree, rules, ruleType;

function initRules(aRules, aType) {
  rules = aRules;
  ruleType = aType;

  ruleTree = SmDom.get("rule-tree");
  ruleTree.view = ruleTreeView;
  if (ruleTree.view.rowCount > 0) ruleTree.view.selection.select(0);
}

var ruleTreeView = {
  get rowCount() {
    return rules.length;
  },
  getCellText: function(row, column) {
    var name = column.id.replace(/rule-/, "");
    var value = rules[row][name];
    switch(name) {
      case "not":
        value = value ? "not" : "";
        break;
      case "param":
        var property = rules[row]["property"];
        switch(property) {
          case "size":
              value = SmUtils.size2string(value);
              break;
          case "accountId":
              value = storage.getAccount(value);
              break;
        }
        break;
    }
    return SmBundle.getString(value) || value;
  },
  action: editRule,
  delete: deleteRules
};
DefaultTreeView.extend(ruleTreeView);

function onSelectRule() {
  SmDom.get("rule-edit").disabled =
  SmDom.get("rule-delete").disabled = !ruleTree.view.selection.getRangeCount();
}

function editRule(add) {
  var rule = add ? SmRule.create(ruleType) : rules[ruleTree.currentIndex];
  var param = { rule: rule };

  openDialog("chrome://simplemail/content/preferences/filter/rule.xul",
             "simplemail-preferences-filter-rule-window",
             "chrome,centerscreen,modal=yes,resizable=yes", param);
  if (!param.rule) return;

  if (add) {
    rules.push(rule);
    ruleTreeView.treebox.rowCountChanged(ruleTreeView.rowCount - 1, 1);
    ruleTree.view.selection.select(ruleTreeView.rowCount - 1);
  } else {
    ruleTreeView.treebox.invalidateRow(ruleTree.currentIndex);
  }
}

function deleteRules() {
  if (SmUtils.confirm(SmBundle.getString("deleteRule"))) {
    ruleTreeView.forEachSelected(function(index) {
      rules.splice(index, 1);
      ruleTreeView.treebox.rowCountChanged(index, -1);
    });
  }
}
