var actionTree, actions;

function initActions(aActions) {
  actions = aActions;
  actionTree = SmDom.get("action-tree");
  actionTree.view = actionTreeView;
  if (actionTree.view.rowCount > 0) actionTree.view.selection.select(0);
}

var actionTreeView = {
  get rowCount() {
    return actions.length;
  },
  getCellText: function(row, column) {
    var name = column.id.replace(/action-/, "");
    var value = actions[row][name];

    if (name == "param") {
      var action = actions[row]["name"];
      switch(action) {
        case "color": return "██";
        case "folder":
            var folder = storage.getFolder(value) ||
                         storage.getFolder(SmFolder.INBOX);
            return folder.getName();
      }
    }
    return SmBundle.getString(value) || value;
  },
  getCellProperties: function(row, column, props) {
    var name = column.id.replace(/action-/, "");
    var value = actions[row][name];
    if (name == "param" &&
        actions[row]["name"] == "color")
    {
      var atom = actionTreeView.atomService.getAtom(COLORS[value]);
      props.AppendElement(atom);
    }
  },
  action: editAction,
  delete: deleteActions
};
DefaultTreeView.extend(actionTreeView);

function onSelectAction() {
  SmDom.get("action-edit").disabled =
  SmDom.get("action-delete").disabled = !actionTree.view.selection.getRangeCount();
}

function editAction(add) {
  var action = add ? SmAction.create() : actions[actionTree.currentIndex];
  var param = { action: action };

  openDialog("chrome://simplemail/content/preferences/filter/action.xul",
             "simplemail-preferences-filter-action-window",
             "chrome,centerscreen,modal=yes,resizable=yes", param);
  if (!param.action) return;

  if (add) {
    actions.push(action);
    actionTreeView.treebox.rowCountChanged(actionTreeView.rowCount - 1, 1);
    actionTree.view.selection.select(actionTreeView.rowCount - 1);
  } else {
    actionTreeView.treebox.invalidateRow(actionTree.currentIndex);
  }
}

function deleteActions() {
  if (SmUtils.confirm(SmBundle.getString("deleteAction"))) {
    actionTreeView.forEachSelected(function(index) {
      actions.splice(index, 1);
      actionTreeView.treebox.rowCountChanged(index, -1);
    });
  }
}
