var SmVCard = {
  export: function(storage) {
    var file = SmFile.chooseFile("save", ["*.vcf"]);
    if (!file) return;

    if (!file.leafName.match(/\.vcf/)) {
      file.leafName += ".vcf";
    }
    var data = "";
    var addresses = storage.getAddresses();

    for(var i = 0; i < addresses.length; i++) {
      var address = addresses[i];
      data += "BEGIN:VCARD\r\n" +
              "UID:" + address.id + "\r\n" +
              "FN:" + address.name + "\r\n" +
              (address.group ? "SM.GROUP:" + address.group
                             : "EMAIL:" + address.email) + "\r\n" +
              (address.favorite ? "SM.FAVORITE:" + address.favorite + "\r\n" : "") +
              "END:VCARD\r\n";
    }
    SmFile.writeFile(file, data, true);
  },

  getByRegexp: function(text, regexp) {
    var match = regexp.exec(text);
    return match && match[1];
  },

  import: function(storage) {
    var file = SmFile.chooseFile("open", ["*.vcf"]);
    if (!file) return;

    var data = SmFile.readFile(file, true);
    var cards = data.split("BEGIN:VCARD");
    var addresses = new Array();

    for(var i = 0; i < cards.length; i++) {
      var card = cards[i];
      if (card) {
        var address = new SmAddress();
        address.name = SmVCard.getByRegexp(card, /FN.*:(.*)/);
        address.email = SmVCard.getByRegexp(card, /EMAIL.*:(.*)/);
        address.group = SmVCard.getByRegexp(card, /SM.GROUP.*:(.*)/);
        address.favorite = SmVCard.getByRegexp(card, /SM.FAVORITE.*:(.*)/);
        storage.saveAddress(address);

        var id = SmVCard.getByRegexp(card, /UID.*:(.*)/) || SmUtils.getUniqueId();
        addresses[id] = address;
      }
    }

    // Translate group ids

    for(var i in addresses) {
      var address = addresses[i];
      if (address.group) {
        var ids = address.group.split(",");
        for(var j = ids.length - 1; j >= 0; j--) {
          var id = ids[j];
          if (addresses[id]) {
            ids[j] = addresses[id].id;
          }
          else ids.splice(j, 1);
        }
        address.group = ids.join(",");
        storage.saveAddress(address);
      }
    }
  }
}
