var messageTreeView = {
  get rowCount() {
    return messages.length;
  },
  getCellText: function(row, column) {
    if (column.id == "image" ||
        column.id == "attachmentsCount") return null;

    var value = messages[row][column.id];
    switch(column.id) {
           case "date": return SmDate.toString(value);
           case "size": return SmUtils.size2string(value);
       case "folderId": return storage.getFolder(value).getName();
          case "color": return parseInt(value) ? "██" : "";
               default: return value;
    }
  },
  getCellValue: function(row, column) {
    return messages[row].checked;
  },
  setCellValue: function(row, column, value) {
    messages[row].checked = value;
    messageTreeView.cycleCell(row, column);
  },
  isEditable: function(row, column) {
    return column.id == "select";
  },
  getImageSrc: function(row, column) {
    if (column.id != "image") return null;

    var message = messages[row];
    var account = storage.getAccount(message.accountId);
    return message.template ? SmFile.getStatusIconURL("notChecked") :
                   !account ? SmFile.getStatusIconURL(message.read ? "noMail" : "mail")
                            : SmFile.getEnvelopeIconURL(account.color);
  },
  getCellProperties: function(row, column, props) {
    var message = messages[row];
    if (!message.read) {
      var atom = messageTreeView.atomService.getAtom("unread");
      props.AppendElement(atom);
    }
    if (column.id == "attachmentsCount" && messages[row].attachmentsCount) {
      var atom = messageTreeView.atomService.getAtom("attachment");
      props.AppendElement(atom);
    }
    if (message.color) {
      var atom = messageTreeView.atomService.getAtom(COLORS[message.color]);
      props.AppendElement(atom);
    }
  },
  getRowProperties: function(row, props) {
    var message = messages[row];
    if (message.color) {
      var atom = messageTreeView.atomService.getAtom(COLORS[message.color]);
      props.AppendElement(atom);
    }
  },
  cycleHeader: function(column) {
    column = SmDom.get(column.id);

    if (column.id == "select") {
      var checked = true;
      for (var i = 0; i < messages.length; i++) {
        checked &= messages[i].checked == "true";
      }
      for (var i = 0; i < messages.length; i++) {
        messages[i].checked = !checked ? "true" : "false";
      }
      return;
    }

    var sortedColumn = messageTreeView.getSortedColumn();
    if (sortedColumn && sortedColumn != column) {
      sortedColumn.removeAttribute("sortDirection");
    }            
    var direction = column.getAttribute("sortDirection");
    column.setAttribute("sortDirection",
                        messageTreeView.nextDirection[direction]);
    displayFolder();
  },
  onClick: function(event) {
    // if checkboxes column is Ctrl/Shift clicked, check multiple items
    var row = {}, column = {}, child = {};
    this.treebox.getCellAt(event.clientX, event.clientY, row, column, child);
    if (!column.value || column.value.id != "select") return;

    if (event.ctrlKey || event.shiftKey) {
      messageTreeView.forEachSelected(function(index) {
        messages[index].checked = "true";
      });
    }
  },
  action: function() {
    if (isPartialSelected()) downloadMessageBody();
    else if (getCurrentFolder().id != SmFolder.DRAFTS) toggleRead();
    else {
      var message = storage.getMessage(messages[messageTree.currentIndex].id);
      SimpleMail.openNewMessage(message);
    }
  },
  delete: deleteMail
};
DefaultTreeView.extend(messageTreeView);

function displayMessageHtml() {
  var body = SmDom.get("body");
  body.contentWindow.scroll(0, 0);

  var message = messageTree.currentIndex != -1
                  ? messages[messageTree.currentIndex] : {};
  displayHeaders(message);

  var html = message.partial
               ? SmBundle.getString("messageNotDownloaded")
               : message.id ? storage.getMessage(message.id).html : "";

  var search = SmDom.get("search").value;
  if (search) html = SmText.highlight(search, html);

  html = SmText.imageToLink(html);

  body.contentDocument.title = message.subject;
  body.contentDocument.body.innerHTML = html;

  if (message.returnReceiptTo &&
      message.uid && !message.partial)
  {
    sendReturnReceipt(message);
  }
  clearTimeout(markReadTimeout);
  if (!message.read && !message.partial) {
    startMarkReadTimeout(message);
  }
}

function displayHeaders(message) {
  SmDom.get("headers-from").value = message.from || "";
  SmDom.get("headers-to").value = message.to || "";
  SmDom.get("headers-cc").value = message.cc || "";
  SmDom.get("headers-bcc").value = message.bcc || "";
  SmDom.get("headers-subject").value = message.subject || "";
  SmDom.get("headers-date").value = SmDate.toString(message.date);
}

function sendReturnReceipt(message) {
  function clearReturnReceiptTo() {
    message.returnReceiptTo = null;
    storage.saveMessageState(message);
  }
  var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                .getService(Components.interfaces.nsIPromptService);
  var button = prompts.confirmEx(window, "Simple Mail",
                                 SmBundle.getString("sendReturnReceipt"),
                                 prompts.BUTTON_POS_0 * prompts.BUTTON_TITLE_YES +
                                 prompts.BUTTON_POS_1 * prompts.BUTTON_TITLE_NO +
                                 prompts.BUTTON_POS_2 * prompts.BUTTON_TITLE_IS_STRING,
                                 null, null, SmBundle.getString("later"), null, {});
  if (button == 0) { // "Yes"
    var account = storage.getAccount(message.accountId);
    var receipt = message.createReturnReceipt(account.toString());
    SimpleMail.sendMail(receipt, clearReturnReceiptTo);
  }
  else if (button == 1) { // "No"
    clearReturnReceiptTo();
  }
}

var markReadTimeout;

function startMarkReadTimeout(message) {
  var time = SmPrefs.getInt("markReadTimeout");
  if (!time) return;

  markReadTimeout = setTimeout(function() {
    if (messages[messageTree.currentIndex] &&
        messages[messageTree.currentIndex].id == message.id)
    {
      markRead(messageTree.currentIndex, true);
    }
  }, time * 1000);
}

// Mark read individual message
function markRead(index, read) {
  var message = messages[index];
  message.read = read;
  storage.saveMessageState(message);
  messageTreeView.treebox.invalidateRow(index);

  updateFolderCounts();
}

function displayMessageSource() {
  var attachmentsDir = messages[messageTree.currentIndex].attachmentsDir;
  var url = SmFile.getAttachmentURL(attachmentsDir, SmFile.MESSAGE_SOURCE);
  var gBrowser = SmUtils.getBrowser();
  gBrowser.selectedTab = gBrowser.addTab(url);
}

// If there's an unread message selected, mark all selected messages read.
// Otherwise mark all selected messages unread.

function toggleRead() {
  var read = false;
  forEachSelected(function(index) {
    read |= !messages[index].read;
  });
  forEachSelected(function(index) {
    markRead(index, read);
  });
}

function deleteMail(skipTrash) {
  if (messageTree.view.selection.getRangeCount() == 0) return;

  if (!skipTrash && getCurrentFolder().id != SmFolder.TRASH &&
      SmPrefs.getBool("moveToTrash")) return moveToFolder(SmFolder.TRASH);

  var msgs = new Array();
  forEachSelected(function(index) {
    msgs.push(messages[index]);
  });
  var confirmText = SmBundle.getString("deleteMessages");
  SimpleMail.askDeleteMail(msgs, confirmText, window);
}

function onMessagesDeleted(deleted) {
  if (!deleted) return;

  function isDeleted(message) {
    for(var i in deleted) {
      if (deleted[i].id == message.id) return true;
    }
  }
  var selectionHandler = messageTree.onselect;
  messageTree.onselect = null;
  var index = messageTree.currentIndex;

  for(var i = messages.length - 1; i >= 0; i--) {
    if (isDeleted(messages[i])) {
      messageTreeView.treebox.rowCountChanged(i, -1);
      messages.splice(i, 1);
      if (i <= index) index = index - 1;
    }
  }
  messageTree.onselect = selectionHandler;

  if (messageTree.currentIndex == -1) {
    index = Math.min(index + 1, messages.length - 1);
    if (index != -1) messageTree.view.selection.select(index);
    else displayMessageHtml();
  }
  updateFolderCounts();
}

function onMessageAdded(message) {
  var folder = getCurrentFolder();
  if (folder && folder.id == message.folderId) {
    messages.splice(0, 0, message);
    messageTreeView.treebox.rowCountChanged(0, 1);
  }
  updateFolderCounts();
}

function onMessageUpdated(message) {
  for (var i = 0; i < messages.length; i++) {
    if (messages[i].id == message.id) {
      messages[i] = message;
      messageTreeView.treebox.invalidateRow(i);
      if (i == messageTree.currentIndex) displayMessageHtml();
      break;
    }
  }
}

function openReply(all) {
  if (messageTree.currentIndex != -1) {
    var message = messages[messageTree.currentIndex];
    var reply = storage.getMessage(message.id).createReply(all);
    SimpleMail.openNewMessage(reply);
  }
}

function openNew(address) {
  var message = new SmMessage();
  message.to = address;
  SimpleMail.openNewMessage(message);
}

function openForward(address) {
  if (messageTree.currentIndex != -1) {
    var message = messages[messageTree.currentIndex];
    var forward = storage.getMessage(message.id).createForward();
    forward.to = address;
    SimpleMail.openNewMessage(forward);
  }
}

function selectFirstMessage() {
  if (messageTreeView.rowCount > 0) {
    messageTree.view.selection.select(0);
    messageTreeView.treebox.scrollToRow(0);
  }
}

function displayFolder() {
  var folder = getCurrentFolder();

  var isSentOrDraft = folder.id == SmFolder.SENT || folder.id == SmFolder.DRAFTS;
  var bothVisible = SmDom.get("from").hidden == SmDom.get("to").hidden;
  SmDom.get("from").setAttribute("hidden", isSentOrDraft && !bothVisible);
  SmDom.get("to").setAttribute("hidden", !isSentOrDraft && !bothVisible);

  var search = SmDom.get("search").value;
  SmDom.get("folderId").hidden = !search;

  var oldCount = messages.length;
  messages = search ? storage.getSearchMessages(search, getSort()) :
             folder ? storage.getFolderMessages(folder.id, getSort()) : [];

  var selectionHandler = messageTree.onselect;
  messageTree.onselect = null;

  messageTreeView.treebox.rowCountChanged(0, messages.length - oldCount);
  messageTreeView.treebox.invalidate();
  selectFirstMessage();

  messageTree.onselect = selectionHandler;
  displayMessageHtml();
}

function moveToFolder(folderId) {
  var deleted = new Array();
  forEachSelected(function(index) {
    messages[index].folderId = folderId;
    storage.saveMessageState(messages[index]);
    deleted.push(messages[index]);
  });
  onMessagesDeleted(deleted);
}

function getSort() {
  var column = messageTreeView.getSortedColumn(); 
  if (!column) return;

  var direction = column.getAttribute("sortDirection");
  if (direction) {
    var sortColumns = {
      "image": "accountId",
      "from" : "fromm",
      "to"   : "too",
      "color": "noColor, color"
    };
    var id = sortColumns[column.id] || column.id;
    return id + " " + (direction == "descending" ? "DESC" : "ASC");
  }
}

// Partially downloaded messages

function populateMessageMenu() {
  SmDom.get("message-menu-download").hidden = !isPartialSelected();
  return messageTree.view.selection.getRangeCount() > 0;
}

function isPartialSelected() {
  var isPartial = false;

  forEachSelected(function(index) {
    if (messages[index].partial) isPartial = true;
  });
  return isPartial;
}

function downloadMessageBody() {
  var partial = new Array();
  forEachSelected(function(index) {
    var message = messages[index];
    if (message.partial) partial[message.id] = message;
  });
  SimpleMail.getMailBody(partial);
}

function setMessageColor(color) {
  forEachSelected(function(index) {
    var message = messages[index];
    message.color = color;
    storage.saveMessageState(message);
    messageTreeView.treebox.invalidateRow(index);
  });
}

function printMessage() {
  if (messageTree.currentIndex != -1) {
    var message = messages[messageTree.currentIndex];
    message = storage.getMessage(message.id);
    SmDom.get("printer").contentDocument.body.innerHTML = message.toHtml();
    SmDom.get("printer").contentWindow.print();
  }
}

function populateCharsetMenu(event) {
  var menupopup = event.target;
  SmUtils.clearElement(menupopup);

  var charsets = SmUtils.getDefaultCharsets();
  for(var i = 0; i < charsets.length; i++) {
    var menuitem = document.createElement("menuitem");
    menuitem.setAttribute("label", charsets[i]);
    menupopup.appendChild(menuitem);
  }
}

function recodeMessage(charset) {
  forEachSelected(function(index) {
    var message = storage.getMessage(messages[index].id);
    message.recode(charset);
    storage.saveMessage(message, true);
    message.html = null; // don't keep in memory
    messages[index] = message;
    messageTreeView.treebox.invalidateRow(index);
    if (index == messageTree.currentIndex) displayMessageHtml();
  });
}

function populateRefreshMenu() {
  var browserWindow = SmUtils.getBrowserWindow();
  var foo = browserWindow.document.createElement("menupopup");
  SimpleMail.populateMenu(foo);

  var refresh = SmDom.get("refresh");
  SmUtils.clearElement(refresh);

  for(var i = 0; i < foo.childNodes.length; i++) {
    var menuitem = document.importNode(foo.childNodes[i], true);
    refresh.appendChild(menuitem);
  }
  return refresh.childNodes.length != 0;
}

function saveMessageAs() {
  if (messageTree.currentIndex == -1) return;
  var message = messages[messageTree.currentIndex];

  var fp = Components.classes["@mozilla.org/filepicker;1"]
           .createInstance(Components.interfaces.nsIFilePicker);
  fp.init(window, null, fp.modeSave);
  fp.appendFilters(fp.filterHTML);
  fp.appendFilter("*.eml", "*.eml");
  fp.defaultString = message.subject;

  var result = fp.show();
  if (result == fp.returnCancel) return;

  var file = fp.file.clone();

  if (fp.filterIndex == 0) {
    if (!file.leafName.match(/\.html?$/)) {
      file.leafName += ".html";
    }
    saveAsHtml(file, message);
  }
  else {
    if (!file.leafName.match(/\.eml$/)) {
      file.leafName += ".eml";
    }
    saveAsEmail(file, message);
  }
}

function saveAsEmail(file, message) {
  var source = SmFile.getAttachmentsDirectory(message.attachmentsDir);
  source.append(SmFile.MESSAGE_SOURCE);
  source.copyTo(file.parent, file.leafName);
}

function saveAsHtml(file, message) {
  message = storage.getMessage(message.id);
  var html = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">' +
             '<style>' + SmFile.readURL("chrome://simplemail/skin/message.css") + '</style>' +
             '<title>' + message.subject + '</title>' + message.toHtml();

  if (message.attachmentsCount) {
    var dir = file.clone();
    dir.leafName = dir.leafName.replace(/(\.[^.]*)?$/, "_files");
    if (!dir.exists()) dir.create(dir.DIRECTORY_TYPE, 0777);

    html = SmText.replaceURLs(html,
      function(text, url) {
        if (url.match(/^simplemail:/i)) {
          var fileName = SmFile.getFileName(url);

          var file = dir.clone();
          file.append(fileName);
          if (file.exists()) file.remove(false);

          var file = SmFile.getAttachmentsDirectory(message.attachmentsDir);
          file.append(fileName);
          file.copyTo(dir, fileName);

          return text.replace(url, dir.leafName + "/" + fileName);
        }
        return text;
      });
    html = SmText.imageToLink(html);
  }
  SmFile.writeFile(file, html, true);
}

function clearSearch() {
  SmDom.get("search").value = "";
}

function addToAddressBook() {
  forEachSelected(function(index) {
    var message = messages[index];
    storage.addAddressList(message.from);
  });
  updateAddressTree();
}

function forEachSelected(onItem) {
  if (!messageTreeView.forEachChecked(onItem)) {
    messageTreeView.forEachSelected(onItem);
  }
}

function onRefreshClicked(event) {
  if (event.type == "dblclick") SimpleMail.stop();
  else SimpleMail.getMail();
}





















