var addressTree, addresses;

function initAddresses() {
  addresses = storage.getAddresses();
  addressTree = SmDom.get("address-tree");
  addressTree.view = addressTreeView;
  if (addressTree.view.rowCount > 0) addressTree.view.selection.select(0);
}

var addressTreeView = {
  get rowCount() {
    return addresses.length;
  },
  getCellText: function(row, column) {
    var name = column.id.replace(/address-/, "");
    return addresses[row][name];
  },
  getCellProperties: function(row, column, props) {
    var address = addresses[row];
    if (address.group) {
      var atom = addressTreeView.atomService.getAtom("group");
      props.AppendElement(atom);
    }
  },
  isEditable: function(row, column) {
    return column.id == "address-favorite";
  },
  getCellValue: function(row, column) {
    return addresses[row].favorite ? "true" : "false";
  },
  setCellValue: function(row, column, value) {
    addresses[row].favorite = value == "true";
    storage.saveAddress(addresses[row]);
    addressTreeView.cycleCell(row, column);
  },
  action: function() {
    if (addressTree.currentIndex != -1) {
      var address = addresses[addressTree.currentIndex];
      openNew(address.toString());
    }
  },
  delete: deleteAddress
};
DefaultTreeView.extend(addressTreeView);

function editAddress(add) {
  var address = add ? SmAddress.create() : addresses[addressTree.currentIndex];
  var param = { address: address };

  openDialog("chrome://simplemail/content/main/address.xul",
             "simplemail-preferences-address-window",
             "chrome,centerscreen,modal=yes,resizable=yes", param);
  if (param.address) {
    storage.saveAddress(address);
    updateAddressTree();

    for(var i = 0; i < addresses.length; i++) {
      if (addresses[i].id == address.id) {
        addressTree.view.selection.select(i);
      }
    }
  }
}

function deleteAddress() {
  if (SmUtils.confirm(SmBundle.getString("deleteAddresses"))) {
    addressTreeView.forEachSelected(function(index) {
      storage.deleteAddress(addresses[index]);
    });
    updateAddressTree();
    addressTree.view.selection.clearSelection();
  }
}

function onSelectAddress() {
  var count = !addressTree.view.selection.getRangeCount();
  var edit = SmDom.get("address-edit"), deletee = SmDom.get("address-delete");
  if (edit.nodeName == "button") edit.disabled = deletee.disabled = count;
  else edit.hidden = deletee.hidden = count;
}

function updateAddressTree() {
  var oldCount = addresses.length;
  addresses = storage.getAddresses();
  addressTreeView.treebox.rowCountChanged(0, addresses.length - oldCount);
  addressTreeView.treebox.invalidate();
}
