using GLib;

[DBus (name = "org.magma.ExtendedActions")]
interface Demo : Object {
    public abstract HashTable<string,string>[] GetServicesByLocation (string strlocation, string? file_mime="")    throws IOError;
}

void main () {
    try {
        Demo demo = Bus.get_proxy_sync (BusType.SESSION, "org.magma.ExtendedActions",
                                        "/org/magma/ExtendedActions");

        var eactions = demo.GetServicesByLocation ("file:///home/kitkat/plop.tar");
        foreach(var entry in eactions)
        {
            message ("desc: %s icon: %s exe: %s", entry.lookup ("Description"), entry.lookup ("IconName"), entry.lookup ("Exec"));
        }
    } catch (IOError e) {
        stderr.printf ("%s\n", e.message);
    }

}

