#ifndef EVAS_ENGINE_DFB_H
#define EVAS_ENGINE_DFB_H
#include "evas_common.h"
#include "evas_private.h"
#include "Evas_Engine_DirectFB.h"
#include "evas_engine_dfb_image_objects.h"

typedef struct _Render_Engine Render_Engine;

struct _Render_Engine
{
   Tilebuf            *tb;
   Tilebuf_Rect       *rects;
   Evas_Object_List   *cur_rect;
   IDirectFB          *dfb;
   IDirectFBSurface   *surface;
   IDirectFBSurface   *backbuf;	/* do we need an outbuf beyond this? */
   RGBA_Image         *rgba_image;
   int                 end:1;
};

void               *evas_engine_directfb_info(Evas * evas);
void                evas_engine_directfb_info_free(Evas *e, void *info);
void                evas_engine_directfb_setup(Evas * evas, void *in);
void               *evas_engine_directfb_output_setup(int w, int h,
						      IDirectFB * dfb,
						      IDirectFBSurface * surf,
						      DFBSurfaceDrawingFlags
						      flags);
void                evas_engine_directfb_output_free(void *data);
void                evas_engine_directfb_output_resize(void *data, int w,
						       int h);
void                evas_engine_directfb_output_tile_size_set(void *data, int w,
							      int h);
void                evas_engine_directfb_output_redraws_rect_add(void *data,
								 int x, int y,
								 int w, int h);
void                evas_engine_directfb_output_redraws_rect_del(void *data,
								 int x, int y,
								 int w, int h);
void                evas_engine_directfb_output_redraws_clear(void *data);
void               *evas_engine_directfb_output_redraws_next_update_get(void
									*data,
									int *x,
									int *y,
									int *w,
									int *h,
									int *cx,
									int *cy,
									int *cw,
									int
									*ch);
void                evas_engine_directfb_output_redraws_next_update_push(void
									 *data,
									 void
									 *surface,
									 int x,
									 int y,
									 int w,
									 int h);
void                evas_engine_directfb_output_flush(void *data);
void                evas_engine_directfb_output_idle_flush(void *data);
void               *evas_engine_directfb_context_new(void *data);
void                evas_engine_directfb_context_free(void *data,
						      void *context);
void                evas_engine_directfb_context_clip_set(void *data,
							  void *context, int x,
							  int y, int w, int h);
void                evas_engine_directfb_context_clip_clip(void *data,
							   void *context, int x,
							   int y, int w, int h);
void                evas_engine_directfb_context_clip_unset(void *data,
							    void *context);
int                 evas_engine_directfb_context_clip_get(void *data,
							  void *context, int *x,
							  int *y, int *w,
							  int *h);
void                evas_engine_directfb_context_color_set(void *data,
							   void *context, int r,
							   int g, int b, int a);
int                 evas_engine_directfb_context_color_get(void *data,
							   void *context,
							   int *r, int *g,
							   int *b, int *a);
void                evas_engine_directfb_context_multiplier_set(void *data,
								void *context,
								int r, int g,
								int b, int a);
void                evas_engine_directfb_context_multiplier_unset(void *data,
								  void
								  *context);
int                 evas_engine_directfb_context_multiplier_get(void *data,
								void *context,
								int *r, int *g,
								int *b, int *a);
void                evas_engine_directfb_context_cutout_add(void *data,
							    void *context,
							    int x, int y, int w,
							    int h);
void                evas_engine_directfb_context_cutout_clear(void *data,
							      void *context);
void                evas_engine_directfb_context_anti_alias_set(void *data, void *context,
								 unsigned char aa);
unsigned char       evas_engine_directfb_context_anti_alias_get(void *data, void *context);
void                evas_engine_directfb_context_color_interpolation_set(void *data, 
								void *context, int color_space);
int                 evas_engine_directfb_context_color_interpolation_get(void *data, void *context);
void                evas_engine_directfb_context_render_op_set(void *data, 
								void *context, int op);
int                 evas_engine_directfb_context_render_op_get(void *data, void *context);

void                evas_engine_directfb_draw_rectangle(void *data,
							void *context,
							void *surface, int x,
							int y, int w, int h);
void                evas_engine_directfb_line_draw(void *data, void *context,
						   void *surface, int x1,
						   int y1, int x2, int y2);
void               *evas_engine_directfb_polygon_point_add(void *data,
							   void *context,
							   void *polygon, int x,
							   int y);
void               *evas_engine_directfb_polygon_points_clear(void *data,
							      void *context,
							      void *polygon);
void                evas_engine_directfb_polygon_draw(void *data, void *context,
						      void *surface,
						      void *polygon);

void               *evas_engine_directfb_gradient_new(void *data);
void               evas_engine_directfb_gradient_free(void *data, void *gradient);
void               evas_engine_directfb_gradient_color_stop_add(void *data,
								void *gradient,
								int r, int g, int b, int a, int delta);
void               evas_engine_directfb_gradient_alpha_stop_add(void *data,
								void *gradient, int a, int delta);
void               evas_engine_directfb_gradient_color_data_set(void *data, void *gradient,
								void *map, int len, int has_alpha);
void               evas_engine_directfb_gradient_alpha_data_set(void *data, void *gradient,
								void *alpha_map, int len);
void               evas_engine_directfb_gradient_clear(void *data, void *gradient);
void               evas_engine_directfb_gradient_fill_set(void *data, void *gradient, int x, int y, int w, int h);
void               evas_engine_directfb_gradient_fill_angle_set(void *data, void *gradient, double angle);
void               evas_engine_directfb_gradient_fill_spread_set(void *data, void *gradient, int spread);
void               evas_engine_directfb_gradient_angle_set(void *data, void *gradient, double angle);
void               evas_engine_directfb_gradient_offset_set(void *data, void *gradient, float offset);
void               evas_engine_directfb_gradient_direction_set(void *data, void *gradient, int direction);
void               evas_engine_directfb_gradient_type_set(void *data, void *gradient, char *name, char *params);
int                evas_engine_directfb_gradient_is_opaque(void *data, void *context, void *gradient, int x, int y, int w, int h);
int                evas_engine_directfb_gradient_is_visible(void *data, void *context, void *gradient, int x, int y, int w, int h);
void               evas_engine_directfb_gradient_render_pre(void *data, void *context, void *gradient);
void               evas_engine_directfb_gradient_render_post(void *data, void *gradient);
void               evas_engine_directfb_gradient_draw(void *data, void *context, void *surface,
						       void *gradient, int x, int y, int w, int h);

void               *evas_engine_directfb_font_load(void *data, const char *name,
						   int size);
void               *evas_engine_directfb_font_memory_load(void *data,
							  char *name,
							  int size,
							  const void *fdata,
							  int fdata_size);
void                *evas_engine_directfb_font_add(void *data, void *font, const char *name, int size);
void                *evas_engine_directfb_font_memory_add(void *data, void *font, 
							  char *name, int size, 
							  const void *fdata, 
							  int fdata_size);
void                evas_engine_directfb_font_free(void *data, void *font);
int                 evas_engine_directfb_font_ascent_get(void *data,
							 void *font);
int                 evas_engine_directfb_font_descent_get(void *data,
							  void *font);
int                 evas_engine_directfb_font_max_ascent_get(void *data,
							     void *font);
int                 evas_engine_directfb_font_max_descent_get(void *data,
							      void *font);
void                evas_engine_directfb_font_string_size_get(void *data,
							      void *font,
							      const char *text,
							      int *w, int *h);
int                 evas_engine_directfb_font_inset_get(void *data, void *font,
							const char *text);
int                 evas_engine_directfb_font_h_advance_get(void *data,
							    void *font,
							    const char *text);
int                 evas_engine_directfb_font_v_advance_get(void *data,
							    void *font,
							    const char *text);
int                 evas_engine_directfb_font_char_coords_get(void *data,
							      void *font,
							      const char *text,
							      int pos, int *cx,
							      int *cy, int *cw,
							      int *ch);
int                 evas_engine_directfb_font_char_at_coords_get(void *data,
								 void *font,
								 const char *text,
								 int x, int y,
								 int *cx,
								 int *cy,
								 int *cw,
								 int *ch);
void                evas_engine_directfb_font_draw(void *data, void *context,
						   void *surface, void *font,
						   int x, int y, int w, int h,
						   int ow, int oh, const char *text);
void                evas_engine_directfb_font_cache_flush(void *data);
void                evas_engine_directfb_font_cache_set(void *data, int bytes);
int                 evas_engine_directfb_font_cache_get(void *data);

void evas_engine_directfb_font_hinting_set(void *data, void *font, int hinting);
int evas_engine_directfb_font_hinting_can_hint(void *data, int hinting);

void                rectangle_draw_internal(void *dst, void *dc, int x, int y,
					    int w, int h);

#endif
