
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2008 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://lis.epfl.ch/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Marxbot wheel

#include <QtOpenGL>

namespace Enki
{
	// 441 Verticies
	// 153 Texture Coordinates
	// 717 Normals
	// 690 Triangles

	static short face_indicies[690][9] = {
	// Object #-1
		{2,0,3 ,0,0,0 ,0,1,2 }, {1,0,2 ,0,0,0 ,3,1,0 }, {4,6,7 ,1,2,3 ,4,5,6 },
		{7,5,4 ,3,4,1 ,6,7,4 }, {2,3,5 ,5,6,5 ,0,2,7 }, {5,8,2 ,5,7,5 ,7,8,0 },
		{10,11,9 ,8,9,10 ,9,10,11 }, {9,8,10 ,10,11,8 ,11,8,9 }, {7,6,11 ,12,13,14 ,6,5,10 },
		{7,11,10 ,12,14,15 ,6,10,9 }, {11,6,4 ,16,17,16 ,10,5,4 }, {11,4,9 ,16,16,18 ,10,4,11 },
		{8,5,7 ,19,19,12 ,8,7,6 }, {7,10,8 ,12,15,19 ,6,9,8 }, {17,19,18 ,20,20,20 ,12,13,14 },
		{17,12,19 ,20,20,20 ,12,15,13 }, {12,20,19 ,21,21,21 ,15,16,13 },
		{12,13,20 ,21,21,21 ,15,17,16 }, {13,22,20 ,22,22,22 ,17,18,16 },
		{13,14,22 ,22,22,22 ,17,19,18 }, {14,23,22 ,23,23,23 ,19,20,18 },
		{14,16,23 ,23,23,23 ,19,21,20 }, {24,57,25 ,24,25,26 ,22,23,24 },
		{24,56,57 ,24,27,25 ,22,25,23 }, {25,58,26 ,26,28,29 ,24,26,27 },
		{25,57,58 ,26,25,28 ,24,23,26 }, {26,59,27 ,29,30,31 ,27,28,29 },
		{26,58,59 ,29,28,30 ,27,26,28 }, {27,60,28 ,31,32,33 ,29,30,31 },
		{27,59,60 ,31,30,32 ,29,28,30 }, {28,61,29 ,33,34,35 ,31,32,33 },
		{28,60,61 ,33,32,34 ,31,30,32 }, {29,62,30 ,35,36,37 ,33,34,35 },
		{29,61,62 ,35,34,36 ,33,32,34 }, {30,63,31 ,37,38,39 ,35,36,37 },
		{30,62,63 ,37,36,38 ,35,34,36 }, {31,64,32 ,39,40,41 ,37,38,39 },
		{31,63,64 ,39,38,40 ,37,36,38 }, {32,65,33 ,41,42,43 ,39,40,41 },
		{32,64,65 ,41,40,42 ,39,38,40 }, {33,66,34 ,43,44,45 ,41,42,43 },
		{33,65,66 ,43,42,44 ,41,40,42 }, {34,67,35 ,45,46,47 ,43,44,45 },
		{34,66,67 ,45,44,46 ,43,42,44 }, {35,68,36 ,47,48,49 ,45,46,47 },
		{35,67,68 ,47,46,48 ,45,44,46 }, {36,69,37 ,49,50,51 ,47,48,49 },
		{36,68,69 ,49,48,50 ,47,46,48 }, {37,70,38 ,51,52,53 ,49,50,51 },
		{37,69,70 ,51,50,52 ,49,48,50 }, {38,71,39 ,53,54,55 ,51,52,53 },
		{38,70,71 ,53,52,54 ,51,50,52 }, {39,72,40 ,55,56,57 ,53,54,55 },
		{39,71,72 ,55,54,56 ,53,52,54 }, {40,73,41 ,57,58,59 ,55,56,57 },
		{40,72,73 ,57,56,58 ,55,54,56 }, {41,74,42 ,59,60,61 ,57,58,59 },
		{41,73,74 ,59,58,60 ,57,56,58 }, {42,75,43 ,61,62,63 ,59,60,61 },
		{42,74,75 ,61,60,62 ,59,58,60 }, {43,76,44 ,63,64,65 ,61,62,63 },
		{43,75,76 ,63,62,64 ,61,60,62 }, {44,77,45 ,65,66,67 ,63,64,65 },
		{44,76,77 ,65,64,66 ,63,62,64 }, {45,78,46 ,67,68,69 ,65,66,67 },
		{45,77,78 ,67,66,68 ,65,64,66 }, {46,79,47 ,69,70,71 ,67,68,69 },
		{46,78,79 ,69,68,70 ,67,66,68 }, {47,80,48 ,71,72,73 ,69,70,71 },
		{47,79,80 ,71,70,72 ,69,68,70 }, {48,81,49 ,73,74,75 ,71,72,73 },
		{48,80,81 ,73,72,74 ,71,70,72 }, {49,82,50 ,75,76,77 ,73,74,75 },
		{49,81,82 ,75,74,76 ,73,72,74 }, {50,83,51 ,77,78,79 ,75,76,77 },
		{50,82,83 ,77,76,78 ,75,74,76 }, {51,84,52 ,79,80,81 ,77,78,79 },
		{51,83,84 ,79,78,80 ,77,76,78 }, {52,85,53 ,81,82,83 ,79,80,81 },
		{52,84,85 ,81,80,82 ,79,78,80 }, {53,86,54 ,83,84,85 ,81,82,83 },
		{53,85,86 ,83,82,84 ,81,80,82 }, {54,87,55 ,85,86,87 ,83,84,85 },
		{54,86,87 ,85,84,86 ,83,82,84 }, {55,56,24 ,87,27,24 ,85,25,22 },
		{55,87,56 ,87,86,27 ,85,84,25 }, {13,12,17 ,88,88,88 ,17,15,12 },
		{13,16,14 ,88,88,88 ,17,21,19 }, {16,17,15 ,88,88,88 ,21,12,86 },
		{13,17,16 ,88,88,88 ,17,12,21 }, {3,4,5 ,89,1,4 ,2,4,7 }, {0,4,3 ,90,1,89 ,1,4,2 },
		{2,8,9 ,91,11,10 ,0,8,11 }, {1,2,9 ,92,91,10 ,3,0,11 }, {57,88,89 ,88,88,88 ,23,87,88 },
		{57,56,88 ,88,88,88 ,23,25,87 }, {58,89,90 ,88,88,88 ,26,88,89 },
		{58,57,89 ,88,88,88 ,26,23,88 }, {59,90,91 ,88,88,88 ,28,89,90 },
		{59,58,90 ,88,88,88 ,28,26,89 }, {60,91,92 ,88,88,88 ,30,90,91 },
		{60,59,91 ,88,88,88 ,30,28,90 }, {61,92,93 ,88,88,88 ,32,91,92 },
		{61,60,92 ,88,88,88 ,32,30,91 }, {62,93,94 ,88,88,88 ,34,92,93 },
		{62,61,93 ,88,88,88 ,34,32,92 }, {63,94,95 ,88,88,88 ,36,93,94 },
		{63,62,94 ,88,88,88 ,36,34,93 }, {64,95,96 ,88,88,88 ,38,94,95 },
		{64,63,95 ,88,88,88 ,38,36,94 }, {65,96,97 ,88,88,88 ,40,95,96 },
		{65,64,96 ,88,88,88 ,40,38,95 }, {66,97,98 ,88,88,88 ,42,96,97 },
		{66,65,97 ,88,88,88 ,42,40,96 }, {67,98,99 ,88,88,88 ,44,97,98 },
		{67,66,98 ,88,88,88 ,44,42,97 }, {68,99,100 ,88,88,88 ,46,98,99 },
		{68,67,99 ,88,88,88 ,46,44,98 }, {69,100,101 ,88,88,88 ,48,99,100 },
		{69,68,100 ,88,88,88 ,48,46,99 }, {70,101,102 ,88,88,88 ,50,100,101 },
		{70,69,101 ,88,88,88 ,50,48,100 }, {71,102,103 ,88,88,88 ,52,101,102 },
		{71,70,102 ,88,88,88 ,52,50,101 }, {72,103,104 ,88,88,88 ,54,102,103 },
		{72,71,103 ,88,88,88 ,54,52,102 }, {73,104,105 ,88,88,88 ,56,103,104 },
		{73,72,104 ,88,88,88 ,56,54,103 }, {74,105,106 ,88,88,88 ,58,104,105 },
		{74,73,105 ,88,88,88 ,58,56,104 }, {75,106,107 ,88,88,88 ,60,105,106 },
		{75,74,106 ,88,88,88 ,60,58,105 }, {76,107,108 ,88,88,88 ,62,106,107 },
		{76,75,107 ,88,88,88 ,62,60,106 }, {77,108,109 ,88,88,88 ,64,107,108 },
		{77,76,108 ,88,88,88 ,64,62,107 }, {78,109,110 ,88,88,88 ,66,108,109 },
		{78,77,109 ,88,88,88 ,66,64,108 }, {79,110,111 ,88,88,88 ,68,109,110 },
		{79,78,110 ,88,88,88 ,68,66,109 }, {80,111,112 ,88,88,88 ,70,110,111 },
		{80,79,111 ,88,88,88 ,70,68,110 }, {81,112,113 ,88,88,88 ,72,111,112 },
		{81,80,112 ,88,88,88 ,72,70,111 }, {82,113,114 ,88,88,88 ,74,112,113 },
		{82,81,113 ,88,88,88 ,74,72,112 }, {83,114,115 ,88,88,88 ,76,113,114 },
		{83,82,114 ,88,88,88 ,76,74,113 }, {84,115,116 ,88,88,88 ,78,114,115 },
		{84,83,115 ,88,88,88 ,78,76,114 }, {85,116,117 ,88,88,88 ,80,115,116 },
		{85,84,116 ,88,88,88 ,80,78,115 }, {86,117,118 ,88,88,88 ,82,116,117 },
		{86,85,117 ,88,88,88 ,82,80,116 }, {87,118,119 ,88,88,88 ,84,117,118 },
		{87,86,118 ,88,88,88 ,84,82,117 }, {56,119,88 ,88,88,88 ,25,118,87 },
		{56,87,119 ,88,88,88 ,25,84,118 }, {89,120,121 ,93,94,95 ,88,119,120 },
		{89,88,120 ,93,96,94 ,88,87,119 }, {90,121,122 ,97,95,98 ,89,120,121 },
		{90,89,121 ,97,93,95 ,89,88,120 }, {91,122,123 ,99,98,100 ,90,121,122 },
		{91,90,122 ,99,97,98 ,90,89,121 }, {92,123,124 ,101,100,102 ,91,122,123 },
		{92,91,123 ,101,99,100 ,91,90,122 }, {93,124,125 ,103,102,104 ,92,123,124 },
		{93,92,124 ,103,101,102 ,92,91,123 }, {94,125,126 ,105,104,106 ,93,124,125 },
		{94,93,125 ,105,103,104 ,93,92,124 }, {95,126,127 ,107,106,108 ,94,125,126 },
		{95,94,126 ,107,105,106 ,94,93,125 }, {96,127,128 ,109,108,110 ,95,126,127 },
		{96,95,127 ,109,107,108 ,95,94,126 }, {97,128,129 ,111,110,112 ,96,127,128 },
		{97,96,128 ,111,109,110 ,96,95,127 }, {98,129,130 ,113,112,114 ,97,128,129 },
		{98,97,129 ,113,111,112 ,97,96,128 }, {99,130,131 ,115,114,116 ,98,129,130 },
		{99,98,130 ,115,113,114 ,98,97,129 }, {100,131,132 ,117,116,118 ,99,130,131 },
		{100,99,131 ,117,115,116 ,99,98,130 }, {101,132,133 ,119,118,120 ,100,131,132 },
		{101,100,132 ,119,117,118 ,100,99,131 }, {102,133,134 ,121,120,122 ,101,132,133 },
		{102,101,133 ,121,119,120 ,101,100,132 }, {103,134,135 ,123,122,124 ,102,133,134 },
		{103,102,134 ,123,121,122 ,102,101,133 }, {104,135,136 ,125,124,126 ,103,134,135 },
		{104,103,135 ,125,123,124 ,103,102,134 }, {105,136,137 ,127,126,128 ,104,135,136 },
		{105,104,136 ,127,125,126 ,104,103,135 }, {106,137,138 ,129,128,130 ,105,136,137 },
		{106,105,137 ,129,127,128 ,105,104,136 }, {107,138,139 ,131,130,132 ,106,137,138 },
		{107,106,138 ,131,129,130 ,106,105,137 }, {108,139,140 ,133,132,134 ,107,138,139 },
		{108,107,139 ,133,131,132 ,107,106,138 }, {109,140,141 ,135,134,136 ,108,139,140 },
		{109,108,140 ,135,133,134 ,108,107,139 }, {110,141,142 ,137,136,138 ,109,140,141 },
		{110,109,141 ,137,135,136 ,109,108,140 }, {111,142,143 ,139,138,140 ,110,141,142 },
		{111,110,142 ,139,137,138 ,110,109,141 }, {112,143,144 ,141,140,142 ,111,142,143 },
		{112,111,143 ,141,139,140 ,111,110,142 }, {113,144,145 ,143,142,144 ,112,143,144 },
		{113,112,144 ,143,141,142 ,112,111,143 }, {114,145,146 ,145,144,146 ,113,144,145 },
		{114,113,145 ,145,143,144 ,113,112,144 }, {115,146,147 ,147,146,148 ,114,145,146 },
		{115,114,146 ,147,145,146 ,114,113,145 }, {116,147,148 ,149,148,150 ,115,146,147 },
		{116,115,147 ,149,147,148 ,115,114,146 }, {117,148,149 ,151,150,152 ,116,147,148 },
		{117,116,148 ,151,149,150 ,116,115,147 }, {118,149,150 ,153,152,154 ,117,148,149 },
		{118,117,149 ,153,151,152 ,117,116,148 }, {119,150,151 ,155,154,156 ,118,149,150 },
		{119,118,150 ,155,153,154 ,118,117,149 }, {88,151,120 ,96,156,94 ,87,150,119 },
		{88,119,151 ,96,155,156 ,87,118,150 }, {121,120,152 ,88,88,88 ,120,119,151 },
		{122,121,152 ,88,88,88 ,121,120,151 }, {123,122,152 ,88,88,88 ,122,121,151 },
		{124,123,152 ,88,88,88 ,123,122,151 }, {125,124,152 ,88,88,88 ,124,123,151 },
		{126,125,152 ,88,88,88 ,125,124,151 }, {127,126,152 ,88,88,88 ,126,125,151 },
		{128,127,152 ,88,88,88 ,127,126,151 }, {129,128,152 ,88,88,88 ,128,127,151 },
		{130,129,152 ,88,88,88 ,129,128,151 }, {131,130,152 ,88,88,88 ,130,129,151 },
		{132,131,152 ,88,88,88 ,131,130,151 }, {133,132,152 ,88,88,88 ,132,131,151 },
		{134,133,152 ,88,88,88 ,133,132,151 }, {135,134,152 ,88,88,88 ,134,133,151 },
		{136,135,152 ,88,88,88 ,135,134,151 }, {137,136,152 ,88,88,88 ,136,135,151 },
		{138,137,152 ,88,88,88 ,137,136,151 }, {139,138,152 ,88,88,88 ,138,137,151 },
		{140,139,152 ,88,88,88 ,139,138,151 }, {141,140,152 ,88,88,88 ,140,139,151 },
		{142,141,152 ,88,88,88 ,141,140,151 }, {143,142,152 ,88,88,88 ,142,141,151 },
		{144,143,152 ,88,88,88 ,143,142,151 }, {145,144,152 ,88,88,88 ,144,143,151 },
		{146,145,152 ,88,88,88 ,145,144,151 }, {147,146,152 ,88,88,88 ,146,145,151 },
		{148,147,152 ,88,88,88 ,147,146,151 }, {149,148,152 ,88,88,88 ,148,147,151 },
		{150,149,152 ,88,88,88 ,149,148,151 }, {151,150,152 ,88,88,88 ,150,149,151 },
		{120,151,152 ,88,88,88 ,119,150,151 }, {15,18,21 ,157,157,157 ,86,14,152 },
		{15,17,18 ,157,157,157 ,86,12,14 }, {15,23,16 ,158,158,158 ,86,20,21 },
		{15,21,23 ,158,158,158 ,86,152,20 }, {163,162,155 ,159,160,161 ,3,0,11 },
		{162,156,155 ,160,162,161 ,0,8,11 }, {164,160,161 ,163,164,165 ,1,4,2 },
		{161,160,159 ,165,164,166 ,2,4,7 }, {157,154,156 ,167,168,169 ,6,9,8 },
		{156,159,157 ,169,170,167 ,8,7,6 }, {153,160,155 ,171,171,172 ,10,4,11 },
		{153,158,160 ,171,173,171 ,10,5,4 }, {157,153,154 ,167,174,168 ,6,10,9 },
		{157,158,153 ,167,175,174 ,6,5,10 }, {155,156,154 ,161,162,176 ,11,8,9 },
		{154,153,155 ,176,177,161 ,9,10,11 }, {159,156,162 ,178,179,178 ,7,8,0 },
		{162,161,159 ,178,180,178 ,0,2,7 }, {157,159,160 ,181,166,164 ,6,7,4 },
		{160,158,157 ,164,182,181 ,4,5,6 }, {163,164,162 ,0,0,0 ,3,1,0 },
		{162,164,161 ,0,0,0 ,0,1,2 }, {167,165,168 ,0,0,0 ,0,1,2 }, {166,165,167 ,0,0,0 ,3,1,0 },
		{169,171,172 ,183,184,185 ,4,5,6 }, {172,170,169 ,185,186,183 ,6,7,4 },
		{167,168,170 ,187,188,187 ,0,2,7 }, {170,173,167 ,187,189,187 ,7,8,0 },
		{175,176,174 ,190,191,192 ,9,10,11 }, {174,173,175 ,192,193,190 ,11,8,9 },
		{172,171,176 ,194,195,196 ,6,5,10 }, {172,176,175 ,194,196,197 ,6,10,9 },
		{176,171,169 ,198,199,198 ,10,5,4 }, {176,169,174 ,198,198,200 ,10,4,11 },
		{173,170,172 ,201,202,194 ,8,7,6 }, {172,175,173 ,194,197,201 ,6,9,8 },
		{168,169,170 ,203,183,186 ,2,4,7 }, {165,169,168 ,204,183,203 ,1,4,2 },
		{167,173,174 ,205,193,192 ,0,8,11 }, {166,167,174 ,206,205,192 ,3,0,11 },
		{187,186,179 ,207,208,209 ,3,0,11 }, {186,180,179 ,208,210,209 ,0,8,11 },
		{188,184,185 ,211,212,213 ,1,4,2 }, {185,184,183 ,213,212,214 ,2,4,7 },
		{181,178,180 ,215,216,217 ,6,9,8 }, {180,183,181 ,217,218,215 ,8,7,6 },
		{177,184,179 ,219,219,220 ,10,4,11 }, {177,182,184 ,219,221,219 ,10,5,4 },
		{181,177,178 ,215,222,216 ,6,10,9 }, {181,182,177 ,215,223,222 ,6,5,10 },
		{179,180,178 ,209,210,224 ,11,8,9 }, {178,177,179 ,224,225,209 ,9,10,11 },
		{183,180,186 ,226,226,226 ,7,8,0 }, {186,185,183 ,226,226,226 ,0,2,7 },
		{181,183,184 ,227,214,212 ,6,7,4 }, {184,182,181 ,212,228,227 ,4,5,6 },
		{187,188,186 ,0,0,0 ,3,1,0 }, {186,188,185 ,0,0,0 ,0,1,2 }, {191,189,192 ,0,0,0 ,0,1,2 },
		{190,189,191 ,0,0,0 ,3,1,0 }, {193,195,196 ,229,230,231 ,4,5,6 },
		{196,194,193 ,231,232,229 ,6,7,4 }, {191,192,194 ,233,234,233 ,0,2,7 },
		{194,197,191 ,233,235,233 ,7,8,0 }, {199,200,198 ,236,237,238 ,9,10,11 },
		{198,197,199 ,238,239,236 ,11,8,9 }, {196,195,200 ,240,241,242 ,6,5,10 },
		{196,200,199 ,240,242,243 ,6,10,9 }, {200,195,193 ,244,245,244 ,10,5,4 },
		{200,193,198 ,244,244,246 ,10,4,11 }, {197,194,196 ,247,248,240 ,8,7,6 },
		{196,199,197 ,240,243,247 ,6,9,8 }, {192,193,194 ,249,229,232 ,2,4,7 },
		{189,193,192 ,250,229,249 ,1,4,2 }, {191,197,198 ,251,239,238 ,0,8,11 },
		{190,191,198 ,252,251,238 ,3,0,11 }, {211,210,203 ,253,254,255 ,3,0,11 },
		{210,204,203 ,254,256,255 ,0,8,11 }, {212,208,209 ,257,258,259 ,1,4,2 },
		{209,208,207 ,259,258,260 ,2,4,7 }, {205,202,204 ,261,262,263 ,6,9,8 },
		{204,207,205 ,263,264,261 ,8,7,6 }, {201,208,203 ,265,265,266 ,10,4,11 },
		{201,206,208 ,265,267,265 ,10,5,4 }, {205,201,202 ,261,268,262 ,6,10,9 },
		{205,206,201 ,261,269,268 ,6,5,10 }, {203,204,202 ,255,256,270 ,11,8,9 },
		{202,201,203 ,270,271,255 ,9,10,11 }, {207,204,210 ,272,273,272 ,7,8,0 },
		{210,209,207 ,272,274,272 ,0,2,7 }, {205,207,208 ,275,260,258 ,6,7,4 },
		{208,206,205 ,258,276,275 ,4,5,6 }, {211,212,210 ,0,0,0 ,3,1,0 },
		{210,212,209 ,0,0,0 ,0,1,2 }, {215,213,216 ,0,0,0 ,0,1,2 }, {214,213,215 ,0,0,0 ,3,1,0 },
		{217,219,220 ,277,278,279 ,4,5,6 }, {220,218,217 ,279,280,277 ,6,7,4 },
		{215,216,218 ,281,281,281 ,0,2,7 }, {218,221,215 ,281,281,281 ,7,8,0 },
		{223,224,222 ,282,283,284 ,9,10,11 }, {222,221,223 ,284,285,282 ,11,8,9 },
		{220,219,224 ,286,287,288 ,6,5,10 }, {220,224,223 ,286,288,289 ,6,10,9 },
		{224,219,217 ,290,291,290 ,10,5,4 }, {224,217,222 ,290,290,292 ,10,4,11 },
		{221,218,220 ,293,293,286 ,8,7,6 }, {220,223,221 ,286,289,293 ,6,9,8 },
		{216,217,218 ,294,277,280 ,2,4,7 }, {213,217,216 ,295,277,294 ,1,4,2 },
		{215,221,222 ,296,285,284 ,0,8,11 }, {214,215,222 ,297,296,284 ,3,0,11 },
		{235,234,227 ,298,299,300 ,3,0,11 }, {234,228,227 ,299,301,300 ,0,8,11 },
		{236,232,233 ,302,303,304 ,1,4,2 }, {233,232,231 ,304,303,305 ,2,4,7 },
		{229,226,228 ,306,307,308 ,6,9,8 }, {228,231,229 ,308,309,306 ,8,7,6 },
		{225,232,227 ,310,310,311 ,10,4,11 }, {225,230,232 ,310,312,310 ,10,5,4 },
		{229,225,226 ,306,313,307 ,6,10,9 }, {229,230,225 ,306,314,313 ,6,5,10 },
		{227,228,226 ,300,301,315 ,11,8,9 }, {226,225,227 ,315,316,300 ,9,10,11 },
		{231,228,234 ,317,317,317 ,7,8,0 }, {234,233,231 ,317,317,317 ,0,2,7 },
		{229,231,232 ,318,305,303 ,6,7,4 }, {232,230,229 ,303,319,318 ,4,5,6 },
		{235,236,234 ,0,0,0 ,3,1,0 }, {234,236,233 ,0,0,0 ,0,1,2 }, {239,237,240 ,0,0,0 ,0,1,2 },
		{238,237,239 ,0,0,0 ,3,1,0 }, {241,243,244 ,320,321,322 ,4,5,6 },
		{244,242,241 ,322,323,320 ,6,7,4 }, {239,240,242 ,324,325,324 ,0,2,7 },
		{242,245,239 ,324,326,324 ,7,8,0 }, {247,248,246 ,327,328,329 ,9,10,11 },
		{246,245,247 ,329,330,327 ,11,8,9 }, {244,243,248 ,331,332,333 ,6,5,10 },
		{244,248,247 ,331,333,334 ,6,10,9 }, {248,243,241 ,335,336,335 ,10,5,4 },
		{248,241,246 ,335,335,337 ,10,4,11 }, {245,242,244 ,338,339,331 ,8,7,6 },
		{244,247,245 ,331,334,338 ,6,9,8 }, {240,241,242 ,340,320,323 ,2,4,7 },
		{237,241,240 ,341,320,340 ,1,4,2 }, {239,245,246 ,342,330,329 ,0,8,11 },
		{238,239,246 ,343,342,329 ,3,0,11 }, {259,258,251 ,344,345,346 ,3,0,11 },
		{258,252,251 ,345,347,346 ,0,8,11 }, {260,256,257 ,348,349,350 ,1,4,2 },
		{257,256,255 ,350,349,351 ,2,4,7 }, {253,250,252 ,352,353,354 ,6,9,8 },
		{252,255,253 ,354,355,352 ,8,7,6 }, {249,256,251 ,356,356,357 ,10,4,11 },
		{249,254,256 ,356,358,356 ,10,5,4 }, {253,249,250 ,352,359,353 ,6,10,9 },
		{253,254,249 ,352,360,359 ,6,5,10 }, {251,252,250 ,346,347,361 ,11,8,9 },
		{250,249,251 ,361,362,346 ,9,10,11 }, {255,252,258 ,363,364,363 ,7,8,0 },
		{258,257,255 ,363,365,363 ,0,2,7 }, {253,255,256 ,366,351,349 ,6,7,4 },
		{256,254,253 ,349,367,366 ,4,5,6 }, {259,260,258 ,0,0,0 ,3,1,0 },
		{258,260,257 ,0,0,0 ,0,1,2 }, {263,261,264 ,0,0,0 ,0,1,2 }, {262,261,263 ,0,0,0 ,3,1,0 },
		{265,267,268 ,368,369,370 ,4,5,6 }, {268,266,265 ,370,371,368 ,6,7,4 },
		{263,264,266 ,372,373,372 ,0,2,7 }, {266,269,263 ,372,374,372 ,7,8,0 },
		{271,272,270 ,375,376,377 ,9,10,11 }, {270,269,271 ,377,378,375 ,11,8,9 },
		{268,267,272 ,379,380,381 ,6,5,10 }, {268,272,271 ,379,381,382 ,6,10,9 },
		{272,267,265 ,383,384,383 ,10,5,4 }, {272,265,270 ,383,383,385 ,10,4,11 },
		{269,266,268 ,386,387,379 ,8,7,6 }, {268,271,269 ,379,382,386 ,6,9,8 },
		{264,265,266 ,388,368,371 ,2,4,7 }, {261,265,264 ,389,368,388 ,1,4,2 },
		{263,269,270 ,390,378,377 ,0,8,11 }, {262,263,270 ,391,390,377 ,3,0,11 },
		{283,282,275 ,392,393,394 ,3,0,11 }, {282,276,275 ,393,395,394 ,0,8,11 },
		{284,280,281 ,396,397,398 ,1,4,2 }, {281,280,279 ,398,397,399 ,2,4,7 },
		{277,274,276 ,400,401,402 ,6,9,8 }, {276,279,277 ,402,403,400 ,8,7,6 },
		{273,280,275 ,404,404,405 ,10,4,11 }, {273,278,280 ,404,406,404 ,10,5,4 },
		{277,273,274 ,400,407,401 ,6,10,9 }, {277,278,273 ,400,408,407 ,6,5,10 },
		{275,276,274 ,394,395,409 ,11,8,9 }, {274,273,275 ,409,410,394 ,9,10,11 },
		{279,276,282 ,411,411,411 ,7,8,0 }, {282,281,279 ,411,411,411 ,0,2,7 },
		{277,279,280 ,412,399,397 ,6,7,4 }, {280,278,277 ,397,413,412 ,4,5,6 },
		{283,284,282 ,0,0,0 ,3,1,0 }, {282,284,281 ,0,0,0 ,0,1,2 }, {287,285,288 ,0,0,0 ,0,1,2 },
		{286,285,287 ,0,0,0 ,3,1,0 }, {289,291,292 ,414,415,416 ,4,5,6 },
		{292,290,289 ,416,417,414 ,6,7,4 }, {287,288,290 ,418,419,418 ,0,2,7 },
		{290,293,287 ,418,418,418 ,7,8,0 }, {295,296,294 ,420,421,422 ,9,10,11 },
		{294,293,295 ,422,423,420 ,11,8,9 }, {292,291,296 ,424,425,426 ,6,5,10 },
		{292,296,295 ,424,426,427 ,6,10,9 }, {296,291,289 ,428,429,428 ,10,5,4 },
		{296,289,294 ,428,428,430 ,10,4,11 }, {293,290,292 ,431,432,424 ,8,7,6 },
		{292,295,293 ,424,427,431 ,6,9,8 }, {288,289,290 ,433,414,417 ,2,4,7 },
		{285,289,288 ,434,414,433 ,1,4,2 }, {287,293,294 ,435,423,422 ,0,8,11 },
		{286,287,294 ,436,435,422 ,3,0,11 }, {307,306,299 ,437,438,439 ,3,0,11 },
		{306,300,299 ,438,440,439 ,0,8,11 }, {308,304,305 ,441,442,443 ,1,4,2 },
		{305,304,303 ,443,442,444 ,2,4,7 }, {301,298,300 ,445,446,447 ,6,9,8 },
		{300,303,301 ,447,448,445 ,8,7,6 }, {297,304,299 ,449,449,450 ,10,4,11 },
		{297,302,304 ,449,451,449 ,10,5,4 }, {301,297,298 ,445,452,446 ,6,10,9 },
		{301,302,297 ,445,453,452 ,6,5,10 }, {299,300,298 ,439,440,454 ,11,8,9 },
		{298,297,299 ,454,455,439 ,9,10,11 }, {303,300,306 ,456,457,456 ,7,8,0 },
		{306,305,303 ,456,458,456 ,0,2,7 }, {301,303,304 ,459,444,442 ,6,7,4 },
		{304,302,301 ,442,460,459 ,4,5,6 }, {307,308,306 ,0,0,0 ,3,1,0 },
		{306,308,305 ,0,0,0 ,0,1,2 }, {311,309,312 ,0,0,0 ,0,1,2 }, {310,309,311 ,0,0,0 ,3,1,0 },
		{313,315,316 ,461,462,463 ,4,5,6 }, {316,314,313 ,463,464,461 ,6,7,4 },
		{311,312,314 ,465,466,465 ,0,2,7 }, {314,317,311 ,465,467,465 ,7,8,0 },
		{319,320,318 ,468,469,470 ,9,10,11 }, {318,317,319 ,470,471,468 ,11,8,9 },
		{316,315,320 ,472,473,474 ,6,5,10 }, {316,320,319 ,472,474,475 ,6,10,9 },
		{320,315,313 ,476,477,476 ,10,5,4 }, {320,313,318 ,476,476,478 ,10,4,11 },
		{317,314,316 ,479,480,472 ,8,7,6 }, {316,319,317 ,472,475,479 ,6,9,8 },
		{312,313,314 ,481,461,464 ,2,4,7 }, {309,313,312 ,482,461,481 ,1,4,2 },
		{311,317,318 ,483,471,470 ,0,8,11 }, {310,311,318 ,484,483,470 ,3,0,11 },
		{331,330,323 ,485,486,487 ,3,0,11 }, {330,324,323 ,486,488,487 ,0,8,11 },
		{332,328,329 ,489,490,491 ,1,4,2 }, {329,328,327 ,491,490,492 ,2,4,7 },
		{325,322,324 ,493,494,495 ,6,9,8 }, {324,327,325 ,495,495,493 ,8,7,6 },
		{321,328,323 ,496,496,497 ,10,4,11 }, {321,326,328 ,496,498,496 ,10,5,4 },
		{325,321,322 ,493,499,494 ,6,10,9 }, {325,326,321 ,493,500,499 ,6,5,10 },
		{323,324,322 ,487,488,501 ,11,8,9 }, {322,321,323 ,501,502,487 ,9,10,11 },
		{327,324,330 ,503,504,503 ,7,8,0 }, {330,329,327 ,503,505,503 ,0,2,7 },
		{325,327,328 ,506,492,490 ,6,7,4 }, {328,326,325 ,490,507,506 ,4,5,6 },
		{331,332,330 ,0,0,0 ,3,1,0 }, {330,332,329 ,0,0,0 ,0,1,2 }, {335,333,336 ,0,0,0 ,0,1,2 },
		{334,333,335 ,0,0,0 ,3,1,0 }, {337,339,340 ,508,509,510 ,4,5,6 },
		{340,338,337 ,510,511,508 ,6,7,4 }, {335,336,338 ,512,512,512 ,0,2,7 },
		{338,341,335 ,512,512,512 ,7,8,0 }, {343,344,342 ,513,514,515 ,9,10,11 },
		{342,341,343 ,515,516,513 ,11,8,9 }, {340,339,344 ,517,518,519 ,6,5,10 },
		{340,344,343 ,517,519,520 ,6,10,9 }, {344,339,337 ,521,522,521 ,10,5,4 },
		{344,337,342 ,521,521,523 ,10,4,11 }, {341,338,340 ,524,525,517 ,8,7,6 },
		{340,343,341 ,517,520,524 ,6,9,8 }, {336,337,338 ,526,508,511 ,2,4,7 },
		{333,337,336 ,527,508,526 ,1,4,2 }, {335,341,342 ,528,516,515 ,0,8,11 },
		{334,335,342 ,529,528,515 ,3,0,11 }, {355,354,347 ,530,531,532 ,3,0,11 },
		{354,348,347 ,531,533,532 ,0,8,11 }, {356,352,353 ,534,535,536 ,1,4,2 },
		{353,352,351 ,536,535,537 ,2,4,7 }, {349,346,348 ,538,539,540 ,6,9,8 },
		{348,351,349 ,540,541,538 ,8,7,6 }, {345,352,347 ,542,542,543 ,10,4,11 },
		{345,350,352 ,542,544,542 ,10,5,4 }, {349,345,346 ,538,545,539 ,6,10,9 },
		{349,350,345 ,538,546,545 ,6,5,10 }, {347,348,346 ,532,533,547 ,11,8,9 },
		{346,345,347 ,547,548,532 ,9,10,11 }, {351,348,354 ,549,550,549 ,7,8,0 },
		{354,353,351 ,549,551,549 ,0,2,7 }, {349,351,352 ,552,537,535 ,6,7,4 },
		{352,350,349 ,535,553,552 ,4,5,6 }, {355,356,354 ,0,0,0 ,3,1,0 },
		{354,356,353 ,0,0,0 ,0,1,2 }, {359,357,360 ,0,0,0 ,0,1,2 }, {358,357,359 ,0,0,0 ,3,1,0 },
		{361,363,364 ,554,555,556 ,4,5,6 }, {364,362,361 ,556,557,554 ,6,7,4 },
		{359,360,362 ,558,559,558 ,0,2,7 }, {362,365,359 ,558,560,558 ,7,8,0 },
		{367,368,366 ,561,562,563 ,9,10,11 }, {366,365,367 ,563,564,561 ,11,8,9 },
		{364,363,368 ,565,566,567 ,6,5,10 }, {364,368,367 ,565,567,568 ,6,10,9 },
		{368,363,361 ,569,570,569 ,10,5,4 }, {368,361,366 ,569,569,571 ,10,4,11 },
		{365,362,364 ,572,573,565 ,8,7,6 }, {364,367,365 ,565,568,572 ,6,9,8 },
		{360,361,362 ,574,554,557 ,2,4,7 }, {357,361,360 ,575,554,574 ,1,4,2 },
		{359,365,366 ,576,564,563 ,0,8,11 }, {358,359,366 ,577,576,563 ,3,0,11 },
		{379,378,371 ,578,579,580 ,3,0,11 }, {378,372,371 ,579,581,580 ,0,8,11 },
		{380,376,377 ,582,583,584 ,1,4,2 }, {377,376,375 ,584,583,585 ,2,4,7 },
		{373,370,372 ,586,587,588 ,6,9,8 }, {372,375,373 ,588,589,586 ,8,7,6 },
		{369,376,371 ,590,590,591 ,10,4,11 }, {369,374,376 ,590,592,590 ,10,5,4 },
		{373,369,370 ,586,593,587 ,6,10,9 }, {373,374,369 ,586,594,593 ,6,5,10 },
		{371,372,370 ,580,581,595 ,11,8,9 }, {370,369,371 ,595,596,580 ,9,10,11 },
		{375,372,378 ,597,597,597 ,7,8,0 }, {378,377,375 ,597,597,597 ,0,2,7 },
		{373,375,376 ,598,585,583 ,6,7,4 }, {376,374,373 ,583,599,598 ,4,5,6 },
		{379,380,378 ,0,0,0 ,3,1,0 }, {378,380,377 ,0,0,0 ,0,1,2 }, {383,381,384 ,0,0,0 ,0,1,2 },
		{382,381,383 ,0,0,0 ,3,1,0 }, {385,387,388 ,600,601,602 ,4,5,6 },
		{388,386,385 ,602,603,600 ,6,7,4 }, {383,384,386 ,604,605,604 ,0,2,7 },
		{386,389,383 ,604,606,604 ,7,8,0 }, {391,392,390 ,607,608,609 ,9,10,11 },
		{390,389,391 ,609,610,607 ,11,8,9 }, {388,387,392 ,611,612,613 ,6,5,10 },
		{388,392,391 ,611,613,614 ,6,10,9 }, {392,387,385 ,615,616,615 ,10,5,4 },
		{392,385,390 ,615,615,617 ,10,4,11 }, {389,386,388 ,618,619,611 ,8,7,6 },
		{388,391,389 ,611,614,618 ,6,9,8 }, {384,385,386 ,620,600,603 ,2,4,7 },
		{381,385,384 ,621,600,620 ,1,4,2 }, {383,389,390 ,622,610,609 ,0,8,11 },
		{382,383,390 ,623,622,609 ,3,0,11 }, {403,402,395 ,624,625,626 ,3,0,11 },
		{402,396,395 ,625,627,626 ,0,8,11 }, {404,400,401 ,628,629,630 ,1,4,2 },
		{401,400,399 ,630,629,631 ,2,4,7 }, {397,394,396 ,632,633,634 ,6,9,8 },
		{396,399,397 ,634,635,632 ,8,7,6 }, {393,400,395 ,636,636,637 ,10,4,11 },
		{393,398,400 ,636,638,636 ,10,5,4 }, {397,393,394 ,632,639,633 ,6,10,9 },
		{397,398,393 ,632,640,639 ,6,5,10 }, {395,396,394 ,626,627,641 ,11,8,9 },
		{394,393,395 ,641,642,626 ,9,10,11 }, {399,396,402 ,643,643,643 ,7,8,0 },
		{402,401,399 ,643,643,643 ,0,2,7 }, {397,399,400 ,644,631,629 ,6,7,4 },
		{400,398,397 ,629,645,644 ,4,5,6 }, {403,404,402 ,0,0,0 ,3,1,0 },
		{402,404,401 ,0,0,0 ,0,1,2 }, {407,405,408 ,0,0,0 ,0,1,2 }, {406,405,407 ,0,0,0 ,3,1,0 },
		{409,411,412 ,646,647,648 ,4,5,6 }, {412,410,409 ,648,649,646 ,6,7,4 },
		{407,408,410 ,650,651,650 ,0,2,7 }, {410,413,407 ,650,652,650 ,7,8,0 },
		{415,416,414 ,653,654,655 ,9,10,11 }, {414,413,415 ,655,656,653 ,11,8,9 },
		{412,411,416 ,657,658,659 ,6,5,10 }, {412,416,415 ,657,659,660 ,6,10,9 },
		{416,411,409 ,661,662,661 ,10,5,4 }, {416,409,414 ,661,661,663 ,10,4,11 },
		{413,410,412 ,664,665,657 ,8,7,6 }, {412,415,413 ,657,660,664 ,6,9,8 },
		{408,409,410 ,666,646,649 ,2,4,7 }, {405,409,408 ,667,646,666 ,1,4,2 },
		{407,413,414 ,668,656,655 ,0,8,11 }, {406,407,414 ,669,668,655 ,3,0,11 },
		{427,426,419 ,670,671,672 ,3,0,11 }, {426,420,419 ,671,673,672 ,0,8,11 },
		{428,424,425 ,674,675,676 ,1,4,2 }, {425,424,423 ,676,675,677 ,2,4,7 },
		{421,418,420 ,678,679,680 ,6,9,8 }, {420,423,421 ,680,681,678 ,8,7,6 },
		{417,424,419 ,682,682,683 ,10,4,11 }, {417,422,424 ,682,684,682 ,10,5,4 },
		{421,417,418 ,678,685,679 ,6,10,9 }, {421,422,417 ,678,686,685 ,6,5,10 },
		{419,420,418 ,672,673,687 ,11,8,9 }, {418,417,419 ,687,688,672 ,9,10,11 },
		{423,420,426 ,689,690,689 ,7,8,0 }, {426,425,423 ,689,691,689 ,0,2,7 },
		{421,423,424 ,692,677,675 ,6,7,4 }, {424,422,421 ,675,693,692 ,4,5,6 },
		{427,428,426 ,0,0,0 ,3,1,0 }, {426,428,425 ,0,0,0 ,0,1,2 }, {431,429,432 ,0,0,0 ,0,1,2 },
		{430,429,431 ,0,0,0 ,3,1,0 }, {433,435,436 ,694,695,696 ,4,5,6 },
		{436,434,433 ,696,697,694 ,6,7,4 }, {431,432,434 ,698,699,698 ,0,2,7 },
		{434,437,431 ,698,700,698 ,7,8,0 }, {439,440,438 ,701,702,703 ,9,10,11 },
		{438,437,439 ,703,704,701 ,11,8,9 }, {436,435,440 ,705,13,706 ,6,5,10 },
		{436,440,439 ,705,706,707 ,6,10,9 }, {440,435,433 ,708,709,708 ,10,5,4 },
		{440,433,438 ,708,708,710 ,10,4,11 }, {437,434,436 ,711,712,705 ,8,7,6 },
		{436,439,437 ,705,707,711 ,6,9,8 }, {432,433,434 ,713,694,697 ,2,4,7 },
		{429,433,432 ,714,694,713 ,1,4,2 }, {431,437,438 ,715,704,703 ,0,8,11 },
		{430,431,438 ,716,715,703 ,3,0,11 }
	};
	static GLfloat vertices [441][3] = {
	{5.25f,-0.124929f,2.22866f},{5.25f,0.128015f,2.22916f},{5.25f,0.100951f,2.62271f},
	{5.25f,-0.099049f,2.62231f},{7.3967f,-0.09948f,2.46285f},{5.4f,-0.099405f,2.80107f},
	{7.30158f,-0.099648f,2.82627f},{7.01514f,-0.099686f,2.94238f},{5.4f,0.100595f,2.80147f},
	{7.3967f,0.10052f,2.46325f},{7.01514f,0.100314f,2.94278f},{7.30158f,0.100353f,2.82667f},
	{7.34748f,0.00527f,0.455989f},{7.34748f,0.405729f,0.225843f},{7.34748f,0.406649f,-0.23604f},
	{7.34748f,-0.39335f,-0.23763f},{7.34748f,0.00711f,-0.467776f},{7.34748f,-0.394269f,0.224252f},
	{7.09788f,-0.394269f,0.224252f},{7.09788f,0.00527f,0.455989f},{7.09788f,0.405729f,0.225843f},
	{7.09788f,-0.39335f,-0.23763f},{7.09788f,0.406649f,-0.23604f},{7.09788f,0.00711f,-0.467776f},
	{4.72944f,1.77286f,1.76077f},{4.72944f,2.08357f,1.38217f},{4.72944f,2.31445f,0.95022f},
	{4.72944f,2.45663f,0.481529f},{4.72944f,2.50463f,-0.005893f},{4.72944f,2.45663f,-0.493315f},
	{4.72944f,2.31445f,-0.962005f},{4.72944f,2.08357f,-1.39395f},{4.72944f,1.77286f,-1.77256f},
	{4.72944f,1.39425f,-2.08327f},{4.72944f,0.962303f,-2.31415f},{4.72944f,0.493612f,-2.45633f},
	{4.72944f,0.00619f,-2.50434f},{4.72944f,-0.481233f,-2.45633f},{4.72944f,-0.949923f,-2.31415f},
	{4.72944f,-1.38187f,-2.08327f},{4.72944f,-1.76048f,-1.77256f},{4.72944f,-2.07119f,-1.39395f},
	{4.72944f,-2.30207f,-0.962004f},{4.72944f,-2.44425f,-0.493313f},{4.72944f,-2.49225f,-0.00589f},
	{4.72944f,-2.44425f,0.481532f},{4.72944f,-2.30207f,0.950223f},{4.72944f,-2.07119f,1.38217f},
	{4.72944f,-1.76047f,1.76078f},{4.72944f,-1.38187f,2.07149f},{4.72944f,-0.949919f,2.30237f},
	{4.72944f,-0.481228f,2.44454f},{4.72944f,0.006194f,2.49255f},{4.72944f,0.493617f,2.44454f},
	{4.72944f,0.962307f,2.30237f},{4.72944f,1.39426f,2.07148f},{7.38022f,1.77286f,1.76077f},
	{7.38022f,2.08357f,1.38216f},{7.38022f,2.31445f,0.950215f},{7.38022f,2.45663f,0.481524f},
	{7.38022f,2.50463f,-0.005898f},{7.38022f,2.45663f,-0.493319f},{7.38022f,2.31445f,-0.962009f},
	{7.38022f,2.08357f,-1.39396f},{7.38022f,1.77286f,-1.77256f},{7.38022f,1.39425f,-2.08327f},
	{7.38022f,0.962303f,-2.31415f},{7.38022f,0.493614f,-2.45633f},{7.38022f,0.006193f,-2.50434f},
	{7.38022f,-0.481228f,-2.45633f},{7.38022f,-0.949918f,-2.31416f},{7.38022f,-1.38187f,-2.08328f},
	{7.38022f,-1.76047f,-1.77256f},{7.38022f,-2.07119f,-1.39396f},{7.38022f,-2.30207f,-0.962013f},
	{7.38022f,-2.44424f,-0.493324f},{7.38022f,-2.49225f,-0.005903f},{7.38022f,-2.44425f,0.481518f},
	{7.38022f,-2.30207f,0.950209f},{7.38022f,-2.0712f,1.38216f},{7.38022f,-1.76049f,1.76076f},
	{7.38022f,-1.38188f,2.07148f},{7.38022f,-0.949937f,2.30236f},{7.38022f,-0.481249f,2.44454f},
	{7.38022f,0.006172f,2.49255f},{7.38022f,0.493594f,2.44455f},{7.38022f,0.962285f,2.30238f},
	{7.38022f,1.39423f,2.0715f},{7.38022f,1.50786f,1.49577f},{7.38022f,1.77197f,1.17395f},
	{7.38022f,1.96821f,0.806799f},{7.38022f,2.08906f,0.408411f},{7.38022f,2.12987f,-0.005898f},
	{7.38022f,2.08906f,-0.420206f},{7.38022f,1.96821f,-0.818592f},{7.38022f,1.77196f,-1.18575f},
	{7.38022f,1.50786f,-1.50756f},{7.38022f,1.18604f,-1.77167f},{7.38022f,0.818886f,-1.96792f},
	{7.38022f,0.4205f,-2.08876f},{7.38022f,0.006192f,-2.12957f},{7.38022f,-0.408116f,-2.08876f},
	{7.38022f,-0.806503f,-1.96792f},{7.38022f,-1.17366f,-1.77167f},{7.38022f,-1.49547f,-1.50756f},
	{7.38022f,-1.75958f,-1.18575f},{7.38022f,-1.95583f,-0.818596f},{7.38022f,-2.07668f,-0.42021f},
	{7.38022f,-2.11749f,-0.005902f},{7.38022f,-2.07668f,0.408406f},{7.38022f,-1.95584f,0.806793f},
	{7.38022f,-1.75959f,1.17395f},{7.38022f,-1.49548f,1.49576f},{7.38022f,-1.17367f,1.75987f},
	{7.38022f,-0.806519f,1.95612f},{7.38022f,-0.408133f,2.07698f},{7.38022f,0.006174f,2.11778f},
	{7.38022f,0.420483f,2.07698f},{7.38022f,0.81887f,1.95614f},{7.38022f,1.18603f,1.75989f},
	{7.01003f,1.50786f,1.49577f},{7.01003f,1.77197f,1.17395f},{7.01003f,1.96821f,0.806799f},
	{7.01003f,2.08906f,0.408411f},{7.01003f,2.12987f,-0.005898f},{7.01003f,2.08906f,-0.420206f},
	{7.01003f,1.96821f,-0.818592f},{7.01003f,1.77196f,-1.18575f},{7.01003f,1.50786f,-1.50756f},
	{7.01003f,1.18604f,-1.77167f},{7.01003f,0.818886f,-1.96792f},{7.01003f,0.4205f,-2.08876f},
	{7.01003f,0.006192f,-2.12957f},{7.01003f,-0.408116f,-2.08876f},{7.01003f,-0.806503f,-1.96792f},
	{7.01003f,-1.17366f,-1.77167f},{7.01003f,-1.49547f,-1.50756f},{7.01003f,-1.75958f,-1.18575f},
	{7.01003f,-1.95583f,-0.818596f},{7.01003f,-2.07668f,-0.42021f},{7.01003f,-2.11749f,-0.005902f},
	{7.01003f,-2.07668f,0.408406f},{7.01003f,-1.95584f,0.806793f},{7.01003f,-1.75959f,1.17395f},
	{7.01003f,-1.49548f,1.49576f},{7.01003f,-1.17367f,1.75987f},{7.01003f,-0.806519f,1.95612f},
	{7.01003f,-0.408133f,2.07698f},{7.01003f,0.006174f,2.11778f},{7.01003f,0.420483f,2.07698f},
	{7.01003f,0.81887f,1.95614f},{7.01003f,1.18603f,1.75989f},{7.01003f,0.006187f,-0.005896f},
	{7.30158f,0.830267f,2.70578f},{7.01514f,0.86028f,2.81795f},{7.3967f,0.736368f,2.3547f},
	{5.4f,0.823979f,2.68138f},{7.01514f,0.666992f,2.86932f},{7.30158f,0.636976f,2.75715f},
	{5.4f,0.630691f,2.73276f},{7.3967f,0.54308f,2.40608f},{5.25f,0.584767f,2.55999f},
	{5.25f,0.778055f,2.50862f},{5.25f,0.70234f,2.12147f},{5.25f,0.457884f,2.18645f},
	{5.25f,1.00991f,1.99484f},{5.25f,1.22922f,1.86881f},{5.25f,1.40256f,2.22316f},
	{5.25f,1.22915f,2.32282f},{7.3967f,1.14905f,2.18494f},{5.4f,1.31823f,2.47781f},
	{7.30158f,1.33061f,2.49974f},{7.01514f,1.38864f,2.60033f},{5.4f,1.49163f,2.37815f},
	{7.3967f,1.32246f,2.08528f},{7.01514f,1.56204f,2.50067f},{7.30158f,1.50402f,2.4001f},
	{7.30158f,2.0757f,1.93045f},{7.01514f,2.15777f,2.01257f},{7.3967f,1.81884f,1.67335f},
	{5.4f,2.05805f,1.91246f},{7.01514f,2.01607f,2.15372f},{7.30158f,1.93399f,2.07158f},
	{5.4f,1.91635f,2.0536f},{7.3967f,1.67714f,1.81449f},{5.25f,1.7902f,1.92694f},
	{5.25f,1.9319f,1.7858f},{5.25f,1.67276f,1.48838f},{5.25f,1.49354f,1.66688f},
	{5.25f,1.87581f,1.22493f},{5.25f,2.00272f,1.00613f},{5.25f,2.33001f,1.22634f},
	{5.25f,2.22967f,1.39934f},{7.3967f,2.09136f,1.31999f},{5.4f,2.3843f,1.48903f},
	{7.30158f,2.40599f,1.50184f},{7.01514f,2.50654f,1.55993f},{5.4f,2.48464f,1.31603f},
	{7.3967f,2.1917f,1.14698f},{7.01514f,2.60688f,1.38693f},{7.30158f,2.50635f,1.32884f},
	{7.30158f,2.76661f,0.636269f},{7.01514f,2.87875f,0.666358f},{7.3967f,2.41562f,0.542048f},
	{5.4f,2.74233f,0.629513f},{7.01514f,2.82661f,0.85944f},{7.30158f,2.71445f,0.82935f},
	{5.4f,2.69018f,0.822595f},{7.3967f,2.36347f,0.73513f},{5.25f,2.51761f,0.775984f},
	{5.25f,2.56975f,0.582902f},{5.25f,2.19662f,0.454903f},{5.25f,2.13067f,0.699097f},
	{5.25f,2.24074f,0.125219f},{5.25f,2.24125f,-0.127725f},{5.25f,2.63479f,-0.100661f},
	{5.25f,2.6344f,0.099339f},{7.3967f,2.47494f,0.09977f},{5.4f,2.81316f,0.099695f},
	{7.30158f,2.83835f,0.099938f},{7.01514f,2.95447f,0.099977f},{5.4f,2.81356f,-0.100305f},
	{7.3967f,2.47534f,-0.100229f},{7.01514f,2.95486f,-0.100023f},{7.30158f,2.83876f,-0.100063f},
	{7.30158f,2.71787f,-0.829977f},{7.01514f,2.83003f,-0.85999f},{7.3967f,2.36679f,-0.736078f},
	{5.4f,2.69346f,-0.823689f},{7.01514f,2.88141f,-0.666702f},{7.30158f,2.76924f,-0.636685f},
	{5.4f,2.74484f,-0.630401f},{7.3967f,2.41817f,-0.54279f},{5.25f,2.57208f,-0.584477f},
	{5.25f,2.5207f,-0.777765f},{5.25f,2.13356f,-0.702049f},{5.25f,2.19853f,-0.457594f},
	{5.25f,2.00693f,-1.00962f},{5.25f,1.88089f,-1.22893f},{5.25f,2.23524f,-1.40227f},
	{5.25f,2.3349f,-1.22886f},{7.3967f,2.19702f,-1.14876f},{5.4f,2.48989f,-1.31794f},
	{7.30158f,2.51183f,-1.33032f},{7.01514f,2.61241f,-1.38835f},{5.4f,2.39024f,-1.49134f},
	{7.3967f,2.09737f,-1.32217f},{7.01514f,2.51275f,-1.56175f},{7.30158f,2.41218f,-1.50373f},
	{7.30158f,1.94253f,-2.07541f},{7.01514f,2.02466f,-2.15749f},{7.3967f,1.68544f,-1.81855f},
	{5.4f,1.92454f,-2.05776f},{7.01514f,2.1658f,-2.01578f},{7.30158f,2.08366f,-1.9337f},
	{5.4f,2.06568f,-1.91606f},{7.3967f,1.82658f,-1.67685f},{5.25f,1.93902f,-1.78991f},
	{5.25f,1.79788f,-1.93161f},{5.25f,1.50047f,-1.67247f},{5.25f,1.67897f,-1.49325f},
	{5.25f,1.23701f,-1.87552f},{5.25f,1.01821f,-2.00243f},{5.25f,1.23842f,-2.32972f},
	{5.25f,1.41143f,-2.22937f},{7.3967f,1.33207f,-2.09106f},{5.4f,1.50112f,-2.38401f},
	{7.30158f,1.51392f,-2.4057f},{7.01514f,1.57202f,-2.50625f},{5.4f,1.32811f,-2.48435f},
	{7.3967f,1.15907f,-2.19141f},{7.01514f,1.39901f,-2.60659f},{7.30158f,1.34092f,-2.50606f},
	{7.30158f,0.648353f,-2.76632f},{7.01514f,0.678441f,-2.87846f},{7.3967f,0.554131f,-2.41533f},
	{5.4f,0.641596f,-2.74204f},{7.01514f,0.871523f,-2.82631f},{7.30158f,0.841433f,-2.71416f},
	{5.4f,0.834678f,-2.68989f},{7.3967f,0.747213f,-2.36318f},{5.25f,0.788067f,-2.51731f},
	{5.25f,0.594985f,-2.56946f},{5.25f,0.466986f,-2.19633f},{5.25f,0.71118f,-2.13037f},
	{5.25f,0.137302f,-2.24045f},{5.25f,-0.115642f,-2.24096f},{5.25f,-0.088578f,-2.6345f},
	{5.25f,0.111422f,-2.63411f},{7.3967f,0.111854f,-2.47465f},{5.4f,0.111778f,-2.81287f},
	{7.30158f,0.112022f,-2.83806f},{7.01514f,0.11206f,-2.95418f},{5.4f,-0.088222f,-2.81327f},
	{7.3967f,-0.088146f,-2.47505f},{7.01514f,-0.08794f,-2.95458f},{7.30158f,-0.08798f,-2.83847f},
	{7.30158f,-0.817894f,-2.71758f},{7.01514f,-0.847907f,-2.82974f},{7.3967f,-0.723995f,-2.3665f},
	{5.4f,-0.811606f,-2.69317f},{7.01514f,-0.654619f,-2.88112f},{7.30158f,-0.624603f,-2.76895f},
	{5.4f,-0.618318f,-2.74455f},{7.3967f,-0.530707f,-2.41788f},{5.25f,-0.572394f,-2.57179f},
	{5.25f,-0.765682f,-2.52041f},{5.25f,-0.689966f,-2.13327f},{5.25f,-0.44551f,-2.19825f},
	{5.25f,-0.997541f,-2.00663f},{5.25f,-1.21685f,-1.8806f},{5.25f,-1.39018f,-2.23495f},
	{5.25f,-1.21678f,-2.33461f},{7.3967f,-1.13668f,-2.19673f},{5.4f,-1.30586f,-2.4896f},
	{7.30158f,-1.31824f,-2.51154f},{7.01514f,-1.37627f,-2.61212f},{5.4f,-1.47926f,-2.38995f},
	{7.3967f,-1.31008f,-2.09708f},{7.01514f,-1.54967f,-2.51246f},{7.30158f,-1.49165f,-2.41189f},
	{7.30158f,-2.06333f,-1.94224f},{7.01514f,-2.1454f,-2.02437f},{7.3967f,-1.80647f,-1.68515f},
	{5.4f,-2.04568f,-1.92425f},{7.01514f,-2.0037f,-2.16551f},{7.30158f,-1.92162f,-2.08337f},
	{5.4f,-1.90398f,-2.06539f},{7.3967f,-1.66477f,-1.82629f},{5.25f,-1.77783f,-1.93873f},
	{5.25f,-1.91953f,-1.79759f},{5.25f,-1.66039f,-1.50018f},{5.25f,-1.48117f,-1.67868f},
	{5.25f,-1.86344f,-1.23672f},{5.25f,-1.99035f,-1.01792f},{5.25f,-2.31764f,-1.23813f},
	{5.25f,-2.21729f,-1.41114f},{7.3967f,-2.07898f,-1.33178f},{5.4f,-2.37193f,-1.50083f},
	{7.30158f,-2.39362f,-1.51363f},{7.01514f,-2.49416f,-1.57173f},{5.4f,-2.47227f,-1.32782f},
	{7.3967f,-2.17933f,-1.15878f},{7.01514f,-2.59451f,-1.39872f},{7.30158f,-2.49397f,-1.34063f},
	{7.30158f,-2.75424f,-0.648062f},{7.01514f,-2.86638f,-0.67815f},{7.3967f,-2.40324f,-0.55384f},
	{5.4f,-2.72996f,-0.641305f},{7.01514f,-2.81423f,-0.871233f},{7.30158f,-2.70208f,-0.841143f},
	{5.4f,-2.67781f,-0.834388f},{7.3967f,-2.3511f,-0.746923f},{5.25f,-2.50523f,-0.787777f},
	{5.25f,-2.55738f,-0.594694f},{5.25f,-2.18425f,-0.466695f},{5.25f,-2.11829f,-0.710889f},
	{5.25f,-2.22837f,-0.137012f},{5.25f,-2.22887f,0.115933f},{5.25f,-2.62242f,0.088869f},
	{5.25f,-2.62202f,-0.111131f},{7.3967f,-2.46257f,-0.111563f},{5.4f,-2.80079f,-0.111488f},
	{7.30158f,-2.82598f,-0.111731f},{7.01514f,-2.94209f,-0.111769f},{5.4f,-2.80118f,0.088513f},
	{7.3967f,-2.46296f,0.088437f},{7.01514f,-2.94249f,0.088231f},{7.30158f,-2.82639f,0.08827f},
	{7.30158f,-2.7055f,0.818185f},{7.01514f,-2.81766f,0.848198f},{7.3967f,-2.35441f,0.724286f},
	{5.4f,-2.68109f,0.811897f},{7.01514f,-2.86904f,0.65491f},{7.30158f,-2.75687f,0.624894f},
	{5.4f,-2.73247f,0.618609f},{7.3967f,-2.40579f,0.530998f},{5.25f,-2.55971f,0.572685f},
	{5.25f,-2.50833f,0.765973f},{5.25f,-2.12119f,0.690258f},{5.25f,-2.18616f,0.445801f},
	{5.25f,-1.99455f,0.997832f},{5.25f,-1.86852f,1.21714f},{5.25f,-2.22287f,1.39048f},
	{5.25f,-2.32253f,1.21707f},{7.3967f,-2.18465f,1.13697f},{5.4f,-2.47752f,1.30615f},
	{7.30158f,-2.49946f,1.31853f},{7.01514f,-2.60004f,1.37656f},{5.4f,-2.37786f,1.47955f},
	{7.3967f,-2.08499f,1.31037f},{7.01514f,-2.50038f,1.54996f},{7.30158f,-2.39981f,1.49194f},
	{7.30158f,-1.93016f,2.06362f},{7.01514f,-2.01229f,2.14569f},{7.3967f,-1.67306f,1.80676f},
	{5.4f,-1.91217f,2.04597f},{7.01514f,-2.15343f,2.00399f},{7.30158f,-2.07129f,1.92191f},
	{5.4f,-2.05331f,1.90427f},{7.3967f,-1.8142f,1.66506f},{5.25f,-1.92665f,1.77812f},
	{5.25f,-1.78551f,1.91982f},{5.25f,-1.48809f,1.66068f},{5.25f,-1.66659f,1.48146f},
	{5.25f,-1.22464f,1.86373f},{5.25f,-1.00584f,1.99064f},{5.25f,-1.22605f,2.31793f},
	{5.25f,-1.39906f,2.21758f},{7.3967f,-1.3197f,2.07927f},{5.4f,-1.48874f,2.37222f},
	{7.30158f,-1.50155f,2.39391f},{7.01514f,-1.55964f,2.49446f},{5.4f,-1.31574f,2.47256f},
	{7.3967f,-1.14669f,2.17962f},{7.01514f,-1.38664f,2.5948f},{7.30158f,-1.32855f,2.49427f},
	{7.30158f,-0.635978f,2.75453f},{7.01514f,-0.666067f,2.86667f},{7.3967f,-0.541757f,2.40354f},
	{5.4f,-0.629221f,2.73025f},{7.01514f,-0.859149f,2.81452f},{7.30158f,-0.829059f,2.70237f},
	{5.4f,-0.822304f,2.6781f},{7.3967f,-0.734839f,2.35139f},{5.25f,-0.775693f,2.50552f},
	{5.25f,-0.582611f,2.55767f},{5.25f,-0.454612f,2.18454f},{5.25f,-0.698806f,2.11858f},
	{5.25f,-0.124928f,2.22866f},{5.25f,0.128016f,2.22917f},{5.25f,0.100952f,2.62271f},
	{5.25f,-0.099048f,2.62231f},{7.3967f,-0.099479f,2.46286f},{5.4f,-0.099404f,2.80108f},
	{7.30158f,-0.099647f,2.82627f},{7.01514f,-0.099685f,2.94239f},{5.4f,0.100597f,2.80148f},
	{7.3967f,0.100521f,2.46325f},{7.01514f,0.100315f,2.94278f},{7.30158f,0.100354f,2.82668f}
	};
	static GLfloat normals [717][3] = {
	{-1.0f,0.0f,0.0f},{0.00103931f,-0.999876f,0.0157254f},{-6.12387e-005f,-1.0f,-0.000478302f},
	{-9.43781e-005f,-1.0f,-0.000504671f},{-0.000227878f,-0.999999f,-0.00112352f},{-0.766046f,-0.00127735f,0.642785f},
	{-0.766046f,-0.00127889f,0.642784f},{-0.766045f,-0.00127582f,0.642786f},{9.17784e-005f,1.0f,0.000502619f},
	{5.60407e-005f,1.0f,0.000474183f},{0.00145268f,0.99984f,0.0178396f},{0.000227879f,0.999999f,0.00112355f},
	{0.148378f,-0.00197479f,0.988929f},{0.375688f,-0.00188583f,0.926744f},{0.375674f,-0.00186264f,0.92675f},
	{0.148371f,-0.00196286f,0.98893f},{0.967411f,-0.000509673f,0.253211f},{0.96741f,-0.000515262f,0.253214f},
	{0.967412f,-0.000504085f,0.253208f},{-0.0871569f,-0.00197728f,0.996193f},{0.0f,-0.501725f,0.865027f},
	{0.0f,0.498279f,0.867017f},{0.0f,0.999998f,0.00199184f},{0.0f,0.501724f,-0.865028f},
	{1.91652e-007f,0.729929f,0.683523f},{-5.9625e-008f,0.812793f,0.582552f},{3.85949e-009f,0.849252f,0.527987f},
	{3.93641e-007f,0.683524f,0.729928f},{-6.52452e-008f,0.910826f,0.412791f},{7.81547e-008f,0.935939f,0.352162f},
	{-9.53258e-008f,0.973856f,0.227166f},{1.35275e-008f,0.986659f,0.162801f},{-8.7851e-008f,0.999462f,0.0328107f},
	{7.04247e-008f,0.999462f,-0.0328129f},{-2.26203e-008f,0.986659f,-0.162803f},{1.2338e-007f,0.973856f,-0.227168f},
	{2.76452e-008f,0.935938f,-0.352164f},{9.38102e-008f,0.910825f,-0.412793f},{-4.286e-008f,0.849252f,-0.527988f},
	{-8.56292e-010f,0.812792f,-0.582553f},{-5.25662e-008f,0.729929f,-0.683524f},{2.03375e-013f,0.683524f,-0.729928f},
	{-1.66949e-008f,0.582553f,-0.812792f},{0.0f,0.527987f,-0.849252f},{0.0f,0.412792f,-0.910825f},
	{-7.32009e-008f,0.352162f,-0.935939f},{-9.79179e-008f,0.227168f,-0.973855f},{-1.35051e-007f,0.162803f,-0.986659f},
	{-2.47177e-008f,0.0328135f,-0.999461f},{-5.78829e-008f,-0.0328122f,-0.999461f},{4.75448e-008f,-0.162802f,-0.986659f},
	{-6.53575e-008f,-0.227168f,-0.973856f},{5.16001e-008f,-0.352162f,-0.935939f},{-6.38358e-008f,-0.412792f,-0.910825f},
	{1.10486e-007f,-0.527987f,-0.849252f},{-5.29309e-008f,-0.582554f,-0.812792f},{9.85503e-008f,-0.683523f,-0.729929f},
	{-7.47153e-008f,-0.729928f,-0.683524f},{1.68553e-007f,-0.812791f,-0.582556f},{-2.01715e-008f,-0.849251f,-0.527989f},
	{2.14413e-007f,-0.910824f,-0.412794f},{-6.83427e-008f,-0.935939f,-0.352163f},{1.4959e-007f,-0.973855f,-0.22717f},
	{-1.712e-007f,-0.986658f,-0.162804f},{1.33543e-007f,-0.999461f,-0.0328156f},{-1.86192e-007f,-0.999461f,0.0328124f},
	{1.42461e-007f,-0.986659f,0.162801f},{-1.10031e-007f,-0.973856f,0.227167f},{3.52377e-007f,-0.93594f,0.35216f},
	{1.30042e-008f,-0.910826f,0.412791f},{3.47098e-007f,-0.849253f,0.527985f},{-1.5659e-007f,-0.812793f,0.582553f},
	{2.42506e-007f,-0.72993f,0.683521f},{-1.85869e-007f,-0.683524f,0.729928f},{3.38666e-007f,-0.582557f,0.81279f},
	{-5.75539e-008f,-0.527989f,0.849251f},{4.48036e-007f,-0.412796f,0.910824f},{-1.29452e-007f,-0.352164f,0.935938f},
	{2.88615e-007f,-0.227172f,0.973855f},{-3.03438e-007f,-0.162804f,0.986658f},{2.49287e-007f,-0.0328168f,0.999461f},
	{-2.24619e-007f,0.0328109f,0.999462f},{4.013e-007f,0.162797f,0.98666f},{-2.74854e-007f,0.227165f,0.973856f},
	{1.43801e-007f,0.352158f,0.935941f},{-6.26581e-007f,0.412791f,0.910826f},{1.39975e-009f,0.527986f,0.849253f},
	{-4.52925e-008f,0.582554f,0.812792f},{1.0f,0.0f,0.0f},{0.00217337f,-0.999487f,0.0319606f},
	{0.00467249f,-0.997835f,0.0656007f},{0.0028139f,0.999377f,0.035181f},{0.00529639f,0.99763f,0.0686064f},
	{0.0f,-0.812793f,-0.582553f},{0.0f,-0.729928f,-0.683524f},{0.0f,-0.849253f,-0.527987f},
	{0.0f,-0.683523f,-0.729929f},{0.0f,-0.910826f,-0.412791f},{0.0f,-0.93594f,-0.352161f},
	{0.0f,-0.973856f,-0.227166f},{0.0f,-0.986659f,-0.162801f},{0.0f,-0.999462f,-0.0328106f},
	{0.0f,-0.999461f,0.0328154f},{0.0f,-0.986658f,0.162806f},{0.0f,-0.973855f,0.22717f},
	{0.0f,-0.935938f,0.352164f},{0.0f,-0.910824f,0.412794f},{0.0f,-0.849251f,0.527989f},
	{0.0f,-0.812792f,0.582554f},{0.0f,-0.729928f,0.683524f},{0.0f,-0.683523f,0.729929f},
	{0.0f,-0.582553f,0.812792f},{0.0f,-0.527988f,0.849252f},{0.0f,-0.412793f,0.910825f},
	{0.0f,-0.352162f,0.935939f},{0.0f,-0.227168f,0.973856f},{0.0f,-0.162803f,0.986659f},
	{0.0f,-0.0328138f,0.999461f},{0.0f,0.0328115f,0.999462f},{0.0f,0.162802f,0.986659f},
	{0.0f,0.227166f,0.973856f},{0.0f,0.352161f,0.93594f},{0.0f,0.41279f,0.910826f},
	{0.0f,0.527986f,0.849253f},{0.0f,0.582552f,0.812793f},{0.0f,0.683523f,0.729929f},
	{0.0f,0.729927f,0.683525f},{0.0f,0.812791f,0.582556f},{0.0f,0.84925f,0.527991f},
	{0.0f,0.910823f,0.412797f},{0.0f,0.935937f,0.352166f},{0.0f,0.973855f,0.227171f},
	{0.0f,0.986658f,0.162806f},{0.0f,0.999461f,0.0328162f},{0.0f,0.999462f,-0.0328088f},
	{0.0f,0.986659f,-0.162798f},{0.0f,0.973857f,-0.227163f},{0.0f,0.935941f,-0.352158f},
	{0.0f,0.910827f,-0.412788f},{0.0f,0.849254f,-0.527985f},{0.0f,0.812795f,-0.58255f},
	{0.0f,0.729932f,-0.68352f},{0.0f,0.683528f,-0.729925f},{0.0f,0.582559f,-0.812788f},
	{0.0f,0.527994f,-0.849248f},{0.0f,0.412799f,-0.910822f},{0.0f,0.352169f,-0.935936f},
	{0.0f,0.227175f,-0.973854f},{0.0f,0.16281f,-0.986657f},{0.0f,0.0328203f,-0.999461f},
	{0.0f,-0.0328056f,-0.999462f},{0.0f,-0.162796f,-0.98666f},{0.0f,-0.22716f,-0.973857f},
	{0.0f,-0.352155f,-0.935942f},{0.0f,-0.412786f,-0.910828f},{0.0f,-0.527983f,-0.849255f},
	{0.0f,-0.58255f,-0.812795f},{0.0f,-0.999998f,-0.00198965f},{0.0f,-0.498278f,-0.867017f},
	{0.0052966f,0.981393f,-0.191935f},{0.00281394f,0.974429f,-0.224676f},{0.00145273f,0.970388f,-0.241546f},
	{0.000228044f,0.966216f,-0.257735f},{0.00467212f,-0.946856f,0.321623f},{0.00103983f,-0.961736f,0.273977f},
	{0.00217313f,-0.957158f,0.289558f},{-0.000228102f,-0.966216f,0.257735f},{0.148378f,0.254041f,0.955744f},
	{0.148371f,0.254051f,0.955743f},{-0.0871565f,0.255919f,0.962761f},{-0.0871563f,0.255921f,0.962761f},
	{0.967411f,0.0650436f,0.244715f},{0.967412f,0.0650492f,0.24471f},{0.96741f,0.0650379f,0.24472f},
	{0.375673f,0.238056f,0.895656f},{0.375687f,0.238034f,0.895656f},{9.18581e-005f,0.966056f,-0.258333f},
	{5.57337e-005f,0.966048f,-0.258361f},{-0.766046f,0.16513f,0.621213f},{-0.766045f,0.165131f,0.621214f},
	{-0.766047f,0.165128f,0.621212f},{-9.31087e-005f,-0.966056f,0.258333f},{-5.83485e-005f,-0.966049f,0.25836f},
	{0.00104041f,-0.858055f,0.513558f},{-5.6202e-005f,-0.866262f,0.499589f},{-9.2059e-005f,-0.866277f,0.499564f},
	{-0.000228098f,-0.866586f,0.499027f},{-0.766045f,0.320286f,0.557307f},{-0.766047f,0.320283f,0.557307f},
	{-0.766044f,0.320289f,0.557307f},{9.22931e-005f,0.866276f,-0.499565f},{5.70469e-005f,0.866262f,-0.49959f},
	{0.00145303f,0.874806f,-0.48447f},{0.000227955f,0.866586f,-0.499027f},{0.148378f,0.492753f,0.857426f},
	{0.375689f,0.461735f,0.803529f},{0.375674f,0.46176f,0.803522f},{0.148371f,0.492764f,0.857421f},
	{0.967411f,0.126164f,0.219542f},{0.96741f,0.12616f,0.219548f},{0.967412f,0.126167f,0.219537f},
	{-0.087157f,0.496384f,0.863717f},{-0.0871568f,0.496385f,0.863716f},{0.00217324f,-0.8496f,0.527423f},
	{0.00467229f,-0.83135f,0.555729f},{0.0028141f,0.883077f,-0.46922f},{0.00529665f,0.898277f,-0.439399f},
	{0.00529617f,0.753943f,-0.656919f},{0.00281366f,0.731542f,-0.68179f},{0.00145204f,0.719608f,-0.694379f},
	{0.000227819f,0.707901f,-0.706312f},{0.00467234f,-0.659189f,0.751963f},{0.00104028f,-0.695899f,0.718139f},
	{0.00217327f,-0.684144f,0.729344f},{-0.000228179f,-0.707901f,0.706312f},{0.148378f,0.697882f,0.700675f},
	{0.148371f,0.697893f,0.700665f},{-0.0871572f,0.703016f,0.705813f},{-0.0871575f,0.703015f,0.705814f},
	{0.967411f,0.178687f,0.179408f},{0.967412f,0.178689f,0.179402f},{0.96741f,0.178685f,0.179414f},
	{0.375675f,0.653994f,0.656628f},{0.37569f,0.653972f,0.656641f},{9.07549e-005f,0.707462f,-0.706751f},
	{5.38517e-005f,0.707441f,-0.706772f},{-0.766045f,0.453615f,0.455422f},{-9.23358e-005f,-0.707463f,0.70675f},
	{-5.65887e-005f,-0.707443f,0.70677f},{0.00103924f,-0.486318f,0.873781f},{-5.98731e-005f,-0.500412f,0.865787f},
	{-9.38669e-005f,-0.500436f,0.865774f},{-0.000228453f,-0.500973f,0.865463f},{-0.766044f,0.556031f,0.322499f},
	{-0.766044f,0.556031f,0.322499f},{-0.766044f,0.556031f,0.322499f},{9.05186e-005f,0.500436f,-0.865774f},
	{5.33566e-005f,0.50041f,-0.865789f},{0.00145205f,0.51537f,-0.856967f},{0.000228034f,0.500974f,-0.865462f},
	{0.148379f,0.855448f,0.496177f},{0.37569f,0.801638f,0.465009f},{0.375676f,0.801655f,0.464991f},
	{0.148371f,0.855456f,0.496167f},{0.967411f,0.219032f,0.127047f},{0.96741f,0.219032f,0.127055f},
	{0.967412f,0.219033f,0.12704f},{-0.0871572f,0.861738f,0.499811f},{-0.0871572f,0.861738f,0.49981f},
	{0.00217272f,-0.472064f,0.881561f},{0.00467201f,-0.442103f,0.896952f},{0.00281392f,0.530156f,-0.847895f},
	{0.00529628f,0.558228f,-0.82967f},{0.00529642f,0.324474f,-0.94588f},{0.00281389f,0.292639f,-0.956219f},
	{0.00145172f,0.276008f,-0.961154f},{0.00022797f,0.259904f,-0.965635f},{0.00467234f,-0.194893f,0.980813f},
	{0.0010391f,-0.243597f,0.969876f},{0.00217318f,-0.227814f,0.973702f},{-0.00022807f,-0.259904f,0.965634f},
	{0.148378f,0.95472f,0.257862f},{0.14837f,0.954725f,0.257849f},{-0.087157f,0.961736f,0.259745f},
	{-0.0871573f,0.961735f,0.259747f},{0.967411f,0.244451f,0.0660284f},{0.967412f,0.244449f,0.0660215f},
	{0.96741f,0.244452f,0.0660353f},{0.375674f,0.894689f,0.241661f},{0.375689f,0.894677f,0.241684f},
	{8.98708e-005f,0.259303f,-0.965796f},{5.20036e-005f,0.259274f,-0.965804f},{-0.766044f,0.620553f,0.167598f},
	{-0.766045f,0.620552f,0.1676f},{-0.766044f,0.620555f,0.167597f},{-9.4614e-005f,-0.259306f,0.965795f},
	{-6.15472e-005f,-0.259281f,0.965802f},{0.00104018f,0.015725f,0.999876f},{-5.73111e-005f,-0.000477276f,1.0f},
	{-9.26195e-005f,-0.00050537f,1.0f},{-0.000228084f,-0.00112474f,0.999999f},{-0.766045f,0.642786f,0.00127582f},
	{8.94949e-005f,0.000500802f,-1.0f},{5.08958e-005f,0.000470089f,-1.0f},{0.00145176f,0.0178387f,-0.99984f},
	{0.000228387f,0.0011236f,-0.999999f},{0.148378f,0.988929f,0.00197479f},{0.375688f,0.926744f,0.00188583f},
	{0.375674f,0.92675f,0.00186264f},{0.148371f,0.98893f,0.00196286f},{0.967411f,0.253211f,0.000508921f},
	{0.96741f,0.253214f,0.000515264f},{0.967412f,0.253208f,0.000502578f},{-0.0871569f,0.996193f,0.00197728f},
	{0.00217336f,0.0319605f,0.999487f},{0.00467247f,0.0656005f,0.997835f},{0.00281435f,0.0351809f,-0.999377f},
	{0.00529685f,0.0686064f,-0.99763f},{0.0052964f,-0.191938f,-0.981393f},{0.00281382f,-0.224677f,-0.974429f},
	{0.00145274f,-0.241547f,-0.970388f},{0.000228014f,-0.257735f,-0.966216f},{0.00467221f,0.321622f,0.946857f},
	{0.0010389f,0.273976f,0.961736f},{0.00217328f,0.289558f,0.957158f},{-0.000228062f,0.257735f,0.966216f},
	{0.148379f,0.955744f,-0.254043f},{0.148371f,0.955741f,-0.254056f},{-0.0871568f,0.962761f,-0.255922f},
	{-0.0871568f,0.962761f,-0.255922f},{0.967411f,0.244715f,-0.0650434f},{0.967412f,0.24471f,-0.0650492f},
	{0.96741f,0.24472f,-0.0650377f},{0.375675f,0.895654f,-0.238058f},{0.37569f,0.895655f,-0.238032f},
	{9.19898e-005f,-0.258333f,-0.966056f},{5.60304e-005f,-0.258361f,-0.966048f},{-0.766045f,0.621214f,-0.165131f},
	{-9.50995e-005f,0.258331f,0.966056f},{-6.22059e-005f,0.258356f,0.96605f},{0.00103951f,0.513557f,0.858055f},
	{-6.04595e-005f,0.499586f,0.866264f},{-9.41877e-005f,0.499563f,0.866278f},{-0.000227851f,0.499029f,0.866586f},
	{-0.766044f,0.557307f,-0.320288f},{-0.766045f,0.557307f,-0.320287f},{-0.766044f,0.557307f,-0.320289f},
	{9.22931e-005f,-0.499565f,-0.866276f},{5.70469e-005f,-0.49959f,-0.866262f},{0.00145306f,-0.48447f,-0.874806f},
	{0.000227998f,-0.499027f,-0.866586f},{0.148379f,0.857426f,-0.492752f},{0.37569f,0.803529f,-0.461733f},
	{0.375675f,0.803522f,-0.461758f},{0.148371f,0.857421f,-0.492764f},{0.967411f,0.219543f,-0.126163f},
	{0.96741f,0.219549f,-0.126159f},{0.967412f,0.219537f,-0.126167f},{-0.087157f,0.863717f,-0.496384f},
	{-0.0871568f,0.863716f,-0.496385f},{0.00217359f,0.527423f,0.8496f},{0.00467248f,0.555728f,0.831351f},
	{0.00281416f,-0.46922f,-0.883077f},{0.00529668f,-0.439399f,-0.898276f},{0.00529664f,-0.656918f,-0.753944f},
	{0.00281403f,-0.68179f,-0.731543f},{0.00145261f,-0.69438f,-0.719607f},{0.000227877f,-0.706313f,-0.707899f},
	{0.0046723f,0.751963f,0.659189f},{0.00103947f,0.718139f,0.695899f},{0.0021731f,0.729343f,0.684145f},
	{-0.00022797f,0.706312f,0.707901f},{0.148378f,0.700677f,-0.69788f},{0.148371f,0.700671f,-0.697887f},
	{-0.087157f,0.705814f,-0.703015f},{-0.0871566f,0.705812f,-0.703017f},{0.967411f,0.179407f,-0.178687f},
	{0.967412f,0.179401f,-0.178689f},{0.96741f,0.179414f,-0.178685f},{0.375674f,0.656631f,-0.653992f},
	{0.375687f,0.656642f,-0.653973f},{9.15259e-005f,-0.706753f,-0.707461f},{5.55396e-005f,-0.706773f,-0.70744f},
	{-0.766045f,0.45542f,-0.453615f},{-0.766045f,0.45542f,-0.453616f},{-0.766046f,0.45542f,-0.453614f},
	{-9.37859e-005f,0.706751f,0.707463f},{-6.02087e-005f,0.70677f,0.707444f},{0.00103919f,0.87378f,0.48632f},
	{-6.08834e-005f,0.865786f,0.500414f},{-9.43329e-005f,0.865773f,0.500437f},{-0.000228166f,0.865463f,0.500973f},
	{-0.766045f,0.3225f,-0.55603f},{-0.766045f,0.3225f,-0.55603f},{-0.766044f,0.322499f,-0.556031f},
	{9.04421e-005f,-0.865774f,-0.500435f},{5.31642e-005f,-0.865789f,-0.500409f},{0.00145217f,-0.856967f,-0.51537f},
	{0.000228159f,-0.865463f,-0.500974f},{0.148379f,0.496177f,-0.855448f},{0.37569f,0.465009f,-0.801638f},
	{0.375676f,0.464991f,-0.801655f},{0.148371f,0.496167f,-0.855456f},{0.967411f,0.127047f,-0.219032f},
	{0.96741f,0.127055f,-0.219032f},{0.967412f,0.12704f,-0.219032f},{-0.0871572f,0.499811f,-0.861738f},
	{-0.0871572f,0.499811f,-0.861738f},{0.00217309f,0.881561f,0.472065f},{0.00467225f,0.896951f,0.442106f},
	{0.00281422f,-0.847895f,-0.530157f},{0.00529667f,-0.829669f,-0.55823f},{0.00529642f,-0.94588f,-0.324474f},
	{0.00281389f,-0.956219f,-0.292639f},{0.00145328f,-0.961154f,-0.276009f},{0.000227919f,-0.965635f,-0.259903f},
	{0.00467236f,0.980813f,0.194893f},{0.00103916f,0.969876f,0.243597f},{0.00217325f,0.973702f,0.227814f},
	{-0.000228075f,0.965635f,0.259903f},{0.148379f,0.257864f,-0.95472f},{0.148371f,0.257854f,-0.954724f},
	{-0.087157f,0.259746f,-0.961736f},{-0.0871568f,0.259744f,-0.961736f},{0.967411f,0.0660284f,-0.244451f},
	{0.967412f,0.0660215f,-0.244449f},{0.96741f,0.0660354f,-0.244452f},{0.375675f,0.241664f,-0.894688f},
	{0.375689f,0.241685f,-0.894677f},{9.2984e-005f,-0.965795f,-0.259305f},{5.8331e-005f,-0.965803f,-0.259279f},
	{-0.766045f,0.167597f,-0.620553f},{-9.45596e-005f,0.965795f,0.259306f},{-6.13058e-005f,0.965802f,0.259281f},
	{0.00103894f,0.999876f,-0.0157253f},{-6.12103e-005f,1.0f,0.000478296f},{-9.46543e-005f,1.0f,0.000504907f},
	{-0.000228388f,0.999999f,0.00112358f},{-0.766045f,0.00127582f,-0.642786f},{-0.766045f,0.00127582f,-0.642786f},
	{8.94944e-005f,-1.0f,-0.0005008f},{5.08951e-005f,-1.0f,-0.000470087f},{0.00145176f,-0.99984f,-0.0178387f},
	{0.000228387f,-0.999999f,-0.0011236f},{0.148378f,0.00197915f,-0.988929f},{0.375688f,0.00189134f,-0.926744f},
	{0.375674f,0.00186816f,-0.92675f},{0.14837f,0.00196876f,-0.98893f},{0.967411f,0.000509672f,-0.253211f},
	{0.96741f,0.00051677f,-0.253214f},{0.967412f,0.000502574f,-0.253207f},{-0.0871571f,0.00198025f,-0.996193f},
	{-0.0871568f,0.00197728f,-0.996193f},{0.00217291f,0.999487f,-0.0319607f},{0.00467201f,0.997835f,-0.0656005f},
	{0.00281436f,-0.999377f,-0.035181f},{0.00529687f,-0.99763f,-0.0686066f},{0.00529643f,-0.981393f,0.191937f},
	{0.00281384f,-0.974429f,0.224677f},{0.00145267f,-0.970388f,0.241547f},{0.000228038f,-0.966216f,0.257735f},
	{0.00467243f,0.946856f,-0.321624f},{0.00103982f,0.961735f,-0.273978f},{0.0021734f,0.957158f,-0.289559f},
	{-0.000228044f,0.966216f,-0.257735f},{0.148378f,-0.254045f,-0.955743f},{0.148371f,-0.254056f,-0.955741f},
	{-0.0871569f,-0.255922f,-0.96276f},{-0.0871568f,-0.255923f,-0.96276f},{0.967411f,-0.0650441f,-0.244715f},
	{0.967412f,-0.065049f,-0.24471f},{0.96741f,-0.0650392f,-0.244719f},{0.375674f,-0.238061f,-0.895654f},
	{0.375687f,-0.238039f,-0.895655f},{9.18179e-005f,-0.966056f,0.258333f},{5.56411e-005f,-0.966048f,0.258361f},
	{-0.766045f,-0.165132f,-0.621214f},{-0.766045f,-0.165132f,-0.621214f},{-0.766045f,-0.165131f,-0.621214f},
	{-9.33936e-005f,0.966056f,-0.258332f},{-5.88047e-005f,0.966049f,-0.258359f},{0.00104021f,0.858055f,-0.513557f},
	{-5.66672e-005f,0.866263f,-0.499589f},{-9.22672e-005f,0.866277f,-0.499565f},{-0.000228219f,0.866587f,-0.499027f},
	{-0.766045f,-0.320289f,-0.557306f},{-0.766044f,-0.32029f,-0.557306f},{-0.766045f,-0.320288f,-0.557306f},
	{9.01484e-005f,-0.866276f,0.499566f},{5.29189e-005f,-0.866261f,0.499591f},{0.00145197f,-0.874807f,0.48447f},
	{0.000227962f,-0.866587f,0.499026f},{0.148378f,-0.492752f,-0.857426f},{0.375689f,-0.461734f,-0.803529f},
	{0.375674f,-0.461759f,-0.803522f},{0.14837f,-0.492763f,-0.857421f},{0.967411f,-0.126164f,-0.219542f},
	{0.96741f,-0.12616f,-0.219548f},{0.967412f,-0.126168f,-0.219535f},{-0.0871569f,-0.496383f,-0.863717f},
	{-0.0871567f,-0.496385f,-0.863716f},{0.00217306f,0.849601f,-0.527422f},{0.00467221f,0.83135f,-0.55573f},
	{0.00281412f,-0.883077f,0.46922f},{0.00529653f,-0.898276f,0.4394f},{0.00529637f,-0.753941f,0.65692f},
	{0.00281404f,-0.731543f,0.68179f},{0.00145303f,-0.719608f,0.694378f},{0.000228116f,-0.707902f,0.706311f},
	{0.0046722f,0.659188f,-0.751964f},{0.00103936f,0.695899f,-0.718139f},{0.00217294f,0.684144f,-0.729343f},
	{-0.000228262f,0.707901f,-0.706311f},{0.148378f,-0.697879f,-0.700678f},{0.148372f,-0.697887f,-0.700671f},
	{-0.087157f,-0.703013f,-0.705816f},{0.967411f,-0.178687f,-0.179407f},{0.967412f,-0.178689f,-0.179401f},
	{0.96741f,-0.178685f,-0.179414f},{0.375674f,-0.653992f,-0.65663f},{0.375687f,-0.653973f,-0.656642f},
	{9.23457e-005f,-0.707463f,0.70675f},{5.69986e-005f,-0.707443f,0.70677f},{-0.766045f,-0.453615f,-0.455421f},
	{-0.766046f,-0.453613f,-0.455422f},{-0.766044f,-0.453618f,-0.455421f},{-9.38545e-005f,0.707463f,-0.70675f},
	{-5.99844e-005f,0.707444f,-0.70677f},{0.00103906f,0.48632f,-0.87378f},{-6.22644e-005f,0.500415f,-0.865786f},
	{-9.47829e-005f,0.500437f,-0.865773f},{-0.000227845f,0.500973f,-0.865463f},{-0.766044f,-0.556032f,-0.322498f},
	{9.15336e-005f,-0.500435f,0.865774f},{5.56235e-005f,-0.500411f,0.865788f},{0.00145259f,-0.51537f,0.856967f},
	{0.000227916f,-0.500974f,0.865463f},{0.148379f,-0.855449f,-0.496177f},{0.375687f,-0.801642f,-0.465005f},
	{0.375675f,-0.801656f,-0.46499f},{0.148372f,-0.855454f,-0.49617f},{0.967411f,-0.219033f,-0.127046f},
	{0.96741f,-0.219033f,-0.127053f},{0.967412f,-0.219033f,-0.127039f},{-0.0871573f,-0.861738f,-0.499811f},
	{-0.0871569f,-0.86174f,-0.499808f},{0.00217327f,0.472065f,-0.881561f},{0.00467245f,0.442106f,-0.896951f},
	{0.00281397f,-0.530157f,0.847895f},{0.00529639f,-0.55823f,0.82967f},{0.00529633f,-0.324475f,0.94588f},
	{0.0028138f,-0.29264f,0.956219f},{0.0014529f,-0.27601f,0.961154f},{0.000227844f,-0.259904f,0.965635f},
	{0.00467221f,0.194895f,-0.980813f},{0.00103922f,0.243598f,-0.969876f},{0.00217313f,0.227815f,-0.973702f},
	{-0.00022809f,0.259904f,-0.965634f},{0.148377f,-0.95472f,-0.257863f},{0.148369f,-0.954724f,-0.257852f},
	{-0.087157f,-0.961736f,-0.259743f},{-0.0871568f,-0.961737f,-0.259741f},{0.967411f,-0.244451f,-0.0660281f},
	{0.967412f,-0.244449f,-0.0660208f},{0.96741f,-0.244452f,-0.0660354f},{0.375672f,-0.89469f,-0.241663f},
	{0.375687f,-0.894678f,-0.241685f},{9.23207e-005f,-0.259305f,0.965795f},{5.70467e-005f,-0.259278f,0.965803f},
	{-0.766044f,-0.620554f,-0.167595f},{-0.766045f,-0.620553f,-0.167596f},{-0.766044f,-0.620556f,-0.167594f},
	{-9.43156e-005f,0.259307f,-0.965795f},{-6.08834e-005f,0.259281f,-0.965802f},{0.00103903f,-0.0157247f,-0.999876f},
	{-6.12462e-005f,0.000478324f,-1.0f},{-9.43811e-005f,0.00050469f,-1.0f},{-0.000228294f,0.001126f,-0.999999f},
	{-0.766044f,-0.642787f,-0.00127429f},{-0.766043f,-0.642788f,-0.00127276f},{-0.766045f,-0.642786f,-0.00127582f},
	{9.20693e-005f,-0.000502851f,1.0f},{5.60407e-005f,-0.000474183f,1.0f},{0.00145304f,-0.0178397f,0.99984f},
	{0.000228387f,-0.00112358f,0.999999f},{0.148377f,-0.988929f,-0.00197714f},{0.375685f,-0.926746f,-0.00188583f},
	{0.375672f,-0.926751f,-0.00186485f},{0.14837f,-0.98893f,-0.00196758f},{0.967411f,-0.253211f,-0.000509673f},
	{0.96741f,-0.253214f,-0.000515262f},{0.967412f,-0.253208f,-0.000504085f},{-0.0871572f,-0.996193f,-0.00197965f},
	{-0.0871569f,-0.996193f,-0.00197727f},{0.00217281f,-0.0319592f,-0.999487f},{0.00467222f,-0.0656029f,-0.997835f},
	{0.00281434f,-0.0351809f,0.999377f},{0.00529684f,-0.0686066f,0.99763f},{0.00529655f,0.191936f,0.981393f},
	{0.0028139f,0.224676f,0.974429f},{0.00145257f,0.241546f,0.970388f},{0.000228065f,0.257735f,0.966216f},
	{0.00467243f,-0.321624f,-0.946856f},{0.00103984f,-0.273978f,-0.961735f},{0.0021734f,-0.289559f,-0.957158f},
	{-0.000228032f,-0.257735f,-0.966216f},{0.148378f,-0.955744f,0.254042f},{0.148372f,-0.955742f,0.254051f},
	{-0.0871571f,-0.962761f,0.255919f},{-0.0871568f,-0.962761f,0.255922f},{0.967411f,-0.244715f,0.0650439f},
	{0.967412f,-0.24471f,0.0650489f},{0.96741f,-0.244719f,0.0650389f},{0.375675f,-0.895654f,0.238058f},
	{0.375687f,-0.895655f,0.238038f},{9.15589e-005f,0.258333f,0.966056f},{5.50681e-005f,0.258361f,0.966048f},
	{-0.766045f,-0.621214f,0.165131f},{-9.33459e-005f,-0.258332f,-0.966056f},{-5.87328e-005f,-0.258359f,-0.966049f},
	{0.00103956f,-0.513556f,-0.858055f},{-6.01535e-005f,-0.499585f,-0.866265f},{-9.39399e-005f,-0.499562f,-0.866278f},
	{-0.000227968f,-0.499026f,-0.866587f},{-0.766045f,-0.557307f,0.320288f},{-0.766044f,-0.557307f,0.320288f},
	{-0.766045f,-0.557307f,0.320287f},{8.97084e-005f,0.499565f,0.866277f},{5.13458e-005f,0.499591f,0.866261f},
	{0.00145147f,0.484471f,0.874806f},{0.000227878f,0.499028f,0.866586f},{0.148378f,-0.857427f,0.492751f},
	{0.375686f,-0.803528f,0.461738f},{0.375674f,-0.803522f,0.461759f},{0.148371f,-0.857423f,0.492759f},
	{0.967411f,-0.219542f,0.126164f},{0.96741f,-0.219547f,0.12616f},{0.967412f,-0.219537f,0.126167f},
	{-0.087157f,-0.863719f,0.49638f},{-0.0871567f,-0.863718f,0.496383f},{0.00217343f,-0.527422f,-0.849601f},
	{0.00467259f,-0.55573f,-0.83135f},{0.00281356f,0.469222f,0.883076f},{0.00529626f,0.439399f,0.898277f},
	{0.00529651f,0.656919f,0.753943f},{0.00281396f,0.68179f,0.731542f},{0.00145289f,0.69438f,0.719608f},
	{0.000228032f,0.706313f,0.7079f},{0.00467245f,-0.751964f,-0.659188f},{0.00103964f,-0.71814f,-0.695898f},
	{0.00217335f,-0.729345f,-0.684143f},{-0.000228032f,-0.706313f,-0.7079f},{0.148378f,-0.700677f,0.69788f},
	{0.148371f,-0.700671f,0.697887f},{-0.0871573f,-0.705814f,0.703015f},{-0.0871569f,-0.705812f,0.703017f},
	{0.967411f,-0.179407f,0.178687f},{0.967412f,-0.1794f,0.178689f},{0.96741f,-0.179414f,0.178685f},
	{0.375674f,-0.656631f,0.653991f},{0.375687f,-0.656642f,0.653973f},{9.21538e-005f,0.706751f,0.707462f},
	{5.64857e-005f,0.706772f,0.707442f},{-0.766045f,-0.45542f,0.453617f},{-9.3686e-005f,-0.706751f,-0.707463f},
	{-5.95499e-005f,-0.70677f,-0.707444f},{0.00103896f,-0.873781f,-0.486318f},{-6.20518e-005f,-0.865787f,-0.500413f},
	{-9.49665e-005f,-0.865773f,-0.500436f},{-0.000228054f,-0.865464f,-0.500971f},{-0.766044f,-0.322499f,0.556031f},
	{-0.766044f,-0.322499f,0.556032f},{-0.766044f,-0.322499f,0.556031f},{9.10318e-005f,0.865775f,0.500434f},
	{5.44761e-005f,0.865789f,0.500409f},{0.00145245f,0.856967f,0.515369f},{0.000228119f,0.865463f,0.500973f},
	{0.148378f,-0.496177f,0.855448f},{0.375687f,-0.465005f,0.801642f},{0.375675f,-0.46499f,0.801656f},
	{0.148372f,-0.49617f,0.855454f},{0.967411f,-0.127046f,0.219032f},{0.96741f,-0.127053f,0.219032f},
	{0.967412f,-0.127039f,0.219033f},{-0.0871574f,-0.499812f,0.861737f},{-0.0871572f,-0.49981f,0.861738f},
	{0.00217325f,-0.881562f,-0.472063f},{0.00467225f,-0.896951f,-0.442106f},{0.0028142f,0.847895f,0.530156f},
	{0.00529659f,0.82967f,0.558228f},{0.00529642f,0.94588f,0.324474f},{0.00281371f,0.956219f,0.292637f},
	{0.00145206f,0.961154f,0.276007f},{0.000228011f,0.965635f,0.259901f},{0.0046724f,-0.980814f,-0.194892f},
	{0.00103944f,-0.969876f,-0.243596f},{0.00217327f,-0.973702f,-0.227814f},{-0.000228063f,-0.965635f,-0.259903f},
	{0.148378f,-0.257863f,0.95472f},{0.148371f,-0.257854f,0.954724f},{-0.0871571f,-0.259745f,0.961736f},
	{-0.0871568f,-0.259742f,0.961737f},{0.967411f,-0.0660277f,0.244451f},{0.967412f,-0.0660215f,0.244449f},
	{0.96741f,-0.0660338f,0.244452f},{0.375674f,-0.241661f,0.894689f},{0.375686f,-0.241679f,0.894679f},
	{9.07456e-005f,0.965796f,0.259303f},{5.32879e-005f,0.965804f,0.259275f},{-0.766045f,-0.167597f,0.620553f},
	{-0.766045f,-0.167597f,0.620553f},{-0.766045f,-0.167597f,0.620553f},{-9.40231e-005f,-0.965795f,-0.259306f},
	{-6.02563e-005f,-0.965802f,-0.25928f},{0.00103931f,-0.999876f,0.0157253f},{-6.12482e-005f,-1.0f,-0.000478325f},
	{-9.43822e-005f,-1.0f,-0.00050469f},{-0.000227876f,-0.999999f,-0.00112353f},{-0.766045f,-0.00127582f,0.642786f},
	{-0.766045f,-0.00127582f,0.642786f},{-0.766045f,-0.00127582f,0.642786f},{9.20705e-005f,1.0f,0.00050285f},
	{5.60429e-005f,1.0f,0.000474183f},{0.00145272f,0.99984f,0.0178384f},{0.000227973f,0.999999f,0.00112114f},
	{0.148379f,-0.00197773f,0.988929f},{0.375675f,-0.0018654f,0.926749f},{0.148372f,-0.00196876f,0.98893f},
	{0.967411f,-0.000509523f,0.253211f},{0.96741f,-0.000515263f,0.253214f},{0.967412f,-0.000503783f,0.253208f},
	{-0.0871571f,-0.00198024f,0.996193f},{-0.0871568f,-0.00197727f,0.996193f},{0.00217337f,-0.999487f,0.0319604f},
	{0.00467249f,-0.997835f,0.0656003f},{0.00281371f,0.999377f,0.0351784f},{0.00529639f,0.99763f,0.0686064f}
	};
	static GLfloat textures [153][2] = {
	{0.808657f,0.078849f},{0.728833f,0.022556f},{0.812455f,0.052167f},
	{0.731484f,0.104263f},{0.987166f,0.022556f},{0.892639f,0.064834f},
	{0.883081f,0.063871f},{0.833966f,0.062569f},{0.834164f,0.070113f},
	{0.882937f,0.071271f},{0.89278f,0.070456f},{0.972409f,0.113506f},
	{0.628675f,0.087467f},{0.648191f,0.126001f},{0.60673f,0.097681f},
	{0.650864f,0.100853f},{0.694662f,0.100718f},{0.672316f,0.085929f},
	{0.69867f,0.043362f},{0.672018f,0.059838f},{0.647915f,0.026001f},
	{0.64874f,0.047849f},{0.893948f,0.452856f},{0.855622f,0.363055f},
	{0.920385f,0.434849f},{0.844304f,0.371892f},{0.864936f,0.352205f},
	{0.943327f,0.411683f},{0.871933f,0.339858f},{0.96169f,0.384057f},
	{0.876418f,0.326425f},{0.974567f,0.352891f},{0.878207f,0.312383f},
	{0.981251f,0.319275f},{0.877205f,0.298279f},{0.981251f,0.284424f},
	{0.873455f,0.284695f},{0.974303f,0.249631f},{0.867208f,0.272117f},
	{0.96036f,0.216227f},{0.858615f,0.261053f},{0.939564f,0.185569f},
	{0.848214f,0.251478f},{0.910894f,0.16196f},{0.835861f,0.244194f},
	{0.878546f,0.144806f},{0.822335f,0.239467f},{0.843858f,0.134528f},
	{0.808058f,0.23764f},{0.808194f,0.131318f},{0.793778f,0.23859f},
	{0.772903f,0.135121f},{0.77989f,0.242402f},{0.739281f,0.145665f},
	{0.767174f,0.249033f},{0.708566f,0.162453f},{0.756072f,0.25776f},
	{0.681863f,0.184773f},{0.746791f,0.268455f},{0.660115f,0.211748f},
	{0.739754f,0.280866f},{0.644115f,0.242338f},{0.735408f,0.294379f},
	{0.634446f,0.275334f},{0.733692f,0.308504f},{0.631425f,0.30945f},
	{0.734875f,0.322625f},{0.635118f,0.343345f},{0.738726f,0.336126f},
	{0.645294f,0.375709f},{0.745053f,0.348723f},{0.661497f,0.405334f},
	{0.753767f,0.359746f},{0.683038f,0.431102f},{0.764331f,0.368803f},
	{0.709014f,0.452084f},{0.776391f,0.37579f},{0.73839f,0.467558f},
	{0.789676f,0.380362f},{0.770017f,0.476995f},{0.803563f,0.382208f},
	{0.802638f,0.480113f},{0.81765f,0.381468f},{0.834981f,0.476907f},
	{0.831373f,0.377956f},{0.865797f,0.46764f},{0.626177f,0.061517f},
	{0.838418f,0.362352f},{0.848184f,0.355145f},{0.85607f,0.345934f},
	{0.862047f,0.335435f},{0.865876f,0.324007f},{0.867406f,0.312067f},
	{0.866561f,0.300086f},{0.863316f,0.288579f},{0.858077f,0.277832f},
	{0.850783f,0.268301f},{0.84182f,0.260176f},{0.831253f,0.254194f},
	{0.819806f,0.250062f},{0.807723f,0.24867f},{0.795599f,0.249393f},
	{0.78379f,0.252506f},{0.772963f,0.25807f},{0.763578f,0.265639f},
	{0.755655f,0.274692f},{0.749625f,0.285185f},{0.746058f,0.296751f},
	{0.744436f,0.308714f},{0.745486f,0.320731f},{0.748822f,0.332226f},
	{0.754044f,0.343005f},{0.761504f,0.35237f},{0.770568f,0.360052f},
	{0.78081f,0.36606f},{0.792099f,0.370006f},{0.804f,0.371411f},
	{0.815991f,0.370885f},{0.827631f,0.367738f},{0.8333f,0.35412f},
	{0.841154f,0.347743f},{0.8479f,0.340157f},{0.852973f,0.331398f},
	{0.856221f,0.321821f},{0.857543f,0.311796f},{0.856913f,0.301712f},
	{0.854415f,0.291969f},{0.849781f,0.28303f},{0.843523f,0.275063f},
	{0.835811f,0.26842f},{0.827156f,0.263086f},{0.817467f,0.259971f},
	{0.807414f,0.258406f},{0.79729f,0.259262f},{0.787475f,0.262116f},
	{0.778283f,0.266514f},{0.770224f,0.272588f},{0.763784f,0.280362f},
	{0.758936f,0.289295f},{0.755576f,0.298848f},{0.75459f,0.308914f},
	{0.755216f,0.31902f},{0.757775f,0.328736f},{0.762527f,0.337598f},
	{0.76861f,0.345635f},{0.776055f,0.35231f},{0.784816f,0.357124f},
	{0.794404f,0.360201f},{0.804341f,0.361741f},{0.814367f,0.360885f},
	{0.824184f,0.358436f},{0.805938f,0.310263f},{0.60673f,0.048133f}
	};
	GLint GenMarxbotWheel()
	{
	unsigned i;
	unsigned j;

	GLint lid=glGenLists(1);
	glNewList(lid, GL_COMPILE);

		glBegin (GL_TRIANGLES);
		for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
		{
		for(j=0;j<3;j++)
			{
			int vi=face_indicies[i][j];
			int ni=face_indicies[i][j+3];//Normal index
			int ti=face_indicies[i][j+6];//Texture index
			/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
			// rotate 90 deg around z
			glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][1],-vertices[vi][0],vertices[vi][2]);
			}
		}
		glEnd ();

	glEndList();
	return lid;
	};
}
