
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2008 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://lis.epfl.ch/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// E-puck object file

#include <QtOpenGL>

namespace Enki
{
	// 306 Verticies
	// 271 Texture Coordinates
	// 299 Normals
	// 544 Triangles
	
	static short face_indicies[544][9] = {
	// (unnamed)
		{0,1,31 ,0,0,0 ,0,1,2 }, {31,1,30 ,0,0,0 ,2,1,3 }, {1,2,30 ,0,0,0 ,1,4,3 },
		{30,2,29 ,0,0,0 ,3,4,5 }, {2,3,29 ,0,0,0 ,4,6,5 }, {29,3,28 ,0,0,0 ,5,6,7 },
		{3,4,28 ,0,0,0 ,6,8,7 }, {28,4,27 ,0,0,0 ,7,8,9 }, {4,5,27 ,0,0,0 ,8,10,9 },
		{27,5,26 ,0,0,0 ,9,10,11 }, {5,6,26 ,0,0,0 ,10,12,11 }, {26,6,25 ,0,0,0 ,11,12,13 },
		{6,7,25 ,0,0,0 ,12,14,13 }, {25,7,24 ,0,0,0 ,13,14,15 }, {7,8,24 ,0,0,0 ,14,16,15 },
		{24,8,23 ,0,0,0 ,15,16,17 }, {8,9,23 ,0,0,0 ,16,18,17 }, {23,9,22 ,0,0,0 ,17,18,19 },
		{9,10,22 ,0,0,0 ,18,20,19 }, {22,10,21 ,0,0,0 ,19,20,21 }, {10,11,21 ,0,0,0 ,20,22,21 },
		{21,11,20 ,0,0,0 ,21,22,23 }, {11,12,20 ,0,0,0 ,22,24,23 }, {20,12,19 ,0,0,0 ,23,24,25 },
		{12,13,19 ,0,0,0 ,24,26,25 }, {19,13,18 ,0,0,0 ,25,26,27 }, {13,14,18 ,0,0,0 ,26,28,27 },
		{18,14,17 ,0,0,0 ,27,28,29 }, {15,17,14 ,0,0,0 ,30,29,28 }, {16,17,15 ,0,0,0 ,31,29,30 },
		{32,63,33 ,1,1,1 ,0,32,1 }, {33,63,34 ,1,1,1 ,1,32,4 }, {63,62,34 ,1,1,1 ,32,3,4 },
		{34,62,35 ,1,1,1 ,4,3,6 }, {62,61,35 ,1,1,1 ,3,5,6 }, {35,61,36 ,1,1,1 ,6,5,8 },
		{61,60,36 ,1,1,1 ,5,7,8 }, {36,60,37 ,1,1,1 ,8,7,10 }, {60,59,37 ,1,1,1 ,7,9,10 },
		{37,59,38 ,1,1,1 ,10,9,12 }, {59,58,38 ,1,1,1 ,9,11,12 }, {38,58,39 ,1,1,1 ,12,11,14 },
		{58,57,39 ,1,1,1 ,11,13,14 }, {39,57,40 ,1,1,1 ,14,13,16 }, {57,56,40 ,1,1,1 ,13,15,16 },
		{40,56,41 ,1,1,1 ,16,15,18 }, {56,55,41 ,1,1,1 ,15,17,18 }, {41,55,42 ,1,1,1 ,18,17,20 },
		{55,54,42 ,1,1,1 ,17,19,20 }, {42,54,43 ,1,1,1 ,20,19,22 }, {54,53,43 ,1,1,1 ,19,21,22 },
		{43,53,44 ,1,1,1 ,22,21,24 }, {53,52,44 ,1,1,1 ,21,23,24 }, {44,52,45 ,1,1,1 ,24,23,26 },
		{52,51,45 ,1,1,1 ,23,25,26 }, {45,51,46 ,1,1,1 ,26,25,28 }, {51,50,46 ,1,1,1 ,25,27,28 },
		{46,50,47 ,1,1,1 ,28,27,30 }, {49,47,50 ,1,1,1 ,29,30,27 }, {48,47,49 ,1,1,1 ,31,30,29 },
		{97,130,191 ,2,3,4 ,15,33,34 }, {97,99,130 ,2,5,3 ,15,13,33 },
		{191,128,190 ,4,6,7 ,34,35,36 }, {191,130,128 ,4,3,6 ,34,33,35 },
		{190,98,96 ,7,8,9 ,36,37,38 }, {190,128,98 ,7,6,8 ,36,35,37 },
		{95,191,189 ,10,4,11 ,17,34,39 }, {95,97,191 ,10,2,4 ,17,15,34 },
		{189,190,188 ,11,7,12 ,39,36,40 }, {189,191,190 ,11,4,7 ,39,34,36 },
		{188,96,94 ,12,9,13 ,40,38,41 }, {188,190,96 ,12,7,9 ,40,36,38 },
		{93,189,187 ,14,11,15 ,19,39,42 }, {93,95,189 ,14,10,11 ,19,17,39 },
		{187,188,186 ,15,12,16 ,42,40,43 }, {187,189,188 ,15,11,12 ,42,39,40 },
		{186,94,92 ,16,13,17 ,43,41,44 }, {186,188,94 ,16,12,13 ,43,40,41 },
		{91,187,185 ,18,15,19 ,21,42,45 }, {91,93,187 ,18,14,15 ,21,19,42 },
		{185,186,184 ,19,16,20 ,45,43,46 }, {185,187,186 ,19,15,16 ,45,42,43 },
		{184,92,90 ,20,17,21 ,46,44,47 }, {184,186,92 ,20,16,17 ,46,43,44 },
		{89,185,183 ,22,19,23 ,23,45,48 }, {89,91,185 ,22,18,19 ,23,21,45 },
		{183,184,182 ,23,20,24 ,48,46,49 }, {183,185,184 ,23,19,20 ,48,45,46 },
		{182,90,88 ,24,21,25 ,49,47,50 }, {182,184,90 ,24,20,21 ,49,46,47 },
		{87,183,181 ,26,23,27 ,25,48,51 }, {87,89,183 ,26,22,23 ,25,23,48 },
		{181,182,180 ,27,24,28 ,51,49,52 }, {181,183,182 ,27,23,24 ,51,48,49 },
		{180,88,86 ,28,25,29 ,52,50,53 }, {180,182,88 ,28,24,25 ,52,49,50 },
		{85,181,179 ,30,27,31 ,27,51,54 }, {85,87,181 ,30,26,27 ,27,25,51 },
		{179,180,178 ,31,28,32 ,54,52,55 }, {179,181,180 ,31,27,28 ,54,51,52 },
		{178,86,84 ,32,29,33 ,55,53,56 }, {178,180,86 ,32,28,29 ,55,52,53 },
		{83,179,177 ,34,31,35 ,29,54,57 }, {83,85,179 ,34,30,31 ,29,27,54 },
		{177,178,176 ,35,32,36 ,57,55,58 }, {177,179,178 ,35,31,32 ,57,54,55 },
		{176,84,82 ,36,33,37 ,58,56,59 }, {176,178,84 ,36,32,33 ,58,55,56 },
		{81,177,175 ,38,35,39 ,31,57,60 }, {81,83,177 ,38,34,35 ,31,29,57 },
		{175,176,174 ,39,36,40 ,60,58,61 }, {175,177,176 ,39,35,36 ,60,57,58 },
		{174,82,80 ,40,37,41 ,61,59,62 }, {174,176,82 ,40,36,37 ,61,58,59 },
		{79,175,173 ,42,39,43 ,30,60,63 }, {79,81,175 ,42,38,39 ,30,31,60 },
		{173,174,172 ,43,40,44 ,63,61,64 }, {173,175,174 ,43,39,40 ,63,60,61 },
		{172,80,78 ,44,41,45 ,64,62,65 }, {172,174,80 ,44,40,41 ,64,61,62 },
		{77,173,171 ,46,43,47 ,28,63,66 }, {77,79,173 ,46,42,43 ,28,30,63 },
		{171,172,170 ,47,44,48 ,66,64,67 }, {171,173,172 ,47,43,44 ,66,63,64 },
		{170,78,76 ,48,45,49 ,67,65,68 }, {170,172,78 ,48,44,45 ,67,64,65 },
		{75,171,169 ,50,47,51 ,26,66,69 }, {75,77,171 ,50,46,47 ,26,28,66 },
		{169,170,168 ,51,48,52 ,69,67,70 }, {169,171,170 ,51,47,48 ,69,66,67 },
		{168,76,74 ,52,49,53 ,70,68,71 }, {168,170,76 ,52,48,49 ,70,67,68 },
		{73,169,167 ,54,51,55 ,24,69,72 }, {73,75,169 ,54,50,51 ,24,26,69 },
		{167,168,166 ,55,52,56 ,72,70,73 }, {167,169,168 ,55,51,52 ,72,69,70 },
		{166,74,72 ,56,53,57 ,73,71,74 }, {166,168,74 ,56,52,53 ,73,70,71 },
		{71,167,165 ,58,55,59 ,22,72,75 }, {71,73,167 ,58,54,55 ,22,24,72 },
		{165,166,164 ,59,56,60 ,75,73,76 }, {165,167,166 ,59,55,56 ,75,72,73 },
		{164,72,70 ,60,57,61 ,76,74,77 }, {164,166,72 ,60,56,57 ,76,73,74 },
		{69,165,163 ,62,59,63 ,20,75,78 }, {69,71,165 ,62,58,59 ,20,22,75 },
		{163,164,162 ,63,60,64 ,78,76,79 }, {163,165,164 ,63,59,60 ,78,75,76 },
		{162,70,68 ,64,61,65 ,79,77,80 }, {162,164,70 ,64,60,61 ,79,76,77 },
		{67,163,161 ,66,63,67 ,18,78,81 }, {67,69,163 ,66,62,63 ,18,20,78 },
		{161,162,160 ,67,64,68 ,81,79,82 }, {161,163,162 ,67,63,64 ,81,78,79 },
		{160,68,65 ,68,65,69 ,82,80,83 }, {160,162,68 ,68,64,65 ,82,79,80 },
		{66,161,159 ,70,67,71 ,16,81,84 }, {66,67,161 ,70,66,67 ,16,18,81 },
		{159,160,158 ,71,68,72 ,84,82,85 }, {159,161,160 ,71,67,68 ,84,81,82 },
		{158,65,64 ,72,69,73 ,85,83,16 }, {158,160,65 ,72,68,69 ,85,82,83 },
		{127,159,157 ,74,71,75 ,86,84,87 }, {127,66,159 ,74,70,71 ,86,16,84 },
		{157,158,156 ,75,72,76 ,87,85,88 }, {157,159,158 ,75,71,72 ,87,84,85 },
		{156,64,126 ,76,73,77 ,88,16,89 }, {156,158,64 ,76,72,73 ,88,85,16 },
		{125,157,155 ,78,75,79 ,12,87,90 }, {125,127,157 ,78,74,75 ,12,86,87 },
		{155,156,154 ,79,76,80 ,90,88,91 }, {155,157,156 ,79,75,76 ,90,87,88 },
		{154,126,124 ,80,77,81 ,91,89,92 }, {154,156,126 ,80,76,77 ,91,88,89 },
		{123,155,153 ,82,79,83 ,10,90,93 }, {123,125,155 ,82,78,79 ,10,12,90 },
		{153,154,152 ,83,80,84 ,93,91,94 }, {153,155,154 ,83,79,80 ,93,90,91 },
		{152,124,122 ,84,81,85 ,94,92,95 }, {152,154,124 ,84,80,81 ,94,91,92 },
		{121,153,151 ,86,83,87 ,8,93,96 }, {121,123,153 ,86,82,83 ,8,10,93 },
		{151,152,150 ,87,84,88 ,96,94,97 }, {151,153,152 ,87,83,84 ,96,93,94 },
		{150,122,120 ,88,85,89 ,97,95,98 }, {150,152,122 ,88,84,85 ,97,94,95 },
		{119,151,149 ,90,87,91 ,6,96,99 }, {119,121,151 ,90,86,87 ,6,8,96 },
		{149,150,148 ,91,88,92 ,99,97,100 }, {149,151,150 ,91,87,88 ,99,96,97 },
		{148,120,118 ,92,89,93 ,100,98,101 }, {148,150,120 ,92,88,89 ,100,97,98 },
		{117,149,147 ,94,91,95 ,4,99,102 }, {117,119,149 ,94,90,91 ,4,6,99 },
		{147,148,146 ,95,92,96 ,102,100,103 }, {147,149,148 ,95,91,92 ,102,99,100 },
		{146,118,116 ,96,93,97 ,103,101,104 }, {146,148,118 ,96,92,93 ,103,100,101 },
		{115,147,145 ,98,95,99 ,1,102,105 }, {115,117,147 ,98,94,95 ,1,4,102 },
		{145,146,144 ,99,96,100 ,105,103,106 }, {145,147,146 ,99,95,96 ,105,102,103 },
		{144,116,114 ,100,97,101 ,106,104,107 }, {144,146,116 ,100,96,97 ,106,103,104 },
		{113,145,143 ,102,99,103 ,0,105,108 }, {113,115,145 ,102,98,99 ,0,1,105 },
		{143,144,142 ,103,100,104 ,108,106,109 }, {143,145,144 ,103,99,100 ,108,105,106 },
		{142,114,112 ,104,101,105 ,109,107,110 }, {142,144,114 ,104,100,101 ,109,106,107 },
		{111,143,141 ,106,103,107 ,2,108,111 }, {111,113,143 ,106,102,103 ,2,0,108 },
		{141,142,140 ,107,104,108 ,111,109,112 }, {141,143,142 ,107,103,104 ,111,108,109 },
		{140,112,110 ,108,105,109 ,112,110,113 }, {140,142,112 ,108,104,105 ,112,109,110 },
		{109,141,139 ,110,107,111 ,3,111,114 }, {109,111,141 ,110,106,107 ,3,2,111 },
		{139,140,138 ,111,108,112 ,114,112,115 }, {139,141,140 ,111,107,108 ,114,111,112 },
		{138,110,108 ,112,109,113 ,115,113,116 }, {138,140,110 ,112,108,109 ,115,112,113 },
		{107,139,137 ,114,111,115 ,5,114,117 }, {107,109,139 ,114,110,111 ,5,3,114 },
		{137,138,136 ,115,112,116 ,117,115,118 }, {137,139,138 ,115,111,112 ,117,114,115 },
		{136,108,106 ,116,113,117 ,118,116,119 }, {136,138,108 ,116,112,113 ,118,115,116 },
		{105,137,135 ,118,115,119 ,7,117,120 }, {105,107,137 ,118,114,115 ,7,5,117 },
		{135,136,134 ,119,116,120 ,120,118,121 }, {135,137,136 ,119,115,116 ,120,117,118 },
		{134,106,104 ,120,117,121 ,121,119,122 }, {134,136,106 ,120,116,117 ,121,118,119 },
		{103,135,133 ,122,119,123 ,9,120,123 }, {103,105,135 ,122,118,119 ,9,7,120 },
		{133,134,132 ,123,120,124 ,123,121,124 }, {133,135,134 ,123,119,120 ,123,120,121 },
		{132,104,102 ,124,121,125 ,124,122,125 }, {132,134,104 ,124,120,121 ,124,121,122 },
		{101,133,131 ,126,123,127 ,11,123,126 }, {101,103,133 ,126,122,123 ,11,9,123 },
		{131,132,129 ,127,124,128 ,126,124,127 }, {131,133,132 ,127,123,124 ,126,123,124 },
		{129,102,100 ,128,125,129 ,127,125,128 }, {129,132,102 ,128,124,125 ,127,124,125 },
		{99,131,130 ,5,127,3 ,13,126,33 }, {99,101,131 ,5,126,127 ,13,11,126 },
		{130,129,128 ,3,128,6 ,33,127,35 }, {130,131,129 ,3,127,128 ,33,126,127 },
		{128,100,98 ,6,129,8 ,35,128,37 }, {128,129,100 ,6,128,129 ,35,127,128 },
		{39,66,127 ,130,70,74 ,14,16,86 }, {39,40,66 ,130,131,70 ,14,16,16 },
		{126,8,7 ,77,132,133 ,89,16,14 }, {126,64,8 ,77,73,132 ,89,16,16 },
		{38,127,125 ,134,74,78 ,12,86,12 }, {38,39,127 ,134,130,74 ,12,14,86 },
		{124,7,6 ,81,133,135 ,92,14,12 }, {124,126,7 ,81,77,133 ,92,89,14 },
		{37,125,123 ,136,78,82 ,10,12,10 }, {37,38,125 ,136,134,78 ,10,12,12 },
		{122,6,5 ,85,135,137 ,95,12,10 }, {122,124,6 ,85,81,135 ,95,92,12 },
		{36,123,121 ,138,82,86 ,8,10,8 }, {36,37,123 ,138,136,82 ,8,10,10 },
		{120,5,4 ,89,137,139 ,98,10,8 }, {120,122,5 ,89,85,137 ,98,95,10 },
		{35,121,119 ,140,86,90 ,6,8,6 }, {35,36,121 ,140,138,86 ,6,8,8 },
		{118,4,3 ,93,139,141 ,101,8,6 }, {118,120,4 ,93,89,139 ,101,98,8 },
		{34,119,117 ,142,90,94 ,4,6,4 }, {34,35,119 ,142,140,90 ,4,6,6 },
		{116,3,2 ,97,141,143 ,104,6,4 }, {116,118,3 ,97,93,141 ,104,101,6 },
		{33,117,115 ,144,94,98 ,1,4,1 }, {33,34,117 ,144,142,94 ,1,4,4 },
		{114,2,1 ,101,143,145 ,107,4,1 }, {114,116,2 ,101,97,143 ,107,104,4 },
		{32,115,113 ,146,98,102 ,0,1,0 }, {32,33,115 ,146,144,98 ,0,1,1 },
		{112,1,0 ,105,145,147 ,110,1,0 }, {112,114,1 ,105,101,145 ,110,107,1 },
		{63,113,111 ,148,102,106 ,32,0,2 }, {63,32,113 ,148,146,102 ,32,0,0 },
		{110,0,31 ,109,147,149 ,113,0,2 }, {110,112,0 ,109,105,147 ,113,110,0 },
		{62,111,109 ,150,106,110 ,3,2,3 }, {62,63,111 ,150,148,106 ,3,32,2 },
		{108,31,30 ,113,149,151 ,116,2,3 }, {108,110,31 ,113,109,149 ,116,113,2 },
		{61,109,107 ,152,110,114 ,5,3,5 }, {61,62,109 ,152,150,110 ,5,3,3 },
		{106,30,29 ,117,151,153 ,119,3,5 }, {106,108,30 ,117,113,151 ,119,116,3 },
		{60,107,105 ,154,114,118 ,7,5,7 }, {60,61,107 ,154,152,114 ,7,5,5 },
		{104,29,28 ,121,153,155 ,122,5,7 }, {104,106,29 ,121,117,153 ,122,119,5 },
		{59,105,103 ,156,118,122 ,9,7,9 }, {59,60,105 ,156,154,118 ,9,7,7 },
		{102,28,27 ,125,155,157 ,125,7,9 }, {102,104,28 ,125,121,155 ,125,122,7 },
		{58,103,101 ,158,122,126 ,11,9,11 }, {58,59,103 ,158,156,122 ,11,9,9 },
		{100,27,26 ,129,157,159 ,128,9,11 }, {100,102,27 ,129,125,157 ,128,125,9 },
		{57,101,99 ,160,126,5 ,13,11,13 }, {57,58,101 ,160,158,126 ,13,11,11 },
		{98,26,25 ,8,159,161 ,37,11,13 }, {98,100,26 ,8,129,159 ,37,128,11 },
		{56,99,97 ,162,5,2 ,15,13,15 }, {56,57,99 ,162,160,5 ,15,13,13 },
		{96,25,24 ,9,161,163 ,38,13,15 }, {96,98,25 ,9,8,161 ,38,37,13 },
		{55,97,95 ,164,2,10 ,17,15,17 }, {55,56,97 ,164,162,2 ,17,15,15 },
		{94,24,23 ,13,163,165 ,41,15,17 }, {94,96,24 ,13,9,163 ,41,38,15 },
		{54,95,93 ,166,10,14 ,19,17,19 }, {54,55,95 ,166,164,10 ,19,17,17 },
		{92,23,22 ,17,165,167 ,44,17,19 }, {92,94,23 ,17,13,165 ,44,41,17 },
		{53,93,91 ,168,14,18 ,21,19,21 }, {53,54,93 ,168,166,14 ,21,19,19 },
		{90,22,21 ,21,167,169 ,47,19,21 }, {90,92,22 ,21,17,167 ,47,44,19 },
		{52,91,89 ,170,18,22 ,23,21,23 }, {52,53,91 ,170,168,18 ,23,21,21 },
		{88,21,20 ,25,169,171 ,50,21,23 }, {88,90,21 ,25,21,169 ,50,47,21 },
		{51,89,87 ,172,22,26 ,25,23,25 }, {51,52,89 ,172,170,22 ,25,23,23 },
		{86,20,19 ,29,171,173 ,53,23,25 }, {86,88,20 ,29,25,171 ,53,50,23 },
		{50,87,85 ,174,26,30 ,27,25,27 }, {50,51,87 ,174,172,26 ,27,25,25 },
		{84,19,18 ,33,173,175 ,56,25,27 }, {84,86,19 ,33,29,173 ,56,53,25 },
		{49,85,83 ,176,30,34 ,29,27,29 }, {49,50,85 ,176,174,30 ,29,27,27 },
		{82,18,17 ,37,175,177 ,59,27,29 }, {82,84,18 ,37,33,175 ,59,56,27 },
		{48,83,81 ,178,34,38 ,31,29,31 }, {48,49,83 ,178,176,34 ,31,29,29 },
		{80,17,16 ,41,177,179 ,62,29,31 }, {80,82,17 ,41,37,177 ,62,59,29 },
		{47,81,79 ,180,38,42 ,30,31,30 }, {47,48,81 ,180,178,38 ,30,31,31 },
		{78,16,15 ,45,179,181 ,65,31,30 }, {78,80,16 ,45,41,179 ,65,62,31 },
		{46,79,77 ,182,42,46 ,28,30,28 }, {46,47,79 ,182,180,42 ,28,30,30 },
		{76,15,14 ,49,181,183 ,68,30,28 }, {76,78,15 ,49,45,181 ,68,65,30 },
		{45,77,75 ,184,46,50 ,26,28,26 }, {45,46,77 ,184,182,46 ,26,28,28 },
		{74,14,13 ,53,183,185 ,71,28,26 }, {74,76,14 ,53,49,183 ,71,68,28 },
		{44,75,73 ,186,50,54 ,24,26,24 }, {44,45,75 ,186,184,50 ,24,26,26 },
		{72,13,12 ,57,185,187 ,74,26,24 }, {72,74,13 ,57,53,185 ,74,71,26 },
		{43,73,71 ,188,54,58 ,22,24,22 }, {43,44,73 ,188,186,54 ,22,24,24 },
		{70,12,11 ,61,187,189 ,77,24,22 }, {70,72,12 ,61,57,187 ,77,74,24 },
		{42,71,69 ,190,58,62 ,20,22,20 }, {42,43,71 ,190,188,58 ,20,22,22 },
		{68,11,10 ,65,189,191 ,80,22,20 }, {68,70,11 ,65,61,189 ,80,77,22 },
		{41,69,67 ,192,62,66 ,18,20,18 }, {41,42,69 ,192,190,62 ,18,20,20 },
		{65,10,9 ,69,191,193 ,83,20,18 }, {65,68,10 ,69,65,191 ,83,80,20 },
		{40,67,66 ,131,66,70 ,16,18,16 }, {40,41,67 ,131,192,66 ,16,18,18 },
		{64,9,8 ,73,193,132 ,16,18,16 }, {64,65,9 ,73,69,193 ,16,83,18 },
		{193,280,192 ,194,195,196 ,129,130,131 }, {193,279,280 ,194,197,195 ,129,132,130 },
		{194,279,193 ,198,197,194 ,133,132,129 }, {194,278,279 ,198,199,197 ,133,134,132 },
		{195,278,194 ,200,199,198 ,135,134,133 }, {195,277,278 ,200,201,199 ,135,136,134 },
		{196,277,195 ,202,201,200 ,137,136,135 }, {196,276,277 ,202,203,201 ,137,138,136 },
		{197,276,196 ,204,203,202 ,139,138,137 }, {197,275,276 ,204,205,203 ,139,140,138 },
		{198,275,197 ,206,205,204 ,141,140,139 }, {198,292,275 ,206,206,205 ,141,142,140 },
		{291,198,199 ,207,206,208 ,143,141,144 }, {291,292,198 ,207,206,206 ,143,142,141 },
		{290,199,200 ,209,208,210 ,145,144,146 }, {290,291,199 ,209,207,208 ,145,143,144 },
		{289,200,201 ,211,210,212 ,147,146,148 }, {289,290,200 ,211,209,210 ,147,145,146 },
		{288,201,202 ,213,212,214 ,149,148,150 }, {288,289,201 ,213,211,212 ,149,147,148 },
		{287,202,203 ,215,214,216 ,151,150,152 }, {287,288,202 ,215,213,214 ,151,149,150 },
		{286,203,204 ,217,216,218 ,153,152,154 }, {286,287,203 ,217,215,216 ,153,151,152 },
		{285,204,205 ,219,218,220 ,155,156,157 }, {285,286,204 ,219,217,218 ,155,158,156 },
		{284,205,206 ,221,220,222 ,159,157,160 }, {284,285,205 ,221,219,220 ,159,155,157 },
		{283,206,207 ,223,222,224 ,161,160,162 }, {283,284,206 ,223,221,222 ,161,159,160 },
		{282,207,208 ,225,224,226 ,163,162,164 }, {282,283,207 ,225,223,224 ,163,161,162 },
		{281,208,209 ,227,226,228 ,165,164,166 }, {281,282,208 ,227,225,226 ,165,163,164 },
		{293,209,210 ,229,228,229 ,167,166,168 }, {293,281,209 ,229,227,228 ,167,165,166 },
		{211,293,210 ,230,229,229 ,169,167,168 }, {211,274,293 ,230,231,229 ,169,170,167 },
		{212,274,211 ,232,231,230 ,171,170,169 }, {212,273,274 ,232,233,231 ,171,172,170 },
		{213,273,212 ,234,233,232 ,173,172,171 }, {213,272,273 ,234,235,233 ,173,174,172 },
		{214,272,213 ,236,235,234 ,175,174,173 }, {214,271,272 ,236,237,235 ,175,176,174 },
		{215,271,214 ,238,237,236 ,177,176,175 }, {215,270,271 ,238,239,237 ,177,178,176 },
		{192,270,215 ,196,239,238 ,131,178,177 }, {192,280,270 ,196,195,239 ,131,130,178 },
		{280,279,270 ,0,0,0 ,179,180,181 }, {270,279,271 ,0,0,0 ,181,180,182 },
		{279,278,271 ,0,0,0 ,180,183,182 }, {271,278,272 ,0,0,0 ,182,183,184 },
		{278,277,272 ,0,0,0 ,183,185,184 }, {272,277,273 ,0,0,0 ,184,185,186 },
		{277,276,273 ,0,0,0 ,185,187,186 }, {273,276,274 ,0,0,0 ,186,187,188 },
		{276,275,274 ,0,0,0 ,187,189,188 }, {274,275,293 ,0,0,0 ,188,189,190 },
		{275,292,293 ,0,0,0 ,189,191,190 }, {293,292,281 ,0,0,0 ,190,191,192 },
		{292,291,281 ,0,0,0 ,191,193,192 }, {281,291,282 ,0,0,0 ,192,193,194 },
		{291,290,282 ,0,0,0 ,193,195,194 }, {282,290,283 ,0,0,0 ,194,195,196 },
		{290,289,283 ,0,0,0 ,195,197,196 }, {283,289,284 ,0,0,0 ,196,197,198 },
		{289,288,284 ,0,0,0 ,197,199,198 }, {284,288,285 ,0,0,0 ,198,199,200 },
		{287,285,288 ,0,0,0 ,201,200,199 }, {286,285,287 ,0,0,0 ,202,200,201 },
		{265,250,249 ,240,241,242 ,203,204,205 }, {264,250,265 ,243,241,240 ,206,204,203 },
		{264,251,250 ,243,244,241 ,206,207,204 }, {263,251,264 ,245,244,243 ,208,207,206 },
		{251,263,252 ,244,245,246 ,207,208,209 }, {252,263,226 ,246,245,247 ,209,208,210 },
		{263,239,226 ,245,248,247 ,208,211,210 }, {226,239,227 ,247,248,249 ,210,211,212 },
		{238,227,239 ,250,249,248 ,213,212,211 }, {228,227,238 ,251,249,250 ,214,212,213 },
		{254,241,252 ,206,252,246 ,215,216,209 }, {254,242,241 ,206,206,252 ,215,217,216 },
		{252,222,254 ,246,206,206 ,209,218,215 }, {252,225,222 ,246,253,206 ,209,219,218 },
		{229,219,227 ,254,255,249 ,220,221,212 }, {229,220,219 ,254,256,255 ,220,222,221 },
		{240,234,238 ,257,258,250 ,223,224,213 }, {240,235,234 ,257,259,258 ,223,225,224 },
		{263,256,267 ,245,229,229 ,208,226,227 }, {263,255,256 ,245,260,229 ,208,228,226 },
		{231,263,267 ,229,245,229 ,229,208,227 }, {231,230,263 ,229,261,245 ,229,230,208 },
		{266,258,265 ,262,263,240 ,231,232,203 }, {266,261,258 ,262,264,263 ,231,233,232 },
		{253,245,250 ,265,266,241 ,234,235,204 }, {253,246,245 ,265,267,266 ,234,236,235 },
		{252,241,251 ,246,252,244 ,209,216,207 }, {226,225,252 ,247,253,246 ,210,219,209 },
		{251,244,250 ,244,268,241 ,207,237,204 }, {251,243,244 ,244,269,268 ,207,238,237 },
		{251,241,243 ,244,252,269 ,207,216,238 }, {250,245,249 ,241,266,242 ,204,235,205 },
		{250,247,253 ,241,265,265 ,204,239,234 }, {250,244,247 ,241,268,265 ,204,237,239 },
		{249,257,265 ,242,270,240 ,205,240,203 }, {249,268,257 ,242,271,270 ,205,241,240 },
		{249,245,268 ,242,266,271 ,205,235,241 }, {265,258,264 ,240,263,243 ,203,232,206 },
		{265,262,266 ,240,272,262 ,203,242,231 }, {265,257,262 ,240,270,272 ,203,240,242 },
		{264,255,263 ,243,260,245 ,206,228,208 }, {264,258,259 ,243,263,273 ,206,232,243 },
		{259,255,264 ,273,260,243 ,243,228,206 }, {263,230,239 ,245,261,248 ,208,230,211 },
		{239,233,238 ,248,274,250 ,211,244,213 }, {239,232,233 ,248,275,274 ,211,245,244 },
		{239,230,232 ,248,261,275 ,211,230,245 }, {238,234,228 ,250,258,251 ,213,224,214 },
		{238,236,240 ,250,276,257 ,213,246,223 }, {238,233,236 ,250,274,276 ,213,244,246 },
		{228,218,227 ,251,277,249 ,214,247,212 }, {228,216,218 ,251,278,277 ,214,248,247 },
		{228,234,216 ,251,258,278 ,214,224,248 }, {227,219,226 ,249,255,247 ,212,221,210 },
		{227,221,229 ,249,279,254 ,212,249,220 }, {227,218,221 ,249,277,279 ,212,247,249 },
		{226,224,225 ,247,280,253 ,210,250,219 }, {226,219,224 ,247,255,280 ,210,221,250 },
		{257,269,262 ,270,281,272 ,240,251,242 }, {257,268,269 ,270,271,281 ,240,241,251 },
		{260,258,261 ,282,263,264 ,252,232,233 }, {260,259,258 ,282,273,263 ,252,243,232 },
		{255,260,256 ,260,282,229 ,228,252,226 }, {255,259,260 ,260,273,282 ,228,243,252 },
		{269,245,246 ,281,266,267 ,251,235,236 }, {269,268,245 ,281,271,266 ,251,241,235 },
		{244,248,247 ,268,283,265 ,237,253,239 }, {244,243,248 ,268,269,283 ,237,238,253 },
		{248,241,242 ,283,252,206 ,253,216,217 }, {248,243,241 ,283,269,252 ,253,238,216 },
		{224,222,225 ,280,206,253 ,250,218,219 }, {224,223,222 ,280,284,206 ,250,254,218 },
		{223,219,220 ,284,255,256 ,254,221,222 }, {223,224,219 ,284,280,255 ,254,250,221 },
		{218,217,221 ,277,285,279 ,247,255,249 }, {218,216,217 ,277,278,285 ,247,248,255 },
		{235,216,234 ,259,278,258 ,225,248,224 }, {235,217,216 ,259,285,278 ,225,255,248 },
		{233,237,236 ,274,286,276 ,244,256,246 }, {233,232,237 ,274,275,286 ,244,245,256 },
		{231,232,230 ,229,275,261 ,229,245,230 }, {231,237,232 ,229,286,275 ,229,256,245 },
		{303,300,302 ,287,288,289 ,257,258,259 }, {303,301,300 ,287,290,288 ,257,260,258 },
		{305,301,303 ,291,290,287 ,261,262,263 }, {305,304,301 ,291,292,290 ,261,264,262 },
		{294,302,300 ,293,289,288 ,265,259,258 }, {294,297,302 ,293,294,289 ,265,266,259 },
		{297,295,296 ,294,295,296 ,266,267,268 }, {297,294,295 ,294,293,295 ,266,265,267 },
		{296,298,299 ,296,297,298 ,268,269,270 }, {296,295,298 ,296,295,297 ,268,267,269 },
		{304,299,298 ,292,298,297 ,264,270,269 }, {304,305,299 ,292,291,298 ,264,261,270 }
	};
	static GLfloat vertices [306][3] = {
	{2.85f,1.995f,0.00235001f},{2.85f,1.95667f,0.391555f},{2.85f,1.84314f,0.765803f},
	{2.85f,1.65878f,1.11071f},{2.85f,1.41068f,1.41303f},{2.85f,1.10836f,1.66113f},
	{2.85f,0.763453f,1.84549f},{2.85f,0.389205f,1.95902f},{2.85f,0.0f,1.99735f},
	{2.85f,-0.389205f,1.95902f},{2.85f,-0.763453f,1.84549f},{2.85f,-1.10836f,1.66113f},
	{2.85f,-1.41068f,1.41303f},{2.85f,-1.65878f,1.11071f},{2.85f,-1.84314f,0.765803f},
	{2.85f,-1.95667f,0.391555f},{2.85f,-1.995f,0.00235001f},{2.85f,-1.95667f,-0.386855f},
	{2.85f,-1.84314f,-0.761104f},{2.85f,-1.65878f,-1.10601f},{2.85f,-1.41068f,-1.40833f},
	{2.85f,-1.10836f,-1.65643f},{2.85f,-0.763453f,-1.84079f},{2.85f,-0.389205f,-1.95432f},
	{2.85f,0.0f,-1.99265f},{2.85f,0.389205f,-1.95432f},{2.85f,0.763453f,-1.84079f},
	{2.85f,1.10836f,-1.65643f},{2.85f,1.41068f,-1.40833f},{2.85f,1.65878f,-1.10601f},
	{2.85f,1.84314f,-0.761104f},{2.85f,1.95667f,-0.386855f},{2.55f,1.995f,0.00235001f},
	{2.55f,1.95667f,0.391555f},{2.55f,1.84314f,0.765803f},{2.55f,1.65878f,1.11071f},
	{2.55f,1.41068f,1.41303f},{2.55f,1.10836f,1.66113f},{2.55f,0.763453f,1.84549f},
	{2.55f,0.389205f,1.95902f},{2.55f,0.0f,1.99735f},{2.55f,-0.389205f,1.95902f},
	{2.55f,-0.763453f,1.84549f},{2.55f,-1.10836f,1.66113f},{2.55f,-1.41068f,1.41303f},
	{2.55f,-1.65878f,1.11071f},{2.55f,-1.84314f,0.765803f},{2.55f,-1.95667f,0.391555f},
	{2.55f,-1.995f,0.00235001f},{2.55f,-1.95667f,-0.386855f},{2.55f,-1.84314f,-0.761104f},
	{2.55f,-1.65878f,-1.10601f},{2.55f,-1.41068f,-1.40833f},{2.55f,-1.10836f,-1.65643f},
	{2.55f,-0.763453f,-1.84079f},{2.55f,-0.389205f,-1.95432f},{2.55f,0.0f,-1.99265f},
	{2.55f,0.389205f,-1.95432f},{2.55f,0.763453f,-1.84079f},{2.55f,1.10836f,-1.65643f},
	{2.55f,1.41068f,-1.40833f},{2.55f,1.65878f,-1.10601f},{2.55f,1.84314f,-0.761104f},
	{2.55f,1.95667f,-0.386855f},{2.82374f,0.0f,1.99735f},{2.82374f,-0.389205f,1.95902f},
	{2.57626f,0.0f,1.99735f},{2.57626f,-0.389205f,1.95902f},{2.82374f,-0.763453f,1.84549f},
	{2.57626f,-0.763453f,1.84549f},{2.82374f,-1.10836f,1.66113f},{2.57626f,-1.10836f,1.66113f},
	{2.82374f,-1.41068f,1.41303f},{2.57626f,-1.41068f,1.41303f},{2.82374f,-1.65878f,1.11071f},
	{2.57626f,-1.65878f,1.11071f},{2.82374f,-1.84314f,0.765803f},{2.57626f,-1.84314f,0.765803f},
	{2.82374f,-1.95667f,0.391555f},{2.57626f,-1.95667f,0.391555f},{2.82374f,-1.995f,0.00235001f},
	{2.57626f,-1.995f,0.00235001f},{2.82374f,-1.95667f,-0.386855f},{2.57626f,-1.95667f,-0.386855f},
	{2.82374f,-1.84314f,-0.761104f},{2.57626f,-1.84314f,-0.761104f},{2.82374f,-1.65878f,-1.10601f},
	{2.57626f,-1.65878f,-1.10601f},{2.82374f,-1.41068f,-1.40833f},{2.57626f,-1.41068f,-1.40833f},
	{2.82374f,-1.10836f,-1.65643f},{2.57626f,-1.10836f,-1.65643f},{2.82374f,-0.763453f,-1.84079f},
	{2.57626f,-0.763453f,-1.84079f},{2.82374f,-0.389205f,-1.95432f},{2.57626f,-0.389205f,-1.95432f},
	{2.82374f,0.0f,-1.99265f},{2.57626f,0.0f,-1.99265f},{2.82374f,0.389205f,-1.95432f},
	{2.57626f,0.389205f,-1.95432f},{2.82374f,0.763453f,-1.84079f},{2.57626f,0.763453f,-1.84079f},
	{2.82374f,1.10836f,-1.65643f},{2.57626f,1.10836f,-1.65643f},{2.82374f,1.41068f,-1.40833f},
	{2.57626f,1.41068f,-1.40833f},{2.82374f,1.65878f,-1.10601f},{2.57626f,1.65878f,-1.10601f},
	{2.82374f,1.84314f,-0.761104f},{2.57626f,1.84314f,-0.761104f},{2.82374f,1.95667f,-0.386855f},
	{2.57626f,1.95667f,-0.386855f},{2.82374f,1.995f,0.00235001f},{2.57626f,1.995f,0.00235001f},
	{2.82374f,1.95667f,0.391555f},{2.57626f,1.95667f,0.391555f},{2.82374f,1.84314f,0.765803f},
	{2.57626f,1.84314f,0.765803f},{2.82374f,1.65878f,1.11071f},{2.57626f,1.65878f,1.11071f},
	{2.82374f,1.41068f,1.41303f},{2.57626f,1.41068f,1.41303f},{2.82374f,1.10836f,1.66113f},
	{2.57626f,1.10836f,1.66113f},{2.82374f,0.763453f,1.84549f},{2.57626f,0.763453f,1.84549f},
	{2.82374f,0.389205f,1.95902f},{2.57626f,0.389205f,1.95902f},{2.76228f,0.412558f,-2.07172f},
	{2.76228f,0.809261f,-1.95138f},{2.63772f,0.412558f,-2.07172f},{2.63772f,0.809261f,-1.95138f},
	{2.76228f,1.17486f,-1.75596f},{2.63772f,1.17486f,-1.75596f},{2.76228f,1.49532f,-1.49297f},
	{2.63772f,1.49532f,-1.49297f},{2.76228f,1.75831f,-1.17251f},{2.63772f,1.75831f,-1.17251f},
	{2.76228f,1.95373f,-0.806911f},{2.63772f,1.95373f,-0.806911f},{2.76228f,2.07407f,-0.410208f},
	{2.63772f,2.07407f,-0.410208f},{2.76228f,2.1147f,0.00235001f},{2.63772f,2.1147f,0.00235001f},
	{2.76228f,2.07407f,0.414908f},{2.63772f,2.07407f,0.414908f},{2.76228f,1.95373f,0.81161f},
	{2.63772f,1.95373f,0.81161f},{2.76228f,1.75831f,1.17721f},{2.63772f,1.75831f,1.17721f},
	{2.76228f,1.49532f,1.49767f},{2.63772f,1.49532f,1.49767f},{2.76228f,1.17486f,1.76066f},
	{2.63772f,1.17486f,1.76066f},{2.76228f,0.809261f,1.95608f},{2.63772f,0.809261f,1.95608f},
	{2.76228f,0.412558f,2.07642f},{2.63772f,0.412558f,2.07642f},{2.76228f,0.0f,2.11705f},
	{2.63772f,0.0f,2.11705f},{2.76228f,-0.412558f,2.07642f},{2.63772f,-0.412558f,2.07642f},
	{2.76228f,-0.809261f,1.95608f},{2.63772f,-0.809261f,1.95608f},{2.76228f,-1.17486f,1.76066f},
	{2.63772f,-1.17486f,1.76066f},{2.76228f,-1.49532f,1.49767f},{2.63772f,-1.49532f,1.49767f},
	{2.76228f,-1.75831f,1.17721f},{2.63772f,-1.75831f,1.17721f},{2.76228f,-1.95373f,0.81161f},
	{2.63772f,-1.95373f,0.81161f},{2.76228f,-2.07407f,0.414908f},{2.63772f,-2.07407f,0.414908f},
	{2.76228f,-2.1147f,0.00235001f},{2.63772f,-2.1147f,0.00235001f},{2.76228f,-2.07407f,-0.410208f},
	{2.63772f,-2.07407f,-0.410208f},{2.76228f,-1.95373f,-0.806911f},{2.63772f,-1.95373f,-0.806911f},
	{2.76228f,-1.75831f,-1.17251f},{2.63772f,-1.75831f,-1.17251f},{2.76228f,-1.49532f,-1.49297f},
	{2.63772f,-1.49532f,-1.49297f},{2.76228f,-1.17486f,-1.75596f},{2.63772f,-1.17486f,-1.75596f},
	{2.76228f,-0.809261f,-1.95138f},{2.63772f,-0.809261f,-1.95138f},{2.76228f,-0.412558f,-2.07172f},
	{2.63772f,-0.412558f,-2.07172f},{2.76228f,0.0f,-2.11235f},{2.63772f,0.0f,-2.11235f},
	{2.85f,0.65f,0.00235001f},{2.85f,0.627852f,0.170582f},{2.85f,0.562917f,0.32735f},
	{2.85f,0.459619f,0.461969f},{2.85f,0.325f,0.565267f},{2.85f,0.168232f,0.630202f},
	{2.85f,0.0f,0.65235f},{2.85f,-0.168232f,0.630202f},{2.85f,-0.325f,0.565267f},
	{2.85f,-0.459619f,0.461969f},{2.85f,-0.562917f,0.32735f},{2.85f,-0.627852f,0.170582f},
	{2.85f,-0.65f,0.00235001f},{2.85f,-0.627852f,-0.165882f},{2.85f,-0.562917f,-0.32265f},
	{2.85f,-0.459619f,-0.457269f},{2.85f,-0.325f,-0.560567f},{2.85f,-0.168232f,-0.625502f},
	{2.85f,0.0f,-0.64765f},{2.85f,0.168232f,-0.625502f},{2.85f,0.325f,-0.560567f},
	{2.85f,0.459619f,-0.457269f},{2.85f,0.562917f,-0.32265f},{2.85f,0.627852f,-0.165882f},
	{3.59748f,0.46188f,0.00235001f},{3.34126f,0.46188f,0.00235001f},{3.61415f,0.403659f,0.103191f},
	{3.61415f,0.289161f,0.301509f},{3.34126f,0.289161f,0.301509f},{3.34126f,0.403659f,0.103191f},
	{3.34126f,0.114655f,0.40235f},{3.34126f,0.23094f,0.40235f},{3.59748f,0.23094f,0.40235f},
	{3.61414f,0.114655f,0.40235f},{3.62f,0.200001f,0.348759f},{3.62f,0.34641f,0.20235f},
	{3.62f,0.4f,0.00235001f},{3.34126f,0.34641f,0.20235f},{3.6141f,0.11502f,-0.39765f},
	{3.34126f,0.11502f,-0.39765f},{3.59748f,0.23094f,-0.39765f},{3.61415f,0.289161f,-0.296809f},
	{3.61415f,0.403659f,-0.0984914f},{3.34126f,0.403659f,-0.0984914f},{3.34126f,0.289161f,-0.296809f},
	{3.34126f,0.23094f,-0.39765f},{3.62f,0.34641f,-0.19765f},{3.62f,0.200001f,-0.344059f},
	{3.34126f,0.34641f,-0.19765f},{3.6141f,-0.11502f,0.40235f},{3.34126f,-0.11502f,0.40235f},
	{3.59748f,-0.23094f,0.40235f},{3.61415f,-0.289161f,0.301509f},{3.61415f,-0.403659f,0.103191f},
	{3.34126f,-0.403659f,0.103191f},{3.34126f,-0.289161f,0.301509f},{3.34126f,-0.23094f,0.40235f},
	{3.62f,-0.4f,0.00235001f},{3.62f,-0.34641f,0.20235f},{3.62f,-0.200001f,0.348759f},
	{3.62f,0.0f,0.40235f},{3.34126f,-0.34641f,0.20235f},{3.34126f,0.0f,0.40235f},
	{3.61414f,-0.114655f,-0.39765f},{3.34126f,-0.114655f,-0.39765f},{3.61415f,-0.403659f,-0.0984914f},
	{3.61415f,-0.289161f,-0.296809f},{3.59748f,-0.23094f,-0.39765f},{3.34126f,-0.23094f,-0.39765f},
	{3.34126f,-0.289161f,-0.296809f},{3.34126f,-0.403659f,-0.0984914f},{3.62f,0.0f,-0.39765f},
	{3.62f,-0.200001f,-0.344059f},{3.62f,-0.34641f,-0.19765f},{3.34126f,-0.34641f,-0.19765f},
	{3.34126f,0.0f,-0.39765f},{3.59748f,-0.46188f,0.00235001f},{3.34126f,-0.46188f,0.00235001f},
	{3.35f,0.627852f,-0.165882f},{3.35f,0.562917f,-0.32265f},{3.35f,0.459619f,-0.457269f},
	{3.35f,0.325f,-0.560567f},{3.35f,0.168232f,-0.625502f},{3.35f,0.168232f,0.630202f},
	{3.35f,0.325f,0.565267f},{3.35f,0.459619f,0.461969f},{3.35f,0.562917f,0.32735f},
	{3.35f,0.627852f,0.170582f},{3.35f,0.65f,0.00235001f},{3.35f,-0.168232f,-0.625502f},
	{3.35f,-0.325f,-0.560567f},{3.35f,-0.459619f,-0.457269f},{3.35f,-0.562917f,-0.32265f},
	{3.35f,-0.627852f,-0.165882f},{3.35f,-0.65f,0.00235001f},{3.35f,-0.627852f,0.170582f},
	{3.35f,-0.562917f,0.32735f},{3.35f,-0.459619f,0.461969f},{3.35f,-0.325f,0.565267f},
	{3.35f,-0.168232f,0.630202f},{3.35f,0.0f,0.65235f},{3.35f,0.0f,-0.64765f},
	{2.58f,0.15002f,0.262136f},{2.58f,0.3f,0.00235001f},{2.38f,0.3f,0.00235001f},
	{2.38f,0.149976f,0.262164f},{2.58f,0.15002f,-0.257436f},{2.38f,0.149976f,-0.257464f},
	{2.58f,-0.15002f,0.262136f},{2.58f,-0.3f,0.00235001f},{2.38f,-0.149976f,0.262164f},
	{2.38f,-0.3f,0.00235001f},{2.58f,-0.15002f,-0.257436f},{2.38f,-0.149976f,-0.257464f}
	};
	static GLfloat normals [299][3] = {
	{1.0f,0.0f,0.0f},{-1.0f,0.0f,0.0f},{-0.522152f,-0.0103954f,-0.852789f},
	{-0.522152f,0.176567f,-0.834375f},{-0.522152f,0.0103953f,-0.852789f},{-0.522152f,0.156176f,-0.838431f},
	{0.522151f,0.156176f,-0.838431f},{0.522151f,-0.0103953f,-0.85279f},{0.522151f,0.176567f,-0.834375f},
	{0.522151f,0.0103953f,-0.85279f},{-0.522152f,-0.176567f,-0.834375f},{-0.522152f,-0.156176f,-0.838431f},
	{0.522151f,-0.176567f,-0.834375f},{0.522151f,-0.156176f,-0.838431f},{-0.522152f,-0.335952f,-0.783896f},
	{-0.522152f,-0.316744f,-0.791853f},{0.522151f,-0.335952f,-0.783897f},{0.522151f,-0.316744f,-0.791853f},
	{-0.522152f,-0.482428f,-0.703293f},{-0.522152f,-0.465141f,-0.714844f},{0.522151f,-0.482428f,-0.703293f},
	{0.522151f,-0.465141f,-0.714844f},{-0.522152f,-0.610364f,-0.595663f},{-0.522152f,-0.595663f,-0.610364f},
	{0.522151f,-0.610364f,-0.595663f},{0.522151f,-0.595663f,-0.610364f},{-0.522152f,-0.714844f,-0.465141f},
	{-0.522152f,-0.703293f,-0.482428f},{0.522151f,-0.714844f,-0.465141f},{0.522151f,-0.703293f,-0.482428f},
	{-0.522152f,-0.791853f,-0.316744f},{-0.522152f,-0.783897f,-0.335952f},{0.522151f,-0.791853f,-0.316744f},
	{0.522151f,-0.783897f,-0.335952f},{-0.522152f,-0.838431f,-0.156175f},{-0.522152f,-0.834375f,-0.176566f},
	{0.522151f,-0.838432f,-0.156175f},{0.522151f,-0.834376f,-0.176566f},{-0.522152f,-0.852789f,0.0103953f},
	{-0.522152f,-0.852789f,-0.0103952f},{0.522151f,-0.85279f,0.0103952f},{0.522151f,-0.85279f,-0.0103952f},
	{-0.522152f,-0.834375f,0.176566f},{-0.522152f,-0.838431f,0.156175f},{0.522151f,-0.834376f,0.176566f},
	{0.522151f,-0.838432f,0.156175f},{-0.522152f,-0.783897f,0.335952f},{-0.522152f,-0.791853f,0.316744f},
	{0.522151f,-0.783897f,0.335952f},{0.522151f,-0.791853f,0.316744f},{-0.522152f,-0.703293f,0.482428f},
	{-0.522152f,-0.714844f,0.465141f},{0.522151f,-0.703293f,0.482428f},{0.522151f,-0.714844f,0.465141f},
	{-0.522152f,-0.595662f,0.610364f},{-0.522152f,-0.610363f,0.595663f},{0.522151f,-0.595663f,0.610364f},
	{0.522151f,-0.610364f,0.595663f},{-0.522152f,-0.465141f,0.714844f},{-0.522152f,-0.482428f,0.703293f},
	{0.522151f,-0.465141f,0.714844f},{0.522151f,-0.482428f,0.703294f},{-0.522152f,-0.316744f,0.791853f},
	{-0.522151f,-0.335952f,0.783897f},{0.522151f,-0.316745f,0.791853f},{0.522151f,-0.335953f,0.783897f},
	{-0.522152f,-0.156175f,0.838431f},{-0.522152f,-0.176567f,0.834375f},{0.522151f,-0.156176f,0.838432f},
	{0.522151f,-0.176566f,0.834376f},{-0.522152f,0.0103952f,0.852789f},{-0.522152f,-0.0103953f,0.852789f},
	{0.522151f,0.0103953f,0.85279f},{0.522151f,-0.0103952f,0.85279f},{-0.522152f,0.176566f,0.834375f},
	{-0.522152f,0.156176f,0.838431f},{0.522151f,0.176567f,0.834375f},{0.522151f,0.156175f,0.838432f},
	{-0.522151f,0.335952f,0.783897f},{-0.522151f,0.316744f,0.791853f},{0.522151f,0.335952f,0.783897f},
	{0.522151f,0.316745f,0.791853f},{-0.522152f,0.482428f,0.703293f},{-0.522152f,0.465141f,0.714844f},
	{0.522151f,0.482428f,0.703293f},{0.522151f,0.465141f,0.714844f},{-0.522152f,0.610364f,0.595663f},
	{-0.522152f,0.595662f,0.610364f},{0.522151f,0.610364f,0.595663f},{0.522151f,0.595663f,0.610364f},
	{-0.522152f,0.714844f,0.465141f},{-0.522152f,0.703293f,0.482428f},{0.522151f,0.714844f,0.465141f},
	{0.522151f,0.703293f,0.482428f},{-0.522152f,0.791853f,0.316744f},{-0.522152f,0.783897f,0.335952f},
	{0.522151f,0.791853f,0.316744f},{0.522151f,0.783897f,0.335952f},{-0.522152f,0.838431f,0.156175f},
	{-0.522152f,0.834375f,0.176566f},{0.522151f,0.838432f,0.156175f},{0.522151f,0.834376f,0.176566f},
	{-0.522152f,0.852789f,-0.0103953f},{-0.522152f,0.852789f,0.0103952f},{0.522151f,0.85279f,-0.0103952f},
	{0.522151f,0.85279f,0.0103953f},{-0.522152f,0.834375f,-0.176566f},{-0.522152f,0.838431f,-0.156175f},
	{0.522151f,0.834376f,-0.176566f},{0.522151f,0.838432f,-0.156175f},{-0.522152f,0.783897f,-0.335952f},
	{-0.522152f,0.791853f,-0.316744f},{0.522151f,0.783897f,-0.335952f},{0.522151f,0.791853f,-0.316744f},
	{-0.522152f,0.703293f,-0.482428f},{-0.522152f,0.714844f,-0.465141f},{0.522151f,0.703293f,-0.482428f},
	{0.522151f,0.714844f,-0.465141f},{-0.522152f,0.595663f,-0.610364f},{-0.522152f,0.610364f,-0.595663f},
	{0.522151f,0.595663f,-0.610364f},{0.522151f,0.610364f,-0.595663f},{-0.522152f,0.465141f,-0.714844f},
	{-0.522152f,0.482428f,-0.703293f},{0.522151f,0.465141f,-0.714844f},{0.522151f,0.482428f,-0.703293f},
	{-0.522152f,0.316744f,-0.791853f},{-0.522152f,0.335952f,-0.783896f},{0.522151f,0.316745f,-0.791853f},
	{0.522151f,0.335952f,-0.783897f},{0.0f,0.162803f,0.986659f},{0.0f,-0.0328127f,0.999461f},
	{0.0f,0.0328127f,0.999461f},{0.0f,0.227167f,0.973856f},{0.0f,0.352162f,0.935939f},
	{0.0f,0.412792f,0.910825f},{0.0f,0.527988f,0.849252f},{0.0f,0.582554f,0.812792f},
	{0.0f,0.683524f,0.729928f},{0.0f,0.729928f,0.683524f},{0.0f,0.812792f,0.582554f},
	{0.0f,0.849252f,0.527988f},{0.0f,0.910825f,0.412792f},{0.0f,0.935939f,0.352162f},
	{0.0f,0.973856f,0.227168f},{0.0f,0.986659f,0.162803f},{0.0f,0.999461f,0.0328127f},
	{0.0f,0.999461f,-0.0328127f},{0.0f,0.986659f,-0.162803f},{0.0f,0.973856f,-0.227167f},
	{0.0f,0.935939f,-0.352162f},{0.0f,0.910825f,-0.412792f},{0.0f,0.849252f,-0.527988f},
	{0.0f,0.812792f,-0.582554f},{0.0f,0.729928f,-0.683524f},{0.0f,0.683524f,-0.729928f},
	{0.0f,0.582554f,-0.812792f},{0.0f,0.527988f,-0.849252f},{0.0f,0.412792f,-0.910825f},
	{0.0f,0.352162f,-0.935939f},{0.0f,0.227168f,-0.973856f},{0.0f,0.162803f,-0.986659f},
	{0.0f,0.0328129f,-0.999462f},{0.0f,-0.0328129f,-0.999462f},{0.0f,-0.162803f,-0.986659f},
	{0.0f,-0.227168f,-0.973856f},{0.0f,-0.352162f,-0.935939f},{0.0f,-0.412792f,-0.910825f},
	{0.0f,-0.527988f,-0.849252f},{0.0f,-0.582554f,-0.812792f},{0.0f,-0.683524f,-0.729928f},
	{0.0f,-0.729928f,-0.683524f},{0.0f,-0.812792f,-0.582554f},{0.0f,-0.849252f,-0.527988f},
	{0.0f,-0.910825f,-0.412792f},{0.0f,-0.935939f,-0.352162f},{0.0f,-0.973856f,-0.227167f},
	{0.0f,-0.986659f,-0.162803f},{0.0f,-0.999461f,-0.0328127f},{0.0f,-0.999461f,0.0328127f},
	{0.0f,-0.986659f,0.162803f},{0.0f,-0.973856f,0.227168f},{0.0f,-0.935939f,0.352162f},
	{0.0f,-0.910825f,0.412792f},{0.0f,-0.849252f,0.527988f},{0.0f,-0.812792f,0.582554f},
	{0.0f,-0.729928f,0.683524f},{0.0f,-0.683524f,0.729928f},{0.0f,-0.582554f,0.812792f},
	{0.0f,-0.527988f,0.849252f},{0.0f,-0.412792f,0.910825f},{0.0f,-0.352162f,0.935939f},
	{0.0f,-0.227167f,0.973856f},{0.0f,-0.162803f,0.986659f},{0.0f,0.976344f,0.216222f},
	{0.0f,0.999038f,0.043842f},{0.0f,0.999038f,-0.0438419f},{0.0f,0.95365f,0.300918f},
	{0.0f,0.887114f,0.461551f},{0.0f,0.843272f,0.537488f},{0.0f,0.737428f,0.675426f},
	{0.0f,0.675426f,0.737428f},{0.0f,0.537488f,0.843271f},{0.0f,0.461552f,0.887113f},
	{0.0f,0.300918f,0.95365f},{0.0f,0.216221f,0.976344f},{0.0f,0.0f,1.0f},
	{0.0f,-0.216221f,0.976344f},{0.0f,-0.300918f,0.95365f},{0.0f,-0.461552f,0.887113f},
	{0.0f,-0.537488f,0.843271f},{0.0f,-0.675426f,0.737428f},{0.0f,-0.737428f,0.675426f},
	{0.0f,-0.843272f,0.537488f},{0.0f,-0.887114f,0.461551f},{0.0f,-0.95365f,0.300918f},
	{0.0f,-0.976344f,0.216222f},{0.0f,-0.999038f,0.043842f},{0.0f,-0.999038f,-0.0438419f},
	{0.0f,-0.976344f,-0.216222f},{0.0f,-0.95365f,-0.300918f},{0.0f,-0.887114f,-0.461551f},
	{0.0f,-0.843272f,-0.537487f},{0.0f,-0.737428f,-0.675426f},{0.0f,-0.675426f,-0.737428f},
	{0.0f,-0.537488f,-0.843272f},{0.0f,-0.461551f,-0.887114f},{0.0f,-0.300918f,-0.95365f},
	{0.0f,-0.216222f,-0.976344f},{0.0f,0.0f,-1.0f},{0.0f,0.216222f,-0.976344f},
	{0.0f,0.300918f,-0.95365f},{0.0f,0.461551f,-0.887114f},{0.0f,0.537488f,-0.843272f},
	{0.0f,0.675426f,-0.737428f},{0.0f,0.737428f,-0.675426f},{0.0f,0.843272f,-0.537487f},
	{0.0f,0.887114f,-0.461551f},{0.0f,0.95365f,-0.300918f},{0.0f,0.976344f,-0.216222f},
	{0.761363f,-0.561466f,-0.324163f},{0.826954f,-0.486939f,0.281135f},{0.976958f,-0.213434f,4.51181e-009f},
	{0.988256f,-0.0764038f,-0.132333f},{0.988244f,-0.0764439f,0.132403f},{0.806224f,2.00407e-005f,-0.59161f},
	{0.761252f,-2.8475e-005f,0.648456f},{0.988256f,0.0764039f,0.132333f},{0.988244f,0.0764438f,-0.132403f},
	{0.826954f,0.486939f,0.281135f},{0.761363f,0.561466f,-0.324163f},{0.976958f,0.213434f,4.51181e-009f},
	{0.391787f,-0.0377437f,0.919282f},{0.607411f,0.058426f,0.792236f},{0.0f,0.866025f,0.500001f},
	{0.391863f,0.777262f,0.492248f},{0.0f,0.866025f,0.5f},{0.0f,0.866025f,-0.5f},
	{0.480022f,0.781746f,-0.398061f},{0.0f,0.866026f,-0.5f},{0.479994f,-0.0461699f,-0.876056f},
	{0.607313f,0.0585069f,-0.792305f},{0.0f,-0.866025f,-0.500001f},{0.391863f,-0.777262f,-0.492247f},
	{0.0f,-0.866025f,-0.5f},{0.0f,-0.866025f,0.5f},{0.391863f,-0.81493f,0.427005f},
	{0.0f,-0.866025f,0.5f},{0.480022f,-0.735604f,0.477982f},{0.61374f,-0.394815f,0.6837f},
	{0.480022f,-0.781746f,-0.39806f},{0.613739f,-0.789509f,2.92229e-008f},{0.0f,-0.866025f,-0.5f},
	{0.613739f,-0.394774f,-0.683724f},{0.480022f,0.735604f,-0.477981f},{0.49237f,0.316738f,-0.810709f},
	{0.0f,0.866025f,-0.5f},{0.480022f,0.781746f,0.398061f},{0.492365f,0.860458f,-0.131107f},
	{0.0f,0.866025f,0.5f},{0.492366f,0.316703f,0.810725f},{0.0f,-1.0f,5.16191e-008f},
	{0.0f,-0.5f,-0.866025f},{0.0f,-0.5f,0.866025f},{0.0f,0.654654f,0.755929f},
	{0.0f,0.981981f,0.188982f},{0.0f,0.654654f,-0.755929f},{-4.57582e-005f,-0.981981f,0.188978f},
	{5.77637e-006f,-0.654644f,0.755937f},{5.73094e-005f,-0.327311f,0.944917f},{-4.57643e-005f,-0.981977f,-0.189001f},
	{5.76943e-006f,-0.654644f,-0.755937f},{5.73036e-005f,-0.327333f,-0.944909f},{5.73036e-005f,0.327333f,0.944909f},
	{5.76944e-006f,0.654644f,0.755937f},{-4.57643e-005f,0.981977f,0.189001f},{-4.57582e-005f,0.981981f,-0.188978f},
	{5.77637e-006f,0.654644f,-0.755937f},{5.73094e-005f,0.327311f,-0.944917f}
	};
	static GLfloat textures [271][2] = {
	{0.98036f,0.192f},{0.977321f,0.222856f},{0.977321f,0.161144f},
	{0.968321f,0.131475f},{0.968321f,0.252525f},{0.953706f,0.104131f},
	{0.953706f,0.279869f},{0.934036f,0.0801637f},{0.934036f,0.303836f},
	{0.910069f,0.0604944f},{0.910069f,0.323506f},{0.882725f,0.0458788f},
	{0.882725f,0.338121f},{0.853056f,0.0368786f},{0.853056f,0.347121f},
	{0.8222f,0.0338396f},{0.8222f,0.35016f},{0.791345f,0.0368786f},
	{0.791345f,0.347121f},{0.761675f,0.0458788f},{0.761675f,0.338121f},
	{0.734331f,0.0604944f},{0.734331f,0.323506f},{0.710364f,0.0801637f},
	{0.710364f,0.303836f},{0.690694f,0.104131f},{0.690694f,0.279869f},
	{0.676079f,0.131475f},{0.676079f,0.252525f},{0.667079f,0.161144f},
	{0.667079f,0.222856f},{0.66404f,0.192f},{0.977321f,0.161144f},
	{0.856442f,0.0189499f},{0.8221f,0.0155675f},{0.854907f,0.0275713f},
	{0.8222f,0.02435f},{0.853056f,0.0368786f},{0.8222f,0.0338396f},
	{0.787758f,0.0189499f},{0.789493f,0.0275713f},{0.791345f,0.0368786f},
	{0.754735f,0.0289671f},{0.758043f,0.0371116f},{0.761675f,0.0458788f},
	{0.724302f,0.0452343f},{0.729059f,0.0526041f},{0.734331f,0.0604944f},
	{0.697626f,0.0671262f},{0.703654f,0.0734535f},{0.710364f,0.0801637f},
	{0.675734f,0.0938016f},{0.682804f,0.0988587f},{0.690694f,0.104131f},
	{0.659467f,0.124235f},{0.667312f,0.127843f},{0.676079f,0.131475f},
	{0.64945f,0.157258f},{0.657771f,0.159293f},{0.667079f,0.161144f},
	{0.646067f,0.1916f},{0.65455f,0.192f},{0.66404f,0.192f},
	{0.64945f,0.225942f},{0.657771f,0.224707f},{0.667079f,0.222856f},
	{0.659467f,0.258965f},{0.667312f,0.256157f},{0.676079f,0.252525f},
	{0.675734f,0.289398f},{0.682804f,0.285141f},{0.690694f,0.279869f},
	{0.697626f,0.316074f},{0.703654f,0.310547f},{0.710364f,0.303836f},
	{0.724302f,0.337966f},{0.729059f,0.331396f},{0.734331f,0.323506f},
	{0.754735f,0.354233f},{0.758043f,0.346888f},{0.761675f,0.338121f},
	{0.787758f,0.36425f},{0.789493f,0.356429f},{0.791345f,0.347121f},
	{0.8221f,0.367633f},{0.8222f,0.35965f},{0.853056f,0.347121f},
	{0.856442f,0.36425f},{0.854907f,0.356429f},{0.853056f,0.347121f},
	{0.889465f,0.354233f},{0.886357f,0.346888f},{0.882725f,0.338121f},
	{0.919898f,0.337966f},{0.915341f,0.331396f},{0.910069f,0.323506f},
	{0.946574f,0.316074f},{0.940746f,0.310547f},{0.934036f,0.303836f},
	{0.968466f,0.289398f},{0.961596f,0.285141f},{0.953706f,0.279869f},
	{0.984733f,0.258965f},{0.977088f,0.256157f},{0.968321f,0.252525f},
	{0.99475f,0.225942f},{0.986629f,0.224707f},{0.977321f,0.222856f},
	{0.998133f,0.1916f},{0.98985f,0.192f},{0.98036f,0.192f},
	{0.99475f,0.157258f},{0.986629f,0.159293f},{0.977321f,0.161144f},
	{0.984733f,0.124235f},{0.977088f,0.127843f},{0.968321f,0.131475f},
	{0.968466f,0.0938016f},{0.961596f,0.0988587f},{0.953706f,0.104131f},
	{0.946574f,0.0671262f},{0.940746f,0.0734535f},{0.934036f,0.0801637f},
	{0.919898f,0.0452343f},{0.915341f,0.0526041f},{0.910069f,0.0604944f},
	{0.889465f,0.0289671f},{0.886357f,0.0371116f},{0.882725f,0.0458788f},
	{0.255124f,0.857001f},{0.2535f,0.853948f},{0.2535f,0.857001f},
	{0.255124f,0.853948f},{0.256749f,0.857001f},{0.256749f,0.853948f},
	{0.258373f,0.857001f},{0.258373f,0.853948f},{0.259998f,0.857001f},
	{0.259998f,0.853948f},{0.261622f,0.857001f},{0.261622f,0.853948f},
	{0.263247f,0.857001f},{0.263247f,0.853948f},{0.264871f,0.853948f},
	{0.264871f,0.857001f},{0.266495f,0.853948f},{0.266495f,0.857001f},
	{0.26812f,0.853948f},{0.26812f,0.857001f},{0.269744f,0.853948f},
	{0.269744f,0.857001f},{0.271368f,0.853948f},{0.271368f,0.857001f},
	{0.272993f,0.853948f},{0.272993f,0.857001f},{0.235632f,0.853948f},
	{0.234007f,0.857001f},{0.235632f,0.857001f},{0.234007f,0.853948f},
	{0.237256f,0.853948f},{0.237256f,0.857001f},{0.23888f,0.853948f},
	{0.23888f,0.857001f},{0.240505f,0.853948f},{0.240505f,0.857001f},
	{0.242129f,0.853948f},{0.242129f,0.857001f},{0.243754f,0.853948f},
	{0.243754f,0.857001f},{0.245378f,0.857001f},{0.245378f,0.853948f},
	{0.247002f,0.857001f},{0.247002f,0.853948f},{0.248627f,0.857001f},
	{0.248627f,0.853948f},{0.250251f,0.857001f},{0.250251f,0.853948f},
	{0.251876f,0.857001f},{0.251876f,0.853948f},{0.270178f,0.872f},
	{0.269892f,0.874168f},{0.269892f,0.869832f},{0.269055f,0.867811f},
	{0.269055f,0.876189f},{0.267724f,0.866076f},{0.267724f,0.877924f},
	{0.265989f,0.864745f},{0.265989f,0.879255f},{0.263968f,0.863908f},
	{0.263968f,0.880092f},{0.2618f,0.863622f},{0.2618f,0.880378f},
	{0.259632f,0.863908f},{0.259632f,0.880092f},{0.257611f,0.864745f},
	{0.257611f,0.879255f},{0.255876f,0.866076f},{0.255876f,0.877924f},
	{0.254545f,0.867811f},{0.254545f,0.876189f},{0.253708f,0.869832f},
	{0.253708f,0.874168f},{0.253422f,0.872f},{0.578053f,0.0351135f},
	{0.578053f,0.0868865f},{0.571099f,0.061f},{0.597049f,0.0161633f},
	{0.597049f,0.105837f},{0.623f,0.00922698f},{0.623f,0.112773f},
	{0.64895f,0.105837f},{0.64895f,0.0161633f},{0.667947f,0.0868865f},
	{0.667947f,0.0351135f},{0.674901f,0.061f},{0.623f,0.110471f},
	{0.608076f,0.112773f},{0.60874f,0.110471f},{0.637215f,0.110471f},
	{0.637877f,0.112773f},{0.665949f,0.0857356f},{0.660519f,0.0997209f},
	{0.658851f,0.0979993f},{0.665949f,0.0362644f},{0.675375f,0.0479479f},
	{0.673047f,0.0485281f},{0.608785f,0.0115287f},{0.623f,0.0115287f},
	{0.608123f,0.00922698f},{0.63726f,0.0115287f},{0.637924f,0.00922698f},
	{0.580051f,0.0362644f},{0.585481f,0.0222791f},{0.587149f,0.0240006f},
	{0.580051f,0.0857356f},{0.570625f,0.0740522f},{0.572953f,0.0734719f},
	{0.585481f,0.0997209f},{0.593035f,0.112773f},{0.587149f,0.0979993f},
	{0.570625f,0.0479479f},{0.56307f,0.061f},{0.572953f,0.0485281f},
	{0.593035f,0.00922698f},{0.660519f,0.0222791f},{0.652965f,0.00922698f},
	{0.658851f,0.0240006f},{0.675375f,0.0740522f},{0.68293f,0.061f},
	{0.673047f,0.0734719f},{0.652965f,0.112773f},{0.565735f,0.061f},
	{0.594368f,0.0115287f},{0.594368f,0.110471f},{0.651632f,0.110471f},
	{0.680265f,0.061f},{0.651632f,0.0115287f},{0.26938f,0.886235f},
	{0.266921f,0.883765f},{0.26692f,0.886235f},{0.26938f,0.883765f},
	{0.25708f,0.886235f},{0.25462f,0.88282f},{0.25462f,0.886235f},
	{0.257079f,0.883765f},{0.26446f,0.883765f},{0.26446f,0.886235f},
	{0.262f,0.883765f},{0.262f,0.886235f},{0.25954f,0.883765f},
	{0.25954f,0.886235f}
	};
	GLint GenEPuckWheelRight()
	{
	unsigned i;
	unsigned j;
	
	GLint lid=glGenLists(1);
	glNewList(lid, GL_COMPILE);
	
		glBegin (GL_TRIANGLES);
		for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
		{
		for(j=0;j<3;j++)
			{
			int vi=face_indicies[i][j];
			int ni=face_indicies[i][j+3];//Normal index
			int ti=face_indicies[i][j+6];//Texture index
			/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
			
			// rotate 90 deg around z
			glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][1],-vertices[vi][0],vertices[vi][2]);
			}
		}
		glEnd ();
	
	glEndList();
	return lid;
	};
}

