
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2008 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://lis.epfl.ch/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// E-puck object file

#include <QtOpenGL>

namespace Enki
{
	// 306 Verticies
	// 269 Texture Coordinates
	// 299 Normals
	// 544 Triangles
	
	static short face_indicies[544][9] = {
	// (unnamed)
		{0,31,1 ,0,0,0 ,0,1,2 }, {1,31,2 ,0,0,0 ,2,1,3 }, {31,30,2 ,0,0,0 ,1,4,3 },
		{2,30,3 ,0,0,0 ,3,4,5 }, {30,29,3 ,0,0,0 ,4,6,5 }, {3,29,4 ,0,0,0 ,5,6,7 },
		{29,28,4 ,0,0,0 ,6,8,7 }, {4,28,5 ,0,0,0 ,7,8,9 }, {28,27,5 ,0,0,0 ,8,10,9 },
		{5,27,6 ,0,0,0 ,9,10,11 }, {27,26,6 ,0,0,0 ,10,12,11 }, {6,26,7 ,0,0,0 ,11,12,13 },
		{26,25,7 ,0,0,0 ,12,14,13 }, {7,25,8 ,0,0,0 ,13,14,15 }, {25,24,8 ,0,0,0 ,14,16,15 },
		{8,24,9 ,0,0,0 ,15,16,17 }, {24,23,9 ,0,0,0 ,16,18,17 }, {9,23,10 ,0,0,0 ,17,18,19 },
		{23,22,10 ,0,0,0 ,18,20,19 }, {10,22,11 ,0,0,0 ,19,20,21 }, {22,21,11 ,0,0,0 ,20,22,21 },
		{11,21,12 ,0,0,0 ,21,22,23 }, {21,20,12 ,0,0,0 ,22,24,23 }, {12,20,13 ,0,0,0 ,23,24,25 },
		{20,19,13 ,0,0,0 ,24,26,25 }, {13,19,14 ,0,0,0 ,25,26,27 }, {19,18,14 ,0,0,0 ,26,28,27 },
		{14,18,15 ,0,0,0 ,27,28,29 }, {17,15,18 ,0,0,0 ,30,29,28 }, {16,15,17 ,0,0,0 ,31,29,30 },
		{32,33,63 ,1,1,1 ,0,2,32 }, {63,33,62 ,1,1,1 ,32,2,4 }, {33,34,62 ,1,1,1 ,2,3,4 },
		{62,34,61 ,1,1,1 ,4,3,6 }, {34,35,61 ,1,1,1 ,3,5,6 }, {61,35,60 ,1,1,1 ,6,5,8 },
		{35,36,60 ,1,1,1 ,5,7,8 }, {60,36,59 ,1,1,1 ,8,7,10 }, {36,37,59 ,1,1,1 ,7,9,10 },
		{59,37,58 ,1,1,1 ,10,9,12 }, {37,38,58 ,1,1,1 ,9,11,12 }, {58,38,57 ,1,1,1 ,12,11,14 },
		{38,39,57 ,1,1,1 ,11,13,14 }, {57,39,56 ,1,1,1 ,14,13,16 }, {39,40,56 ,1,1,1 ,13,15,16 },
		{56,40,55 ,1,1,1 ,16,15,18 }, {40,41,55 ,1,1,1 ,15,17,18 }, {55,41,54 ,1,1,1 ,18,17,20 },
		{41,42,54 ,1,1,1 ,17,19,20 }, {54,42,53 ,1,1,1 ,20,19,22 }, {42,43,53 ,1,1,1 ,19,21,22 },
		{53,43,52 ,1,1,1 ,22,21,24 }, {43,44,52 ,1,1,1 ,21,23,24 }, {52,44,51 ,1,1,1 ,24,23,26 },
		{44,45,51 ,1,1,1 ,23,25,26 }, {51,45,50 ,1,1,1 ,26,25,28 }, {45,46,50 ,1,1,1 ,25,27,28 },
		{50,46,49 ,1,1,1 ,28,27,30 }, {47,49,46 ,1,1,1 ,29,30,27 }, {48,49,47 ,1,1,1 ,31,30,29 },
		{130,97,191 ,2,3,4 ,33,16,34 }, {130,99,97 ,2,5,3 ,33,14,16 },
		{128,191,190 ,6,4,7 ,35,34,36 }, {128,130,191 ,6,2,4 ,35,33,34 },
		{98,190,96 ,8,7,9 ,37,36,38 }, {98,128,190 ,8,6,7 ,37,35,36 },
		{191,95,189 ,4,10,11 ,34,18,39 }, {191,97,95 ,4,3,10 ,34,16,18 },
		{190,189,188 ,7,11,12 ,36,39,40 }, {190,191,189 ,7,4,11 ,36,34,39 },
		{96,188,94 ,9,12,13 ,38,40,41 }, {96,190,188 ,9,7,12 ,38,36,40 },
		{189,93,187 ,11,14,15 ,39,20,42 }, {189,95,93 ,11,10,14 ,39,18,20 },
		{188,187,186 ,12,15,16 ,40,42,43 }, {188,189,187 ,12,11,15 ,40,39,42 },
		{94,186,92 ,13,16,17 ,41,43,44 }, {94,188,186 ,13,12,16 ,41,40,43 },
		{187,91,185 ,15,18,19 ,42,22,45 }, {187,93,91 ,15,14,18 ,42,20,22 },
		{186,185,184 ,16,19,20 ,43,45,46 }, {186,187,185 ,16,15,19 ,43,42,45 },
		{92,184,90 ,17,20,21 ,44,46,47 }, {92,186,184 ,17,16,20 ,44,43,46 },
		{185,89,183 ,19,22,23 ,45,24,48 }, {185,91,89 ,19,18,22 ,45,22,24 },
		{184,183,182 ,20,23,24 ,46,48,49 }, {184,185,183 ,20,19,23 ,46,45,48 },
		{90,182,88 ,21,24,25 ,47,49,50 }, {90,184,182 ,21,20,24 ,47,46,49 },
		{183,87,181 ,23,26,27 ,48,26,51 }, {183,89,87 ,23,22,26 ,48,24,26 },
		{182,181,180 ,24,27,28 ,49,51,52 }, {182,183,181 ,24,23,27 ,49,48,51 },
		{88,180,86 ,25,28,29 ,50,52,53 }, {88,182,180 ,25,24,28 ,50,49,52 },
		{181,85,179 ,27,30,31 ,51,28,54 }, {181,87,85 ,27,26,30 ,51,26,28 },
		{180,179,178 ,28,31,32 ,52,54,55 }, {180,181,179 ,28,27,31 ,52,51,54 },
		{86,178,84 ,29,32,33 ,53,55,56 }, {86,180,178 ,29,28,32 ,53,52,55 },
		{179,83,177 ,31,34,35 ,54,30,57 }, {179,85,83 ,31,30,34 ,54,28,30 },
		{178,177,176 ,32,35,36 ,55,57,58 }, {178,179,177 ,32,31,35 ,55,54,57 },
		{84,176,82 ,33,36,37 ,56,58,59 }, {84,178,176 ,33,32,36 ,56,55,58 },
		{177,81,175 ,35,38,39 ,57,31,60 }, {177,83,81 ,35,34,38 ,57,30,31 },
		{176,175,174 ,36,39,40 ,58,60,61 }, {176,177,175 ,36,35,39 ,58,57,60 },
		{82,174,80 ,37,40,41 ,59,61,31 }, {82,176,174 ,37,36,40 ,59,58,61 },
		{175,79,173 ,39,42,43 ,60,29,62 }, {175,81,79 ,39,38,42 ,60,31,29 },
		{174,173,172 ,40,43,44 ,61,62,63 }, {174,175,173 ,40,39,43 ,61,60,62 },
		{80,172,78 ,41,44,45 ,31,63,64 }, {80,174,172 ,41,40,44 ,31,61,63 },
		{173,77,171 ,43,46,47 ,62,27,65 }, {173,79,77 ,43,42,46 ,62,29,27 },
		{172,171,170 ,44,47,48 ,63,65,66 }, {172,173,171 ,44,43,47 ,63,62,65 },
		{78,170,76 ,45,48,49 ,64,66,67 }, {78,172,170 ,45,44,48 ,64,63,66 },
		{171,75,169 ,47,50,51 ,65,25,68 }, {171,77,75 ,47,46,50 ,65,27,25 },
		{170,169,168 ,48,51,52 ,66,68,69 }, {170,171,169 ,48,47,51 ,66,65,68 },
		{76,168,74 ,49,52,53 ,67,69,70 }, {76,170,168 ,49,48,52 ,67,66,69 },
		{169,73,167 ,51,54,55 ,68,23,71 }, {169,75,73 ,51,50,54 ,68,25,23 },
		{168,167,166 ,52,55,56 ,69,71,72 }, {168,169,167 ,52,51,55 ,69,68,71 },
		{74,166,72 ,53,56,57 ,70,72,73 }, {74,168,166 ,53,52,56 ,70,69,72 },
		{167,71,165 ,55,58,59 ,71,21,74 }, {167,73,71 ,55,54,58 ,71,23,21 },
		{166,165,164 ,56,59,60 ,72,74,75 }, {166,167,165 ,56,55,59 ,72,71,74 },
		{72,164,70 ,57,60,61 ,73,75,76 }, {72,166,164 ,57,56,60 ,73,72,75 },
		{165,69,163 ,59,62,63 ,74,19,77 }, {165,71,69 ,59,58,62 ,74,21,19 },
		{164,163,162 ,60,63,64 ,75,77,78 }, {164,165,163 ,60,59,63 ,75,74,77 },
		{70,162,68 ,61,64,65 ,76,78,79 }, {70,164,162 ,61,60,64 ,76,75,78 },
		{163,67,161 ,63,66,67 ,77,17,80 }, {163,69,67 ,63,62,66 ,77,19,17 },
		{162,161,160 ,64,67,68 ,78,80,81 }, {162,163,161 ,64,63,67 ,78,77,80 },
		{68,160,65 ,65,68,69 ,79,81,82 }, {68,162,160 ,65,64,68 ,79,78,81 },
		{161,66,159 ,67,70,71 ,80,15,83 }, {161,67,66 ,67,66,70 ,80,17,15 },
		{160,159,158 ,68,71,72 ,81,83,84 }, {160,161,159 ,68,67,71 ,81,80,83 },
		{65,158,64 ,69,72,73 ,82,84,15 }, {65,160,158 ,69,68,72 ,82,81,84 },
		{159,127,157 ,71,74,75 ,83,85,86 }, {159,66,127 ,71,70,74 ,83,15,85 },
		{158,157,156 ,72,75,76 ,84,86,87 }, {158,159,157 ,72,71,75 ,84,83,86 },
		{64,156,126 ,73,76,77 ,15,87,88 }, {64,158,156 ,73,72,76 ,15,84,87 },
		{157,125,155 ,75,78,79 ,86,11,89 }, {157,127,125 ,75,74,78 ,86,85,11 },
		{156,155,154 ,76,79,80 ,87,89,90 }, {156,157,155 ,76,75,79 ,87,86,89 },
		{126,154,124 ,77,80,81 ,88,90,91 }, {126,156,154 ,77,76,80 ,88,87,90 },
		{155,123,153 ,79,82,83 ,89,9,92 }, {155,125,123 ,79,78,82 ,89,11,9 },
		{154,153,152 ,80,83,84 ,90,92,93 }, {154,155,153 ,80,79,83 ,90,89,92 },
		{124,152,122 ,81,84,85 ,91,93,94 }, {124,154,152 ,81,80,84 ,91,90,93 },
		{153,121,151 ,83,86,87 ,92,7,95 }, {153,123,121 ,83,82,86 ,92,9,7 },
		{152,151,150 ,84,87,88 ,93,95,96 }, {152,153,151 ,84,83,87 ,93,92,95 },
		{122,150,120 ,85,88,89 ,94,96,97 }, {122,152,150 ,85,84,88 ,94,93,96 },
		{151,119,149 ,87,90,91 ,95,5,98 }, {151,121,119 ,87,86,90 ,95,7,5 },
		{150,149,148 ,88,91,92 ,96,98,99 }, {150,151,149 ,88,87,91 ,96,95,98 },
		{120,148,118 ,89,92,93 ,97,99,100 }, {120,150,148 ,89,88,92 ,97,96,99 },
		{149,117,147 ,91,94,95 ,98,3,101 }, {149,119,117 ,91,90,94 ,98,5,3 },
		{148,147,146 ,92,95,96 ,99,101,102 }, {148,149,147 ,92,91,95 ,99,98,101 },
		{118,146,116 ,93,96,97 ,100,102,103 }, {118,148,146 ,93,92,96 ,100,99,102 },
		{147,115,145 ,95,98,99 ,101,2,104 }, {147,117,115 ,95,94,98 ,101,3,2 },
		{146,145,144 ,96,99,100 ,102,104,105 }, {146,147,145 ,96,95,99 ,102,101,104 },
		{116,144,114 ,97,100,101 ,103,105,106 }, {116,146,144 ,97,96,100 ,103,102,105 },
		{145,113,143 ,99,102,103 ,104,0,107 }, {145,115,113 ,99,98,102 ,104,2,0 },
		{144,143,142 ,100,103,104 ,105,107,108 }, {144,145,143 ,100,99,103 ,105,104,107 },
		{114,142,112 ,101,104,105 ,106,108,0 }, {114,144,142 ,101,100,104 ,106,105,108 },
		{143,111,141 ,103,106,107 ,107,1,109 }, {143,113,111 ,103,102,106 ,107,0,1 },
		{142,141,140 ,104,107,108 ,108,109,110 }, {142,143,141 ,104,103,107 ,108,107,109 },
		{112,140,110 ,105,108,109 ,0,110,111 }, {112,142,140 ,105,104,108 ,0,108,110 },
		{141,109,139 ,107,110,111 ,109,4,112 }, {141,111,109 ,107,106,110 ,109,1,4 },
		{140,139,138 ,108,111,112 ,110,112,113 }, {140,141,139 ,108,107,111 ,110,109,112 },
		{110,138,108 ,109,112,113 ,111,113,114 }, {110,140,138 ,109,108,112 ,111,110,113 },
		{139,107,137 ,111,114,115 ,112,6,115 }, {139,109,107 ,111,110,114 ,112,4,6 },
		{138,137,136 ,112,115,116 ,113,115,116 }, {138,139,137 ,112,111,115 ,113,112,115 },
		{108,136,106 ,113,116,117 ,114,116,117 }, {108,138,136 ,113,112,116 ,114,113,116 },
		{137,105,135 ,115,118,119 ,115,8,118 }, {137,107,105 ,115,114,118 ,115,6,8 },
		{136,135,134 ,116,119,120 ,116,118,119 }, {136,137,135 ,116,115,119 ,116,115,118 },
		{106,134,104 ,117,120,121 ,117,119,120 }, {106,136,134 ,117,116,120 ,117,116,119 },
		{135,103,133 ,119,122,123 ,118,10,121 }, {135,105,103 ,119,118,122 ,118,8,10 },
		{134,133,132 ,120,123,124 ,119,121,122 }, {134,135,133 ,120,119,123 ,119,118,121 },
		{104,132,102 ,121,124,125 ,120,122,123 }, {104,134,132 ,121,120,124 ,120,119,122 },
		{133,101,131 ,123,126,127 ,121,12,124 }, {133,103,101 ,123,122,126 ,121,10,12 },
		{132,131,129 ,124,127,128 ,122,124,125 }, {132,133,131 ,124,123,127 ,122,121,124 },
		{102,129,100 ,125,128,129 ,123,125,126 }, {102,132,129 ,125,124,128 ,123,122,125 },
		{131,99,130 ,127,5,2 ,124,14,33 }, {131,101,99 ,127,126,5 ,124,12,14 },
		{129,130,128 ,128,2,6 ,125,33,35 }, {129,131,130 ,128,127,2 ,125,124,33 },
		{100,128,98 ,129,6,8 ,126,35,37 }, {100,129,128 ,129,128,6 ,126,125,35 },
		{66,39,127 ,70,130,74 ,15,13,85 }, {66,40,39 ,70,131,130 ,15,15,13 },
		{8,126,7 ,132,77,133 ,15,88,13 }, {8,64,126 ,132,73,77 ,15,15,88 },
		{127,38,125 ,74,134,78 ,85,11,11 }, {127,39,38 ,74,130,134 ,85,13,11 },
		{7,124,6 ,133,81,135 ,13,91,11 }, {7,126,124 ,133,77,81 ,13,88,91 },
		{125,37,123 ,78,136,82 ,11,9,9 }, {125,38,37 ,78,134,136 ,11,11,9 },
		{6,122,5 ,135,85,137 ,11,94,9 }, {6,124,122 ,135,81,85 ,11,91,94 },
		{123,36,121 ,82,138,86 ,9,7,7 }, {123,37,36 ,82,136,138 ,9,9,7 },
		{5,120,4 ,137,89,139 ,9,97,7 }, {5,122,120 ,137,85,89 ,9,94,97 },
		{121,35,119 ,86,140,90 ,7,5,5 }, {121,36,35 ,86,138,140 ,7,7,5 },
		{4,118,3 ,139,93,141 ,7,100,5 }, {4,120,118 ,139,89,93 ,7,97,100 },
		{119,34,117 ,90,142,94 ,5,3,3 }, {119,35,34 ,90,140,142 ,5,5,3 },
		{3,116,2 ,141,97,143 ,5,103,3 }, {3,118,116 ,141,93,97 ,5,100,103 },
		{117,33,115 ,94,144,98 ,3,2,2 }, {117,34,33 ,94,142,144 ,3,3,2 },
		{2,114,1 ,143,101,145 ,3,106,2 }, {2,116,114 ,143,97,101 ,3,103,106 },
		{115,32,113 ,98,146,102 ,2,0,0 }, {115,33,32 ,98,144,146 ,2,2,0 },
		{1,112,0 ,145,105,147 ,2,0,0 }, {1,114,112 ,145,101,105 ,2,106,0 },
		{113,63,111 ,102,148,106 ,0,32,1 }, {113,32,63 ,102,146,148 ,0,0,32 },
		{0,110,31 ,147,109,149 ,0,111,1 }, {0,112,110 ,147,105,109 ,0,0,111 },
		{111,62,109 ,106,150,110 ,1,4,4 }, {111,63,62 ,106,148,150 ,1,32,4 },
		{31,108,30 ,149,113,151 ,1,114,4 }, {31,110,108 ,149,109,113 ,1,111,114 },
		{109,61,107 ,110,152,114 ,4,6,6 }, {109,62,61 ,110,150,152 ,4,4,6 },
		{30,106,29 ,151,117,153 ,4,117,6 }, {30,108,106 ,151,113,117 ,4,114,117 },
		{107,60,105 ,114,154,118 ,6,8,8 }, {107,61,60 ,114,152,154 ,6,6,8 },
		{29,104,28 ,153,121,155 ,6,120,8 }, {29,106,104 ,153,117,121 ,6,117,120 },
		{105,59,103 ,118,156,122 ,8,10,10 }, {105,60,59 ,118,154,156 ,8,8,10 },
		{28,102,27 ,155,125,157 ,8,123,10 }, {28,104,102 ,155,121,125 ,8,120,123 },
		{103,58,101 ,122,158,126 ,10,12,12 }, {103,59,58 ,122,156,158 ,10,10,12 },
		{27,100,26 ,157,129,159 ,10,126,12 }, {27,102,100 ,157,125,129 ,10,123,126 },
		{101,57,99 ,126,160,5 ,12,14,14 }, {101,58,57 ,126,158,160 ,12,12,14 },
		{26,98,25 ,159,8,161 ,12,37,14 }, {26,100,98 ,159,129,8 ,12,126,37 },
		{99,56,97 ,5,162,3 ,14,16,16 }, {99,57,56 ,5,160,162 ,14,14,16 },
		{25,96,24 ,161,9,163 ,14,38,16 }, {25,98,96 ,161,8,9 ,14,37,38 },
		{97,55,95 ,3,164,10 ,16,18,18 }, {97,56,55 ,3,162,164 ,16,16,18 },
		{24,94,23 ,163,13,165 ,16,41,18 }, {24,96,94 ,163,9,13 ,16,38,41 },
		{95,54,93 ,10,166,14 ,18,20,20 }, {95,55,54 ,10,164,166 ,18,18,20 },
		{23,92,22 ,165,17,167 ,18,44,20 }, {23,94,92 ,165,13,17 ,18,41,44 },
		{93,53,91 ,14,168,18 ,20,22,22 }, {93,54,53 ,14,166,168 ,20,20,22 },
		{22,90,21 ,167,21,169 ,20,47,22 }, {22,92,90 ,167,17,21 ,20,44,47 },
		{91,52,89 ,18,170,22 ,22,24,24 }, {91,53,52 ,18,168,170 ,22,22,24 },
		{21,88,20 ,169,25,171 ,22,50,24 }, {21,90,88 ,169,21,25 ,22,47,50 },
		{89,51,87 ,22,172,26 ,24,26,26 }, {89,52,51 ,22,170,172 ,24,24,26 },
		{20,86,19 ,171,29,173 ,24,53,26 }, {20,88,86 ,171,25,29 ,24,50,53 },
		{87,50,85 ,26,174,30 ,26,28,28 }, {87,51,50 ,26,172,174 ,26,26,28 },
		{19,84,18 ,173,33,175 ,26,56,28 }, {19,86,84 ,173,29,33 ,26,53,56 },
		{85,49,83 ,30,176,34 ,28,30,30 }, {85,50,49 ,30,174,176 ,28,28,30 },
		{18,82,17 ,175,37,177 ,28,59,30 }, {18,84,82 ,175,33,37 ,28,56,59 },
		{83,48,81 ,34,178,38 ,30,31,31 }, {83,49,48 ,34,176,178 ,30,30,31 },
		{17,80,16 ,177,41,179 ,30,31,31 }, {17,82,80 ,177,37,41 ,30,59,31 },
		{81,47,79 ,38,180,42 ,31,29,29 }, {81,48,47 ,38,178,180 ,31,31,29 },
		{16,78,15 ,179,45,181 ,31,64,29 }, {16,80,78 ,179,41,45 ,31,31,64 },
		{79,46,77 ,42,182,46 ,29,27,27 }, {79,47,46 ,42,180,182 ,29,29,27 },
		{15,76,14 ,181,49,183 ,29,67,27 }, {15,78,76 ,181,45,49 ,29,64,67 },
		{77,45,75 ,46,184,50 ,27,25,25 }, {77,46,45 ,46,182,184 ,27,27,25 },
		{14,74,13 ,183,53,185 ,27,70,25 }, {14,76,74 ,183,49,53 ,27,67,70 },
		{75,44,73 ,50,186,54 ,25,23,23 }, {75,45,44 ,50,184,186 ,25,25,23 },
		{13,72,12 ,185,57,187 ,25,73,23 }, {13,74,72 ,185,53,57 ,25,70,73 },
		{73,43,71 ,54,188,58 ,23,21,21 }, {73,44,43 ,54,186,188 ,23,23,21 },
		{12,70,11 ,187,61,189 ,23,76,21 }, {12,72,70 ,187,57,61 ,23,73,76 },
		{71,42,69 ,58,190,62 ,21,19,19 }, {71,43,42 ,58,188,190 ,21,21,19 },
		{11,68,10 ,189,65,191 ,21,79,19 }, {11,70,68 ,189,61,65 ,21,76,79 },
		{69,41,67 ,62,192,66 ,19,17,17 }, {69,42,41 ,62,190,192 ,19,19,17 },
		{10,65,9 ,191,69,193 ,19,82,17 }, {10,68,65 ,191,65,69 ,19,79,82 },
		{67,40,66 ,66,131,70 ,17,15,15 }, {67,41,40 ,66,192,131 ,17,17,15 },
		{9,64,8 ,193,73,132 ,17,15,15 }, {9,65,64 ,193,69,73 ,17,82,15 },
		{280,193,192 ,194,195,196 ,127,128,129 }, {280,279,193 ,194,197,195 ,127,130,128 },
		{279,194,193 ,197,198,195 ,130,131,128 }, {279,278,194 ,197,199,198 ,130,132,131 },
		{278,195,194 ,199,200,198 ,132,133,131 }, {278,277,195 ,199,201,200 ,132,134,133 },
		{277,196,195 ,201,202,200 ,134,135,133 }, {277,276,196 ,201,203,202 ,134,136,135 },
		{276,197,196 ,203,204,202 ,136,137,135 }, {276,275,197 ,203,205,204 ,136,138,137 },
		{275,198,197 ,205,206,204 ,138,139,137 }, {275,292,198 ,205,206,206 ,138,140,139 },
		{198,291,199 ,206,207,208 ,139,141,142 }, {198,292,291 ,206,206,207 ,139,140,141 },
		{199,290,200 ,208,209,210 ,142,143,144 }, {199,291,290 ,208,207,209 ,142,141,143 },
		{200,289,201 ,210,211,212 ,144,145,146 }, {200,290,289 ,210,209,211 ,144,143,145 },
		{201,288,202 ,212,213,214 ,146,147,148 }, {201,289,288 ,212,211,213 ,146,145,147 },
		{202,287,203 ,214,215,216 ,148,149,150 }, {202,288,287 ,214,213,215 ,148,147,149 },
		{203,286,204 ,216,217,218 ,150,151,152 }, {203,287,286 ,216,215,217 ,150,149,151 },
		{204,285,205 ,218,219,220 ,153,154,155 }, {204,286,285 ,218,217,219 ,153,156,154 },
		{205,284,206 ,220,221,222 ,155,157,158 }, {205,285,284 ,220,219,221 ,155,154,157 },
		{206,283,207 ,222,223,224 ,158,159,160 }, {206,284,283 ,222,221,223 ,158,157,159 },
		{207,282,208 ,224,225,226 ,160,161,162 }, {207,283,282 ,224,223,225 ,160,159,161 },
		{208,281,209 ,226,227,228 ,162,163,164 }, {208,282,281 ,226,225,227 ,162,161,163 },
		{209,293,210 ,228,229,229 ,164,165,166 }, {209,281,293 ,228,227,229 ,164,163,165 },
		{293,211,210 ,229,230,229 ,165,167,166 }, {293,274,211 ,229,231,230 ,165,168,167 },
		{274,212,211 ,231,232,230 ,168,169,167 }, {274,273,212 ,231,233,232 ,168,170,169 },
		{273,213,212 ,233,234,232 ,170,171,169 }, {273,272,213 ,233,235,234 ,170,172,171 },
		{272,214,213 ,235,236,234 ,172,173,171 }, {272,271,214 ,235,237,236 ,172,174,173 },
		{271,215,214 ,237,238,236 ,174,175,173 }, {271,270,215 ,237,239,238 ,174,176,175 },
		{270,192,215 ,239,196,238 ,176,129,175 }, {270,280,192 ,239,194,196 ,176,127,129 },
		{287,285,286 ,0,0,0 ,177,178,179 }, {288,285,287 ,0,0,0 ,180,178,177 },
		{288,284,285 ,0,0,0 ,180,181,178 }, {289,284,288 ,0,0,0 ,182,181,180 },
		{289,283,284 ,0,0,0 ,182,183,181 }, {290,283,289 ,0,0,0 ,184,183,182 },
		{290,282,283 ,0,0,0 ,184,185,183 }, {291,282,290 ,0,0,0 ,186,185,184 },
		{291,281,282 ,0,0,0 ,186,187,185 }, {292,281,291 ,0,0,0 ,188,187,186 },
		{292,293,281 ,0,0,0 ,188,189,187 }, {275,293,292 ,0,0,0 ,190,189,188 },
		{275,274,293 ,0,0,0 ,190,191,189 }, {276,274,275 ,0,0,0 ,192,191,190 },
		{276,273,274 ,0,0,0 ,192,193,191 }, {277,273,276 ,0,0,0 ,194,193,192 },
		{277,272,273 ,0,0,0 ,194,195,193 }, {278,272,277 ,0,0,0 ,196,195,194 },
		{278,271,272 ,0,0,0 ,196,197,195 }, {279,271,278 ,0,0,0 ,198,197,196 },
		{279,270,271 ,0,0,0 ,198,199,197 }, {280,270,279 ,0,0,0 ,200,199,198 },
		{238,227,228 ,240,241,242 ,201,202,203 }, {239,227,238 ,243,241,240 ,204,202,201 },
		{239,226,227 ,243,244,241 ,204,205,202 }, {263,226,239 ,245,244,243 ,206,205,204 },
		{226,263,252 ,244,245,246 ,205,206,207 }, {252,263,251 ,246,245,247 ,207,206,208 },
		{263,264,251 ,245,248,247 ,206,209,208 }, {251,264,250 ,247,248,249 ,208,209,210 },
		{265,250,264 ,250,249,248 ,211,210,209 }, {249,250,265 ,251,249,250 ,212,210,211 },
		{241,254,252 ,252,206,246 ,213,214,207 }, {241,242,254 ,252,206,206 ,213,215,214 },
		{222,252,254 ,206,246,206 ,216,207,214 }, {222,225,252 ,206,253,246 ,216,217,207 },
		{219,229,227 ,254,255,241 ,218,219,202 }, {219,220,229 ,254,256,255 ,218,220,219 },
		{234,240,238 ,257,258,240 ,221,222,201 }, {234,235,240 ,257,259,258 ,221,223,222 },
		{256,263,267 ,229,245,229 ,224,206,225 }, {256,255,263 ,229,260,245 ,224,226,206 },
		{263,231,267 ,245,229,229 ,206,227,225 }, {263,230,231 ,245,261,229 ,206,228,227 },
		{258,266,265 ,262,263,250 ,229,230,211 }, {258,261,266 ,262,264,263 ,229,231,230 },
		{245,253,250 ,265,266,249 ,232,233,210 }, {245,246,253 ,265,267,266 ,232,234,233 },
		{241,252,251 ,252,246,247 ,213,207,208 }, {225,226,252 ,253,244,246 ,217,205,207 },
		{244,251,250 ,268,247,249 ,235,208,210 }, {243,251,244 ,269,247,268 ,236,208,235 },
		{241,251,243 ,252,247,269 ,213,208,236 }, {245,250,249 ,265,249,251 ,232,210,212 },
		{247,250,253 ,266,249,266 ,237,210,233 }, {247,244,250 ,266,268,249 ,237,235,210 },
		{257,249,265 ,270,251,250 ,238,212,211 }, {268,249,257 ,271,251,270 ,239,212,238 },
		{245,249,268 ,265,251,271 ,232,212,239 }, {258,265,264 ,262,250,248 ,229,211,209 },
		{262,265,266 ,272,250,263 ,240,211,230 }, {262,257,265 ,272,270,250 ,240,238,211 },
		{255,264,263 ,260,248,245 ,226,209,206 }, {258,264,259 ,262,248,273 ,229,209,241 },
		{255,259,264 ,260,273,248 ,226,241,209 }, {230,263,239 ,261,245,243 ,228,206,204 },
		{233,239,238 ,274,243,240 ,242,204,201 }, {232,239,233 ,275,243,274 ,243,204,242 },
		{230,239,232 ,261,243,275 ,228,204,243 }, {234,238,228 ,257,240,242 ,221,201,203 },
		{236,238,240 ,276,240,258 ,244,201,222 }, {236,233,238 ,276,274,240 ,244,242,201 },
		{218,228,227 ,277,242,241 ,245,203,202 }, {216,228,218 ,278,242,277 ,246,203,245 },
		{234,228,216 ,257,242,278 ,221,203,246 }, {219,227,226 ,254,241,244 ,218,202,205 },
		{221,227,229 ,279,241,255 ,247,202,219 }, {221,218,227 ,279,277,241 ,247,245,202 },
		{224,226,225 ,280,244,253 ,248,205,217 }, {219,226,224 ,254,244,280 ,218,205,248 },
		{269,257,262 ,281,270,272 ,249,238,240 }, {269,268,257 ,281,271,270 ,249,239,238 },
		{258,260,261 ,262,282,264 ,229,250,231 }, {258,259,260 ,262,273,282 ,229,241,250 },
		{260,255,256 ,282,260,229 ,250,226,224 }, {260,259,255 ,282,273,260 ,250,241,226 },
		{245,269,246 ,265,281,267 ,232,249,234 }, {245,268,269 ,265,271,281 ,232,239,249 },
		{248,244,247 ,283,268,266 ,251,235,237 }, {248,243,244 ,283,269,268 ,251,236,235 },
		{241,248,242 ,252,283,206 ,213,251,215 }, {241,243,248 ,252,269,283 ,213,236,251 },
		{222,224,225 ,206,280,253 ,216,248,217 }, {222,223,224 ,206,284,280 ,216,252,248 },
		{219,223,220 ,254,284,256 ,218,252,220 }, {219,224,223 ,254,280,284 ,218,248,252 },
		{217,218,221 ,285,277,279 ,253,245,247 }, {217,216,218 ,285,278,277 ,253,246,245 },
		{216,235,234 ,278,259,257 ,246,223,221 }, {216,217,235 ,278,285,259 ,246,253,223 },
		{237,233,236 ,286,274,276 ,254,242,244 }, {237,232,233 ,286,275,274 ,254,243,242 },
		{232,231,230 ,275,229,261 ,243,227,228 }, {232,237,231 ,275,286,229 ,243,254,227 },
		{300,303,302 ,287,288,289 ,255,256,257 }, {300,301,303 ,287,290,288 ,255,258,256 },
		{301,305,303 ,290,291,288 ,259,260,261 }, {301,304,305 ,290,292,291 ,259,262,260 },
		{302,294,300 ,289,293,287 ,257,263,255 }, {302,297,294 ,289,294,293 ,257,264,263 },
		{295,297,296 ,295,294,296 ,265,264,266 }, {295,294,297 ,295,293,294 ,265,263,264 },
		{298,296,299 ,297,296,298 ,267,266,268 }, {298,295,296 ,297,295,296 ,267,265,266 },
		{299,304,298 ,298,292,297 ,268,262,267 }, {299,305,304 ,298,291,292 ,268,260,262 }
	};
	static GLfloat vertices [306][3] = {
	{-2.85f,1.995f,0.00235001f},{-2.85f,1.95667f,0.391555f},{-2.85f,1.84314f,0.765803f},
	{-2.85f,1.65878f,1.11071f},{-2.85f,1.41068f,1.41303f},{-2.85f,1.10836f,1.66113f},
	{-2.85f,0.763453f,1.84549f},{-2.85f,0.389205f,1.95902f},{-2.85f,0.0f,1.99735f},
	{-2.85f,-0.389205f,1.95902f},{-2.85f,-0.763453f,1.84549f},{-2.85f,-1.10836f,1.66113f},
	{-2.85f,-1.41068f,1.41303f},{-2.85f,-1.65878f,1.11071f},{-2.85f,-1.84314f,0.765803f},
	{-2.85f,-1.95667f,0.391555f},{-2.85f,-1.995f,0.00235001f},{-2.85f,-1.95667f,-0.386855f},
	{-2.85f,-1.84314f,-0.761104f},{-2.85f,-1.65878f,-1.10601f},{-2.85f,-1.41068f,-1.40833f},
	{-2.85f,-1.10836f,-1.65643f},{-2.85f,-0.763453f,-1.84079f},{-2.85f,-0.389205f,-1.95432f},
	{-2.85f,0.0f,-1.99265f},{-2.85f,0.389205f,-1.95432f},{-2.85f,0.763453f,-1.84079f},
	{-2.85f,1.10836f,-1.65643f},{-2.85f,1.41068f,-1.40833f},{-2.85f,1.65878f,-1.10601f},
	{-2.85f,1.84314f,-0.761104f},{-2.85f,1.95667f,-0.386855f},{-2.55f,1.995f,0.00235001f},
	{-2.55f,1.95667f,0.391555f},{-2.55f,1.84314f,0.765803f},{-2.55f,1.65878f,1.11071f},
	{-2.55f,1.41068f,1.41303f},{-2.55f,1.10836f,1.66113f},{-2.55f,0.763453f,1.84549f},
	{-2.55f,0.389205f,1.95902f},{-2.55f,0.0f,1.99735f},{-2.55f,-0.389205f,1.95902f},
	{-2.55f,-0.763453f,1.84549f},{-2.55f,-1.10836f,1.66113f},{-2.55f,-1.41068f,1.41303f},
	{-2.55f,-1.65878f,1.11071f},{-2.55f,-1.84314f,0.765803f},{-2.55f,-1.95667f,0.391555f},
	{-2.55f,-1.995f,0.00235001f},{-2.55f,-1.95667f,-0.386855f},{-2.55f,-1.84314f,-0.761104f},
	{-2.55f,-1.65878f,-1.10601f},{-2.55f,-1.41068f,-1.40833f},{-2.55f,-1.10836f,-1.65643f},
	{-2.55f,-0.763453f,-1.84079f},{-2.55f,-0.389205f,-1.95432f},{-2.55f,0.0f,-1.99265f},
	{-2.55f,0.389205f,-1.95432f},{-2.55f,0.763453f,-1.84079f},{-2.55f,1.10836f,-1.65643f},
	{-2.55f,1.41068f,-1.40833f},{-2.55f,1.65878f,-1.10601f},{-2.55f,1.84314f,-0.761104f},
	{-2.55f,1.95667f,-0.386855f},{-2.82374f,0.0f,1.99735f},{-2.82374f,-0.389205f,1.95902f},
	{-2.57626f,0.0f,1.99735f},{-2.57626f,-0.389205f,1.95902f},{-2.82374f,-0.763453f,1.84549f},
	{-2.57626f,-0.763453f,1.84549f},{-2.82374f,-1.10836f,1.66113f},{-2.57626f,-1.10836f,1.66113f},
	{-2.82374f,-1.41068f,1.41303f},{-2.57626f,-1.41068f,1.41303f},{-2.82374f,-1.65878f,1.11071f},
	{-2.57626f,-1.65878f,1.11071f},{-2.82374f,-1.84314f,0.765803f},{-2.57626f,-1.84314f,0.765803f},
	{-2.82374f,-1.95667f,0.391555f},{-2.57626f,-1.95667f,0.391555f},{-2.82374f,-1.995f,0.00235001f},
	{-2.57626f,-1.995f,0.00235001f},{-2.82374f,-1.95667f,-0.386855f},{-2.57626f,-1.95667f,-0.386855f},
	{-2.82374f,-1.84314f,-0.761104f},{-2.57626f,-1.84314f,-0.761104f},{-2.82374f,-1.65878f,-1.10601f},
	{-2.57626f,-1.65878f,-1.10601f},{-2.82374f,-1.41068f,-1.40833f},{-2.57626f,-1.41068f,-1.40833f},
	{-2.82374f,-1.10836f,-1.65643f},{-2.57626f,-1.10836f,-1.65643f},{-2.82374f,-0.763453f,-1.84079f},
	{-2.57626f,-0.763453f,-1.84079f},{-2.82374f,-0.389205f,-1.95432f},{-2.57626f,-0.389205f,-1.95432f},
	{-2.82374f,0.0f,-1.99265f},{-2.57626f,0.0f,-1.99265f},{-2.82374f,0.389205f,-1.95432f},
	{-2.57626f,0.389205f,-1.95432f},{-2.82374f,0.763453f,-1.84079f},{-2.57626f,0.763453f,-1.84079f},
	{-2.82374f,1.10836f,-1.65643f},{-2.57626f,1.10836f,-1.65643f},{-2.82374f,1.41068f,-1.40833f},
	{-2.57626f,1.41068f,-1.40833f},{-2.82374f,1.65878f,-1.10601f},{-2.57626f,1.65878f,-1.10601f},
	{-2.82374f,1.84314f,-0.761104f},{-2.57626f,1.84314f,-0.761104f},{-2.82374f,1.95667f,-0.386855f},
	{-2.57626f,1.95667f,-0.386855f},{-2.82374f,1.995f,0.00235001f},{-2.57626f,1.995f,0.00235001f},
	{-2.82374f,1.95667f,0.391555f},{-2.57626f,1.95667f,0.391555f},{-2.82374f,1.84314f,0.765803f},
	{-2.57626f,1.84314f,0.765803f},{-2.82374f,1.65878f,1.11071f},{-2.57626f,1.65878f,1.11071f},
	{-2.82374f,1.41068f,1.41303f},{-2.57626f,1.41068f,1.41303f},{-2.82374f,1.10836f,1.66113f},
	{-2.57626f,1.10836f,1.66113f},{-2.82374f,0.763453f,1.84549f},{-2.57626f,0.763453f,1.84549f},
	{-2.82374f,0.389205f,1.95902f},{-2.57626f,0.389205f,1.95902f},{-2.76228f,0.412558f,-2.07172f},
	{-2.76228f,0.809261f,-1.95138f},{-2.63772f,0.412558f,-2.07172f},{-2.63772f,0.809261f,-1.95138f},
	{-2.76228f,1.17486f,-1.75596f},{-2.63772f,1.17486f,-1.75596f},{-2.76228f,1.49532f,-1.49297f},
	{-2.63772f,1.49532f,-1.49297f},{-2.76228f,1.75831f,-1.17251f},{-2.63772f,1.75831f,-1.17251f},
	{-2.76228f,1.95373f,-0.806911f},{-2.63772f,1.95373f,-0.806911f},{-2.76228f,2.07407f,-0.410208f},
	{-2.63772f,2.07407f,-0.410208f},{-2.76228f,2.1147f,0.00235001f},{-2.63772f,2.1147f,0.00235001f},
	{-2.76228f,2.07407f,0.414908f},{-2.63772f,2.07407f,0.414908f},{-2.76228f,1.95373f,0.81161f},
	{-2.63772f,1.95373f,0.81161f},{-2.76228f,1.75831f,1.17721f},{-2.63772f,1.75831f,1.17721f},
	{-2.76228f,1.49532f,1.49767f},{-2.63772f,1.49532f,1.49767f},{-2.76228f,1.17486f,1.76066f},
	{-2.63772f,1.17486f,1.76066f},{-2.76228f,0.809261f,1.95608f},{-2.63772f,0.809261f,1.95608f},
	{-2.76228f,0.412558f,2.07642f},{-2.63772f,0.412558f,2.07642f},{-2.76228f,0.0f,2.11705f},
	{-2.63772f,0.0f,2.11705f},{-2.76228f,-0.412558f,2.07642f},{-2.63772f,-0.412558f,2.07642f},
	{-2.76228f,-0.809261f,1.95608f},{-2.63772f,-0.809261f,1.95608f},{-2.76228f,-1.17486f,1.76066f},
	{-2.63772f,-1.17486f,1.76066f},{-2.76228f,-1.49532f,1.49767f},{-2.63772f,-1.49532f,1.49767f},
	{-2.76228f,-1.75831f,1.17721f},{-2.63772f,-1.75831f,1.17721f},{-2.76228f,-1.95373f,0.81161f},
	{-2.63772f,-1.95373f,0.81161f},{-2.76228f,-2.07407f,0.414908f},{-2.63772f,-2.07407f,0.414908f},
	{-2.76228f,-2.1147f,0.00235001f},{-2.63772f,-2.1147f,0.00235001f},{-2.76228f,-2.07407f,-0.410208f},
	{-2.63772f,-2.07407f,-0.410208f},{-2.76228f,-1.95373f,-0.806911f},{-2.63772f,-1.95373f,-0.806911f},
	{-2.76228f,-1.75831f,-1.17251f},{-2.63772f,-1.75831f,-1.17251f},{-2.76228f,-1.49532f,-1.49297f},
	{-2.63772f,-1.49532f,-1.49297f},{-2.76228f,-1.17486f,-1.75596f},{-2.63772f,-1.17486f,-1.75596f},
	{-2.76228f,-0.809261f,-1.95138f},{-2.63772f,-0.809261f,-1.95138f},{-2.76228f,-0.412558f,-2.07172f},
	{-2.63772f,-0.412558f,-2.07172f},{-2.76228f,0.0f,-2.11235f},{-2.63772f,0.0f,-2.11235f},
	{-2.85f,0.65f,0.00235001f},{-2.85f,0.627852f,0.170582f},{-2.85f,0.562917f,0.32735f},
	{-2.85f,0.459619f,0.461969f},{-2.85f,0.325f,0.565267f},{-2.85f,0.168232f,0.630202f},
	{-2.85f,0.0f,0.65235f},{-2.85f,-0.168232f,0.630202f},{-2.85f,-0.325f,0.565267f},
	{-2.85f,-0.459619f,0.461969f},{-2.85f,-0.562917f,0.32735f},{-2.85f,-0.627852f,0.170582f},
	{-2.85f,-0.65f,0.00235001f},{-2.85f,-0.627852f,-0.165882f},{-2.85f,-0.562917f,-0.32265f},
	{-2.85f,-0.459619f,-0.457269f},{-2.85f,-0.325f,-0.560567f},{-2.85f,-0.168232f,-0.625502f},
	{-2.85f,0.0f,-0.64765f},{-2.85f,0.168232f,-0.625502f},{-2.85f,0.325f,-0.560567f},
	{-2.85f,0.459619f,-0.457269f},{-2.85f,0.562917f,-0.32265f},{-2.85f,0.627852f,-0.165882f},
	{-3.59748f,0.46188f,0.00235001f},{-3.34126f,0.46188f,0.00235001f},{-3.61415f,0.403659f,0.103191f},
	{-3.61415f,0.289161f,0.301509f},{-3.34126f,0.289161f,0.301509f},{-3.34126f,0.403659f,0.103191f},
	{-3.34126f,0.114655f,0.40235f},{-3.34126f,0.23094f,0.40235f},{-3.59748f,0.23094f,0.40235f},
	{-3.61414f,0.114655f,0.40235f},{-3.62f,0.200001f,0.348759f},{-3.62f,0.34641f,0.20235f},
	{-3.62f,0.4f,0.00235001f},{-3.34126f,0.34641f,0.20235f},{-3.6141f,0.11502f,-0.39765f},
	{-3.34126f,0.11502f,-0.39765f},{-3.59748f,0.23094f,-0.39765f},{-3.61415f,0.289161f,-0.296809f},
	{-3.61415f,0.403659f,-0.0984914f},{-3.34126f,0.403659f,-0.0984914f},{-3.34126f,0.289161f,-0.296809f},
	{-3.34126f,0.23094f,-0.39765f},{-3.62f,0.34641f,-0.19765f},{-3.62f,0.200001f,-0.344059f},
	{-3.34126f,0.34641f,-0.19765f},{-3.6141f,-0.11502f,0.40235f},{-3.34126f,-0.11502f,0.40235f},
	{-3.59748f,-0.23094f,0.40235f},{-3.61415f,-0.289161f,0.301509f},{-3.61415f,-0.403659f,0.103191f},
	{-3.34126f,-0.403659f,0.103191f},{-3.34126f,-0.289161f,0.301509f},{-3.34126f,-0.23094f,0.40235f},
	{-3.62f,-0.4f,0.00235001f},{-3.62f,-0.34641f,0.20235f},{-3.62f,-0.200001f,0.348759f},
	{-3.62f,0.0f,0.40235f},{-3.34126f,-0.34641f,0.20235f},{-3.34126f,0.0f,0.40235f},
	{-3.61414f,-0.114655f,-0.39765f},{-3.34126f,-0.114655f,-0.39765f},{-3.61415f,-0.403659f,-0.0984914f},
	{-3.61415f,-0.289161f,-0.296809f},{-3.59748f,-0.23094f,-0.39765f},{-3.34126f,-0.23094f,-0.39765f},
	{-3.34126f,-0.289161f,-0.296809f},{-3.34126f,-0.403659f,-0.0984914f},{-3.62f,0.0f,-0.39765f},
	{-3.62f,-0.200001f,-0.344059f},{-3.62f,-0.34641f,-0.19765f},{-3.34126f,-0.34641f,-0.19765f},
	{-3.34126f,0.0f,-0.39765f},{-3.59748f,-0.46188f,0.00235001f},{-3.34126f,-0.46188f,0.00235001f},
	{-3.35f,0.627852f,-0.165882f},{-3.35f,0.562917f,-0.32265f},{-3.35f,0.459619f,-0.457269f},
	{-3.35f,0.325f,-0.560567f},{-3.35f,0.168232f,-0.625502f},{-3.35f,0.168232f,0.630202f},
	{-3.35f,0.325f,0.565267f},{-3.35f,0.459619f,0.461969f},{-3.35f,0.562917f,0.32735f},
	{-3.35f,0.627852f,0.170582f},{-3.35f,0.65f,0.00235001f},{-3.35f,-0.168232f,-0.625502f},
	{-3.35f,-0.325f,-0.560567f},{-3.35f,-0.459619f,-0.457269f},{-3.35f,-0.562917f,-0.32265f},
	{-3.35f,-0.627852f,-0.165882f},{-3.35f,-0.65f,0.00235001f},{-3.35f,-0.627852f,0.170582f},
	{-3.35f,-0.562917f,0.32735f},{-3.35f,-0.459619f,0.461969f},{-3.35f,-0.325f,0.565267f},
	{-3.35f,-0.168232f,0.630202f},{-3.35f,0.0f,0.65235f},{-3.35f,0.0f,-0.64765f},
	{-2.58f,0.15002f,0.262136f},{-2.58f,0.3f,0.00235001f},{-2.38f,0.3f,0.00235001f},
	{-2.38f,0.149976f,0.262164f},{-2.58f,0.15002f,-0.257436f},{-2.38f,0.149976f,-0.257464f},
	{-2.58f,-0.15002f,0.262136f},{-2.58f,-0.3f,0.00235001f},{-2.38f,-0.149976f,0.262164f},
	{-2.38f,-0.3f,0.00235001f},{-2.58f,-0.15002f,-0.257436f},{-2.38f,-0.149976f,-0.257464f}
	};
	static GLfloat normals [299][3] = {
	{-1.0f,0.0f,0.0f},{1.0f,0.0f,0.0f},{0.522152f,0.176567f,-0.834375f},
	{0.522152f,-0.0103954f,-0.852789f},{0.522152f,0.0103953f,-0.852789f},{0.522152f,0.156176f,-0.838431f},
	{-0.522151f,0.156176f,-0.838431f},{-0.522151f,-0.0103953f,-0.85279f},{-0.522151f,0.176567f,-0.834375f},
	{-0.522151f,0.0103953f,-0.85279f},{0.522152f,-0.176567f,-0.834375f},{0.522152f,-0.156176f,-0.838431f},
	{-0.522151f,-0.176567f,-0.834375f},{-0.522151f,-0.156176f,-0.838431f},{0.522152f,-0.335952f,-0.783896f},
	{0.522152f,-0.316744f,-0.791853f},{-0.522151f,-0.335952f,-0.783897f},{-0.522151f,-0.316744f,-0.791853f},
	{0.522152f,-0.482428f,-0.703293f},{0.522152f,-0.465141f,-0.714844f},{-0.522151f,-0.482428f,-0.703293f},
	{-0.522151f,-0.465141f,-0.714844f},{0.522152f,-0.610364f,-0.595663f},{0.522152f,-0.595663f,-0.610364f},
	{-0.522151f,-0.610364f,-0.595663f},{-0.522151f,-0.595663f,-0.610364f},{0.522152f,-0.714844f,-0.465141f},
	{0.522152f,-0.703293f,-0.482428f},{-0.522151f,-0.714844f,-0.465141f},{-0.522151f,-0.703293f,-0.482428f},
	{0.522152f,-0.791853f,-0.316744f},{0.522152f,-0.783897f,-0.335952f},{-0.522151f,-0.791853f,-0.316744f},
	{-0.522151f,-0.783897f,-0.335952f},{0.522152f,-0.838431f,-0.156175f},{0.522152f,-0.834375f,-0.176566f},
	{-0.522151f,-0.838432f,-0.156175f},{-0.522151f,-0.834376f,-0.176566f},{0.522152f,-0.852789f,0.0103953f},
	{0.522152f,-0.852789f,-0.0103952f},{-0.522151f,-0.85279f,0.0103952f},{-0.522151f,-0.85279f,-0.0103952f},
	{0.522152f,-0.834375f,0.176566f},{0.522152f,-0.838431f,0.156175f},{-0.522151f,-0.834376f,0.176566f},
	{-0.522151f,-0.838432f,0.156175f},{0.522152f,-0.783897f,0.335952f},{0.522152f,-0.791853f,0.316744f},
	{-0.522151f,-0.783897f,0.335952f},{-0.522151f,-0.791853f,0.316744f},{0.522152f,-0.703293f,0.482428f},
	{0.522152f,-0.714844f,0.465141f},{-0.522151f,-0.703293f,0.482428f},{-0.522151f,-0.714844f,0.465141f},
	{0.522152f,-0.595662f,0.610364f},{0.522152f,-0.610363f,0.595663f},{-0.522151f,-0.595663f,0.610364f},
	{-0.522151f,-0.610364f,0.595663f},{0.522152f,-0.465141f,0.714844f},{0.522152f,-0.482428f,0.703293f},
	{-0.522151f,-0.465141f,0.714844f},{-0.522151f,-0.482428f,0.703294f},{0.522152f,-0.316744f,0.791853f},
	{0.522151f,-0.335952f,0.783897f},{-0.522151f,-0.316745f,0.791853f},{-0.522151f,-0.335953f,0.783897f},
	{0.522152f,-0.156175f,0.838431f},{0.522152f,-0.176567f,0.834375f},{-0.522151f,-0.156176f,0.838432f},
	{-0.522151f,-0.176566f,0.834376f},{0.522152f,0.0103952f,0.852789f},{0.522152f,-0.0103953f,0.852789f},
	{-0.522151f,0.0103953f,0.85279f},{-0.522151f,-0.0103952f,0.85279f},{0.522152f,0.176566f,0.834375f},
	{0.522152f,0.156176f,0.838431f},{-0.522151f,0.176567f,0.834375f},{-0.522151f,0.156175f,0.838432f},
	{0.522151f,0.335952f,0.783897f},{0.522151f,0.316744f,0.791853f},{-0.522151f,0.335952f,0.783897f},
	{-0.522151f,0.316745f,0.791853f},{0.522152f,0.482428f,0.703293f},{0.522152f,0.465141f,0.714844f},
	{-0.522151f,0.482428f,0.703293f},{-0.522151f,0.465141f,0.714844f},{0.522152f,0.610364f,0.595663f},
	{0.522152f,0.595662f,0.610364f},{-0.522151f,0.610364f,0.595663f},{-0.522151f,0.595663f,0.610364f},
	{0.522152f,0.714844f,0.465141f},{0.522152f,0.703293f,0.482428f},{-0.522151f,0.714844f,0.465141f},
	{-0.522151f,0.703293f,0.482428f},{0.522152f,0.791853f,0.316744f},{0.522152f,0.783897f,0.335952f},
	{-0.522151f,0.791853f,0.316744f},{-0.522151f,0.783897f,0.335952f},{0.522152f,0.838431f,0.156175f},
	{0.522152f,0.834375f,0.176566f},{-0.522151f,0.838432f,0.156175f},{-0.522151f,0.834376f,0.176566f},
	{0.522152f,0.852789f,-0.0103953f},{0.522152f,0.852789f,0.0103952f},{-0.522151f,0.85279f,-0.0103952f},
	{-0.522151f,0.85279f,0.0103953f},{0.522152f,0.834375f,-0.176566f},{0.522152f,0.838431f,-0.156175f},
	{-0.522151f,0.834376f,-0.176566f},{-0.522151f,0.838432f,-0.156175f},{0.522152f,0.783897f,-0.335952f},
	{0.522152f,0.791853f,-0.316744f},{-0.522151f,0.783897f,-0.335952f},{-0.522151f,0.791853f,-0.316744f},
	{0.522152f,0.703293f,-0.482428f},{0.522152f,0.714844f,-0.465141f},{-0.522151f,0.703293f,-0.482428f},
	{-0.522151f,0.714844f,-0.465141f},{0.522152f,0.595663f,-0.610364f},{0.522152f,0.610364f,-0.595663f},
	{-0.522151f,0.595663f,-0.610364f},{-0.522151f,0.610364f,-0.595663f},{0.522152f,0.465141f,-0.714844f},
	{0.522152f,0.482428f,-0.703293f},{-0.522151f,0.465141f,-0.714844f},{-0.522151f,0.482428f,-0.703293f},
	{0.522152f,0.316744f,-0.791853f},{0.522152f,0.335952f,-0.783896f},{-0.522151f,0.316745f,-0.791853f},
	{-0.522151f,0.335952f,-0.783897f},{0.0f,0.162803f,0.986659f},{0.0f,-0.0328127f,0.999461f},
	{0.0f,0.0328127f,0.999461f},{0.0f,0.227167f,0.973856f},{0.0f,0.352162f,0.935939f},
	{0.0f,0.412792f,0.910825f},{0.0f,0.527988f,0.849252f},{0.0f,0.582554f,0.812792f},
	{0.0f,0.683524f,0.729928f},{0.0f,0.729928f,0.683524f},{0.0f,0.812792f,0.582554f},
	{0.0f,0.849252f,0.527988f},{0.0f,0.910825f,0.412792f},{0.0f,0.935939f,0.352162f},
	{0.0f,0.973856f,0.227168f},{0.0f,0.986659f,0.162803f},{0.0f,0.999461f,0.0328127f},
	{0.0f,0.999461f,-0.0328127f},{0.0f,0.986659f,-0.162803f},{0.0f,0.973856f,-0.227167f},
	{0.0f,0.935939f,-0.352162f},{0.0f,0.910825f,-0.412792f},{0.0f,0.849252f,-0.527988f},
	{0.0f,0.812792f,-0.582554f},{0.0f,0.729928f,-0.683524f},{0.0f,0.683524f,-0.729928f},
	{0.0f,0.582554f,-0.812792f},{0.0f,0.527988f,-0.849252f},{0.0f,0.412792f,-0.910825f},
	{0.0f,0.352162f,-0.935939f},{0.0f,0.227168f,-0.973856f},{0.0f,0.162803f,-0.986659f},
	{0.0f,0.0328129f,-0.999462f},{0.0f,-0.0328129f,-0.999462f},{0.0f,-0.162803f,-0.986659f},
	{0.0f,-0.227168f,-0.973856f},{0.0f,-0.352162f,-0.935939f},{0.0f,-0.412792f,-0.910825f},
	{0.0f,-0.527988f,-0.849252f},{0.0f,-0.582554f,-0.812792f},{0.0f,-0.683524f,-0.729928f},
	{0.0f,-0.729928f,-0.683524f},{0.0f,-0.812792f,-0.582554f},{0.0f,-0.849252f,-0.527988f},
	{0.0f,-0.910825f,-0.412792f},{0.0f,-0.935939f,-0.352162f},{0.0f,-0.973856f,-0.227167f},
	{0.0f,-0.986659f,-0.162803f},{0.0f,-0.999461f,-0.0328127f},{0.0f,-0.999461f,0.0328127f},
	{0.0f,-0.986659f,0.162803f},{0.0f,-0.973856f,0.227168f},{0.0f,-0.935939f,0.352162f},
	{0.0f,-0.910825f,0.412792f},{0.0f,-0.849252f,0.527988f},{0.0f,-0.812792f,0.582554f},
	{0.0f,-0.729928f,0.683524f},{0.0f,-0.683524f,0.729928f},{0.0f,-0.582554f,0.812792f},
	{0.0f,-0.527988f,0.849252f},{0.0f,-0.412792f,0.910825f},{0.0f,-0.352162f,0.935939f},
	{0.0f,-0.227167f,0.973856f},{0.0f,-0.162803f,0.986659f},{0.0f,0.999038f,0.043842f},
	{0.0f,0.976344f,0.216222f},{0.0f,0.999038f,-0.0438419f},{0.0f,0.95365f,0.300918f},
	{0.0f,0.887114f,0.461551f},{0.0f,0.843272f,0.537488f},{0.0f,0.737428f,0.675426f},
	{0.0f,0.675426f,0.737428f},{0.0f,0.537488f,0.843271f},{0.0f,0.461552f,0.887113f},
	{0.0f,0.300918f,0.95365f},{0.0f,0.216221f,0.976344f},{0.0f,0.0f,1.0f},
	{0.0f,-0.216221f,0.976344f},{0.0f,-0.300918f,0.95365f},{0.0f,-0.461552f,0.887113f},
	{0.0f,-0.537488f,0.843271f},{0.0f,-0.675426f,0.737428f},{0.0f,-0.737428f,0.675426f},
	{0.0f,-0.843272f,0.537488f},{0.0f,-0.887114f,0.461551f},{0.0f,-0.95365f,0.300918f},
	{0.0f,-0.976344f,0.216222f},{0.0f,-0.999038f,0.043842f},{0.0f,-0.999038f,-0.0438419f},
	{0.0f,-0.976344f,-0.216222f},{0.0f,-0.95365f,-0.300918f},{0.0f,-0.887114f,-0.461551f},
	{0.0f,-0.843272f,-0.537487f},{0.0f,-0.737428f,-0.675426f},{0.0f,-0.675426f,-0.737428f},
	{0.0f,-0.537488f,-0.843272f},{0.0f,-0.461551f,-0.887114f},{0.0f,-0.300918f,-0.95365f},
	{0.0f,-0.216222f,-0.976344f},{0.0f,0.0f,-1.0f},{0.0f,0.216222f,-0.976344f},
	{0.0f,0.300918f,-0.95365f},{0.0f,0.461551f,-0.887114f},{0.0f,0.537488f,-0.843272f},
	{0.0f,0.675426f,-0.737428f},{0.0f,0.737428f,-0.675426f},{0.0f,0.843272f,-0.537487f},
	{0.0f,0.887114f,-0.461551f},{0.0f,0.95365f,-0.300918f},{0.0f,0.976344f,-0.216222f},
	{-0.761363f,0.561466f,-0.324163f},{-0.826954f,0.486939f,0.281135f},{-0.976958f,0.213434f,4.51181e-009f},
	{-0.988244f,0.0764438f,-0.132403f},{-0.988256f,0.0764039f,0.132333f},{-0.806224f,2.00407e-005f,-0.59161f},
	{-0.761252f,-2.8475e-005f,0.648456f},{-0.988244f,-0.0764439f,0.132403f},{-0.988256f,-0.0764038f,-0.132333f},
	{-0.826954f,-0.486939f,0.281135f},{-0.761363f,-0.561466f,-0.324163f},{-0.976958f,-0.213434f,4.51181e-009f},
	{-0.391787f,-0.0377437f,0.919282f},{-0.607411f,0.058426f,0.792236f},{-0.391863f,0.777262f,0.492248f},
	{0.0f,0.866025f,0.500001f},{0.0f,0.866025f,0.5f},{-0.480022f,0.781746f,-0.398061f},
	{0.0f,0.866025f,-0.5f},{0.0f,0.866026f,-0.5f},{-0.479994f,-0.0461699f,-0.876056f},
	{-0.607313f,0.0585069f,-0.792305f},{-0.391863f,-0.777262f,-0.492247f},{0.0f,-0.866025f,-0.500001f},
	{0.0f,-0.866025f,-0.5f},{-0.391863f,-0.81493f,0.427005f},{0.0f,-0.866025f,0.5f},
	{0.0f,-0.866025f,0.5f},{-0.480022f,-0.735604f,0.477982f},{-0.61374f,-0.394815f,0.6837f},
	{-0.480022f,-0.781746f,-0.39806f},{-0.613739f,-0.789509f,2.92229e-008f},{0.0f,-0.866025f,-0.5f},
	{-0.613739f,-0.394774f,-0.683724f},{-0.480022f,0.735604f,-0.477981f},{-0.49237f,0.316738f,-0.810709f},
	{0.0f,0.866025f,-0.5f},{-0.480022f,0.781746f,0.398061f},{-0.492365f,0.860458f,-0.131107f},
	{0.0f,0.866025f,0.5f},{-0.492366f,0.316703f,0.810725f},{0.0f,-1.0f,5.16191e-008f},
	{0.0f,-0.5f,-0.866025f},{0.0f,-0.5f,0.866025f},{0.0f,0.654654f,0.755929f},
	{0.0f,0.981981f,0.188982f},{0.0f,0.654654f,-0.755929f},{-5.77637e-006f,-0.654644f,0.755937f},
	{4.57582e-005f,-0.981981f,0.188978f},{-5.73094e-005f,-0.327311f,0.944917f},{4.57643e-005f,-0.981977f,-0.189001f},
	{-5.76943e-006f,-0.654644f,-0.755937f},{-5.73036e-005f,-0.327333f,-0.944909f},{-5.73036e-005f,0.327333f,0.944909f},
	{-5.76944e-006f,0.654644f,0.755937f},{4.57643e-005f,0.981977f,0.189001f},{4.57582e-005f,0.981981f,-0.188978f},
	{-5.77637e-006f,0.654644f,-0.755937f},{-5.73094e-005f,0.327311f,-0.944917f}
	};
	static GLfloat textures [269][2] = {
	{0.66384f,0.192f},{0.666879f,0.161144f},{0.666879f,0.222856f},
	{0.675879f,0.252525f},{0.675879f,0.131475f},{0.690494f,0.279869f},
	{0.690494f,0.104131f},{0.710164f,0.303836f},{0.710164f,0.0801637f},
	{0.734131f,0.323506f},{0.734131f,0.0604944f},{0.761475f,0.338121f},
	{0.761475f,0.0458788f},{0.791144f,0.347121f},{0.791144f,0.0368786f},
	{0.822f,0.35016f},{0.822f,0.0338396f},{0.852855f,0.347121f},
	{0.852855f,0.0368786f},{0.882525f,0.338121f},{0.882525f,0.0458788f},
	{0.909869f,0.323506f},{0.909869f,0.0604944f},{0.933836f,0.303836f},
	{0.933836f,0.0801637f},{0.953506f,0.279869f},{0.953506f,0.104131f},
	{0.968121f,0.252525f},{0.968121f,0.131475f},{0.977121f,0.222856f},
	{0.977121f,0.161144f},{0.98016f,0.192f},{0.666879f,0.161144f},
	{0.787758f,0.0189499f},{0.8221f,0.0155675f},{0.789293f,0.0275713f},
	{0.822f,0.02435f},{0.791144f,0.0368786f},{0.822f,0.0338396f},
	{0.856442f,0.0189499f},{0.854707f,0.0275713f},{0.852855f,0.0368786f},
	{0.889465f,0.0289671f},{0.886157f,0.0371116f},{0.882525f,0.0458788f},
	{0.919898f,0.0452343f},{0.915141f,0.0526041f},{0.909869f,0.0604944f},
	{0.946574f,0.0671262f},{0.940546f,0.0734535f},{0.933836f,0.0801637f},
	{0.968466f,0.0938016f},{0.961396f,0.0988587f},{0.953506f,0.104131f},
	{0.984733f,0.124235f},{0.976888f,0.127843f},{0.968121f,0.131475f},
	{0.99475f,0.157258f},{0.986429f,0.159293f},{0.977121f,0.161144f},
	{0.998133f,0.1916f},{0.98965f,0.192f},{0.99475f,0.225942f},
	{0.986429f,0.224707f},{0.977121f,0.222856f},{0.984733f,0.258965f},
	{0.976888f,0.256157f},{0.968121f,0.252525f},{0.968466f,0.289398f},
	{0.961396f,0.285141f},{0.953506f,0.279869f},{0.946574f,0.316074f},
	{0.940546f,0.310547f},{0.933836f,0.303836f},{0.919898f,0.337966f},
	{0.915141f,0.331396f},{0.909869f,0.323506f},{0.889465f,0.354233f},
	{0.886157f,0.346888f},{0.882525f,0.338121f},{0.856442f,0.36425f},
	{0.854707f,0.356429f},{0.852855f,0.347121f},{0.8221f,0.367633f},
	{0.822f,0.35965f},{0.791144f,0.347121f},{0.787758f,0.36425f},
	{0.789293f,0.356429f},{0.791144f,0.347121f},{0.754735f,0.354233f},
	{0.757843f,0.346888f},{0.761475f,0.338121f},{0.724302f,0.337966f},
	{0.728859f,0.331396f},{0.734131f,0.323506f},{0.697626f,0.316074f},
	{0.703454f,0.310547f},{0.710164f,0.303836f},{0.675734f,0.289398f},
	{0.682604f,0.285141f},{0.690494f,0.279869f},{0.659467f,0.258965f},
	{0.667112f,0.256157f},{0.675879f,0.252525f},{0.64945f,0.225942f},
	{0.657571f,0.224707f},{0.666879f,0.222856f},{0.646067f,0.1916f},
	{0.65435f,0.192f},{0.64945f,0.157258f},{0.657571f,0.159293f},
	{0.666879f,0.161144f},{0.659467f,0.124235f},{0.667112f,0.127843f},
	{0.675879f,0.131475f},{0.675734f,0.0938016f},{0.682604f,0.0988587f},
	{0.690494f,0.104131f},{0.697626f,0.0671262f},{0.703454f,0.0734535f},
	{0.710164f,0.0801637f},{0.724302f,0.0452343f},{0.728859f,0.0526041f},
	{0.734131f,0.0604944f},{0.754735f,0.0289671f},{0.757843f,0.0371116f},
	{0.761475f,0.0458788f},{0.2535f,0.853948f},{0.255124f,0.857001f},
	{0.2535f,0.857001f},{0.255124f,0.853948f},{0.256749f,0.857001f},
	{0.256749f,0.853948f},{0.258373f,0.857001f},{0.258373f,0.853948f},
	{0.259998f,0.857001f},{0.259998f,0.853948f},{0.261622f,0.857001f},
	{0.261622f,0.853948f},{0.263247f,0.857001f},{0.263247f,0.853948f},
	{0.264871f,0.853948f},{0.264871f,0.857001f},{0.266495f,0.853948f},
	{0.266495f,0.857001f},{0.26812f,0.853948f},{0.26812f,0.857001f},
	{0.269744f,0.853948f},{0.269744f,0.857001f},{0.271368f,0.853948f},
	{0.271368f,0.857001f},{0.272993f,0.853948f},{0.272993f,0.857001f},
	{0.234007f,0.857001f},{0.235632f,0.853948f},{0.235632f,0.857001f},
	{0.234007f,0.853948f},{0.237256f,0.853948f},{0.237256f,0.857001f},
	{0.23888f,0.853948f},{0.23888f,0.857001f},{0.240505f,0.853948f},
	{0.240505f,0.857001f},{0.242129f,0.853948f},{0.242129f,0.857001f},
	{0.243754f,0.853948f},{0.243754f,0.857001f},{0.245378f,0.857001f},
	{0.245378f,0.853948f},{0.247002f,0.857001f},{0.247002f,0.853948f},
	{0.248627f,0.857001f},{0.248627f,0.853948f},{0.250251f,0.857001f},
	{0.250251f,0.853948f},{0.251876f,0.857001f},{0.251876f,0.853948f},
	{0.253708f,0.874168f},{0.253708f,0.869832f},{0.253422f,0.872f},
	{0.254545f,0.876189f},{0.254545f,0.867811f},{0.255876f,0.877924f},
	{0.255876f,0.866076f},{0.257611f,0.879255f},{0.257611f,0.864745f},
	{0.259632f,0.880092f},{0.259632f,0.863908f},{0.2618f,0.880378f},
	{0.2618f,0.863622f},{0.263968f,0.880092f},{0.263968f,0.863908f},
	{0.265989f,0.879255f},{0.265989f,0.864745f},{0.267724f,0.877924f},
	{0.267724f,0.866076f},{0.269055f,0.876189f},{0.269055f,0.867811f},
	{0.269892f,0.874168f},{0.269892f,0.869832f},{0.270178f,0.872f},
	{0.667947f,0.0351135f},{0.667947f,0.0868865f},{0.674901f,0.061f},
	{0.64895f,0.0161633f},{0.64895f,0.105837f},{0.623f,0.00922698f},
	{0.623f,0.112773f},{0.597049f,0.105837f},{0.597049f,0.0161633f},
	{0.578053f,0.0868865f},{0.578053f,0.0351135f},{0.571099f,0.061f},
	{0.608076f,0.112773f},{0.623f,0.110471f},{0.60874f,0.110471f},
	{0.637215f,0.110471f},{0.637877f,0.112773f},{0.660519f,0.0997209f},
	{0.665949f,0.0857356f},{0.658851f,0.0979993f},{0.675375f,0.0479479f},
	{0.665949f,0.0362644f},{0.673047f,0.0485281f},{0.608785f,0.0115287f},
	{0.623f,0.0115287f},{0.608123f,0.00922698f},{0.63726f,0.0115287f},
	{0.637924f,0.00922698f},{0.585481f,0.0222791f},{0.580051f,0.0362644f},
	{0.587149f,0.0240006f},{0.570625f,0.0740522f},{0.580051f,0.0857356f},
	{0.572953f,0.0734719f},{0.585481f,0.0997209f},{0.593035f,0.112773f},
	{0.587149f,0.0979993f},{0.570625f,0.0479479f},{0.56307f,0.061f},
	{0.572953f,0.0485281f},{0.593035f,0.00922698f},{0.660519f,0.0222791f},
	{0.652965f,0.00922698f},{0.658851f,0.0240006f},{0.675375f,0.0740522f},
	{0.68293f,0.061f},{0.673047f,0.0734719f},{0.652965f,0.112773f},
	{0.565735f,0.061f},{0.594368f,0.0115287f},{0.594368f,0.110471f},
	{0.651632f,0.110471f},{0.680265f,0.061f},{0.651632f,0.0115287f},
	{0.266921f,0.883765f},{0.26938f,0.886235f},{0.26692f,0.886235f},
	{0.26938f,0.883765f},{0.25462f,0.88282f},{0.25708f,0.886235f},
	{0.25462f,0.886235f},{0.257079f,0.883765f},{0.26446f,0.883765f},
	{0.26446f,0.886235f},{0.262f,0.883765f},{0.262f,0.886235f},
	{0.25954f,0.883765f},{0.25954f,0.886235f}
	};
	GLint GenEPuckWheelLeft()
	{
	unsigned i;
	unsigned j;
	
	GLint lid=glGenLists(1);
	glNewList(lid, GL_COMPILE);
	
		glBegin (GL_TRIANGLES);
		for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
		{
		for(j=0;j<3;j++)
			{
			int vi=face_indicies[i][j];
			int ni=face_indicies[i][j+3];//Normal index
			int ti=face_indicies[i][j+6];//Texture index
			/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
			
			// rotate 90 deg around z
			glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][1],-vertices[vi][0],vertices[vi][2]);
			}
		}
		glEnd ();
	
	glEndList();
	return lid;
	};
}
