
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2008 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://lis.epfl.ch/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// E-puck object file

#include <QtOpenGL>

namespace Enki
{
	// 938 Verticies
	// 1341 Texture Coordinates
	// 644 Normals
	// 1536 Triangles
	
	static short face_indicies[1536][9] = {
	// (unnamed)
		{15,17,16 ,0,0,0 ,0,1,2 }, {14,17,15 ,0,0,0 ,3,1,0 }, {14,18,17 ,0,0,0 ,3,4,1 },
		{13,18,14 ,0,0,0 ,5,4,3 }, {13,19,18 ,0,0,0 ,5,6,4 }, {12,19,13 ,0,0,0 ,7,6,5 },
		{12,20,19 ,0,0,0 ,7,8,6 }, {11,20,12 ,0,0,0 ,9,8,7 }, {11,21,20 ,0,0,0 ,9,10,8 },
		{10,21,11 ,0,0,0 ,11,10,9 }, {10,22,21 ,0,0,0 ,11,12,10 }, {9,22,10 ,0,0,0 ,13,12,11 },
		{9,23,22 ,0,0,0 ,13,14,12 }, {8,23,9 ,0,0,0 ,15,14,13 }, {8,24,23 ,0,0,0 ,15,16,14 },
		{7,24,8 ,0,0,0 ,17,16,15 }, {7,25,24 ,0,0,0 ,17,18,16 }, {6,25,7 ,0,0,0 ,19,18,17 },
		{6,26,25 ,0,0,0 ,19,20,18 }, {5,26,6 ,0,0,0 ,21,20,19 }, {5,27,26 ,0,0,0 ,21,22,20 },
		{4,27,5 ,0,0,0 ,23,22,21 }, {104,106,105 ,1,1,1 ,24,25,26 },
		{103,106,104 ,1,1,1 ,27,25,24 }, {103,107,106 ,1,1,1 ,27,28,25 },
		{102,107,103 ,1,1,1 ,29,28,27 }, {102,108,107 ,1,1,1 ,29,30,28 },
		{101,108,102 ,1,1,1 ,31,30,29 }, {101,109,108 ,1,1,1 ,31,32,30 },
		{100,109,101 ,1,1,1 ,33,32,31 }, {100,110,109 ,1,1,1 ,33,34,32 },
		{99,110,100 ,1,1,1 ,35,34,33 }, {99,111,110 ,1,1,1 ,35,36,34 },
		{98,111,99 ,1,1,1 ,37,36,35 }, {98,90,111 ,1,1,1 ,37,38,36 },
		{97,90,98 ,1,1,1 ,39,38,37 }, {90,97,89 ,1,1,1 ,38,39,40 }, {89,97,92 ,1,1,1 ,40,39,41 },
		{97,96,92 ,1,1,1 ,39,42,41 }, {92,96,93 ,1,1,1 ,41,42,43 }, {95,93,96 ,1,1,1 ,44,43,42 },
		{94,93,95 ,1,1,1 ,45,43,44 }, {135,133,134 ,2,2,2 ,46,47,48 },
		{136,133,135 ,2,2,2 ,49,47,46 }, {136,132,133 ,2,2,2 ,49,50,47 },
		{137,132,136 ,2,2,2 ,51,50,49 }, {132,137,129 ,2,2,2 ,50,51,52 },
		{129,137,130 ,2,2,2 ,52,51,53 }, {137,138,130 ,2,2,2 ,51,54,53 },
		{130,138,151 ,2,2,2 ,53,54,55 }, {138,139,151 ,2,2,2 ,54,56,55 },
		{151,139,150 ,2,2,2 ,55,56,57 }, {139,140,150 ,2,2,2 ,56,58,57 },
		{150,140,149 ,2,2,2 ,57,58,59 }, {140,141,149 ,2,2,2 ,58,60,59 },
		{149,141,148 ,2,2,2 ,59,60,61 }, {141,142,148 ,2,2,2 ,60,62,61 },
		{148,142,147 ,2,2,2 ,61,62,63 }, {142,143,147 ,2,2,2 ,62,64,63 },
		{147,143,146 ,2,2,2 ,63,64,65 }, {144,146,143 ,2,2,2 ,66,65,64 },
		{145,146,144 ,2,2,2 ,67,65,66 }, {115,119,118 ,1,1,1 ,68,69,70 },
		{115,120,119 ,1,1,1 ,68,71,69 }, {115,116,120 ,1,1,1 ,68,72,71 },
		{160,158,159 ,2,2,2 ,71,73,74 }, {156,158,160 ,2,2,2 ,75,73,71 },
		{155,158,156 ,2,2,2 ,76,73,75 }, {122,123,125 ,1,1,1 ,77,78,79 },
		{122,124,123 ,1,1,1 ,77,80,78 }, {122,121,124 ,1,1,1 ,77,81,80 },
		{165,161,162 ,2,2,2 ,82,83,84 }, {165,164,161 ,2,2,2 ,82,85,83 },
		{165,163,164 ,2,2,2 ,82,86,85 }, {88,129,128 ,3,4,5 ,87,40,87 },
		{88,89,129 ,3,6,4 ,87,40,40 }, {90,131,130 ,7,8,9 ,38,88,38 },
		{90,91,131 ,7,8,8 ,38,88,88 }, {89,132,129 ,6,10,4 ,40,41,40 },
		{89,92,132 ,6,11,10 ,40,41,41 }, {92,133,132 ,11,12,10 ,41,43,41 },
		{92,93,133 ,11,13,12 ,41,43,43 }, {93,134,133 ,13,14,12 ,43,45,43 },
		{93,94,134 ,13,14,14 ,43,45,45 }, {134,95,135 ,14,15,16 ,45,44,44 },
		{134,94,95 ,14,14,15 ,45,45,44 }, {135,96,136 ,16,17,18 ,44,42,42 },
		{135,95,96 ,16,15,17 ,44,44,42 }, {136,97,137 ,18,19,20 ,42,39,39 },
		{136,96,97 ,18,17,19 ,42,42,39 }, {138,99,139 ,21,22,23 ,37,35,35 },
		{138,98,99 ,21,24,22 ,37,37,35 }, {139,100,140 ,23,25,26 ,35,33,33 },
		{139,99,100 ,23,22,25 ,35,35,33 }, {140,101,141 ,26,27,27 ,33,31,31 },
		{140,100,101 ,26,25,27 ,33,33,31 }, {142,103,143 ,28,29,30 ,29,27,27 },
		{142,102,103 ,28,31,29 ,29,29,27 }, {143,104,144 ,30,32,33 ,27,24,24 },
		{143,103,104 ,30,29,32 ,27,27,24 }, {144,105,145 ,33,0,0 ,24,26,26 },
		{144,104,105 ,33,32,0 ,24,24,26 }, {105,146,145 ,0,34,0 ,26,25,26 },
		{105,106,146 ,0,35,34 ,26,25,25 }, {106,147,146 ,35,36,34 ,25,28,25 },
		{106,107,147 ,35,37,36 ,25,28,28 }, {107,148,147 ,37,38,36 ,28,30,28 },
		{107,108,148 ,37,39,38 ,28,30,30 }, {109,150,149 ,40,41,40 ,32,34,32 },
		{109,110,150 ,40,42,41 ,32,34,34 }, {110,151,150 ,42,43,41 ,34,36,34 },
		{110,111,151 ,42,44,43 ,34,36,36 }, {111,130,151 ,44,9,43 ,36,38,36 },
		{111,90,130 ,44,7,9 ,36,38,38 }, {137,112,152 ,20,45,46 ,39,89,89 },
		{137,97,112 ,20,19,45 ,39,39,89 }, {153,98,138 ,47,24,21 ,90,37,37 },
		{153,113,98 ,47,47,24 ,90,90,37 }, {114,155,154 ,48,49,50 ,91,68,91 },
		{114,115,155 ,48,51,49 ,91,68,68 }, {156,117,157 ,52,53,54 ,72,92,92 },
		{156,116,117 ,52,55,53 ,72,72,92 }, {101,154,141 ,27,50,27 ,31,91,31 },
		{101,114,154 ,27,48,50 ,31,91,91 }, {157,102,142 ,54,31,28 ,92,29,29 },
		{157,117,102 ,54,53,31 ,92,92,29 }, {115,158,155 ,51,56,49 ,68,70,68 },
		{115,118,158 ,51,57,56 ,68,70,70 }, {159,120,160 ,58,59,60 ,69,71,71 },
		{159,119,120 ,58,61,59 ,69,69,71 }, {160,116,156 ,60,55,52 ,71,72,72 },
		{160,120,116 ,60,59,55 ,71,71,72 }, {118,153,158 ,57,47,56 ,70,90,70 },
		{118,113,153 ,57,47,47 ,70,90,90 }, {152,119,159 ,46,61,58 ,89,69,69 },
		{152,112,119 ,46,45,61 ,89,89,69 }, {121,128,161 ,62,5,63 ,81,87,81 },
		{121,88,128 ,62,3,5 ,81,87,87 }, {131,122,162 ,8,64,65 ,88,77,77 },
		{131,91,122 ,8,8,64 ,88,88,77 }, {123,164,163 ,66,67,68 ,78,80,78 },
		{123,124,164 ,66,69,67 ,78,80,80 }, {124,161,164 ,69,63,67 ,80,81,80 },
		{124,121,161 ,69,62,63 ,80,81,81 }, {162,125,165 ,65,70,71 ,77,79,79 },
		{162,122,125 ,65,64,70 ,77,77,79 }, {126,163,166 ,72,68,73 ,93,78,93 },
		{126,123,163 ,72,66,68 ,93,78,78 }, {165,127,167 ,71,74,75 ,79,94,95 },
		{165,125,127 ,71,70,74 ,79,79,94 }, {108,166,148 ,39,73,38 ,30,93,30 },
		{108,126,166 ,39,72,73 ,30,93,93 }, {167,109,149 ,75,40,40 ,95,32,32 },
		{167,127,109 ,75,74,40 ,95,94,32 }, {91,89,88 ,1,1,1 ,88,40,87 },
		{91,90,89 ,1,1,1 ,88,38,40 }, {129,131,128 ,2,2,2 ,96,97,87 },
		{129,130,131 ,2,2,2 ,96,98,97 }, {98,112,97 ,1,1,1 ,37,89,39 },
		{98,113,112 ,1,1,1 ,37,90,89 }, {152,138,137 ,2,2,2 ,89,99,39 },
		{152,153,138 ,2,2,2 ,89,100,99 }, {117,115,114 ,1,1,1 ,92,68,91 },
		{117,116,115 ,1,1,1 ,92,72,68 }, {155,157,154 ,2,2,2 ,101,102,91 },
		{155,156,157 ,2,2,2 ,101,103,102 }, {102,114,101 ,1,1,1 ,29,91,31 },
		{102,117,114 ,1,1,1 ,29,92,91 }, {154,142,141 ,2,2,2 ,104,105,31 },
		{154,157,142 ,2,2,2 ,104,106,105 }, {119,113,118 ,1,1,1 ,69,90,70 },
		{119,112,113 ,1,1,1 ,69,89,90 }, {153,159,158 ,2,2,2 ,107,108,70 },
		{153,152,159 ,2,2,2 ,107,89,108 }, {122,88,121 ,1,1,1 ,77,87,81 },
		{122,91,88 ,1,1,1 ,77,88,87 }, {128,162,161 ,2,2,2 ,109,110,81 },
		{128,131,162 ,2,2,2 ,109,111,110 }, {127,123,126 ,1,1,1 ,94,78,93 },
		{127,125,123 ,1,1,1 ,94,79,78 }, {163,167,166 ,2,2,2 ,112,113,93 },
		{163,165,167 ,2,2,2 ,112,114,113 }, {109,126,108 ,1,1,1 ,32,93,30 },
		{109,127,126 ,1,1,1 ,32,94,93 }, {166,149,148 ,2,2,2 ,115,116,30 },
		{166,167,149 ,2,2,2 ,115,117,116 }, {203,201,202 ,1,1,1 ,118,119,120 },
		{204,201,203 ,1,1,1 ,121,119,118 }, {204,200,201 ,1,1,1 ,121,122,119 },
		{200,204,199 ,1,1,1 ,122,121,123 }, {205,199,204 ,1,1,1 ,124,123,121 },
		{199,205,198 ,1,1,1 ,123,124,125 }, {206,198,205 ,1,1,1 ,126,125,124 },
		{198,206,197 ,1,1,1 ,125,126,127 }, {207,197,206 ,1,1,1 ,128,127,126 },
		{197,207,196 ,1,1,1 ,127,128,129 }, {208,196,207 ,1,1,1 ,130,129,128 },
		{209,196,208 ,1,1,1 ,131,129,130 }, {196,209,195 ,1,1,1 ,129,131,132 },
		{210,195,209 ,1,1,1 ,133,132,131 }, {195,210,194 ,1,1,1 ,132,133,134 },
		{211,194,210 ,1,1,1 ,135,134,133 }, {194,211,193 ,1,1,1 ,134,135,136 },
		{212,193,211 ,1,1,1 ,137,136,135 }, {193,212,192 ,1,1,1 ,136,137,138 },
		{192,212,215 ,1,1,1 ,138,137,139 }, {213,215,212 ,1,1,1 ,140,139,137 },
		{214,215,213 ,1,1,1 ,141,139,140 }, {169,192,168 ,76,77,78 ,136,138,138 },
		{169,193,192 ,76,79,77 ,136,136,138 }, {170,193,169 ,80,79,76 ,134,136,136 },
		{170,194,193 ,80,45,79 ,134,134,136 }, {171,194,170 ,81,45,80 ,132,134,134 },
		{171,195,194 ,81,82,45 ,132,132,134 }, {172,195,171 ,83,82,81 ,129,132,132 },
		{172,196,195 ,83,17,82 ,129,129,132 }, {173,196,172 ,84,17,83 ,127,129,129 },
		{173,197,196 ,84,85,17 ,127,127,129 }, {174,197,173 ,86,85,84 ,125,127,127 },
		{174,198,197 ,86,14,85 ,125,125,127 }, {199,174,175 ,87,86,88 ,123,125,123 },
		{199,198,174 ,87,14,86 ,123,125,125 }, {200,175,176 ,89,88,90 ,122,123,122 },
		{200,199,175 ,89,87,88 ,122,123,123 }, {201,176,177 ,91,90,92 ,119,122,119 },
		{201,200,176 ,91,89,90 ,119,122,122 }, {202,177,178 ,3,92,93 ,120,119,120 },
		{202,201,177 ,3,91,92 ,120,119,119 }, {203,178,179 ,94,93,95 ,118,120,118 },
		{203,202,178 ,94,3,93 ,118,120,120 }, {204,179,180 ,96,95,97 ,121,118,121 },
		{204,203,179 ,96,94,95 ,121,118,118 }, {205,180,181 ,98,97,99 ,124,121,124 },
		{205,204,180 ,98,96,97 ,124,121,121 }, {206,181,182 ,100,99,101 ,126,124,126 },
		{206,205,181 ,100,98,99 ,126,124,124 }, {207,182,183 ,102,101,103 ,128,126,128 },
		{207,206,182 ,102,100,101 ,128,126,126 }, {208,183,184 ,104,103,105 ,130,128,130 },
		{208,207,183 ,104,102,103 ,130,128,128 }, {209,184,185 ,106,105,107 ,131,130,131 },
		{209,208,184 ,106,104,105 ,131,130,130 }, {210,185,186 ,0,107,108 ,133,131,133 },
		{210,209,185 ,0,106,107 ,133,131,131 }, {187,210,186 ,109,0,108 ,135,133,133 },
		{187,211,210 ,109,110,0 ,135,135,133 }, {188,211,187 ,111,110,109 ,137,135,135 },
		{188,212,211 ,111,112,110 ,137,137,135 }, {189,212,188 ,113,112,111 ,140,137,137 },
		{189,213,212 ,113,114,112 ,140,140,137 }, {190,213,189 ,115,114,113 ,141,140,140 },
		{190,214,213 ,115,116,114 ,141,141,140 }, {191,214,190 ,117,116,115 ,142,141,141 },
		{191,215,214 ,117,118,116 ,142,139,141 }, {168,215,191 ,78,118,117 ,138,139,142 },
		{168,192,215 ,78,77,118 ,138,138,139 }, {216,191,239 ,119,117,120 ,143,142,144 },
		{216,168,191 ,119,78,117 ,143,138,142 }, {217,168,216 ,121,78,119 ,145,138,143 },
		{217,169,168 ,121,76,78 ,145,136,138 }, {218,169,217 ,122,76,121 ,146,136,145 },
		{218,170,169 ,122,80,76 ,146,134,136 }, {219,170,218 ,123,80,122 ,147,134,146 },
		{219,171,170 ,123,81,80 ,147,132,134 }, {220,171,219 ,124,81,123 ,148,132,147 },
		{220,172,171 ,124,83,81 ,148,129,132 }, {221,172,220 ,125,83,124 ,149,129,148 },
		{221,173,172 ,125,84,83 ,149,127,129 }, {222,173,221 ,126,84,125 ,150,127,149 },
		{222,174,173 ,126,86,84 ,150,125,127 }, {175,222,223 ,88,126,127 ,123,150,151 },
		{175,174,222 ,88,86,126 ,123,125,150 }, {176,223,224 ,90,127,128 ,122,151,152 },
		{176,175,223 ,90,88,127 ,122,123,151 }, {177,224,225 ,92,128,129 ,119,152,153 },
		{177,176,224 ,92,90,128 ,119,122,152 }, {178,225,226 ,93,129,130 ,120,153,154 },
		{178,177,225 ,93,92,129 ,120,119,153 }, {179,226,227 ,95,130,131 ,118,154,155 },
		{179,178,226 ,95,93,130 ,118,120,154 }, {180,227,228 ,97,131,132 ,121,155,156 },
		{180,179,227 ,97,95,131 ,121,118,155 }, {181,228,229 ,99,132,133 ,124,156,157 },
		{181,180,228 ,99,97,132 ,124,121,156 }, {182,229,230 ,101,133,134 ,126,157,158 },
		{182,181,229 ,101,99,133 ,126,124,157 }, {183,230,231 ,103,134,135 ,128,158,159 },
		{183,182,230 ,103,101,134 ,128,126,158 }, {184,231,232 ,105,135,136 ,130,159,160 },
		{184,183,231 ,105,103,135 ,130,128,159 }, {185,232,233 ,107,136,137 ,131,160,161 },
		{185,184,232 ,107,105,136 ,131,130,160 }, {186,233,234 ,108,137,138 ,133,161,162 },
		{186,185,233 ,108,107,137 ,133,131,161 }, {235,186,234 ,139,108,138 ,163,133,162 },
		{235,187,186 ,139,109,108 ,163,135,133 }, {236,187,235 ,140,109,139 ,164,135,163 },
		{236,188,187 ,140,111,109 ,164,137,135 }, {237,188,236 ,141,111,140 ,165,137,164 },
		{237,189,188 ,141,113,111 ,165,140,137 }, {238,189,237 ,142,113,141 ,166,140,165 },
		{238,190,189 ,142,115,113 ,166,141,140 }, {239,190,238 ,120,115,142 ,144,141,166 },
		{239,191,190 ,120,117,115 ,144,142,141 }, {276,280,277 ,1,1,1 ,167,168,169 },
		{277,282,284 ,1,1,1 ,169,170,171 }, {277,280,282 ,1,1,1 ,169,168,170 },
		{278,281,279 ,2,2,2 ,172,173,174 }, {283,278,287 ,2,2,2 ,175,172,171 },
		{283,281,278 ,2,2,2 ,175,173,172 }, {289,287,286 ,2,2,2 ,176,171,177 },
		{289,283,287 ,2,2,2 ,176,175,171 }, {283,288,282 ,143,144,143 ,175,178,170 },
		{283,289,288 ,143,145,144 ,175,176,178 }, {283,280,281 ,143,146,147 ,175,168,173 },
		{283,282,280 ,143,143,146 ,175,170,168 }, {279,280,276 ,148,146,149 ,174,168,167 },
		{279,281,280 ,148,147,146 ,174,173,168 }, {284,288,285 ,1,1,1 ,171,178,179 },
		{284,282,288 ,1,1,1 ,171,170,178 }, {291,288,293 ,1,1,1 ,180,178,181 },
		{291,285,288 ,1,1,1 ,180,179,178 }, {286,291,290 ,150,151,152 ,177,180,182 },
		{286,285,291 ,150,153,151 ,177,179,180 }, {287,277,284 ,154,155,156 ,171,169,171 },
		{287,278,277 ,154,155,155 ,171,172,169 }, {287,285,286 ,154,153,150 ,171,179,177 },
		{287,284,285 ,154,156,153 ,171,171,179 }, {279,277,278 ,148,155,155 ,174,169,172 },
		{279,276,277 ,148,149,155 ,174,167,169 }, {289,293,288 ,145,157,144 ,176,181,178 },
		{289,292,293 ,145,157,157 ,176,183,181 }, {289,290,292 ,2,2,2 ,176,182,183 },
		{289,286,290 ,2,2,2 ,176,177,182 }, {244,240,241 ,1,1,1 ,184,185,186 },
		{246,241,248 ,1,1,1 ,187,186,188 }, {246,244,241 ,1,1,1 ,187,184,186 },
		{245,242,243 ,2,2,2 ,184,189,190 }, {242,247,251 ,2,2,2 ,189,191,188 },
		{242,245,247 ,2,2,2 ,189,184,191 }, {251,253,250 ,2,2,2 ,188,192,193 },
		{251,247,253 ,2,2,2 ,188,191,192 }, {252,247,246 ,158,159,159 ,194,191,187 },
		{252,253,247 ,158,160,159 ,194,192,191 }, {244,247,245 ,161,159,162 ,184,191,184 },
		{244,246,247 ,161,159,159 ,184,187,191 }, {244,243,240 ,161,163,164 ,184,190,185 },
		{244,245,243 ,161,162,163 ,184,184,190 }, {275,270,295 ,165,166,167 ,195,196,197 },
		{275,274,270 ,165,168,166 ,195,198,196 }, {294,295,269 ,2,2,2 ,199,197,200 },
		{294,275,295 ,2,2,2 ,199,195,197 }, {274,272,271 ,1,1,1 ,198,201,202 },
		{274,268,270 ,1,1,1 ,198,203,196 }, {274,271,268 ,1,1,1 ,198,202,203 },
		{294,273,275 ,2,2,2 ,199,204,195 }, {252,248,249 ,1,1,1 ,194,188,205 },
		{252,246,248 ,1,1,1 ,194,187,188 }, {252,254,258 ,1,1,1 ,194,206,207 },
		{252,249,254 ,1,1,1 ,194,205,206 }, {254,256,291 ,1,1,1 ,206,208,180 },
		{258,291,293 ,1,1,1 ,207,180,181 }, {258,254,291 ,1,1,1 ,207,206,180 },
		{260,293,262 ,1,1,1 ,209,181,210 }, {260,258,293 ,1,1,1 ,209,207,181 },
		{264,262,266 ,1,1,1 ,211,210,212 }, {264,260,262 ,1,1,1 ,211,209,210 },
		{268,266,270 ,1,1,1 ,203,212,196 }, {268,264,266 ,1,1,1 ,203,211,212 },
		{262,267,266 ,169,170,171 ,210,213,212 }, {262,263,267 ,169,172,170 ,210,214,213 },
		{293,263,262 ,157,172,169 ,181,214,210 }, {293,292,263 ,157,157,172 ,181,183,214 },
		{291,257,290 ,151,173,152 ,180,215,182 }, {291,256,257 ,151,174,173 ,180,208,215 },
		{256,255,257 ,174,175,173 ,208,216,215 }, {256,254,255 ,174,176,175 ,208,206,216 },
		{290,257,255 ,2,2,2 ,182,215,216 }, {254,250,255 ,176,177,175 ,206,193,216 },
		{254,249,250 ,176,178,177 ,206,205,193 }, {241,251,248 ,179,180,181 ,186,188,188 },
		{241,242,251 ,179,179,180 ,186,189,188 }, {249,251,250 ,178,180,177 ,205,188,193 },
		{249,248,251 ,178,181,180 ,205,188,188 }, {241,243,242 ,179,163,179 ,186,190,189 },
		{241,240,243 ,179,164,163 ,186,185,190 }, {258,253,252 ,182,160,158 ,207,192,194 },
		{258,259,253 ,182,183,160 ,207,217,192 }, {255,253,259 ,2,2,2 ,216,192,217 },
		{255,250,253 ,2,2,2 ,216,193,192 }, {260,259,258 ,184,183,182 ,209,217,207 },
		{260,261,259 ,184,185,183 ,209,218,217 }, {292,255,259 ,2,2,2 ,183,216,217 },
		{292,290,255 ,2,2,2 ,183,182,216 }, {264,261,260 ,186,185,184 ,211,218,209 },
		{264,265,261 ,186,187,185 ,211,219,218 }, {263,259,261 ,2,2,2 ,214,217,218 },
		{263,292,259 ,2,2,2 ,214,183,217 }, {268,265,264 ,188,187,186 ,203,219,211 },
		{268,269,265 ,188,189,187 ,203,200,219 }, {267,261,265 ,2,2,2 ,213,218,219 },
		{267,263,261 ,2,2,2 ,213,214,218 }, {271,269,268 ,190,189,188 ,202,200,203 },
		{271,294,269 ,190,191,189 ,202,199,200 }, {272,294,271 ,192,191,190 ,201,199,202 },
		{272,273,294 ,192,193,191 ,201,204,199 }, {274,273,272 ,168,193,192 ,198,204,201 },
		{274,275,273 ,168,165,193 ,198,195,204 }, {266,295,270 ,171,167,166 ,212,197,196 },
		{266,267,295 ,171,170,167 ,212,213,197 }, {267,269,295 ,2,2,2 ,213,200,197 },
		{267,265,269 ,2,2,2 ,213,219,200 }, {297,298,299 ,14,14,14 ,220,221,222 },
		{297,296,298 ,14,14,14 ,220,223,221 }, {296,302,298 ,194,194,194 ,223,224,221 },
		{296,300,302 ,194,194,194 ,223,225,224 }, {301,299,303 ,195,195,195 ,226,222,227 },
		{301,297,299 ,195,195,195 ,226,220,222 }, {300,303,302 ,0,0,0 ,225,227,224 },
		{300,301,303 ,0,0,0 ,225,226,227 }, {297,300,296 ,1,1,1 ,220,225,223 },
		{297,301,300 ,1,1,1 ,220,226,225 }, {305,306,307 ,194,194,194 ,228,229,230 },
		{305,304,306 ,194,194,194 ,228,231,229 }, {308,306,304 ,0,0,0 ,232,229,231 },
		{308,310,306 ,0,0,0 ,232,233,229 }, {305,311,309 ,14,14,14 ,228,234,235 },
		{305,307,311 ,14,14,14 ,228,230,234 }, {305,308,304 ,1,1,1 ,228,232,231 },
		{305,309,308 ,1,1,1 ,228,235,232 }, {310,309,311 ,195,195,195 ,233,235,234 },
		{310,308,309 ,195,195,195 ,233,232,235 }, {315,313,312 ,2,2,2 ,236,237,238 },
		{315,314,313 ,2,2,2 ,236,239,237 }, {313,316,312 ,196,196,196 ,237,240,238 },
		{313,317,316 ,196,196,196 ,237,241,240 }, {314,317,313 ,197,197,197 ,239,241,237 },
		{314,318,317 ,197,197,197 ,239,242,241 }, {319,314,315 ,198,198,198 ,243,239,236 },
		{319,318,314 ,198,198,198 ,243,242,239 }, {316,315,312 ,199,199,199 ,240,236,238 },
		{316,319,315 ,199,199,199 ,240,243,236 }, {317,319,316 ,1,1,1 ,241,243,240 },
		{317,318,319 ,1,1,1 ,241,242,243 }, {323,321,320 ,2,2,2 ,236,237,238 },
		{323,322,321 ,2,2,2 ,236,239,237 }, {321,324,320 ,0,0,0 ,237,240,238 },
		{321,325,324 ,0,0,0 ,237,241,240 }, {322,325,321 ,194,194,194 ,239,241,237 },
		{322,326,325 ,194,194,194 ,239,242,241 }, {327,322,323 ,14,14,14 ,243,239,236 },
		{327,326,322 ,14,14,14 ,243,242,239 }, {324,323,320 ,195,195,195 ,240,236,238 },
		{324,327,323 ,195,195,195 ,240,243,236 }, {325,327,324 ,1,1,1 ,241,243,240 },
		{325,326,327 ,1,1,1 ,241,242,243 }, {331,329,328 ,2,2,2 ,236,237,238 },
		{331,330,329 ,2,2,2 ,236,239,237 }, {329,332,328 ,200,200,200 ,237,240,238 },
		{329,333,332 ,200,200,200 ,237,241,240 }, {330,333,329 ,201,201,201 ,239,241,237 },
		{330,334,333 ,201,201,201 ,239,242,241 }, {335,330,331 ,202,202,202 ,243,239,236 },
		{335,334,330 ,202,202,202 ,243,242,239 }, {332,331,328 ,203,203,203 ,244,245,246 },
		{332,335,331 ,203,203,203 ,244,247,245 }, {333,335,332 ,1,1,1 ,241,243,240 },
		{333,334,335 ,1,1,1 ,241,242,243 }, {339,337,336 ,2,2,2 ,236,237,238 },
		{339,338,337 ,2,2,2 ,236,239,237 }, {337,340,336 ,204,204,204 ,237,240,238 },
		{337,341,340 ,204,204,204 ,237,241,240 }, {338,341,337 ,205,205,205 ,239,241,237 },
		{338,342,341 ,205,205,205 ,239,242,241 }, {343,338,339 ,206,206,206 ,243,239,236 },
		{343,342,338 ,206,206,206 ,243,242,239 }, {340,339,336 ,207,207,207 ,240,236,238 },
		{340,343,339 ,207,207,207 ,240,243,236 }, {341,343,340 ,1,1,1 ,241,243,240 },
		{341,342,343 ,1,1,1 ,241,242,243 }, {345,347,344 ,2,2,2 ,237,236,238 },
		{345,346,347 ,2,2,2 ,237,239,236 }, {348,345,344 ,208,208,208 ,240,237,238 },
		{348,349,345 ,208,208,208 ,240,241,237 }, {349,346,345 ,209,209,209 ,241,239,237 },
		{349,350,346 ,209,209,209 ,241,242,239 }, {346,351,347 ,210,210,210 ,239,243,236 },
		{346,350,351 ,210,210,210 ,239,242,243 }, {347,348,344 ,211,211,211 ,236,240,238 },
		{347,351,348 ,211,211,211 ,236,243,240 }, {351,349,348 ,1,1,1 ,243,241,240 },
		{351,350,349 ,1,1,1 ,243,242,241 }, {353,355,352 ,2,2,2 ,237,236,238 },
		{353,354,355 ,2,2,2 ,237,239,236 }, {356,353,352 ,0,0,0 ,240,237,238 },
		{356,357,353 ,0,0,0 ,240,241,237 }, {357,354,353 ,195,195,195 ,241,239,237 },
		{357,358,354 ,195,195,195 ,241,242,239 }, {354,359,355 ,14,14,14 ,239,243,236 },
		{354,358,359 ,14,14,14 ,239,242,243 }, {355,356,352 ,194,194,194 ,236,240,238 },
		{355,359,356 ,194,194,194 ,236,243,240 }, {359,357,356 ,1,1,1 ,243,241,240 },
		{359,358,357 ,1,1,1 ,243,242,241 }, {361,363,360 ,2,2,2 ,237,236,238 },
		{361,362,363 ,2,2,2 ,237,239,236 }, {364,361,360 ,212,212,212 ,240,237,238 },
		{364,365,361 ,212,212,212 ,240,241,237 }, {365,362,361 ,213,213,213 ,241,239,237 },
		{365,366,362 ,213,213,213 ,241,242,239 }, {362,367,363 ,214,214,214 ,239,243,236 },
		{362,366,367 ,214,214,214 ,239,242,243 }, {363,364,360 ,215,215,215 ,236,240,238 },
		{363,367,364 ,215,215,215 ,236,243,240 }, {367,365,364 ,1,1,1 ,243,241,240 },
		{367,366,365 ,1,1,1 ,243,242,241 }, {369,371,368 ,2,2,2 ,237,236,238 },
		{369,370,371 ,2,2,2 ,237,239,236 }, {372,369,368 ,216,216,216 ,240,237,238 },
		{372,373,369 ,216,216,216 ,240,241,237 }, {373,370,369 ,217,217,217 ,241,239,237 },
		{373,374,370 ,217,217,217 ,241,242,239 }, {370,375,371 ,218,218,218 ,239,248,236 },
		{370,374,375 ,218,218,218 ,239,242,248 }, {371,372,368 ,219,219,219 ,236,240,238 },
		{371,375,372 ,219,219,219 ,236,248,240 }, {375,373,372 ,1,1,1 ,248,241,240 },
		{375,374,373 ,1,1,1 ,248,242,241 }, {377,378,379 ,220,220,220 ,249,250,251 },
		{377,376,378 ,220,220,220 ,249,252,250 }, {380,378,376 ,221,221,221 ,253,250,252 },
		{380,382,378 ,221,221,221 ,253,254,250 }, {377,383,381 ,222,222,222 ,249,255,256 },
		{377,379,383 ,222,222,222 ,249,251,255 }, {377,380,376 ,1,1,1 ,249,253,252 },
		{377,381,380 ,1,1,1 ,249,256,253 }, {382,381,383 ,223,223,223 ,254,256,255 },
		{382,380,381 ,223,223,223 ,254,253,256 }, {417,415,416 ,1,1,1 ,257,258,259 },
		{418,415,417 ,1,1,1 ,260,258,257 }, {418,414,415 ,1,1,1 ,260,261,258 },
		{419,414,418 ,1,1,1 ,262,261,260 }, {419,413,414 ,1,1,1 ,262,263,261 },
		{413,419,412 ,1,1,1 ,263,262,264 }, {420,412,419 ,1,1,1 ,265,264,262 },
		{412,420,411 ,1,1,1 ,264,265,266 }, {421,411,420 ,1,1,1 ,267,266,265 },
		{422,411,421 ,1,1,1 ,268,266,267 }, {422,410,411 ,1,1,1 ,268,269,266 },
		{410,422,409 ,1,1,1 ,269,268,270 }, {423,409,422 ,1,1,1 ,271,270,268 },
		{409,423,408 ,1,1,1 ,270,271,272 }, {424,408,423 ,1,1,1 ,273,272,271 },
		{408,424,431 ,1,1,1 ,272,273,274 }, {425,431,424 ,1,1,1 ,275,274,273 },
		{431,425,430 ,1,1,1 ,274,275,276 }, {426,430,425 ,1,1,1 ,277,276,275 },
		{430,426,429 ,1,1,1 ,276,277,278 }, {427,429,426 ,1,1,1 ,279,278,277 },
		{428,429,427 ,1,1,1 ,280,278,279 }, {385,408,384 ,224,225,226 ,281,272,282 },
		{385,409,408 ,224,227,225 ,281,270,272 }, {386,409,385 ,228,227,224 ,283,270,281 },
		{386,410,409 ,228,229,227 ,283,269,270 }, {387,410,386 ,230,229,228 ,284,269,283 },
		{387,411,410 ,230,231,229 ,284,266,269 }, {388,411,387 ,232,231,230 ,285,266,284 },
		{388,412,411 ,232,233,231 ,285,264,266 }, {389,412,388 ,234,233,232 ,286,264,285 },
		{389,413,412 ,234,235,233 ,286,263,264 }, {390,413,389 ,14,235,234 ,287,263,286 },
		{390,414,413 ,14,14,235 ,287,261,263 }, {415,390,391 ,236,14,237 ,258,287,288 },
		{415,414,390 ,236,14,14 ,258,261,287 }, {416,391,392 ,238,237,239 ,259,288,289 },
		{416,415,391 ,238,236,237 ,259,258,288 }, {417,392,393 ,240,239,241 ,257,289,290 },
		{417,416,392 ,240,238,239 ,257,259,289 }, {418,393,394 ,3,241,242 ,260,290,291 },
		{418,417,393 ,3,240,241 ,260,257,290 }, {419,394,395 ,243,242,244 ,262,291,292 },
		{419,418,394 ,243,3,242 ,262,260,291 }, {420,395,396 ,245,244,246 ,265,292,293 },
		{420,419,395 ,245,243,244 ,265,262,292 }, {421,396,397 ,247,246,248 ,267,293,294 },
		{421,420,396 ,247,245,246 ,267,265,293 }, {422,397,398 ,249,248,250 ,268,294,295 },
		{422,421,397 ,249,247,248 ,268,267,294 }, {423,398,399 ,251,250,38 ,271,295,296 },
		{423,422,398 ,251,249,250 ,271,268,295 }, {424,399,400 ,252,38,253 ,273,296,297 },
		{424,423,399 ,252,251,38 ,273,271,296 }, {425,400,401 ,254,253,255 ,275,297,298 },
		{425,424,400 ,254,252,253 ,275,273,297 }, {426,401,402 ,0,255,0 ,277,298,299 },
		{426,425,401 ,0,254,255 ,277,275,298 }, {403,426,402 ,256,0,0 ,300,277,299 },
		{403,427,426 ,256,257,0 ,300,279,277 }, {404,427,403 ,258,257,256 ,301,279,300 },
		{404,428,427 ,258,259,257 ,301,280,279 }, {405,428,404 ,28,259,258 ,302,280,301 },
		{405,429,428 ,28,260,259 ,302,278,280 }, {406,429,405 ,261,260,28 ,303,278,302 },
		{406,430,429 ,261,262,260 ,303,276,278 }, {407,430,406 ,263,262,261 ,304,276,303 },
		{407,431,430 ,263,264,262 ,304,274,276 }, {384,431,407 ,226,264,263 ,282,274,304 },
		{384,408,431 ,226,225,264 ,282,272,274 }, {455,384,407 ,2,2,2 ,305,282,304 },
		{455,432,384 ,2,2,2 ,305,306,282 }, {433,384,432 ,2,2,2 ,307,282,306 },
		{433,385,384 ,2,2,2 ,307,281,282 }, {434,385,433 ,2,2,2 ,308,281,307 },
		{434,386,385 ,2,2,2 ,308,283,281 }, {435,386,434 ,2,2,2 ,309,283,308 },
		{435,387,386 ,2,2,2 ,309,284,283 }, {436,387,435 ,2,2,2 ,310,284,309 },
		{436,388,387 ,2,2,2 ,310,285,284 }, {437,388,436 ,2,2,2 ,311,285,310 },
		{437,389,388 ,2,2,2 ,311,286,285 }, {438,389,437 ,2,2,2 ,312,286,311 },
		{438,390,389 ,2,2,2 ,312,287,286 }, {391,438,439 ,2,2,2 ,288,312,313 },
		{391,390,438 ,2,2,2 ,288,287,312 }, {392,439,440 ,2,2,2 ,289,313,314 },
		{392,391,439 ,2,2,2 ,289,288,313 }, {393,440,441 ,2,2,2 ,290,314,315 },
		{393,392,440 ,2,2,2 ,290,289,314 }, {394,441,442 ,2,2,2 ,291,315,316 },
		{394,393,441 ,2,2,2 ,291,290,315 }, {395,442,443 ,2,2,2 ,292,316,317 },
		{395,394,442 ,2,2,2 ,292,291,316 }, {396,443,444 ,2,2,2 ,293,317,318 },
		{396,395,443 ,2,2,2 ,293,292,317 }, {396,445,397 ,2,2,2 ,293,319,294 },
		{396,444,445 ,2,2,2 ,293,318,319 }, {397,446,398 ,2,2,2 ,294,320,295 },
		{397,445,446 ,2,2,2 ,294,319,320 }, {398,447,399 ,2,2,2 ,295,321,296 },
		{398,446,447 ,2,2,2 ,295,320,321 }, {399,448,400 ,2,2,2 ,296,322,297 },
		{399,447,448 ,2,2,2 ,296,321,322 }, {400,449,401 ,2,2,2 ,297,323,298 },
		{400,448,449 ,2,2,2 ,297,322,323 }, {401,450,402 ,2,2,2 ,298,324,299 },
		{401,449,450 ,2,2,2 ,298,323,324 }, {450,403,402 ,2,2,2 ,324,300,299 },
		{450,451,403 ,2,2,2 ,324,325,300 }, {451,404,403 ,2,2,2 ,325,301,300 },
		{451,452,404 ,2,2,2 ,325,326,301 }, {452,405,404 ,2,2,2 ,326,302,301 },
		{452,453,405 ,2,2,2 ,326,327,302 }, {453,406,405 ,2,2,2 ,327,303,302 },
		{453,454,406 ,2,2,2 ,327,328,303 }, {454,407,406 ,2,2,2 ,328,304,303 },
		{454,455,407 ,2,2,2 ,328,305,304 }, {456,455,479 ,265,264,266 ,329,305,330 },
		{456,432,455 ,265,267,264 ,329,306,305 }, {457,432,456 ,268,267,265 ,331,306,329 },
		{457,433,432 ,268,269,267 ,331,307,306 }, {458,433,457 ,46,269,268 ,332,307,331 },
		{458,434,433 ,46,270,269 ,332,308,307 }, {459,434,458 ,271,270,46 ,333,308,332 },
		{459,435,434 ,271,272,270 ,333,309,308 }, {460,435,459 ,273,272,271 ,334,309,333 },
		{460,436,435 ,273,274,272 ,334,310,309 }, {461,436,460 ,275,274,273 ,335,310,334 },
		{461,437,436 ,275,276,274 ,335,311,310 }, {462,437,461 ,14,276,275 ,336,311,335 },
		{462,438,437 ,14,14,276 ,336,312,311 }, {439,462,463 ,277,14,278 ,313,336,337 },
		{439,438,462 ,277,14,14 ,313,312,336 }, {440,463,464 ,279,278,280 ,314,337,338 },
		{440,439,463 ,279,277,278 ,314,313,337 }, {441,464,465 ,281,280,282 ,315,338,339 },
		{441,440,464 ,281,279,280 ,315,314,338 }, {442,465,466 ,283,282,5 ,316,339,340 },
		{442,441,465 ,283,281,282 ,316,315,339 }, {443,466,467 ,284,5,285 ,317,340,341 },
		{443,442,466 ,284,283,5 ,317,316,340 }, {444,467,468 ,286,285,287 ,318,341,342 },
		{444,443,467 ,286,284,285 ,318,317,341 }, {445,468,469 ,247,287,288 ,319,342,343 },
		{445,444,468 ,247,286,287 ,319,318,342 }, {446,469,470 ,289,288,290 ,320,343,344 },
		{446,445,469 ,289,247,288 ,320,319,343 }, {447,470,471 ,291,290,292 ,321,344,345 },
		{447,446,470 ,291,289,290 ,321,320,344 }, {448,471,472 ,293,292,294 ,322,345,346 },
		{448,447,471 ,293,291,292 ,322,321,345 }, {449,472,473 ,295,294,296 ,323,346,347 },
		{449,448,472 ,295,293,294 ,323,322,346 }, {450,473,474 ,0,296,0 ,324,347,348 },
		{450,449,473 ,0,295,296 ,324,323,347 }, {475,450,474 ,297,0,0 ,349,324,348 },
		{475,451,450 ,297,298,0 ,349,325,324 }, {476,451,475 ,299,298,297 ,350,325,349 },
		{476,452,451 ,299,300,298 ,350,326,325 }, {477,452,476 ,301,300,299 ,351,326,350 },
		{477,453,452 ,301,302,300 ,351,327,326 }, {478,453,477 ,303,302,301 ,352,327,351 },
		{478,454,453 ,303,304,302 ,352,328,327 }, {479,454,478 ,266,304,303 ,330,328,352 },
		{479,455,454 ,266,264,304 ,330,305,328 }, {3,887,889 ,195,195,195 ,353,354,355 },
		{3,1,887 ,195,195,195 ,353,356,354 }, {0,887,1 ,14,14,14 ,357,354,356 },
		{0,886,887 ,14,14,14 ,357,358,354 }, {0,888,886 ,194,194,194 ,357,359,358 },
		{0,2,888 ,194,194,194 ,357,360,359 }, {3,888,2 ,0,0,0 ,353,359,360 },
		{3,889,888 ,0,0,0 ,353,355,359 }, {2,1,3 ,1,1,1 ,360,356,353 },
		{2,0,1 ,1,1,1 ,360,357,356 }, {31,6,7 ,305,306,307 ,361,362,363 },
		{31,30,6 ,305,308,306 ,361,364,362 }, {541,546,547 ,309,310,311 ,365,366,367 },
		{541,540,546 ,309,310,310 ,365,368,366 }, {546,536,542 ,312,312,312 ,366,369,370 },
		{546,540,536 ,312,312,312 ,366,368,369 }, {543,536,537 ,313,314,315 ,371,369,372 },
		{543,542,536 ,313,314,314 ,371,370,369 }, {544,537,538 ,316,315,317 ,373,372,374 },
		{544,543,537 ,316,313,315 ,373,371,372 }, {547,539,541 ,311,318,309 ,367,375,365 },
		{547,545,539 ,311,319,318 ,367,376,375 }, {545,538,539 ,319,317,318 ,376,377,375 },
		{545,544,538 ,319,316,317 ,376,378,377 }, {59,83,52 ,0,0,0 ,379,380,381 },
		{59,60,83 ,0,0,0 ,379,382,380 }, {57,61,58 ,0,0,0 ,383,384,385 },
		{57,85,61 ,0,0,0 ,383,386,384 }, {60,62,83 ,0,0,0 ,382,387,388 },
		{85,63,61 ,0,0,0 ,389,390,391 }, {83,87,52 ,195,195,195 ,392,393,394 },
		{83,82,87 ,195,195,195 ,392,395,393 }, {54,64,53 ,1,1,1 ,396,397,398 },
		{54,65,64 ,1,1,1 ,396,399,397 }, {56,66,55 ,1,1,1 ,400,401,402 },
		{56,67,66 ,1,1,1 ,400,403,401 }, {86,85,57 ,194,194,194 ,404,405,406 },
		{86,84,85 ,194,194,194 ,404,407,405 }, {82,69,87 ,14,14,14 ,395,408,393 },
		{82,70,69 ,14,14,14 ,395,409,408 }, {71,86,68 ,14,14,14 ,410,404,411 },
		{71,84,86 ,14,14,14 ,410,407,404 }, {82,72,70 ,14,14,14 ,395,412,409 },
		{73,84,71 ,14,14,14 ,413,407,410 }, {71,63,73 ,320,321,322 ,410,414,413 },
		{71,61,63 ,320,323,321 ,410,415,414 }, {70,62,60 ,324,325,326 ,409,416,417 },
		{70,72,62 ,324,327,325 ,409,412,416 }, {74,64,65 ,14,14,14 ,418,397,399 },
		{74,82,64 ,14,14,14 ,418,395,397 }, {72,82,74 ,14,14,14 ,412,395,418 },
		{84,66,67 ,14,14,14 ,407,401,403 }, {84,75,66 ,14,14,14 ,407,419,401 },
		{84,73,75 ,14,14,14 ,407,413,419 }, {53,76,54 ,0,0,0 ,420,421,422 },
		{53,83,76 ,0,0,0 ,420,423,421 }, {83,62,76 ,0,0,0 ,424,425,426 },
		{55,85,56 ,0,0,0 ,427,428,429 }, {55,77,85 ,0,0,0 ,427,430,428 },
		{63,85,77 ,0,0,0 ,431,432,433 }, {82,53,64 ,195,195,195 ,395,398,397 },
		{82,83,53 ,195,195,195 ,395,392,398 }, {56,84,67 ,194,194,194 ,400,407,403 },
		{56,85,84 ,194,194,194 ,400,405,407 }, {77,73,63 ,328,322,321 ,434,413,414 },
		{77,75,73 ,328,328,322 ,434,419,413 }, {66,77,55 ,329,328,329 ,401,434,402 },
		{66,75,77 ,329,328,328 ,401,419,434 }, {76,65,54 ,330,331,331 ,435,399,396 },
		{76,74,65 ,330,330,331 ,435,418,399 }, {72,76,62 ,327,330,325 ,412,435,416 },
		{72,74,76 ,327,330,330 ,412,418,435 }, {61,78,58 ,0,0,0 ,436,437,385 },
		{61,80,78 ,0,0,0 ,436,438,437 }, {80,59,78 ,0,0,0 ,439,379,437 },
		{80,60,59 ,0,0,0 ,439,440,379 }, {81,68,79 ,14,14,14 ,441,411,442 },
		{81,71,68 ,14,14,14 ,441,410,411 }, {70,79,69 ,14,14,14 ,409,442,408 },
		{70,81,79 ,14,14,14 ,409,441,442 }, {81,60,80 ,332,326,333 ,441,417,443 },
		{81,70,60 ,332,324,326 ,441,409,417 }, {80,71,81 ,333,320,332 ,443,410,441 },
		{80,61,71 ,333,323,320 ,443,415,410 }, {483,481,480 ,334,335,336 ,444,445,446 },
		{483,482,481 ,334,337,335 ,444,447,445 }, {481,484,480 ,335,338,336 ,445,448,446 },
		{481,485,484 ,335,339,338 ,445,449,448 }, {486,485,481 ,340,339,335 ,450,449,445 },
		{487,486,481 ,341,340,335 ,451,450,445 }, {482,487,481 ,337,341,335 ,447,451,445 },
		{482,488,487 ,337,342,341 ,447,452,451 }, {489,488,482 ,343,342,337 ,453,452,447 },
		{490,489,482 ,344,343,337 ,454,453,447 }, {491,482,483 ,345,337,334 ,455,447,444 },
		{491,490,482 ,345,344,337 ,455,454,447 }, {492,491,483 ,346,345,334 ,456,455,444 },
		{493,492,483 ,347,346,334 ,457,456,444 }, {494,483,480 ,348,334,336 ,458,444,446 },
		{494,493,483 ,348,347,334 ,458,457,444 }, {495,494,480 ,349,348,336 ,459,458,446 },
		{484,495,480 ,338,349,336 ,448,459,446 }, {485,496,484 ,339,350,338 ,449,460,448 },
		{485,497,496 ,339,351,350 ,449,461,460 }, {486,497,485 ,340,351,339 ,450,462,449 },
		{486,498,497 ,340,352,351 ,450,463,462 }, {487,498,486 ,341,352,340 ,451,464,450 },
		{487,499,498 ,341,353,352 ,451,465,464 }, {488,499,487 ,342,353,341 ,452,466,451 },
		{488,500,499 ,342,354,353 ,452,467,466 }, {489,500,488 ,343,354,342 ,453,468,452 },
		{489,501,500 ,343,355,354 ,453,469,468 }, {490,501,489 ,344,355,343 ,454,470,453 },
		{490,502,501 ,344,356,355 ,454,471,470 }, {503,490,491 ,357,344,345 ,472,454,455 },
		{503,502,490 ,357,356,344 ,472,471,454 }, {504,491,492 ,358,345,346 ,473,455,456 },
		{504,503,491 ,358,357,345 ,473,474,455 }, {505,492,493 ,359,346,347 ,475,456,457 },
		{505,504,492 ,359,358,346 ,475,476,456 }, {506,493,494 ,360,347,348 ,477,457,458 },
		{506,505,493 ,360,359,347 ,477,478,457 }, {507,494,495 ,361,348,349 ,479,458,459 },
		{507,506,494 ,361,360,348 ,479,480,458 }, {496,495,484 ,350,349,338 ,460,459,448 },
		{496,507,495 ,350,361,349 ,460,481,459 }, {497,508,496 ,351,362,350 ,462,482,460 },
		{497,509,508 ,351,363,362 ,462,483,482 }, {498,509,497 ,352,363,351 ,464,483,462 },
		{498,510,509 ,352,364,363 ,464,484,483 }, {499,510,498 ,353,364,352 ,466,484,464 },
		{499,511,510 ,353,365,364 ,466,485,484 }, {500,511,499 ,354,365,353 ,468,485,466 },
		{500,512,511 ,354,366,365 ,468,486,485 }, {501,512,500 ,355,366,354 ,470,486,468 },
		{501,513,512 ,355,367,366 ,470,487,486 }, {502,513,501 ,356,367,355 ,471,487,470 },
		{502,514,513 ,356,368,367 ,471,488,487 }, {515,502,503 ,369,356,357 ,489,471,474 },
		{515,514,502 ,369,368,356 ,489,488,471 }, {516,503,504 ,370,357,358 ,490,474,476 },
		{516,515,503 ,370,369,357 ,490,489,474 }, {517,504,505 ,371,358,359 ,491,476,478 },
		{517,516,504 ,371,370,358 ,491,490,476 }, {518,505,506 ,372,359,360 ,492,478,480 },
		{518,517,505 ,372,371,359 ,492,491,478 }, {519,506,507 ,373,360,361 ,493,480,494 },
		{519,518,506 ,373,372,360 ,493,492,480 }, {508,507,496 ,362,361,350 ,482,494,460 },
		{508,519,507 ,362,373,361 ,482,493,494 }, {509,520,508 ,363,374,362 ,461,495,460 },
		{509,521,520 ,363,375,374 ,461,496,495 }, {510,521,509 ,364,375,363 ,497,496,498 },
		{510,522,521 ,364,376,375 ,497,499,496 }, {511,522,510 ,365,376,364 ,500,499,501 },
		{511,523,522 ,365,377,376 ,500,502,499 }, {512,523,511 ,366,377,365 ,503,502,504 },
		{512,524,523 ,366,378,377 ,503,505,502 }, {513,524,512 ,367,378,366 ,469,505,506 },
		{513,525,524 ,367,379,378 ,469,453,505 }, {514,525,513 ,368,379,367 ,471,453,470 },
		{514,526,525 ,368,380,379 ,471,454,453 }, {527,514,515 ,381,368,369 ,455,507,472 },
		{527,526,514 ,381,380,368 ,455,454,507 }, {528,515,516 ,382,369,370 ,508,509,510 },
		{528,527,515 ,382,381,369 ,508,455,509 }, {529,516,517 ,383,370,371 ,511,512,513 },
		{529,528,516 ,383,382,370 ,511,508,512 }, {530,517,518 ,384,371,372 ,514,515,516 },
		{530,529,517 ,384,383,371 ,514,511,515 }, {531,518,519 ,385,372,373 ,517,518,519 },
		{531,530,518 ,385,384,372 ,517,514,518 }, {520,519,508 ,374,373,362 ,495,520,521 },
		{520,531,519 ,374,385,373 ,495,517,520 }, {521,532,520 ,375,386,374 ,496,522,495 },
		{521,533,532 ,375,387,386 ,496,523,522 }, {522,533,521 ,376,387,375 ,499,523,496 },
		{523,533,522 ,377,387,376 ,502,523,499 }, {524,533,523 ,378,387,377 ,505,523,502 },
		{524,534,533 ,378,388,387 ,505,524,523 }, {525,534,524 ,379,388,378 ,453,524,505 },
		{526,534,525 ,380,388,379 ,454,524,453 }, {535,526,527 ,389,380,381 ,525,454,455 },
		{535,534,526 ,389,388,380 ,525,524,454 }, {535,527,528 ,389,381,382 ,525,455,508 },
		{535,528,529 ,389,382,383 ,525,508,511 }, {532,529,530 ,386,383,384 ,522,511,514 },
		{532,535,529 ,386,389,383 ,522,525,511 }, {532,530,531 ,386,384,385 ,522,514,517 },
		{532,531,520 ,386,385,374 ,522,517,495 }, {533,535,532 ,387,389,386 ,523,525,522 },
		{533,534,535 ,387,388,389 ,523,524,525 }, {541,536,540 ,1,1,1 ,526,527,528 },
		{541,537,536 ,1,1,1 ,526,529,527 }, {539,537,541 ,1,1,1 ,375,530,531 },
		{539,538,537 ,1,1,1 ,375,532,530 }, {542,547,546 ,2,2,2 ,370,533,366 },
		{542,543,547 ,2,2,2 ,370,534,533 }, {544,547,543 ,2,2,2 ,535,536,537 },
		{544,545,547 ,2,2,2 ,535,376,536 }, {553,558,559 ,390,391,392 ,538,539,540 },
		{553,552,558 ,390,391,391 ,538,541,539 }, {558,548,554 ,393,393,393 ,539,542,543 },
		{558,552,548 ,393,393,393 ,539,541,542 }, {555,548,549 ,394,395,396 ,544,542,545 },
		{555,554,548 ,394,395,395 ,544,543,542 }, {556,549,550 ,397,396,398 ,546,545,547 },
		{556,555,549 ,397,394,396 ,546,544,545 }, {559,551,553 ,392,399,390 ,540,548,538 },
		{559,557,551 ,392,400,399 ,540,549,548 }, {557,550,551 ,400,398,399 ,549,550,548 },
		{557,556,550 ,400,397,398 ,549,551,550 }, {553,548,552 ,1,1,1 ,552,553,554 },
		{553,549,548 ,1,1,1 ,552,555,553 }, {551,549,553 ,1,1,1 ,548,556,557 },
		{551,550,549 ,1,1,1 ,548,558,556 }, {554,559,558 ,2,2,2 ,543,559,539 },
		{554,555,559 ,2,2,2 ,543,560,559 }, {556,559,555 ,2,2,2 ,561,562,563 },
		{556,557,559 ,2,2,2 ,561,549,562 }, {689,688,690 ,195,195,195 ,564,565,566 },
		{690,688,691 ,195,195,195 ,566,565,567 }, {687,691,688 ,195,195,195 ,568,567,565 },
		{692,691,687 ,195,195,195 ,569,567,568 }, {686,692,687 ,195,195,195 ,570,569,568 },
		{693,692,686 ,195,195,195 ,571,569,570 }, {685,693,686 ,195,195,195 ,572,571,570 },
		{684,693,685 ,195,195,195 ,573,571,572 }, {699,700,698 ,194,194,194 ,574,575,576 },
		{698,700,697 ,194,194,194 ,576,575,577 }, {701,697,700 ,194,194,194 ,578,577,575 },
		{696,697,701 ,194,194,194 ,579,577,578 }, {702,696,701 ,194,194,194 ,580,579,578 },
		{695,696,702 ,194,194,194 ,581,579,580 }, {703,695,702 ,194,194,194 ,582,581,580 },
		{694,695,703 ,194,194,194 ,583,581,582 }, {704,713,705 ,401,402,195 ,584,585,586 },
		{705,713,706 ,195,402,195 ,586,585,587 }, {713,712,706 ,402,403,195 ,585,588,587 },
		{706,712,707 ,195,403,195 ,587,588,589 }, {712,711,707 ,403,404,195 ,588,590,589 },
		{707,711,708 ,195,404,195 ,589,590,591 }, {710,708,711 ,405,195,404 ,592,591,590 },
		{709,708,710 ,406,195,405 ,593,591,592 }, {724,733,725 ,407,408,409 ,594,595,596 },
		{732,725,733 ,410,409,408 ,597,596,595 }, {725,732,726 ,409,410,411 ,596,597,598 },
		{731,726,732 ,412,411,410 ,599,598,597 }, {726,731,727 ,411,412,413 ,598,599,600 },
		{730,727,731 ,414,413,412 ,601,600,599 }, {727,730,728 ,413,414,415 ,600,601,602 },
		{729,728,730 ,416,415,414 ,603,602,601 }, {788,789,772 ,194,194,194 ,604,605,606 },
		{771,772,789 ,194,194,194 ,607,606,605 }, {771,773,772 ,194,194,194 ,607,608,606 },
		{770,773,771 ,194,194,194 ,609,608,607 }, {770,774,773 ,194,194,194 ,609,610,608 },
		{787,774,770 ,194,194,194 ,611,610,609 }, {787,775,774 ,194,194,194 ,611,612,610 },
		{775,787,786 ,194,194,194 ,612,611,613 }, {781,779,780 ,195,195,195 ,614,615,616 },
		{779,781,778 ,195,195,195 ,615,614,617 }, {782,778,781 ,195,195,195 ,618,617,614 },
		{783,778,782 ,195,195,195 ,619,617,618 }, {783,777,778 ,195,195,195 ,619,620,617 },
		{784,777,783 ,195,195,195 ,621,620,619 }, {777,784,776 ,195,195,195 ,620,621,622 },
		{785,776,784 ,195,195,195 ,623,622,621 }, {834,851,850 ,195,195,195 ,624,625,626 },
		{851,834,833 ,195,195,195 ,625,624,627 }, {835,833,834 ,195,195,195 ,628,627,624 },
		{836,833,835 ,195,195,195 ,629,627,628 }, {836,832,833 ,195,195,195 ,629,630,627 },
		{837,832,836 ,195,195,195 ,631,630,629 }, {832,837,849 ,195,195,195 ,630,631,632 },
		{848,849,837 ,195,195,195 ,633,632,631 }, {842,841,843 ,194,194,194 ,634,635,636 },
		{840,843,841 ,194,194,194 ,637,636,635 }, {840,844,843 ,194,194,194 ,637,638,636 },
		{839,844,840 ,194,194,194 ,639,638,637 }, {839,845,844 ,194,194,194 ,639,640,638 },
		{838,845,839 ,194,194,194 ,641,640,639 }, {838,846,845 ,194,194,194 ,641,642,640 },
		{846,838,847 ,194,194,194 ,642,641,643 }, {561,566,560 ,417,418,419 ,644,645,646 },
		{561,567,566 ,417,417,418 ,644,647,645 }, {568,561,562 ,420,417,421 ,648,644,649 },
		{568,567,561 ,420,417,417 ,648,647,644 }, {569,562,563 ,422,421,423 ,650,649,651 },
		{569,568,562 ,422,420,421 ,650,648,649 }, {570,563,564 ,424,423,425 ,652,653,654 },
		{570,569,563 ,424,422,423 ,652,655,653 }, {571,564,565 ,426,425,426 ,656,654,657 },
		{571,570,564 ,426,424,425 ,656,652,654 }, {560,571,565 ,419,426,426 ,646,656,657 },
		{560,566,571 ,419,418,426 ,646,645,656 }, {572,575,573 ,14,14,14 ,658,659,660 },
		{572,574,575 ,14,14,14 ,658,661,659 }, {577,575,579 ,195,195,195 ,662,659,663 },
		{577,573,575 ,195,195,195 ,662,660,659 }, {577,578,576 ,0,0,0 ,662,664,665 },
		{577,579,578 ,0,0,0 ,662,663,664 }, {576,574,572 ,194,194,194 ,665,661,658 },
		{576,578,574 ,194,194,194 ,665,664,661 }, {576,573,577 ,1,1,1 ,665,660,662 },
		{576,572,573 ,1,1,1 ,665,658,660 }, {583,581,580 ,195,195,195 ,666,667,668 },
		{583,582,581 ,195,195,195 ,666,669,667 }, {581,584,580 ,2,2,2 ,670,671,672 },
		{581,585,584 ,2,2,2 ,670,673,671 }, {582,585,581 ,14,14,14 ,674,675,676 },
		{582,586,585 ,14,14,14 ,674,677,675 }, {587,582,583 ,1,1,1 ,678,679,680 },
		{587,586,582 ,1,1,1 ,678,681,679 }, {584,583,580 ,0,0,0 ,682,683,684 },
		{584,587,583 ,0,0,0 ,682,685,683 }, {585,587,584 ,194,194,194 ,686,687,688 },
		{585,586,587 ,194,194,194 ,686,689,687 }, {591,589,588 ,0,0,0 ,690,691,692 },
		{591,590,589 ,0,0,0 ,690,693,691 }, {589,592,588 ,427,428,427 ,694,695,696 },
		{589,593,592 ,427,429,428 ,694,697,695 }, {590,593,589 ,430,429,430 ,698,699,700 },
		{590,594,593 ,430,431,429 ,698,701,699 }, {595,590,591 ,432,433,433 ,702,703,704 },
		{595,594,590 ,432,431,433 ,702,701,703 }, {592,591,588 ,428,434,434 ,705,706,707 },
		{592,595,591 ,428,432,434 ,705,708,706 }, {793,791,790 ,435,436,437 ,709,710,711 },
		{793,792,791 ,435,438,436 ,709,712,710 }, {599,597,596 ,439,439,439 ,713,714,715 },
		{599,598,597 ,439,439,439 ,713,716,714 }, {597,600,596 ,440,440,440 ,714,717,715 },
		{597,601,600 ,440,440,440 ,714,718,717 }, {603,598,599 ,441,441,441 ,719,720,713 },
		{603,602,598 ,441,441,441 ,719,721,720 }, {601,603,600 ,442,442,442 ,722,719,717 },
		{601,602,603 ,442,442,442 ,722,723,719 }, {607,605,604 ,0,0,0 ,724,725,726 },
		{607,606,605 ,0,0,0 ,724,727,725 }, {605,608,604 ,195,195,195 ,728,729,730 },
		{605,609,608 ,195,195,195 ,728,731,729 }, {611,606,607 ,194,194,194 ,732,733,734 },
		{611,610,606 ,194,194,194 ,732,735,733 }, {609,611,608 ,14,14,14 ,736,737,738 },
		{609,610,611 ,14,14,14 ,736,739,737 }, {615,613,612 ,443,443,443 ,740,741,742 },
		{615,614,613 ,443,443,443 ,740,743,741 }, {613,616,612 ,444,444,444 ,741,744,742 },
		{613,617,616 ,444,444,444 ,741,745,744 }, {619,614,615 ,445,445,445 ,746,743,740 },
		{619,618,614 ,445,445,445 ,746,747,743 }, {617,619,616 ,446,446,446 ,745,746,744 },
		{617,618,619 ,446,446,446 ,745,747,746 }, {623,621,620 ,447,447,447 ,748,749,750 },
		{623,622,621 ,447,447,447 ,748,751,749 }, {621,624,620 ,207,207,207 ,749,752,750 },
		{621,625,624 ,207,207,207 ,749,753,752 }, {627,622,623 ,448,448,448 ,754,755,748 },
		{627,626,622 ,448,448,448 ,754,756,755 }, {625,627,624 ,449,449,449 ,757,754,752 },
		{625,626,627 ,449,449,449 ,757,758,754 }, {629,631,628 ,450,450,450 ,759,760,761 },
		{629,630,631 ,450,450,450 ,759,762,760 }, {632,629,628 ,451,451,451 ,763,764,765 },
		{632,633,629 ,451,451,451 ,763,766,764 }, {630,635,631 ,452,452,452 ,767,768,769 },
		{630,634,635 ,452,452,452 ,767,770,768 }, {635,633,632 ,453,453,453 ,768,771,772 },
		{635,634,633 ,453,453,453 ,768,770,771 }, {637,639,636 ,0,0,0 ,773,774,775 },
		{637,638,639 ,0,0,0 ,773,776,774 }, {640,637,636 ,194,194,194 ,777,778,779 },
		{640,641,637 ,194,194,194 ,777,780,778 }, {638,643,639 ,195,195,195 ,781,782,783 },
		{638,642,643 ,195,195,195 ,781,784,782 }, {643,641,640 ,14,14,14 ,785,786,787 },
		{643,642,641 ,14,14,14 ,785,788,786 }, {645,647,644 ,454,454,454 ,789,790,791 },
		{645,646,647 ,454,454,454 ,789,792,790 }, {648,645,644 ,455,455,455 ,793,789,791 },
		{648,649,645 ,455,455,455 ,793,794,789 }, {646,651,647 ,456,456,456 ,792,795,790 },
		{646,650,651 ,456,456,456 ,792,796,795 }, {651,649,648 ,457,457,457 ,795,794,793 },
		{651,650,649 ,457,457,457 ,795,796,794 }, {653,655,652 ,458,458,458 ,797,798,799 },
		{653,654,655 ,458,458,458 ,797,800,798 }, {656,653,652 ,219,219,219 ,801,802,803 },
		{656,657,653 ,219,219,219 ,801,804,802 }, {654,659,655 ,459,459,459 ,805,806,807 },
		{654,658,659 ,459,459,459 ,805,808,806 }, {659,657,656 ,460,460,460 ,809,810,811 },
		{659,658,657 ,460,460,460 ,809,812,810 }, {663,661,660 ,0,0,0 ,813,814,815 },
		{663,662,661 ,0,0,0 ,813,816,814 }, {661,664,660 ,195,195,195 ,817,818,819 },
		{661,665,664 ,195,195,195 ,817,820,818 }, {662,665,661 ,1,1,1 ,821,822,823 },
		{662,666,665 ,1,1,1 ,821,824,822 }, {667,662,663 ,194,194,194 ,825,826,827 },
		{667,666,662 ,194,194,194 ,825,828,826 }, {664,663,660 ,2,2,2 ,829,830,831 },
		{664,667,663 ,2,2,2 ,829,832,830 }, {665,667,664 ,14,14,14 ,833,834,835 },
		{665,666,667 ,14,14,14 ,833,836,834 }, {669,671,668 ,0,0,0 ,837,838,839 },
		{669,670,671 ,0,0,0 ,837,840,838 }, {672,669,668 ,194,194,194 ,841,842,843 },
		{672,673,669 ,194,194,194 ,841,844,842 }, {673,670,669 ,1,1,1 ,845,846,847 },
		{673,674,670 ,1,1,1 ,845,848,846 }, {670,675,671 ,195,195,195 ,849,850,851 },
		{670,674,675 ,195,195,195 ,849,852,850 }, {671,672,668 ,2,2,2 ,853,854,855 },
		{671,675,672 ,2,2,2 ,853,856,854 }, {675,673,672 ,14,14,14 ,857,858,859 },
		{675,674,673 ,14,14,14 ,857,860,858 }, {679,678,677 ,0,0,0 ,861,862,863 },
		{679,677,676 ,0,0,0 ,861,863,864 }, {677,681,680 ,195,195,195 ,865,866,867 },
		{677,680,676 ,195,195,195 ,865,867,868 }, {678,682,681 ,1,1,1 ,869,870,871 },
		{678,681,677 ,1,1,1 ,869,871,872 }, {683,682,678 ,194,194,194 ,873,874,875 },
		{683,678,679 ,194,194,194 ,873,875,876 }, {680,683,679 ,2,2,2 ,877,878,879 },
		{680,679,676 ,2,2,2 ,877,879,880 }, {681,682,683 ,14,14,14 ,881,882,883 },
		{681,683,680 ,14,14,14 ,881,883,884 }, {684,685,695 ,461,462,463 ,885,886,887 },
		{684,695,694 ,461,463,464 ,885,887,888 }, {685,686,696 ,462,465,465 ,889,890,891 },
		{685,696,695 ,462,465,463 ,889,891,892 }, {696,686,687 ,465,465,466 ,891,890,893 },
		{696,687,697 ,465,466,467 ,891,893,894 }, {697,687,688 ,467,466,468 ,894,893,895 },
		{697,688,698 ,467,468,469 ,894,895,896 }, {698,688,689 ,469,468,470 ,897,898,899 },
		{698,689,699 ,469,470,471 ,897,899,900 }, {699,689,690 ,471,470,472 ,900,899,901 },
		{699,690,700 ,471,472,473 ,900,901,902 }, {700,690,691 ,473,472,474 ,903,904,905 },
		{700,691,701 ,473,474,474 ,903,905,906 }, {691,692,702 ,474,475,476 ,905,907,908 },
		{691,702,701 ,474,476,474 ,905,908,906 }, {692,693,703 ,475,477,478 ,907,909,910 },
		{692,703,702 ,475,478,476 ,907,910,908 }, {693,684,694 ,477,461,464 ,911,885,888 },
		{693,694,703 ,477,464,478 ,911,888,912 }, {704,715,714 ,401,479,480 ,913,914,915 },
		{704,705,715 ,401,481,479 ,913,916,914 }, {705,716,715 ,481,482,479 ,917,918,919 },
		{705,706,716 ,481,483,482 ,917,920,918 }, {716,707,717 ,482,484,485 ,918,921,922 },
		{716,706,707 ,482,483,484 ,918,920,921 }, {717,708,718 ,485,486,487 ,922,923,924 },
		{717,707,708 ,485,484,486 ,922,921,923 }, {718,709,719 ,487,406,488 ,925,926,927 },
		{718,708,709 ,487,486,406 ,925,928,926 }, {719,710,720 ,488,405,489 ,927,929,930 },
		{719,709,710 ,488,406,405 ,927,926,929 }, {720,711,721 ,489,404,490 ,931,932,933 },
		{720,710,711 ,489,405,404 ,931,934,932 }, {711,722,721 ,404,491,490 ,932,935,933 },
		{711,712,722 ,404,403,491 ,932,936,935 }, {712,723,722 ,403,492,491 ,936,937,935 },
		{712,713,723 ,403,402,492 ,936,938,937 }, {713,714,723 ,402,480,492 ,939,915,940 },
		{713,704,714 ,402,401,480 ,939,913,915 }, {714,733,724 ,480,408,407 ,941,595,942 },
		{714,715,733 ,480,479,408 ,941,943,595 }, {714,725,723 ,480,409,492 ,915,944,940 },
		{714,724,725 ,480,407,409 ,915,945,944 }, {723,726,722 ,492,411,491 ,946,947,935 },
		{723,725,726 ,492,409,411 ,946,948,947 }, {722,727,721 ,491,413,490 ,935,949,933 },
		{722,726,727 ,491,411,413 ,935,947,949 }, {727,720,721 ,413,489,490 ,949,950,933 },
		{727,728,720 ,413,415,489 ,949,951,950 }, {728,719,720 ,415,488,489 ,952,927,930 },
		{728,729,719 ,415,416,488 ,952,953,927 }, {729,718,719 ,416,487,488 ,954,955,956 },
		{729,730,718 ,416,414,487 ,954,601,955 }, {731,718,730 ,412,487,414 ,599,957,601 },
		{731,717,718 ,412,485,487 ,599,922,957 }, {732,717,731 ,410,485,412 ,597,922,599 },
		{732,716,717 ,410,482,485 ,597,918,922 }, {715,732,733 ,479,410,408 ,958,597,595 },
		{715,716,732 ,479,482,410 ,958,918,597 }, {737,735,734 ,0,0,0 ,959,960,961 },
		{737,736,735 ,0,0,0 ,959,962,960 }, {735,738,734 ,195,195,195 ,963,964,965 },
		{735,739,738 ,195,195,195 ,963,966,964 }, {736,739,735 ,1,1,1 ,967,968,969 },
		{736,740,739 ,1,1,1 ,967,970,968 }, {741,736,737 ,194,194,194 ,971,972,973 },
		{741,740,736 ,194,194,194 ,971,974,972 }, {738,737,734 ,2,2,2 ,975,976,977 },
		{738,741,737 ,2,2,2 ,975,978,976 }, {739,741,738 ,14,14,14 ,979,980,981 },
		{739,740,741 ,14,14,14 ,979,982,980 }, {745,743,742 ,0,0,0 ,983,984,985 },
		{745,744,743 ,0,0,0 ,983,986,984 }, {743,746,742 ,195,195,195 ,987,988,989 },
		{743,747,746 ,195,195,195 ,987,990,988 }, {744,747,743 ,1,1,1 ,991,992,993 },
		{744,748,747 ,1,1,1 ,991,994,992 }, {749,744,745 ,194,194,194 ,995,996,997 },
		{749,748,744 ,194,194,194 ,995,998,996 }, {746,745,742 ,2,2,2 ,999,1000,1001 },
		{746,749,745 ,2,2,2 ,999,1002,1000 }, {747,749,746 ,14,14,14 ,1003,1004,1005 },
		{747,748,749 ,14,14,14 ,1003,1006,1004 }, {750,753,752 ,493,494,495 ,1007,1008,1009 },
		{750,751,753 ,493,496,494 ,1007,1010,1008 }, {750,757,754 ,493,497,498 ,1011,1012,1013 },
		{750,752,757 ,493,495,497 ,1011,1014,1012 }, {788,755,789 ,194,194,194 ,604,1015,605 },
		{788,751,755 ,194,194,194 ,604,1016,1015 }, {754,756,755 ,498,499,500 ,1017,1018,1019 },
		{754,757,756 ,498,497,499 ,1017,1012,1018 }, {755,758,789 ,500,501,502 ,1020,1021,1022 },
		{755,756,758 ,500,499,501 ,1020,1023,1021 }, {751,759,753 ,496,1,494 ,1024,1025,1008 },
		{751,788,759 ,496,503,1 ,1024,1026,1025 }, {751,754,755 ,194,194,194 ,1016,1027,1015 },
		{751,750,754 ,194,194,194 ,1016,1028,1027 }, {763,760,762 ,504,505,506 ,1029,1030,1031 },
		{763,761,760 ,504,507,505 ,1029,1032,1030 }, {767,760,764 ,508,505,509 ,1033,1034,1035 },
		{767,762,760 ,508,506,505 ,1033,1036,1034 }, {765,786,787 ,194,194,194 ,1037,613,611 },
		{765,761,786 ,194,194,194 ,1037,1038,613 }, {766,764,765 ,510,509,511 ,1039,1040,1041 },
		{766,767,764 ,510,508,509 ,1039,1033,1040 }, {768,765,787 ,512,511,513 ,1042,1043,1044 },
		{768,766,765 ,512,510,511 ,1042,1045,1043 }, {769,761,763 ,1,507,504 ,1046,1047,1029 },
		{769,786,761 ,1,514,507 ,1046,1048,1047 }, {764,761,765 ,194,194,194 ,1049,1038,1037 },
		{764,760,761 ,194,194,194 ,1049,1050,1038 }, {593,790,592 ,429,437,428 ,1051,711,1052 },
		{593,793,790 ,429,435,437 ,1051,709,711 }, {790,595,592 ,437,432,428 ,711,1053,1052 },
		{790,791,595 ,437,436,432 ,711,710,1053 }, {791,594,595 ,436,431,432 ,710,1054,1055 },
		{791,792,594 ,436,438,431 ,710,712,1054 }, {594,793,593 ,431,435,429 ,1056,709,1057 },
		{594,792,793 ,431,438,435 ,1056,712,709 }, {795,789,788 ,515,502,503 ,1058,1059,1060 },
		{795,794,789 ,515,516,502 ,1058,1061,1059 }, {779,795,780 ,517,515,518 ,1062,1058,1063 },
		{779,794,795 ,517,516,515 ,1062,1064,1058 }, {796,788,772 ,519,503,520 ,1065,1066,1067 },
		{796,795,788 ,519,515,503 ,1065,1058,1066 }, {780,796,781 ,518,519,520 ,1063,1065,1068 },
		{780,795,796 ,518,515,519 ,1063,1058,1065 }, {794,771,789 ,516,521,502 ,1069,1070,1022 },
		{794,797,771 ,516,522,521 ,1069,1071,1070 }, {778,794,779 ,523,516,517 ,1072,1069,1073 },
		{778,797,794 ,523,522,516 ,1072,1071,1069 }, {798,772,773 ,524,520,525 ,1074,1075,1076 },
		{798,796,772 ,524,519,520 ,1074,1077,1075 }, {781,798,782 ,520,524,525 ,1078,1074,1079 },
		{781,796,798 ,520,519,524 ,1078,1080,1074 }, {771,799,770 ,521,526,527 ,1070,1081,1082 },
		{771,797,799 ,521,522,526 ,1070,1071,1081 }, {777,797,778 ,528,522,523 ,1083,1071,1072 },
		{777,799,797 ,528,526,522 ,1083,1081,1071 }, {800,773,774 ,529,525,530 ,1084,1085,1086 },
		{800,798,773 ,529,524,525 ,1084,1074,1085 }, {782,800,783 ,525,529,531 ,1079,1084,1087 },
		{782,798,800 ,525,524,529 ,1079,1074,1084 }, {770,801,787 ,527,532,513 ,1088,1089,1044 },
		{770,799,801 ,527,526,532 ,1088,1081,1089 }, {776,799,777 ,533,526,528 ,1090,1081,1083 },
		{776,801,799 ,533,532,526 ,1090,1089,1081 }, {775,800,774 ,534,529,530 ,1091,1084,1092 },
		{775,802,800 ,534,535,529 ,1091,1093,1084 }, {783,802,784 ,531,535,536 ,1087,1094,1095 },
		{783,800,802 ,531,529,535 ,1087,1084,1094 }, {787,803,786 ,513,537,514 ,1096,1097,1098 },
		{787,801,803 ,513,532,537 ,1096,1099,1097 }, {785,801,776 ,538,532,533 ,1100,1099,1101 },
		{785,803,801 ,538,537,532 ,1100,1097,1099 }, {786,802,775 ,514,535,534 ,1102,1103,1104 },
		{786,803,802 ,514,537,535 ,1102,1097,1103 }, {784,803,785 ,536,537,538 ,1105,1097,1100 },
		{784,802,803 ,536,535,537 ,1105,1103,1097 }, {805,807,804 ,0,0,0 ,1106,1107,1108 },
		{805,806,807 ,0,0,0 ,1106,1109,1107 }, {808,805,804 ,194,194,194 ,1110,1111,1112 },
		{808,809,805 ,194,194,194 ,1110,1113,1111 }, {809,806,805 ,1,1,1 ,1114,1115,1116 },
		{809,810,806 ,1,1,1 ,1114,1117,1115 }, {806,811,807 ,195,195,195 ,1118,1119,1120 },
		{806,810,811 ,195,195,195 ,1118,1121,1119 }, {807,808,804 ,2,2,2 ,1122,1123,1124 },
		{807,811,808 ,2,2,2 ,1122,1125,1123 }, {811,809,808 ,14,14,14 ,1126,1127,1128 },
		{811,810,809 ,14,14,14 ,1126,1129,1127 }, {815,812,814 ,494,493,495 ,1130,1131,1132 },
		{815,813,812 ,494,496,493 ,1130,1133,1131 }, {819,812,816 ,497,493,498 ,1134,1135,1136 },
		{819,814,812 ,497,495,493 ,1134,1137,1135 }, {817,850,851 ,195,195,195 ,1138,626,625 },
		{817,813,850 ,195,195,195 ,1138,1139,626 }, {818,816,817 ,499,498,500 ,1140,1141,1142 },
		{818,819,816 ,499,497,498 ,1140,1134,1141 }, {820,817,851 ,501,500,502 ,1143,1144,1145 },
		{820,818,817 ,501,499,500 ,1143,1146,1144 }, {821,813,815 ,1,496,494 ,1147,1148,1130 },
		{821,850,813 ,1,503,496 ,1147,1149,1148 }, {816,813,817 ,195,195,195 ,1150,1139,1138 },
		{816,812,813 ,195,195,195 ,1150,1151,1139 }, {822,825,824 ,505,504,506 ,1152,1153,1154 },
		{822,823,825 ,505,507,504 ,1152,1155,1153 }, {822,829,826 ,505,508,509 ,1156,1157,1158 },
		{822,824,829 ,505,506,508 ,1156,1159,1157 }, {848,827,849 ,195,195,195 ,633,1160,632 },
		{848,823,827 ,195,195,195 ,633,1161,1160 }, {826,828,827 ,509,510,511 ,1162,1163,1164 },
		{826,829,828 ,509,508,510 ,1162,1157,1163 }, {827,830,849 ,511,512,513 ,1165,1166,1167 },
		{827,828,830 ,511,510,512 ,1165,1168,1166 }, {823,831,825 ,507,1,504 ,1169,1170,1153 },
		{823,848,831 ,507,514,1 ,1169,1171,1170 }, {823,826,827 ,195,195,195 ,1161,1172,1160 },
		{823,822,826 ,195,195,195 ,1161,1173,1172 }, {851,853,850 ,502,515,503 ,1174,1175,1176 },
		{851,852,853 ,502,516,515 ,1174,1177,1175 }, {853,841,842 ,515,517,518 ,1175,1178,1179 },
		{853,852,841 ,515,516,517 ,1175,1177,1178 }, {850,854,834 ,503,519,520 ,1180,1181,1182 },
		{850,853,854 ,503,515,519 ,1180,1175,1181 }, {854,842,843 ,519,518,520 ,1181,1179,1183 },
		{854,853,842 ,519,515,518 ,1181,1175,1179 }, {833,852,851 ,521,516,502 ,1184,1185,1145 },
		{833,855,852 ,521,522,516 ,1184,1186,1185 }, {852,840,841 ,516,523,517 ,1185,1187,1188 },
		{852,855,840 ,516,522,523 ,1185,1186,1187 }, {834,856,835 ,520,524,525 ,1189,1190,1191 },
		{834,854,856 ,520,519,524 ,1189,1192,1190 }, {856,843,844 ,524,520,525 ,1190,1193,1194 },
		{856,854,843 ,524,519,520 ,1190,1195,1193 }, {857,833,832 ,526,521,527 ,1196,1184,1197 },
		{857,855,833 ,526,522,521 ,1196,1186,1184 }, {855,839,840 ,522,528,523 ,1186,1198,1187 },
		{855,857,839 ,522,526,528 ,1186,1196,1198 }, {835,858,836 ,525,529,530 ,1199,1200,1201 },
		{835,856,858 ,525,524,529 ,1199,1190,1200 }, {858,844,845 ,529,525,531 ,1200,1194,1202 },
		{858,856,844 ,529,524,525 ,1200,1190,1194 }, {859,832,849 ,532,527,513 ,1203,1204,1167 },
		{859,857,832 ,532,526,527 ,1203,1196,1204 }, {857,838,839 ,526,533,528 ,1196,1205,1198 },
		{857,859,838 ,526,532,533 ,1196,1203,1205 }, {858,837,836 ,529,534,530 ,1200,1206,1201 },
		{858,860,837 ,529,535,534 ,1200,1207,1206 }, {860,845,846 ,535,531,536 ,1207,1202,1208 },
		{860,858,845 ,535,529,531 ,1207,1200,1202 }, {861,849,848 ,537,513,514 ,1209,1210,1211 },
		{861,859,849 ,537,532,513 ,1209,1212,1210 }, {859,847,838 ,532,538,533 ,1213,1214,1215 },
		{859,861,847 ,532,537,538 ,1213,1209,1214 }, {860,848,837 ,535,514,534 ,1216,1217,1218 },
		{860,861,848 ,535,537,514 ,1216,1209,1217 }, {861,846,847 ,537,536,538 ,1209,1219,1214 },
		{861,860,846 ,537,535,536 ,1209,1220,1219 }, {28,29,51 ,14,14,14 ,1221,1222,1223 },
		{51,29,50 ,14,14,14 ,1223,1222,1224 }, {29,30,50 ,14,14,14 ,1222,364,1224 },
		{50,30,49 ,14,14,14 ,1224,364,1225 }, {30,31,49 ,14,14,14 ,364,361,1225 },
		{49,31,48 ,14,14,14 ,1225,361,1226 }, {31,32,48 ,14,14,14 ,361,1227,1226 },
		{48,32,47 ,14,14,14 ,1226,1227,1228 }, {32,33,47 ,14,14,14 ,1227,1229,1228 },
		{47,33,46 ,14,14,14 ,1228,1229,1230 }, {33,34,46 ,14,14,14 ,1229,1231,1230 },
		{46,34,45 ,14,14,14 ,1230,1231,1232 }, {34,35,45 ,14,14,14 ,1231,1233,1232 },
		{45,35,44 ,14,14,14 ,1232,1233,1234 }, {35,36,44 ,14,14,14 ,1233,1235,1234 },
		{44,36,43 ,14,14,14 ,1234,1235,1236 }, {36,37,43 ,14,14,14 ,1235,1237,1236 },
		{43,37,42 ,14,14,14 ,1236,1237,1238 }, {37,38,42 ,14,14,14 ,1237,1239,1238 },
		{42,38,41 ,14,14,14 ,1238,1239,1240 }, {39,41,38 ,14,14,14 ,1241,1240,1239 },
		{40,41,39 ,14,14,14 ,1242,1240,1241 }, {29,4,5 ,539,1,540 ,1222,1243,1244 },
		{29,28,4 ,539,1,1 ,1222,1221,1243 }, {30,5,6 ,308,540,306 ,364,1244,362 },
		{30,29,5 ,308,539,540 ,364,1222,1244 }, {32,7,8 ,541,307,542 ,1227,363,1245 },
		{32,31,7 ,541,305,307 ,1227,361,363 }, {33,8,9 ,543,542,544 ,1229,1245,1246 },
		{33,32,8 ,543,541,542 ,1229,1227,1245 }, {34,9,10 ,545,544,546 ,1231,1246,1247 },
		{34,33,9 ,545,543,544 ,1231,1229,1246 }, {35,10,11 ,547,546,548 ,1233,1247,1248 },
		{35,34,10 ,547,545,546 ,1233,1231,1247 }, {36,11,12 ,549,548,550 ,1235,1248,1249 },
		{36,35,11 ,549,547,548 ,1235,1233,1248 }, {37,12,13 ,551,550,552 ,1237,1249,1250 },
		{37,36,12 ,551,549,550 ,1237,1235,1249 }, {38,13,14 ,553,552,554 ,1239,1250,1251 },
		{38,37,13 ,553,551,552 ,1239,1237,1250 }, {39,14,15 ,555,554,556 ,1241,1251,1252 },
		{39,38,14 ,555,553,554 ,1241,1239,1251 }, {40,15,16 ,2,556,2 ,1242,1252,1253 },
		{40,39,15 ,2,555,556 ,1242,1241,1252 }, {17,40,16 ,557,2,2 ,1254,1242,1253 },
		{17,41,40 ,557,558,2 ,1254,1240,1242 }, {18,41,17 ,559,558,557 ,1255,1240,1254 },
		{18,42,41 ,559,560,558 ,1255,1238,1240 }, {19,42,18 ,561,560,559 ,1256,1238,1255 },
		{19,43,42 ,561,562,560 ,1256,1236,1238 }, {20,43,19 ,563,562,561 ,1257,1236,1256 },
		{20,44,43 ,563,564,562 ,1257,1234,1236 }, {21,44,20 ,565,564,563 ,1258,1234,1257 },
		{21,45,44 ,565,566,564 ,1258,1232,1234 }, {22,45,21 ,567,566,565 ,1259,1232,1258 },
		{22,46,45 ,567,568,566 ,1259,1230,1232 }, {23,46,22 ,569,568,567 ,1260,1230,1259 },
		{23,47,46 ,569,570,568 ,1260,1228,1230 }, {24,47,23 ,571,570,569 ,1261,1228,1260 },
		{24,48,47 ,571,572,570 ,1261,1226,1228 }, {25,48,24 ,573,572,571 ,1262,1226,1261 },
		{25,49,48 ,573,574,572 ,1262,1225,1226 }, {26,49,25 ,575,574,573 ,1263,1225,1262 },
		{26,50,49 ,575,576,574 ,1263,1224,1225 }, {27,50,26 ,577,576,575 ,1264,1224,1263 },
		{27,51,50 ,577,578,576 ,1264,1223,1224 }, {4,51,27 ,1,578,577 ,1243,1223,1264 },
		{4,28,51 ,1,1,578 ,1243,1221,1223 }, {863,868,862 ,579,580,581 ,1265,1266,1267 },
		{863,869,868 ,579,579,580 ,1265,1268,1266 }, {870,863,864 ,582,579,583 ,1269,1265,1270 },
		{870,869,863 ,582,579,579 ,1269,1268,1265 }, {871,864,865 ,584,583,585 ,1271,1270,1272 },
		{871,870,864 ,584,582,583 ,1271,1269,1270 }, {872,865,866 ,586,585,587 ,1273,1274,1275 },
		{872,871,865 ,586,584,585 ,1273,1276,1274 }, {873,866,867 ,588,587,588 ,1277,1275,1278 },
		{873,872,866 ,588,586,587 ,1277,1273,1275 }, {862,873,867 ,581,588,588 ,1267,1277,1278 },
		{862,868,873 ,581,580,588 ,1267,1266,1277 }, {875,880,874 ,589,590,591 ,1279,1280,1281 },
		{875,881,880 ,589,589,590 ,1279,1282,1280 }, {882,875,876 ,592,589,593 ,1283,1279,1284 },
		{882,881,875 ,592,589,589 ,1283,1282,1279 }, {883,876,877 ,594,593,595 ,1285,1284,1286 },
		{883,882,876 ,594,592,593 ,1285,1283,1284 }, {884,877,878 ,596,595,597 ,1287,1288,1289 },
		{884,883,877 ,596,594,595 ,1287,1290,1288 }, {885,878,879 ,598,597,598 ,1291,1289,1292 },
		{885,884,878 ,598,596,597 ,1291,1287,1289 }, {874,885,879 ,591,598,598 ,1281,1291,1292 },
		{874,880,885 ,591,590,598 ,1281,1280,1291 }, {891,914,890 ,599,600,601 ,1293,1294,1295 },
		{891,915,914 ,599,602,600 ,1293,1296,1294 }, {892,915,891 ,603,602,599 ,1297,1296,1293 },
		{892,916,915 ,603,604,602 ,1297,1298,1296 }, {893,916,892 ,605,604,603 ,1299,1298,1297 },
		{893,917,916 ,605,606,604 ,1299,1300,1298 }, {894,917,893 ,607,606,605 ,1301,1300,1299 },
		{894,918,917 ,607,608,606 ,1301,1302,1300 }, {895,918,894 ,609,608,607 ,1303,1302,1301 },
		{895,919,918 ,609,610,608 ,1303,1304,1302 }, {896,919,895 ,611,610,609 ,1305,1304,1303 },
		{896,920,919 ,611,611,610 ,1305,1306,1304 }, {921,896,897 ,612,611,613 ,1307,1305,1308 },
		{921,920,896 ,612,611,611 ,1307,1306,1305 }, {922,897,898 ,614,613,10 ,1309,1308,1310 },
		{922,921,897 ,614,612,613 ,1309,1307,1308 }, {923,898,899 ,615,10,616 ,1311,1310,1312 },
		{923,922,898 ,615,614,10 ,1311,1309,1310 }, {924,899,900 ,617,616,618 ,1313,1312,1314 },
		{924,923,899 ,617,615,616 ,1313,1311,1312 }, {925,900,901 ,619,618,620 ,1315,1314,1316 },
		{925,924,900 ,619,617,618 ,1315,1313,1314 }, {926,925,901 ,621,619,620 ,1317,1315,1316 },
		{926,901,902 ,621,620,622 ,1317,1316,1318 }, {927,926,902 ,623,621,622 ,1319,1317,1318 },
		{927,902,903 ,623,622,624 ,1319,1318,1320 }, {928,927,903 ,625,623,624 ,1321,1319,1320 },
		{928,903,904 ,625,624,626 ,1321,1320,1322 }, {929,928,904 ,627,625,626 ,1323,1321,1322 },
		{929,904,905 ,627,626,628 ,1323,1322,1324 }, {930,929,905 ,629,627,628 ,1325,1323,1324 },
		{930,905,906 ,629,628,630 ,1325,1324,1326 }, {931,930,906 ,631,629,630 ,1327,1325,1326 },
		{931,906,907 ,631,630,632 ,1327,1326,1328 }, {932,931,907 ,633,631,632 ,1329,1327,1328 },
		{932,907,908 ,633,632,633 ,1329,1328,1330 }, {909,933,932 ,634,635,633 ,1331,1332,1329 },
		{909,932,908 ,634,633,633 ,1331,1329,1330 }, {910,934,933 ,636,637,635 ,1333,1334,1332 },
		{910,933,909 ,636,635,634 ,1333,1332,1331 }, {911,935,934 ,638,639,637 ,1335,1336,1334 },
		{911,934,910 ,638,637,636 ,1335,1334,1333 }, {912,936,935 ,640,641,639 ,1337,1338,1336 },
		{912,935,911 ,640,639,638 ,1337,1336,1335 }, {913,937,936 ,642,643,641 ,1339,1340,1338 },
		{913,936,912 ,642,641,640 ,1339,1338,1337 }, {890,914,937 ,601,600,643 ,1295,1294,1340 },
		{890,937,913 ,601,643,642 ,1295,1340,1339 }, {936,937,935 ,1,1,1 ,1338,1340,1336 },
		{935,937,934 ,1,1,1 ,1336,1340,1334 }, {914,934,937 ,1,1,1 ,1294,1334,1340 },
		{934,914,933 ,1,1,1 ,1334,1294,1332 }, {915,933,914 ,1,1,1 ,1296,1332,1294 },
		{933,915,916 ,1,1,1 ,1332,1296,1298 }, {933,916,932 ,1,1,1 ,1332,1298,1329 },
		{932,916,917 ,1,1,1 ,1329,1298,1300 }, {932,917,931 ,1,1,1 ,1329,1300,1327 },
		{931,917,930 ,1,1,1 ,1327,1300,1325 }, {918,930,917 ,1,1,1 ,1302,1325,1300 },
		{930,918,929 ,1,1,1 ,1325,1302,1323 }, {919,929,918 ,1,1,1 ,1304,1323,1302 },
		{929,919,920 ,1,1,1 ,1323,1304,1306 }, {929,920,928 ,1,1,1 ,1323,1306,1321 },
		{928,920,927 ,1,1,1 ,1321,1306,1319 }, {921,927,920 ,1,1,1 ,1307,1319,1306 },
		{927,921,922 ,1,1,1 ,1319,1307,1309 }, {927,922,926 ,1,1,1 ,1319,1309,1317 },
		{926,922,923 ,1,1,1 ,1317,1309,1311 }, {926,923,925 ,1,1,1 ,1317,1311,1315 },
		{924,925,923 ,1,1,1 ,1313,1315,1311 }
	};
	static GLfloat vertices [938][3] = {
	{0.37f,1.53f,3.10735f},{-0.37f,1.53f,3.10735f},{0.37f,0.79f,3.10735f},
	{-0.37f,0.79f,3.10735f},{0.0f,3.3f,0.97235f},{0.0750575f,3.3f,0.962468f},
	{0.145f,3.3f,0.933497f},{0.205061f,3.3f,0.887411f},{0.251147f,3.3f,0.82735f},
	{0.280118f,3.3f,0.757407f},{0.29f,3.3f,0.68235f},{0.280118f,3.3f,0.607292f},
	{0.251147f,3.3f,0.53735f},{0.205061f,3.3f,0.477289f},{0.145f,3.3f,0.431203f},
	{0.0750575f,3.3f,0.402231f},{0.0f,3.3f,0.39235f},{-0.0750575f,3.3f,0.402231f},
	{-0.145f,3.3f,0.431203f},{-0.205061f,3.3f,0.477289f},{-0.251147f,3.3f,0.53735f},
	{-0.280118f,3.3f,0.607292f},{-0.29f,3.3f,0.68235f},{-0.280118f,3.3f,0.757407f},
	{-0.251147f,3.3f,0.82735f},{-0.205061f,3.3f,0.887411f},{-0.145f,3.3f,0.933497f},
	{-0.0750575f,3.3f,0.962468f},{0.0f,3.43f,0.97235f},{0.0750575f,3.43f,0.962468f},
	{0.145f,3.43f,0.933497f},{0.205061f,3.43f,0.887411f},{0.251147f,3.43f,0.82735f},
	{0.280118f,3.43f,0.757407f},{0.29f,3.43f,0.68235f},{0.280118f,3.43f,0.607292f},
	{0.251147f,3.43f,0.53735f},{0.205061f,3.43f,0.477289f},{0.145f,3.43f,0.431203f},
	{0.0750575f,3.43f,0.402231f},{0.0f,3.43f,0.39235f},{-0.0750575f,3.43f,0.402231f},
	{-0.145f,3.43f,0.431203f},{-0.205061f,3.43f,0.477289f},{-0.251147f,3.43f,0.53735f},
	{-0.280118f,3.43f,0.607292f},{-0.29f,3.43f,0.68235f},{-0.280118f,3.43f,0.757407f},
	{-0.251147f,3.43f,0.82735f},{-0.205061f,3.43f,0.887411f},{-0.145f,3.43f,0.933497f},
	{-0.0750575f,3.43f,0.962468f},{-0.55f,3.3f,0.35235f},{-0.55f,3.3f,0.95235f},
	{-0.346775f,3.3f,0.95235f},{0.346775f,3.3f,0.95235f},{0.55f,3.3f,0.95235f},
	{0.55f,3.3f,0.35235f},{0.26741f,3.3f,0.35235f},{-0.26741f,3.3f,0.35235f},
	{-0.224624f,3.3f,0.44235f},{0.224624f,3.3f,0.44235f},{-0.336465f,3.3f,0.59235f},
	{0.336465f,3.3f,0.59235f},{-0.55f,3.45f,0.95235f},{-0.346775f,3.45f,0.95235f},
	{0.346775f,3.45f,0.95235f},{0.55f,3.45f,0.95235f},{0.26741f,3.45f,0.35235f},
	{-0.26741f,3.45f,0.35235f},{-0.224624f,3.45f,0.44235f},{0.224624f,3.45f,0.44235f},
	{-0.336465f,3.45f,0.59235f},{0.336465f,3.45f,0.59235f},{-0.353865f,3.45f,0.78235f},
	{0.353865f,3.45f,0.78235f},{-0.353865f,3.3f,0.78235f},{0.353865f,3.3f,0.78235f},
	{0.0f,3.3f,0.35235f},{0.0f,3.45f,0.35235f},{0.0f,3.3f,0.36235f},
	{-4.44089e-017f,3.45f,0.36235f},{-0.55f,3.45f,0.59235f},{-0.55f,3.3f,0.59235f},
	{0.55f,3.45f,0.59235f},{0.55f,3.3f,0.59235f},{0.55f,3.45f,0.35235f},
	{-0.55f,3.45f,0.35235f},{-3.03109f,1.75f,1.76235f},{-2.47487f,2.47487f,1.76235f},
	{-2.63333f,1.495f,1.76235f},{-2.76667f,1.495f,1.76235f},{-1.75f,3.03109f,1.76235f},
	{-0.905867f,3.38074f,1.76235f},{0.0f,3.5f,1.76235f},{0.905867f,3.38074f,1.76235f},
	{1.75f,3.03109f,1.76235f},{2.47487f,2.47487f,1.76235f},{2.63333f,1.495f,1.76235f},
	{2.5f,1.3f,1.76235f},{2.5f,-1.3f,1.76235f},{2.63333f,-1.495f,1.76235f},
	{2.47487f,-2.47487f,1.76235f},{1.75f,-3.03109f,1.76235f},{0.905867f,-3.38074f,1.76235f},
	{0.0f,-3.5f,1.76235f},{-0.905867f,-3.38074f,1.76235f},{-1.75f,-3.03109f,1.76235f},
	{-2.47487f,-2.47487f,1.76235f},{-2.63333f,-1.495f,1.76235f},{-2.5f,-1.3f,1.76235f},
	{-2.5f,1.3f,1.76235f},{3.03109f,1.75f,1.76235f},{2.76667f,1.495f,1.76235f},
	{2.76667f,-1.495f,1.76235f},{2.9f,-1.3f,1.76235f},{3.38074f,-0.905867f,1.76235f},
	{3.03109f,-1.75f,1.76235f},{2.9f,1.3f,1.76235f},{3.38074f,0.905867f,1.76235f},
	{3.5f,0.0f,1.76235f},{-3.38074f,0.905867f,1.76235f},{-2.9f,1.3f,1.76235f},
	{-3.38074f,-0.905867f,1.76235f},{-3.5f,0.0f,1.76235f},{-2.9f,-1.3f,1.76235f},
	{-3.03109f,-1.75f,1.76235f},{-2.76667f,-1.495f,1.76235f},{-3.03109f,1.75f,1.60235f},
	{-2.47487f,2.47487f,1.60235f},{-2.63333f,1.495f,1.60235f},{-2.76667f,1.495f,1.60235f},
	{-1.75f,3.03109f,1.60235f},{-0.905867f,3.38074f,1.60235f},{0.0f,3.5f,1.60235f},
	{0.905867f,3.38074f,1.60235f},{1.75f,3.03109f,1.60235f},{2.47487f,2.47487f,1.60235f},
	{2.63333f,1.495f,1.60235f},{2.5f,1.3f,1.60235f},{2.5f,-1.3f,1.60235f},
	{2.63333f,-1.495f,1.60235f},{2.47487f,-2.47487f,1.60235f},{1.75f,-3.03109f,1.60235f},
	{0.905867f,-3.38074f,1.60235f},{0.0f,-3.5f,1.60235f},{-0.905867f,-3.38074f,1.60235f},
	{-1.75f,-3.03109f,1.60235f},{-2.47487f,-2.47487f,1.60235f},{-2.63333f,-1.495f,1.60235f},
	{-2.5f,-1.3f,1.60235f},{-2.5f,1.3f,1.60235f},{3.03109f,1.75f,1.60235f},
	{2.76667f,1.495f,1.60235f},{2.76667f,-1.495f,1.60235f},{2.9f,-1.3f,1.60235f},
	{3.38074f,-0.905867f,1.60235f},{3.03109f,-1.75f,1.60235f},{2.9f,1.3f,1.60235f},
	{3.38074f,0.905867f,1.60235f},{3.5f,0.0f,1.60235f},{-3.38074f,0.905867f,1.60235f},
	{-2.9f,1.3f,1.60235f},{-3.38074f,-0.905867f,1.60235f},{-3.5f,0.0f,1.60235f},
	{-2.9f,-1.3f,1.60235f},{-3.03109f,-1.75f,1.60235f},{-2.76667f,-1.495f,1.60235f},
	{1.3f,-1.35f,2.96235f},{1.2557f,-1.01354f,2.96235f},{1.12583f,-0.7f,2.96235f},
	{0.919239f,-0.430761f,2.96235f},{0.65f,-0.224167f,2.96235f},{0.336465f,-0.0942965f,2.96235f},
	{0.0f,-0.05f,2.96235f},{-0.336465f,-0.0942965f,2.96235f},{-0.65f,-0.224167f,2.96235f},
	{-0.919239f,-0.430761f,2.96235f},{-1.12583f,-0.7f,2.96235f},{-1.2557f,-1.01354f,2.96235f},
	{-1.3f,-1.35f,2.96235f},{-1.2557f,-1.68646f,2.96235f},{-1.12583f,-2.0f,2.96235f},
	{-0.919239f,-2.26924f,2.96235f},{-0.65f,-2.47583f,2.96235f},{-0.336465f,-2.6057f,2.96235f},
	{0.0f,-2.65f,2.96235f},{0.336465f,-2.6057f,2.96235f},{0.65f,-2.47583f,2.96235f},
	{0.919239f,-2.26924f,2.96235f},{1.12583f,-2.0f,2.96235f},{1.2557f,-1.68646f,2.96235f},
	{1.3f,-1.35f,3.02235f},{1.2557f,-1.01354f,3.02235f},{1.12583f,-0.7f,3.02235f},
	{0.919239f,-0.430761f,3.02235f},{0.65f,-0.224167f,3.02235f},{0.336465f,-0.0942965f,3.02235f},
	{0.0f,-0.05f,3.02235f},{-0.336465f,-0.0942965f,3.02235f},{-0.65f,-0.224167f,3.02235f},
	{-0.919239f,-0.430761f,3.02235f},{-1.12583f,-0.7f,3.02235f},{-1.2557f,-1.01354f,3.02235f},
	{-1.3f,-1.35f,3.02235f},{-1.2557f,-1.68646f,3.02235f},{-1.12583f,-2.0f,3.02235f},
	{-0.919239f,-2.26924f,3.02235f},{-0.65f,-2.47583f,3.02235f},{-0.336465f,-2.6057f,3.02235f},
	{0.0f,-2.65f,3.02235f},{0.336465f,-2.6057f,3.02235f},{0.65f,-2.47583f,3.02235f},
	{0.919239f,-2.26924f,3.02235f},{1.12583f,-2.0f,3.02235f},{1.2557f,-1.68646f,3.02235f},
	{0.896548f,-1.35f,2.72235f},{0.865999f,-1.11796f,2.72235f},{0.776434f,-0.901726f,2.72235f},
	{0.633955f,-0.716045f,2.72235f},{0.448274f,-0.573566f,2.72235f},{0.232044f,-0.484001f,2.72235f},
	{0.0f,-0.453452f,2.72235f},{-0.232044f,-0.484001f,2.72235f},{-0.448274f,-0.573566f,2.72235f},
	{-0.633955f,-0.716045f,2.72235f},{-0.776434f,-0.901726f,2.72235f},{-0.865999f,-1.11796f,2.72235f},
	{-0.896548f,-1.35f,2.72235f},{-0.865999f,-1.58204f,2.72235f},{-0.776434f,-1.79827f,2.72235f},
	{-0.633955f,-1.98396f,2.72235f},{-0.448274f,-2.12643f,2.72235f},{-0.232044f,-2.216f,2.72235f},
	{0.0f,-2.24655f,2.72235f},{0.232044f,-2.216f,2.72235f},{0.448274f,-2.12643f,2.72235f},
	{0.633955f,-1.98396f,2.72235f},{0.776434f,-1.79827f,2.72235f},{0.865999f,-1.58204f,2.72235f},
	{2.18741f,2.73426f,2.72235f},{1.95083f,2.79592f,2.72235f},{1.95083f,2.79592f,2.56235f},
	{2.18741f,2.73426f,2.56235f},{2.2995f,2.51699f,2.72235f},{2.2995f,2.51699f,2.56235f},
	{2.21256f,2.28833f,2.72235f},{2.21256f,2.28833f,2.56235f},{1.74683f,2.66091f,2.72235f},
	{1.71113f,2.41905f,2.72235f},{1.71113f,2.41905f,2.56235f},{1.74683f,2.66091f,2.56235f},
	{1.98443f,2.2004f,2.72235f},{1.98443f,2.2004f,2.56235f},{0.811054f,1.49405f,2.72235f},
	{0.811054f,1.49405f,2.56235f},{0.0f,1.7f,2.72235f},{0.0f,1.7f,2.56235f},
	{1.27958f,1.11923f,2.72235f},{1.27958f,1.11923f,2.56235f},{1.56912f,0.654101f,2.72235f},
	{1.56912f,0.654101f,2.56235f},{-1.56912f,0.654101f,2.72235f},{-1.56912f,0.654101f,2.56235f},
	{1.69569f,0.121025f,2.72235f},{1.69569f,0.121025f,2.56235f},{-1.69569f,0.121025f,2.72235f},
	{-1.69569f,0.121025f,2.56235f},{1.91349f,-2.93062f,2.72235f},{1.91349f,-2.93062f,2.56235f},
	{-1.91349f,-2.93062f,2.72235f},{0.99831f,-3.35459f,2.72235f},{0.0f,-3.49998f,2.72235f},
	{0.0f,-3.49998f,2.56235f},{-0.99831f,-3.35459f,2.72235f},{-0.99831f,-3.35459f,2.56235f},
	{-2.18741f,2.73426f,2.72235f},{-1.95083f,2.79592f,2.72235f},{-1.95083f,2.79592f,2.56235f},
	{-2.18741f,2.73426f,2.56235f},{-2.2995f,2.51699f,2.72235f},{-2.2995f,2.51699f,2.56235f},
	{-2.21256f,2.28833f,2.72235f},{-2.21256f,2.28833f,2.56235f},{-1.74683f,2.66091f,2.72235f},
	{-1.71113f,2.41905f,2.72235f},{-1.71113f,2.41905f,2.56235f},{-1.74683f,2.66091f,2.56235f},
	{-1.98443f,2.2004f,2.72235f},{-1.98443f,2.2004f,2.56235f},{-0.811054f,1.49405f,2.56235f},
	{-0.811054f,1.49405f,2.72235f},{-1.27958f,1.11923f,2.56235f},{-1.27958f,1.11923f,2.72235f},
	{0.99831f,-3.35459f,2.56235f},{-1.91349f,-2.93062f,2.56235f},{1.17199f,1.3655f,2.96235f},
	{0.828012f,1.3655f,2.96235f},{1.17199f,1.3655f,2.72235f},{0.828012f,1.3655f,2.72235f},
	{1.17199f,0.7945f,2.96235f},{0.828012f,0.7945f,2.96235f},{1.17199f,0.7945f,2.72235f},
	{0.828012f,0.7945f,2.72235f},{1.77406f,1.81693f,1.96485f},{1.77406f,2.18306f,1.96485f},
	{1.77406f,1.81693f,1.76985f},{1.77406f,2.18306f,1.76985f},{1.22594f,1.81693f,1.96485f},
	{1.22594f,2.18306f,1.96485f},{1.22594f,1.81693f,1.76985f},{1.22594f,2.18306f,1.76985f},
	{1.2124f,2.9592f,1.00235f},{1.28549f,3.19828f,1.00235f},{0.616079f,3.40294f,1.00235f},
	{0.542986f,3.16386f,1.00235f},{1.2124f,2.9592f,1.40235f},{1.28549f,3.19828f,1.40235f},
	{0.616079f,3.40294f,1.40235f},{0.542986f,3.16386f,1.40235f},{3.28f,-0.265f,1.00235f},
	{3.53f,-0.265f,1.00235f},{3.53f,0.435f,1.00235f},{3.28f,0.435f,1.00235f},
	{3.28f,-0.265f,1.40235f},{3.53f,-0.265f,1.40235f},{3.53f,0.435f,1.40235f},
	{3.28f,0.435f,1.40235f},{1.66426f,-2.83882f,1.00235f},{1.80765f,-3.0436f,1.00235f},
	{2.38106f,-2.6421f,1.00235f},{2.23766f,-2.43731f,1.00235f},{1.66426f,-2.83882f,1.40235f},
	{1.80765f,-3.0436f,1.40235f},{2.38106f,-2.6421f,1.40235f},{2.23766f,-2.43731f,1.40235f},
	{2.6493f,1.95188f,1.00235f},{2.83798f,2.11589f,1.00235f},{2.37874f,2.64419f,1.00235f},
	{2.19006f,2.48017f,1.00235f},{2.6493f,1.95188f,1.40235f},{2.83798f,2.11589f,1.40235f},
	{2.37874f,2.64419f,1.40235f},{2.19006f,2.48017f,1.40235f},{-1.2124f,2.9592f,1.00235f},
	{-1.28549f,3.19828f,1.00235f},{-0.616079f,3.40294f,1.00235f},{-0.542986f,3.16386f,1.00235f},
	{-1.2124f,2.9592f,1.40235f},{-1.28549f,3.19828f,1.40235f},{-0.616079f,3.40294f,1.40235f},
	{-0.542986f,3.16386f,1.40235f},{-3.28f,-0.265f,1.00235f},{-3.53f,-0.265f,1.00235f},
	{-3.53f,0.435f,1.00235f},{-3.28f,0.435f,1.00235f},{-3.28f,-0.265f,1.40235f},
	{-3.53f,-0.265f,1.40235f},{-3.53f,0.435f,1.40235f},{-3.28f,0.435f,1.40235f},
	{-1.66426f,-2.83882f,1.00235f},{-1.80765f,-3.0436f,1.00235f},{-2.38106f,-2.6421f,1.00235f},
	{-2.23766f,-2.43731f,1.00235f},{-1.66426f,-2.83882f,1.40235f},{-1.80765f,-3.0436f,1.40235f},
	{-2.38106f,-2.6421f,1.40235f},{-2.23766f,-2.43731f,1.40235f},{-2.6493f,1.95188f,1.00235f},
	{-2.83798f,2.11589f,1.00235f},{-2.37874f,2.64419f,1.00235f},{-2.19006f,2.48017f,1.00235f},
	{-2.6493f,1.95188f,1.40235f},{-2.83798f,2.11589f,1.40235f},{-2.37874f,2.64419f,1.40235f},
	{-2.19006f,2.48017f,1.40235f},{2.43652f,-1.21308f,1.97735f},{2.04825f,-1.19273f,1.97735f},
	{2.43652f,-1.21308f,1.79735f},{2.04825f,-1.19273f,1.79735f},{2.39175f,-2.06727f,1.97735f},
	{2.00348f,-2.04692f,1.97735f},{2.39175f,-2.06727f,1.79735f},{2.00348f,-2.04692f,1.79735f},
	{0.36f,1.16f,3.24735f},{0.347733f,1.25317f,3.24735f},{0.311769f,1.34f,3.24735f},
	{0.254558f,1.41456f,3.24735f},{0.18f,1.47177f,3.24735f},{0.0931749f,1.50773f,3.24735f},
	{0.0f,1.52f,3.24735f},{-0.0931749f,1.50773f,3.24735f},{-0.18f,1.47177f,3.24735f},
	{-0.254558f,1.41456f,3.24735f},{-0.311769f,1.34f,3.24735f},{-0.347733f,1.25317f,3.24735f},
	{-0.36f,1.16f,3.24735f},{-0.347733f,1.06683f,3.24735f},{-0.311769f,0.98f,3.24735f},
	{-0.254558f,0.905442f,3.24735f},{-0.18f,0.848231f,3.24735f},{-0.0931749f,0.812267f,3.24735f},
	{0.0f,0.8f,3.24735f},{0.0931749f,0.812267f,3.24735f},{0.18f,0.848231f,3.24735f},
	{0.254558f,0.905442f,3.24735f},{0.311769f,0.98f,3.24735f},{0.347733f,1.06683f,3.24735f},
	{0.36f,1.16f,3.41235f},{0.347733f,1.25317f,3.41235f},{0.311769f,1.34f,3.41235f},
	{0.254558f,1.41456f,3.41235f},{0.18f,1.47177f,3.41235f},{0.0931749f,1.50773f,3.41235f},
	{0.0f,1.52f,3.41235f},{-0.0931749f,1.50773f,3.41235f},{-0.18f,1.47177f,3.41235f},
	{-0.254558f,1.41456f,3.41235f},{-0.311769f,1.34f,3.41235f},{-0.347733f,1.25317f,3.41235f},
	{-0.36f,1.16f,3.41235f},{-0.347733f,1.06683f,3.41235f},{-0.311769f,0.98f,3.41235f},
	{-0.254558f,0.905442f,3.41235f},{-0.18f,0.848231f,3.41235f},{-0.0931749f,0.812267f,3.41235f},
	{0.0f,0.8f,3.41235f},{0.0931749f,0.812267f,3.41235f},{0.18f,0.848231f,3.41235f},
	{0.254558f,0.905442f,3.41235f},{0.311769f,0.98f,3.41235f},{0.347733f,1.06683f,3.41235f},
	{0.193576f,1.16f,3.24735f},{0.18698f,1.2101f,3.24735f},{0.167642f,1.25679f,3.24735f},
	{0.136879f,1.29688f,3.24735f},{0.0967881f,1.32764f,3.24735f},{0.0501012f,1.34698f,3.24735f},
	{0.0f,1.35358f,3.24735f},{-0.0501012f,1.34698f,3.24735f},{-0.0967881f,1.32764f,3.24735f},
	{-0.136879f,1.29688f,3.24735f},{-0.167642f,1.25679f,3.24735f},{-0.18698f,1.2101f,3.24735f},
	{-0.193576f,1.16f,3.24735f},{-0.18698f,1.1099f,3.24735f},{-0.167642f,1.06321f,3.24735f},
	{-0.136879f,1.02312f,3.24735f},{-0.0967881f,0.992358f,3.24735f},{-0.0501012f,0.97302f,3.24735f},
	{0.0f,0.966424f,3.24735f},{0.0501012f,0.97302f,3.24735f},{0.0967881f,0.992358f,3.24735f},
	{0.136879f,1.02312f,3.24735f},{0.167642f,1.06321f,3.24735f},{0.18698f,1.1099f,3.24735f},
	{0.193576f,1.16f,3.10735f},{0.18698f,1.2101f,3.10735f},{0.167642f,1.25679f,3.10735f},
	{0.136879f,1.29688f,3.10735f},{0.0967881f,1.32764f,3.10735f},{0.0501012f,1.34698f,3.10735f},
	{0.0f,1.35358f,3.10735f},{-0.0501012f,1.34698f,3.10735f},{-0.0967881f,1.32764f,3.10735f},
	{-0.136879f,1.29688f,3.10735f},{-0.167642f,1.25679f,3.10735f},{-0.18698f,1.2101f,3.10735f},
	{-0.193576f,1.16f,3.10735f},{-0.18698f,1.1099f,3.10735f},{-0.167642f,1.06321f,3.10735f},
	{-0.136879f,1.02312f,3.10735f},{-0.0967881f,0.992358f,3.10735f},{-0.0501012f,0.97302f,3.10735f},
	{0.0f,0.966424f,3.10735f},{0.0501012f,0.97302f,3.10735f},{0.0967881f,0.992358f,3.10735f},
	{0.136879f,1.02312f,3.10735f},{0.167642f,1.06321f,3.10735f},{0.18698f,1.1099f,3.10735f},
	{-1.6461f,-2.5961f,-1.74765f},{1.6461f,-2.5961f,-1.74765f},{1.6461f,2.0461f,-1.74765f},
	{-1.6461f,2.0461f,-1.74765f},{-1.6461f,-2.63421f,-1.73186f},{1.6461f,-2.63421f,-1.73186f},
	{1.67305f,-2.62305f,-1.73186f},{1.68421f,-2.5961f,-1.73186f},{1.68421f,2.0461f,-1.73186f},
	{1.67305f,2.07305f,-1.73186f},{1.6461f,2.08421f,-1.73186f},{-1.6461f,2.08421f,-1.73186f},
	{-1.67305f,2.07305f,-1.73186f},{-1.68421f,2.0461f,-1.73186f},{-1.68421f,-2.5961f,-1.73186f},
	{-1.67305f,-2.62305f,-1.73186f},{-1.6461f,-2.65f,-1.69375f},{1.6461f,-2.65f,-1.69375f},
	{1.68421f,-2.63421f,-1.69375f},{1.7f,-2.5961f,-1.69375f},{1.7f,2.0461f,-1.69375f},
	{1.68421f,2.08421f,-1.69375f},{1.6461f,2.1f,-1.69375f},{-1.6461f,2.1f,-1.69375f},
	{-1.68421f,2.08421f,-1.69375f},{-1.7f,2.0461f,-1.69375f},{-1.7f,-2.5961f,-1.69375f},
	{-1.68421f,-2.63421f,-1.69375f},{-1.6461f,-2.65f,-0.79155f},{1.6461f,-2.65f,-0.79155f},
	{1.68421f,-2.63421f,-0.79155f},{1.7f,-2.5961f,-0.79155f},{1.7f,2.0461f,-0.79155f},
	{1.68421f,2.08421f,-0.79155f},{1.6461f,2.1f,-0.79155f},{-1.6461f,2.1f,-0.79155f},
	{-1.68421f,2.08421f,-0.79155f},{-1.7f,2.0461f,-0.79155f},{-1.7f,-2.5961f,-0.79155f},
	{-1.68421f,-2.63421f,-0.79155f},{-1.6461f,-2.63421f,-0.753437f},{1.6461f,-2.63421f,-0.753437f},
	{1.67305f,-2.62305f,-0.753437f},{1.68421f,-2.5961f,-0.753437f},{1.68421f,2.0461f,-0.753437f},
	{1.67305f,2.07305f,-0.753437f},{1.6461f,2.08421f,-0.753437f},{-1.6461f,2.08421f,-0.753437f},
	{-1.67305f,2.07305f,-0.753437f},{-1.68421f,2.0461f,-0.753437f},{-1.68421f,-2.5961f,-0.753437f},
	{-1.67305f,-2.62305f,-0.753437f},{-1.6461f,-2.5961f,-0.73765f},{1.6461f,-2.5961f,-0.73765f},
	{1.6461f,2.0461f,-0.73765f},{-1.6461f,2.0461f,-0.73765f},{-0.923916f,-1.2254f,2.58235f},
	{-1.42967f,-1.21657f,2.58235f},{-1.55485f,-1.07717f,2.58235f},{-1.52543f,0.608176f,2.58235f},
	{-0.889709f,0.734301f,2.58235f},{-1.39546f,0.743129f,2.58235f},{-0.923916f,-1.2254f,1.76235f},
	{-1.42967f,-1.21657f,1.76235f},{-1.55485f,-1.07717f,1.76235f},{-1.52543f,0.608176f,1.76235f},
	{-0.889709f,0.734301f,1.76235f},{-1.39546f,0.743129f,1.76235f},{0.636084f,-1.3254f,2.58235f},
	{0.130334f,-1.31657f,2.58235f},{0.00515229f,-1.17717f,2.58235f},{0.0345701f,0.508176f,2.58235f},
	{0.670291f,0.634301f,2.58235f},{0.164541f,0.643129f,2.58235f},{0.636084f,-1.3254f,1.76235f},
	{0.130334f,-1.31657f,1.76235f},{0.00515229f,-1.17717f,1.76235f},{0.0345701f,0.508176f,1.76235f},
	{0.670291f,0.634301f,1.76235f},{0.164541f,0.643129f,1.76235f},{-1.77f,2.5f,1.76235f},
	{-1.885f,2.69919f,1.76235f},{-2.115f,2.69919f,1.76235f},{-2.23f,2.5f,1.76235f},
	{-2.115f,2.30081f,1.76235f},{-1.885f,2.30081f,1.76235f},{-1.77f,2.5f,2.56235f},
	{-1.885f,2.69919f,2.56235f},{-2.115f,2.69919f,2.56235f},{-2.23f,2.5f,2.56235f},
	{-2.115f,2.30081f,2.56235f},{-1.885f,2.30081f,2.56235f},{-0.75f,1.4f,2.97635f},
	{-1.25f,1.4f,2.97635f},{-0.75f,1.4f,2.72235f},{-1.25f,1.4f,2.72235f},
	{-0.75f,0.92f,2.97635f},{-1.25f,0.92f,2.97635f},{-0.75f,0.92f,2.72235f},
	{-1.25f,0.92f,2.72235f},{-0.3f,3.06f,0.35235f},{-0.3f,3.3f,0.35235f},
	{-0.3f,3.3f,0.95235f},{-0.3f,3.06f,0.95235f},{0.3f,3.06f,0.35235f},
	{0.3f,3.3f,0.35235f},{0.3f,3.3f,0.95235f},{0.3f,3.06f,0.95235f},
	{7.21734e-013f,3.43f,0.399507f},{-0.282843f,3.43f,0.68235f},{-7.21734e-013f,3.43f,0.965193f},
	{0.282843f,3.43f,0.68235f},{7.21734e-013f,3.47f,0.399507f},{-0.282843f,3.47f,0.68235f},
	{-7.21734e-013f,3.47f,0.965193f},{0.282843f,3.47f,0.68235f},{1.18612f,3.06135f,1.39735f},
	{1.18612f,3.06135f,1.60235f},{1.19635f,3.09482f,1.60235f},{1.19635f,3.09482f,1.39735f},
	{0.617115f,3.23531f,1.39735f},{0.617115f,3.23531f,1.60235f},{0.627348f,3.26878f,1.60235f},
	{0.627348f,3.26878f,1.39735f},{3.37f,-0.21f,1.39735f},{3.37f,-0.21f,1.60235f},
	{3.405f,-0.21f,1.60235f},{3.405f,-0.21f,1.39735f},{3.37f,0.385f,1.39735f},
	{3.37f,0.385f,1.60235f},{3.405f,0.385f,1.60235f},{3.405f,0.385f,1.39735f},
	{1.76093f,-2.88099f,1.39735f},{1.76093f,-2.88099f,1.60235f},{1.78101f,-2.90966f,1.60235f},
	{1.78101f,-2.90966f,1.39735f},{2.24833f,-2.53972f,1.39735f},{2.24833f,-2.53972f,1.60235f},
	{2.2684f,-2.56839f,1.60235f},{2.2684f,-2.56839f,1.39735f},{2.68114f,2.05243f,1.39735f},
	{2.68114f,2.05243f,1.60235f},{2.70756f,2.07539f,1.60235f},{2.70756f,2.07539f,1.39735f},
	{2.29079f,2.50148f,1.39735f},{2.29079f,2.50148f,1.60235f},{2.3172f,2.52444f,1.60235f},
	{2.3172f,2.52444f,1.39735f},{-1.18612f,3.06135f,1.39735f},{-1.18612f,3.06135f,1.60235f},
	{-1.19635f,3.09482f,1.60235f},{-1.19635f,3.09482f,1.39735f},{-0.617115f,3.23531f,1.39735f},
	{-0.617115f,3.23531f,1.60235f},{-0.627348f,3.26878f,1.60235f},{-0.627348f,3.26878f,1.39735f},
	{-3.37f,-0.21f,1.39735f},{-3.37f,-0.21f,1.60235f},{-3.405f,-0.21f,1.60235f},
	{-3.405f,-0.21f,1.39735f},{-3.37f,0.385f,1.39735f},{-3.37f,0.385f,1.60235f},
	{-3.405f,0.385f,1.60235f},{-3.405f,0.385f,1.39735f},{-1.76093f,-2.88099f,1.39735f},
	{-1.76093f,-2.88099f,1.60235f},{-1.78101f,-2.90966f,1.60235f},{-1.78101f,-2.90966f,1.39735f},
	{-2.24833f,-2.53972f,1.39735f},{-2.24833f,-2.53972f,1.60235f},{-2.2684f,-2.56839f,1.60235f},
	{-2.2684f,-2.56839f,1.39735f},{-2.68114f,2.05243f,1.39735f},{-2.68114f,2.05243f,1.60235f},
	{-2.70756f,2.07539f,1.60235f},{-2.70756f,2.07539f,1.39735f},{-2.29079f,2.50148f,1.39735f},
	{-2.29079f,2.50148f,1.60235f},{-2.3172f,2.52444f,1.60235f},{-2.3172f,2.52444f,1.39735f},
	{2.912f,0.4926f,1.76235f},{2.912f,0.4926f,1.90735f},{3.288f,0.4926f,1.90735f},
	{3.288f,0.4926f,1.76235f},{2.912f,1.107f,1.76235f},{2.912f,1.107f,1.90735f},
	{3.288f,1.107f,1.90735f},{3.288f,1.107f,1.76235f},{-2.912f,0.4926f,1.76235f},
	{-2.912f,0.4926f,1.90735f},{-3.288f,0.4926f,1.90735f},{-3.288f,0.4926f,1.76235f},
	{-2.912f,1.107f,1.76235f},{-2.912f,1.107f,1.90735f},{-3.288f,1.107f,1.90735f},
	{-3.288f,1.107f,1.76235f},{0.96f,-2.42f,0.73235f},{0.96f,-2.42f,1.60235f},
	{1.81f,-2.42f,1.60235f},{1.81f,-2.42f,0.73235f},{0.96f,-1.92f,0.73235f},
	{0.96f,-1.92f,1.60235f},{1.81f,-1.92f,1.60235f},{1.81f,-1.92f,0.73235f},
	{1.81f,-1.96f,1.17235f},{1.81f,-2.00011f,1.31342f},{1.81f,-2.10511f,1.4006f},
	{1.81f,-2.23489f,1.4006f},{1.81f,-2.33989f,1.31342f},{1.81f,-2.38f,1.17235f},
	{1.81f,-2.33989f,1.03128f},{1.81f,-2.23489f,0.944096f},{1.81f,-2.10511f,0.944096f},
	{1.81f,-2.00011f,1.03128f},{2.38f,-1.96f,1.17235f},{2.38f,-2.00011f,1.31342f},
	{2.38f,-2.10511f,1.4006f},{2.38f,-2.23489f,1.4006f},{2.38f,-2.33989f,1.31342f},
	{2.38f,-2.38f,1.17235f},{2.38f,-2.33989f,1.03128f},{2.38f,-2.23489f,0.944096f},
	{2.38f,-2.10511f,0.944096f},{2.38f,-2.00011f,1.03128f},{2.38326f,-2.05f,1.19236f},
	{2.38326f,-2.07292f,1.26453f},{2.38326f,-2.13292f,1.30913f},{2.38326f,-2.20708f,1.30913f},
	{2.38326f,-2.26708f,1.26453f},{2.38326f,-2.29f,1.19236f},{2.38326f,-2.26708f,1.12019f},
	{2.38326f,-2.20708f,1.07559f},{2.38326f,-2.13292f,1.07559f},{2.38326f,-2.07292f,1.12019f},
	{2.79349f,-2.05f,1.01526f},{2.82218f,-2.07292f,1.0797f},{2.83991f,-2.13292f,1.11952f},
	{2.83991f,-2.20708f,1.11952f},{2.82218f,-2.26708f,1.0797f},{2.79349f,-2.29f,1.01526f},
	{2.7648f,-2.26708f,0.950824f},{2.74707f,-2.20708f,0.911f},{2.74707f,-2.13292f,0.911f},
	{2.7648f,-2.07292f,0.950824f},{2.83917f,-2.10257f,0.994924f},{2.82305f,-2.11545f,0.958717f},
	{2.81309f,-2.14916f,0.936341f},{2.81309f,-2.19084f,0.936341f},{2.82305f,-2.22455f,0.958717f},
	{2.83917f,-2.23743f,0.994924f},{2.85529f,-2.22455f,1.03113f},{2.86525f,-2.19084f,1.05351f},
	{2.86525f,-2.14916f,1.05351f},{2.85529f,-2.11545f,1.03113f},{0.42f,-2.21f,0.91235f},
	{0.42f,-2.21f,1.93235f},{0.96f,-2.21f,1.93235f},{0.96f,-2.21f,0.91235f},
	{0.42f,-2.13f,0.91235f},{0.42f,-2.13f,1.93235f},{0.96f,-2.13f,1.93235f},
	{0.96f,-2.13f,0.91235f},{0.2f,-0.46f,0.62235f},{0.2f,-0.46f,1.10235f},
	{1.1f,-0.46f,1.10235f},{1.1f,-0.46f,0.62235f},{0.2f,0.44f,0.62235f},
	{0.2f,0.44f,1.10235f},{1.1f,0.44f,1.10235f},{1.1f,0.44f,0.62235f},
	{2.38f,-1.15874f,0.13983f},{2.38f,-1.0f,0.21235f},{2.2f,-1.15874f,0.13983f},
	{2.2f,-1.0f,0.21235f},{2.38f,-1.20785f,-0.0276416f},{2.38f,-1.1134f,-0.1744f},
	{2.2f,-1.1134f,-0.1744f},{2.2f,-1.20785f,-0.0276416f},{2.2f,-0.625f,-0.458899f},
	{2.2f,-0.72f,0.21235f},{2.38f,1.15874f,0.13983f},{2.38f,1.0f,0.21235f},
	{2.2f,1.15874f,0.13983f},{2.2f,1.0f,0.21235f},{2.38f,1.20785f,-0.0276416f},
	{2.38f,1.1134f,-0.1744f},{2.2f,1.1134f,-0.1744f},{2.2f,1.20785f,-0.0276416f},
	{2.2f,0.625f,-0.458899f},{2.2f,0.72f,0.21235f},{2.38f,0.234853f,-0.720453f},
	{2.38f,-0.234853f,-0.720453f},{2.38f,-0.614853f,0.449067f},{2.38f,-0.234853f,0.725153f},
	{2.38f,0.234853f,0.725153f},{2.38f,0.614853f,0.449067f},{0.2f,0.625f,-0.458899f},
	{0.2f,0.234853f,-0.720453f},{0.2f,-0.234853f,-0.720453f},{0.2f,-0.625f,-0.458899f},
	{0.2f,-0.72f,0.21235f},{0.2f,-0.614853f,0.449067f},{0.2f,-0.234853f,0.725153f},
	{0.2f,0.234853f,0.725153f},{0.2f,0.614853f,0.449067f},{0.2f,0.72f,0.21235f},
	{2.38f,0.72f,0.21235f},{2.38f,0.625f,-0.458899f},{2.38f,-0.72f,0.21235f},
	{2.38f,-0.625f,-0.458899f},{6.85647e-013f,3.49f,0.427792f},{0.254558f,3.49f,0.68235f},
	{-6.85647e-013f,3.49f,0.936908f},{-0.254558f,3.49f,0.68235f},{1.1f,-0.625f,-0.458899f},
	{1.1f,-0.72f,0.21235f},{1.1f,-0.614853f,0.449067f},{1.1f,-0.234853f,-0.720453f},
	{1.1f,-0.234853f,0.725153f},{1.1f,0.234853f,-0.720453f},{1.1f,0.234853f,0.725153f},
	{1.1f,0.625f,-0.458899f},{1.1f,0.614853f,0.449067f},{1.1f,0.72f,0.21235f},
	{-0.2f,-0.46f,0.62235f},{-0.2f,-0.46f,1.10235f},{-1.1f,-0.46f,1.10235f},
	{-1.1f,-0.46f,0.62235f},{-0.2f,0.44f,0.62235f},{-0.2f,0.44f,1.10235f},
	{-1.1f,0.44f,1.10235f},{-1.1f,0.44f,0.62235f},{-2.38f,-1.15874f,0.13983f},
	{-2.38f,-1.0f,0.21235f},{-2.2f,-1.15874f,0.13983f},{-2.2f,-1.0f,0.21235f},
	{-2.38f,-1.20785f,-0.0276416f},{-2.38f,-1.1134f,-0.1744f},{-2.2f,-1.1134f,-0.1744f},
	{-2.2f,-1.20785f,-0.0276416f},{-2.2f,-0.625f,-0.458899f},{-2.2f,-0.72f,0.21235f},
	{-2.38f,1.15874f,0.13983f},{-2.38f,1.0f,0.21235f},{-2.2f,1.15874f,0.13983f},
	{-2.2f,1.0f,0.21235f},{-2.38f,1.20785f,-0.0276416f},{-2.38f,1.1134f,-0.1744f},
	{-2.2f,1.1134f,-0.1744f},{-2.2f,1.20785f,-0.0276416f},{-2.2f,0.625f,-0.458899f},
	{-2.2f,0.72f,0.21235f},{-2.38f,0.234853f,-0.720453f},{-2.38f,-0.234853f,-0.720453f},
	{-2.38f,-0.614853f,0.449067f},{-2.38f,-0.234853f,0.725153f},{-2.38f,0.234853f,0.725153f},
	{-2.38f,0.614853f,0.449067f},{-0.2f,0.625f,-0.458899f},{-0.2f,0.234853f,-0.720453f},
	{-0.2f,-0.234853f,-0.720453f},{-0.2f,-0.625f,-0.458899f},{-0.2f,-0.72f,0.21235f},
	{-0.2f,-0.614853f,0.449067f},{-0.2f,-0.234853f,0.725153f},{-0.2f,0.234853f,0.725153f},
	{-0.2f,0.614853f,0.449067f},{-0.2f,0.72f,0.21235f},{-2.38f,0.72f,0.21235f},
	{-2.38f,0.625f,-0.458899f},{-2.38f,-0.72f,0.21235f},{-2.38f,-0.625f,-0.458899f},
	{-1.1f,-0.625f,-0.458899f},{-1.1f,-0.72f,0.21235f},{-1.1f,-0.614853f,0.449067f},
	{-1.1f,-0.234853f,-0.720453f},{-1.1f,-0.234853f,0.725153f},{-1.1f,0.234853f,-0.720453f},
	{-1.1f,0.234853f,0.725153f},{-1.1f,0.625f,-0.458899f},{-1.1f,0.614853f,0.449067f},
	{-1.1f,0.72f,0.21235f},{0.23f,-3.2f,1.76235f},{0.115f,-3.00081f,1.76235f},
	{-0.115f,-3.00081f,1.76235f},{-0.23f,-3.2f,1.76235f},{-0.115f,-3.39919f,1.76235f},
	{0.115f,-3.39919f,1.76235f},{0.23f,-3.2f,2.56235f},{0.115f,-3.00081f,2.56235f},
	{-0.115f,-3.00081f,2.56235f},{-0.23f,-3.2f,2.56235f},{-0.115f,-3.39919f,2.56235f},
	{0.115f,-3.39919f,2.56235f},{2.23f,2.5f,1.76235f},{2.115f,2.69919f,1.76235f},
	{1.885f,2.69919f,1.76235f},{1.77f,2.5f,1.76235f},{1.885f,2.30081f,1.76235f},
	{2.115f,2.30081f,1.76235f},{2.23f,2.5f,2.56235f},{2.115f,2.69919f,2.56235f},
	{1.885f,2.69919f,2.56235f},{1.77f,2.5f,2.56235f},{1.885f,2.30081f,2.56235f},
	{2.115f,2.30081f,2.56235f},{0.37f,1.53f,2.72235f},{-0.37f,1.53f,2.72235f},
	{0.37f,0.79f,2.72235f},{-0.37f,0.79f,2.72235f},{-0.88f,1.15f,2.975f},
	{-0.884089f,1.18106f,2.975f},{-0.896077f,1.21f,2.975f},{-0.915147f,1.23485f,2.975f},
	{-0.94f,1.25392f,2.975f},{-0.968942f,1.26591f,2.975f},{-1.0f,1.27f,2.975f},
	{-1.03106f,1.26591f,2.975f},{-1.06f,1.25392f,2.975f},{-1.08485f,1.23485f,2.975f},
	{-1.10392f,1.21f,2.975f},{-1.11591f,1.18106f,2.975f},{-1.12f,1.15f,2.975f},
	{-1.11591f,1.11894f,2.975f},{-1.10392f,1.09f,2.975f},{-1.08485f,1.06515f,2.975f},
	{-1.06f,1.04608f,2.975f},{-1.03106f,1.03409f,2.975f},{-1.0f,1.03f,2.975f},
	{-0.968942f,1.03409f,2.975f},{-0.94f,1.04608f,2.975f},{-0.915147f,1.06515f,2.975f},
	{-0.896077f,1.09f,2.975f},{-0.884089f,1.11894f,2.975f},{-0.88f,1.15f,3.125f},
	{-0.884089f,1.18106f,3.125f},{-0.896077f,1.21f,3.125f},{-0.915147f,1.23485f,3.125f},
	{-0.94f,1.25392f,3.125f},{-0.968942f,1.26591f,3.125f},{-1.0f,1.27f,3.125f},
	{-1.03106f,1.26591f,3.125f},{-1.06f,1.25392f,3.125f},{-1.08485f,1.23485f,3.125f},
	{-1.10392f,1.21f,3.125f},{-1.11591f,1.18106f,3.125f},{-1.12f,1.15f,3.125f},
	{-1.11591f,1.11894f,3.125f},{-1.10392f,1.09f,3.125f},{-1.08485f,1.06515f,3.125f},
	{-1.06f,1.04608f,3.125f},{-1.03106f,1.03409f,3.125f},{-1.0f,1.03f,3.125f},
	{-0.968942f,1.03409f,3.125f},{-0.94f,1.04608f,3.125f},{-0.915147f,1.06515f,3.125f},
	{-0.896077f,1.09f,3.125f},{-0.884089f,1.11894f,3.125f}
	};
	static GLfloat normals [644][3] = {
	{0.0f,-1.0f,0.0f},{0.0f,0.0f,1.0f},{0.0f,0.0f,-1.0f},
	{-0.843272f,0.537488f,0.0f},{-0.737428f,0.675426f,0.0f},{-0.887114f,0.461551f,0.0f},
	{-0.675426f,0.737428f,0.0f},{-0.306412f,-0.951899f,0.0f},{0.466674f,-0.884429f,0.0f},
	{-0.612825f,-0.790219f,0.0f},{-0.537488f,0.843272f,0.0f},{-0.461551f,0.887114f,0.0f},
	{-0.300918f,0.95365f,0.0f},{-0.216222f,0.976344f,0.0f},{0.0f,1.0f,0.0f},
	{0.216222f,0.976344f,0.0f},{0.300918f,0.95365f,0.0f},{0.461551f,0.887114f,0.0f},
	{0.537488f,0.843272f,0.0f},{0.675426f,0.737428f,0.0f},{0.737428f,0.675426f,0.0f},
	{0.612825f,-0.790219f,0.0f},{0.920055f,-0.391789f,0.0f},{0.980625f,-0.195894f,0.0f},
	{0.306412f,-0.951899f,0.0f},{0.980625f,0.195894f,0.0f},{0.920055f,0.391789f,0.0f},
	{0.466674f,0.88443f,0.0f},{0.675426f,-0.737428f,0.0f},{0.537488f,-0.843272f,0.0f},
	{0.461551f,-0.887114f,0.0f},{0.737428f,-0.675426f,0.0f},{0.300918f,-0.95365f,0.0f},
	{0.216222f,-0.976344f,0.0f},{-0.216222f,-0.976344f,0.0f},{-0.300918f,-0.95365f,0.0f},
	{-0.461551f,-0.887114f,0.0f},{-0.537488f,-0.843272f,0.0f},{-0.675426f,-0.737428f,0.0f},
	{-0.737428f,-0.675426f,0.0f},{-0.466674f,0.88443f,0.0f},{-0.920055f,0.391789f,0.0f},
	{-0.980625f,0.195894f,0.0f},{-0.980625f,-0.195894f,0.0f},{-0.920055f,-0.391789f,0.0f},
	{0.843272f,0.537488f,0.0f},{0.887114f,0.461551f,0.0f},{-0.466674f,-0.884429f,0.0f},
	{-0.612825f,0.790218f,0.0f},{-0.920056f,0.391788f,0.0f},{-0.306413f,0.951899f,0.0f},
	{-0.980625f,0.195894f,0.0f},{0.95365f,-0.300918f,0.0f},{0.887114f,-0.461551f,0.0f},
	{0.843272f,-0.537488f,0.0f},{0.976344f,-0.216222f,0.0f},{-0.980625f,-0.195894f,0.0f},
	{-0.920056f,-0.391788f,0.0f},{0.976344f,0.216222f,0.0f},{0.999038f,0.0438421f,0.0f},
	{0.999038f,-0.0438421f,0.0f},{0.95365f,0.300918f,0.0f},{-0.95365f,0.300918f,0.0f},
	{-0.976344f,0.216222f,0.0f},{0.920056f,-0.391788f,0.0f},{0.980625f,-0.195894f,0.0f},
	{-0.976344f,-0.216222f,0.0f},{-0.999038f,-0.0438421f,0.0f},{-0.95365f,-0.300918f,0.0f},
	{-0.999038f,0.0438421f,0.0f},{0.980625f,0.195894f,0.0f},{0.920056f,0.391788f,0.0f},
	{-0.887114f,-0.461551f,0.0f},{-0.843272f,-0.537488f,0.0f},{0.612825f,0.790218f,0.0f},
	{0.306413f,0.951899f,0.0f},{0.841885f,0.212936f,-0.495871f},{0.999038f,0.0438419f,0.0f},
	{0.86831f,-0.0122154f,-0.495871f},{0.95365f,0.300918f,0.0f},{0.758086f,0.423576f,-0.495871f},
	{0.622626f,0.605351f,-0.495871f},{0.675426f,0.737428f,0.0f},{0.444734f,0.745871f,-0.495871f},
	{0.236534f,0.835562f,-0.495871f},{0.216222f,0.976344f,0.0f},{0.0f,0.945625f,-0.325259f},
	{-0.216222f,0.976344f,0.0f},{-0.236534f,0.835562f,-0.495871f},{-0.461551f,0.887114f,0.0f},
	{-0.444734f,0.745871f,-0.495871f},{-0.675426f,0.737428f,0.0f},{-0.622626f,0.605351f,-0.495871f},
	{-0.758086f,0.423576f,-0.495871f},{-0.95365f,0.300918f,0.0f},{-0.841885f,0.212936f,-0.495871f},
	{-0.999038f,0.0438419f,0.0f},{-0.86831f,-0.0122154f,-0.495871f},{-0.976344f,-0.216222f,0.0f},
	{-0.835562f,-0.236534f,-0.495871f},{-0.887114f,-0.461551f,0.0f},{-0.745871f,-0.444734f,-0.495871f},
	{-0.737428f,-0.675426f,0.0f},{-0.60535f,-0.622626f,-0.495871f},{-0.537487f,-0.843272f,0.0f},
	{-0.423576f,-0.758087f,-0.495871f},{-0.300918f,-0.95365f,0.0f},{-0.212936f,-0.841885f,-0.495871f},
	{1.40925e-009f,-0.760987f,-0.648767f},{0.212936f,-0.841885f,-0.495871f},{0.300918f,-0.95365f,0.0f},
	{0.423576f,-0.758087f,-0.495871f},{0.537487f,-0.843272f,0.0f},{0.60535f,-0.622626f,-0.495871f},
	{0.737428f,-0.675426f,0.0f},{0.745871f,-0.444734f,-0.495871f},{0.887114f,-0.461551f,0.0f},
	{0.835562f,-0.236534f,-0.495871f},{0.976344f,-0.216222f,0.0f},{0.51112f,-0.0224301f,-0.859217f},
	{0.487899f,-0.153953f,-0.859217f},{0.499509f,0.110622f,-0.859217f},{0.453858f,0.236135f,-0.859217f},
	{0.377277f,0.345556f,-0.859217f},{0.274985f,0.431428f,-0.859217f},{0.153953f,0.487899f,-0.859217f},
	{-1.86686e-009f,0.511249f,-0.859433f},{-0.153953f,0.487899f,-0.859217f},{-0.274985f,0.431428f,-0.859217f},
	{-0.377277f,0.345556f,-0.859217f},{-0.453858f,0.236135f,-0.859217f},{-0.499509f,0.110622f,-0.859217f},
	{-0.51112f,-0.0224301f,-0.859217f},{-0.487899f,-0.153953f,-0.859217f},{-0.431428f,-0.274985f,-0.859217f},
	{-0.345556f,-0.377277f,-0.859217f},{-0.236135f,-0.453858f,-0.859217f},{-0.110622f,-0.49951f,-0.859217f},
	{0.0f,-0.511249f,-0.859433f},{0.110622f,-0.49951f,-0.859217f},{0.236135f,-0.453858f,-0.859217f},
	{0.345556f,-0.377277f,-0.859217f},{0.431428f,-0.274985f,-0.859217f},{-0.708709f,-0.705501f,0.0f},
	{-0.542277f,-0.8402f,0.0f},{-0.708788f,-0.705421f,0.0f},{-0.998406f,0.056445f,0.0f},
	{-0.998406f,0.056445f,0.0f},{-0.624695f,0.780869f,0.0f},{-0.624695f,0.780869f,0.0f},
	{0.843804f,0.536652f,0.0f},{0.27173f,0.962373f,0.0f},{0.27173f,0.962373f,0.0f},
	{0.938744f,0.344615f,0.0f},{0.843864f,0.536557f,0.0f},{0.164094f,0.986445f,0.0f},
	{0.843864f,0.536557f,0.0f},{-0.999945f,-0.0104664f,0.0f},{0.542277f,-0.8402f,0.0f},
	{0.708709f,-0.705501f,0.0f},{0.708788f,-0.705421f,0.0f},{0.998406f,0.056445f,0.0f},
	{0.998406f,0.056445f,0.0f},{0.624695f,0.780869f,0.0f},{0.624695f,0.780869f,0.0f},
	{-0.331341f,-0.943511f,0.0f},{-0.725534f,-0.688186f,0.0f},{-0.953326f,-0.301944f,0.0f},
	{-0.238401f,-0.971167f,0.0f},{-0.942561f,0.334035f,0.0f},{-0.983986f,0.178247f,0.0f},
	{-0.992179f,0.124823f,0.0f},{-0.90074f,0.434359f,0.0f},{-0.0843406f,0.996437f,0.0f},
	{0.0843406f,0.996437f,0.0f},{-0.0848503f,0.996394f,0.0f},{-0.448806f,0.893629f,0.0f},
	{-0.843804f,0.536652f,0.0f},{-0.938744f,0.344615f,0.0f},{-0.164094f,0.986445f,0.0f},
	{-0.843864f,0.536557f,0.0f},{-0.843864f,0.536557f,0.0f},{0.975956f,-0.217969f,0.0f},
	{0.980304f,0.197492f,0.0f},{0.90074f,0.434359f,0.0f},{0.942561f,0.334035f,0.0f},
	{0.983986f,0.178247f,0.0f},{0.992179f,0.124823f,0.0f},{0.953326f,-0.301944f,0.0f},
	{0.725534f,-0.688186f,0.0f},{0.331341f,-0.943511f,0.0f},{0.238401f,-0.971167f,0.0f},
	{0.0484868f,-0.998824f,0.0f},{-0.0484868f,-0.998824f,0.0f},{1.0f,0.0f,0.0f},
	{-1.0f,0.0f,0.0f},{0.956305f,-0.292371f,0.0f},{0.292371f,0.956305f,0.0f},
	{-0.956305f,0.292372f,0.0f},{-0.292372f,-0.956305f,0.0f},{-0.819152f,-0.573577f,0.0f},
	{0.573577f,-0.819152f,0.0f},{0.819152f,0.573576f,0.0f},{-0.573576f,0.819152f,0.0f},
	{0.656059f,-0.754709f,0.0f},{0.75471f,0.656059f,0.0f},{-0.656059f,0.754709f,0.0f},
	{-0.75471f,-0.656059f,0.0f},{-0.956305f,-0.292371f,0.0f},{-0.292371f,0.956305f,0.0f},
	{0.956305f,0.292372f,0.0f},{0.292372f,-0.956305f,0.0f},{0.819152f,-0.573577f,0.0f},
	{-0.573577f,-0.819152f,0.0f},{-0.819152f,0.573576f,0.0f},{0.573576f,0.819152f,0.0f},
	{-0.656059f,-0.754709f,0.0f},{-0.75471f,0.656059f,0.0f},{0.656059f,0.754709f,0.0f},
	{0.75471f,-0.656059f,0.0f},{0.0523362f,0.99863f,0.0f},{0.99863f,-0.0523358f,0.0f},
	{-0.99863f,0.0523361f,0.0f},{-0.0523356f,-0.99863f,0.0f},{0.976344f,0.216222f,0.0f},
	{0.999038f,0.0438422f,0.0f},{0.999038f,-0.0438419f,0.0f},{0.95365f,0.300918f,0.0f},
	{0.887114f,0.461551f,0.0f},{0.843272f,0.537488f,0.0f},{0.737428f,0.675426f,0.0f},
	{0.675426f,0.737428f,0.0f},{0.537488f,0.843271f,0.0f},{0.461551f,0.887114f,0.0f},
	{0.300918f,0.95365f,0.0f},{0.216222f,0.976344f,0.0f},{-0.216222f,0.976344f,0.0f},
	{-0.300918f,0.95365f,0.0f},{-0.461551f,0.887114f,0.0f},{-0.537488f,0.843271f,0.0f},
	{-0.675426f,0.737428f,0.0f},{-0.737428f,0.675426f,0.0f},{-0.887114f,0.461551f,0.0f},
	{-0.95365f,0.300918f,0.0f},{-0.976344f,0.216222f,0.0f},{-0.999038f,0.0438422f,0.0f},
	{-0.999038f,-0.0438419f,0.0f},{-0.976344f,-0.216222f,0.0f},{-0.95365f,-0.300918f,0.0f},
	{-0.887114f,-0.461551f,0.0f},{-0.843272f,-0.537487f,0.0f},{-0.737428f,-0.675426f,0.0f},
	{-0.537487f,-0.843272f,0.0f},{-0.461551f,-0.887114f,0.0f},{-0.300918f,-0.95365f,0.0f},
	{-0.216223f,-0.976344f,0.0f},{0.216223f,-0.976344f,0.0f},{0.300918f,-0.95365f,0.0f},
	{0.461551f,-0.887114f,0.0f},{0.537487f,-0.843272f,0.0f},{0.737428f,-0.675426f,0.0f},
	{0.843272f,-0.537487f,0.0f},{0.887114f,-0.461551f,0.0f},{0.95365f,-0.300918f,0.0f},
	{0.976344f,-0.216222f,0.0f},{0.999038f,-0.0438419f,0.0f},{0.95365f,-0.300918f,0.0f},
	{0.999038f,0.0438422f,0.0f},{0.976344f,0.216223f,0.0f},{0.95365f,0.300919f,0.0f},
	{0.843272f,0.537487f,0.0f},{0.737428f,0.675425f,0.0f},{0.675426f,0.737427f,0.0f},
	{0.537487f,0.843272f,0.0f},{0.46155f,0.887114f,0.0f},{0.300917f,0.95365f,0.0f},
	{0.216222f,0.976344f,0.0f},{-0.216222f,0.976344f,0.0f},{-0.300917f,0.95365f,0.0f},
	{-0.46155f,0.887114f,0.0f},{-0.537487f,0.843272f,0.0f},{-0.675426f,0.737427f,0.0f},
	{-0.737428f,0.675425f,0.0f},{-0.843272f,0.537487f,0.0f},{-0.95365f,0.300919f,0.0f},
	{-0.976344f,0.216223f,0.0f},{-0.999038f,0.0438423f,0.0f},{-0.999038f,-0.0438419f,0.0f},
	{-0.95365f,-0.300918f,0.0f},{-0.887114f,-0.461551f,0.0f},{-0.843272f,-0.537488f,0.0f},
	{-0.737428f,-0.675426f,0.0f},{-0.675426f,-0.737428f,0.0f},{-0.537487f,-0.843272f,0.0f},
	{-0.46155f,-0.887114f,0.0f},{-0.300918f,-0.95365f,0.0f},{-0.216223f,-0.976344f,0.0f},
	{0.216223f,-0.976344f,0.0f},{0.300918f,-0.95365f,0.0f},{0.46155f,-0.887114f,0.0f},
	{0.537487f,-0.843272f,0.0f},{0.675426f,-0.737428f,0.0f},{0.737428f,-0.675426f,0.0f},
	{0.843272f,-0.537488f,0.0f},{0.887114f,-0.461551f,0.0f},{0.675425f,0.0f,0.737428f},
	{0.537487f,0.0f,0.843272f},{0.737427f,0.0f,0.675426f},{0.461551f,0.0f,0.887114f},
	{-0.246606f,0.969116f,0.0f},{0.0174523f,0.999848f,0.0f},{-0.51205f,0.858956f,0.0f},
	{0.999848f,-0.0174525f,0.0f},{-0.280276f,-0.959919f,0.0f},{-0.0174527f,-0.999848f,0.0f},
	{-0.541713f,-0.840563f,0.0f},{-0.883543f,-0.46835f,0.0f},{-0.974387f,-0.224878f,0.0f},
	{-0.866661f,0.498898f,0.0f},{-0.965945f,0.258746f,0.0f},{-0.594086f,-2.59457e-017f,0.804401f},
	{-0.896202f,0.0f,0.443646f},{-0.963143f,0.0f,0.268992f},{-0.594086f,0.0f,0.804401f},
	{0.671854f,0.0f,0.740684f},{0.896202f,0.0f,0.443645f},{0.510314f,3.44194e-017f,0.859988f},
	{0.963143f,0.0f,0.268992f},{-0.999692f,0.0f,0.0248192f},{-0.999131f,0.0f,-0.0416723f},
	{0.999692f,0.0f,0.0248195f},{0.999131f,0.0f,-0.0416718f},{0.117889f,6.97562e-024f,0.993027f},
	{-0.117889f,6.97562e-024f,0.993027f},{-0.191561f,0.135167f,-0.972129f},{0.135166f,-0.191561f,-0.972129f},
	{-0.189136f,-0.189136f,-0.963564f},{0.191874f,0.191875f,-0.96248f},{-0.111885f,-0.637848f,-0.761992f},
	{0.111969f,-0.756227f,-0.644658f},{0.475795f,-0.589656f,-0.652629f},{0.692169f,-0.159017f,-0.704f},
	{0.756226f,0.111971f,-0.644658f},{0.589654f,0.475799f,-0.652628f},{0.157668f,0.784229f,-0.600105f},
	{-0.159016f,0.692171f,-0.703998f},{-0.589654f,0.475799f,-0.652628f},{-0.756226f,0.111971f,-0.644658f},
	{-0.692169f,-0.159017f,-0.704f},{-0.475795f,-0.589656f,-0.652629f},{-0.18929f,-0.948154f,-0.255292f},
	{0.189696f,-0.963344f,-0.189696f},{0.690093f,-0.696634f,-0.196146f},{0.961536f,-0.194226f,-0.194226f},
	{0.963343f,0.189697f,-0.189696f},{0.696632f,0.690094f,-0.196146f},{0.193823f,0.972682f,-0.127761f},
	{-0.194226f,0.961536f,-0.194226f},{-0.696632f,0.690094f,-0.196146f},{-0.963343f,0.189697f,-0.189696f},
	{-0.961536f,-0.194226f,-0.194226f},{-0.690093f,-0.696634f,-0.196146f},{-0.193823f,-0.972682f,0.127761f},
	{0.194226f,-0.961537f,0.194226f},{0.696633f,-0.690094f,0.196145f},{0.963344f,-0.189696f,0.189696f},
	{0.961536f,0.194227f,0.194226f},{0.690092f,0.696635f,0.196145f},{0.18929f,0.948154f,0.255292f},
	{-0.189696f,0.963344f,0.189695f},{-0.690092f,0.696635f,0.196145f},{-0.961536f,0.194227f,0.194226f},
	{-0.963344f,-0.189696f,0.189696f},{-0.696633f,-0.690094f,0.196145f},{-0.157668f,-0.784229f,0.600105f},
	{0.159016f,-0.69217f,0.703999f},{0.589655f,-0.475798f,0.652628f},{0.756227f,-0.11197f,0.644658f},
	{0.692169f,0.159018f,0.703999f},{0.475795f,0.589657f,0.652628f},{0.111885f,0.63785f,0.76199f},
	{-0.111969f,0.756227f,0.644657f},{-0.475795f,0.589657f,0.652628f},{-0.692169f,0.159018f,0.703999f},
	{-0.756227f,-0.11197f,0.644658f},{-0.589655f,-0.475797f,0.652628f},{-0.191874f,-0.191874f,0.962481f},
	{0.191561f,-0.135166f,0.972129f},{0.189136f,0.189137f,0.963564f},{-0.135166f,0.191562f,0.972129f},
	{-0.246606f,0.969116f,0.0f},{0.0174523f,0.999848f,0.0f},{-0.51205f,0.858956f,0.0f},
	{0.999848f,-0.0174525f,0.0f},{-0.280276f,-0.959919f,0.0f},{-0.0174527f,-0.999848f,0.0f},
	{-0.541713f,-0.840563f,0.0f},{-0.883543f,-0.46835f,0.0f},{-0.974387f,-0.224878f,0.0f},
	{-0.866661f,0.498898f,0.0f},{-0.965945f,0.258746f,0.0f},{-0.294687f,0.950862f,0.0949816f},
	{-0.78868f,0.53994f,-0.294022f},{-0.837299f,0.235887f,-0.493242f},{-0.788148f,-0.201672f,-0.581507f},
	{-0.679255f,-0.644536f,-0.35098f},{-0.294687f,-0.950862f,0.0949816f},{0.798053f,0.486684f,-0.355316f},
	{0.908925f,0.383255f,-0.16423f},{0.774796f,0.319605f,-0.545476f},{0.991567f,0.129492f,-0.00521468f},
	{0.712616f,0.150898f,-0.685134f},{0.985987f,-0.150896f,-0.0711299f},{0.667364f,-0.129494f,-0.733387f},
	{0.943564f,-0.235799f,-0.232565f},{0.730235f,-0.383259f,-0.565571f},{0.789779f,-0.541903f,-0.287386f},
	{0.5f,0.866025f,0.0f},{0.981981f,0.188982f,0.0f},{0.981981f,-0.188982f,0.0f},
	{-0.327327f,0.944911f,0.0f},{-0.654653f,0.755929f,0.0f},{-0.98198f,0.188983f,0.0f},
	{-0.981981f,-0.188982f,0.0f},{-0.654654f,-0.755929f,0.0f},{-0.327327f,-0.944911f,0.0f},
	{0.5f,-0.866025f,0.0f},{-0.707107f,0.0f,-0.707107f},{0.0f,0.346513f,-0.938045f},
	{-0.861807f,0.504835f,0.049288f},{-0.707107f,0.0f,0.707107f},{-1.34438e-008f,0.637952f,0.770076f},
	{0.861807f,0.504835f,0.049288f},{0.707107f,0.0f,0.707107f},{0.707107f,0.0f,-0.707107f},
	{-0.339811f,0.933648f,0.113271f},{0.339811f,0.933648f,0.113271f},{0.0f,0.886342f,-0.463031f},
	{0.0f,0.923879f,0.382684f},{0.956305f,-0.29237f,0.0f},{-0.292372f,-0.956305f,0.0f},
	{0.292372f,0.956305f,0.0f},{-0.956305f,0.29237f,0.0f},{-0.819152f,-0.573576f,0.0f},
	{-0.573576f,0.819152f,0.0f},{0.573577f,-0.819152f,0.0f},{0.819148f,0.573583f,0.0f},
	{0.656059f,-0.75471f,0.0f},{0.754709f,0.656059f,0.0f},{-0.656062f,0.754707f,0.0f},
	{-0.956305f,-0.29237f,0.0f},{0.292372f,-0.956305f,0.0f},{-0.292372f,0.956305f,0.0f},
	{0.956305f,0.29237f,0.0f},{0.819152f,-0.573576f,0.0f},{0.573576f,0.819152f,0.0f},
	{-0.573577f,-0.819152f,0.0f},{-0.819148f,0.573583f,0.0f},{-0.656059f,-0.75471f,0.0f},
	{-0.754709f,0.656059f,0.0f},{0.656062f,0.754707f,0.0f},{0.0f,0.99554f,0.0943452f},
	{0.0f,0.777376f,0.629036f},{0.0f,0.889515f,0.456905f},{0.0f,0.99554f,-0.0943454f},
	{0.0f,0.339592f,0.940573f},{0.0f,-0.224773f,0.974411f},{0.0f,-0.449546f,0.893257f},
	{0.0f,-0.777376f,0.629036f},{0.0f,-0.889515f,0.456905f},{0.0f,-0.99554f,0.0943452f},
	{0.0f,-0.99554f,-0.0943454f},{0.0f,-0.889515f,-0.456905f},{0.0f,-0.777376f,-0.629036f},
	{0.0f,-0.339592f,-0.940573f},{0.0f,0.449545f,-0.893257f},{0.0f,0.224773f,-0.974411f},
	{0.0f,0.889515f,-0.456905f},{0.0f,0.777376f,-0.629036f},{0.575641f,0.751416f,0.322508f},
	{0.393706f,0.889282f,-0.232753f},{0.263484f,0.731048f,0.6294f},{0.602801f,0.294763f,0.741449f},
	{0.366256f,0.296303f,0.882077f},{0.376002f,-0.196487f,0.905547f},{0.710008f,-0.296383f,0.638785f},
	{0.263484f,-0.731047f,0.629401f},{0.609066f,-0.748968f,0.260932f},{0.321745f,-0.911801f,-0.255147f},
	{0.110534f,-0.676158f,-0.728418f},{0.00735593f,-0.283657f,-0.958897f},{-0.00521153f,0.188186f,-0.98212f},
	{0.110534f,0.676158f,-0.728418f},{0.0f,-0.755915f,0.654669f},{0.0f,-0.28276f,0.959191f},
	{0.0f,-0.755915f,0.654669f},{0.0f,-0.14138f,0.989955f},{0.0f,-0.999969f,0.00781129f},
	{0.0f,-0.956969f,-0.29019f},{0.0f,-0.746718f,-0.66514f},{0.0f,-0.631364f,-0.775487f},
	{0.0f,-0.503342f,-0.864087f},{0.0f,-0.838611f,-0.54473f},{0.0f,-0.860041f,0.510225f},
	{0.0f,0.28276f,0.959191f},{0.0f,0.755915f,0.654669f},{0.0f,0.755915f,0.654669f},
	{0.0f,0.14138f,0.989955f},{0.0f,0.999969f,0.00781129f},{0.0f,0.956969f,-0.29019f},
	{0.0f,0.746718f,-0.66514f},{0.0f,0.631364f,-0.775487f},{0.0f,0.503342f,-0.864087f},
	{0.0f,0.838611f,-0.54473f},{0.0f,0.860041f,0.510225f},{0.0f,-0.999058f,0.0433854f},
	{0.0f,-0.759598f,-0.650393f},{0.0f,-0.916039f,-0.401089f},{0.0f,-0.972742f,0.231888f},
	{0.0f,-0.830378f,0.5572f},{0.0f,-0.718274f,0.69576f},{0.0f,-0.291018f,-0.956717f},
	{0.0f,-0.232385f,-0.972624f},{0.0f,-0.386045f,-0.92248f},{0.0f,-0.409627f,0.912253f},
	{0.0f,-0.204814f,0.978801f},{0.0f,0.291018f,-0.956717f},{0.0f,0.386045f,-0.92248f},
	{0.0f,0.193023f,-0.981194f},{0.0f,0.264587f,0.964362f},{0.0f,0.309017f,0.951056f},
	{0.0f,0.409627f,0.912253f},{0.0f,0.847041f,-0.531528f},{0.0f,0.759598f,-0.650393f},
	{0.0f,0.718274f,0.69576f},{0.0f,0.777419f,0.628983f},{0.0f,0.830378f,0.5572f},
	{0.0f,0.990395f,0.138264f},{0.0f,0.999058f,0.0433854f},{0.216223f,0.0f,0.976344f},
	{0.300919f,0.0f,0.95365f},{0.843271f,0.0f,0.537488f},{0.887114f,0.0f,0.461551f},
	{0.95365f,0.0f,0.300918f},{0.976344f,0.0f,0.216222f},{0.999038f,0.0f,0.0438423f},
	{0.999038f,0.0f,-0.0438417f},{0.976344f,0.0f,-0.216222f},{0.95365f,0.0f,-0.300918f},
	{0.887114f,0.0f,-0.461551f},{0.843271f,0.0f,-0.537488f},{0.737427f,0.0f,-0.675426f},
	{0.675425f,0.0f,-0.737428f},{0.537488f,0.0f,-0.843272f},{0.461552f,0.0f,-0.887113f},
	{0.300919f,0.0f,-0.95365f},{0.216222f,0.0f,-0.976344f},{-0.216222f,0.0f,-0.976344f},
	{-0.300919f,0.0f,-0.95365f},{-0.461552f,0.0f,-0.887113f},{-0.537488f,0.0f,-0.843272f},
	{-0.675425f,0.0f,-0.737428f},{-0.737427f,0.0f,-0.675426f},{-0.843271f,0.0f,-0.537488f},
	{-0.887114f,0.0f,-0.461551f},{-0.95365f,0.0f,-0.300918f},{-0.976344f,0.0f,-0.216222f},
	{-0.999038f,0.0f,-0.0438417f},{-0.999038f,0.0f,0.0438423f},{-0.976344f,0.0f,0.216222f},
	{-0.95365f,0.0f,0.300918f},{-0.887114f,0.0f,0.461551f},{-0.843271f,0.0f,0.537488f},
	{-0.737427f,0.0f,0.675426f},{-0.675425f,0.0f,0.737428f},{-0.537487f,0.0f,0.843272f},
	{-0.461551f,0.0f,0.887114f},{-0.300919f,0.0f,0.95365f},{-0.216223f,0.0f,0.976344f},
	{0.5f,0.866026f,0.0f},{0.98198f,0.188983f,0.0f},{0.981981f,-0.188982f,0.0f},
	{-0.327327f,0.944911f,0.0f},{-0.654653f,0.755929f,0.0f},{-0.98198f,0.188983f,0.0f},
	{-0.981981f,-0.188982f,0.0f},{-0.654654f,-0.755929f,0.0f},{-0.327327f,-0.944911f,0.0f},
	{0.5f,-0.866025f,0.0f},{0.5f,0.866026f,0.0f},{0.98198f,0.188983f,0.0f},
	{0.981981f,-0.188982f,0.0f},{-0.327327f,0.944911f,0.0f},{-0.654654f,0.755929f,0.0f},
	{-0.981981f,0.188982f,0.0f},{-0.981981f,-0.188982f,0.0f},{-0.654654f,-0.755929f,0.0f},
	{-0.327327f,-0.944911f,0.0f},{0.5f,-0.866025f,0.0f},{0.976344f,0.216221f,0.0f},
	{0.999038f,0.0438417f,0.0f},{0.999038f,-0.0438417f,0.0f},{0.95365f,0.300918f,0.0f},
	{0.887114f,0.461551f,0.0f},{0.843271f,0.537488f,0.0f},{0.737427f,0.675426f,0.0f},
	{0.675426f,0.737427f,0.0f},{0.537488f,0.843271f,0.0f},{0.461551f,0.887114f,0.0f},
	{0.300917f,0.95365f,0.0f},{0.216221f,0.976344f,0.0f},{1.27753e-007f,1.0f,0.0f},
	{-0.216222f,0.976344f,0.0f},{-0.300919f,0.95365f,0.0f},{-0.461551f,0.887113f,0.0f},
	{-0.675425f,0.737428f,0.0f},{-0.737427f,0.675427f,0.0f},{-0.843271f,0.537488f,0.0f},
	{-0.887114f,0.461551f,0.0f},{-0.95365f,0.300918f,0.0f},{-0.976344f,0.216221f,0.0f},
	{-0.999038f,0.0438417f,0.0f},{-0.999038f,-0.0438417f,0.0f},{-0.976344f,-0.216221f,0.0f},
	{-0.95365f,-0.300918f,0.0f},{-0.887114f,-0.461551f,0.0f},{-0.843271f,-0.537488f,0.0f},
	{-0.737427f,-0.675427f,0.0f},{-0.675425f,-0.737428f,0.0f},{-0.537488f,-0.843272f,0.0f},
	{-0.461551f,-0.887113f,0.0f},{-0.300919f,-0.95365f,0.0f},{-0.216222f,-0.976344f,0.0f},
	{1.27753e-007f,-1.0f,0.0f},{0.216221f,-0.976344f,0.0f},{0.300917f,-0.95365f,0.0f},
	{0.461551f,-0.887114f,0.0f},{0.537488f,-0.843271f,0.0f},{0.675426f,-0.737427f,0.0f},
	{0.737427f,-0.675426f,0.0f},{0.843271f,-0.537488f,0.0f},{0.887114f,-0.461551f,0.0f},
	{0.95365f,-0.300918f,0.0f},{0.976344f,-0.216221f,0.0f}
	};
	static GLfloat textures [1341][2] = {
	{0.323669f,0.85354f},{0.314493f,0.85354f},{0.319081f,0.852936f},
	{0.327944f,0.855311f},{0.310218f,0.855311f},{0.331615f,0.858128f},
	{0.306547f,0.858128f},{0.334432f,0.861799f},{0.30373f,0.861799f},
	{0.336203f,0.866074f},{0.301959f,0.866074f},{0.336807f,0.870662f},
	{0.301355f,0.870662f},{0.336203f,0.87525f},{0.301959f,0.87525f},
	{0.334432f,0.879525f},{0.30373f,0.879525f},{0.331615f,0.883196f},
	{0.306547f,0.883196f},{0.327944f,0.886013f},{0.310218f,0.886013f},
	{0.323669f,0.887784f},{0.314493f,0.887784f},{0.319081f,0.888388f},
	{0.414465f,0.0147735f},{0.245535f,0.0147735f},{0.33f,0.00365353f},
	{0.493173f,0.0473757f},{0.166827f,0.0473757f},{0.560762f,0.0992382f},
	{0.0992382f,0.0992382f},{0.569035f,0.190603f},{0.0952712f,0.186422f},
	{0.554613f,0.208786f},{0.10932f,0.205149f},{0.554613f,0.451214f},
	{0.10932f,0.454851f},{0.569035f,0.469397f},{0.0952712f,0.473578f},
	{0.560762f,0.560762f},{0.0992382f,0.560762f},{0.166827f,0.612624f},
	{0.493173f,0.612624f},{0.245535f,0.645227f},{0.414465f,0.645227f},
	{0.33f,0.656346f},{0.414465f,0.645227f},{0.245535f,0.645227f},
	{0.33f,0.656346f},{0.493173f,0.612624f},{0.166827f,0.612624f},
	{0.560762f,0.560762f},{0.0992382f,0.560762f},{0.0952712f,0.473578f},
	{0.569035f,0.469397f},{0.10932f,0.454851f},{0.554613f,0.451214f},
	{0.10932f,0.205149f},{0.554613f,0.208786f},{0.0952712f,0.186422f},
	{0.569035f,0.190603f},{0.0992382f,0.0992382f},{0.560762f,0.0992382f},
	{0.166827f,0.0473757f},{0.493173f,0.0473757f},{0.245535f,0.0147735f},
	{0.414465f,0.0147735f},{0.33f,0.00365353f},{0.597878f,0.208786f},
	{0.645227f,0.414465f},{0.597878f,0.451214f},{0.656346f,0.33f},
	{0.645227f,0.245535f},{0.597878f,0.451214f},{0.645227f,0.414465f},
	{0.645227f,0.245535f},{0.597878f,0.208786f},{0.0671744f,0.454851f},
	{0.0147735f,0.245535f},{0.0671744f,0.205149f},{0.00365355f,0.33f},
	{0.0147735f,0.414465f},{0.0671744f,0.205149f},{0.0147735f,0.414465f},
	{0.0671744f,0.454851f},{0.00365355f,0.33f},{0.0147735f,0.245535f},
	{0.0473757f,0.493173f},{0.0812228f,0.473578f},{0.612624f,0.493173f},
	{0.583456f,0.469397f},{0.583456f,0.190603f},{0.612624f,0.166827f},
	{0.0473757f,0.166827f},{0.0812228f,0.186422f},{0.0812228f,0.186422f},
	{0.0992382f,0.560762f},{0.0812228f,0.473578f},{0.0952712f,0.473578f},
	{0.569035f,0.469397f},{0.583456f,0.469397f},{0.597878f,0.208786f},
	{0.612624f,0.166827f},{0.645227f,0.245535f},{0.583456f,0.190603f},
	{0.560762f,0.0992382f},{0.612624f,0.166827f},{0.583456f,0.469397f},
	{0.645227f,0.414465f},{0.0473757f,0.493173f},{0.0671744f,0.454851f},
	{0.0812228f,0.473578f},{0.0147735f,0.245535f},{0.0812228f,0.186422f},
	{0.0671744f,0.205149f},{0.0473757f,0.166827f},{0.0952712f,0.186422f},
	{0.0812228f,0.186422f},{0.721629f,0.646052f},{0.739681f,0.677319f},
	{0.728597f,0.662874f},{0.719253f,0.628f},{0.754126f,0.688403f},
	{0.770948f,0.695371f},{0.721629f,0.609948f},{0.789f,0.697747f},
	{0.728597f,0.593126f},{0.807052f,0.695371f},{0.739681f,0.578681f},
	{0.823874f,0.688403f},{0.754126f,0.567597f},{0.770948f,0.560629f},
	{0.838319f,0.677319f},{0.789f,0.558253f},{0.849403f,0.662874f},
	{0.807052f,0.560629f},{0.856371f,0.646052f},{0.823874f,0.567597f},
	{0.858747f,0.628f},{0.856371f,0.609948f},{0.838319f,0.578681f},
	{0.849403f,0.593126f},{0.856371f,0.609948f},{0.845641f,0.628f},
	{0.843711f,0.61334f},{0.843711f,0.64266f},{0.838052f,0.65632f},
	{0.829051f,0.668051f},{0.81732f,0.677052f},{0.80366f,0.682711f},
	{0.789f,0.684641f},{0.77434f,0.682711f},{0.76068f,0.677052f},
	{0.748949f,0.668051f},{0.739948f,0.65632f},{0.734289f,0.64266f},
	{0.732359f,0.628f},{0.734289f,0.61334f},{0.739948f,0.59968f},
	{0.748949f,0.587949f},{0.76068f,0.578948f},{0.77434f,0.573289f},
	{0.789f,0.571359f},{0.80366f,0.573289f},{0.81732f,0.578948f},
	{0.829051f,0.587949f},{0.838052f,0.59968f},{0.603427f,0.983001f},
	{0.596508f,0.965923f},{0.622363f,0.990416f},{0.603202f,0.948845f},
	{0.639416f,0.978561f},{0.622363f,0.990416f},{0.596508f,0.965923f},
	{0.603427f,0.983001f},{0.603202f,0.948845f},{0.621389f,0.939124f},
	{0.643575f,0.956323f},{0.621389f,0.939124f},{0.643575f,0.956323f},
	{0.723227f,0.875101f},{0.682765f,0.845189f},{0.723227f,0.875101f},
	{0.682765f,0.845189f},{0.996492f,0.967923f},{0.987573f,0.984002f},
	{0.969637f,0.988416f},{0.990798f,0.946845f},{0.952584f,0.977561f},
	{0.969637f,0.988416f},{0.987573f,0.984002f},{0.990798f,0.946845f},
	{0.967611f,0.939124f},{0.947425f,0.957323f},{0.967611f,0.939124f},
	{0.706655f,0.44935f},{0.626667f,0.488578f},{0.626667f,0.488578f},
	{0.706655f,0.44935f},{0.883345f,0.44935f},{0.958333f,0.484578f},
	{0.795f,0.438584f},{0.883345f,0.44935f},{0.958333f,0.484578f},
	{0.795f,0.438584f},{0.947425f,0.957323f},{0.866773f,0.875101f},
	{0.905235f,0.844189f},{0.795f,0.892185f},{0.930858f,0.803347f},
	{0.659142f,0.803347f},{0.942058f,0.756538f},{0.648942f,0.757538f},
	{0.648942f,0.757538f},{0.659142f,0.803347f},{0.795f,0.892185f},
	{0.866773f,0.875101f},{0.905235f,0.844189f},{0.930858f,0.803347f},
	{0.942058f,0.756538f},{0.956019f,0.874458f},{0.996284f,0.883884f},
	{0.947715f,0.883884f},{0.987981f,0.874458f},{0.996284f,0.816116f},
	{0.987981f,0.825542f},{0.956019f,0.825542f},{0.947715f,0.816116f},
	{0.0883889f,0.0615906f},{0.0997527f,0.0172248f},{0.0997527f,0.0737752f},
	{0.0883889f,0.0294093f},{0.0315201f,0.0294094f},{0.0190443f,0.0172248f},
	{0.0190443f,0.0737752f},{0.0315201f,0.0615906f},{0.856477f,0.905666f},
	{0.735762f,0.923968f},{0.712523f,0.905666f},{0.833238f,0.923968f},
	{0.712523f,0.995334f},{0.735762f,0.977032f},{0.833238f,0.977032f},
	{0.856477f,0.995334f},{0.861269f,0.974658f},{0.891731f,0.922342f},
	{0.861269f,0.922342f},{0.891731f,0.974658f},{0.856477f,0.995334f},
	{0.75649f,0.420164f},{0.77623f,0.373595f},{0.77623f,0.42488f},
	{0.75649f,0.380346f},{0.683275f,0.380346f},{0.667025f,0.37363f},
	{0.667025f,0.42488f},{0.683275f,0.420164f},{0.531427f,0.976736f},
	{0.543176f,0.983519f},{0.536855f,0.980901f},{0.527262f,0.971308f},
	{0.549959f,0.984412f},{0.524644f,0.964987f},{0.556742f,0.983519f},
	{0.563063f,0.980901f},{0.523751f,0.958204f},{0.568491f,0.976736f},
	{0.524644f,0.951421f},{0.527262f,0.9451f},{0.572656f,0.971308f},
	{0.575274f,0.964987f},{0.531427f,0.939672f},{0.576167f,0.958204f},
	{0.536855f,0.935507f},{0.575274f,0.951421f},{0.543176f,0.932889f},
	{0.572656f,0.9451f},{0.549959f,0.931996f},{0.568491f,0.939672f},
	{0.556742f,0.932889f},{0.563063f,0.935507f},{0.582604f,0.967013f},
	{0.583756f,0.958263f},{0.579226f,0.975167f},{0.573853f,0.982169f},
	{0.566851f,0.987542f},{0.558697f,0.990919f},{0.549947f,0.992071f},
	{0.541197f,0.990919f},{0.533043f,0.987542f},{0.526041f,0.982169f},
	{0.520668f,0.975167f},{0.517291f,0.967013f},{0.516139f,0.958263f},
	{0.517291f,0.949512f},{0.520668f,0.941359f},{0.526041f,0.934357f},
	{0.533043f,0.928984f},{0.541197f,0.925606f},{0.549947f,0.924454f},
	{0.558697f,0.925606f},{0.566851f,0.928984f},{0.573853f,0.934357f},
	{0.579226f,0.941359f},{0.582604f,0.949512f},{0.586199f,0.948594f},
	{0.587478f,0.95831f},{0.586199f,0.968026f},{0.582448f,0.97708f},
	{0.576482f,0.984855f},{0.568708f,0.990821f},{0.559654f,0.994571f},
	{0.549938f,0.99585f},{0.540221f,0.994571f},{0.531168f,0.990821f},
	{0.523393f,0.984855f},{0.517427f,0.97708f},{0.513677f,0.968026f},
	{0.512398f,0.95831f},{0.513677f,0.948594f},{0.517427f,0.93954f},
	{0.523393f,0.931765f},{0.531168f,0.9258f},{0.540221f,0.922049f},
	{0.549938f,0.92077f},{0.559654f,0.922049f},{0.568708f,0.9258f},
	{0.576482f,0.931765f},{0.582448f,0.93954f},{0.590851f,0.958338f},
	{0.589456f,0.947747f},{0.589456f,0.968929f},{0.585369f,0.978797f},
	{0.578866f,0.987272f},{0.570391f,0.993775f},{0.560523f,0.997862f},
	{0.549932f,0.999257f},{0.539341f,0.997862f},{0.529473f,0.993775f},
	{0.520998f,0.987272f},{0.514495f,0.978797f},{0.510408f,0.968929f},
	{0.509013f,0.958338f},{0.510408f,0.947747f},{0.514495f,0.937879f},
	{0.520998f,0.929404f},{0.529473f,0.922902f},{0.539341f,0.918814f},
	{0.549932f,0.91742f},{0.560523f,0.918814f},{0.570391f,0.922902f},
	{0.578866f,0.929404f},{0.585369f,0.937879f},{0.56003f,0.60403f},
	{0.548196f,0.661804f},{0.548196f,0.592196f},{0.56003f,0.64997f},
	{0.60597f,0.64997f},{0.617804f,0.661804f},{0.617804f,0.592196f},
	{0.60597f,0.60403f},{0.332953f,0.928921f},{0.331092f,0.935596f},
	{0.335922f,0.93189f},{0.328993f,0.931961f},{0.96831f,0.433925f},
	{0.963361f,0.372075f},{0.96831f,0.372075f},{0.963361f,0.433925f},
	{0.938567f,0.433925f},{0.938567f,0.372075f},{0.933608f,0.372075f},
	{0.933608f,0.433925f},{0.931943f,0.372075f},{0.931943f,0.433925f},
	{0.96997f,0.433925f},{0.96997f,0.372075f},{0.993794f,0.433925f},
	{0.993794f,0.372075f},{0.161932f,0.87908f},{0.158689f,0.895981f},
	{0.158689f,0.88568f},{0.163607f,0.893146f},{0.171311f,0.88568f},
	{0.166393f,0.893146f},{0.168068f,0.87908f},{0.171311f,0.895981f},
	{0.162914f,0.897553f},{0.158689f,0.895981f},{0.171311f,0.895981f},
	{0.167086f,0.897553f},{0.166393f,0.893146f},{0.142484f,0.882416f},
	{0.146842f,0.864745f},{0.142484f,0.864825f},{0.146842f,0.883544f},
	{0.157329f,0.917317f},{0.146842f,0.911742f},{0.142484f,0.917382f},
	{0.153551f,0.911742f},{0.187516f,0.917382f},{0.176449f,0.911742f},
	{0.172671f,0.917317f},{0.183158f,0.911742f},{0.183158f,0.864745f},
	{0.187516f,0.882416f},{0.187516f,0.864825f},{0.183158f,0.883544f},
	{0.156172f,0.864745f},{0.157584f,0.871795f},{0.172416f,0.871795f},
	{0.173828f,0.864745f},{0.153892f,0.883544f},{0.176108f,0.883544f},
	{0.172443f,0.885224f},{0.170845f,0.877099f},{0.157557f,0.885224f},
	{0.160031f,0.877352f},{0.153317f,0.898426f},{0.176683f,0.898426f},
	{0.158689f,0.917207f},{0.162806f,0.903136f},{0.16285f,0.917171f},
	{0.158689f,0.895981f},{0.158689f,0.895981f},{0.162914f,0.897553f},
	{0.162806f,0.903136f},{0.16715f,0.917171f},{0.171311f,0.895981f},
	{0.171311f,0.917207f},{0.167194f,0.903136f},{0.167086f,0.897553f},
	{0.171311f,0.895981f},{0.167194f,0.903136f},{0.172827f,0.895195f},
	{0.157173f,0.895195f},{0.166393f,0.893146f},{0.165f,0.87743f},
	{0.165f,0.890795f},{0.165f,0.890795f},{0.163607f,0.893146f},
	{0.165f,0.865528f},{0.165f,0.864745f},{0.165f,0.873282f},
	{0.0138982f,0.617075f},{0.134102f,0.688925f},{0.134102f,0.617075f},
	{0.0138982f,0.688925f},{0.135089f,0.617075f},{0.135089f,0.688925f},
	{0.1348f,0.689514f},{0.134102f,0.689757f},{0.0138982f,0.689757f},
	{0.0132004f,0.689514f},{0.0129113f,0.688925f},{0.0129113f,0.617075f},
	{0.0132004f,0.616486f},{0.0138982f,0.616243f},{0.134102f,0.616243f},
	{0.1348f,0.616486f},{0.135497f,0.617075f},{0.135497f,0.688925f},
	{0.135497f,0.688925f},{0.135089f,0.689757f},{0.135089f,0.689757f},
	{0.134102f,0.690102f},{0.134102f,0.690102f},{0.0138982f,0.690102f},
	{0.0138982f,0.690102f},{0.0129113f,0.689757f},{0.0129113f,0.689757f},
	{0.0125026f,0.688925f},{0.0125026f,0.617075f},{0.0129113f,0.616243f},
	{0.0125026f,0.617075f},{0.0138982f,0.615898f},{0.0129113f,0.616243f},
	{0.134102f,0.615898f},{0.0138982f,0.615898f},{0.135089f,0.616243f},
	{0.134102f,0.615898f},{0.135089f,0.616243f},{0.147211f,0.610231f},
	{0.147211f,0.695769f},{0.146725f,0.696759f},{0.14555f,0.697169f},
	{0.0034503f,0.697169f},{0.00227538f,0.696759f},{0.00178879f,0.695769f},
	{0.00178879f,0.610231f},{0.00227538f,0.609241f},{0.0034503f,0.608831f},
	{0.14555f,0.608831f},{0.146725f,0.609241f},{0.135089f,0.616243f},
	{0.135089f,0.617075f},{0.135089f,0.688925f},{0.135089f,0.689757f},
	{0.135497f,0.688925f},{0.1348f,0.689514f},{0.134102f,0.690102f},
	{0.135089f,0.689757f},{0.134102f,0.689757f},{0.0138983f,0.690102f},
	{0.134102f,0.690102f},{0.0138983f,0.689757f},{0.0138983f,0.690102f},
	{0.0125026f,0.688925f},{0.0132004f,0.616486f},{0.0125026f,0.617075f},
	{0.0129113f,0.616243f},{0.0138983f,0.616243f},{0.0129113f,0.616243f},
	{0.0138983f,0.615898f},{0.134102f,0.616243f},{0.0138983f,0.615898f},
	{0.134102f,0.615898f},{0.1348f,0.616486f},{0.134102f,0.615898f},
	{0.135089f,0.616243f},{0.135089f,0.616243f},{0.135497f,0.617075f},
	{0.134102f,0.617075f},{0.134102f,0.688925f},{0.0138983f,0.688925f},
	{0.0138983f,0.617075f},{0.96331f,0.433925f},{0.938567f,0.439925f},
	{0.963361f,0.439925f},{0.938608f,0.433925f},{0.995459f,0.439925f},
	{0.96831f,0.439925f},{0.993794f,0.433925f},{0.96331f,0.366075f},
	{0.938608f,0.366075f},{0.993794f,0.372075f},{0.96831f,0.366075f},
	{0.995459f,0.366075f},{0.90031f,0.433925f},{0.895361f,0.372075f},
	{0.90031f,0.372075f},{0.895361f,0.433925f},{0.870567f,0.433925f},
	{0.870567f,0.372075f},{0.865608f,0.372075f},{0.865608f,0.433925f},
	{0.863943f,0.372075f},{0.863943f,0.433925f},{0.90197f,0.433925f},
	{0.90197f,0.372075f},{0.925794f,0.433925f},{0.925794f,0.372075f},
	{0.89531f,0.433925f},{0.870567f,0.439925f},{0.895361f,0.439925f},
	{0.870608f,0.433925f},{0.927459f,0.439925f},{0.90031f,0.439925f},
	{0.925794f,0.433925f},{0.89531f,0.366075f},{0.870608f,0.366075f},
	{0.925794f,0.372075f},{0.90031f,0.366075f},{0.927459f,0.366075f},
	{0.392351f,0.929205f},{0.394235f,0.933179f},{0.394235f,0.92523f},
	{0.399166f,0.922773f},{0.399166f,0.935636f},{0.405262f,0.922773f},
	{0.405262f,0.935636f},{0.410193f,0.92523f},{0.410193f,0.933179f},
	{0.412077f,0.929205f},{0.413063f,0.929205f},{0.414947f,0.92523f},
	{0.414947f,0.933179f},{0.419878f,0.935636f},{0.419878f,0.922773f},
	{0.425974f,0.935636f},{0.425974f,0.922773f},{0.430905f,0.933179f},
	{0.430905f,0.92523f},{0.432789f,0.929205f},{0.598507f,0.911075f},
	{0.597608f,0.909178f},{0.597608f,0.912972f},{0.595255f,0.914145f},
	{0.595255f,0.908006f},{0.592345f,0.914145f},{0.592345f,0.908006f},
	{0.589992f,0.912972f},{0.589992f,0.909178f},{0.589093f,0.911075f},
	{0.482529f,0.924795f},{0.482024f,0.926044f},{0.482024f,0.923545f},
	{0.480701f,0.926816f},{0.480701f,0.923123f},{0.479066f,0.926816f},
	{0.479066f,0.923123f},{0.477744f,0.926044f},{0.477744f,0.923545f},
	{0.477239f,0.924795f},{0.363577f,0.791328f},{0.36645f,0.777604f},
	{0.366757f,0.796168f},{0.37825f,0.772257f},{0.37825f,0.801813f},
	{0.392455f,0.772257f},{0.392455f,0.801813f},{0.404254f,0.777604f},
	{0.403947f,0.796168f},{0.407127f,0.791328f},{0.398362f,0.87455f},
	{0.398042f,0.855986f},{0.395052f,0.86971f},{0.410322f,0.850639f},
	{0.410322f,0.880195f},{0.425107f,0.880195f},{0.425107f,0.850639f},
	{0.437068f,0.87455f},{0.437387f,0.855986f},{0.440378f,0.86971f},
	{0.440729f,0.796168f},{0.440422f,0.777604f},{0.437549f,0.791328f},
	{0.452221f,0.772257f},{0.452221f,0.801813f},{0.466426f,0.801813f},
	{0.466426f,0.772257f},{0.477919f,0.796168f},{0.478226f,0.777604f},
	{0.481099f,0.791328f},{0.34882f,0.86971f},{0.35181f,0.855986f},
	{0.352129f,0.87455f},{0.36409f,0.850639f},{0.36409f,0.880195f},
	{0.378875f,0.850639f},{0.378875f,0.880195f},{0.391155f,0.855986f},
	{0.390836f,0.87455f},{0.394145f,0.86971f},{0.41139f,0.954392f},
	{0.406f,0.981608f},{0.406f,0.954392f},{0.41139f,0.981608f},
	{0.41678f,0.981608f},{0.41678f,0.954392f},{0.42217f,0.981608f},
	{0.42217f,0.954392f},{0.39522f,0.981608f},{0.38983f,0.954392f},
	{0.39522f,0.954392f},{0.38983f,0.981608f},{0.40061f,0.981608f},
	{0.40061f,0.954392f},{0.603938f,0.738937f},{0.54825f,0.75075f},
	{0.560062f,0.738937f},{0.61575f,0.75075f},{0.560062f,0.695063f},
	{0.54825f,0.68325f},{0.61575f,0.68325f},{0.603938f,0.695063f},
	{0.524469f,0.892262f},{0.532875f,0.880778f},{0.524469f,0.880778f},
	{0.532875f,0.892262f},{0.552229f,0.850069f},{0.569841f,0.844588f},
	{0.552229f,0.844588f},{0.569841f,0.850069f},{0.487503f,0.892262f},
	{0.505116f,0.880778f},{0.487503f,0.880778f},{0.505116f,0.892262f},
	{0.588334f,0.844588f},{0.570721f,0.850069f},{0.570721f,0.844588f},
	{0.588334f,0.850069f},{0.523609f,0.880778f},{0.505996f,0.892262f},
	{0.505996f,0.880778f},{0.523609f,0.892262f},{0.625339f,0.850631f},
	{0.616933f,0.862115f},{0.616933f,0.850631f},{0.625339f,0.862115f},
	{0.625319f,0.88652f},{0.607707f,0.88652f},{0.616513f,0.880778f},
	{0.616513f,0.892262f},{0.568381f,0.914145f},{0.577795f,0.908006f},
	{0.568381f,0.908006f},{0.577795f,0.914145f},{0.59802f,0.868706f},
	{0.589214f,0.874187f},{0.589214f,0.868706f},{0.59802f,0.874187f},
	{0.606826f,0.874187f},{0.59802f,0.868706f},{0.606826f,0.868706f},
	{0.567439f,0.908006f},{0.558025f,0.914145f},{0.558025f,0.908006f},
	{0.567439f,0.914145f},{0.537366f,0.891167f},{0.565845f,0.891167f},
	{0.551606f,0.878677f},{0.551606f,0.903657f},{0.606826f,0.862676f},
	{0.606515f,0.868157f},{0.606515f,0.862676f},{0.606826f,0.868157f},
	{0.589214f,0.862676f},{0.589214f,0.868157f},{0.589525f,0.862676f},
	{0.606826f,0.868157f},{0.589525f,0.868157f},{0.589214f,0.868157f},
	{0.589525f,0.868157f},{0.526015f,0.908006f},{0.516601f,0.914145f},
	{0.516601f,0.908006f},{0.526015f,0.914145f},{0.607707f,0.850069f},
	{0.625319f,0.844588f},{0.607707f,0.844588f},{0.625319f,0.850069f},
	{0.551348f,0.862676f},{0.533736f,0.868157f},{0.533736f,0.862676f},
	{0.551348f,0.868157f},{0.526957f,0.914145f},{0.536371f,0.908006f},
	{0.526957f,0.908006f},{0.536371f,0.914145f},{0.460461f,0.874735f},
	{0.459764f,0.880216f},{0.459764f,0.874735f},{0.460461f,0.880216f},
	{0.47668f,0.874735f},{0.47668f,0.880216f},{0.477376f,0.874735f},
	{0.477376f,0.880216f},{0.571578f,0.874735f},{0.570721f,0.880216f},
	{0.570721f,0.874735f},{0.571578f,0.880216f},{0.587477f,0.874735f},
	{0.587477f,0.880216f},{0.588334f,0.874735f},{0.571578f,0.880216f},
	{0.588334f,0.880216f},{0.587477f,0.880216f},{0.588334f,0.880216f},
	{0.534047f,0.874187f},{0.533736f,0.868706f},{0.534047f,0.868706f},
	{0.533736f,0.874187f},{0.551348f,0.868706f},{0.534047f,0.874187f},
	{0.534047f,0.868706f},{0.551348f,0.874187f},{0.607707f,0.868157f},
	{0.625008f,0.862676f},{0.607707f,0.862676f},{0.625008f,0.868157f},
	{0.625319f,0.868157f},{0.625319f,0.862676f},{0.557083f,0.914145f},
	{0.547669f,0.908006f},{0.557083f,0.908006f},{0.547669f,0.914145f},
	{0.569841f,0.862676f},{0.552229f,0.868157f},{0.552229f,0.862676f},
	{0.569841f,0.868157f},{0.589214f,0.850069f},{0.606826f,0.844588f},
	{0.589214f,0.844588f},{0.606826f,0.850069f},{0.537313f,0.908006f},
	{0.546727f,0.914145f},{0.546727f,0.908006f},{0.537313f,0.914145f},
	{0.495869f,0.880216f},{0.495172f,0.874735f},{0.495869f,0.874735f},
	{0.495172f,0.880216f},{0.478954f,0.874735f},{0.478954f,0.880216f},
	{0.478257f,0.874735f},{0.478257f,0.880216f},{0.372889f,0.922145f},
	{0.371639f,0.916006f},{0.372889f,0.916006f},{0.371639f,0.922145f},
	{0.391365f,0.916006f},{0.372889f,0.922145f},{0.372889f,0.916006f},
	{0.391365f,0.922145f},{0.371639f,0.922145f},{0.390114f,0.916006f},
	{0.371639f,0.916006f},{0.390114f,0.922145f},{0.390114f,0.916006f},
	{0.391365f,0.922145f},{0.391365f,0.916006f},{0.390114f,0.922145f},
	{0.453501f,0.916006f},{0.433775f,0.922145f},{0.433775f,0.916006f},
	{0.453501f,0.922145f},{0.515243f,0.850069f},{0.532855f,0.844588f},
	{0.515243f,0.844588f},{0.532855f,0.850069f},{0.625319f,0.790336f},
	{0.607707f,0.801821f},{0.607707f,0.790336f},{0.625319f,0.801821f},
	{0.495869f,0.844588f},{0.478257f,0.850069f},{0.478257f,0.844588f},
	{0.495869f,0.850069f},{0.46901f,0.892262f},{0.486623f,0.880778f},
	{0.46901f,0.880778f},{0.486623f,0.892262f},{0.454487f,0.922145f},
	{0.474213f,0.916006f},{0.454487f,0.916006f},{0.474213f,0.922145f},
	{0.412077f,0.922145f},{0.392351f,0.916006f},{0.412077f,0.916006f},
	{0.392351f,0.922145f},{0.514362f,0.844588f},{0.49675f,0.850069f},
	{0.49675f,0.844588f},{0.514362f,0.850069f},{0.46813f,0.892262f},
	{0.450518f,0.880778f},{0.46813f,0.880778f},{0.450518f,0.892262f},
	{0.533736f,0.850069f},{0.551348f,0.844588f},{0.533736f,0.844588f},
	{0.551348f,0.850069f},{0.432025f,0.880778f},{0.449637f,0.892262f},
	{0.449637f,0.880778f},{0.432025f,0.892262f},{0.413063f,0.916006f},
	{0.432789f,0.922145f},{0.432789f,0.916006f},{0.413063f,0.922145f},
	{0.44963f,0.892841f},{0.44963f,0.910346f},{0.422785f,0.910346f},
	{0.422785f,0.892841f},{0.607707f,0.819905f},{0.625319f,0.819905f},
	{0.625319f,0.8024f},{0.607707f,0.8024f},{0.431137f,0.880778f},
	{0.431137f,0.892262f},{0.404292f,0.892262f},{0.404292f,0.880778f},
	{0.421898f,0.892841f},{0.421898f,0.910346f},{0.404285f,0.910346f},
	{0.404285f,0.892841f},{0.376553f,0.892262f},{0.403398f,0.892262f},
	{0.403398f,0.880778f},{0.376553f,0.880778f},{0.450525f,0.910346f},
	{0.477369f,0.910346f},{0.477369f,0.892841f},{0.450525f,0.892841f},
	{0.552229f,0.871446f},{0.552229f,0.874187f},{0.569841f,0.874187f},
	{0.569841f,0.871446f},{0.570721f,0.892262f},{0.570721f,0.888713f},
	{0.588334f,0.888713f},{0.588334f,0.892262f},{0.570721f,0.884326f},
	{0.588334f,0.884326f},{0.570721f,0.880778f},{0.588334f,0.880778f},
	{0.588334f,0.874187f},{0.570721f,0.874187f},{0.570721f,0.871446f},
	{0.588334f,0.871446f},{0.570721f,0.868706f},{0.588334f,0.868706f},
	{0.606826f,0.880778f},{0.589214f,0.880778f},{0.589214f,0.884326f},
	{0.606826f,0.884326f},{0.589214f,0.888713f},{0.606826f,0.888713f},
	{0.589214f,0.892262f},{0.606826f,0.892262f},{0.552229f,0.868706f},
	{0.569841f,0.868706f},{0.589214f,0.878955f},{0.60617f,0.876987f},
	{0.605062f,0.875861f},{0.589214f,0.879616f},{0.483692f,0.934097f},
	{0.481339f,0.929094f},{0.483692f,0.92772f},{0.481339f,0.935636f},
	{0.478429f,0.935636f},{0.478429f,0.929094f},{0.476076f,0.934097f},
	{0.476076f,0.92772f},{0.624663f,0.876987f},{0.607707f,0.878955f},
	{0.623555f,0.875861f},{0.607707f,0.880216f},{0.607707f,0.877694f},
	{0.622446f,0.874735f},{0.36804f,0.916006f},{0.350927f,0.917903f},
	{0.367245f,0.917903f},{0.350927f,0.916006f},{0.367245f,0.920248f},
	{0.350927f,0.920248f},{0.36804f,0.922145f},{0.350927f,0.922145f},
	{0.589214f,0.877694f},{0.603953f,0.874735f},{0.484591f,0.925496f},
	{0.482529f,0.924795f},{0.483692f,0.92772f},{0.606204f,0.874873f},
	{0.606826f,0.875506f},{0.36804f,0.922145f},{0.370206f,0.919734f},
	{0.370653f,0.9208f},{0.370206f,0.918416f},{0.36804f,0.916006f},
	{0.370653f,0.91735f},{0.624697f,0.874873f},{0.625319f,0.875506f},
	{0.477239f,0.924795f},{0.476076f,0.92772f},{0.475176f,0.925496f},
	{0.476076f,0.92772f},{0.483692f,0.92772f},{0.625319f,0.82049f},
	{0.607707f,0.84402f},{0.607707f,0.82049f},{0.625319f,0.84402f},
	{0.441251f,0.874167f},{0.449657f,0.850637f},{0.441251f,0.850637f},
	{0.449657f,0.874167f},{0.625319f,0.868706f},{0.607707f,0.873687f},
	{0.607707f,0.868706f},{0.625319f,0.873687f},{0.477396f,0.850637f},
	{0.468991f,0.874167f},{0.468991f,0.850637f},{0.477396f,0.874167f},
	{0.441271f,0.880216f},{0.458883f,0.874735f},{0.441271f,0.874735f},
	{0.458883f,0.880216f},{0.450518f,0.874167f},{0.46813f,0.850637f},
	{0.450518f,0.850637f},{0.46813f,0.874167f},{0.616066f,0.850631f},
	{0.589221f,0.862115f},{0.589221f,0.850631f},{0.616066f,0.862115f},
	{0.348814f,0.892262f},{0.375658f,0.880778f},{0.348814f,0.880778f},
	{0.375658f,0.892262f},{0.505109f,0.850635f},{0.478264f,0.86814f},
	{0.478264f,0.850635f},{0.505109f,0.86814f},{0.551341f,0.790336f},
	{0.524496f,0.801821f},{0.524496f,0.790336f},{0.551341f,0.801821f},
	{0.376553f,0.910346f},{0.403398f,0.892841f},{0.376553f,0.892841f},
	{0.403398f,0.910346f},{0.579975f,0.801821f},{0.606819f,0.790336f},
	{0.579975f,0.790336f},{0.606819f,0.801821f},{0.453523f,0.922773f},
	{0.444109f,0.927427f},{0.444109f,0.922773f},{0.453523f,0.927427f},
	{0.505303f,0.914145f},{0.495889f,0.910873f},{0.505303f,0.910873f},
	{0.495889f,0.914145f},{0.35168f,0.783421f},{0.355109f,0.791328f},
	{0.505303f,0.910873f},{0.495889f,0.908006f},{0.505303f,0.908006f},
	{0.477361f,0.802406f},{0.472092f,0.812855f},{0.477361f,0.812855f},
	{0.472092f,0.802406f},{0.453523f,0.927427f},{0.444109f,0.935636f},
	{0.453523f,0.935636f},{0.348823f,0.786421f},{0.350308f,0.789845f},
	{0.464821f,0.930982f},{0.474235f,0.935636f},{0.464821f,0.935636f},
	{0.474235f,0.930982f},{0.506245f,0.910873f},{0.515659f,0.914145f},
	{0.515659f,0.910873f},{0.506245f,0.914145f},{0.419025f,0.783421f},
	{0.415595f,0.791328f},{0.506245f,0.908006f},{0.515659f,0.910873f},
	{0.515659f,0.908006f},{0.472092f,0.839597f},{0.477361f,0.850046f},
	{0.477361f,0.839597f},{0.472092f,0.850046f},{0.464821f,0.922773f},
	{0.474235f,0.930982f},{0.474235f,0.922773f},{0.421881f,0.786421f},
	{0.420396f,0.789845f},{0.535784f,0.891167f},{0.551606f,0.877289f},
	{0.567428f,0.891167f},{0.551606f,0.905045f},{0.567428f,0.891167f},
	{0.551606f,0.905045f},{0.535784f,0.891167f},{0.504617f,0.815341f},
	{0.542086f,0.8024f},{0.542086f,0.815341f},{0.504617f,0.8024f},
	{0.478272f,0.8024f},{0.478272f,0.815341f},{0.504617f,0.8024f},
	{0.504617f,0.819905f},{0.542086f,0.815341f},{0.542086f,0.819905f},
	{0.478272f,0.819905f},{0.439892f,0.812855f},{0.477361f,0.821201f},
	{0.439892f,0.821201f},{0.413547f,0.821201f},{0.413547f,0.812855f},
	{0.569343f,0.827761f},{0.606811f,0.82049f},{0.606811f,0.827761f},
	{0.569343f,0.82049f},{0.542997f,0.82049f},{0.542997f,0.827761f},
	{0.569343f,0.82049f},{0.439892f,0.83125f},{0.477361f,0.83125f},
	{0.413547f,0.83125f},{0.569343f,0.836749f},{0.606811f,0.827761f},
	{0.606811f,0.836749f},{0.542997f,0.836749f},{0.477361f,0.83125f},
	{0.439892f,0.839597f},{0.413547f,0.839597f},{0.606811f,0.84402f},
	{0.606811f,0.836749f},{0.569343f,0.84402f},{0.569343f,0.84402f},
	{0.542997f,0.84402f},{0.560579f,0.772253f},{0.52311f,0.785194f},
	{0.560579f,0.785194f},{0.52311f,0.772253f},{0.496765f,0.785194f},
	{0.496765f,0.772253f},{0.560579f,0.785194f},{0.52311f,0.789758f},
	{0.560579f,0.789758f},{0.496765f,0.789758f},{0.57908f,0.801821f},
	{0.552235f,0.790336f},{0.57908f,0.790336f},{0.552235f,0.801821f},
	{0.523601f,0.790336f},{0.496757f,0.801821f},{0.496757f,0.790336f},
	{0.523601f,0.801821f},{0.375658f,0.910346f},{0.348814f,0.892841f},
	{0.375658f,0.892841f},{0.348814f,0.910346f},{0.533743f,0.862115f},
	{0.560587f,0.850631f},{0.533743f,0.850631f},{0.560587f,0.862115f},
	{0.506003f,0.850635f},{0.532848f,0.86814f},{0.532848f,0.850635f},
	{0.506003f,0.86814f},{0.561482f,0.850631f},{0.588327f,0.862115f},
	{0.588327f,0.850631f},{0.561482f,0.862115f},{0.443167f,0.927427f},
	{0.433753f,0.922773f},{0.443167f,0.922773f},{0.433753f,0.927427f},
	{0.494947f,0.910873f},{0.485533f,0.914145f},{0.485533f,0.910873f},
	{0.494947f,0.914145f},{0.425651f,0.783421f},{0.429081f,0.791328f},
	{0.494947f,0.908006f},{0.485533f,0.910873f},{0.485533f,0.908006f},
	{0.354091f,0.812855f},{0.348822f,0.802406f},{0.348822f,0.812855f},
	{0.354091f,0.802406f},{0.443167f,0.935636f},{0.433753f,0.927427f},
	{0.433753f,0.935636f},{0.422795f,0.786421f},{0.42428f,0.789845f},
	{0.454465f,0.935636f},{0.463879f,0.930982f},{0.463879f,0.935636f},
	{0.454465f,0.930982f},{0.475176f,0.922145f},{0.484591f,0.918873f},
	{0.475176f,0.918873f},{0.484591f,0.922145f},{0.492996f,0.783421f},
	{0.489567f,0.791328f},{0.475176f,0.918873f},{0.484591f,0.916006f},
	{0.475176f,0.916006f},{0.348822f,0.850046f},{0.354091f,0.839597f},
	{0.348822f,0.839597f},{0.354091f,0.850046f},{0.454465f,0.930982f},
	{0.463879f,0.922773f},{0.454465f,0.922773f},{0.495853f,0.786421f},
	{0.494368f,0.789845f},{0.56149f,0.772253f},{0.598959f,0.785194f},
	{0.56149f,0.785194f},{0.598959f,0.772253f},{0.625304f,0.772253f},
	{0.625304f,0.785194f},{0.56149f,0.785194f},{0.598959f,0.789758f},
	{0.56149f,0.789758f},{0.625304f,0.789758f},{0.348822f,0.821201f},
	{0.386291f,0.812855f},{0.386291f,0.821201f},{0.412636f,0.821201f},
	{0.412636f,0.812855f},{0.478272f,0.82049f},{0.515741f,0.827761f},
	{0.478272f,0.827761f},{0.515741f,0.82049f},{0.542086f,0.82049f},
	{0.542086f,0.827761f},{0.515741f,0.82049f},{0.386291f,0.83125f},
	{0.348822f,0.83125f},{0.412636f,0.83125f},{0.478272f,0.827761f},
	{0.515741f,0.836749f},{0.478272f,0.836749f},{0.542086f,0.836749f},
	{0.386291f,0.839597f},{0.348822f,0.83125f},{0.412636f,0.839597f},
	{0.478272f,0.84402f},{0.515741f,0.84402f},{0.542086f,0.84402f},
	{0.580466f,0.815341f},{0.542997f,0.8024f},{0.542997f,0.815341f},
	{0.580466f,0.8024f},{0.580466f,0.8024f},{0.606811f,0.815341f},
	{0.606811f,0.8024f},{0.580466f,0.819905f},{0.542997f,0.815341f},
	{0.542997f,0.819905f},{0.606811f,0.819905f},{0.580466f,0.819905f},
	{0.31943f,0.934523f},{0.32438f,0.933871f},{0.31448f,0.933871f},
	{0.309868f,0.931961f},{0.305907f,0.928921f},{0.302867f,0.924961f},
	{0.335993f,0.924961f},{0.300957f,0.920348f},{0.337903f,0.920348f},
	{0.300305f,0.915398f},{0.338555f,0.915398f},{0.300957f,0.910448f},
	{0.337903f,0.910448f},{0.302867f,0.905835f},{0.335993f,0.905835f},
	{0.305907f,0.901874f},{0.332953f,0.901874f},{0.309868f,0.898835f},
	{0.328993f,0.898835f},{0.31448f,0.896925f},{0.32438f,0.896925f},
	{0.31943f,0.896273f},{0.31943f,0.938721f},{0.325466f,0.937927f},
	{0.339628f,0.92706f},{0.341958f,0.921435f},{0.342753f,0.915398f},
	{0.341958f,0.909361f},{0.339628f,0.903736f},{0.335922f,0.898906f},
	{0.331092f,0.8952f},{0.325466f,0.892869f},{0.31943f,0.892075f},
	{0.313394f,0.892869f},{0.307768f,0.8952f},{0.302938f,0.898906f},
	{0.299231f,0.903736f},{0.296902f,0.909361f},{0.296107f,0.915398f},
	{0.296902f,0.921435f},{0.299231f,0.92706f},{0.302938f,0.93189f},
	{0.307768f,0.935596f},{0.313394f,0.937927f},{0.37339f,0.954392f},
	{0.368f,0.981608f},{0.368f,0.954392f},{0.37339f,0.981608f},
	{0.37878f,0.981608f},{0.37878f,0.954392f},{0.38417f,0.981608f},
	{0.38417f,0.954392f},{0.35722f,0.981608f},{0.35183f,0.954392f},
	{0.35722f,0.954392f},{0.35183f,0.981608f},{0.36261f,0.981608f},
	{0.36261f,0.954392f},{0.44939f,0.954392f},{0.444f,0.981608f},
	{0.444f,0.954392f},{0.44939f,0.981608f},{0.45478f,0.981608f},
	{0.45478f,0.954392f},{0.46017f,0.981608f},{0.46017f,0.954392f},
	{0.43322f,0.981608f},{0.42783f,0.954392f},{0.43322f,0.954392f},
	{0.42783f,0.980524f},{0.43861f,0.981608f},{0.43861f,0.954392f},
	{0.523691f,0.659941f},{0.514215f,0.654315f},{0.524431f,0.654315f},
	{0.513823f,0.657297f},{0.521519f,0.665183f},{0.512672f,0.660075f},
	{0.518065f,0.669685f},{0.510841f,0.662461f},{0.513563f,0.673139f},
	{0.508455f,0.664292f},{0.508321f,0.675311f},{0.505677f,0.665443f},
	{0.502695f,0.676051f},{0.502695f,0.665835f},{0.499713f,0.665443f},
	{0.497069f,0.675311f},{0.496935f,0.664292f},{0.491827f,0.673139f},
	{0.494549f,0.662461f},{0.487325f,0.669685f},{0.492718f,0.660075f},
	{0.483871f,0.665183f},{0.491567f,0.657297f},{0.481699f,0.659941f},
	{0.491175f,0.654315f},{0.480959f,0.654315f},{0.491567f,0.651333f},
	{0.481699f,0.648689f},{0.492718f,0.648555f},{0.483871f,0.643447f},
	{0.494549f,0.646169f},{0.487325f,0.638945f},{0.496935f,0.644338f},
	{0.491827f,0.635491f},{0.499713f,0.643187f},{0.497069f,0.633319f},
	{0.502695f,0.642795f},{0.502695f,0.632579f},{0.508321f,0.633319f},
	{0.505677f,0.643187f},{0.513563f,0.635491f},{0.508455f,0.644338f},
	{0.518065f,0.638945f},{0.510841f,0.646169f},{0.521519f,0.643447f},
	{0.512672f,0.648555f},{0.523691f,0.648689f},{0.513823f,0.651333f}
	};
	GLint GenEPuckRest()
	{
	unsigned i;
	unsigned j;
	
	GLint lid=glGenLists(1);
	glNewList(lid, GL_COMPILE);
	
		glBegin (GL_TRIANGLES);
		for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
		{
		for(j=0;j<3;j++)
			{
			int vi=face_indicies[i][j];
			int ni=face_indicies[i][j+3];//Normal index
			int ti=face_indicies[i][j+6];//Texture index
			/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
			
			// rotate 90 deg around z
			glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][1],-vertices[vi][0],vertices[vi][2]);
			}
		}
		glEnd ();
	
	glEndList();
	return lid;
	};
}
