
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2008 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://lis.epfl.ch/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// E-puck object file

#include <QtOpenGL>

namespace Enki
{
	// 262 Verticies
	// 610 Texture Coordinates
	// 275 Normals
	// 536 Triangles
	
	static short face_indicies[536][9] = {
	// (unnamed)
		{204,188,217 ,0,1,2 ,0,1,2 }, {179,162,172 ,3,4,5 ,3,4,5 }, {179,180,162 ,3,0,4 ,3,6,4 },
		{235,261,233 ,6,7,8 ,7,8,9 }, {235,244,261 ,6,9,7 ,7,10,8 },
		{231,261,1 ,10,7,11 ,11,8,12 }, {231,233,261 ,10,8,7 ,11,9,8 },
		{257,1,261 ,12,11,7 ,13,12,8 }, {234,247,235 ,13,14,6 ,14,15,7 },
		{234,246,247 ,13,15,14 ,14,16,15 }, {215,234,196 ,16,13,0 ,17,14,18 },
		{215,245,234 ,16,17,13 ,17,19,14 }, {245,246,234 ,17,15,13 ,19,16,14 },
		{216,196,205 ,18,0,0 ,20,18,21 }, {216,215,196 ,18,16,0 ,20,17,18 },
		{162,150,172 ,4,19,5 ,4,22,5 }, {162,149,150 ,4,20,19 ,4,23,22 },
		{205,204,216 ,0,0,18 ,21,24,20 }, {188,179,172 ,1,3,5 ,1,3,5 },
		{188,189,179 ,1,21,3 ,1,25,3 }, {247,244,235 ,14,9,6 ,15,10,7 },
		{216,204,217 ,18,0,2 ,20,24,26 }, {217,188,172 ,2,1,5 ,2,1,5 },
		{231,222,223 ,10,22,23 ,11,27,28 }, {231,0,222 ,10,24,22 ,11,29,27 },
		{2,231,1 ,25,10,11 ,30,11,12 }, {2,0,231 ,25,24,10 ,30,29,11 },
		{183,199,211 ,26,21,27 ,31,32,33 }, {154,176,166 ,28,29,30 ,34,35,36 },
		{154,175,176 ,28,21,29 ,34,37,35 }, {249,226,225 ,31,32,33 ,38,39,40 },
		{249,238,226 ,31,34,32 ,38,41,39 }, {249,229,3 ,31,35,36 ,38,42,43 },
		{249,225,229 ,31,33,35 ,38,40,42 }, {249,3,253 ,31,36,37 ,38,43,44 },
		{241,227,226 ,38,39,32 ,45,46,39 }, {241,240,227 ,38,40,39 ,45,47,46 },
		{227,209,192 ,39,41,21 ,46,48,49 }, {227,239,209 ,39,42,41 ,46,50,48 },
		{240,239,227 ,40,42,39 ,47,50,46 }, {192,210,200 ,21,43,21 ,49,51,52 },
		{192,209,210 ,21,41,43 ,49,48,51 }, {142,154,166 ,44,28,30 ,53,34,36 },
		{142,143,154 ,44,45,28 ,53,54,34 }, {199,200,210 ,21,21,43 ,32,52,51 },
		{176,183,166 ,29,26,30 ,35,31,36 }, {176,184,183 ,29,0,26 ,35,55,31 },
		{238,241,226 ,34,38,32 ,41,45,39 }, {199,210,211 ,21,43,27 ,32,51,33 },
		{183,211,166 ,26,27,30 ,31,33,36 }, {222,229,219 ,22,35,46 ,27,42,56 },
		{222,0,229 ,22,24,35 ,27,29,42 }, {3,0,2 ,36,24,25 ,43,29,30 },
		{3,229,0 ,36,35,24 ,43,42,29 }, {257,259,1 ,12,47,11 ,13,57,12 },
		{2,259,258 ,25,47,48 ,30,57,58 }, {2,1,259 ,25,11,47 ,30,12,57 },
		{252,2,258 ,49,25,48 ,59,30,58 }, {252,3,2 ,49,36,25 ,59,43,30 },
		{3,252,253 ,36,49,37 ,43,59,44 }, {163,173,172 ,50,51,5 ,60,61,5 },
		{163,158,173 ,50,52,51 ,60,62,61 }, {150,163,172 ,19,50,5 ,22,60,5 },
		{150,151,163 ,19,53,50 ,22,63,60 }, {173,159,169 ,51,54,55 ,61,64,65 },
		{173,158,159 ,51,52,54 ,61,62,64 }, {167,155,166 ,56,57,30 ,66,67,36 },
		{167,156,155 ,56,58,57 ,66,68,67 }, {155,142,166 ,57,44,30 ,67,53,36 },
		{155,144,142 ,57,59,44 ,67,69,53 }, {159,167,169 ,54,56,55 ,64,66,65 },
		{159,156,167 ,54,58,56 ,64,68,66 }, {195,196,234 ,0,0,13 ,70,18,14 },
		{192,191,227 ,21,21,39 ,49,71,46 }, {151,148,163 ,53,60,50 ,63,72,60 },
		{141,144,155 ,61,59,57 ,73,69,67 }, {234,235,232 ,62,62,62 ,74,75,76 },
		{226,227,224 ,62,62,62 ,77,78,79 }, {203,205,196 ,63,64,65 ,80,81,82 },
		{228,219,229 ,21,21,21 ,83,84,85 }, {228,218,219 ,21,21,21 ,83,86,84 },
		{158,163,159 ,62,62,62 ,87,88,89 }, {146,163,148 ,21,21,21 ,90,91,92 },
		{146,160,163 ,21,21,21 ,90,93,91 }, {180,161,162 ,62,62,62 ,94,95,96 },
		{180,178,161 ,62,62,62 ,94,97,95 }, {161,149,162 ,66,66,66 ,98,99,100 },
		{161,145,149 ,66,66,66 ,98,101,99 }, {233,231,235 ,62,62,62 ,102,103,104 },
		{230,232,231 ,62,62,62 ,105,106,107 }, {232,235,231 ,62,62,62 ,106,108,109 },
		{223,230,231 ,0,0,0 ,110,111,112 }, {223,221,230 ,0,0,0 ,110,113,111 },
		{234,194,195 ,62,62,62 ,114,115,116 }, {234,232,194 ,62,62,62 ,114,117,115 },
		{189,187,179 ,67,68,69 ,118,119,120 }, {186,189,188 ,70,67,71 ,121,122,123 },
		{186,187,189 ,70,68,67 ,121,124,122 }, {204,186,188 ,72,70,71 ,125,126,127 },
		{204,202,186 ,72,73,70 ,125,128,126 }, {205,202,204 ,64,73,72 ,129,130,131 },
		{205,203,202 ,64,63,73 ,129,132,130 }, {148,147,146 ,62,62,62 ,133,134,135 },
		{148,151,147 ,62,62,62 ,133,136,134 }, {147,149,145 ,62,62,62 ,134,137,138 },
		{147,150,149 ,62,62,62 ,134,139,137 }, {150,147,151 ,62,62,62 ,140,141,142 },
		{159,160,157 ,62,62,62 ,143,144,145 }, {159,163,160 ,62,62,62 ,143,146,144 },
		{222,4,223 ,62,62,62 ,147,148,149 }, {223,220,221 ,62,62,62 ,150,151,152 },
		{223,4,220 ,62,62,62 ,150,148,151 }, {179,185,5 ,69,74,75 ,153,154,155 },
		{179,187,185 ,69,68,74 ,153,119,154 }, {8,196,195 ,76,65,76 ,156,82,157 },
		{8,7,196 ,76,77,65 ,156,158,82 }, {6,178,180 ,62,62,62 ,159,160,161 },
		{6,177,178 ,62,62,62 ,159,162,160 }, {5,180,179 ,75,66,69 ,155,163,153 },
		{5,6,180 ,75,66,66 ,155,159,163 }, {195,193,8 ,62,62,62 ,157,164,156 },
		{195,194,193 ,62,62,62 ,157,165,164 }, {7,203,196 ,77,63,65 ,158,166,167 },
		{7,201,203 ,77,78,63 ,158,168,166 }, {155,156,159 ,62,62,62 ,169,170,171 },
		{155,140,141 ,0,0,0 ,172,173,174 }, {155,153,140 ,0,0,0 ,172,175,173 },
		{152,175,154 ,62,62,62 ,176,177,178 }, {152,174,175 ,62,62,62 ,176,179,177 },
		{143,152,154 ,66,66,66 ,180,181,182 }, {143,138,152 ,66,66,66 ,180,183,181 },
		{229,225,226 ,62,62,62 ,184,185,186 }, {224,228,229 ,62,62,62 ,187,188,184 },
		{226,224,229 ,62,62,62 ,189,190,191 }, {190,227,191 ,62,62,62 ,192,193,194 },
		{190,224,227 ,62,62,62 ,192,195,193 }, {182,184,176 ,79,80,81 ,196,197,198 },
		{184,181,183 ,80,82,83 ,199,200,201 }, {184,182,181 ,80,79,82 ,199,196,200 },
		{181,199,183 ,82,84,83 ,202,203,204 }, {181,197,199 ,82,85,84 ,202,205,203 },
		{197,200,199 ,85,86,84 ,206,207,208 }, {197,198,200 ,85,87,86 ,206,209,207 },
		{139,141,140 ,62,62,62 ,210,211,212 }, {139,144,141 ,62,62,62 ,210,213,211 },
		{143,139,138 ,62,62,62 ,214,215,216 }, {143,142,139 ,62,62,62 ,214,217,215 },
		{139,142,144 ,62,62,62 ,218,219,220 }, {200,198,192 ,86,87,88 ,221,222,223 },
		{153,159,157 ,62,62,62 ,224,225,226 }, {153,155,159 ,62,62,62 ,224,227,225 },
		{4,222,219 ,62,62,62 ,148,228,229 }, {220,219,218 ,62,62,62 ,230,229,231 },
		{220,4,219 ,62,62,62 ,230,148,229 }, {185,176,5 ,74,81,75 ,232,233,155 },
		{185,182,176 ,74,79,81 ,232,234,233 }, {192,8,191 ,88,76,76 ,235,156,194 },
		{192,7,8 ,88,77,76 ,235,158,156 }, {174,6,175 ,62,62,62 ,236,159,237 },
		{174,177,6 ,62,62,62 ,236,238,159 }, {175,5,176 ,66,75,81 ,239,155,198 },
		{175,6,5 ,66,66,75 ,239,159,155 }, {193,191,8 ,62,62,62 ,240,241,156 },
		{193,190,191 ,62,62,62 ,240,242,241 }, {198,7,192 ,87,77,88 ,243,158,244 },
		{198,201,7 ,87,78,77 ,243,245,158 }, {51,48,60 ,0,0,0 ,246,247,248 },
		{51,46,48 ,0,0,0 ,246,249,247 }, {44,48,46 ,89,90,91 ,250,247,249 },
		{44,45,48 ,89,92,90 ,250,251,247 }, {42,44,40 ,93,94,95 ,252,250,253 },
		{42,45,44 ,93,93,94 ,252,251,250 }, {25,68,20 ,96,97,98 ,254,255,256 },
		{25,55,68 ,96,99,97 ,254,257,255 }, {31,37,36 ,100,101,102 ,258,259,260 },
		{31,30,37 ,100,103,101 ,258,261,259 }, {53,31,36 ,104,100,102 ,262,258,260 },
		{53,24,31 ,104,105,100 ,262,263,258 }, {68,173,20 ,97,51,98 ,255,264,256 },
		{68,172,173 ,97,5,51 ,255,265,264 }, {247,63,244 ,14,106,107 ,266,267,268 },
		{247,244,63 ,14,107,106 ,266,10,267 }, {244,61,261 ,107,108,109 ,269,270,271 },
		{244,63,61 ,107,106,108 ,269,267,270 }, {58,257,62 ,110,111,112 ,272,273,274 },
		{58,259,257 ,110,113,111 ,272,275,273 }, {61,257,261 ,108,111,109 ,270,273,276 },
		{61,62,257 ,108,112,111 ,270,274,273 }, {50,259,58 ,114,113,110 ,277,278,272 },
		{50,49,259 ,114,115,113 ,277,279,278 }, {63,242,243 ,106,116,21 ,267,280,281 },
		{63,56,242 ,106,117,116 ,267,282,280 }, {242,23,212 ,116,118,119 ,280,283,284 },
		{242,56,23 ,116,117,118 ,280,282,283 }, {212,27,213 ,119,120,121 ,284,285,286 },
		{212,23,27 ,119,118,120 ,284,283,285 }, {24,213,27 ,122,121,120 ,263,287,285 },
		{24,53,213 ,122,104,121 ,263,262,287 }, {21,245,215 ,123,17,16 ,288,289,290 },
		{21,57,245 ,123,124,17 ,288,291,289 }, {28,215,216 ,125,16,18 ,292,290,293 },
		{28,21,215 ,125,123,16 ,292,288,290 }, {245,247,246 ,17,14,15 ,294,295,296 },
		{245,57,247 ,17,124,14 ,294,291,295 }, {256,40,44 ,126,95,94 ,297,253,250 },
		{256,41,40 ,126,127,95 ,297,298,253 }, {44,43,256 ,94,128,126 ,250,299,300 },
		{254,61,260 ,129,108,130 ,301,270,302 }, {254,62,61 ,129,112,108 ,301,274,270 },
		{256,62,254 ,126,112,129 ,300,274,303 }, {256,43,62 ,126,128,112 ,300,299,274 },
		{61,63,260 ,108,106,130 ,270,267,304 }, {247,57,39 ,14,124,131 ,305,291,306 },
		{39,244,247 ,131,107,14 ,306,307,308 }, {39,38,244 ,131,132,107 ,306,309,307 },
		{38,35,32 ,132,133,134 ,309,310,311 }, {38,39,35 ,132,131,133 ,309,306,310 },
		{35,28,34 ,133,125,135 ,310,292,312 }, {35,21,28 ,133,123,125 ,310,288,292 },
		{32,34,33 ,134,135,136 ,311,312,313 }, {32,35,34 ,134,133,135 ,311,310,312 },
		{39,21,35 ,131,123,133 ,306,288,310 }, {39,57,21 ,131,124,123 ,306,291,288 },
		{30,33,34 ,103,136,135 ,261,313,312 }, {30,31,33 ,103,100,136 ,261,258,313 },
		{28,30,34 ,125,103,135 ,292,261,312 }, {28,22,30 ,125,137,103 ,292,314,261 },
		{32,56,38 ,134,117,132 ,311,282,309 }, {32,23,56 ,134,118,117 ,311,283,282 },
		{33,23,32 ,136,118,134 ,313,283,311 }, {33,27,23 ,136,120,118 ,313,285,283 },
		{38,63,244 ,132,106,107 ,309,267,315 }, {38,56,63 ,132,117,106 ,309,282,267 },
		{44,47,43 ,89,138,139 ,250,316,299 }, {44,46,47 ,89,91,138 ,250,249,316 },
		{59,49,50 ,140,115,114 ,317,279,277 }, {52,50,58 ,141,142,143 ,318,277,272 },
		{52,51,50 ,141,144,142 ,318,246,277 }, {33,24,27 ,136,122,120 ,313,263,285 },
		{33,31,24 ,136,100,122 ,313,258,263 }, {37,22,29 ,101,145,146 ,259,314,319 },
		{37,30,22 ,101,103,145 ,259,261,314 }, {51,47,46 ,0,0,0 ,246,316,249 },
		{51,52,47 ,0,0,0 ,246,318,316 }, {51,59,50 ,144,147,142 ,246,317,277 },
		{51,60,59 ,144,148,147 ,246,248,317 }, {22,216,29 ,145,18,146 ,314,320,319 },
		{22,28,216 ,145,125,18 ,314,292,320 }, {10,25,20 ,149,96,98 ,321,254,256 },
		{10,69,25 ,149,150,96 ,321,322,254 }, {10,173,169 ,149,51,55 ,321,323,324 },
		{10,20,173 ,149,98,51 ,321,256,323 }, {49,258,259 ,151,48,47 ,279,325,326 },
		{49,9,258 ,151,152,48 ,279,327,325 }, {18,60,48 ,153,148,90 ,328,248,247 },
		{18,19,60 ,153,154,148 ,328,329,248 }, {18,48,45 ,62,62,62 ,328,247,251 },
		{17,45,42 ,155,92,156 ,330,251,252 }, {17,18,45 ,155,153,92 ,330,328,251 },
		{16,42,40 ,157,156,158 ,331,252,253 }, {16,17,42 ,157,155,156 ,331,330,252 },
		{12,54,26 ,159,160,161 ,332,333,334 }, {12,15,54 ,159,162,160 ,332,335,333 },
		{14,171,170 ,62,62,62 ,336,337,338 }, {14,168,171 ,62,62,62 ,336,339,337 },
		{15,170,54 ,162,163,160 ,335,340,333 }, {15,14,170 ,162,163,163 ,335,336,340 },
		{256,13,41 ,62,62,62 ,341,342,298 }, {256,255,13 ,62,62,62 ,341,343,342 },
		{13,40,41 ,164,158,165 ,342,253,298 }, {13,16,40 ,164,157,158 ,342,331,253 },
		{59,9,49 ,166,152,151 ,317,327,279 }, {59,60,9 ,166,148,152 ,317,248,327 },
		{60,19,9 ,148,154,152 ,248,329,327 }, {58,47,52 ,167,167,167 ,272,316,318 },
		{58,43,47 ,167,167,167 ,272,299,316 }, {58,62,43 ,110,112,128 ,272,274,299 },
		{260,63,243 ,76,76,76 ,344,267,345 }, {55,65,64 ,99,168,169 ,257,346,347 },
		{55,26,65 ,99,161,168 ,257,334,346 }, {64,36,37 ,169,102,101 ,347,260,259 },
		{64,65,36 ,169,168,102 ,347,346,260 }, {66,37,29 ,170,101,146 ,348,259,319 },
		{66,64,37 ,170,169,101 ,348,347,259 }, {64,68,55 ,169,97,99 ,347,255,257 },
		{64,66,68 ,169,170,97 ,347,348,255 }, {26,67,65 ,161,171,168 ,334,349,346 },
		{26,54,67 ,161,160,171 ,334,333,349 }, {65,53,36 ,168,104,102 ,346,262,260 },
		{65,67,53 ,168,171,104 ,346,349,262 }, {214,53,67 ,172,104,171 ,350,262,349 },
		{214,213,53 ,172,121,104 ,350,286,262 }, {170,67,54 ,173,171,160 ,351,349,333 },
		{170,214,67 ,173,172,171 ,351,350,349 }, {29,217,66 ,146,2,170 ,319,352,348 },
		{29,216,217 ,146,18,2 ,319,353,352 }, {66,172,68 ,170,5,97 ,348,354,255 },
		{66,217,172 ,170,2,5 ,348,355,354 }, {55,69,11 ,99,150,167 ,257,322,356 },
		{55,25,69 ,99,96,150 ,257,254,322 }, {11,26,55 ,167,161,99 ,356,334,257 },
		{11,12,26 ,167,159,161 ,356,332,334 }, {98,101,110 ,21,21,21 ,357,358,359 },
		{98,96,101 ,21,21,21 ,357,360,358 }, {98,94,96 ,174,175,176 ,357,361,360 },
		{98,95,94 ,174,92,175 ,357,362,361 }, {94,92,90 ,177,178,179 ,361,363,364 },
		{94,95,92 ,177,178,178 ,361,362,363 }, {118,75,70 ,180,181,182 ,365,366,367 },
		{118,105,75 ,180,183,181 ,365,368,366 }, {87,81,86 ,184,185,186 ,369,370,371 },
		{87,80,81 ,184,187,185 ,369,372,370 }, {81,103,86 ,185,188,186 ,370,373,371 },
		{81,74,103 ,185,189,188 ,370,374,373 }, {167,118,70 ,56,180,182 ,375,365,367 },
		{167,166,118 ,56,30,180 ,375,376,365 }, {113,241,238 ,190,38,191 ,377,378,379 },
		{113,238,241 ,190,191,38 ,377,41,378 }, {111,238,249 ,192,191,193 ,380,381,382 },
		{111,113,238 ,192,190,191 ,380,377,381 }, {253,108,112 ,194,195,196 ,383,384,385 },
		{253,252,108 ,194,197,195 ,383,386,384 }, {253,111,249 ,194,192,193 ,387,380,388 },
		{253,112,111 ,194,196,192 ,387,385,380 }, {252,100,108 ,197,198,195 ,389,390,384 },
		{252,99,100 ,197,199,198 ,389,391,390 }, {236,113,237 ,200,190,0 ,392,377,393 },
		{236,106,113 ,200,201,190 ,392,394,377 }, {73,236,206 ,202,200,203 ,395,392,396 },
		{73,106,236 ,202,201,200 ,395,394,392 }, {77,206,207 ,204,203,205 ,397,396,398 },
		{77,73,206 ,204,202,203 ,397,395,396 }, {207,74,77 ,205,206,204 ,399,374,397 },
		{207,103,74 ,205,188,206 ,399,373,374 }, {239,71,209 ,42,207,41 ,400,401,402 },
		{239,107,71 ,42,208,207 ,400,403,401 }, {209,78,210 ,41,209,43 ,402,404,405 },
		{209,71,78 ,41,207,209 ,402,401,404 }, {241,239,240 ,38,42,40 ,406,407,408 },
		{241,107,239 ,38,208,42 ,406,403,407 }, {90,250,94 ,179,210,177 ,364,409,361 },
		{90,91,250 ,179,211,210 ,364,410,409 }, {93,94,250 ,212,177,210 ,411,361,412 },
		{111,251,248 ,192,213,214 ,380,413,414 }, {111,112,251 ,192,196,213 ,380,385,413 },
		{112,250,251 ,196,210,213 ,385,412,415 }, {112,93,250 ,196,212,210 ,385,411,412 },
		{113,111,248 ,190,192,214 ,377,380,416 }, {107,241,89 ,208,38,215 ,403,417,418 },
		{238,89,241 ,191,215,38 ,419,418,420 }, {238,88,89 ,191,216,215 ,419,421,418 },
		{85,88,82 ,217,216,218 ,422,421,423 }, {85,89,88 ,217,215,216 ,422,418,421 },
		{78,85,84 ,209,217,219 ,404,422,424 }, {78,71,85 ,209,207,217 ,404,401,422 },
		{84,82,83 ,219,218,220 ,424,423,425 }, {84,85,82 ,219,217,218 ,424,422,423 },
		{71,89,85 ,207,215,217 ,401,418,422 }, {71,107,89 ,207,208,215 ,401,403,418 },
		{83,80,84 ,220,187,219 ,425,372,424 }, {83,81,80 ,220,185,187 ,425,370,372 },
		{80,78,84 ,187,209,219 ,372,404,424 }, {80,72,78 ,187,221,209 ,372,426,404 },
		{106,82,88 ,201,218,216 ,394,423,421 }, {106,73,82 ,201,202,218 ,394,395,423 },
		{73,83,82 ,202,220,218 ,395,425,423 }, {73,77,83 ,202,204,220 ,395,397,425 },
		{113,88,238 ,190,216,191 ,377,421,427 }, {113,106,88 ,190,201,216 ,377,394,421 },
		{97,94,93 ,222,175,139 ,428,361,411 }, {97,96,94 ,222,176,175 ,428,360,361 },
		{99,109,100 ,199,223,198 ,391,429,390 }, {100,102,108 ,224,225,226 ,390,430,384 },
		{100,101,102 ,224,227,225 ,390,358,430 }, {74,83,77 ,206,220,204 ,374,425,397 },
		{74,81,83 ,206,185,220 ,374,370,425 }, {72,87,79 ,228,184,229 ,426,369,431 },
		{72,80,87 ,228,187,184 ,426,372,369 }, {97,101,96 ,21,21,21 ,428,358,360 },
		{97,102,101 ,21,21,21 ,428,430,358 }, {109,101,100 ,230,227,224 ,429,358,390 },
		{109,110,101 ,230,231,227 ,429,359,358 }, {210,72,79 ,43,228,229 ,432,426,431 },
		{210,78,72 ,43,209,228 ,432,404,426 }, {75,10,70 ,181,149,182 ,366,321,367 },
		{75,69,10 ,181,150,149 ,366,322,321 }, {167,10,169 ,56,149,55 ,433,321,434 },
		{167,70,10 ,56,182,149 ,433,367,321 }, {258,99,252 ,48,232,49 ,435,391,436 },
		{258,9,99 ,48,152,232 ,435,327,391 }, {110,18,98 ,231,153,174 ,359,328,357 },
		{110,19,18 ,231,154,153 ,359,329,328 }, {98,18,95 ,62,62,62 ,357,328,362 },
		{95,17,92 ,92,155,233 ,362,330,363 }, {95,18,17 ,92,153,155 ,362,328,330 },
		{92,16,90 ,233,157,234 ,363,331,364 }, {92,17,16 ,233,155,157 ,363,330,331 },
		{104,12,76 ,235,159,236 ,437,332,438 }, {104,15,12 ,235,162,159 ,437,335,332 },
		{165,14,164 ,62,62,62 ,439,336,440 }, {165,168,14 ,62,62,62 ,439,441,336 },
		{164,15,104 ,163,162,235 ,442,335,437 }, {164,14,15 ,163,163,162 ,442,336,335 },
		{13,250,91 ,62,62,62 ,342,443,410 }, {13,255,250 ,62,62,62 ,342,444,443 },
		{90,13,91 ,234,164,165 ,364,342,410 }, {90,16,13 ,234,157,164 ,364,331,342 },
		{9,109,99 ,152,237,232 ,327,429,391 }, {9,110,109 ,152,231,237 ,327,359,429 },
		{19,110,9 ,154,231,152 ,329,359,327 }, {97,108,102 ,167,167,167 ,428,384,430 },
		{97,93,108 ,167,167,167 ,428,411,384 }, {112,108,93 ,196,195,212 ,385,384,411 },
		{113,248,237 ,76,76,76 ,377,445,446 }, {115,105,114 ,238,183,239 ,447,368,448 },
		{115,76,105 ,238,236,183 ,447,438,368 }, {86,114,87 ,186,239,184 ,371,448,369 },
		{86,115,114 ,186,238,239 ,371,447,448 }, {87,116,79 ,184,240,229 ,369,449,431 },
		{87,114,116 ,184,239,240 ,369,448,449 }, {118,114,105 ,180,239,183 ,365,448,368 },
		{118,116,114 ,180,240,239 ,365,449,448 }, {117,76,115 ,241,236,238 ,450,438,447 },
		{117,104,76 ,241,235,236 ,450,437,438 }, {103,115,86 ,188,238,186 ,373,447,371 },
		{103,117,115 ,188,241,238 ,373,450,447 }, {103,208,117 ,188,242,241 ,373,451,450 },
		{103,207,208 ,188,205,242 ,373,398,451 }, {117,164,104 ,241,243,235 ,450,452,437 },
		{117,208,164 ,241,242,243 ,450,453,452 }, {211,79,116 ,27,229,240 ,454,431,449 },
		{211,210,79 ,27,43,229 ,454,405,431 }, {166,116,118 ,30,240,180 ,455,449,365 },
		{166,211,116 ,30,27,240 ,455,456,449 }, {69,105,11 ,150,183,167 ,322,368,356 },
		{69,75,105 ,150,181,183 ,322,366,368 }, {76,11,105 ,236,167,183 ,438,356,368 },
		{76,12,11 ,236,159,167 ,438,332,356 }, {171,146,147 ,244,245,66 ,457,458,459 },
		{171,160,146 ,244,246,245 ,457,460,458 }, {147,170,171 ,21,173,21 ,461,462,463 },
		{147,161,170 ,21,21,173 ,461,464,462 }, {260,232,230 ,76,76,76 ,465,466,467 },
		{260,243,232 ,76,76,76 ,465,468,466 }, {256,254,230 ,76,76,76 ,469,470,471 },
		{232,242,194 ,21,116,21 ,472,473,474 }, {232,243,242 ,21,21,116 ,472,475,473 },
		{168,160,171 ,247,246,244 ,476,477,478 }, {168,157,160 ,247,247,246 ,476,479,477 },
		{256,119,255 ,76,76,76 ,480,481,482 }, {256,230,119 ,76,76,76 ,480,483,481 },
		{220,230,221 ,76,76,76 ,484,485,486 }, {220,119,230 ,76,76,76 ,484,487,485 },
		{254,260,230 ,76,76,76 ,488,489,490 }, {120,131,127 ,248,249,248 ,491,492,493 },
		{120,125,131 ,248,250,249 ,491,494,492 }, {130,123,129 ,251,252,252 ,495,496,497 },
		{130,124,123 ,251,253,252 ,495,498,496 }, {123,128,129 ,254,255,256 ,496,499,497 },
		{123,122,128 ,254,257,255 ,496,500,499 }, {201,130,203 ,78,251,63 ,501,495,502 },
		{201,124,130 ,78,253,251 ,501,498,495 }, {125,187,131 ,250,68,249 ,494,503,492 },
		{125,185,187 ,250,74,68 ,494,504,503 }, {121,127,126 ,258,259,260 ,505,493,506 },
		{121,120,127 ,258,261,259 ,505,491,493 }, {122,194,128 ,257,262,255 ,500,507,499 },
		{122,193,194 ,257,263,262 ,500,508,507 }, {121,178,177 ,258,264,265 ,505,509,510 },
		{121,126,178 ,258,260,264 ,505,506,509 }, {130,213,214 ,21,121,172 ,495,511,512 },
		{130,129,213 ,21,21,121 ,495,497,511 }, {203,130,202 ,21,21,21 ,513,495,514 },
		{202,130,214 ,21,21,172 ,515,516,517 }, {131,187,186 ,21,21,21 ,492,518,519 },
		{186,202,214 ,21,21,172 ,520,521,522 }, {131,186,214 ,21,21,172 ,492,523,524 },
		{170,131,214 ,173,21,172 ,525,492,526 }, {170,127,131 ,173,21,21 ,525,493,492 },
		{213,128,212 ,121,21,119 ,527,499,528 }, {213,129,128 ,121,21,21 ,527,497,499 },
		{212,194,242 ,119,21,116 ,529,530,531 }, {212,128,194 ,119,21,21 ,529,499,530 },
		{170,126,127 ,173,21,21 ,462,506,493 }, {178,170,161 ,21,173,21 ,532,533,534 },
		{178,126,170 ,21,21,173 ,532,506,533 }, {140,165,139 ,266,267,66 ,535,536,537 },
		{140,153,165 ,266,268,267 ,535,538,536 }, {164,139,165 ,243,0,0 ,539,540,541 },
		{164,152,139 ,243,0,0 ,539,542,540 }, {224,248,228 ,76,76,76 ,543,544,545 },
		{224,237,248 ,76,76,76 ,543,546,544 }, {251,250,228 ,76,76,76 ,547,548,549 },
		{236,224,190 ,200,0,0 ,550,551,552 }, {236,237,224 ,200,0,0 ,550,553,551 },
		{153,168,165 ,268,247,267 ,554,555,556 }, {153,157,168 ,268,247,247 ,554,557,555 },
		{119,250,255 ,76,76,76 ,481,558,559 }, {119,228,250 ,76,76,76 ,481,560,558 },
		{228,220,218 ,76,76,76 ,561,562,563 }, {228,119,220 ,76,76,76 ,561,564,562 },
		{248,251,228 ,76,76,76 ,565,566,567 }, {137,120,133 ,249,248,248 ,568,491,569 },
		{137,125,120 ,249,250,248 ,568,494,491 }, {123,136,135 ,252,251,252 ,496,570,571 },
		{123,124,136 ,252,253,251 ,496,498,570 }, {134,123,135 ,269,254,256 ,572,496,571 },
		{134,122,123 ,269,257,254 ,572,500,496 }, {136,201,198 ,251,78,87 ,570,573,574 },
		{136,124,201 ,251,253,78 ,570,498,573 }, {182,125,137 ,79,250,249 ,575,494,568 },
		{182,185,125 ,79,74,250 ,575,576,494 }, {133,121,132 ,270,258,271 ,569,505,577 },
		{133,120,121 ,270,261,258 ,569,491,505 }, {190,122,134 ,272,257,269 ,578,500,572 },
		{190,193,122 ,272,263,257 ,578,579,500 }, {174,121,177 ,273,258,265 ,580,505,581 },
		{174,132,121 ,273,271,258 ,580,577,505 }, {207,136,208 ,205,0,242 ,582,570,583 },
		{207,135,136 ,205,0,0 ,582,571,570 }, {136,198,197 ,0,0,0 ,570,584,585 },
		{136,197,208 ,0,0,242 ,570,586,587 }, {182,137,181 ,0,0,0 ,588,568,589 },
		{197,181,208 ,0,0,242 ,590,591,592 }, {181,137,208 ,0,0,242 ,593,568,592 },
		{137,164,208 ,0,243,242 ,568,594,595 }, {137,133,164 ,0,0,243 ,568,569,594 },
		{134,207,206 ,0,205,203 ,572,596,597 }, {134,135,207 ,0,0,205 ,572,571,596 },
		{190,206,236 ,0,203,200 ,598,599,600 }, {190,134,206 ,0,0,203 ,598,572,599 },
		{132,164,133 ,0,243,0 ,577,601,569 }, {164,174,152 ,243,0,0 ,602,603,604 },
		{164,132,174 ,243,0,0 ,602,577,603 }, {147,145,161 ,21,21,21 ,605,606,607 },
		{138,139,152 ,0,0,0 ,608,540,609 }
	};
	static GLfloat vertices [262][3] = {
	{0.0f,-3.49998f,0.35235f},{-0.789509f,-3.40949f,-1.38255f},{0.0f,-3.5f,-1.33903f},
	{0.790101f,-3.40936f,-1.38255f},{0.0f,-3.42929f,1.60235f},{0.0f,0.775f,0.00235001f},
	{0.0f,0.775f,0.35235f},{0.0f,-0.775f,0.00235001f},{0.0f,-0.775f,0.35235f},
	{0.0f,-3.4799f,-1.92265f},{0.0f,3.44142f,-1.93907f},{0.0f,2.58603f,-1.99765f},
	{0.0f,2.05f,-1.99765f},{0.0f,-2.55f,-1.84765f},{0.0f,1.9f,-1.84765f},
	{0.0f,1.93867f,-1.94817f},{0.0f,-2.59428f,-1.95406f},{0.0f,-2.7f,-1.99765f},
	{0.0f,-2.75f,-1.99765f},{0.0f,-3.4f,-1.98255f},{-1.1183f,3.25465f,-1.93907f},
	{-2.15607f,-1.6893f,-1.40561f},{-2.12344f,-1.51075f,-1.93083f},{-1.84393f,-1.6893f,-1.40561f},
	{-1.87653f,-1.47911f,-1.95856f},{-1.0865f,3.11599f,-1.99765f},{-1.95f,2.05f,-1.99765f},
	{-1.84393f,-1.51498f,-1.86148f},{-2.15607f,-1.51498f,-1.86148f},{-2.15607f,-1.40982f,-1.95372f},
	{-2.05f,-1.50873f,-1.96042f},{-1.95f,-1.50873f,-1.96042f},{-1.95f,-1.731f,-1.42385f},
	{-1.95f,-1.55854f,-1.86722f},{-2.05f,-1.55854f,-1.86722f},{-2.05f,-1.73096f,-1.42391f},
	{-1.95f,-1.40982f,-1.99765f},{-2.05f,-1.40982f,-1.99765f},{-1.95f,-2.08797f,-1.11079f},
	{-2.05f,-2.08779f,-1.11088f},{-0.800937f,-2.5946f,-1.95438f},{-0.811314f,-2.55f,-1.84765f},
	{-0.8f,-2.7f,-1.99765f},{-0.811314f,-2.9f,-1.84765f},{-0.800937f,-2.8554f,-1.95438f},
	{-0.8f,-2.75f,-1.99765f},{-0.2f,-2.85603f,-1.95375f},{-0.2f,-2.9f,-1.84765f},
	{-0.2f,-2.75f,-1.99765f},{-0.802028f,-3.37875f,-1.934f},{-0.802002f,-3.22955f,-1.9344f},
	{-0.2f,-3.32142f,-1.93412f},{-0.2f,-3.29393f,-1.84765f},{-1.83058f,-1.40982f,-1.93842f},
	{-1.83867f,1.93867f,-1.94817f},{-2.05f,2.58603f,-1.99765f},{-1.84393f,-2.04195f,-1.04672f},
	{-2.15607f,-2.04195f,-1.04672f},{-0.811314f,-3.19871f,-1.84765f},{-0.800037f,-3.30454f,-1.98904f},
	{-0.2f,-3.39411f,-1.98907f},{-1.28094f,-3.04125f,-1.14291f},{-0.998289f,-3.14538f,-1.39994f},
	{-1.8f,-2.7f,-0.99765f},{-2.05f,0.0f,-1.99765f},{-1.95f,0.0f,-1.99765f},
	{-2.15607f,0.0f,-1.95372f},{-1.83398f,0.0f,-1.94253f},{-2.15607f,2.66025f,-1.93818f},
	{0.0f,3.29998f,-1.99765f},{1.1183f,3.25465f,-1.93907f},{2.15607f,-1.6893f,-1.40561f},
	{2.12344f,-1.51075f,-1.93083f},{1.84393f,-1.6893f,-1.40561f},{1.87653f,-1.47911f,-1.95856f},
	{1.0865f,3.11599f,-1.99765f},{1.95f,2.05f,-1.99765f},{1.84393f,-1.51498f,-1.86148f},
	{2.15607f,-1.51498f,-1.86148f},{2.15607f,-1.40982f,-1.95372f},{2.05f,-1.50873f,-1.96042f},
	{1.95f,-1.50873f,-1.96042f},{1.95f,-1.731f,-1.42385f},{1.95f,-1.55854f,-1.86722f},
	{2.05f,-1.55854f,-1.86722f},{2.05f,-1.73096f,-1.42391f},{1.95f,-1.40982f,-1.99765f},
	{2.05f,-1.40982f,-1.99765f},{1.95f,-2.08797f,-1.11079f},{2.05f,-2.08779f,-1.11088f},
	{0.800937f,-2.5946f,-1.95438f},{0.811314f,-2.55f,-1.84765f},{0.8f,-2.7f,-1.99765f},
	{0.811314f,-2.9f,-1.84765f},{0.800937f,-2.8554f,-1.95438f},{0.8f,-2.75f,-1.99765f},
	{0.2f,-2.85603f,-1.95375f},{0.2f,-2.9f,-1.84765f},{0.2f,-2.75f,-1.99765f},
	{0.802028f,-3.37875f,-1.934f},{0.802002f,-3.22955f,-1.9344f},{0.2f,-3.32142f,-1.93412f},
	{0.2f,-3.29393f,-1.84765f},{1.83058f,-1.40982f,-1.93842f},{1.83867f,1.93867f,-1.94817f},
	{2.05f,2.58603f,-1.99765f},{1.84393f,-2.04195f,-1.04672f},{2.15607f,-2.04195f,-1.04672f},
	{0.811314f,-3.19871f,-1.84765f},{0.800037f,-3.30454f,-1.98904f},{0.2f,-3.39411f,-1.98907f},
	{1.28094f,-3.04125f,-1.14291f},{0.998289f,-3.14538f,-1.39994f},{1.8f,-2.7f,-0.99765f},
	{2.05f,0.0f,-1.99765f},{1.95f,0.0f,-1.99765f},{2.15607f,0.0f,-1.95372f},
	{1.83398f,0.0f,-1.94253f},{2.15607f,2.66025f,-1.93818f},{0.0f,-2.7f,0.35235f},
	{0.0f,1.0f,-0.74765f},{0.0f,1.18582f,-0.392925f},{0.0f,-1.18582f,-0.392925f},
	{0.0f,-1.0f,-0.74765f},{0.0f,-0.672987f,-0.697837f},{0.0f,0.672987f,-0.697837f},
	{-1.8f,1.1858f,-0.392915f},{-1.8f,1.0f,-0.74765f},{-1.8f,-1.1858f,-0.392915f},
	{-1.8f,-1.0f,-0.74765f},{-1.8f,-0.672987f,-0.697837f},{-1.8f,0.672987f,-0.697837f},
	{1.8f,1.1858f,-0.392915f},{1.8f,1.0f,-0.74765f},{1.8f,-1.1858f,-0.392915f},
	{1.8f,-1.0f,-0.74765f},{1.8f,-0.672987f,-0.697837f},{1.8f,0.672987f,-0.697837f},
	{1.8f,2.15f,1.60235f},{1.8f,2.67f,1.60235f},{1.4f,2.67f,1.60235f},
	{1.4f,3.2078f,1.60235f},{2.18467f,2.71558f,1.60235f},{2.2f,2.15f,1.60235f},
	{1.78458f,3.01085f,1.60235f},{-1.8f,2.15f,1.60235f},{-1.4f,2.67f,1.60235f},
	{-1.8f,2.67f,1.60235f},{-1.4f,3.2078f,1.60235f},{-2.2f,2.15f,1.60235f},
	{-2.18467f,2.71558f,1.60235f},{-1.78458f,3.01085f,1.60235f},{1.8f,2.15f,0.35235f},
	{1.4f,2.7f,0.35235f},{2.2f,2.15f,0.35235f},{1.4f,3.2078f,0.35235f},
	{0.948198f,3.36911f,0.35235f},{0.0f,2.7f,0.35235f},{-0.948198f,3.36911f,0.35235f},
	{0.0f,3.48711f,0.35235f},{-1.4f,2.7f,0.35235f},{-1.8f,2.15f,0.35235f},
	{-2.2f,2.15f,0.35235f},{-1.4f,3.2078f,0.35235f},{1.8f,1.9f,-1.84765f},
	{1.8f,2.67f,-1.84765f},{2.18466f,2.7156f,-1.79765f},{1.13241f,3.31174f,-1.79765f},
	{0.0f,2.67f,-1.84765f},{0.0f,3.5f,-1.79765f},{-1.8f,1.9f,-1.84765f},
	{-1.8f,2.67f,-1.84765f},{-2.18466f,2.7156f,-1.79765f},{-1.13241f,3.31174f,-1.79765f},
	{1.8f,1.25f,0.35235f},{2.2f,0.775f,0.35235f},{2.2f,0.775f,0.00235001f},
	{0.0f,1.25f,0.35235f},{-1.8f,1.25f,0.35235f},{-2.2f,0.775f,0.00235001f},
	{-2.2f,0.775f,0.35235f},{1.8f,0.2465f,-0.732382f},{1.8f,0.606556f,-0.572051f},
	{2.2f,0.239526f,-0.734681f},{2.2f,0.627035f,-0.453101f},{0.0f,0.606556f,-0.572051f},
	{-1.8f,0.2465f,-0.732382f},{-1.8f,0.606556f,-0.572051f},{-2.2f,0.239526f,-0.734681f},
	{-2.2f,0.627035f,-0.453101f},{1.8f,-1.25f,0.35235f},{2.2f,-0.775f,0.35235f},
	{2.2f,-0.775f,0.00235001f},{0.0f,-1.25f,0.35235f},{-1.8f,-1.25f,0.35235f},
	{-2.2f,-0.775f,0.35235f},{-2.2f,-0.775f,0.00235001f},{1.8f,-0.246935f,-0.732237f},
	{1.8f,-0.606556f,-0.572051f},{2.2f,-0.239526f,-0.734681f},{2.2f,-0.627035f,-0.453101f},
	{0.0f,-0.606556f,-0.572051f},{-1.8f,-0.246935f,-0.732237f},{-1.8f,-0.606556f,-0.572051f},
	{-2.2f,-0.239526f,-0.734681f},{-2.2f,-0.627035f,-0.453101f},{1.8f,-1.60818f,-1.33776f},
	{1.8f,-1.40982f,-1.84765f},{1.8f,0.0f,-1.84765f},{2.2f,-1.6081f,-1.33787f},
	{2.2f,-1.40982f,-1.84765f},{2.2f,0.0f,-1.84765f},{-1.8f,-1.60818f,-1.33776f},
	{-1.8f,-1.40982f,-1.84765f},{-1.8f,0.0f,-1.84765f},{-2.2f,-1.6081f,-1.33787f},
	{-2.2f,-1.40982f,-1.84765f},{-2.2f,0.0f,-1.84765f},{0.7f,-2.7f,1.60235f},
	{0.7f,-3.42929f,1.60235f},{0.0f,-2.7f,1.60235f},{-0.7f,-2.7f,1.60235f},
	{0.0f,-3.49997f,1.60235f},{-0.7f,-3.42929f,1.60235f},{1.8f,-2.7f,0.35235f},
	{1.45894f,-3.18143f,0.35235f},{2.14179f,-2.76816f,0.35235f},{2.2f,-2.64953f,0.35235f},
	{0.7f,-2.7f,0.35235f},{0.7f,-3.42929f,0.35235f},{-0.7f,-2.7f,0.35235f},
	{-0.7f,-3.42929f,0.35235f},{-1.8f,-2.7f,0.35235f},{-1.45894f,-3.18143f,0.35235f},
	{-2.2f,-2.64953f,0.35235f},{-2.14179f,-2.76816f,0.35235f},{1.8f,-2.01865f,-0.97777f},
	{1.8f,-2.7f,-0.84765f},{1.92676f,-2.92192f,-0.99765f},{2.2f,-2.01835f,-0.977926f},
	{2.2f,-2.64953f,-0.84765f},{2.14179f,-2.76816f,-0.966286f},{-1.8f,-2.01865f,-0.97777f},
	{-1.8f,-2.7f,-0.84765f},{-1.92676f,-2.92192f,-0.99765f},{-2.2f,-2.01835f,-0.977926f},
	{-2.2f,-2.64953f,-0.84765f},{-2.14179f,-2.76816f,-0.966286f},{1.34394f,-2.7f,-1.1077f},
	{1.35582f,-3.22672f,-1.10171f},{0.811314f,-2.7f,-1.84765f},{0.988348f,-2.7f,-1.41351f},
	{0.811314f,-3.40467f,-1.84765f},{0.994882f,-3.35562f,-1.40454f},{-0.988348f,-2.7f,-1.41351f},
	{0.0f,-2.7f,-1.84765f},{-0.811314f,-2.7f,-1.84765f},{-0.994882f,-3.35562f,-1.40454f},
	{0.0f,-3.5f,-1.84765f},{-0.811314f,-3.40467f,-1.84765f},{-1.34394f,-2.7f,-1.1077f},
	{-1.35582f,-3.22672f,-1.10171f}
	};
	static GLfloat normals [274][3] = {
	{-1.0f,0.0f,0.0f},{-0.999984f,0.00519551f,-0.00232515f},{-0.980741f,0.00304722f,-0.195287f},
	{-0.999982f,0.00321145f,-0.0050577f},{-0.999901f,0.0139735f,-0.00167206f},{-0.936619f,0.325635f,-0.129252f},
	{-0.635574f,-0.772028f,0.00417741f},{-0.374979f,-0.926692f,0.0251491f},{-0.416825f,-0.908986f,-0.00124481f},
	{-0.525586f,-0.850639f,0.0131636f},{-0.172574f,-0.984996f,0.00117284f},{-0.210513f,-0.977414f,0.0185848f},
	{-0.258321f,-0.96481f,0.0491156f},{-0.988643f,-0.150284f,0.0f},{-0.823776f,-0.351623f,-0.444696f},
	{-0.975233f,-0.179062f,-0.129837f},{-0.980566f,-0.16978f,-0.0983098f},{-0.952236f,-0.138993f,-0.271897f},
	{-0.976766f,-0.13269f,-0.168292f},{-0.877679f,0.478993f,-0.0156877f},{-0.999633f,0.0270911f,0.0f},
	{1.0f,0.0f,0.0f},{-1.87212e-009f,-1.0f,3.52859e-006f},{-0.100472f,-0.99494f,0.0f},
	{0.0229096f,-0.999737f,-0.0012419f},{-0.014379f,-0.999894f,-0.00219243f},{0.999984f,0.00519551f,-0.00232515f},
	{0.980741f,0.00304722f,-0.195287f},{0.999901f,0.0139735f,-0.00167206f},{0.999982f,0.00321145f,-0.0050577f},
	{0.936619f,0.325635f,-0.129252f},{0.375017f,-0.926677f,0.0251251f},{0.635574f,-0.772028f,0.00417741f},
	{0.416825f,-0.908986f,-0.00124481f},{0.525586f,-0.850639f,0.0131636f},{0.184376f,-0.982855f,0.00126651f},
	{0.19241f,-0.981194f,0.0153646f},{0.258434f,-0.964785f,0.0490148f},{0.823776f,-0.351623f,-0.444696f},
	{0.988643f,-0.150284f,0.0f},{0.975233f,-0.179062f,-0.129837f},{0.980566f,-0.16978f,-0.0983098f},
	{0.952236f,-0.138993f,-0.271897f},{0.976766f,-0.13269f,-0.168292f},{0.877679f,0.478993f,-0.0156877f},
	{0.999633f,0.0270911f,0.0f},{0.100472f,-0.99494f,0.0f},{-0.150459f,-0.985712f,-0.0757187f},
	{-1.26142e-009f,-0.982267f,-0.187487f},{0.150508f,-0.985707f,-0.0756957f},{-0.48425f,0.874812f,-0.0143577f},
	{-0.3013f,0.931914f,-0.201876f},{-0.231256f,0.972873f,-0.00614353f},{-0.526289f,0.849844f,-0.0280189f},
	{1.88271e-009f,0.999987f,-0.00504398f},{0.0f,0.981327f,-0.192344f},{0.3013f,0.931914f,-0.201876f},
	{0.48425f,0.874812f,-0.0143577f},{0.231256f,0.972873f,-0.00614353f},{0.526289f,0.849844f,-0.0280189f},
	{-0.455821f,0.890072f,0.0f},{0.455821f,0.890072f,0.0f},{0.0f,0.0f,1.0f},
	{0.0657879f,0.952791f,0.296413f},{0.10445f,0.69044f,0.715809f},{0.0109124f,0.988743f,0.149229f},
	{0.0f,-1.0f,0.0f},{0.104335f,-0.690422f,0.715843f},{0.0695468f,-0.988856f,0.131634f},
	{0.0108787f,-0.975504f,0.219712f},{0.0618815f,-0.25638f,0.964593f},{-7.68889e-005f,-0.309048f,0.951047f},
	{-0.00205735f,0.204931f,0.978774f},{0.0844502f,0.341379f,0.936124f},{0.0f,-0.999417f,0.0341539f},
	{0.0f,-0.99551f,0.0946543f},{0.0f,1.0f,0.0f},{0.0f,0.981918f,0.189309f},
	{0.0f,0.972561f,-0.232648f},{-0.0695468f,-0.988856f,0.131634f},{-0.104335f,-0.690422f,0.715843f},
	{-0.0108787f,-0.975504f,0.219712f},{-0.0618815f,-0.25638f,0.964593f},{7.68889e-005f,-0.309048f,0.951047f},
	{0.00205735f,0.204931f,0.978774f},{-0.0844502f,0.341379f,0.936124f},{-0.10445f,0.69044f,0.715809f},
	{-0.0657879f,0.952791f,0.296413f},{-0.0109124f,0.988743f,0.149229f},{-2.695e-006f,-0.70594f,-0.708272f},
	{0.000192697f,-0.262692f,-0.96488f},{-5.38999e-006f,-0.707003f,-0.707211f},{0.0f,-0.128752f,-0.991677f},
	{-0.999766f,0.0f,-0.0216409f},{-0.998243f,0.0f,-0.0592487f},{-0.997421f,0.0f,-0.0717738f},
	{-0.110602f,0.30484f,-0.94596f},{-0.5256f,0.388284f,-0.756954f},{-0.238354f,0.664347f,-0.7084f},
	{-0.104052f,0.0586272f,-0.992842f},{0.125063f,-0.459593f,-0.87928f},{-0.217416f,-0.199415f,-0.955492f},
	{0.180023f,-0.139748f,-0.973685f},{-0.1298f,-0.788311f,-0.60143f},{0.652009f,-0.0742063f,-0.754571f},
	{-0.116753f,0.347918f,-0.930227f},{0.447525f,0.0067279f,-0.894246f},{-0.0972002f,-0.0882603f,-0.991344f},
	{-0.485837f,0.0128693f,-0.873955f},{-0.443782f,-0.019869f,-0.895914f},{-0.948313f,-0.00164689f,-0.317333f},
	{-0.808553f,0.0200673f,-0.588081f},{-0.858391f,8.64955e-005f,-0.512997f},{-0.979669f,-3.89778e-005f,-0.20062f},
	{-0.996525f,-1.42301e-005f,-0.0832893f},{-0.997437f,-2.13467e-005f,-0.0715458f},{0.978716f,-0.0949488f,-0.181931f},
	{0.67714f,-0.343528f,-0.650745f},{0.686377f,-0.616067f,-0.386455f},{0.980566f,-0.169777f,-0.0983178f},
	{0.74217f,-0.592683f,-0.312907f},{0.977835f,-0.147992f,-0.148113f},{0.639882f,-0.647718f,-0.413536f},
	{-0.715589f,-0.549052f,-0.431825f},{-0.73778f,-0.301487f,-0.603976f},{-0.610268f,-0.733583f,-0.299047f},
	{-0.97708f,0.00185179f,-0.212865f},{-0.995307f,0.0f,-0.0967725f},{-0.956401f,0.0f,-0.292057f},
	{-0.768622f,-0.0137886f,-0.639555f},{-0.456092f,0.00761986f,-0.8899f},{-0.315155f,-0.404027f,-0.858743f},
	{0.242533f,-0.386677f,-0.889752f},{-0.197382f,-0.801534f,-0.564432f},{0.24008f,-0.806336f,-0.54054f},
	{-0.149757f,-0.90336f,-0.401889f},{0.214947f,-0.884715f,-0.413614f},{0.00361947f,-0.998239f,-0.0592032f},
	{-0.000289462f,-0.923248f,-0.384205f},{0.0f,-0.922669f,-0.385593f},{-0.99935f,7.32087e-005f,-0.0360433f},
	{0.145011f,0.940077f,-0.308588f},{0.132303f,0.859023f,-0.494545f},{0.145949f,0.936997f,-0.317387f},
	{0.112723f,0.742104f,-0.660738f},{-0.647982f,-0.349544f,-0.676712f},{-0.75514f,-0.147652f,-0.638719f},
	{0.0898762f,0.594363f,-0.799159f},{0.00381381f,-0.184719f,-0.982784f},{0.0f,0.703645f,-0.710552f},
	{0.0f,0.129579f,-0.991569f},{-0.102191f,-0.87449f,-0.474155f},{3.63993e-010f,-0.758864f,-0.651249f},
	{0.0f,-0.0121772f,-0.999926f},{-2.44554e-010f,-0.327201f,-0.944955f},{0.0f,0.129244f,-0.991613f},
	{7.33698e-005f,0.257996f,-0.966146f},{0.0f,0.602021f,-0.79848f},{-7.75359e-008f,0.795583f,-0.605844f},
	{0.0f,-0.276074f,-0.961136f},{0.326394f,-0.425868f,-0.843862f},{0.143616f,-0.0702339f,-0.987138f},
	{0.0f,-0.812299f,-0.583242f},{0.0f,-0.933328f,-0.359024f},{0.0f,0.922958f,-0.384901f},
	{0.0f,0.922669f,-0.385593f},{-0.0891187f,-0.681542f,-0.726332f},{0.0f,0.0f,-1.0f},
	{0.222711f,-0.000272707f,-0.974885f},{-0.214215f,0.000921458f,-0.976786f},{-0.728642f,0.00345042f,-0.684886f},
	{0.735846f,-0.00014084f,-0.677148f},{0.992044f,0.00016362f,-0.125893f},{0.99694f,0.000135919f,-0.0781646f},
	{-0.000192697f,-0.262692f,-0.96488f},{2.695e-006f,-0.70594f,-0.708272f},{5.38999e-006f,-0.707003f,-0.707211f},
	{0.998243f,0.0f,-0.0592487f},{0.999766f,0.0f,-0.0216409f},{0.997421f,0.0f,-0.0717738f},
	{0.5256f,0.388284f,-0.756954f},{0.110602f,0.30484f,-0.94596f},{0.238354f,0.664347f,-0.7084f},
	{0.104052f,0.0586272f,-0.992842f},{0.217416f,-0.199415f,-0.955492f},{-0.125063f,-0.459593f,-0.87928f},
	{-0.180023f,-0.139748f,-0.973685f},{0.1298f,-0.788311f,-0.60143f},{-0.652009f,-0.0742063f,-0.754571f},
	{0.116753f,0.347918f,-0.930227f},{-0.447525f,0.0067279f,-0.894246f},{0.0972002f,-0.0882603f,-0.991344f},
	{0.485837f,0.0128693f,-0.873955f},{0.443782f,-0.019869f,-0.895914f},{0.808553f,0.0200673f,-0.588081f},
	{0.948313f,-0.00164689f,-0.317333f},{0.858391f,8.64955e-005f,-0.512997f},{0.979669f,-3.89778e-005f,-0.20062f},
	{0.996525f,-1.42301e-005f,-0.0832893f},{0.997437f,-2.13467e-005f,-0.0715458f},{-0.978716f,-0.0949488f,-0.181931f},
	{-0.67714f,-0.343528f,-0.650745f},{-0.686377f,-0.616067f,-0.386455f},{-0.980566f,-0.169777f,-0.0983178f},
	{-0.74217f,-0.592683f,-0.312907f},{-0.977835f,-0.147992f,-0.148113f},{-0.639882f,-0.647718f,-0.413536f},
	{0.715589f,-0.549052f,-0.431825f},{0.73778f,-0.301487f,-0.603976f},{0.610268f,-0.733583f,-0.299047f},
	{0.97708f,0.00185179f,-0.212865f},{0.995307f,0.0f,-0.0967725f},{0.956401f,0.0f,-0.292057f},
	{0.768622f,-0.0137886f,-0.639555f},{0.456092f,0.00761986f,-0.8899f},{0.315155f,-0.404027f,-0.858743f},
	{-0.242533f,-0.386677f,-0.889752f},{0.197382f,-0.801534f,-0.564432f},{-0.24008f,-0.806336f,-0.54054f},
	{0.149757f,-0.90336f,-0.401889f},{-0.214947f,-0.884715f,-0.413614f},{-0.00361947f,-0.998239f,-0.0592032f},
	{0.000289462f,-0.923248f,-0.384205f},{0.99935f,7.32087e-005f,-0.0360433f},{-0.132303f,0.859023f,-0.494545f},
	{-0.145011f,0.940077f,-0.308588f},{-0.145949f,0.936997f,-0.317387f},{-0.112723f,0.742104f,-0.660738f},
	{0.647982f,-0.349544f,-0.676712f},{0.75514f,-0.147652f,-0.638719f},{-0.0898762f,0.594363f,-0.799159f},
	{-0.00381381f,-0.184719f,-0.982784f},{0.102191f,-0.87449f,-0.474155f},{-7.33698e-005f,0.257996f,-0.966146f},
	{7.75359e-008f,0.795583f,-0.605844f},{-0.326394f,-0.425868f,-0.843862f},{-0.143616f,-0.0702339f,-0.987138f},
	{0.0891187f,-0.681542f,-0.726332f},{-0.222711f,-0.000272707f,-0.974885f},{0.214215f,0.000921458f,-0.976786f},
	{0.728642f,0.00345042f,-0.684886f},{-0.735846f,-0.00014084f,-0.677148f},{-0.992044f,0.00016362f,-0.125893f},
	{-0.99694f,0.000135919f,-0.0781646f},{0.0678716f,-0.997689f,-0.00330243f},{0.101862f,-0.994729f,-0.0118101f},
	{0.0678741f,-0.997693f,0.00126437f},{0.0f,-0.999907f,0.0136353f},{0.0f,-0.150591f,-0.988596f},
	{0.0f,-0.436386f,-0.89976f},{0.0f,-0.706465f,-0.707748f},{0.0f,0.579434f,-0.815019f},
	{0.0f,0.150591f,-0.988596f},{0.0f,0.579434f,-0.815019f},{0.0f,-0.885832f,-0.464006f},
	{-1.14482e-005f,-0.938995f,-0.343931f},{0.0f,-0.88585f,-0.463972f},{0.0f,-0.976473f,-0.215641f},
	{0.0f,0.959882f,-0.280404f},{-8.40575e-006f,0.885832f,-0.464005f},{-1.702e-005f,0.959885f,-0.280395f},
	{0.0f,0.885815f,-0.464039f},{-8.37983e-006f,-0.996311f,-0.0858118f},{0.0f,-0.996313f,-0.0857917f},
	{-8.28085e-006f,0.996311f,-0.085812f},{0.0f,0.996313f,-0.0857922f},{-0.101862f,-0.994729f,-0.0118101f},
	{-0.0678716f,-0.997689f,-0.00330243f},{-0.0678741f,-0.997693f,0.00126437f},{1.14482e-005f,-0.938995f,-0.343931f},
	{8.40575e-006f,0.885832f,-0.464005f},{1.702e-005f,0.959885f,-0.280395f},{8.37983e-006f,-0.996311f,-0.0858118f},
	{8.28085e-006f,0.996311f,-0.085812f}
	};
	static GLfloat textures [610][2] = {
	{0.340065f,0.804648f},{0.328884f,0.804648f},{0.334475f,0.764f},
	{0.317013f,0.831565f},{0.294577f,0.844348f},{0.28842f,0.765826f},
	{0.317013f,0.844348f},{0.0575824f,0.844348f},{0.0710239f,0.791243f},
	{0.0693647f,0.844348f},{0.061477f,0.795044f},{0.0811505f,0.844348f},
	{0.0798001f,0.780986f},{0.0766721f,0.780183f},{0.055806f,0.844348f},
	{0.0575824f,0.796189f},{0.055806f,0.800522f},{0.0430913f,0.782618f},
	{0.0280116f,0.831565f},{0.0488222f,0.795764f},{0.039931f,0.764f},
	{0.0248645f,0.814931f},{0.28842f,0.89f},{0.294577f,0.89f},
	{0.0161413f,0.804648f},{0.32016f,0.814931f},{0.0105503f,0.764f},
	{0.0915314f,0.89f},{0.0811505f,0.89f},{0.0915314f,0.844348f},
	{0.0915314f,0.782576f},{0.178103f,0.804648f},{0.166921f,0.804648f},
	{0.172512f,0.764f},{0.21241f,0.844348f},{0.189974f,0.831565f},
	{0.218567f,0.765826f},{0.189974f,0.844348f},{0.112039f,0.791243f},
	{0.12548f,0.844348f},{0.113698f,0.844348f},{0.121586f,0.795044f},
	{0.101912f,0.844348f},{0.103272f,0.780986f},{0.106391f,0.780183f},
	{0.12548f,0.796189f},{0.127257f,0.844348f},{0.127257f,0.800522f},
	{0.139971f,0.782618f},{0.155051f,0.831565f},{0.134241f,0.795764f},
	{0.143132f,0.764f},{0.158198f,0.814931f},{0.218567f,0.89f},
	{0.21241f,0.89f},{0.186827f,0.814931f},{0.101912f,0.89f},
	{0.0794712f,0.764f},{0.0915314f,0.764f},{0.103592f,0.764f},
	{0.274709f,0.844348f},{0.270479f,0.765826f},{0.267637f,0.844348f},
	{0.281077f,0.89f},{0.253494f,0.844348f},{0.253494f,0.765826f},
	{0.236508f,0.765826f},{0.232278f,0.844348f},{0.23935f,0.844348f},
	{0.22591f,0.89f},{0.0280116f,0.844348f},{0.155051f,0.844348f},
	{0.274709f,0.89f},{0.232278f,0.89f},{0.008048f,0.861444f},
	{0.00884048f,0.860022f},{0.0134938f,0.860839f},{0.0671595f,0.860022f},
	{0.067952f,0.861444f},{0.0625062f,0.860839f},{0.0134938f,0.887895f},
	{0.008048f,0.887711f},{0.008048f,0.886381f},{0.0475302f,0.860839f},
	{0.0439019f,0.852099f},{0.0475302f,0.852099f},{0.0439019f,0.860839f},
	{0.0250907f,0.933573f},{0.0189396f,0.93164f},{0.038f,0.934748f},
	{0.0165435f,0.925242f},{0.0189396f,0.93164f},{0.0165435f,0.928851f},
	{0.0189396f,0.925555f},{0.008048f,0.902485f},{0.0134938f,0.918963f},
	{0.008048f,0.918963f},{0.0134938f,0.908177f},{0.0134938f,0.918963f},
	{0.0104442f,0.921752f},{0.008048f,0.918963f},{0.0134938f,0.921752f},
	{0.0181371f,0.85507f},{0.0284698f,0.852099f},{0.00884048f,0.860022f},
	{0.0284698f,0.860839f},{0.0134938f,0.860839f},{0.0284698f,0.852099f},
	{0.00884048f,0.860022f},{0.0284698f,0.852099f},{0.0326563f,0.852099f},
	{0.0284698f,0.860839f},{0.0284698f,0.852099f},{0.0326563f,0.860839f},
	{0.008048f,0.861444f},{0.0134938f,0.878217f},{0.008048f,0.883909f},
	{0.0134938f,0.860839f},{0.008048f,0.898983f},{0.0134938f,0.898799f},
	{0.008048f,0.900313f},{0.0134938f,0.895562f},{0.008048f,0.898983f},
	{0.008048f,0.8955f},{0.0134938f,0.898799f},{0.008048f,0.891194f},
	{0.0134938f,0.895562f},{0.008048f,0.8955f},{0.0134938f,0.891127f},
	{0.008048f,0.887711f},{0.0134938f,0.891127f},{0.008048f,0.891194f},
	{0.0134938f,0.887895f},{0.0165435f,0.928851f},{0.0134938f,0.925242f},
	{0.0165435f,0.925242f},{0.0136114f,0.92753f},{0.0104442f,0.921752f},
	{0.0134938f,0.921752f},{0.010561f,0.925548f},{0.010561f,0.925548f},
	{0.0134938f,0.925242f},{0.0136114f,0.92753f},{0.038f,0.934748f},
	{0.0189396f,0.925555f},{0.038f,0.925555f},{0.0189396f,0.93164f},
	{0.0382791f,0.851252f},{0.0382791f,0.852099f},{0.0326563f,0.852099f},
	{0.0326563f,0.852099f},{0.0382791f,0.860839f},{0.0326563f,0.860839f},
	{0.008048f,0.900313f},{0.038f,0.898799f},{0.038f,0.900313f},
	{0.038f,0.883909f},{0.008048f,0.883909f},{0.038f,0.886381f},
	{0.038f,0.902485f},{0.0134938f,0.908177f},{0.008048f,0.902485f},
	{0.038f,0.908177f},{0.008048f,0.902485f},{0.038f,0.878217f},
	{0.0134938f,0.878217f},{0.0134938f,0.887895f},{0.008048f,0.886381f},
	{0.038f,0.887895f},{0.0570604f,0.93164f},{0.0509093f,0.933573f},
	{0.038f,0.934748f},{0.0570604f,0.93164f},{0.0594565f,0.925242f},
	{0.0594565f,0.928851f},{0.0570604f,0.925555f},{0.0625062f,0.918963f},
	{0.067952f,0.902485f},{0.067952f,0.918963f},{0.0625062f,0.908177f},
	{0.0655558f,0.921752f},{0.0625062f,0.918963f},{0.067952f,0.918963f},
	{0.0625062f,0.921752f},{0.0475302f,0.852099f},{0.0578629f,0.85507f},
	{0.0671595f,0.860022f},{0.0625062f,0.860839f},{0.0475302f,0.860839f},
	{0.0671595f,0.860022f},{0.0625062f,0.860839f},{0.0475302f,0.852099f},
	{0.0625062f,0.878217f},{0.067952f,0.861444f},{0.067952f,0.883909f},
	{0.0625062f,0.860839f},{0.0625062f,0.898799f},{0.067952f,0.898983f},
	{0.067952f,0.900313f},{0.067952f,0.898983f},{0.0625062f,0.895562f},
	{0.067952f,0.8955f},{0.0625062f,0.895562f},{0.067952f,0.891194f},
	{0.067952f,0.8955f},{0.0625062f,0.891127f},{0.0625062f,0.891127f},
	{0.067952f,0.887711f},{0.067952f,0.891194f},{0.0625062f,0.887895f},
	{0.0625062f,0.925242f},{0.0594565f,0.928851f},{0.0594565f,0.925242f},
	{0.0623886f,0.92753f},{0.0655558f,0.921752f},{0.0625062f,0.925242f},
	{0.0625062f,0.921752f},{0.065439f,0.925548f},{0.0625062f,0.925242f},
	{0.065439f,0.925548f},{0.0623886f,0.92753f},{0.067952f,0.887711f},
	{0.0625062f,0.887895f},{0.067952f,0.886381f},{0.0570604f,0.925555f},
	{0.038f,0.934748f},{0.038f,0.925555f},{0.0570604f,0.93164f},
	{0.0382791f,0.851252f},{0.0439019f,0.852099f},{0.0382791f,0.860839f},
	{0.0439019f,0.860839f},{0.038f,0.898799f},{0.067952f,0.900313f},
	{0.0625062f,0.898799f},{0.067952f,0.886381f},{0.0625062f,0.908177f},
	{0.067952f,0.902485f},{0.038f,0.908177f},{0.067952f,0.902485f},
	{0.038f,0.878217f},{0.067952f,0.883909f},{0.0625062f,0.878217f},
	{0.0625062f,0.887895f},{0.067952f,0.886381f},{0.038f,0.887895f},
	{0.162107f,0.851171f},{0.162107f,0.858711f},{0.162107f,0.850212f},
	{0.162107f,0.857312f},{0.153415f,0.857321f},{0.153428f,0.858711f},
	{0.153428f,0.859371f},{0.153415f,0.860762f},{0.149284f,0.936118f},
	{0.133814f,0.930104f},{0.148824f,0.937948f},{0.135348f,0.929125f},
	{0.136794f,0.875091f},{0.135348f,0.876396f},{0.136794f,0.876396f},
	{0.135348f,0.875091f},{0.138522f,0.876396f},{0.137857f,0.875482f},
	{0.14862f,0.938701f},{0.1334f,0.930835f},{0.13402f,0.858472f},
	{0.138964f,0.859371f},{0.137131f,0.856443f},{0.137131f,0.856443f},
	{0.146472f,0.854868f},{0.145389f,0.852421f},{0.153265f,0.85279f},
	{0.15061f,0.85072f},{0.15056f,0.853494f},{0.153265f,0.850073f},
	{0.145389f,0.852421f},{0.1534f,0.852383f},{0.153265f,0.850073f},
	{0.153399f,0.850415f},{0.138964f,0.868362f},{0.138964f,0.859371f},
	{0.138329f,0.868055f},{0.138329f,0.8735f},{0.138964f,0.873779f},
	{0.138329f,0.875009f},{0.138964f,0.876396f},{0.138964f,0.876396f},
	{0.133814f,0.8735f},{0.133178f,0.868366f},{0.133178f,0.87378f},
	{0.133814f,0.868055f},{0.133814f,0.875009f},{0.133178f,0.876396f},
	{0.133178f,0.868366f},{0.13402f,0.858472f},{0.133178f,0.860037f},
	{0.153265f,0.859371f},{0.153265f,0.861351f},{0.153265f,0.856732f},
	{0.153265f,0.859371f},{0.150704f,0.859371f},{0.145561f,0.859371f},
	{0.150704f,0.859371f},{0.145561f,0.859371f},{0.13402f,0.858472f},
	{0.135348f,0.86745f},{0.137131f,0.856443f},{0.13402f,0.858472f},
	{0.136794f,0.867448f},{0.135348f,0.872158f},{0.136794f,0.872158f},
	{0.135348f,0.874434f},{0.136794f,0.874434f},{0.134286f,0.875064f},
	{0.137131f,0.856443f},{0.162107f,0.856732f},{0.153428f,0.851394f},
	{0.162107f,0.851534f},{0.133814f,0.876396f},{0.133178f,0.876396f},
	{0.165f,0.940413f},{0.165f,0.938546f},{0.14862f,0.938701f},
	{0.165f,0.941186f},{0.165f,0.848815f},{0.153265f,0.850073f},
	{0.165f,0.84908f},{0.165f,0.858711f},{0.165f,0.850134f},
	{0.165f,0.859371f},{0.165f,0.860766f},{0.165f,0.922052f},
	{0.138405f,0.920582f},{0.136794f,0.922052f},{0.165f,0.920582f},
	{0.165f,0.920072f},{0.138964f,0.930233f},{0.138964f,0.920072f},
	{0.165f,0.930233f},{0.138964f,0.920072f},{0.153265f,0.859371f},
	{0.165f,0.861351f},{0.165f,0.859371f},{0.145561f,0.859371f},
	{0.138964f,0.859371f},{0.136794f,0.895f},{0.135348f,0.895f},
	{0.133814f,0.895f},{0.138472f,0.895f},{0.138964f,0.895f},
	{0.138964f,0.920072f},{0.133178f,0.895f},{0.133178f,0.876396f},
	{0.1334f,0.930835f},{0.133178f,0.895f},{0.165f,0.929125f},
	{0.167893f,0.858711f},{0.167893f,0.851171f},{0.167893f,0.850212f},
	{0.167893f,0.857312f},{0.176585f,0.857321f},{0.176572f,0.858711f},
	{0.176572f,0.859371f},{0.176585f,0.860762f},{0.196186f,0.930104f},
	{0.180716f,0.936118f},{0.181176f,0.937948f},{0.194652f,0.929125f},
	{0.194652f,0.876396f},{0.193206f,0.875091f},{0.193206f,0.876396f},
	{0.194652f,0.875091f},{0.191478f,0.876396f},{0.192143f,0.875482f},
	{0.18138f,0.938701f},{0.1966f,0.930835f},{0.191036f,0.859371f},
	{0.19598f,0.858472f},{0.192869f,0.856443f},{0.183528f,0.854868f},
	{0.192869f,0.856443f},{0.184611f,0.852421f},{0.17939f,0.85072f},
	{0.176735f,0.85279f},{0.17944f,0.853494f},{0.176735f,0.850073f},
	{0.17939f,0.85072f},{0.184611f,0.852421f},{0.176735f,0.850073f},
	{0.176601f,0.852383f},{0.176601f,0.850415f},{0.191036f,0.868362f},
	{0.191036f,0.859371f},{0.191671f,0.868055f},{0.191671f,0.8735f},
	{0.191036f,0.873779f},{0.191671f,0.875009f},{0.191036f,0.876396f},
	{0.191036f,0.876396f},{0.196822f,0.868366f},{0.196186f,0.8735f},
	{0.196822f,0.87378f},{0.196186f,0.868055f},{0.196186f,0.875009f},
	{0.196822f,0.876396f},{0.19598f,0.858472f},{0.196822f,0.868366f},
	{0.196822f,0.860037f},{0.176735f,0.859371f},{0.176735f,0.861351f},
	{0.176735f,0.856732f},{0.176735f,0.859371f},{0.179296f,0.859371f},
	{0.184439f,0.859371f},{0.179296f,0.859371f},{0.184439f,0.859371f},
	{0.19598f,0.858472f},{0.194652f,0.86745f},{0.192869f,0.856443f},
	{0.19598f,0.858472f},{0.193206f,0.867448f},{0.194652f,0.872158f},
	{0.193206f,0.872158f},{0.194652f,0.874434f},{0.193206f,0.874434f},
	{0.195714f,0.875064f},{0.192869f,0.856443f},{0.167893f,0.856732f},
	{0.176572f,0.851394f},{0.167893f,0.851534f},{0.196186f,0.876396f},
	{0.196822f,0.876396f},{0.18138f,0.938701f},{0.165f,0.941186f},
	{0.165f,0.848815f},{0.176735f,0.850073f},{0.191595f,0.920582f},
	{0.193206f,0.922052f},{0.191036f,0.930233f},{0.191036f,0.920072f},
	{0.165f,0.930233f},{0.191036f,0.920072f},{0.176735f,0.859371f},
	{0.165f,0.859371f},{0.184439f,0.859371f},{0.191036f,0.859371f},
	{0.193206f,0.895f},{0.194652f,0.895f},{0.196186f,0.895f},
	{0.191528f,0.895f},{0.191036f,0.895f},{0.191036f,0.920072f},
	{0.191036f,0.895f},{0.196822f,0.895f},{0.1966f,0.930835f},
	{0.196822f,0.895f},{0.28202f,0.9905f},{0.276337f,0.99941f},
	{0.28202f,0.99941f},{0.277101f,0.990239f},{0.28202f,0.99941f},
	{0.290538f,0.9905f},{0.28202f,0.9905f},{0.287374f,0.996384f},
	{0.0656675f,0.985714f},{0.0651311f,0.974239f},{0.0789199f,0.974239f},
	{0.0591638f,0.983435f},{0.074429f,0.9905f},{0.0713872f,0.988395f},
	{0.0789199f,0.974239f},{0.0651311f,0.974239f},{0.051936f,0.984575f},
	{0.0496316f,0.974239f},{0.0591638f,0.983435f},{0.25144f,0.9905f},
	{0.276101f,0.966239f},{0.28202f,0.9905f},{0.25144f,0.966239f},
	{0.074429f,0.9905f},{0.0893823f,0.974239f},{0.0894779f,0.9905f},
	{0.0789199f,0.974239f},{0.0644779f,0.988f},{0.0539199f,0.991239f},
	{0.0513999f,0.988f},{0.0643823f,0.991239f},{0.0713872f,0.988395f},
	{0.0656675f,0.985714f},{0.0789199f,0.974239f},{0.25144f,0.96337f},
	{0.313976f,0.959005f},{0.306278f,0.96337f},{0.25144f,0.959005f},
	{0.0269423f,0.959005f},{0.0894779f,0.96037f},{0.0346399f,0.96037f},
	{0.0894779f,0.959005f},{0.0455281f,0.968653f},{0.0894779f,0.968653f},
	{0.0894779f,0.94556f},{0.0252532f,0.94656f},{0.315665f,0.95556f},
	{0.25144f,0.95556f},{0.25144f,0.965653f},{0.30339f,0.965653f},
	{0.0496316f,0.974239f},{0.0893823f,0.974239f},{0.301128f,0.966239f},
	{0.25144f,0.966239f},{0.0427511f,0.9905f},{0.00144966f,0.9905f},
	{0.0252532f,0.94656f},{0.0155255f,0.959947f},{0.0155255f,0.959947f},
	{0.0269423f,0.959005f},{0.00144966f,0.9905f},{0.315665f,0.95556f},
	{0.325405f,0.959951f},{0.00846608f,0.959951f},{0.0155255f,0.959947f},
	{0.00144966f,0.9905f},{0.325405f,0.959951f},{0.332421f,0.9905f},
	{0.290538f,0.9905f},{0.332421f,0.9905f},{0.0427511f,0.9905f},
	{0.0460888f,0.987731f},{0.0460888f,0.987731f},{0.0496316f,0.974239f},
	{0.051936f,0.984575f},{0.301128f,0.966239f},{0.290538f,0.9905f},
	{0.287374f,0.966239f},{0.226543f,0.999f},{0.22086f,0.9905f},
	{0.22086f,0.999f},{0.226779f,0.990739f},{0.219342f,0.99f},
	{0.22086f,0.999f},{0.22086f,0.9905f},{0.215506f,0.990239f},
	{0.113633f,0.974239f},{0.113288f,0.985714f},{0.0998447f,0.974239f},
	{0.119792f,0.983435f},{0.107568f,0.988395f},{0.104527f,0.9905f},
	{0.0998447f,0.974239f},{0.12702f,0.984575f},{0.113633f,0.974239f},
	{0.129133f,0.974239f},{0.119792f,0.983435f},{0.223779f,0.985239f},
	{0.25144f,0.9905f},{0.22086f,0.9905f},{0.25144f,0.966239f},
	{0.104527f,0.9905f},{0.0894779f,0.9905f},{0.0998447f,0.974239f},
	{0.124845f,0.990739f},{0.114478f,0.9875f},{0.127556f,0.9875f},
	{0.114382f,0.990739f},{0.113288f,0.985714f},{0.107568f,0.988395f},
	{0.0998447f,0.974239f},{0.188904f,0.959005f},{0.196602f,0.96337f},
	{0.152013f,0.959005f},{0.144316f,0.96037f},{0.132428f,0.968653f},
	{0.0894779f,0.94556f},{0.153703f,0.94656f},{0.187215f,0.95556f},
	{0.25144f,0.95556f},{0.20049f,0.965653f},{0.129133f,0.974239f},
	{0.0893823f,0.974239f},{0.201752f,0.966239f},{0.25144f,0.966239f},
	{0.136205f,0.9905f},{0.170459f,0.9905f},{0.153703f,0.94656f},
	{0.16343f,0.959947f},{0.16343f,0.959947f},{0.170459f,0.9905f},
	{0.187215f,0.95556f},{0.177475f,0.959951f},{0.16343f,0.959947f},
	{0.177475f,0.959951f},{0.170459f,0.9905f},{0.177475f,0.959951f},
	{0.212342f,0.9905f},{0.170459f,0.9905f},{0.136205f,0.9905f},
	{0.132867f,0.987731f},{0.129133f,0.974239f},{0.132867f,0.987731f},
	{0.12702f,0.984575f},{0.212342f,0.9905f},{0.212342f,0.9905f},
	{0.201752f,0.966239f},{0.215506f,0.990239f},{0.28202f,0.99941f},
	{0.287374f,0.99941f},{0.287374f,0.996384f},{0.215506f,0.996094f},
	{0.215506f,0.990239f}
	};
	GLint GenEPuckBody()
	{
	unsigned i;
	unsigned j;
	
	GLint lid=glGenLists(1);
	glNewList(lid, GL_COMPILE);
	
		glBegin (GL_TRIANGLES);
		for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
		{
		for(j=0;j<3;j++)
			{
			int vi=face_indicies[i][j];
			int ni=face_indicies[i][j+3];//Normal index
			int ti=face_indicies[i][j+6];//Texture index
			/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
			
			// rotate 90 deg around z
			glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][1],-vertices[vi][0],vertices[vi][2]);
			}
		}
		glEnd ();
	
	glEndList();
	return lid;
	};
}
