/* $Id: e2p_sort_by_ext.c 1835 2009-09-17 00:35:44Z tpgww $

Copyright (C) 2003-2009 tooar <tooar@emelfm2.net>
Portions copyright (C) 1999 Michael Clark

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

/**
@file plugins/e2p_sort_by_ext.c
@brief plugin to enable sorting of filelists by extension, instead of by name
This is effectively redundant, pressing <Control> before a sort-click achieves
the same effect
*/

#include "emelfm2.h"
#include <string.h>
#include "e2_plugins.h"
#include "e2_filelist.h"

extern gint stored_col_order[2][MAX_COLUMNS];
extern gint displayed_col_order[2][MAX_COLUMNS];

/**
@brief sort active filepane by item-extension
Expects BGL on/closed
@param from the button, menu item etc which was activated
@param art action runtime data

@return TRUE
*/
static gboolean _e2p_sort_by_ext (gpointer from, E2_ActionRuntime *art)
{
	E2_PaneRuntime *rt = e2_pane_get_runtime (from, art->data, NULL);
	//replace the sort function for filename column of liststore
	//sortable uses base model, even with filter-model parent
    GtkTreeSortable *sortable = GTK_TREE_SORTABLE (rt->view.store);
	gint sortcolnow;
	GtkSortType sort_order = rt->view.sort_order;

	if (rt->view.extsort)
		//already extension-sorted, toggle direction
		rt->view.sort_order = (sort_order == GTK_SORT_ASCENDING) ?
			GTK_SORT_DESCENDING : GTK_SORT_ASCENDING;
	else
		rt->view.extsort = TRUE;

	gtk_tree_sortable_get_sort_column_id (sortable, &sortcolnow, &sort_order);
	gtk_widget_hide (rt->view.sort_arrows[sortcolnow]);
	gtk_arrow_set (GTK_ARROW (rt->view.sort_arrows[FILENAME]),
		(rt->view.sort_order == GTK_SORT_ASCENDING) ?
			 GTK_ARROW_RIGHT : GTK_ARROW_LEFT, GTK_SHADOW_IN);
	gtk_widget_show (rt->view.sort_arrows[FILENAME]);

	gtk_tree_sortable_set_sort_func (sortable, FILENAME,
		(GtkTreeIterCompareFunc) e2_fileview_ext_sort, &sort_order, NULL);
	//do the sort
	gtk_tree_sortable_set_sort_column_id (sortable, FILENAME, rt->view.sort_order);
	return TRUE;
}

//aname must be confined to this module
static gchar *aname;
/**
@brief plugin initialization function, called by main program

@param p ptr to plugin data struct

@return TRUE if the initialization succeeds, else FALSE
*/
gboolean init_plugin (Plugin *p)
{
#define ANAME "sort_by_ext"
  aname = _("sort_by_ext");

  p->signature = ANAME VERSION;
  p->menu_name = _("Extension _sort");
  p->description = _("Sort the active file pane by filename extension");
  p->icon = "plugin_extsort"E2ICONTB;  //use icon file pathname if appropriate

  if (p->action == NULL)
  {
	//don't free name string here
	E2_Action plugact =
	{g_strconcat (_A(7),".",aname,NULL),_e2p_sort_by_ext,TRUE,E2_ACTION_TYPE_ITEM,0,NULL,NULL};
	p->action = e2_plugins_action_register (&plugact);
	if G_LIKELY((p->action != NULL))
		return TRUE;
	g_free (plugact.name);
  }
  return FALSE;
}
/**
@brief cleanup transient things for this plugin

@param p pointer to data struct for the plugin

@return TRUE if all cleanups were completed
*/
gboolean clean_plugin (Plugin *p)
{
  gchar *action_name = g_strconcat (_A(7),".",aname,NULL);
  gboolean ret = e2_plugins_action_unregister (action_name);
  g_free (action_name);
  return ret;
}
