/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, Sortable) {
  var ajax = Drupal.ajax,
      behaviors = Drupal.behaviors,
      debounce = Drupal.debounce,
      announce = Drupal.announce,
      formatPlural = Drupal.formatPlural;
  var layoutBuilderBlocksFiltered = false;
  behaviors.layoutBuilderBlockFilter = {
    attach: function attach(context) {
      var $categories = $('.js-layout-builder-categories', context);
      var $filterLinks = $categories.find('.js-layout-builder-block-link');

      var filterBlockList = function filterBlockList(e) {
        var query = $(e.target).val().toLowerCase();

        var toggleBlockEntry = function toggleBlockEntry(index, link) {
          var $link = $(link);
          var textMatch = $link.text().toLowerCase().indexOf(query) !== -1;
          $link.toggle(textMatch);
        };

        if (query.length >= 2) {
          $categories.find('.js-layout-builder-category:not([open])').attr('remember-closed', '');
          $categories.find('.js-layout-builder-category').attr('open', '');
          $filterLinks.each(toggleBlockEntry);
          $categories.find('.js-layout-builder-category:not(:has(.js-layout-builder-block-link:visible))').hide();
          announce(formatPlural($categories.find('.js-layout-builder-block-link:visible').length, '1 block is available in the modified list.', '@count blocks are available in the modified list.'));
          layoutBuilderBlocksFiltered = true;
        } else if (layoutBuilderBlocksFiltered) {
          layoutBuilderBlocksFiltered = false;
          $categories.find('.js-layout-builder-category[remember-closed]').removeAttr('open').removeAttr('remember-closed');
          $categories.find('.js-layout-builder-category').show();
          $filterLinks.show();
          announce(Drupal.t('All available blocks are listed.'));
        }
      };

      $(once('block-filter-text', 'input.js-layout-builder-filter', context)).on('keyup', debounce(filterBlockList, 200));
    }
  };

  Drupal.layoutBuilderBlockUpdate = function (item, from, to) {
    var $item = $(item);
    var $from = $(from);
    var itemRegion = $item.closest('.js-layout-builder-region');

    if (to === itemRegion[0]) {
      var deltaTo = $item.closest('[data-layout-delta]').data('layout-delta');
      var deltaFrom = $from ? $from.closest('[data-layout-delta]').data('layout-delta') : deltaTo;
      ajax({
        url: [$item.closest('[data-layout-update-url]').data('layout-update-url'), deltaFrom, deltaTo, itemRegion.data('region'), $item.data('layout-block-uuid'), $item.prev('[data-layout-block-uuid]').data('layout-block-uuid')].filter(function (element) {
          return element !== undefined;
        }).join('/')
      }).execute();
    }
  };

  behaviors.layoutBuilderBlockDrag = {
    attach: function attach(context) {
      var regionSelector = '.js-layout-builder-region';
      Array.prototype.forEach.call(context.querySelectorAll(regionSelector), function (region) {
        Sortable.create(region, {
          draggable: '.js-layout-builder-block',
          ghostClass: 'ui-state-drop',
          group: 'builder-region',
          onEnd: function onEnd(event) {
            return Drupal.layoutBuilderBlockUpdate(event.item, event.from, event.to);
          }
        });
      });
    }
  };
  behaviors.layoutBuilderDisableInteractiveElements = {
    attach: function attach() {
      var $blocks = $('#layout-builder [data-layout-block-uuid]');
      $blocks.find('input, textarea, select').prop('disabled', true);
      $blocks.find('a').not(function (index, element) {
        return $(element).closest('[data-contextual-id]').length > 0;
      }).on('click mouseup touchstart', function (e) {
        e.preventDefault();
        e.stopPropagation();
      });
      $blocks.find('button, [href], input, select, textarea, iframe, [tabindex]:not([tabindex="-1"]):not(.tabbable)').not(function (index, element) {
        return $(element).closest('[data-contextual-id]').length > 0;
      }).attr('tabindex', -1);
    }
  };
  $(window).on('dialog:aftercreate', function (event, dialog, $element) {
    if (Drupal.offCanvas.isOffCanvas($element)) {
      $('.is-layout-builder-highlighted').removeClass('is-layout-builder-highlighted');
      var id = $element.find('[data-layout-builder-target-highlight-id]').attr('data-layout-builder-target-highlight-id');

      if (id) {
        $("[data-layout-builder-highlight-id=\"".concat(id, "\"]")).addClass('is-layout-builder-highlighted');
      }

      $('#layout-builder').removeClass('layout-builder--move-blocks-active');
      var layoutBuilderWrapperValue = $element.find('[data-add-layout-builder-wrapper]').attr('data-add-layout-builder-wrapper');

      if (layoutBuilderWrapperValue) {
        $('#layout-builder').addClass(layoutBuilderWrapperValue);
      }
    }
  });

  if (document.querySelector('[data-off-canvas-main-canvas]')) {
    var mainCanvas = document.querySelector('[data-off-canvas-main-canvas]');
    mainCanvas.addEventListener('transitionend', function () {
      var $target = $('.is-layout-builder-highlighted');

      if ($target.length > 0) {
        var targetTop = $target.offset().top;
        var targetBottom = targetTop + $target.outerHeight();
        var viewportTop = $(window).scrollTop();
        var viewportBottom = viewportTop + $(window).height();

        if (targetBottom < viewportTop || targetTop > viewportBottom) {
          var viewportMiddle = (viewportBottom + viewportTop) / 2;
          var scrollAmount = targetTop - viewportMiddle;

          if ('scrollBehavior' in document.documentElement.style) {
            window.scrollBy({
              top: scrollAmount,
              left: 0,
              behavior: 'smooth'
            });
          } else {
            window.scrollBy(0, scrollAmount);
          }
        }
      }
    });
  }

  $(window).on('dialog:afterclose', function (event, dialog, $element) {
    if (Drupal.offCanvas.isOffCanvas($element)) {
      $('.is-layout-builder-highlighted').removeClass('is-layout-builder-highlighted');
      $('#layout-builder').removeClass('layout-builder--move-blocks-active');
    }
  });
  behaviors.layoutBuilderToggleContentPreview = {
    attach: function attach(context) {
      var $layoutBuilder = $('#layout-builder');
      var $layoutBuilderContentPreview = $('#layout-builder-content-preview');
      var contentPreviewId = $layoutBuilderContentPreview.data('content-preview-id');
      var isContentPreview = JSON.parse(localStorage.getItem(contentPreviewId)) !== false;

      var disableContentPreview = function disableContentPreview() {
        $layoutBuilder.addClass('layout-builder--content-preview-disabled');
        $('[data-layout-content-preview-placeholder-label]', context).each(function (i, element) {
          var $element = $(element);
          $element.children(':not([data-contextual-id])').hide(0);
          var contentPreviewPlaceholderText = $element.attr('data-layout-content-preview-placeholder-label');
          var contentPreviewPlaceholderLabel = Drupal.theme('layoutBuilderPrependContentPreviewPlaceholderLabel', contentPreviewPlaceholderText);
          $element.prepend(contentPreviewPlaceholderLabel);
        });
      };

      var enableContentPreview = function enableContentPreview() {
        $layoutBuilder.removeClass('layout-builder--content-preview-disabled');
        $('.js-layout-builder-content-preview-placeholder-label').remove();
        $('[data-layout-content-preview-placeholder-label]').each(function (i, element) {
          $(element).children().show();
        });
      };

      $('#layout-builder-content-preview', context).on('change', function (event) {
        var isChecked = $(event.currentTarget).is(':checked');
        localStorage.setItem(contentPreviewId, JSON.stringify(isChecked));

        if (isChecked) {
          enableContentPreview();
          announce(Drupal.t('Block previews are visible. Block labels are hidden.'));
        } else {
          disableContentPreview();
          announce(Drupal.t('Block previews are hidden. Block labels are visible.'));
        }
      });

      if (!isContentPreview) {
        $layoutBuilderContentPreview.attr('checked', false);
        disableContentPreview();
      }
    }
  };

  Drupal.theme.layoutBuilderPrependContentPreviewPlaceholderLabel = function (contentPreviewPlaceholderText) {
    var contentPreviewPlaceholderLabel = document.createElement('div');
    contentPreviewPlaceholderLabel.className = 'layout-builder-block__content-preview-placeholder-label js-layout-builder-content-preview-placeholder-label';
    contentPreviewPlaceholderLabel.innerHTML = contentPreviewPlaceholderText;
    return "<div class=\"layout-builder-block__content-preview-placeholder-label js-layout-builder-content-preview-placeholder-label\">".concat(contentPreviewPlaceholderText, "</div>");
  };
})(jQuery, Drupal, Sortable);