#ifndef __DW_FLTKPLATFORM_HH__
#define __DW_FLTKPLATFORM_HH__

#ifndef __INCLUDED_FROM_DW_FLTK_CORE_HH__
#   error Do not include this file directly, use "fltkcore.hh" instead.
#endif

#include <fltk/Font.h>

namespace dw {

/**
 * \brief This namespace contains FLTK implementations of Dw interfaces.
 */
namespace fltk {

class FltkFont: public core::style::Font
{
   static lout::container::typed::HashTable <dw::core::style::FontAttrs,
                                       FltkFont> *fontsTable;

   FltkFont (core::style::FontAttrs *attrs);
   ~FltkFont ();

public:
   ::fltk::Font *font;

   static FltkFont *create (core::style::FontAttrs *attrs);
};


class FltkColor: public core::style::Color
{
   static lout::container::typed::HashTable <dw::core::style::ColorAttrs,
                                       FltkColor> *colorsTable;

   FltkColor (int color);
   ~FltkColor ();

public:
   int colors[SHADING_NUM];

   static FltkColor *create(int color);
};


/**
 * \brief This interface adds some more methods for all flkt-based views.
 */
class FltkView: public core::View
{
public:
   virtual bool usesFltkWidgets () = 0;

   virtual void addFltkWidget (::fltk::Widget *widget,
                               core::Allocation *allocation);
   virtual void removeFltkWidget (::fltk::Widget *widget);
   virtual void allocateFltkWidget (::fltk::Widget *widget,
                                    core::Allocation *allocation);
   virtual void drawFltkWidget (::fltk::Widget *widget, core::Rectangle *area);
};


class FltkPlatform: public core::Platform
{
private:
   class FltkResourceFactory: public core::ui::ResourceFactory
   {
   private:
      FltkPlatform *platform;

   public:
      inline void setPlatform (FltkPlatform *platform) {
         this->platform = platform; }

      core::ui::LabelButtonResource *createLabelButtonResource (const char
                                                                *label);
      core::ui::ComplexButtonResource *
      createComplexButtonResource (core::Widget *widget, bool relief);
      core::ui::ListResource *
      createListResource (core::ui::ListResource::SelectionMode selectionMode,
                          int rows);
      core::ui::OptionMenuResource *createOptionMenuResource ();
      core::ui::EntryResource *createEntryResource (int maxLength,
                                                    bool password,
                                                    const char *label);
      core::ui::MultiLineTextResource *createMultiLineTextResource (int cols,
                                                                    int rows);
      core::ui::CheckButtonResource *createCheckButtonResource (bool
                                                                activated);
      core::ui::RadioButtonResource *
      createRadioButtonResource (core::ui::RadioButtonResource
                                  *groupedWith, bool activated);
   };

   FltkResourceFactory resourceFactory;

   class IdleFunc: public lout::object::Object
   {
   public:
      int id;
      void (core::Layout::*func) ();
   };

   core::Layout *layout;

   lout::container::typed::List <IdleFunc> *idleQueue;
   bool idleFuncRunning;
   int idleFuncId;

   static void generalStaticIdle(void *data);
   void generalIdle();

   lout::container::typed::List <FltkView> *views;
   lout::container::typed::List <ui::FltkResource> *resources;

public:
   FltkPlatform ();
   ~FltkPlatform ();

   void setLayout (core::Layout *layout);

   void attachView (core::View *view);

   void detachView  (core::View *view);

   int textWidth (core::style::Font *font, const char *text, int len);
   int nextGlyph (const char *text, int idx);
   int prevGlyph (const char *text, int idx);
   float dpiX ();
   float dpiY ();

   int addIdle (void (core::Layout::*func) ());
   void removeIdle (int idleId);

   core::style::Font *createFont (core::style::FontAttrs *attrs,
                                      bool tryEverything);
   core::style::Color *createColor (int color);

   core::Imgbuf *createImgbuf (core::Imgbuf::Type type, int width, int height);

   void copySelection(const char *text);

   core::ui::ResourceFactory *getResourceFactory ();

   void attachResource (ui::FltkResource *resource);
   void detachResource (ui::FltkResource *resource);
};

} // namespace fltk
} // namespace dw

#endif // __DW_FLTKPLATFORM_HH__
