/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetKeyInfo;

public class SqlJetBtreeTable
implements ISqlJetBtreeTable {
    protected ISqlJetBtree btree;
    protected int rootPage;
    protected boolean write;
    protected boolean index;
    private long priorNewRowid = 0L;
    private SqlJetBtreeRecord recordCache;
    private Object[] valueCache;
    private Object[] valuesCache;
    private Stack<State> states;

    public SqlJetBtreeTable(ISqlJetBtree btree, int rootPage, boolean write, boolean index) throws SqlJetException {
        this.init(btree, rootPage, write, index);
    }

    private void init(ISqlJetBtree btree, int rootPage, boolean write, boolean index) throws SqlJetException {
        this.states = new Stack();
        this.btree = btree;
        this.rootPage = rootPage;
        this.write = write;
        this.index = index;
        this.pushState();
        this.first();
    }

    private State getCurrentState() {
        assert (!this.states.isEmpty());
        return this.states.peek();
    }

    protected ISqlJetBtreeCursor getCursor() {
        return this.getCurrentState().getCursor();
    }

    protected SqlJetKeyInfo getKeyInfo() {
        return this.getCurrentState().getKeyInfo();
    }

    public void pushState() throws SqlJetException {
        SqlJetKeyInfo keyInfo = null;
        if (this.index) {
            keyInfo = new SqlJetKeyInfo();
            keyInfo.setEnc(this.btree.getDb().getOptions().getEncoding());
        }
        ISqlJetBtreeCursor cursor = this.btree.getCursor(this.rootPage, this.write, this.index ? keyInfo : null);
        this.states.push(new State(cursor, keyInfo));
        this.clearRecordCache();
    }

    public boolean popState() throws SqlJetException {
        if (this.states.size() <= 1) {
            return false;
        }
        State oldState = this.states.pop();
        oldState.close();
        this.clearRecordCache();
        return true;
    }

    public void close() throws SqlJetException {
        while (this.popState()) {
        }
        this.clearRecordCache();
        this.getCurrentState().close();
    }

    public void unlock() {
        this.getCursor().leaveCursor();
    }

    public void lock() throws SqlJetException {
        this.getCursor().enterCursor();
    }

    public boolean eof() throws SqlJetException {
        this.hasMoved();
        return this.getCursor().eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoved() throws SqlJetException {
        this.getCursor().enterCursor();
        try {
            boolean bl = this.getCursor().cursorHasMoved();
            Object var3_2 = null;
            this.getCursor().leaveCursor();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.getCursor().leaveCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            boolean bl = !this.getCursor().first();
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            boolean bl = !this.getCursor().last();
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            this.hasMoved();
            boolean bl = !this.getCursor().next();
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            this.hasMoved();
            boolean bl = !this.getCursor().previous();
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetBtreeRecord getRecord() throws SqlJetException {
        if (this.eof()) {
            return null;
        }
        if (null == this.recordCache) {
            this.lock();
            try {
                this.recordCache = new SqlJetBtreeRecord(this.getCursor(), this.index, this.btree.getDb().getOptions().getFileFormat());
                Object var2_1 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.unlock();
                throw throwable;
            }
            this.valueCache = new Object[this.recordCache.getFieldsCount()];
        }
        return this.recordCache;
    }

    public void lockTable(boolean write) {
        this.btree.lockTable(this.rootPage, write);
    }

    public SqlJetEncoding getEncoding() throws SqlJetException {
        return this.getCursor().getCursorDb().getOptions().getEncoding();
    }

    protected static boolean checkField(ISqlJetBtreeRecord record, int field) throws SqlJetException {
        return field >= 0 && record != null && field < record.getFieldsCount();
    }

    protected ISqlJetVdbeMem getValueMem(int field) throws SqlJetException {
        ISqlJetBtreeRecord r = this.getRecord();
        if (null == r) {
            return null;
        }
        if (!SqlJetBtreeTable.checkField(r, field)) {
            return null;
        }
        List<ISqlJetVdbeMem> fields = r.getFields();
        if (null == fields) {
            return null;
        }
        return fields.get(field);
    }

    public Object getValue(int field) throws SqlJetException {
        Object valueCached;
        if (this.valueCache != null && field < this.valueCache.length && (valueCached = this.valueCache[field]) != null) {
            return valueCached;
        }
        Object valueUncached = this.getValueUncached(field);
        if (valueUncached != null) {
            this.valueCache[field] = valueUncached;
        }
        return valueUncached;
    }

    public Object getValueUncached(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return null;
        }
        switch (value.getType()) {
            case INTEGER: {
                return value.intValue();
            }
            case FLOAT: {
                return value.realValue();
            }
            case TEXT: {
                return SqlJetUtility.toString(value.valueText(this.getEncoding()), this.getEncoding());
            }
            case BLOB: {
                return value.valueBlob();
            }
            case NULL: {
                break;
            }
        }
        return null;
    }

    public int getFieldsCount() throws SqlJetException {
        ISqlJetBtreeRecord r = this.getRecord();
        if (null == r) {
            return 0;
        }
        return r.getFieldsCount();
    }

    public boolean isNull(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (null == value) {
            return true;
        }
        return value.isNull();
    }

    public String getString(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return null;
        }
        return SqlJetUtility.toString(value.valueText(this.getEncoding()), this.getEncoding());
    }

    public long getInteger(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return 0L;
        }
        return value.intValue();
    }

    public double getFloat(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return 0.0;
        }
        return value.realValue();
    }

    public SqlJetValueType getFieldType(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null) {
            return SqlJetValueType.NULL;
        }
        return value.getType();
    }

    public ISqlJetMemoryPointer getBlob(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.valueBlob();
    }

    public Object[] getValues() throws SqlJetException {
        if (this.valuesCache != null) {
            return this.valuesCache;
        }
        ISqlJetBtreeRecord record = this.getRecord();
        int fieldsCount = record.getFieldsCount();
        for (int i = 0; i < fieldsCount; ++i) {
            this.valueCache[i] = this.getValue(i);
        }
        this.valuesCache = this.valueCache;
        return this.valueCache;
    }

    public long newRowId() throws SqlJetException {
        return this.newRowId(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long newRowId(long prev) throws SqlJetException {
        this.lock();
        try {
            boolean useRandomRowid = false;
            long v = 0L;
            int res = 0;
            int cnt = 0;
            if ((this.getCursor().flags() & (SqlJetBtreeTableCreateFlags.INTKEY.getValue() | SqlJetBtreeTableCreateFlags.ZERODATA.getValue())) != SqlJetBtreeTableCreateFlags.INTKEY.getValue()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert ((this.getCursor().flags() & SqlJetBtreeTableCreateFlags.INTKEY.getValue()) != 0);
            assert ((this.getCursor().flags() & SqlJetBtreeTableCreateFlags.ZERODATA.getValue()) == 0);
            long MAX_ROWID = Integer.MAX_VALUE;
            boolean last = this.getCursor().last();
            if (last) {
                v = 1L;
            } else {
                v = this.getCursor().getKeySize();
                if (v == MAX_ROWID) {
                    useRandomRowid = true;
                } else {
                    ++v;
                }
                if (prev != 0L) {
                    if (prev == MAX_ROWID || useRandomRowid) {
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                    if (v < prev) {
                        v = prev + 1L;
                    }
                }
                if (useRandomRowid) {
                    v = this.priorNewRowid;
                    Random random = new Random();
                    assert (prev == 0L);
                    cnt = 0;
                    do {
                        if (cnt == 0 && (v & 0xFFFFFFL) == v) {
                            ++v;
                        } else {
                            v = random.nextInt();
                            if (cnt < 5) {
                                v &= 0xFFFFFFL;
                            }
                        }
                        if (v == 0L) continue;
                        res = this.getCursor().moveToUnpacked(null, v, false);
                        ++cnt;
                    } while (cnt < 100 && res == 0);
                    this.priorNewRowid = v;
                    if (res == 0) {
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                }
            }
            long l = v;
            Object var14_10 = null;
            this.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.unlock();
            throw throwable;
        }
    }

    protected void clearRecordCache() {
        this.recordCache = null;
        this.valuesCache = null;
        this.valueCache = null;
    }

    public void clear() throws SqlJetException {
        this.btree.clearTable(this.rootPage, null);
    }

    public long getKeySize() throws SqlJetException {
        return this.getCursor().getKeySize();
    }

    public int moveTo(ISqlJetMemoryPointer pKey, long nKey, boolean bias) throws SqlJetException {
        this.clearRecordCache();
        return this.getCursor().moveTo(pKey, nKey, bias);
    }

    public void insert(ISqlJetMemoryPointer pKey, long nKey, ISqlJetMemoryPointer pData, int nData, int nZero, boolean bias) throws SqlJetException {
        this.clearRecordCache();
        this.getCursor().insert(pKey, nKey, pData, nData, nZero, bias);
    }

    public void delete() throws SqlJetException {
        this.clearRecordCache();
        this.getCursor().delete();
    }

    protected static class State {
        private ISqlJetBtreeCursor cursor;
        private SqlJetKeyInfo keyInfo;

        public State(ISqlJetBtreeCursor cursor, SqlJetKeyInfo keyInfo) {
            this.cursor = cursor;
            this.keyInfo = keyInfo;
        }

        public ISqlJetBtreeCursor getCursor() {
            return this.cursor;
        }

        public SqlJetKeyInfo getKeyInfo() {
            return this.keyInfo;
        }

        public void close() throws SqlJetException {
            if (this.cursor != null) {
                this.cursor.closeCursor();
            }
        }
    }
}

