/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = System.getProperty("file.separator");

    public DirectoryDialog(Shell shell) {
        this(shell, 65536);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        boolean bl;
        boolean bl2 = bl = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (bl) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        int n;
        int n2;
        Object object;
        Object object2;
        int n3;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n4 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        int n5 = 0;
        n5 = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(byArray, n4, 2, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0) : OS.gtk_file_chooser_dialog_new(byArray, n4, 2, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0);
        if (n5 == 0) {
            this.error(2);
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            n3 = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(n3, n5);
        }
        OS.gtk_window_set_modal(n5, true);
        n3 = OS.gtk_window_get_icon_list(n4);
        if (n3 != 0) {
            OS.gtk_window_set_icon_list(n5, n3);
            OS.g_list_free(n3);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            object2 = new StringBuffer();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                ((StringBuffer)object2).append(SEPARATOR);
            }
            ((StringBuffer)object2).append(this.filterPath);
            object = Converter.wcsToMbcs(null, ((StringBuffer)object2).toString(), true);
            n2 = OS.realpath((byte[])object, null);
            if (n2 != 0) {
                OS.gtk_file_chooser_set_current_folder(n5, n2);
                OS.g_free(n2);
            }
        }
        if (this.message.length() > 0) {
            object2 = Converter.wcsToMbcs(null, this.message, true);
            int n6 = OS.gtk_hbox_new(false, 0);
            if (n6 == 0) {
                this.error(2);
            }
            if ((n2 = OS.gtk_label_new((byte[])object2)) == 0) {
                this.error(2);
            }
            OS.gtk_container_add(n6, n2);
            OS.gtk_widget_show(n2);
            OS.gtk_label_set_line_wrap(n2, true);
            OS.gtk_label_set_justify(n2, 2);
            OS.gtk_file_chooser_set_extra_widget(n5, n6);
        }
        object2 = null;
        display.addIdleProc();
        object = null;
        if (OS.gtk_window_get_modal(n5)) {
            object = display.getModalDialog();
            display.setModalDialog(this);
        }
        n2 = 0;
        int n7 = 0;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n7 = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, n5, 0);
        }
        int n8 = OS.gtk_dialog_run(n5);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, n7);
        }
        if (OS.gtk_window_get_modal(n5)) {
            display.setModalDialog((Dialog)object);
        }
        if (n8 == -5 && (n = OS.gtk_file_chooser_get_filename(n5)) != 0) {
            int n9 = OS.g_filename_to_utf8(n, -1, null, null, null);
            OS.g_free(n);
            if (n9 != 0) {
                int[] nArray = new int[1];
                int n10 = OS.g_utf8_to_utf16(n9, -1, null, nArray, null);
                OS.g_free(n9);
                if (n10 != 0) {
                    int n11 = nArray[0];
                    char[] cArray = new char[n11];
                    OS.memmove(cArray, n10, n11 * 2);
                    OS.g_free(n10);
                    this.filterPath = object2 = new String(cArray);
                }
            }
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(n5);
        return object2;
    }

    String openClassicDialog() {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n6 = OS.gtk_file_selection_new(byArray);
        if (this.parent != null) {
            int n7 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(n6, n7);
            int n8 = OS.gtk_window_get_icon_list(n7);
            if (n8 != 0) {
                OS.gtk_window_set_icon_list(n6, n8);
                OS.g_list_free(n8);
            }
        }
        OS.gtk_window_set_modal(n6, true);
        String string = null;
        if (this.filterPath != null) {
            String string2 = this.filterPath;
            if (string2.length() > 0 && !string2.endsWith(SEPARATOR)) {
                string2 = String.valueOf(string2) + SEPARATOR;
            }
            n5 = string2.length();
            object = new char[n5 + 1];
            string2.getChars(0, n5, (char[])object, 0);
            n4 = OS.g_utf16_to_utf8((char[])object, -1, null, null, null);
            n3 = OS.g_filename_from_utf8(n4, -1, null, null, null);
            OS.gtk_file_selection_set_filename(n6, n3);
            OS.g_free(n4);
            OS.g_free(n3);
        }
        GtkFileSelection gtkFileSelection = new GtkFileSelection();
        OS.memmove(gtkFileSelection, n6);
        OS.gtk_file_selection_hide_fileop_buttons(n6);
        n5 = OS.gtk_widget_get_parent(gtkFileSelection.file_list);
        OS.gtk_widget_hide(gtkFileSelection.file_list);
        OS.gtk_widget_hide(n5);
        if (this.message.length() > 0) {
            object = Converter.wcsToMbcs(null, this.message, true);
            n4 = OS.gtk_label_new((byte[])object);
            OS.gtk_label_set_line_wrap(n4, true);
            OS.gtk_misc_set_alignment(n4, 0.0f, 0.0f);
            OS.gtk_container_add(gtkFileSelection.main_vbox, n4);
            OS.gtk_box_set_child_packing(gtkFileSelection.main_vbox, n4, false, false, 0, 0);
            OS.gtk_widget_show(n4);
        }
        object = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        ((Display)object).addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(n6)) {
            dialog = ((Display)object).getModalDialog();
            ((Display)object).setModalDialog(this);
        }
        n3 = 0;
        int n9 = 0;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n9 = OS.g_signal_add_emission_hook(n3, 0, ((Display)object).emissionProc, n6, 0);
        }
        int n10 = OS.gtk_dialog_run(n6);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, n9);
        }
        if (OS.gtk_window_get_modal(n6)) {
            ((Display)object).setModalDialog(dialog);
        }
        if (n10 == -5 && (n2 = OS.g_filename_to_utf8(n = OS.gtk_file_selection_get_filename(n6), -1, null, null, null)) != 0) {
            int[] nArray = new int[1];
            int n11 = OS.g_utf8_to_utf16(n2, -1, null, nArray, null);
            if (n11 != 0) {
                int n12 = nArray[0];
                char[] cArray = new char[n12];
                OS.memmove(cArray, n11, n12 * 2);
                String string3 = new String(cArray);
                if (string3 != null) {
                    if (!string3.equals(SEPARATOR) && string3.endsWith(SEPARATOR)) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    string = this.filterPath = string3;
                }
                OS.g_free(n11);
            }
            OS.g_free(n2);
        }
        ((Display)object).removeIdleProc();
        OS.gtk_widget_destroy(n6);
        return string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

