/*
 * Decompiled with CFR 0.152.
 */
package info.growl;

import info.growl.DummyGrowl;
import info.growl.Growl;
import info.growl.GrowlNative;
import java.util.HashMap;
import java.util.Map;

public final class GrowlUtils {
    private static final boolean GROWL_LOADED;
    private static final Map<String, Growl> instances;

    private GrowlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Growl getGrowlInstance(String appName) {
        Map<String, Growl> map = instances;
        synchronized (map) {
            Growl instance = instances.get(appName);
            if (instance == null) {
                instance = GROWL_LOADED ? new GrowlNative(appName) : new DummyGrowl();
                instances.put(appName, instance);
            }
            return instance;
        }
    }

    public static boolean isGrowlLoaded() {
        return GROWL_LOADED;
    }

    static {
        instances = new HashMap<String, Growl>();
        boolean loaded = false;
        try {
            System.loadLibrary("growl");
            loaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        GROWL_LOADED = loaded;
    }
}

