/*
 * Decompiled with CFR 0.152.
 */
package info.growl;

import info.growl.Growl;
import info.growl.GrowlCallbackListener;
import info.growl.GrowlException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

class GrowlNative
implements Growl {
    private final String appName;
    private final List<NotificationType> notifications = new ArrayList<NotificationType>();
    private final List<GrowlCallbackListener> callbackListeners = new ArrayList<GrowlCallbackListener>();
    private byte[] imageData;

    private native void sendNotification(String var1, String var2, String var3, String var4, String var5, byte[] var6);

    private native void registerApp(String var1, byte[] var2, List<NotificationType> var3);

    GrowlNative(String appName) {
        this.appName = appName;
    }

    void fireCallbacks(String callbackContext) {
        for (GrowlCallbackListener listener : this.callbackListeners) {
            listener.notificationWasClicked(callbackContext);
        }
    }

    @Override
    public void register() throws GrowlException {
        this.registerApp(this.appName, this.imageData, this.notifications);
    }

    @Override
    public void addNotification(String name, boolean enabledByDefault) {
        this.notifications.add(new NotificationType(name, enabledByDefault));
    }

    @Override
    public void addCallbackListener(GrowlCallbackListener listener) {
        this.callbackListeners.add(listener);
    }

    @Override
    public void setIcon(RenderedImage icon) throws GrowlException {
        this.imageData = this.convertImage(icon);
    }

    protected byte[] convertImage(RenderedImage icon) throws GrowlException {
        if (icon == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write(icon, "png", baos);
        }
        catch (IOException ioe) {
            throw new GrowlException("Failed to convert Image", ioe);
        }
        return baos.toByteArray();
    }

    @Override
    public void sendNotification(String name, String title, String body) throws GrowlException {
        this.sendNotification(name, title, body, null, null);
    }

    @Override
    public void sendNotification(String name, String title, String body, RenderedImage icon) throws GrowlException {
        this.sendNotification(name, title, body, null, icon);
    }

    @Override
    public void sendNotification(String name, String title, String body, String callbackContext) throws GrowlException {
        this.sendNotification(name, title, body, callbackContext, null);
    }

    @Override
    public void sendNotification(String name, String title, String body, String callbackContext, RenderedImage icon) throws GrowlException {
        if (!this.notifications.contains(new NotificationType(name, false))) {
            throw new GrowlException("Unregistered notification name [" + name + ']');
        }
        this.sendNotification(this.appName, name, title, body, callbackContext, this.convertImage(icon));
    }

    private class NotificationType {
        private final String name;
        private final boolean enabledByDefault;

        private NotificationType(String name, boolean enabledByDefault) {
            this.name = name;
            this.enabledByDefault = enabledByDefault;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }

        public boolean equals(Object other) {
            return other instanceof NotificationType && this.name.equals(((NotificationType)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

