/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropFindMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger((Class)PropFindMethod.class);

    public PropFindMethod(String uri) throws IOException {
        this(uri, 1, new DavPropertyNameSet(), Integer.MAX_VALUE);
    }

    public PropFindMethod(String uri, DavPropertyNameSet propNameSet, int depth) throws IOException {
        this(uri, 0, propNameSet, depth);
    }

    public PropFindMethod(String uri, int propfindType, int depth) throws IOException {
        this(uri, propfindType, new DavPropertyNameSet(), depth);
    }

    private PropFindMethod(String uri, int propfindType, DavPropertyNameSet propNameSet, int depth) throws IOException {
        super(uri);
        DepthHeader dh = new DepthHeader(depth);
        this.setRequestHeader(dh.getHeaderName(), dh.getHeaderValue());
        try {
            Document document = BUILDER_FACTORY.newDocumentBuilder().newDocument();
            Element propfind = DomUtil.createElement(document, "propfind", NAMESPACE);
            document.appendChild(propfind);
            switch (propfindType) {
                case 1: {
                    propfind.appendChild(DomUtil.createElement(document, "allprop", NAMESPACE));
                    break;
                }
                case 2: {
                    propfind.appendChild(DomUtil.createElement(document, "propname", NAMESPACE));
                    break;
                }
                default: {
                    if (propNameSet == null) {
                        propfind.appendChild(DomUtil.createElement(document, "prop", NAMESPACE));
                        break;
                    }
                    propfind.appendChild(propNameSet.toXml(document));
                }
            }
            this.setRequestBody(document);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getName() {
        return "PROPFIND";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 207;
    }
}

