/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.pe.res;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.charabia.jsmoothgen.pe.res.ResIcon;

public class ResIcon32
extends ResIcon {
    BufferedImage image;

    public ResIcon32(Image img) throws Exception {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        this.image = (BufferedImage)img;
        this.BitsPerPixel = 32;
        this.Size = 40L;
        this.Width = width;
        this.Height = height * 2;
        this.Planes = 1;
        this.Compression = 0L;
        this.SizeOfBitmap = 0L;
        this.HorzResolution = 0L;
        this.VertResolution = 0L;
        this.ColorsUsed = 0L;
        this.ColorsImportant = 0L;
    }

    public ByteBuffer getData() {
        int rowsize = (int)this.Width / 8;
        int padding = 0;
        if (rowsize % 4 > 0) {
            padding = (int)((4L - this.Width / 8L % 4L) * 8L);
            rowsize += 4 - rowsize % 4;
        }
        int transparencyBytesSize = (int)((long)rowsize * (this.Height / 2L));
        int[] transparencyMask = new int[transparencyBytesSize];
        ByteBuffer buf = ByteBuffer.allocate((int)(40L + this.Width * (this.Height / 2L) * (long)this.BitsPerPixel / 8L + (long)transparencyBytesSize));
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(0);
        buf.putInt((int)this.Size);
        buf.putInt((int)this.Width);
        buf.putInt((int)this.Height);
        buf.putShort((short)this.Planes);
        buf.putShort((short)this.BitsPerPixel);
        buf.putInt((int)this.Compression);
        buf.putInt((int)this.SizeOfBitmap);
        buf.putInt((int)this.HorzResolution);
        buf.putInt((int)this.VertResolution);
        buf.putInt((int)this.ColorsUsed);
        buf.putInt((int)this.ColorsImportant);
        int pixelCount = 0;
        for (int y = (int)(this.Height / 2L - 1L); y >= 0; --y) {
            int x = 0;
            while ((long)x < this.Width) {
                boolean isTransparent;
                int pix = this.image.getRGB(x, y);
                boolean bl = isTransparent = (pix >> 24 & 0xFF) == 0;
                if (isTransparent) {
                    int index = pixelCount / 8;
                    byte bitindex = (byte)(pixelCount % 8);
                    int n = index;
                    transparencyMask[n] = transparencyMask[n] | 128 >> bitindex;
                }
                buf.putInt(pix);
                ++pixelCount;
                ++x;
            }
            pixelCount += padding;
        }
        for (int x = 0; x < transparencyBytesSize; ++x) {
            buf.put((byte)(transparencyMask[x] & 0xFF));
        }
        buf.position(0);
        return buf;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Size: ").append(this.Size);
        out.append("\nWidth: ").append(this.Width);
        out.append("\nHeight: ").append(this.Height);
        out.append("\nPlanes: ").append(this.Planes);
        out.append("\nBitsPerPixel: ").append(this.BitsPerPixel);
        out.append("\nCompression: ").append(this.Compression);
        out.append("\nSizeOfBitmap: ").append(this.SizeOfBitmap);
        out.append("\nHorzResolution: ").append(this.HorzResolution);
        out.append("\nVertResolution: ").append(this.VertResolution);
        out.append("\nColorsUsed: ").append(this.ColorsUsed);
        out.append("\nColorsImportant: ").append(this.ColorsImportant);
        return out.toString();
    }
}

