/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.pe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import net.charabia.jsmoothgen.pe.PEHeader;
import net.charabia.jsmoothgen.pe.PEOldMSHeader;
import net.charabia.jsmoothgen.pe.PEResourceDirectory;
import net.charabia.jsmoothgen.pe.PESection;
import net.charabia.jsmoothgen.pe.res.ResIcon;
import net.charabia.jsmoothgen.pe.res.ResIconDir;

public class PEFile {
    private File m_file;
    private FileInputStream m_in = null;
    private FileChannel m_channel = null;
    private PEOldMSHeader m_oldmsheader;
    private PEHeader m_header;
    private Vector m_sections = new Vector();
    private PEResourceDirectory m_resourceDir;

    public PEFile(File f) {
        this.m_file = f;
    }

    public void close() throws IOException {
        this.m_in.close();
    }

    public void open() throws FileNotFoundException, IOException {
        this.m_in = new FileInputStream(this.m_file);
        this.m_channel = this.m_in.getChannel();
        this.m_oldmsheader = new PEOldMSHeader(this);
        this.m_oldmsheader.read();
        long headoffset = this.m_oldmsheader.e_lfanew;
        this.m_header = new PEHeader(this, headoffset);
        this.m_header.read();
        int seccount = this.m_header.NumberOfSections;
        long offset = headoffset + this.m_header.NumberOfRvaAndSizes * 8L + 24L + (long)this.getPeHeaderOffset();
        for (int i = 0; i < seccount; ++i) {
            PESection sect = new PESection(this, offset);
            sect.read();
            this.m_sections.add(sect);
            offset += 40L;
        }
        ByteBuffer resbuf = null;
        long resourceoffset = this.m_header.ResourceDirectory_VA;
        for (int i = 0; i < seccount; ++i) {
            PESection sect = (PESection)this.m_sections.get(i);
            if (sect.VirtualAddress != resourceoffset) continue;
            PEResourceDirectory prd = new PEResourceDirectory(this, sect);
            resbuf = prd.buildResource(sect.VirtualAddress);
            break;
        }
    }

    private int getPeHeaderOffset() {
        int pe32Offset = 96;
        if (this.m_header.isPe32Plus()) {
            pe32Offset = 112;
        }
        return pe32Offset;
    }

    public FileChannel getChannel() {
        return this.m_channel;
    }

    public static void main(String[] args) throws IOException, CloneNotSupportedException, Exception {
        PEFile pe = new PEFile(new File("c:/scratch/rc3.exe"));
        pe.open();
        System.out.println("OldMSHeader");
        pe.m_oldmsheader.dump(System.out);
        System.out.println("COFFHeader");
        pe.m_header.dump(System.out);
        PEResourceDirectory resdir = pe.getResourceDirectory();
        System.out.println("ResourceDirectory");
        resdir.dump(System.out);
        File out = new File("c:/scratch/COPIE.exe");
        pe.dumpTo(out);
    }

    public PEResourceDirectory getResourceDirectory() throws IOException {
        if (this.m_resourceDir != null) {
            return this.m_resourceDir;
        }
        long resourceoffset = this.m_header.ResourceDirectory_VA;
        for (int i = 0; i < this.m_sections.size(); ++i) {
            PESection sect = (PESection)this.m_sections.get(i);
            if (sect.VirtualAddress != resourceoffset) continue;
            this.m_resourceDir = new PEResourceDirectory(this, sect);
            return this.m_resourceDir;
        }
        return null;
    }

    public void dumpTo(File destination) throws IOException, CloneNotSupportedException {
        PESection sect;
        int i;
        int outputcount = 0;
        FileOutputStream fos = new FileOutputStream(destination);
        FileChannel out = fos.getChannel();
        PEOldMSHeader oldmsheader = (PEOldMSHeader)this.m_oldmsheader.clone();
        PEHeader peheader = (PEHeader)this.m_header.clone();
        Vector<PESection> sections = new Vector<PESection>();
        for (int i2 = 0; i2 < this.m_sections.size(); ++i2) {
            PESection sect2 = (PESection)this.m_sections.get(i2);
            PESection cs = (PESection)sect2.clone();
            sections.add(cs);
        }
        long newexeoffset = oldmsheader.e_lfanew;
        ByteBuffer msheadbuffer = oldmsheader.get();
        outputcount = out.write(msheadbuffer);
        this.m_channel.position(64L);
        out.transferFrom(this.m_channel, 64L, newexeoffset - 64L);
        ByteBuffer headbuffer = peheader.get();
        out.position(newexeoffset);
        outputcount = out.write(headbuffer);
        long offset = oldmsheader.e_lfanew + this.m_header.NumberOfRvaAndSizes * 8L + 24L + (long)this.getPeHeaderOffset();
        out.position(offset);
        for (int i3 = 0; i3 < sections.size(); ++i3) {
            PESection sect3 = (PESection)sections.get(i3);
            ByteBuffer buf = sect3.get();
            outputcount = out.write(buf);
        }
        offset = 1024L;
        long virtualAddress = offset;
        if (virtualAddress % peheader.SectionAlignment > 0L) {
            virtualAddress += peheader.SectionAlignment - virtualAddress % peheader.SectionAlignment;
        }
        long resourceoffset = this.m_header.ResourceDirectory_VA;
        for (i = 0; i < sections.size(); ++i) {
            long sectoffset;
            sect = (PESection)sections.get(i);
            if (resourceoffset == sect.VirtualAddress) {
                long virtualSize;
                out.position(offset);
                sectoffset = offset;
                PEResourceDirectory prd = this.getResourceDirectory();
                ByteBuffer resbuf = prd.buildResource(sect.VirtualAddress);
                resbuf.position(0);
                out.write(resbuf);
                long rem = (offset += (long)resbuf.capacity()) % this.m_header.FileAlignment;
                if (rem != 0L) {
                    offset += this.m_header.FileAlignment - rem;
                }
                if (out.size() + 1L < offset) {
                    ByteBuffer padder = ByteBuffer.allocate(1);
                    out.write(padder, offset - 1L);
                }
                if ((virtualSize = (long)resbuf.capacity()) % peheader.SectionAlignment > 0L) {
                    virtualSize += peheader.SectionAlignment - virtualSize % peheader.SectionAlignment;
                }
                sect.PointerToRawData = sectoffset;
                sect.SizeOfRawData = resbuf.capacity();
                if (sect.SizeOfRawData % this.m_header.FileAlignment > 0L) {
                    sect.SizeOfRawData += this.m_header.FileAlignment - sect.SizeOfRawData % this.m_header.FileAlignment;
                }
                sect.VirtualAddress = virtualAddress;
                sect.VirtualSize = virtualSize;
                virtualAddress += virtualSize;
                continue;
            }
            if (sect.PointerToRawData > 0L) {
                out.position(offset);
                this.m_channel.position(sect.PointerToRawData);
                sectoffset = offset;
                out.position(offset + sect.SizeOfRawData);
                ByteBuffer padder = ByteBuffer.allocate(1);
                out.write(padder, offset + sect.SizeOfRawData - 1L);
                long outted = out.transferFrom(this.m_channel, offset, sect.SizeOfRawData);
                long rem = (offset += sect.SizeOfRawData) % this.m_header.FileAlignment;
                if (rem != 0L) {
                    offset += this.m_header.FileAlignment - rem;
                }
                sect.PointerToRawData = sectoffset;
                sect.VirtualAddress = virtualAddress;
                if ((virtualAddress += sect.VirtualSize) % peheader.SectionAlignment <= 0L) continue;
                virtualAddress += peheader.SectionAlignment - virtualAddress % peheader.SectionAlignment;
                continue;
            }
            long virtualSize = sect.VirtualSize;
            if (virtualSize % peheader.SectionAlignment > 0L) {
                virtualSize += peheader.SectionAlignment - virtualSize % peheader.SectionAlignment;
            }
            sect.VirtualAddress = virtualAddress;
            virtualAddress += virtualSize;
        }
        peheader.updateVAAndSize(this.m_sections, sections);
        headbuffer = peheader.get();
        out.position(newexeoffset);
        outputcount = out.write(headbuffer);
        offset = oldmsheader.e_lfanew + this.m_header.NumberOfRvaAndSizes * 8L + 24L + (long)this.getPeHeaderOffset();
        out.position(offset);
        for (i = 0; i < sections.size(); ++i) {
            sect = (PESection)sections.get(i);
            ByteBuffer buf = sect.get();
            outputcount = out.write(buf);
        }
        fos.flush();
        fos.close();
    }

    public void replaceDefaultIcon(ResIcon icon) throws Exception {
        PEResourceDirectory resdir = this.getResourceDirectory();
        PEResourceDirectory.DataEntry entry = resdir.getData("#14", null, null);
        if (entry == null) {
            throw new Exception("Can't find any icon group in the file!");
        }
        entry.Data.position(0);
        entry.Data.position(0);
        ResIconDir rid = new ResIconDir(entry.Data);
        int iconid = rid.getEntries()[0].dwImageOffset;
        PEResourceDirectory.DataEntry iconentry = resdir.getData("#3", "#" + iconid, null);
        iconentry.Data.position(0);
        rid.getEntries()[0].bWidth = (short)icon.Width;
        rid.getEntries()[0].bHeight = (short)(icon.Height / 2L);
        rid.getEntries()[0].bColorCount = (short)(1 << icon.BitsPerPixel);
        rid.getEntries()[0].wBitCount = icon.BitsPerPixel;
        rid.getEntries()[0].dwBytesInRes = icon.getData().remaining();
        iconentry.Data = icon.getData();
        iconentry.Size = iconentry.Data.remaining();
        entry.setData(rid.getData());
    }
}

